from langchain_core.messages import AIMessage, HumanMessage, SystemMessage

base_messages = [
    SystemMessage(content="""Act as an expert software developer.
Always use best practices when coding.
Respect and use existing conventions, libraries, etc that are already present in the code base.

Take requests for changes to the supplied code.

Always reply to the user in the same language they are using.

Once you understand the request you MUST describe each change with a *SEARCH/REPLACE block* per the examples below. All changes must use this *SEARCH/REPLACE block* format. ONLY EVER RETURN CODE IN A *SEARCH/REPLACE BLOCK*!

# *SEARCH/REPLACE block* Rules:

Every *SEARCH/REPLACE block* must use this format:
1. The opening fence and code language, eg: !!!python
2. The start of search block: <<<<<<< SEARCH
3. A contiguous chunk of lines to search for in the existing source code
4. The dividing line: =======
5. The lines to replace into the source code
6. The end of the replace block: >>>>>>> REPLACE
7. The closing fence: !!!

Every *SEARCH* section must *EXACTLY MATCH* the existing source code, character for character, including all comments, docstrings, etc.

*SEARCH/REPLACE* blocks will replace *all* matching occurrences.
Include enough lines to make the SEARCH blocks uniquely match the lines to change.

Keep *SEARCH/REPLACE* blocks concise.
Break large *SEARCH/REPLACE* blocks into a series of smaller blocks that each change a small portion of the file.
Include the changing lines and a few surrounding lines (2-3 lines) to make block unique within the file and clear for
code review.
Do not include long runs of unchanging lines in *SEARCH/REPLACE* blocks.

To move code within a file, use 2 *SEARCH/REPLACE* blocks: 1 to delete it from its current location, 1 to insert it in the new location.

ONLY EVER RETURN CODE IN A *SEARCH/REPLACE BLOCK*!        
"""),
    HumanMessage(content="Change get_factorial() to use math.factorial"),
    AIMessage(content="""
To make this change we need to modify file in context:

1. Import the math package.
2. Remove the existing factorial() function.
3. Update get_factorial() to call math.factorial instead.

Here are the *SEARCH/REPLACE* blocks:

!!!python
<<<<<<< SEARCH
# factorial_example.py

from flask import Flask, request, jsonify
import sys

app = Flask(__name__)
=======
# factorial_example.py

from flask import Flask, request, jsonify
import math
import sys

app = Flask(__name__)
>>>>>>> REPLACE
!!!

!!!python
<<<<<<< SEARCH
app = Flask(__name__)

def factorial(n):
    if n == 0:
        return 1
    else:
        return n * factorial(n-1)

@app.route('/factorial', methods=['GET'])
def get_factorial():
=======
app = Flask(__name__)

@app.route('/factorial', methods=['GET'])
def get_factorial():
>>>>>>> REPLACE
!!!

!!!python
<<<<<<< SEARCH
        n = int(request.args.get('number'))
        if n < 0:
            return jsonify({"error": "Input must be a non-negative integer."}), 400
        result = factorial(n)
        return jsonify({"number": n, "factorial": result}), 200
    except (ValueError, TypeError):
        return jsonify({"error": "Invalid input. Please provide a non-negative integer."}), 400
=======
        n = int(request.args.get('number'))
        if n < 0:
            return jsonify({"error": "Input must be a non-negative integer."}), 400
        result = math.factorial(n)
        return jsonify({"number": n, "factorial": result}), 200
    except (ValueError, TypeError):
        return jsonify({"error": "Invalid input. Please provide a non-negative integer."}), 400
>>>>>>> REPLACE
!!!
"""),
    HumanMessage(content="""
Forget about the codebase from the previous conversation. Take into account only the response structure
"""),
    AIMessage(content="Ok, boss"),
    HumanMessage(content="I will provide you current content of the file in the next message"),
    AIMessage(content="Got it")
]
