# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatabaseMysqlArgs', 'DatabaseMysql']

@pulumi.input_type
class DatabaseMysqlArgs:
    def __init__(__self__, *,
                 engine_id: pulumi.Input[builtins.str],
                 label: pulumi.Input[builtins.str],
                 region: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str],
                 allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 cluster_size: Optional[pulumi.Input[builtins.int]] = None,
                 encrypted: Optional[pulumi.Input[builtins.bool]] = None,
                 replication_type: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_connection: Optional[pulumi.Input[builtins.bool]] = None,
                 updates: Optional[pulumi.Input['DatabaseMysqlUpdatesArgs']] = None):
        """
        The set of arguments for constructing a DatabaseMysql resource.
        :param pulumi.Input[builtins.str] engine_id: The Managed Database engine in engine/version format. (e.g. `mysql/8.0.30`)
        :param pulumi.Input[builtins.str] label: A unique, user-defined string referring to the Managed Database.
        :param pulumi.Input[builtins.str] region: The region to use for the Managed Database.
        :param pulumi.Input[builtins.str] type: The Linode Instance type used for the nodes of the  Managed Database instance.
               
               - - -
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allow_lists: A list of IP addresses that can access the Managed Database. Each item can be a single IP address or a range in CIDR format. Use `DatabaseAccessControls` to manage your allow list separately.
        :param pulumi.Input[builtins.int] cluster_size: The number of Linode Instance nodes deployed to the Managed Database. (default `1`)
        :param pulumi.Input[builtins.bool] encrypted: Whether the Managed Databases is encrypted. (default `false`)
        :param pulumi.Input[builtins.str] replication_type: The replication method used for the Managed Database. (`none`, `asynch`, `semi_synch`; default `none`)
               
               * Must be `none` for a single node cluster.
               
               * Must be `asynch` or `semi_synch` for a high availability cluster.
        :param pulumi.Input[builtins.bool] ssl_connection: Whether to require SSL credentials to establish a connection to the Managed Database. (default `false`)
               
               * `updates` - (Optional) Configuration settings for automated patch update maintenance for the Managed Database.
        :param pulumi.Input['DatabaseMysqlUpdatesArgs'] updates: Configuration settings for automated patch update maintenance for the Managed Database.
        """
        pulumi.set(__self__, "engine_id", engine_id)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "type", type)
        if allow_lists is not None:
            pulumi.set(__self__, "allow_lists", allow_lists)
        if cluster_size is not None:
            pulumi.set(__self__, "cluster_size", cluster_size)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if replication_type is not None:
            pulumi.set(__self__, "replication_type", replication_type)
        if ssl_connection is not None:
            pulumi.set(__self__, "ssl_connection", ssl_connection)
        if updates is not None:
            pulumi.set(__self__, "updates", updates)

    @property
    @pulumi.getter(name="engineId")
    def engine_id(self) -> pulumi.Input[builtins.str]:
        """
        The Managed Database engine in engine/version format. (e.g. `mysql/8.0.30`)
        """
        return pulumi.get(self, "engine_id")

    @engine_id.setter
    def engine_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "engine_id", value)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[builtins.str]:
        """
        A unique, user-defined string referring to the Managed Database.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[builtins.str]:
        """
        The region to use for the Managed Database.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The Linode Instance type used for the nodes of the  Managed Database instance.

        - - -
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="allowLists")
    def allow_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of IP addresses that can access the Managed Database. Each item can be a single IP address or a range in CIDR format. Use `DatabaseAccessControls` to manage your allow list separately.
        """
        return pulumi.get(self, "allow_lists")

    @allow_lists.setter
    def allow_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "allow_lists", value)

    @property
    @pulumi.getter(name="clusterSize")
    def cluster_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of Linode Instance nodes deployed to the Managed Database. (default `1`)
        """
        return pulumi.get(self, "cluster_size")

    @cluster_size.setter
    def cluster_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "cluster_size", value)

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the Managed Databases is encrypted. (default `false`)
        """
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "encrypted", value)

    @property
    @pulumi.getter(name="replicationType")
    def replication_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The replication method used for the Managed Database. (`none`, `asynch`, `semi_synch`; default `none`)

        * Must be `none` for a single node cluster.

        * Must be `asynch` or `semi_synch` for a high availability cluster.
        """
        return pulumi.get(self, "replication_type")

    @replication_type.setter
    def replication_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "replication_type", value)

    @property
    @pulumi.getter(name="sslConnection")
    def ssl_connection(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to require SSL credentials to establish a connection to the Managed Database. (default `false`)

        * `updates` - (Optional) Configuration settings for automated patch update maintenance for the Managed Database.
        """
        return pulumi.get(self, "ssl_connection")

    @ssl_connection.setter
    def ssl_connection(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ssl_connection", value)

    @property
    @pulumi.getter
    def updates(self) -> Optional[pulumi.Input['DatabaseMysqlUpdatesArgs']]:
        """
        Configuration settings for automated patch update maintenance for the Managed Database.
        """
        return pulumi.get(self, "updates")

    @updates.setter
    def updates(self, value: Optional[pulumi.Input['DatabaseMysqlUpdatesArgs']]):
        pulumi.set(self, "updates", value)


@pulumi.input_type
class _DatabaseMysqlState:
    def __init__(__self__, *,
                 allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ca_cert: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_size: Optional[pulumi.Input[builtins.int]] = None,
                 created: Optional[pulumi.Input[builtins.str]] = None,
                 encrypted: Optional[pulumi.Input[builtins.bool]] = None,
                 engine: Optional[pulumi.Input[builtins.str]] = None,
                 engine_id: Optional[pulumi.Input[builtins.str]] = None,
                 host_primary: Optional[pulumi.Input[builtins.str]] = None,
                 host_secondary: Optional[pulumi.Input[builtins.str]] = None,
                 label: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 replication_type: Optional[pulumi.Input[builtins.str]] = None,
                 root_password: Optional[pulumi.Input[builtins.str]] = None,
                 root_username: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_connection: Optional[pulumi.Input[builtins.bool]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 updated: Optional[pulumi.Input[builtins.str]] = None,
                 updates: Optional[pulumi.Input['DatabaseMysqlUpdatesArgs']] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering DatabaseMysql resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allow_lists: A list of IP addresses that can access the Managed Database. Each item can be a single IP address or a range in CIDR format. Use `DatabaseAccessControls` to manage your allow list separately.
        :param pulumi.Input[builtins.str] ca_cert: The base64-encoded SSL CA certificate for the Managed Database instance.
        :param pulumi.Input[builtins.int] cluster_size: The number of Linode Instance nodes deployed to the Managed Database. (default `1`)
        :param pulumi.Input[builtins.str] created: When this Managed Database was created.
        :param pulumi.Input[builtins.bool] encrypted: Whether the Managed Databases is encrypted. (default `false`)
        :param pulumi.Input[builtins.str] engine: The Managed Database engine. (e.g. `mysql`)
        :param pulumi.Input[builtins.str] engine_id: The Managed Database engine in engine/version format. (e.g. `mysql/8.0.30`)
        :param pulumi.Input[builtins.str] host_primary: The primary host for the Managed Database.
        :param pulumi.Input[builtins.str] host_secondary: The secondary/private network host for the Managed Database.
        :param pulumi.Input[builtins.str] label: A unique, user-defined string referring to the Managed Database.
        :param pulumi.Input[builtins.str] region: The region to use for the Managed Database.
        :param pulumi.Input[builtins.str] replication_type: The replication method used for the Managed Database. (`none`, `asynch`, `semi_synch`; default `none`)
               
               * Must be `none` for a single node cluster.
               
               * Must be `asynch` or `semi_synch` for a high availability cluster.
        :param pulumi.Input[builtins.str] root_password: The randomly-generated root password for the Managed Database instance.
        :param pulumi.Input[builtins.str] root_username: The root username for the Managed Database instance.
        :param pulumi.Input[builtins.bool] ssl_connection: Whether to require SSL credentials to establish a connection to the Managed Database. (default `false`)
               
               * `updates` - (Optional) Configuration settings for automated patch update maintenance for the Managed Database.
        :param pulumi.Input[builtins.str] status: The operating status of the Managed Database.
        :param pulumi.Input[builtins.str] type: The Linode Instance type used for the nodes of the  Managed Database instance.
               
               - - -
        :param pulumi.Input[builtins.str] updated: When this Managed Database was last updated.
        :param pulumi.Input['DatabaseMysqlUpdatesArgs'] updates: Configuration settings for automated patch update maintenance for the Managed Database.
        :param pulumi.Input[builtins.str] version: The Managed Database engine version. (e.g. `v8.0.26`)
        """
        if allow_lists is not None:
            pulumi.set(__self__, "allow_lists", allow_lists)
        if ca_cert is not None:
            pulumi.set(__self__, "ca_cert", ca_cert)
        if cluster_size is not None:
            pulumi.set(__self__, "cluster_size", cluster_size)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_id is not None:
            pulumi.set(__self__, "engine_id", engine_id)
        if host_primary is not None:
            pulumi.set(__self__, "host_primary", host_primary)
        if host_secondary is not None:
            pulumi.set(__self__, "host_secondary", host_secondary)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replication_type is not None:
            pulumi.set(__self__, "replication_type", replication_type)
        if root_password is not None:
            pulumi.set(__self__, "root_password", root_password)
        if root_username is not None:
            pulumi.set(__self__, "root_username", root_username)
        if ssl_connection is not None:
            pulumi.set(__self__, "ssl_connection", ssl_connection)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if updated is not None:
            pulumi.set(__self__, "updated", updated)
        if updates is not None:
            pulumi.set(__self__, "updates", updates)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="allowLists")
    def allow_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of IP addresses that can access the Managed Database. Each item can be a single IP address or a range in CIDR format. Use `DatabaseAccessControls` to manage your allow list separately.
        """
        return pulumi.get(self, "allow_lists")

    @allow_lists.setter
    def allow_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "allow_lists", value)

    @property
    @pulumi.getter(name="caCert")
    def ca_cert(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The base64-encoded SSL CA certificate for the Managed Database instance.
        """
        return pulumi.get(self, "ca_cert")

    @ca_cert.setter
    def ca_cert(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ca_cert", value)

    @property
    @pulumi.getter(name="clusterSize")
    def cluster_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of Linode Instance nodes deployed to the Managed Database. (default `1`)
        """
        return pulumi.get(self, "cluster_size")

    @cluster_size.setter
    def cluster_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "cluster_size", value)

    @property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        When this Managed Database was created.
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created", value)

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the Managed Databases is encrypted. (default `false`)
        """
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "encrypted", value)

    @property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Managed Database engine. (e.g. `mysql`)
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="engineId")
    def engine_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Managed Database engine in engine/version format. (e.g. `mysql/8.0.30`)
        """
        return pulumi.get(self, "engine_id")

    @engine_id.setter
    def engine_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "engine_id", value)

    @property
    @pulumi.getter(name="hostPrimary")
    def host_primary(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The primary host for the Managed Database.
        """
        return pulumi.get(self, "host_primary")

    @host_primary.setter
    def host_primary(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host_primary", value)

    @property
    @pulumi.getter(name="hostSecondary")
    def host_secondary(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The secondary/private network host for the Managed Database.
        """
        return pulumi.get(self, "host_secondary")

    @host_secondary.setter
    def host_secondary(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host_secondary", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique, user-defined string referring to the Managed Database.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region to use for the Managed Database.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="replicationType")
    def replication_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The replication method used for the Managed Database. (`none`, `asynch`, `semi_synch`; default `none`)

        * Must be `none` for a single node cluster.

        * Must be `asynch` or `semi_synch` for a high availability cluster.
        """
        return pulumi.get(self, "replication_type")

    @replication_type.setter
    def replication_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "replication_type", value)

    @property
    @pulumi.getter(name="rootPassword")
    def root_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The randomly-generated root password for the Managed Database instance.
        """
        return pulumi.get(self, "root_password")

    @root_password.setter
    def root_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "root_password", value)

    @property
    @pulumi.getter(name="rootUsername")
    def root_username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The root username for the Managed Database instance.
        """
        return pulumi.get(self, "root_username")

    @root_username.setter
    def root_username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "root_username", value)

    @property
    @pulumi.getter(name="sslConnection")
    def ssl_connection(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to require SSL credentials to establish a connection to the Managed Database. (default `false`)

        * `updates` - (Optional) Configuration settings for automated patch update maintenance for the Managed Database.
        """
        return pulumi.get(self, "ssl_connection")

    @ssl_connection.setter
    def ssl_connection(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ssl_connection", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The operating status of the Managed Database.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Linode Instance type used for the nodes of the  Managed Database instance.

        - - -
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        When this Managed Database was last updated.
        """
        return pulumi.get(self, "updated")

    @updated.setter
    def updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated", value)

    @property
    @pulumi.getter
    def updates(self) -> Optional[pulumi.Input['DatabaseMysqlUpdatesArgs']]:
        """
        Configuration settings for automated patch update maintenance for the Managed Database.
        """
        return pulumi.get(self, "updates")

    @updates.setter
    def updates(self, value: Optional[pulumi.Input['DatabaseMysqlUpdatesArgs']]):
        pulumi.set(self, "updates", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Managed Database engine version. (e.g. `v8.0.26`)
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("linode:index/databaseMysql:DatabaseMysql")
class DatabaseMysql(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 cluster_size: Optional[pulumi.Input[builtins.int]] = None,
                 encrypted: Optional[pulumi.Input[builtins.bool]] = None,
                 engine_id: Optional[pulumi.Input[builtins.str]] = None,
                 label: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 replication_type: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_connection: Optional[pulumi.Input[builtins.bool]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 updates: Optional[pulumi.Input[Union['DatabaseMysqlUpdatesArgs', 'DatabaseMysqlUpdatesArgsDict']]] = None,
                 __props__=None):
        """
        > **DEPRECATION NOTICE:** This resource has been deprecated. Please use DatabaseMysqlV2 for all future implementations.

        Provides a Linode MySQL Database resource. This can be used to create, modify, and delete Linode MySQL Databases.
        For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-databases-instances).

        Please keep in mind that Managed Databases can take up to an hour to provision.

        ## Example Usage

        Creating a simple MySQL database instance:

        ```python
        import pulumi
        import pulumi_linode as linode

        foobar = linode.DatabaseMysql("foobar",
            label="mydatabase",
            engine_id="mysql/8.0.30",
            region="us-southeast",
            type="g6-nanode-1")
        ```

        Creating a complex MySQL database instance:

        ```python
        import pulumi
        import pulumi_linode as linode

        foobar = linode.DatabaseMysql("foobar",
            label="mydatabase",
            engine_id="mysql/8.0.30",
            region="us-southeast",
            type="g6-nanode-1",
            allow_lists=["0.0.0.0/0"],
            cluster_size=3,
            encrypted=True,
            replication_type="asynch",
            ssl_connection=True,
            updates={
                "day_of_week": "saturday",
                "duration": 1,
                "frequency": "monthly",
                "hour_of_day": 22,
                "week_of_month": 2,
            })
        ```

        ## updates

        The following arguments are supported in the `updates` specification block:

        * `day_of_week` - (Required) The day to perform maintenance. (`monday`, `tuesday`, ...)

        * `duration` - (Required) The maximum maintenance window time in hours. (`1`..`3`)

        * `frequency` - (Required) Whether maintenance occurs on a weekly or monthly basis. (`weekly`, `monthly`)

        * `hour_of_day` - (Required) The hour to begin maintenance based in UTC time. (`0`..`23`)

        * `week_of_month` - (Optional) The week of the month to perform monthly frequency updates. Required for `monthly` frequency updates. (`1`..`4`)

        ## Import

        Linode MySQL Databases can be imported using the `id`, e.g.

        ```sh
        $ pulumi import linode:index/databaseMysql:DatabaseMysql foobar 1234567
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allow_lists: A list of IP addresses that can access the Managed Database. Each item can be a single IP address or a range in CIDR format. Use `DatabaseAccessControls` to manage your allow list separately.
        :param pulumi.Input[builtins.int] cluster_size: The number of Linode Instance nodes deployed to the Managed Database. (default `1`)
        :param pulumi.Input[builtins.bool] encrypted: Whether the Managed Databases is encrypted. (default `false`)
        :param pulumi.Input[builtins.str] engine_id: The Managed Database engine in engine/version format. (e.g. `mysql/8.0.30`)
        :param pulumi.Input[builtins.str] label: A unique, user-defined string referring to the Managed Database.
        :param pulumi.Input[builtins.str] region: The region to use for the Managed Database.
        :param pulumi.Input[builtins.str] replication_type: The replication method used for the Managed Database. (`none`, `asynch`, `semi_synch`; default `none`)
               
               * Must be `none` for a single node cluster.
               
               * Must be `asynch` or `semi_synch` for a high availability cluster.
        :param pulumi.Input[builtins.bool] ssl_connection: Whether to require SSL credentials to establish a connection to the Managed Database. (default `false`)
               
               * `updates` - (Optional) Configuration settings for automated patch update maintenance for the Managed Database.
        :param pulumi.Input[builtins.str] type: The Linode Instance type used for the nodes of the  Managed Database instance.
               
               - - -
        :param pulumi.Input[Union['DatabaseMysqlUpdatesArgs', 'DatabaseMysqlUpdatesArgsDict']] updates: Configuration settings for automated patch update maintenance for the Managed Database.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseMysqlArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > **DEPRECATION NOTICE:** This resource has been deprecated. Please use DatabaseMysqlV2 for all future implementations.

        Provides a Linode MySQL Database resource. This can be used to create, modify, and delete Linode MySQL Databases.
        For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-databases-instances).

        Please keep in mind that Managed Databases can take up to an hour to provision.

        ## Example Usage

        Creating a simple MySQL database instance:

        ```python
        import pulumi
        import pulumi_linode as linode

        foobar = linode.DatabaseMysql("foobar",
            label="mydatabase",
            engine_id="mysql/8.0.30",
            region="us-southeast",
            type="g6-nanode-1")
        ```

        Creating a complex MySQL database instance:

        ```python
        import pulumi
        import pulumi_linode as linode

        foobar = linode.DatabaseMysql("foobar",
            label="mydatabase",
            engine_id="mysql/8.0.30",
            region="us-southeast",
            type="g6-nanode-1",
            allow_lists=["0.0.0.0/0"],
            cluster_size=3,
            encrypted=True,
            replication_type="asynch",
            ssl_connection=True,
            updates={
                "day_of_week": "saturday",
                "duration": 1,
                "frequency": "monthly",
                "hour_of_day": 22,
                "week_of_month": 2,
            })
        ```

        ## updates

        The following arguments are supported in the `updates` specification block:

        * `day_of_week` - (Required) The day to perform maintenance. (`monday`, `tuesday`, ...)

        * `duration` - (Required) The maximum maintenance window time in hours. (`1`..`3`)

        * `frequency` - (Required) Whether maintenance occurs on a weekly or monthly basis. (`weekly`, `monthly`)

        * `hour_of_day` - (Required) The hour to begin maintenance based in UTC time. (`0`..`23`)

        * `week_of_month` - (Optional) The week of the month to perform monthly frequency updates. Required for `monthly` frequency updates. (`1`..`4`)

        ## Import

        Linode MySQL Databases can be imported using the `id`, e.g.

        ```sh
        $ pulumi import linode:index/databaseMysql:DatabaseMysql foobar 1234567
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseMysqlArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseMysqlArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 cluster_size: Optional[pulumi.Input[builtins.int]] = None,
                 encrypted: Optional[pulumi.Input[builtins.bool]] = None,
                 engine_id: Optional[pulumi.Input[builtins.str]] = None,
                 label: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 replication_type: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_connection: Optional[pulumi.Input[builtins.bool]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 updates: Optional[pulumi.Input[Union['DatabaseMysqlUpdatesArgs', 'DatabaseMysqlUpdatesArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseMysqlArgs.__new__(DatabaseMysqlArgs)

            __props__.__dict__["allow_lists"] = allow_lists
            __props__.__dict__["cluster_size"] = cluster_size
            __props__.__dict__["encrypted"] = encrypted
            if engine_id is None and not opts.urn:
                raise TypeError("Missing required property 'engine_id'")
            __props__.__dict__["engine_id"] = engine_id
            if label is None and not opts.urn:
                raise TypeError("Missing required property 'label'")
            __props__.__dict__["label"] = label
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["replication_type"] = replication_type
            __props__.__dict__["ssl_connection"] = ssl_connection
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["updates"] = updates
            __props__.__dict__["ca_cert"] = None
            __props__.__dict__["created"] = None
            __props__.__dict__["engine"] = None
            __props__.__dict__["host_primary"] = None
            __props__.__dict__["host_secondary"] = None
            __props__.__dict__["root_password"] = None
            __props__.__dict__["root_username"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated"] = None
            __props__.__dict__["version"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["caCert", "rootPassword", "rootUsername"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(DatabaseMysql, __self__).__init__(
            'linode:index/databaseMysql:DatabaseMysql',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            ca_cert: Optional[pulumi.Input[builtins.str]] = None,
            cluster_size: Optional[pulumi.Input[builtins.int]] = None,
            created: Optional[pulumi.Input[builtins.str]] = None,
            encrypted: Optional[pulumi.Input[builtins.bool]] = None,
            engine: Optional[pulumi.Input[builtins.str]] = None,
            engine_id: Optional[pulumi.Input[builtins.str]] = None,
            host_primary: Optional[pulumi.Input[builtins.str]] = None,
            host_secondary: Optional[pulumi.Input[builtins.str]] = None,
            label: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            replication_type: Optional[pulumi.Input[builtins.str]] = None,
            root_password: Optional[pulumi.Input[builtins.str]] = None,
            root_username: Optional[pulumi.Input[builtins.str]] = None,
            ssl_connection: Optional[pulumi.Input[builtins.bool]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            updated: Optional[pulumi.Input[builtins.str]] = None,
            updates: Optional[pulumi.Input[Union['DatabaseMysqlUpdatesArgs', 'DatabaseMysqlUpdatesArgsDict']]] = None,
            version: Optional[pulumi.Input[builtins.str]] = None) -> 'DatabaseMysql':
        """
        Get an existing DatabaseMysql resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allow_lists: A list of IP addresses that can access the Managed Database. Each item can be a single IP address or a range in CIDR format. Use `DatabaseAccessControls` to manage your allow list separately.
        :param pulumi.Input[builtins.str] ca_cert: The base64-encoded SSL CA certificate for the Managed Database instance.
        :param pulumi.Input[builtins.int] cluster_size: The number of Linode Instance nodes deployed to the Managed Database. (default `1`)
        :param pulumi.Input[builtins.str] created: When this Managed Database was created.
        :param pulumi.Input[builtins.bool] encrypted: Whether the Managed Databases is encrypted. (default `false`)
        :param pulumi.Input[builtins.str] engine: The Managed Database engine. (e.g. `mysql`)
        :param pulumi.Input[builtins.str] engine_id: The Managed Database engine in engine/version format. (e.g. `mysql/8.0.30`)
        :param pulumi.Input[builtins.str] host_primary: The primary host for the Managed Database.
        :param pulumi.Input[builtins.str] host_secondary: The secondary/private network host for the Managed Database.
        :param pulumi.Input[builtins.str] label: A unique, user-defined string referring to the Managed Database.
        :param pulumi.Input[builtins.str] region: The region to use for the Managed Database.
        :param pulumi.Input[builtins.str] replication_type: The replication method used for the Managed Database. (`none`, `asynch`, `semi_synch`; default `none`)
               
               * Must be `none` for a single node cluster.
               
               * Must be `asynch` or `semi_synch` for a high availability cluster.
        :param pulumi.Input[builtins.str] root_password: The randomly-generated root password for the Managed Database instance.
        :param pulumi.Input[builtins.str] root_username: The root username for the Managed Database instance.
        :param pulumi.Input[builtins.bool] ssl_connection: Whether to require SSL credentials to establish a connection to the Managed Database. (default `false`)
               
               * `updates` - (Optional) Configuration settings for automated patch update maintenance for the Managed Database.
        :param pulumi.Input[builtins.str] status: The operating status of the Managed Database.
        :param pulumi.Input[builtins.str] type: The Linode Instance type used for the nodes of the  Managed Database instance.
               
               - - -
        :param pulumi.Input[builtins.str] updated: When this Managed Database was last updated.
        :param pulumi.Input[Union['DatabaseMysqlUpdatesArgs', 'DatabaseMysqlUpdatesArgsDict']] updates: Configuration settings for automated patch update maintenance for the Managed Database.
        :param pulumi.Input[builtins.str] version: The Managed Database engine version. (e.g. `v8.0.26`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseMysqlState.__new__(_DatabaseMysqlState)

        __props__.__dict__["allow_lists"] = allow_lists
        __props__.__dict__["ca_cert"] = ca_cert
        __props__.__dict__["cluster_size"] = cluster_size
        __props__.__dict__["created"] = created
        __props__.__dict__["encrypted"] = encrypted
        __props__.__dict__["engine"] = engine
        __props__.__dict__["engine_id"] = engine_id
        __props__.__dict__["host_primary"] = host_primary
        __props__.__dict__["host_secondary"] = host_secondary
        __props__.__dict__["label"] = label
        __props__.__dict__["region"] = region
        __props__.__dict__["replication_type"] = replication_type
        __props__.__dict__["root_password"] = root_password
        __props__.__dict__["root_username"] = root_username
        __props__.__dict__["ssl_connection"] = ssl_connection
        __props__.__dict__["status"] = status
        __props__.__dict__["type"] = type
        __props__.__dict__["updated"] = updated
        __props__.__dict__["updates"] = updates
        __props__.__dict__["version"] = version
        return DatabaseMysql(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowLists")
    def allow_lists(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of IP addresses that can access the Managed Database. Each item can be a single IP address or a range in CIDR format. Use `DatabaseAccessControls` to manage your allow list separately.
        """
        return pulumi.get(self, "allow_lists")

    @property
    @pulumi.getter(name="caCert")
    def ca_cert(self) -> pulumi.Output[builtins.str]:
        """
        The base64-encoded SSL CA certificate for the Managed Database instance.
        """
        return pulumi.get(self, "ca_cert")

    @property
    @pulumi.getter(name="clusterSize")
    def cluster_size(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of Linode Instance nodes deployed to the Managed Database. (default `1`)
        """
        return pulumi.get(self, "cluster_size")

    @property
    @pulumi.getter
    def created(self) -> pulumi.Output[builtins.str]:
        """
        When this Managed Database was created.
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter
    def encrypted(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether the Managed Databases is encrypted. (default `false`)
        """
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Output[builtins.str]:
        """
        The Managed Database engine. (e.g. `mysql`)
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="engineId")
    def engine_id(self) -> pulumi.Output[builtins.str]:
        """
        The Managed Database engine in engine/version format. (e.g. `mysql/8.0.30`)
        """
        return pulumi.get(self, "engine_id")

    @property
    @pulumi.getter(name="hostPrimary")
    def host_primary(self) -> pulumi.Output[builtins.str]:
        """
        The primary host for the Managed Database.
        """
        return pulumi.get(self, "host_primary")

    @property
    @pulumi.getter(name="hostSecondary")
    def host_secondary(self) -> pulumi.Output[builtins.str]:
        """
        The secondary/private network host for the Managed Database.
        """
        return pulumi.get(self, "host_secondary")

    @property
    @pulumi.getter
    def label(self) -> pulumi.Output[builtins.str]:
        """
        A unique, user-defined string referring to the Managed Database.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        The region to use for the Managed Database.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="replicationType")
    def replication_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The replication method used for the Managed Database. (`none`, `asynch`, `semi_synch`; default `none`)

        * Must be `none` for a single node cluster.

        * Must be `asynch` or `semi_synch` for a high availability cluster.
        """
        return pulumi.get(self, "replication_type")

    @property
    @pulumi.getter(name="rootPassword")
    def root_password(self) -> pulumi.Output[builtins.str]:
        """
        The randomly-generated root password for the Managed Database instance.
        """
        return pulumi.get(self, "root_password")

    @property
    @pulumi.getter(name="rootUsername")
    def root_username(self) -> pulumi.Output[builtins.str]:
        """
        The root username for the Managed Database instance.
        """
        return pulumi.get(self, "root_username")

    @property
    @pulumi.getter(name="sslConnection")
    def ssl_connection(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to require SSL credentials to establish a connection to the Managed Database. (default `false`)

        * `updates` - (Optional) Configuration settings for automated patch update maintenance for the Managed Database.
        """
        return pulumi.get(self, "ssl_connection")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        The operating status of the Managed Database.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        The Linode Instance type used for the nodes of the  Managed Database instance.

        - - -
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def updated(self) -> pulumi.Output[builtins.str]:
        """
        When this Managed Database was last updated.
        """
        return pulumi.get(self, "updated")

    @property
    @pulumi.getter
    def updates(self) -> pulumi.Output['outputs.DatabaseMysqlUpdates']:
        """
        Configuration settings for automated patch update maintenance for the Managed Database.
        """
        return pulumi.get(self, "updates")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.str]:
        """
        The Managed Database engine version. (e.g. `v8.0.26`)
        """
        return pulumi.get(self, "version")

