# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['DomainArgs', 'Domain']

@pulumi.input_type
class DomainArgs:
    def __init__(__self__, *,
                 domain: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str],
                 axfr_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 expire_sec: Optional[pulumi.Input[builtins.int]] = None,
                 group: Optional[pulumi.Input[builtins.str]] = None,
                 master_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 refresh_sec: Optional[pulumi.Input[builtins.int]] = None,
                 retry_sec: Optional[pulumi.Input[builtins.int]] = None,
                 soa_email: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ttl_sec: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a Domain resource.
        :param pulumi.Input[builtins.str] domain: The domain this Domain represents. These must be unique in our system; you cannot have two Domains representing the same domain.
        :param pulumi.Input[builtins.str] type: If this Domain represents the authoritative source of information for the domain it describes, or if it is a read-only copy of a master (also called a slave).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] axfr_ips: The list of IPs that may perform a zone transfer for this Domain. This is potentially dangerous, and should be set to an empty list unless you intend to use it.
        :param pulumi.Input[builtins.str] description: A description for this Domain. This is for display purposes only.
        :param pulumi.Input[builtins.int] expire_sec: The amount of time in seconds that may pass before this Domain is no longer authoritative. Valid values are 0, 30, 120, 300, 3600, 7200, 14400, 28800, 57600, 86400, 172800, 345600, 604800, 1209600, and 2419200 - any other value will be rounded to the nearest valid value.
        :param pulumi.Input[builtins.str] group: The group this Domain belongs to. This is for display purposes only.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] master_ips: The IP addresses representing the master DNS for this Domain.
               
               - - -
        :param pulumi.Input[builtins.int] refresh_sec: The amount of time in seconds before this Domain should be refreshed. Valid values are 0, 30, 120, 300, 3600, 7200, 14400, 28800, 57600, 86400, 172800, 345600, 604800, 1209600, and 2419200 - any other value will be rounded to the nearest valid value.
        :param pulumi.Input[builtins.int] retry_sec: The interval, in seconds, at which a failed refresh should be retried. Valid values are 0, 30, 120, 300, 3600, 7200, 14400, 28800, 57600, 86400, 172800, 345600, 604800, 1209600, and 2419200 - any other value will be rounded to the nearest valid value.
        :param pulumi.Input[builtins.str] soa_email: Start of Authority email address. This is required for master Domains.
        :param pulumi.Input[builtins.str] status: Used to control whether this Domain is currently being rendered (defaults to "active").
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of tags applied to this object. Tags are case-insensitive and are for organizational purposes only.
        :param pulumi.Input[builtins.int] ttl_sec: 'Time to Live' - the amount of time in seconds that this Domain's records may be cached by resolvers or other domain servers. Valid values are 0, 30, 120, 300, 3600, 7200, 14400, 28800, 57600, 86400, 172800, 345600, 604800, 1209600, and 2419200 - any other value will be rounded to the nearest valid value.
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "type", type)
        if axfr_ips is not None:
            pulumi.set(__self__, "axfr_ips", axfr_ips)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expire_sec is not None:
            pulumi.set(__self__, "expire_sec", expire_sec)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if master_ips is not None:
            pulumi.set(__self__, "master_ips", master_ips)
        if refresh_sec is not None:
            pulumi.set(__self__, "refresh_sec", refresh_sec)
        if retry_sec is not None:
            pulumi.set(__self__, "retry_sec", retry_sec)
        if soa_email is not None:
            pulumi.set(__self__, "soa_email", soa_email)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if ttl_sec is not None:
            pulumi.set(__self__, "ttl_sec", ttl_sec)

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Input[builtins.str]:
        """
        The domain this Domain represents. These must be unique in our system; you cannot have two Domains representing the same domain.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        If this Domain represents the authoritative source of information for the domain it describes, or if it is a read-only copy of a master (also called a slave).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="axfrIps")
    def axfr_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of IPs that may perform a zone transfer for this Domain. This is potentially dangerous, and should be set to an empty list unless you intend to use it.
        """
        return pulumi.get(self, "axfr_ips")

    @axfr_ips.setter
    def axfr_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "axfr_ips", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description for this Domain. This is for display purposes only.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="expireSec")
    def expire_sec(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The amount of time in seconds that may pass before this Domain is no longer authoritative. Valid values are 0, 30, 120, 300, 3600, 7200, 14400, 28800, 57600, 86400, 172800, 345600, 604800, 1209600, and 2419200 - any other value will be rounded to the nearest valid value.
        """
        return pulumi.get(self, "expire_sec")

    @expire_sec.setter
    def expire_sec(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "expire_sec", value)

    @property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The group this Domain belongs to. This is for display purposes only.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "group", value)

    @property
    @pulumi.getter(name="masterIps")
    def master_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The IP addresses representing the master DNS for this Domain.

        - - -
        """
        return pulumi.get(self, "master_ips")

    @master_ips.setter
    def master_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "master_ips", value)

    @property
    @pulumi.getter(name="refreshSec")
    def refresh_sec(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The amount of time in seconds before this Domain should be refreshed. Valid values are 0, 30, 120, 300, 3600, 7200, 14400, 28800, 57600, 86400, 172800, 345600, 604800, 1209600, and 2419200 - any other value will be rounded to the nearest valid value.
        """
        return pulumi.get(self, "refresh_sec")

    @refresh_sec.setter
    def refresh_sec(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "refresh_sec", value)

    @property
    @pulumi.getter(name="retrySec")
    def retry_sec(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The interval, in seconds, at which a failed refresh should be retried. Valid values are 0, 30, 120, 300, 3600, 7200, 14400, 28800, 57600, 86400, 172800, 345600, 604800, 1209600, and 2419200 - any other value will be rounded to the nearest valid value.
        """
        return pulumi.get(self, "retry_sec")

    @retry_sec.setter
    def retry_sec(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "retry_sec", value)

    @property
    @pulumi.getter(name="soaEmail")
    def soa_email(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Start of Authority email address. This is required for master Domains.
        """
        return pulumi.get(self, "soa_email")

    @soa_email.setter
    def soa_email(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "soa_email", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Used to control whether this Domain is currently being rendered (defaults to "active").
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of tags applied to this object. Tags are case-insensitive and are for organizational purposes only.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="ttlSec")
    def ttl_sec(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        'Time to Live' - the amount of time in seconds that this Domain's records may be cached by resolvers or other domain servers. Valid values are 0, 30, 120, 300, 3600, 7200, 14400, 28800, 57600, 86400, 172800, 345600, 604800, 1209600, and 2419200 - any other value will be rounded to the nearest valid value.
        """
        return pulumi.get(self, "ttl_sec")

    @ttl_sec.setter
    def ttl_sec(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ttl_sec", value)


@pulumi.input_type
class _DomainState:
    def __init__(__self__, *,
                 axfr_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 domain: Optional[pulumi.Input[builtins.str]] = None,
                 expire_sec: Optional[pulumi.Input[builtins.int]] = None,
                 group: Optional[pulumi.Input[builtins.str]] = None,
                 master_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 refresh_sec: Optional[pulumi.Input[builtins.int]] = None,
                 retry_sec: Optional[pulumi.Input[builtins.int]] = None,
                 soa_email: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ttl_sec: Optional[pulumi.Input[builtins.int]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Domain resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] axfr_ips: The list of IPs that may perform a zone transfer for this Domain. This is potentially dangerous, and should be set to an empty list unless you intend to use it.
        :param pulumi.Input[builtins.str] description: A description for this Domain. This is for display purposes only.
        :param pulumi.Input[builtins.str] domain: The domain this Domain represents. These must be unique in our system; you cannot have two Domains representing the same domain.
        :param pulumi.Input[builtins.int] expire_sec: The amount of time in seconds that may pass before this Domain is no longer authoritative. Valid values are 0, 30, 120, 300, 3600, 7200, 14400, 28800, 57600, 86400, 172800, 345600, 604800, 1209600, and 2419200 - any other value will be rounded to the nearest valid value.
        :param pulumi.Input[builtins.str] group: The group this Domain belongs to. This is for display purposes only.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] master_ips: The IP addresses representing the master DNS for this Domain.
               
               - - -
        :param pulumi.Input[builtins.int] refresh_sec: The amount of time in seconds before this Domain should be refreshed. Valid values are 0, 30, 120, 300, 3600, 7200, 14400, 28800, 57600, 86400, 172800, 345600, 604800, 1209600, and 2419200 - any other value will be rounded to the nearest valid value.
        :param pulumi.Input[builtins.int] retry_sec: The interval, in seconds, at which a failed refresh should be retried. Valid values are 0, 30, 120, 300, 3600, 7200, 14400, 28800, 57600, 86400, 172800, 345600, 604800, 1209600, and 2419200 - any other value will be rounded to the nearest valid value.
        :param pulumi.Input[builtins.str] soa_email: Start of Authority email address. This is required for master Domains.
        :param pulumi.Input[builtins.str] status: Used to control whether this Domain is currently being rendered (defaults to "active").
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of tags applied to this object. Tags are case-insensitive and are for organizational purposes only.
        :param pulumi.Input[builtins.int] ttl_sec: 'Time to Live' - the amount of time in seconds that this Domain's records may be cached by resolvers or other domain servers. Valid values are 0, 30, 120, 300, 3600, 7200, 14400, 28800, 57600, 86400, 172800, 345600, 604800, 1209600, and 2419200 - any other value will be rounded to the nearest valid value.
        :param pulumi.Input[builtins.str] type: If this Domain represents the authoritative source of information for the domain it describes, or if it is a read-only copy of a master (also called a slave).
        """
        if axfr_ips is not None:
            pulumi.set(__self__, "axfr_ips", axfr_ips)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if expire_sec is not None:
            pulumi.set(__self__, "expire_sec", expire_sec)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if master_ips is not None:
            pulumi.set(__self__, "master_ips", master_ips)
        if refresh_sec is not None:
            pulumi.set(__self__, "refresh_sec", refresh_sec)
        if retry_sec is not None:
            pulumi.set(__self__, "retry_sec", retry_sec)
        if soa_email is not None:
            pulumi.set(__self__, "soa_email", soa_email)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if ttl_sec is not None:
            pulumi.set(__self__, "ttl_sec", ttl_sec)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="axfrIps")
    def axfr_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of IPs that may perform a zone transfer for this Domain. This is potentially dangerous, and should be set to an empty list unless you intend to use it.
        """
        return pulumi.get(self, "axfr_ips")

    @axfr_ips.setter
    def axfr_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "axfr_ips", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description for this Domain. This is for display purposes only.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The domain this Domain represents. These must be unique in our system; you cannot have two Domains representing the same domain.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="expireSec")
    def expire_sec(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The amount of time in seconds that may pass before this Domain is no longer authoritative. Valid values are 0, 30, 120, 300, 3600, 7200, 14400, 28800, 57600, 86400, 172800, 345600, 604800, 1209600, and 2419200 - any other value will be rounded to the nearest valid value.
        """
        return pulumi.get(self, "expire_sec")

    @expire_sec.setter
    def expire_sec(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "expire_sec", value)

    @property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The group this Domain belongs to. This is for display purposes only.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "group", value)

    @property
    @pulumi.getter(name="masterIps")
    def master_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The IP addresses representing the master DNS for this Domain.

        - - -
        """
        return pulumi.get(self, "master_ips")

    @master_ips.setter
    def master_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "master_ips", value)

    @property
    @pulumi.getter(name="refreshSec")
    def refresh_sec(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The amount of time in seconds before this Domain should be refreshed. Valid values are 0, 30, 120, 300, 3600, 7200, 14400, 28800, 57600, 86400, 172800, 345600, 604800, 1209600, and 2419200 - any other value will be rounded to the nearest valid value.
        """
        return pulumi.get(self, "refresh_sec")

    @refresh_sec.setter
    def refresh_sec(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "refresh_sec", value)

    @property
    @pulumi.getter(name="retrySec")
    def retry_sec(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The interval, in seconds, at which a failed refresh should be retried. Valid values are 0, 30, 120, 300, 3600, 7200, 14400, 28800, 57600, 86400, 172800, 345600, 604800, 1209600, and 2419200 - any other value will be rounded to the nearest valid value.
        """
        return pulumi.get(self, "retry_sec")

    @retry_sec.setter
    def retry_sec(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "retry_sec", value)

    @property
    @pulumi.getter(name="soaEmail")
    def soa_email(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Start of Authority email address. This is required for master Domains.
        """
        return pulumi.get(self, "soa_email")

    @soa_email.setter
    def soa_email(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "soa_email", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Used to control whether this Domain is currently being rendered (defaults to "active").
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of tags applied to this object. Tags are case-insensitive and are for organizational purposes only.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="ttlSec")
    def ttl_sec(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        'Time to Live' - the amount of time in seconds that this Domain's records may be cached by resolvers or other domain servers. Valid values are 0, 30, 120, 300, 3600, 7200, 14400, 28800, 57600, 86400, 172800, 345600, 604800, 1209600, and 2419200 - any other value will be rounded to the nearest valid value.
        """
        return pulumi.get(self, "ttl_sec")

    @ttl_sec.setter
    def ttl_sec(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ttl_sec", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If this Domain represents the authoritative source of information for the domain it describes, or if it is a read-only copy of a master (also called a slave).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("linode:index/domain:Domain")
class Domain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 axfr_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 domain: Optional[pulumi.Input[builtins.str]] = None,
                 expire_sec: Optional[pulumi.Input[builtins.int]] = None,
                 group: Optional[pulumi.Input[builtins.str]] = None,
                 master_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 refresh_sec: Optional[pulumi.Input[builtins.int]] = None,
                 retry_sec: Optional[pulumi.Input[builtins.int]] = None,
                 soa_email: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ttl_sec: Optional[pulumi.Input[builtins.int]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides a Linode Domain resource.  This can be used to create, modify, and delete Linode Domains through Linode's managed DNS service.
        For more information, see [DNS Manager](https://www.linode.com/docs/platform/manager/dns-manager/) and the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/post-domain).

        ## Example Usage

        The following example shows how one might use this resource to configure a Domain Record attached to a Linode Domain.

        ```python
        import pulumi
        import pulumi_linode as linode

        foobar = linode.Domain("foobar",
            type="master",
            domain="foobar.example",
            soa_email="example@foobar.example",
            tags=[
                "foo",
                "bar",
            ])
        foobar_domain_record = linode.DomainRecord("foobar",
            domain_id=foobar.id,
            name="www",
            record_type="CNAME",
            target="foobar.example")
        ```

        ## Import

        Linodes Domains can be imported using the Linode Domain `id`, e.g.

        ```sh
        $ pulumi import linode:index/domain:Domain foobar 1234567
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] axfr_ips: The list of IPs that may perform a zone transfer for this Domain. This is potentially dangerous, and should be set to an empty list unless you intend to use it.
        :param pulumi.Input[builtins.str] description: A description for this Domain. This is for display purposes only.
        :param pulumi.Input[builtins.str] domain: The domain this Domain represents. These must be unique in our system; you cannot have two Domains representing the same domain.
        :param pulumi.Input[builtins.int] expire_sec: The amount of time in seconds that may pass before this Domain is no longer authoritative. Valid values are 0, 30, 120, 300, 3600, 7200, 14400, 28800, 57600, 86400, 172800, 345600, 604800, 1209600, and 2419200 - any other value will be rounded to the nearest valid value.
        :param pulumi.Input[builtins.str] group: The group this Domain belongs to. This is for display purposes only.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] master_ips: The IP addresses representing the master DNS for this Domain.
               
               - - -
        :param pulumi.Input[builtins.int] refresh_sec: The amount of time in seconds before this Domain should be refreshed. Valid values are 0, 30, 120, 300, 3600, 7200, 14400, 28800, 57600, 86400, 172800, 345600, 604800, 1209600, and 2419200 - any other value will be rounded to the nearest valid value.
        :param pulumi.Input[builtins.int] retry_sec: The interval, in seconds, at which a failed refresh should be retried. Valid values are 0, 30, 120, 300, 3600, 7200, 14400, 28800, 57600, 86400, 172800, 345600, 604800, 1209600, and 2419200 - any other value will be rounded to the nearest valid value.
        :param pulumi.Input[builtins.str] soa_email: Start of Authority email address. This is required for master Domains.
        :param pulumi.Input[builtins.str] status: Used to control whether this Domain is currently being rendered (defaults to "active").
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of tags applied to this object. Tags are case-insensitive and are for organizational purposes only.
        :param pulumi.Input[builtins.int] ttl_sec: 'Time to Live' - the amount of time in seconds that this Domain's records may be cached by resolvers or other domain servers. Valid values are 0, 30, 120, 300, 3600, 7200, 14400, 28800, 57600, 86400, 172800, 345600, 604800, 1209600, and 2419200 - any other value will be rounded to the nearest valid value.
        :param pulumi.Input[builtins.str] type: If this Domain represents the authoritative source of information for the domain it describes, or if it is a read-only copy of a master (also called a slave).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Linode Domain resource.  This can be used to create, modify, and delete Linode Domains through Linode's managed DNS service.
        For more information, see [DNS Manager](https://www.linode.com/docs/platform/manager/dns-manager/) and the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/post-domain).

        ## Example Usage

        The following example shows how one might use this resource to configure a Domain Record attached to a Linode Domain.

        ```python
        import pulumi
        import pulumi_linode as linode

        foobar = linode.Domain("foobar",
            type="master",
            domain="foobar.example",
            soa_email="example@foobar.example",
            tags=[
                "foo",
                "bar",
            ])
        foobar_domain_record = linode.DomainRecord("foobar",
            domain_id=foobar.id,
            name="www",
            record_type="CNAME",
            target="foobar.example")
        ```

        ## Import

        Linodes Domains can be imported using the Linode Domain `id`, e.g.

        ```sh
        $ pulumi import linode:index/domain:Domain foobar 1234567
        ```

        :param str resource_name: The name of the resource.
        :param DomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 axfr_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 domain: Optional[pulumi.Input[builtins.str]] = None,
                 expire_sec: Optional[pulumi.Input[builtins.int]] = None,
                 group: Optional[pulumi.Input[builtins.str]] = None,
                 master_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 refresh_sec: Optional[pulumi.Input[builtins.int]] = None,
                 retry_sec: Optional[pulumi.Input[builtins.int]] = None,
                 soa_email: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ttl_sec: Optional[pulumi.Input[builtins.int]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainArgs.__new__(DomainArgs)

            __props__.__dict__["axfr_ips"] = axfr_ips
            __props__.__dict__["description"] = description
            if domain is None and not opts.urn:
                raise TypeError("Missing required property 'domain'")
            __props__.__dict__["domain"] = domain
            __props__.__dict__["expire_sec"] = expire_sec
            __props__.__dict__["group"] = group
            __props__.__dict__["master_ips"] = master_ips
            __props__.__dict__["refresh_sec"] = refresh_sec
            __props__.__dict__["retry_sec"] = retry_sec
            __props__.__dict__["soa_email"] = soa_email
            __props__.__dict__["status"] = status
            __props__.__dict__["tags"] = tags
            __props__.__dict__["ttl_sec"] = ttl_sec
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
        super(Domain, __self__).__init__(
            'linode:index/domain:Domain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            axfr_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            domain: Optional[pulumi.Input[builtins.str]] = None,
            expire_sec: Optional[pulumi.Input[builtins.int]] = None,
            group: Optional[pulumi.Input[builtins.str]] = None,
            master_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            refresh_sec: Optional[pulumi.Input[builtins.int]] = None,
            retry_sec: Optional[pulumi.Input[builtins.int]] = None,
            soa_email: Optional[pulumi.Input[builtins.str]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            ttl_sec: Optional[pulumi.Input[builtins.int]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None) -> 'Domain':
        """
        Get an existing Domain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] axfr_ips: The list of IPs that may perform a zone transfer for this Domain. This is potentially dangerous, and should be set to an empty list unless you intend to use it.
        :param pulumi.Input[builtins.str] description: A description for this Domain. This is for display purposes only.
        :param pulumi.Input[builtins.str] domain: The domain this Domain represents. These must be unique in our system; you cannot have two Domains representing the same domain.
        :param pulumi.Input[builtins.int] expire_sec: The amount of time in seconds that may pass before this Domain is no longer authoritative. Valid values are 0, 30, 120, 300, 3600, 7200, 14400, 28800, 57600, 86400, 172800, 345600, 604800, 1209600, and 2419200 - any other value will be rounded to the nearest valid value.
        :param pulumi.Input[builtins.str] group: The group this Domain belongs to. This is for display purposes only.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] master_ips: The IP addresses representing the master DNS for this Domain.
               
               - - -
        :param pulumi.Input[builtins.int] refresh_sec: The amount of time in seconds before this Domain should be refreshed. Valid values are 0, 30, 120, 300, 3600, 7200, 14400, 28800, 57600, 86400, 172800, 345600, 604800, 1209600, and 2419200 - any other value will be rounded to the nearest valid value.
        :param pulumi.Input[builtins.int] retry_sec: The interval, in seconds, at which a failed refresh should be retried. Valid values are 0, 30, 120, 300, 3600, 7200, 14400, 28800, 57600, 86400, 172800, 345600, 604800, 1209600, and 2419200 - any other value will be rounded to the nearest valid value.
        :param pulumi.Input[builtins.str] soa_email: Start of Authority email address. This is required for master Domains.
        :param pulumi.Input[builtins.str] status: Used to control whether this Domain is currently being rendered (defaults to "active").
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of tags applied to this object. Tags are case-insensitive and are for organizational purposes only.
        :param pulumi.Input[builtins.int] ttl_sec: 'Time to Live' - the amount of time in seconds that this Domain's records may be cached by resolvers or other domain servers. Valid values are 0, 30, 120, 300, 3600, 7200, 14400, 28800, 57600, 86400, 172800, 345600, 604800, 1209600, and 2419200 - any other value will be rounded to the nearest valid value.
        :param pulumi.Input[builtins.str] type: If this Domain represents the authoritative source of information for the domain it describes, or if it is a read-only copy of a master (also called a slave).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainState.__new__(_DomainState)

        __props__.__dict__["axfr_ips"] = axfr_ips
        __props__.__dict__["description"] = description
        __props__.__dict__["domain"] = domain
        __props__.__dict__["expire_sec"] = expire_sec
        __props__.__dict__["group"] = group
        __props__.__dict__["master_ips"] = master_ips
        __props__.__dict__["refresh_sec"] = refresh_sec
        __props__.__dict__["retry_sec"] = retry_sec
        __props__.__dict__["soa_email"] = soa_email
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["ttl_sec"] = ttl_sec
        __props__.__dict__["type"] = type
        return Domain(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="axfrIps")
    def axfr_ips(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The list of IPs that may perform a zone transfer for this Domain. This is potentially dangerous, and should be set to an empty list unless you intend to use it.
        """
        return pulumi.get(self, "axfr_ips")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A description for this Domain. This is for display purposes only.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output[builtins.str]:
        """
        The domain this Domain represents. These must be unique in our system; you cannot have two Domains representing the same domain.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="expireSec")
    def expire_sec(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The amount of time in seconds that may pass before this Domain is no longer authoritative. Valid values are 0, 30, 120, 300, 3600, 7200, 14400, 28800, 57600, 86400, 172800, 345600, 604800, 1209600, and 2419200 - any other value will be rounded to the nearest valid value.
        """
        return pulumi.get(self, "expire_sec")

    @property
    @pulumi.getter
    def group(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The group this Domain belongs to. This is for display purposes only.
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter(name="masterIps")
    def master_ips(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The IP addresses representing the master DNS for this Domain.

        - - -
        """
        return pulumi.get(self, "master_ips")

    @property
    @pulumi.getter(name="refreshSec")
    def refresh_sec(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The amount of time in seconds before this Domain should be refreshed. Valid values are 0, 30, 120, 300, 3600, 7200, 14400, 28800, 57600, 86400, 172800, 345600, 604800, 1209600, and 2419200 - any other value will be rounded to the nearest valid value.
        """
        return pulumi.get(self, "refresh_sec")

    @property
    @pulumi.getter(name="retrySec")
    def retry_sec(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The interval, in seconds, at which a failed refresh should be retried. Valid values are 0, 30, 120, 300, 3600, 7200, 14400, 28800, 57600, 86400, 172800, 345600, 604800, 1209600, and 2419200 - any other value will be rounded to the nearest valid value.
        """
        return pulumi.get(self, "retry_sec")

    @property
    @pulumi.getter(name="soaEmail")
    def soa_email(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Start of Authority email address. This is required for master Domains.
        """
        return pulumi.get(self, "soa_email")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        Used to control whether this Domain is currently being rendered (defaults to "active").
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of tags applied to this object. Tags are case-insensitive and are for organizational purposes only.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="ttlSec")
    def ttl_sec(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        'Time to Live' - the amount of time in seconds that this Domain's records may be cached by resolvers or other domain servers. Valid values are 0, 30, 120, 300, 3600, 7200, 14400, 28800, 57600, 86400, 172800, 345600, 604800, 1209600, and 2419200 - any other value will be rounded to the nearest valid value.
        """
        return pulumi.get(self, "ttl_sec")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        If this Domain represents the authoritative source of information for the domain it describes, or if it is a read-only copy of a master (also called a slave).
        """
        return pulumi.get(self, "type")

