# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAccountAvailabilitiesResult',
    'AwaitableGetAccountAvailabilitiesResult',
    'get_account_availabilities',
    'get_account_availabilities_output',
]

@pulumi.output_type
class GetAccountAvailabilitiesResult:
    """
    A collection of values returned by getAccountAvailabilities.
    """
    def __init__(__self__, availabilities=None, filters=None, id=None):
        if availabilities and not isinstance(availabilities, list):
            raise TypeError("Expected argument 'availabilities' to be a list")
        pulumi.set(__self__, "availabilities", availabilities)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def availabilities(self) -> Optional[Sequence['outputs.GetAccountAvailabilitiesAvailabilityResult']]:
        return pulumi.get(self, "availabilities")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAccountAvailabilitiesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")


class AwaitableGetAccountAvailabilitiesResult(GetAccountAvailabilitiesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccountAvailabilitiesResult(
            availabilities=self.availabilities,
            filters=self.filters,
            id=self.id)


def get_account_availabilities(availabilities: Optional[Sequence[Union['GetAccountAvailabilitiesAvailabilityArgs', 'GetAccountAvailabilitiesAvailabilityArgsDict']]] = None,
                               filters: Optional[Sequence[Union['GetAccountAvailabilitiesFilterArgs', 'GetAccountAvailabilitiesFilterArgsDict']]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccountAvailabilitiesResult:
    """
    Provides information about services availabilities for the current Linode account.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-availability).

    ## Example Usage

    The following example shows how one might use this data source to discover regions without specific service availability.

    ```python
    import pulumi
    import pulumi_linode as linode

    filtered_availabilities = linode.get_account_availabilities(filters=[{
        "name": "unavailable",
        "values": ["Linodes"],
    }])
    pulumi.export("regions-without-linodes", [__item.region for __item in filtered_availabilities.availabilities])
    ```

    ## Filterable Fields

    * `region`

    * `unavailable`

    * `available`
    """
    __args__ = dict()
    __args__['availabilities'] = availabilities
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('linode:index/getAccountAvailabilities:getAccountAvailabilities', __args__, opts=opts, typ=GetAccountAvailabilitiesResult).value

    return AwaitableGetAccountAvailabilitiesResult(
        availabilities=pulumi.get(__ret__, 'availabilities'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))
def get_account_availabilities_output(availabilities: Optional[pulumi.Input[Optional[Sequence[Union['GetAccountAvailabilitiesAvailabilityArgs', 'GetAccountAvailabilitiesAvailabilityArgsDict']]]]] = None,
                                      filters: Optional[pulumi.Input[Optional[Sequence[Union['GetAccountAvailabilitiesFilterArgs', 'GetAccountAvailabilitiesFilterArgsDict']]]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccountAvailabilitiesResult]:
    """
    Provides information about services availabilities for the current Linode account.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-availability).

    ## Example Usage

    The following example shows how one might use this data source to discover regions without specific service availability.

    ```python
    import pulumi
    import pulumi_linode as linode

    filtered_availabilities = linode.get_account_availabilities(filters=[{
        "name": "unavailable",
        "values": ["Linodes"],
    }])
    pulumi.export("regions-without-linodes", [__item.region for __item in filtered_availabilities.availabilities])
    ```

    ## Filterable Fields

    * `region`

    * `unavailable`

    * `available`
    """
    __args__ = dict()
    __args__['availabilities'] = availabilities
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('linode:index/getAccountAvailabilities:getAccountAvailabilities', __args__, opts=opts, typ=GetAccountAvailabilitiesResult)
    return __ret__.apply(lambda __response__: GetAccountAvailabilitiesResult(
        availabilities=pulumi.get(__response__, 'availabilities'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id')))
