# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetAccountAvailabilityResult',
    'AwaitableGetAccountAvailabilityResult',
    'get_account_availability',
    'get_account_availability_output',
]

@pulumi.output_type
class GetAccountAvailabilityResult:
    """
    A collection of values returned by getAccountAvailability.
    """
    def __init__(__self__, availables=None, id=None, region=None, unavailables=None):
        if availables and not isinstance(availables, list):
            raise TypeError("Expected argument 'availables' to be a list")
        pulumi.set(__self__, "availables", availables)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if unavailables and not isinstance(unavailables, list):
            raise TypeError("Expected argument 'unavailables' to be a list")
        pulumi.set(__self__, "unavailables", unavailables)

    @property
    @pulumi.getter
    def availables(self) -> Sequence[builtins.str]:
        """
        A set of services which are available to the account in a region.
        """
        return pulumi.get(self, "availables")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        The region ID.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def unavailables(self) -> Sequence[builtins.str]:
        """
        A set of services which are unavailable to the account in a region.
        """
        return pulumi.get(self, "unavailables")


class AwaitableGetAccountAvailabilityResult(GetAccountAvailabilityResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccountAvailabilityResult(
            availables=self.availables,
            id=self.id,
            region=self.region,
            unavailables=self.unavailables)


def get_account_availability(region: Optional[builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccountAvailabilityResult:
    """
    Provides details about service availability in a region to an account specifically.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-account-availability).

    ## Example Usage

    The following example shows how one might use this data source to access information about a Linode account availability.

    ```python
    import pulumi
    import pulumi_linode as linode

    my_account_availability = linode.get_account_availability(region="us-east")
    ```


    :param builtins.str region: The region ID.
    """
    __args__ = dict()
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('linode:index/getAccountAvailability:getAccountAvailability', __args__, opts=opts, typ=GetAccountAvailabilityResult).value

    return AwaitableGetAccountAvailabilityResult(
        availables=pulumi.get(__ret__, 'availables'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'),
        unavailables=pulumi.get(__ret__, 'unavailables'))
def get_account_availability_output(region: Optional[pulumi.Input[builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccountAvailabilityResult]:
    """
    Provides details about service availability in a region to an account specifically.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-account-availability).

    ## Example Usage

    The following example shows how one might use this data source to access information about a Linode account availability.

    ```python
    import pulumi
    import pulumi_linode as linode

    my_account_availability = linode.get_account_availability(region="us-east")
    ```


    :param builtins.str region: The region ID.
    """
    __args__ = dict()
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('linode:index/getAccountAvailability:getAccountAvailability', __args__, opts=opts, typ=GetAccountAvailabilityResult)
    return __ret__.apply(lambda __response__: GetAccountAvailabilityResult(
        availables=pulumi.get(__response__, 'availables'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region'),
        unavailables=pulumi.get(__response__, 'unavailables')))
