# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetChildAccountsResult',
    'AwaitableGetChildAccountsResult',
    'get_child_accounts',
    'get_child_accounts_output',
]

@pulumi.output_type
class GetChildAccountsResult:
    """
    A collection of values returned by getChildAccounts.
    """
    def __init__(__self__, child_accounts=None, filters=None, id=None):
        if child_accounts and not isinstance(child_accounts, list):
            raise TypeError("Expected argument 'child_accounts' to be a list")
        pulumi.set(__self__, "child_accounts", child_accounts)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="childAccounts")
    def child_accounts(self) -> Optional[Sequence['outputs.GetChildAccountsChildAccountResult']]:
        return pulumi.get(self, "child_accounts")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetChildAccountsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")


class AwaitableGetChildAccountsResult(GetChildAccountsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetChildAccountsResult(
            child_accounts=self.child_accounts,
            filters=self.filters,
            id=self.id)


def get_child_accounts(child_accounts: Optional[Sequence[Union['GetChildAccountsChildAccountArgs', 'GetChildAccountsChildAccountArgsDict']]] = None,
                       filters: Optional[Sequence[Union['GetChildAccountsFilterArgs', 'GetChildAccountsFilterArgsDict']]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetChildAccountsResult:
    """
    Provides information about Linode Child Accounts that match a set of filters.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-child-accounts).

    **NOTE: Parent/Child related features may not be generally available.**

    ## Example Usage

    The following example shows how one might use this data source to access Child Accounts under the current Account.

    ```python
    import pulumi
    import pulumi_linode as linode

    all = linode.get_child_accounts()
    filtered = linode.get_child_accounts(filters=[
        {
            "name": "email",
            "values": ["example@linode.com"],
        },
        {
            "name": "first_name",
            "values": ["John"],
        },
        {
            "name": "last_name",
            "values": ["Smith"],
        },
    ])
    pulumi.export("allAccounts", [__item.euuid for __item in all.child_accounts])
    pulumi.export("filteredAccounts", [__item.euuid for __item in filtered.child_accounts])
    ```

    ## Filterable Fields

    * `euuid`

    * `email`

    * `first_name`

    * `last_name`

    * `company`

    * `address_1`

    * `address_2`

    * `phone`

    * `city`

    * `state`

    * `country`

    * `zip`

    * `capabilities`

    * `active_since`
    """
    __args__ = dict()
    __args__['childAccounts'] = child_accounts
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('linode:index/getChildAccounts:getChildAccounts', __args__, opts=opts, typ=GetChildAccountsResult).value

    return AwaitableGetChildAccountsResult(
        child_accounts=pulumi.get(__ret__, 'child_accounts'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))
def get_child_accounts_output(child_accounts: Optional[pulumi.Input[Optional[Sequence[Union['GetChildAccountsChildAccountArgs', 'GetChildAccountsChildAccountArgsDict']]]]] = None,
                              filters: Optional[pulumi.Input[Optional[Sequence[Union['GetChildAccountsFilterArgs', 'GetChildAccountsFilterArgsDict']]]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetChildAccountsResult]:
    """
    Provides information about Linode Child Accounts that match a set of filters.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-child-accounts).

    **NOTE: Parent/Child related features may not be generally available.**

    ## Example Usage

    The following example shows how one might use this data source to access Child Accounts under the current Account.

    ```python
    import pulumi
    import pulumi_linode as linode

    all = linode.get_child_accounts()
    filtered = linode.get_child_accounts(filters=[
        {
            "name": "email",
            "values": ["example@linode.com"],
        },
        {
            "name": "first_name",
            "values": ["John"],
        },
        {
            "name": "last_name",
            "values": ["Smith"],
        },
    ])
    pulumi.export("allAccounts", [__item.euuid for __item in all.child_accounts])
    pulumi.export("filteredAccounts", [__item.euuid for __item in filtered.child_accounts])
    ```

    ## Filterable Fields

    * `euuid`

    * `email`

    * `first_name`

    * `last_name`

    * `company`

    * `address_1`

    * `address_2`

    * `phone`

    * `city`

    * `state`

    * `country`

    * `zip`

    * `capabilities`

    * `active_since`
    """
    __args__ = dict()
    __args__['childAccounts'] = child_accounts
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('linode:index/getChildAccounts:getChildAccounts', __args__, opts=opts, typ=GetChildAccountsResult)
    return __ret__.apply(lambda __response__: GetChildAccountsResult(
        child_accounts=pulumi.get(__response__, 'child_accounts'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id')))
