# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetDomainResult',
    'AwaitableGetDomainResult',
    'get_domain',
    'get_domain_output',
]

@pulumi.output_type
class GetDomainResult:
    """
    A collection of values returned by getDomain.
    """
    def __init__(__self__, axfr_ips=None, description=None, domain=None, expire_sec=None, group=None, id=None, master_ips=None, refresh_sec=None, retry_sec=None, soa_email=None, status=None, tags=None, ttl_sec=None, type=None):
        if axfr_ips and not isinstance(axfr_ips, list):
            raise TypeError("Expected argument 'axfr_ips' to be a list")
        pulumi.set(__self__, "axfr_ips", axfr_ips)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if domain and not isinstance(domain, str):
            raise TypeError("Expected argument 'domain' to be a str")
        pulumi.set(__self__, "domain", domain)
        if expire_sec and not isinstance(expire_sec, int):
            raise TypeError("Expected argument 'expire_sec' to be a int")
        pulumi.set(__self__, "expire_sec", expire_sec)
        if group and not isinstance(group, str):
            raise TypeError("Expected argument 'group' to be a str")
        pulumi.set(__self__, "group", group)
        if id and not isinstance(id, int):
            raise TypeError("Expected argument 'id' to be a int")
        pulumi.set(__self__, "id", id)
        if master_ips and not isinstance(master_ips, list):
            raise TypeError("Expected argument 'master_ips' to be a list")
        pulumi.set(__self__, "master_ips", master_ips)
        if refresh_sec and not isinstance(refresh_sec, int):
            raise TypeError("Expected argument 'refresh_sec' to be a int")
        pulumi.set(__self__, "refresh_sec", refresh_sec)
        if retry_sec and not isinstance(retry_sec, int):
            raise TypeError("Expected argument 'retry_sec' to be a int")
        pulumi.set(__self__, "retry_sec", retry_sec)
        if soa_email and not isinstance(soa_email, str):
            raise TypeError("Expected argument 'soa_email' to be a str")
        pulumi.set(__self__, "soa_email", soa_email)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if ttl_sec and not isinstance(ttl_sec, int):
            raise TypeError("Expected argument 'ttl_sec' to be a int")
        pulumi.set(__self__, "ttl_sec", ttl_sec)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="axfrIps")
    def axfr_ips(self) -> Sequence[builtins.str]:
        """
        The list of IPs that may perform a zone transfer for this Domain.
        """
        return pulumi.get(self, "axfr_ips")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        A description for this Domain.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def domain(self) -> Optional[builtins.str]:
        """
        The domain this Domain represents. These must be unique in our system; you cannot have two Domains representing the same domain
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="expireSec")
    def expire_sec(self) -> builtins.int:
        """
        The amount of time in seconds that may pass before this Domain is no longer authoritative.
        """
        return pulumi.get(self, "expire_sec")

    @property
    @pulumi.getter
    def group(self) -> builtins.str:
        """
        The group this Domain belongs to.
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.int]:
        """
        The unique ID of this Domain.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="masterIps")
    def master_ips(self) -> Sequence[builtins.str]:
        """
        The IP addresses representing the master DNS for this Domain.
        """
        return pulumi.get(self, "master_ips")

    @property
    @pulumi.getter(name="refreshSec")
    def refresh_sec(self) -> builtins.int:
        """
        The amount of time in seconds before this Domain should be refreshed.
        """
        return pulumi.get(self, "refresh_sec")

    @property
    @pulumi.getter(name="retrySec")
    def retry_sec(self) -> builtins.int:
        """
        The interval, in seconds, at which a failed refresh should be retried.
        """
        return pulumi.get(self, "retry_sec")

    @property
    @pulumi.getter(name="soaEmail")
    def soa_email(self) -> builtins.str:
        """
        Start of Authority email address.
        """
        return pulumi.get(self, "soa_email")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Used to control whether this Domain is currently being rendered. (`disabled`, `active`)
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[builtins.str]:
        """
        An array of tags applied to this object. Tags are case-insensitive and are for organizational purposes only.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="ttlSec")
    def ttl_sec(self) -> builtins.int:
        """
        'Time to Live'-the amount of time in seconds that this Domain's records may be cached by resolvers or other domain servers.
        """
        return pulumi.get(self, "ttl_sec")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        If this Domain represents the authoritative source of information for the domain it describes, or if it is a read-only copy of a master (also called a slave) (`master`, `slave`)
        """
        return pulumi.get(self, "type")


class AwaitableGetDomainResult(GetDomainResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDomainResult(
            axfr_ips=self.axfr_ips,
            description=self.description,
            domain=self.domain,
            expire_sec=self.expire_sec,
            group=self.group,
            id=self.id,
            master_ips=self.master_ips,
            refresh_sec=self.refresh_sec,
            retry_sec=self.retry_sec,
            soa_email=self.soa_email,
            status=self.status,
            tags=self.tags,
            ttl_sec=self.ttl_sec,
            type=self.type)


def get_domain(domain: Optional[builtins.str] = None,
               id: Optional[builtins.int] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDomainResult:
    """
    Provides information about a Linode domain.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-domain).

    ## Example Usage

    The following example shows how one might use this data source to access information about a Linode domain.

    ```python
    import pulumi
    import pulumi_linode as linode

    foo = linode.get_domain(id=1234567)
    bar = linode.get_domain(domain="bar.example.com")
    ```


    :param builtins.str domain: The unique domain name of the Domain record to query.
    :param builtins.int id: The unique numeric ID of the Domain record to query.
    """
    __args__ = dict()
    __args__['domain'] = domain
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('linode:index/getDomain:getDomain', __args__, opts=opts, typ=GetDomainResult).value

    return AwaitableGetDomainResult(
        axfr_ips=pulumi.get(__ret__, 'axfr_ips'),
        description=pulumi.get(__ret__, 'description'),
        domain=pulumi.get(__ret__, 'domain'),
        expire_sec=pulumi.get(__ret__, 'expire_sec'),
        group=pulumi.get(__ret__, 'group'),
        id=pulumi.get(__ret__, 'id'),
        master_ips=pulumi.get(__ret__, 'master_ips'),
        refresh_sec=pulumi.get(__ret__, 'refresh_sec'),
        retry_sec=pulumi.get(__ret__, 'retry_sec'),
        soa_email=pulumi.get(__ret__, 'soa_email'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        ttl_sec=pulumi.get(__ret__, 'ttl_sec'),
        type=pulumi.get(__ret__, 'type'))
def get_domain_output(domain: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                      id: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDomainResult]:
    """
    Provides information about a Linode domain.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-domain).

    ## Example Usage

    The following example shows how one might use this data source to access information about a Linode domain.

    ```python
    import pulumi
    import pulumi_linode as linode

    foo = linode.get_domain(id=1234567)
    bar = linode.get_domain(domain="bar.example.com")
    ```


    :param builtins.str domain: The unique domain name of the Domain record to query.
    :param builtins.int id: The unique numeric ID of the Domain record to query.
    """
    __args__ = dict()
    __args__['domain'] = domain
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('linode:index/getDomain:getDomain', __args__, opts=opts, typ=GetDomainResult)
    return __ret__.apply(lambda __response__: GetDomainResult(
        axfr_ips=pulumi.get(__response__, 'axfr_ips'),
        description=pulumi.get(__response__, 'description'),
        domain=pulumi.get(__response__, 'domain'),
        expire_sec=pulumi.get(__response__, 'expire_sec'),
        group=pulumi.get(__response__, 'group'),
        id=pulumi.get(__response__, 'id'),
        master_ips=pulumi.get(__response__, 'master_ips'),
        refresh_sec=pulumi.get(__response__, 'refresh_sec'),
        retry_sec=pulumi.get(__response__, 'retry_sec'),
        soa_email=pulumi.get(__response__, 'soa_email'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        ttl_sec=pulumi.get(__response__, 'ttl_sec'),
        type=pulumi.get(__response__, 'type')))
