# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetFirewallsResult',
    'AwaitableGetFirewallsResult',
    'get_firewalls',
    'get_firewalls_output',
]

@pulumi.output_type
class GetFirewallsResult:
    """
    A collection of values returned by getFirewalls.
    """
    def __init__(__self__, filters=None, firewalls=None, id=None, order=None, order_by=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if firewalls and not isinstance(firewalls, list):
            raise TypeError("Expected argument 'firewalls' to be a list")
        pulumi.set(__self__, "firewalls", firewalls)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if order and not isinstance(order, str):
            raise TypeError("Expected argument 'order' to be a str")
        pulumi.set(__self__, "order", order)
        if order_by and not isinstance(order_by, str):
            raise TypeError("Expected argument 'order_by' to be a str")
        pulumi.set(__self__, "order_by", order_by)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetFirewallsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def firewalls(self) -> Optional[Sequence['outputs.GetFirewallsFirewallResult']]:
        return pulumi.get(self, "firewalls")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The unique ID assigned to this Firewall.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def order(self) -> Optional[builtins.str]:
        return pulumi.get(self, "order")

    @property
    @pulumi.getter(name="orderBy")
    def order_by(self) -> Optional[builtins.str]:
        return pulumi.get(self, "order_by")


class AwaitableGetFirewallsResult(GetFirewallsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFirewallsResult(
            filters=self.filters,
            firewalls=self.firewalls,
            id=self.id,
            order=self.order,
            order_by=self.order_by)


def get_firewalls(filters: Optional[Sequence[Union['GetFirewallsFilterArgs', 'GetFirewallsFilterArgsDict']]] = None,
                  firewalls: Optional[Sequence[Union['GetFirewallsFirewallArgs', 'GetFirewallsFirewallArgsDict']]] = None,
                  order: Optional[builtins.str] = None,
                  order_by: Optional[builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFirewallsResult:
    """
    Provides information about Linode Cloud Firewalls that match a set of filters.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-firewalls).

    ## Example Usage

    Get information about all Linode Cloud Firewalls with a certain label and visibility:

    ```python
    import pulumi
    import pulumi_linode as linode

    specific = linode.get_firewalls(filters=[
        {
            "name": "label",
            "values": ["my-firewalls"],
        },
        {
            "name": "tags",
            "values": ["my-tag"],
        },
    ])
    pulumi.export("firewallId", specific.firewalls[0].id)
    ```

    Get information about all Linode images associated with the current token:

    ```python
    import pulumi
    import pulumi_linode as linode

    all = linode.get_firewalls()
    pulumi.export("firewallIds", [__item.id for __item in all.firewalls])
    ```

    ## Firewall Rule

    * `label` - The label of this rule for display purposes only.

    * `action` - Controls whether traffic is accepted or dropped by this rule (ACCEPT, DROP).

    * `protocol` - The network protocol this rule controls. (TCP, UDP, ICMP)

    * `ports` - A string representation of ports and/or port ranges (i.e. "443" or "80-90, 91").

    * `ipv4` - A list of IPv4 addresses or networks in IP/mask format.

    * `ipv6` - A list of IPv6 addresses or networks in IP/mask format.

    ## Firewall Device

    * `id` - The unique ID of this Firewall Device assignment.

    * `entity_id` - The ID of the underlying entity this device references.

    * `type` - The type of the assigned entity.

    * `label` - The label of the assigned entity.

    * `url` - The URL of the assigned entity.

    ## Filterable Fields

    * `id`

    * `label`

    * `status`

    * `tags`


    :param builtins.str order: The order in which results should be returned. (`asc`, `desc`; default `asc`)
    :param builtins.str order_by: The attribute to order the results by. See the Filterable Fields section for a list of valid fields.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['firewalls'] = firewalls
    __args__['order'] = order
    __args__['orderBy'] = order_by
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('linode:index/getFirewalls:getFirewalls', __args__, opts=opts, typ=GetFirewallsResult).value

    return AwaitableGetFirewallsResult(
        filters=pulumi.get(__ret__, 'filters'),
        firewalls=pulumi.get(__ret__, 'firewalls'),
        id=pulumi.get(__ret__, 'id'),
        order=pulumi.get(__ret__, 'order'),
        order_by=pulumi.get(__ret__, 'order_by'))
def get_firewalls_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetFirewallsFilterArgs', 'GetFirewallsFilterArgsDict']]]]] = None,
                         firewalls: Optional[pulumi.Input[Optional[Sequence[Union['GetFirewallsFirewallArgs', 'GetFirewallsFirewallArgsDict']]]]] = None,
                         order: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                         order_by: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFirewallsResult]:
    """
    Provides information about Linode Cloud Firewalls that match a set of filters.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-firewalls).

    ## Example Usage

    Get information about all Linode Cloud Firewalls with a certain label and visibility:

    ```python
    import pulumi
    import pulumi_linode as linode

    specific = linode.get_firewalls(filters=[
        {
            "name": "label",
            "values": ["my-firewalls"],
        },
        {
            "name": "tags",
            "values": ["my-tag"],
        },
    ])
    pulumi.export("firewallId", specific.firewalls[0].id)
    ```

    Get information about all Linode images associated with the current token:

    ```python
    import pulumi
    import pulumi_linode as linode

    all = linode.get_firewalls()
    pulumi.export("firewallIds", [__item.id for __item in all.firewalls])
    ```

    ## Firewall Rule

    * `label` - The label of this rule for display purposes only.

    * `action` - Controls whether traffic is accepted or dropped by this rule (ACCEPT, DROP).

    * `protocol` - The network protocol this rule controls. (TCP, UDP, ICMP)

    * `ports` - A string representation of ports and/or port ranges (i.e. "443" or "80-90, 91").

    * `ipv4` - A list of IPv4 addresses or networks in IP/mask format.

    * `ipv6` - A list of IPv6 addresses or networks in IP/mask format.

    ## Firewall Device

    * `id` - The unique ID of this Firewall Device assignment.

    * `entity_id` - The ID of the underlying entity this device references.

    * `type` - The type of the assigned entity.

    * `label` - The label of the assigned entity.

    * `url` - The URL of the assigned entity.

    ## Filterable Fields

    * `id`

    * `label`

    * `status`

    * `tags`


    :param builtins.str order: The order in which results should be returned. (`asc`, `desc`; default `asc`)
    :param builtins.str order_by: The attribute to order the results by. See the Filterable Fields section for a list of valid fields.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['firewalls'] = firewalls
    __args__['order'] = order
    __args__['orderBy'] = order_by
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('linode:index/getFirewalls:getFirewalls', __args__, opts=opts, typ=GetFirewallsResult)
    return __ret__.apply(lambda __response__: GetFirewallsResult(
        filters=pulumi.get(__response__, 'filters'),
        firewalls=pulumi.get(__response__, 'firewalls'),
        id=pulumi.get(__response__, 'id'),
        order=pulumi.get(__response__, 'order'),
        order_by=pulumi.get(__response__, 'order_by')))
