# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetInstancesResult',
    'AwaitableGetInstancesResult',
    'get_instances',
    'get_instances_output',
]

@pulumi.output_type
class GetInstancesResult:
    """
    A collection of values returned by getInstances.
    """
    def __init__(__self__, filters=None, id=None, instances=None, order=None, order_by=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instances and not isinstance(instances, list):
            raise TypeError("Expected argument 'instances' to be a list")
        pulumi.set(__self__, "instances", instances)
        if order and not isinstance(order, str):
            raise TypeError("Expected argument 'order' to be a str")
        pulumi.set(__self__, "order", order)
        if order_by and not isinstance(order_by, str):
            raise TypeError("Expected argument 'order_by' to be a str")
        pulumi.set(__self__, "order_by", order_by)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetInstancesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.GetInstancesInstanceResult']:
        return pulumi.get(self, "instances")

    @property
    @pulumi.getter
    def order(self) -> Optional[builtins.str]:
        return pulumi.get(self, "order")

    @property
    @pulumi.getter(name="orderBy")
    def order_by(self) -> Optional[builtins.str]:
        return pulumi.get(self, "order_by")


class AwaitableGetInstancesResult(GetInstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstancesResult(
            filters=self.filters,
            id=self.id,
            instances=self.instances,
            order=self.order,
            order_by=self.order_by)


def get_instances(filters: Optional[Sequence[Union['GetInstancesFilterArgs', 'GetInstancesFilterArgsDict']]] = None,
                  order: Optional[builtins.str] = None,
                  order_by: Optional[builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstancesResult:
    """
    Provides information about Linode instances that match a set of filters.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-linode-instances).

    ## Example Usage

    Get information about all Linode instances with a certain label and tag:

    ```python
    import pulumi
    import pulumi_linode as linode

    my_instances = linode.get_instances(filters=[
        {
            "name": "label",
            "values": [
                "my-label",
                "my-other-label",
            ],
        },
        {
            "name": "tags",
            "values": ["my-tag"],
        },
    ])
    pulumi.export("instanceId", my_instances.instances[0].id)
    ```

    Get information about all Linode instances associated with the current token:

    ```python
    import pulumi
    import pulumi_linode as linode

    all_instances = linode.get_instances()
    pulumi.export("instanceIds", [__item.id for __item in all_instances.instances])
    ```

    ## Filterable Fields

    * `group`

    * `id`

    * `image`

    * `label`

    * `region`

    * `status`

    * `tags`

    * `type`

    * `watchdog_enabled`


    :param builtins.str order: The order in which results should be returned. (`asc`, `desc`; default `asc`)
    :param builtins.str order_by: The attribute to order the results by. See the Filterable Fields section for a list of valid fields.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['order'] = order
    __args__['orderBy'] = order_by
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('linode:index/getInstances:getInstances', __args__, opts=opts, typ=GetInstancesResult).value

    return AwaitableGetInstancesResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        instances=pulumi.get(__ret__, 'instances'),
        order=pulumi.get(__ret__, 'order'),
        order_by=pulumi.get(__ret__, 'order_by'))
def get_instances_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetInstancesFilterArgs', 'GetInstancesFilterArgsDict']]]]] = None,
                         order: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                         order_by: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInstancesResult]:
    """
    Provides information about Linode instances that match a set of filters.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-linode-instances).

    ## Example Usage

    Get information about all Linode instances with a certain label and tag:

    ```python
    import pulumi
    import pulumi_linode as linode

    my_instances = linode.get_instances(filters=[
        {
            "name": "label",
            "values": [
                "my-label",
                "my-other-label",
            ],
        },
        {
            "name": "tags",
            "values": ["my-tag"],
        },
    ])
    pulumi.export("instanceId", my_instances.instances[0].id)
    ```

    Get information about all Linode instances associated with the current token:

    ```python
    import pulumi
    import pulumi_linode as linode

    all_instances = linode.get_instances()
    pulumi.export("instanceIds", [__item.id for __item in all_instances.instances])
    ```

    ## Filterable Fields

    * `group`

    * `id`

    * `image`

    * `label`

    * `region`

    * `status`

    * `tags`

    * `type`

    * `watchdog_enabled`


    :param builtins.str order: The order in which results should be returned. (`asc`, `desc`; default `asc`)
    :param builtins.str order_by: The attribute to order the results by. See the Filterable Fields section for a list of valid fields.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['order'] = order
    __args__['orderBy'] = order_by
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('linode:index/getInstances:getInstances', __args__, opts=opts, typ=GetInstancesResult)
    return __ret__.apply(lambda __response__: GetInstancesResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        instances=pulumi.get(__response__, 'instances'),
        order=pulumi.get(__response__, 'order'),
        order_by=pulumi.get(__response__, 'order_by')))
