# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetIpv6RangesResult',
    'AwaitableGetIpv6RangesResult',
    'get_ipv6_ranges',
    'get_ipv6_ranges_output',
]

@pulumi.output_type
class GetIpv6RangesResult:
    """
    A collection of values returned by getIpv6Ranges.
    """
    def __init__(__self__, filters=None, id=None, ranges=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ranges and not isinstance(ranges, list):
            raise TypeError("Expected argument 'ranges' to be a list")
        pulumi.set(__self__, "ranges", ranges)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetIpv6RangesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ranges(self) -> Optional[Sequence['outputs.GetIpv6RangesRangeResult']]:
        return pulumi.get(self, "ranges")


class AwaitableGetIpv6RangesResult(GetIpv6RangesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIpv6RangesResult(
            filters=self.filters,
            id=self.id,
            ranges=self.ranges)


def get_ipv6_ranges(filters: Optional[Sequence[Union['GetIpv6RangesFilterArgs', 'GetIpv6RangesFilterArgsDict']]] = None,
                    ranges: Optional[Sequence[Union['GetIpv6RangesRangeArgs', 'GetIpv6RangesRangeArgsDict']]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIpv6RangesResult:
    """
    Provides information about Linode IPv6 ranges that match a set of filters.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-ipv6-ranges).

    > Some fields may not be accessible directly the results of this data source.
    For additional information about a specific IPv6 range consider using the Ipv6Range
    data source.

    ```python
    import pulumi
    import pulumi_linode as linode

    filtered_ranges = linode.get_ipv6_ranges(filters=[{
        "name": "region",
        "values": ["us-mia"],
    }])
    pulumi.export("ranges", filtered_ranges)
    ```

    ## Filterable Fields

    * `range`

    * `route_target`

    * `prefix`

    * `region`
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['ranges'] = ranges
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('linode:index/getIpv6Ranges:getIpv6Ranges', __args__, opts=opts, typ=GetIpv6RangesResult).value

    return AwaitableGetIpv6RangesResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        ranges=pulumi.get(__ret__, 'ranges'))
def get_ipv6_ranges_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetIpv6RangesFilterArgs', 'GetIpv6RangesFilterArgsDict']]]]] = None,
                           ranges: Optional[pulumi.Input[Optional[Sequence[Union['GetIpv6RangesRangeArgs', 'GetIpv6RangesRangeArgsDict']]]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIpv6RangesResult]:
    """
    Provides information about Linode IPv6 ranges that match a set of filters.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-ipv6-ranges).

    > Some fields may not be accessible directly the results of this data source.
    For additional information about a specific IPv6 range consider using the Ipv6Range
    data source.

    ```python
    import pulumi
    import pulumi_linode as linode

    filtered_ranges = linode.get_ipv6_ranges(filters=[{
        "name": "region",
        "values": ["us-mia"],
    }])
    pulumi.export("ranges", filtered_ranges)
    ```

    ## Filterable Fields

    * `range`

    * `route_target`

    * `prefix`

    * `region`
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['ranges'] = ranges
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('linode:index/getIpv6Ranges:getIpv6Ranges', __args__, opts=opts, typ=GetIpv6RangesResult)
    return __ret__.apply(lambda __response__: GetIpv6RangesResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        ranges=pulumi.get(__response__, 'ranges')))
