# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetLkeClustersResult',
    'AwaitableGetLkeClustersResult',
    'get_lke_clusters',
    'get_lke_clusters_output',
]

@pulumi.output_type
class GetLkeClustersResult:
    """
    A collection of values returned by getLkeClusters.
    """
    def __init__(__self__, filters=None, id=None, lke_clusters=None, order=None, order_by=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lke_clusters and not isinstance(lke_clusters, list):
            raise TypeError("Expected argument 'lke_clusters' to be a list")
        pulumi.set(__self__, "lke_clusters", lke_clusters)
        if order and not isinstance(order, str):
            raise TypeError("Expected argument 'order' to be a str")
        pulumi.set(__self__, "order", order)
        if order_by and not isinstance(order_by, str):
            raise TypeError("Expected argument 'order_by' to be a str")
        pulumi.set(__self__, "order_by", order_by)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetLkeClustersFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The LKE Cluster's ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lkeClusters")
    def lke_clusters(self) -> Optional[Sequence['outputs.GetLkeClustersLkeClusterResult']]:
        return pulumi.get(self, "lke_clusters")

    @property
    @pulumi.getter
    def order(self) -> Optional[builtins.str]:
        return pulumi.get(self, "order")

    @property
    @pulumi.getter(name="orderBy")
    def order_by(self) -> Optional[builtins.str]:
        return pulumi.get(self, "order_by")


class AwaitableGetLkeClustersResult(GetLkeClustersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLkeClustersResult(
            filters=self.filters,
            id=self.id,
            lke_clusters=self.lke_clusters,
            order=self.order,
            order_by=self.order_by)


def get_lke_clusters(filters: Optional[Sequence[Union['GetLkeClustersFilterArgs', 'GetLkeClustersFilterArgsDict']]] = None,
                     lke_clusters: Optional[Sequence[Union['GetLkeClustersLkeClusterArgs', 'GetLkeClustersLkeClusterArgsDict']]] = None,
                     order: Optional[builtins.str] = None,
                     order_by: Optional[builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLkeClustersResult:
    """
    Provides information about a list of current Linode Kubernetes (LKE) clusters on your account that match a set of filters.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-lke-clusters).

    ## Example Usage

    Get information about all LKE clusters with a specific tag:

    ```python
    import pulumi
    import pulumi_linode as linode

    specific = linode.get_lke_clusters(filters=[{
        "name": "tags",
        "values": ["test-tag"],
    }])
    pulumi.export("lkeCluster", specific.lke_clusters[0].id)
    ```

    ## Filterable Fields

    * `k8s_version`

    * `label`

    * `region`

    * `tags`

    * `status`

    * `created`

    * `updated`


    :param builtins.str order: The order in which results should be returned. (`asc`, `desc`; default `asc`)
    :param builtins.str order_by: The attribute to order the results by. See the Filterable Fields section for a list of valid fields.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['lkeClusters'] = lke_clusters
    __args__['order'] = order
    __args__['orderBy'] = order_by
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('linode:index/getLkeClusters:getLkeClusters', __args__, opts=opts, typ=GetLkeClustersResult).value

    return AwaitableGetLkeClustersResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        lke_clusters=pulumi.get(__ret__, 'lke_clusters'),
        order=pulumi.get(__ret__, 'order'),
        order_by=pulumi.get(__ret__, 'order_by'))
def get_lke_clusters_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetLkeClustersFilterArgs', 'GetLkeClustersFilterArgsDict']]]]] = None,
                            lke_clusters: Optional[pulumi.Input[Optional[Sequence[Union['GetLkeClustersLkeClusterArgs', 'GetLkeClustersLkeClusterArgsDict']]]]] = None,
                            order: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                            order_by: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLkeClustersResult]:
    """
    Provides information about a list of current Linode Kubernetes (LKE) clusters on your account that match a set of filters.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-lke-clusters).

    ## Example Usage

    Get information about all LKE clusters with a specific tag:

    ```python
    import pulumi
    import pulumi_linode as linode

    specific = linode.get_lke_clusters(filters=[{
        "name": "tags",
        "values": ["test-tag"],
    }])
    pulumi.export("lkeCluster", specific.lke_clusters[0].id)
    ```

    ## Filterable Fields

    * `k8s_version`

    * `label`

    * `region`

    * `tags`

    * `status`

    * `created`

    * `updated`


    :param builtins.str order: The order in which results should be returned. (`asc`, `desc`; default `asc`)
    :param builtins.str order_by: The attribute to order the results by. See the Filterable Fields section for a list of valid fields.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['lkeClusters'] = lke_clusters
    __args__['order'] = order
    __args__['orderBy'] = order_by
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('linode:index/getLkeClusters:getLkeClusters', __args__, opts=opts, typ=GetLkeClustersResult)
    return __ret__.apply(lambda __response__: GetLkeClustersResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        lke_clusters=pulumi.get(__response__, 'lke_clusters'),
        order=pulumi.get(__response__, 'order'),
        order_by=pulumi.get(__response__, 'order_by')))
