# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetLkeVersionsResult',
    'AwaitableGetLkeVersionsResult',
    'get_lke_versions',
    'get_lke_versions_output',
]

@pulumi.output_type
class GetLkeVersionsResult:
    """
    A collection of values returned by getLkeVersions.
    """
    def __init__(__self__, id=None, tier=None, versions=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if tier and not isinstance(tier, str):
            raise TypeError("Expected argument 'tier' to be a str")
        pulumi.set(__self__, "tier", tier)
        if versions and not isinstance(versions, list):
            raise TypeError("Expected argument 'versions' to be a list")
        pulumi.set(__self__, "versions", versions)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The Kubernetes version numbers available for deployment to a Kubernetes cluster in the format of [major].[minor], and the latest supported patch version.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def tier(self) -> Optional[builtins.str]:
        """
        The Kubernetes version tier. Only exported if `tier` was provided when using the datasource.
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter
    def versions(self) -> Optional[Sequence['outputs.GetLkeVersionsVersionResult']]:
        return pulumi.get(self, "versions")


class AwaitableGetLkeVersionsResult(GetLkeVersionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLkeVersionsResult(
            id=self.id,
            tier=self.tier,
            versions=self.versions)


def get_lke_versions(tier: Optional[builtins.str] = None,
                     versions: Optional[Sequence[Union['GetLkeVersionsVersionArgs', 'GetLkeVersionsVersionArgsDict']]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLkeVersionsResult:
    """
    Provides details about the Kubernetes versions available for deployment to a Kubernetes cluster.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-lke-versions).

    ## Example Usage

    The following example shows how one might use this data source to access information about a Linode LKE Version.

    ```python
    import pulumi
    import pulumi_linode as linode

    example = linode.get_lke_versions()
    pulumi.export("exampleOutput", example)
    pulumi.export("exampleOutputFirstVersion", example.versions[0])
    ```

    The following example shows how one might use this data source to access information about a Linode LKE Version
    with additional information about the Linode LKE Version's tier (`enterprise` or `standard`).

    > **_NOTE:_**  This functionality may not be currently available to all users and can only be used with v4beta.

    ```python
    import pulumi
    import pulumi_linode as linode

    example_enterprise = linode.get_lke_versions(tier="enterprise")
    pulumi.export("exampleEnterpriseOutput", example_enterprise)
    pulumi.export("exampleEnterpriseOutputFirstVersion", example_enterprise.versions[0])
    ```


    :param builtins.str tier: The tier (`standard` or `enterprise`) of Linode LKE Versions to fetch.
    """
    __args__ = dict()
    __args__['tier'] = tier
    __args__['versions'] = versions
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('linode:index/getLkeVersions:getLkeVersions', __args__, opts=opts, typ=GetLkeVersionsResult).value

    return AwaitableGetLkeVersionsResult(
        id=pulumi.get(__ret__, 'id'),
        tier=pulumi.get(__ret__, 'tier'),
        versions=pulumi.get(__ret__, 'versions'))
def get_lke_versions_output(tier: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                            versions: Optional[pulumi.Input[Optional[Sequence[Union['GetLkeVersionsVersionArgs', 'GetLkeVersionsVersionArgsDict']]]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLkeVersionsResult]:
    """
    Provides details about the Kubernetes versions available for deployment to a Kubernetes cluster.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-lke-versions).

    ## Example Usage

    The following example shows how one might use this data source to access information about a Linode LKE Version.

    ```python
    import pulumi
    import pulumi_linode as linode

    example = linode.get_lke_versions()
    pulumi.export("exampleOutput", example)
    pulumi.export("exampleOutputFirstVersion", example.versions[0])
    ```

    The following example shows how one might use this data source to access information about a Linode LKE Version
    with additional information about the Linode LKE Version's tier (`enterprise` or `standard`).

    > **_NOTE:_**  This functionality may not be currently available to all users and can only be used with v4beta.

    ```python
    import pulumi
    import pulumi_linode as linode

    example_enterprise = linode.get_lke_versions(tier="enterprise")
    pulumi.export("exampleEnterpriseOutput", example_enterprise)
    pulumi.export("exampleEnterpriseOutputFirstVersion", example_enterprise.versions[0])
    ```


    :param builtins.str tier: The tier (`standard` or `enterprise`) of Linode LKE Versions to fetch.
    """
    __args__ = dict()
    __args__['tier'] = tier
    __args__['versions'] = versions
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('linode:index/getLkeVersions:getLkeVersions', __args__, opts=opts, typ=GetLkeVersionsResult)
    return __ret__.apply(lambda __response__: GetLkeVersionsResult(
        id=pulumi.get(__response__, 'id'),
        tier=pulumi.get(__response__, 'tier'),
        versions=pulumi.get(__response__, 'versions')))
