# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetNetworkTransferPricesResult',
    'AwaitableGetNetworkTransferPricesResult',
    'get_network_transfer_prices',
    'get_network_transfer_prices_output',
]

@pulumi.output_type
class GetNetworkTransferPricesResult:
    """
    A collection of values returned by getNetworkTransferPrices.
    """
    def __init__(__self__, filters=None, id=None, order=None, order_by=None, types=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if order and not isinstance(order, str):
            raise TypeError("Expected argument 'order' to be a str")
        pulumi.set(__self__, "order", order)
        if order_by and not isinstance(order_by, str):
            raise TypeError("Expected argument 'order_by' to be a str")
        pulumi.set(__self__, "order_by", order_by)
        if types and not isinstance(types, list):
            raise TypeError("Expected argument 'types' to be a list")
        pulumi.set(__self__, "types", types)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetNetworkTransferPricesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID representing the Network Transfer Price.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def order(self) -> Optional[builtins.str]:
        return pulumi.get(self, "order")

    @property
    @pulumi.getter(name="orderBy")
    def order_by(self) -> Optional[builtins.str]:
        return pulumi.get(self, "order_by")

    @property
    @pulumi.getter
    def types(self) -> Optional[Sequence['outputs.GetNetworkTransferPricesTypeResult']]:
        return pulumi.get(self, "types")


class AwaitableGetNetworkTransferPricesResult(GetNetworkTransferPricesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkTransferPricesResult(
            filters=self.filters,
            id=self.id,
            order=self.order,
            order_by=self.order_by,
            types=self.types)


def get_network_transfer_prices(filters: Optional[Sequence[Union['GetNetworkTransferPricesFilterArgs', 'GetNetworkTransferPricesFilterArgsDict']]] = None,
                                order: Optional[builtins.str] = None,
                                order_by: Optional[builtins.str] = None,
                                types: Optional[Sequence[Union['GetNetworkTransferPricesTypeArgs', 'GetNetworkTransferPricesTypeArgsDict']]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkTransferPricesResult:
    """
    Provides information about Linode Network Transfer Prices that match a set of filters.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-network-transfer-prices).


    :param builtins.str order: The order in which results should be returned. (`asc`, `desc`; default `asc`)
    :param builtins.str order_by: The attribute to order the results by. See the Filterable Fields section for a list of valid fields.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['order'] = order
    __args__['orderBy'] = order_by
    __args__['types'] = types
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('linode:index/getNetworkTransferPrices:getNetworkTransferPrices', __args__, opts=opts, typ=GetNetworkTransferPricesResult).value

    return AwaitableGetNetworkTransferPricesResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        order=pulumi.get(__ret__, 'order'),
        order_by=pulumi.get(__ret__, 'order_by'),
        types=pulumi.get(__ret__, 'types'))
def get_network_transfer_prices_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetNetworkTransferPricesFilterArgs', 'GetNetworkTransferPricesFilterArgsDict']]]]] = None,
                                       order: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                       order_by: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                       types: Optional[pulumi.Input[Optional[Sequence[Union['GetNetworkTransferPricesTypeArgs', 'GetNetworkTransferPricesTypeArgsDict']]]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNetworkTransferPricesResult]:
    """
    Provides information about Linode Network Transfer Prices that match a set of filters.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-network-transfer-prices).


    :param builtins.str order: The order in which results should be returned. (`asc`, `desc`; default `asc`)
    :param builtins.str order_by: The attribute to order the results by. See the Filterable Fields section for a list of valid fields.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['order'] = order
    __args__['orderBy'] = order_by
    __args__['types'] = types
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('linode:index/getNetworkTransferPrices:getNetworkTransferPrices', __args__, opts=opts, typ=GetNetworkTransferPricesResult)
    return __ret__.apply(lambda __response__: GetNetworkTransferPricesResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        order=pulumi.get(__response__, 'order'),
        order_by=pulumi.get(__response__, 'order_by'),
        types=pulumi.get(__response__, 'types')))
