# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetNodeBalancerConfigResult',
    'AwaitableGetNodeBalancerConfigResult',
    'get_node_balancer_config',
    'get_node_balancer_config_output',
]

@pulumi.output_type
class GetNodeBalancerConfigResult:
    """
    A collection of values returned by getNodeBalancerConfig.
    """
    def __init__(__self__, algorithm=None, check=None, check_attempts=None, check_body=None, check_interval=None, check_passive=None, check_path=None, check_timeout=None, cipher_suite=None, id=None, node_statuses=None, nodebalancer_id=None, port=None, protocol=None, proxy_protocol=None, ssl_commonname=None, ssl_fingerprint=None, stickiness=None, udp_check_port=None, udp_session_timeout=None):
        if algorithm and not isinstance(algorithm, str):
            raise TypeError("Expected argument 'algorithm' to be a str")
        pulumi.set(__self__, "algorithm", algorithm)
        if check and not isinstance(check, str):
            raise TypeError("Expected argument 'check' to be a str")
        pulumi.set(__self__, "check", check)
        if check_attempts and not isinstance(check_attempts, int):
            raise TypeError("Expected argument 'check_attempts' to be a int")
        pulumi.set(__self__, "check_attempts", check_attempts)
        if check_body and not isinstance(check_body, str):
            raise TypeError("Expected argument 'check_body' to be a str")
        pulumi.set(__self__, "check_body", check_body)
        if check_interval and not isinstance(check_interval, int):
            raise TypeError("Expected argument 'check_interval' to be a int")
        pulumi.set(__self__, "check_interval", check_interval)
        if check_passive and not isinstance(check_passive, bool):
            raise TypeError("Expected argument 'check_passive' to be a bool")
        pulumi.set(__self__, "check_passive", check_passive)
        if check_path and not isinstance(check_path, str):
            raise TypeError("Expected argument 'check_path' to be a str")
        pulumi.set(__self__, "check_path", check_path)
        if check_timeout and not isinstance(check_timeout, int):
            raise TypeError("Expected argument 'check_timeout' to be a int")
        pulumi.set(__self__, "check_timeout", check_timeout)
        if cipher_suite and not isinstance(cipher_suite, str):
            raise TypeError("Expected argument 'cipher_suite' to be a str")
        pulumi.set(__self__, "cipher_suite", cipher_suite)
        if id and not isinstance(id, int):
            raise TypeError("Expected argument 'id' to be a int")
        pulumi.set(__self__, "id", id)
        if node_statuses and not isinstance(node_statuses, list):
            raise TypeError("Expected argument 'node_statuses' to be a list")
        pulumi.set(__self__, "node_statuses", node_statuses)
        if nodebalancer_id and not isinstance(nodebalancer_id, int):
            raise TypeError("Expected argument 'nodebalancer_id' to be a int")
        pulumi.set(__self__, "nodebalancer_id", nodebalancer_id)
        if port and not isinstance(port, int):
            raise TypeError("Expected argument 'port' to be a int")
        pulumi.set(__self__, "port", port)
        if protocol and not isinstance(protocol, str):
            raise TypeError("Expected argument 'protocol' to be a str")
        pulumi.set(__self__, "protocol", protocol)
        if proxy_protocol and not isinstance(proxy_protocol, str):
            raise TypeError("Expected argument 'proxy_protocol' to be a str")
        pulumi.set(__self__, "proxy_protocol", proxy_protocol)
        if ssl_commonname and not isinstance(ssl_commonname, str):
            raise TypeError("Expected argument 'ssl_commonname' to be a str")
        pulumi.set(__self__, "ssl_commonname", ssl_commonname)
        if ssl_fingerprint and not isinstance(ssl_fingerprint, str):
            raise TypeError("Expected argument 'ssl_fingerprint' to be a str")
        pulumi.set(__self__, "ssl_fingerprint", ssl_fingerprint)
        if stickiness and not isinstance(stickiness, str):
            raise TypeError("Expected argument 'stickiness' to be a str")
        pulumi.set(__self__, "stickiness", stickiness)
        if udp_check_port and not isinstance(udp_check_port, int):
            raise TypeError("Expected argument 'udp_check_port' to be a int")
        pulumi.set(__self__, "udp_check_port", udp_check_port)
        if udp_session_timeout and not isinstance(udp_session_timeout, int):
            raise TypeError("Expected argument 'udp_session_timeout' to be a int")
        pulumi.set(__self__, "udp_session_timeout", udp_session_timeout)

    @property
    @pulumi.getter
    def algorithm(self) -> builtins.str:
        """
        What algorithm this NodeBalancer should use for routing traffic to backends (`roundrobin`, `leastconn`, `source`)
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter
    def check(self) -> builtins.str:
        """
        The type of check to perform against backends to ensure they are serving requests. This is used to determine if backends are up or down. If none no check is performed. connection requires only a connection to the backend to succeed. http and http_body rely on the backend serving HTTP, and that the response returned matches what is expected. (`none`, `connection`, `http`, `http_body`)
        """
        return pulumi.get(self, "check")

    @property
    @pulumi.getter(name="checkAttempts")
    def check_attempts(self) -> builtins.int:
        """
        How many times to attempt a check before considering a backend to be down. (1-30)
        """
        return pulumi.get(self, "check_attempts")

    @property
    @pulumi.getter(name="checkBody")
    def check_body(self) -> builtins.str:
        return pulumi.get(self, "check_body")

    @property
    @pulumi.getter(name="checkInterval")
    def check_interval(self) -> builtins.int:
        """
        How often, in seconds, to check that backends are up and serving requests.
        """
        return pulumi.get(self, "check_interval")

    @property
    @pulumi.getter(name="checkPassive")
    def check_passive(self) -> builtins.bool:
        """
        If true, any response from this backend with a 5xx status code will be enough for it to be considered unhealthy and taken out of rotation.
        """
        return pulumi.get(self, "check_passive")

    @property
    @pulumi.getter(name="checkPath")
    def check_path(self) -> builtins.str:
        """
        The URL path to check on each backend. If the backend does not respond to this request it is considered to be down.
        """
        return pulumi.get(self, "check_path")

    @property
    @pulumi.getter(name="checkTimeout")
    def check_timeout(self) -> builtins.int:
        """
        How long, in seconds, to wait for a check attempt before considering it failed. (1-30)
        """
        return pulumi.get(self, "check_timeout")

    @property
    @pulumi.getter(name="cipherSuite")
    def cipher_suite(self) -> builtins.str:
        """
        What ciphers to use for SSL connections served by this NodeBalancer. `legacy` is considered insecure and should only be used if necessary. (`recommended`, `legacy`)
        """
        return pulumi.get(self, "cipher_suite")

    @property
    @pulumi.getter
    def id(self) -> builtins.int:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="nodeStatuses")
    def node_statuses(self) -> Sequence['outputs.GetNodeBalancerConfigNodeStatusResult']:
        return pulumi.get(self, "node_statuses")

    @property
    @pulumi.getter(name="nodebalancerId")
    def nodebalancer_id(self) -> builtins.int:
        return pulumi.get(self, "nodebalancer_id")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        The TCP port this Config is for.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> builtins.str:
        """
        The protocol this port is configured to serve. If this is set to https you must include an ssl_cert and an ssl_key. (`http`, `https`, `tcp`) (Defaults to `http`)
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="proxyProtocol")
    def proxy_protocol(self) -> builtins.str:
        """
        The version of ProxyProtocol to use for the underlying NodeBalancer. This requires protocol to be `tcp`. (`none`, `v1`, and `v2`) (Defaults to `none`)
        """
        return pulumi.get(self, "proxy_protocol")

    @property
    @pulumi.getter(name="sslCommonname")
    def ssl_commonname(self) -> builtins.str:
        """
        The read-only common name automatically derived from the SSL certificate assigned to this NodeBalancerConfig. Please refer to this field to verify that the appropriate certificate is assigned to your NodeBalancerConfig.
        """
        return pulumi.get(self, "ssl_commonname")

    @property
    @pulumi.getter(name="sslFingerprint")
    def ssl_fingerprint(self) -> builtins.str:
        """
        The read-only fingerprint automatically derived from the SSL certificate assigned to this NodeBalancerConfig. Please refer to this field to verify that the appropriate certificate is assigned to your NodeBalancerConfig.
        """
        return pulumi.get(self, "ssl_fingerprint")

    @property
    @pulumi.getter
    def stickiness(self) -> builtins.str:
        """
        Controls how session stickiness is handled on this port. (`none`, `table`, `http_cookie`)
        """
        return pulumi.get(self, "stickiness")

    @property
    @pulumi.getter(name="udpCheckPort")
    def udp_check_port(self) -> builtins.int:
        """
        Specifies the port on the backend node used for active health checks, which may differ from the port serving traffic.
        """
        return pulumi.get(self, "udp_check_port")

    @property
    @pulumi.getter(name="udpSessionTimeout")
    def udp_session_timeout(self) -> builtins.int:
        """
        The idle time in seconds after which a session that hasn’t received packets is destroyed.
        """
        return pulumi.get(self, "udp_session_timeout")


class AwaitableGetNodeBalancerConfigResult(GetNodeBalancerConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNodeBalancerConfigResult(
            algorithm=self.algorithm,
            check=self.check,
            check_attempts=self.check_attempts,
            check_body=self.check_body,
            check_interval=self.check_interval,
            check_passive=self.check_passive,
            check_path=self.check_path,
            check_timeout=self.check_timeout,
            cipher_suite=self.cipher_suite,
            id=self.id,
            node_statuses=self.node_statuses,
            nodebalancer_id=self.nodebalancer_id,
            port=self.port,
            protocol=self.protocol,
            proxy_protocol=self.proxy_protocol,
            ssl_commonname=self.ssl_commonname,
            ssl_fingerprint=self.ssl_fingerprint,
            stickiness=self.stickiness,
            udp_check_port=self.udp_check_port,
            udp_session_timeout=self.udp_session_timeout)


def get_node_balancer_config(id: Optional[builtins.int] = None,
                             nodebalancer_id: Optional[builtins.int] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNodeBalancerConfigResult:
    """
    Provides details about a Linode NodeBalancer Config.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-node-balancer-config).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_linode as linode

    my_config = linode.get_node_balancer_config(id=123,
        nodebalancer_id=456)
    ```


    :param builtins.int id: The config's ID.
    :param builtins.int nodebalancer_id: The ID of the NodeBalancer that contains the config.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['nodebalancerId'] = nodebalancer_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('linode:index/getNodeBalancerConfig:getNodeBalancerConfig', __args__, opts=opts, typ=GetNodeBalancerConfigResult).value

    return AwaitableGetNodeBalancerConfigResult(
        algorithm=pulumi.get(__ret__, 'algorithm'),
        check=pulumi.get(__ret__, 'check'),
        check_attempts=pulumi.get(__ret__, 'check_attempts'),
        check_body=pulumi.get(__ret__, 'check_body'),
        check_interval=pulumi.get(__ret__, 'check_interval'),
        check_passive=pulumi.get(__ret__, 'check_passive'),
        check_path=pulumi.get(__ret__, 'check_path'),
        check_timeout=pulumi.get(__ret__, 'check_timeout'),
        cipher_suite=pulumi.get(__ret__, 'cipher_suite'),
        id=pulumi.get(__ret__, 'id'),
        node_statuses=pulumi.get(__ret__, 'node_statuses'),
        nodebalancer_id=pulumi.get(__ret__, 'nodebalancer_id'),
        port=pulumi.get(__ret__, 'port'),
        protocol=pulumi.get(__ret__, 'protocol'),
        proxy_protocol=pulumi.get(__ret__, 'proxy_protocol'),
        ssl_commonname=pulumi.get(__ret__, 'ssl_commonname'),
        ssl_fingerprint=pulumi.get(__ret__, 'ssl_fingerprint'),
        stickiness=pulumi.get(__ret__, 'stickiness'),
        udp_check_port=pulumi.get(__ret__, 'udp_check_port'),
        udp_session_timeout=pulumi.get(__ret__, 'udp_session_timeout'))
def get_node_balancer_config_output(id: Optional[pulumi.Input[builtins.int]] = None,
                                    nodebalancer_id: Optional[pulumi.Input[builtins.int]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNodeBalancerConfigResult]:
    """
    Provides details about a Linode NodeBalancer Config.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-node-balancer-config).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_linode as linode

    my_config = linode.get_node_balancer_config(id=123,
        nodebalancer_id=456)
    ```


    :param builtins.int id: The config's ID.
    :param builtins.int nodebalancer_id: The ID of the NodeBalancer that contains the config.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['nodebalancerId'] = nodebalancer_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('linode:index/getNodeBalancerConfig:getNodeBalancerConfig', __args__, opts=opts, typ=GetNodeBalancerConfigResult)
    return __ret__.apply(lambda __response__: GetNodeBalancerConfigResult(
        algorithm=pulumi.get(__response__, 'algorithm'),
        check=pulumi.get(__response__, 'check'),
        check_attempts=pulumi.get(__response__, 'check_attempts'),
        check_body=pulumi.get(__response__, 'check_body'),
        check_interval=pulumi.get(__response__, 'check_interval'),
        check_passive=pulumi.get(__response__, 'check_passive'),
        check_path=pulumi.get(__response__, 'check_path'),
        check_timeout=pulumi.get(__response__, 'check_timeout'),
        cipher_suite=pulumi.get(__response__, 'cipher_suite'),
        id=pulumi.get(__response__, 'id'),
        node_statuses=pulumi.get(__response__, 'node_statuses'),
        nodebalancer_id=pulumi.get(__response__, 'nodebalancer_id'),
        port=pulumi.get(__response__, 'port'),
        protocol=pulumi.get(__response__, 'protocol'),
        proxy_protocol=pulumi.get(__response__, 'proxy_protocol'),
        ssl_commonname=pulumi.get(__response__, 'ssl_commonname'),
        ssl_fingerprint=pulumi.get(__response__, 'ssl_fingerprint'),
        stickiness=pulumi.get(__response__, 'stickiness'),
        udp_check_port=pulumi.get(__response__, 'udp_check_port'),
        udp_session_timeout=pulumi.get(__response__, 'udp_session_timeout')))
