# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetObjectStorageClusterResult',
    'AwaitableGetObjectStorageClusterResult',
    'get_object_storage_cluster',
    'get_object_storage_cluster_output',
]

@pulumi.output_type
class GetObjectStorageClusterResult:
    """
    A collection of values returned by getObjectStorageCluster.
    """
    def __init__(__self__, domain=None, id=None, region=None, static_site_domain=None, status=None):
        if domain and not isinstance(domain, str):
            raise TypeError("Expected argument 'domain' to be a str")
        pulumi.set(__self__, "domain", domain)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if static_site_domain and not isinstance(static_site_domain, str):
            raise TypeError("Expected argument 'static_site_domain' to be a str")
        pulumi.set(__self__, "static_site_domain", static_site_domain)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def domain(self) -> builtins.str:
        """
        The base URL for this cluster.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        The region this cluster is located in. See all regions [here](https://api.linode.com/v4/regions).
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="staticSiteDomain")
    def static_site_domain(self) -> builtins.str:
        """
        The base URL for this cluster used when hosting static sites.
        """
        return pulumi.get(self, "static_site_domain")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        This cluster's status. (`available`, `unavailable`)
        """
        return pulumi.get(self, "status")


class AwaitableGetObjectStorageClusterResult(GetObjectStorageClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetObjectStorageClusterResult(
            domain=self.domain,
            id=self.id,
            region=self.region,
            static_site_domain=self.static_site_domain,
            status=self.status)


def get_object_storage_cluster(id: Optional[builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetObjectStorageClusterResult:
    """
    Provides information about a Linode Object Storage Cluster
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-object-storage-cluster).

    ## Example Usage

    The following example shows how one might use this data source to access information about a Linode Object Storage Cluster.

    ```python
    import pulumi
    import pulumi_linode as linode

    primary = linode.get_object_storage_cluster(id="us-east-1")
    ```


    :param builtins.str id: The unique ID of this cluster.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('linode:index/getObjectStorageCluster:getObjectStorageCluster', __args__, opts=opts, typ=GetObjectStorageClusterResult).value

    return AwaitableGetObjectStorageClusterResult(
        domain=pulumi.get(__ret__, 'domain'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'),
        static_site_domain=pulumi.get(__ret__, 'static_site_domain'),
        status=pulumi.get(__ret__, 'status'))
def get_object_storage_cluster_output(id: Optional[pulumi.Input[builtins.str]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetObjectStorageClusterResult]:
    """
    Provides information about a Linode Object Storage Cluster
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-object-storage-cluster).

    ## Example Usage

    The following example shows how one might use this data source to access information about a Linode Object Storage Cluster.

    ```python
    import pulumi
    import pulumi_linode as linode

    primary = linode.get_object_storage_cluster(id="us-east-1")
    ```


    :param builtins.str id: The unique ID of this cluster.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('linode:index/getObjectStorageCluster:getObjectStorageCluster', __args__, opts=opts, typ=GetObjectStorageClusterResult)
    return __ret__.apply(lambda __response__: GetObjectStorageClusterResult(
        domain=pulumi.get(__response__, 'domain'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region'),
        static_site_domain=pulumi.get(__response__, 'static_site_domain'),
        status=pulumi.get(__response__, 'status')))
