# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetObjectStorageQuotaResult',
    'AwaitableGetObjectStorageQuotaResult',
    'get_object_storage_quota',
    'get_object_storage_quota_output',
]

@pulumi.output_type
class GetObjectStorageQuotaResult:
    """
    A collection of values returned by getObjectStorageQuota.
    """
    def __init__(__self__, description=None, endpoint_type=None, id=None, quota_id=None, quota_limit=None, quota_name=None, quota_usage=None, resource_metric=None, s3_endpoint=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if endpoint_type and not isinstance(endpoint_type, str):
            raise TypeError("Expected argument 'endpoint_type' to be a str")
        pulumi.set(__self__, "endpoint_type", endpoint_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if quota_id and not isinstance(quota_id, str):
            raise TypeError("Expected argument 'quota_id' to be a str")
        pulumi.set(__self__, "quota_id", quota_id)
        if quota_limit and not isinstance(quota_limit, int):
            raise TypeError("Expected argument 'quota_limit' to be a int")
        pulumi.set(__self__, "quota_limit", quota_limit)
        if quota_name and not isinstance(quota_name, str):
            raise TypeError("Expected argument 'quota_name' to be a str")
        pulumi.set(__self__, "quota_name", quota_name)
        if quota_usage and not isinstance(quota_usage, dict):
            raise TypeError("Expected argument 'quota_usage' to be a dict")
        pulumi.set(__self__, "quota_usage", quota_usage)
        if resource_metric and not isinstance(resource_metric, str):
            raise TypeError("Expected argument 'resource_metric' to be a str")
        pulumi.set(__self__, "resource_metric", resource_metric)
        if s3_endpoint and not isinstance(s3_endpoint, str):
            raise TypeError("Expected argument 's3_endpoint' to be a str")
        pulumi.set(__self__, "s3_endpoint", s3_endpoint)

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description of the Object Storage quota.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> builtins.str:
        """
        The type of the S3 endpoint of the Object Storage.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The unique ID of the Object Storage quota data source.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="quotaId")
    def quota_id(self) -> builtins.str:
        return pulumi.get(self, "quota_id")

    @property
    @pulumi.getter(name="quotaLimit")
    def quota_limit(self) -> builtins.int:
        """
        The maximum quantity allowed by the quota.
        """
        return pulumi.get(self, "quota_limit")

    @property
    @pulumi.getter(name="quotaName")
    def quota_name(self) -> builtins.str:
        """
        The name of the Object Storage quota.
        """
        return pulumi.get(self, "quota_name")

    @property
    @pulumi.getter(name="quotaUsage")
    def quota_usage(self) -> 'outputs.GetObjectStorageQuotaQuotaUsageResult':
        """
        The usage data for a specific Object Storage related quota on your account. For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-object-storage-quota-usage).
        """
        return pulumi.get(self, "quota_usage")

    @property
    @pulumi.getter(name="resourceMetric")
    def resource_metric(self) -> builtins.str:
        """
        The specific Object Storage resource for the quota.
        """
        return pulumi.get(self, "resource_metric")

    @property
    @pulumi.getter(name="s3Endpoint")
    def s3_endpoint(self) -> builtins.str:
        """
        The S3 endpoint URL of the Object Storage, based on the `endpoint_type` and `region`.
        """
        return pulumi.get(self, "s3_endpoint")


class AwaitableGetObjectStorageQuotaResult(GetObjectStorageQuotaResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetObjectStorageQuotaResult(
            description=self.description,
            endpoint_type=self.endpoint_type,
            id=self.id,
            quota_id=self.quota_id,
            quota_limit=self.quota_limit,
            quota_name=self.quota_name,
            quota_usage=self.quota_usage,
            resource_metric=self.resource_metric,
            s3_endpoint=self.s3_endpoint)


def get_object_storage_quota(quota_id: Optional[builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetObjectStorageQuotaResult:
    """
    Provides details about Object Storage quota information on your account.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-object-storage-quota).

    ## Example Usage

    The following example shows how one might use this data source to access information about an Object Storage quota.

    ```python
    import pulumi
    import pulumi_linode as linode

    my_quota = linode.get_object_storage_quota(quota_id="obj-buckets-br-gru-1.linodeobjects.com")
    ```


    :param builtins.str quota_id: The Object Storage quota ID.
    """
    __args__ = dict()
    __args__['quotaId'] = quota_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('linode:index/getObjectStorageQuota:getObjectStorageQuota', __args__, opts=opts, typ=GetObjectStorageQuotaResult).value

    return AwaitableGetObjectStorageQuotaResult(
        description=pulumi.get(__ret__, 'description'),
        endpoint_type=pulumi.get(__ret__, 'endpoint_type'),
        id=pulumi.get(__ret__, 'id'),
        quota_id=pulumi.get(__ret__, 'quota_id'),
        quota_limit=pulumi.get(__ret__, 'quota_limit'),
        quota_name=pulumi.get(__ret__, 'quota_name'),
        quota_usage=pulumi.get(__ret__, 'quota_usage'),
        resource_metric=pulumi.get(__ret__, 'resource_metric'),
        s3_endpoint=pulumi.get(__ret__, 's3_endpoint'))
def get_object_storage_quota_output(quota_id: Optional[pulumi.Input[builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetObjectStorageQuotaResult]:
    """
    Provides details about Object Storage quota information on your account.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-object-storage-quota).

    ## Example Usage

    The following example shows how one might use this data source to access information about an Object Storage quota.

    ```python
    import pulumi
    import pulumi_linode as linode

    my_quota = linode.get_object_storage_quota(quota_id="obj-buckets-br-gru-1.linodeobjects.com")
    ```


    :param builtins.str quota_id: The Object Storage quota ID.
    """
    __args__ = dict()
    __args__['quotaId'] = quota_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('linode:index/getObjectStorageQuota:getObjectStorageQuota', __args__, opts=opts, typ=GetObjectStorageQuotaResult)
    return __ret__.apply(lambda __response__: GetObjectStorageQuotaResult(
        description=pulumi.get(__response__, 'description'),
        endpoint_type=pulumi.get(__response__, 'endpoint_type'),
        id=pulumi.get(__response__, 'id'),
        quota_id=pulumi.get(__response__, 'quota_id'),
        quota_limit=pulumi.get(__response__, 'quota_limit'),
        quota_name=pulumi.get(__response__, 'quota_name'),
        quota_usage=pulumi.get(__response__, 'quota_usage'),
        resource_metric=pulumi.get(__response__, 'resource_metric'),
        s3_endpoint=pulumi.get(__response__, 's3_endpoint')))
