# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVlansResult',
    'AwaitableGetVlansResult',
    'get_vlans',
    'get_vlans_output',
]

@pulumi.output_type
class GetVlansResult:
    """
    A collection of values returned by getVlans.
    """
    def __init__(__self__, filters=None, id=None, order=None, order_by=None, vlans=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if order and not isinstance(order, str):
            raise TypeError("Expected argument 'order' to be a str")
        pulumi.set(__self__, "order", order)
        if order_by and not isinstance(order_by, str):
            raise TypeError("Expected argument 'order_by' to be a str")
        pulumi.set(__self__, "order_by", order_by)
        if vlans and not isinstance(vlans, list):
            raise TypeError("Expected argument 'vlans' to be a list")
        pulumi.set(__self__, "vlans", vlans)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetVlansFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def order(self) -> Optional[builtins.str]:
        return pulumi.get(self, "order")

    @property
    @pulumi.getter(name="orderBy")
    def order_by(self) -> Optional[builtins.str]:
        return pulumi.get(self, "order_by")

    @property
    @pulumi.getter
    def vlans(self) -> Optional[Sequence['outputs.GetVlansVlanResult']]:
        return pulumi.get(self, "vlans")


class AwaitableGetVlansResult(GetVlansResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVlansResult(
            filters=self.filters,
            id=self.id,
            order=self.order,
            order_by=self.order_by,
            vlans=self.vlans)


def get_vlans(filters: Optional[Sequence[Union['GetVlansFilterArgs', 'GetVlansFilterArgsDict']]] = None,
              order: Optional[builtins.str] = None,
              order_by: Optional[builtins.str] = None,
              vlans: Optional[Sequence[Union['GetVlansVlanArgs', 'GetVlansVlanArgsDict']]] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVlansResult:
    """
    > **Beta Notice** VLANs are currently available through early access.
    To use early access resources, the `api_version` provider argument must be set to `v4beta`.
    To learn more, see the early access documentation.

    Provides details about Linode VLANs.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-vlans).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_linode as linode

    my_instance = linode.Instance("my_instance",
        label="my_instance",
        image="linode/ubuntu22.04",
        region="us-southeast",
        type="g6-standard-1",
        root_pass="bogusPassword$",
        interfaces=[{
            "purpose": "vlan",
            "label": "my-vlan",
        }])
    my_vlans = linode.get_vlans(filters=[{
        "name": "label",
        "values": ["my-vlan"],
    }])
    pulumi.export("vlanLinodes", my_vlans.vlans[0].linodes)
    ```

    ## Filterable Fields

    * `label`

    * `region`


    :param builtins.str order: The order in which results should be returned. (`asc`, `desc`; default `asc`)
    :param builtins.str order_by: The attribute to order the results by. See the Filterable Fields section for a list of valid fields.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['order'] = order
    __args__['orderBy'] = order_by
    __args__['vlans'] = vlans
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('linode:index/getVlans:getVlans', __args__, opts=opts, typ=GetVlansResult).value

    return AwaitableGetVlansResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        order=pulumi.get(__ret__, 'order'),
        order_by=pulumi.get(__ret__, 'order_by'),
        vlans=pulumi.get(__ret__, 'vlans'))
def get_vlans_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetVlansFilterArgs', 'GetVlansFilterArgsDict']]]]] = None,
                     order: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                     order_by: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                     vlans: Optional[pulumi.Input[Optional[Sequence[Union['GetVlansVlanArgs', 'GetVlansVlanArgsDict']]]]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVlansResult]:
    """
    > **Beta Notice** VLANs are currently available through early access.
    To use early access resources, the `api_version` provider argument must be set to `v4beta`.
    To learn more, see the early access documentation.

    Provides details about Linode VLANs.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-vlans).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_linode as linode

    my_instance = linode.Instance("my_instance",
        label="my_instance",
        image="linode/ubuntu22.04",
        region="us-southeast",
        type="g6-standard-1",
        root_pass="bogusPassword$",
        interfaces=[{
            "purpose": "vlan",
            "label": "my-vlan",
        }])
    my_vlans = linode.get_vlans(filters=[{
        "name": "label",
        "values": ["my-vlan"],
    }])
    pulumi.export("vlanLinodes", my_vlans.vlans[0].linodes)
    ```

    ## Filterable Fields

    * `label`

    * `region`


    :param builtins.str order: The order in which results should be returned. (`asc`, `desc`; default `asc`)
    :param builtins.str order_by: The attribute to order the results by. See the Filterable Fields section for a list of valid fields.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['order'] = order
    __args__['orderBy'] = order_by
    __args__['vlans'] = vlans
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('linode:index/getVlans:getVlans', __args__, opts=opts, typ=GetVlansResult)
    return __ret__.apply(lambda __response__: GetVlansResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        order=pulumi.get(__response__, 'order'),
        order_by=pulumi.get(__response__, 'order_by'),
        vlans=pulumi.get(__response__, 'vlans')))
