# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ObjectStorageBucketArgs', 'ObjectStorageBucket']

@pulumi.input_type
class ObjectStorageBucketArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[builtins.str],
                 access_key: Optional[pulumi.Input[builtins.str]] = None,
                 acl: Optional[pulumi.Input[builtins.str]] = None,
                 cert: Optional[pulumi.Input['ObjectStorageBucketCertArgs']] = None,
                 cluster: Optional[pulumi.Input[builtins.str]] = None,
                 cors_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 endpoint_type: Optional[pulumi.Input[builtins.str]] = None,
                 lifecycle_rules: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectStorageBucketLifecycleRuleArgs']]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 s3_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[builtins.str]] = None,
                 versioning: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a ObjectStorageBucket resource.
        :param pulumi.Input[builtins.str] label: The label of the Linode Object Storage Bucket.
        :param pulumi.Input[builtins.str] access_key: The access key to authenticate with. If not specified with the resource, its value can be
               * configured by `obj_access_key` in the provider configuration;
               * or, generated implicitly at apply-time if `obj_use_temp_keys` at provider-level is set.
        :param pulumi.Input[builtins.str] acl: The Access Control Level of the bucket using a canned ACL string. See all ACL strings [in the Linode API v4 documentation](https://techdocs.akamai.com/linode-api/reference/post-object-storage-bucket).
        :param pulumi.Input['ObjectStorageBucketCertArgs'] cert: The cert used by this Object Storage Bucket.
        :param pulumi.Input[builtins.str] cluster: The cluster of the Linode Object Storage Bucket. This is deprecated in favor of `region` attribute.
               For example, `us-mia-1` cluster can be translated into `us-mia` region. Exactly one of `region` and `cluster` is required for creating a bucket.
        :param pulumi.Input[builtins.bool] cors_enabled: If true, the bucket will have CORS enabled for all origins.
        :param pulumi.Input[builtins.str] endpoint_type: The type of `s3_endpoint` available to the user in this region. See [Endpoint types](https://techdocs.akamai.com/cloud-computing/docs/object-storage#endpoint-type) for more information.
        :param pulumi.Input[Sequence[pulumi.Input['ObjectStorageBucketLifecycleRuleArgs']]] lifecycle_rules: Lifecycle rules to be applied to the bucket.
        :param pulumi.Input[builtins.str] region: The region of the Linode Object Storage Bucket. Exactly one of `region` and `cluster` is required for creating a bucket.
        :param pulumi.Input[builtins.str] s3_endpoint: The user's s3 endpoint URL, based on the `endpoint_type` and `region`.
        :param pulumi.Input[builtins.str] secret_key: The secret key to authenticate with. If not specified with the resource, its value can be
               * configured by `obj_secret_key` in the provider configuration;
               * or, generated implicitly at apply-time if `obj_use_temp_keys` at provider-level is set.
        :param pulumi.Input[builtins.bool] versioning: Whether to enable versioning. Once you version-enable a bucket, it can never return to an unversioned state. You can, however, suspend versioning on that bucket. (Requires `access_key` and `secret_key`)
               
               * `lifecycle_rule` - (Optional) Lifecycle rules to be applied to the bucket. (Requires `access_key` and `secret_key`)
               
               * `cert` - (Optional) The bucket's TLS/SSL certificate.
        """
        pulumi.set(__self__, "label", label)
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if cluster is not None:
            warnings.warn("""The cluster attribute has been deprecated, please consider switching to the region attribute. For example, a cluster value of `us-mia-1` can be translated to a region value of `us-mia`.""", DeprecationWarning)
            pulumi.log.warn("""cluster is deprecated: The cluster attribute has been deprecated, please consider switching to the region attribute. For example, a cluster value of `us-mia-1` can be translated to a region value of `us-mia`.""")
        if cluster is not None:
            pulumi.set(__self__, "cluster", cluster)
        if cors_enabled is not None:
            pulumi.set(__self__, "cors_enabled", cors_enabled)
        if endpoint_type is not None:
            pulumi.set(__self__, "endpoint_type", endpoint_type)
        if lifecycle_rules is not None:
            pulumi.set(__self__, "lifecycle_rules", lifecycle_rules)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if s3_endpoint is not None:
            pulumi.set(__self__, "s3_endpoint", s3_endpoint)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if versioning is not None:
            pulumi.set(__self__, "versioning", versioning)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[builtins.str]:
        """
        The label of the Linode Object Storage Bucket.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The access key to authenticate with. If not specified with the resource, its value can be
        * configured by `obj_access_key` in the provider configuration;
        * or, generated implicitly at apply-time if `obj_use_temp_keys` at provider-level is set.
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access_key", value)

    @property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Access Control Level of the bucket using a canned ACL string. See all ACL strings [in the Linode API v4 documentation](https://techdocs.akamai.com/linode-api/reference/post-object-storage-bucket).
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "acl", value)

    @property
    @pulumi.getter
    def cert(self) -> Optional[pulumi.Input['ObjectStorageBucketCertArgs']]:
        """
        The cert used by this Object Storage Bucket.
        """
        return pulumi.get(self, "cert")

    @cert.setter
    def cert(self, value: Optional[pulumi.Input['ObjectStorageBucketCertArgs']]):
        pulumi.set(self, "cert", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""The cluster attribute has been deprecated, please consider switching to the region attribute. For example, a cluster value of `us-mia-1` can be translated to a region value of `us-mia`.""")
    def cluster(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The cluster of the Linode Object Storage Bucket. This is deprecated in favor of `region` attribute.
        For example, `us-mia-1` cluster can be translated into `us-mia` region. Exactly one of `region` and `cluster` is required for creating a bucket.
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter(name="corsEnabled")
    def cors_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, the bucket will have CORS enabled for all origins.
        """
        return pulumi.get(self, "cors_enabled")

    @cors_enabled.setter
    def cors_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "cors_enabled", value)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of `s3_endpoint` available to the user in this region. See [Endpoint types](https://techdocs.akamai.com/cloud-computing/docs/object-storage#endpoint-type) for more information.
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_type", value)

    @property
    @pulumi.getter(name="lifecycleRules")
    def lifecycle_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ObjectStorageBucketLifecycleRuleArgs']]]]:
        """
        Lifecycle rules to be applied to the bucket.
        """
        return pulumi.get(self, "lifecycle_rules")

    @lifecycle_rules.setter
    def lifecycle_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectStorageBucketLifecycleRuleArgs']]]]):
        pulumi.set(self, "lifecycle_rules", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region of the Linode Object Storage Bucket. Exactly one of `region` and `cluster` is required for creating a bucket.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="s3Endpoint")
    def s3_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user's s3 endpoint URL, based on the `endpoint_type` and `region`.
        """
        return pulumi.get(self, "s3_endpoint")

    @s3_endpoint.setter
    def s3_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "s3_endpoint", value)

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The secret key to authenticate with. If not specified with the resource, its value can be
        * configured by `obj_secret_key` in the provider configuration;
        * or, generated implicitly at apply-time if `obj_use_temp_keys` at provider-level is set.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secret_key", value)

    @property
    @pulumi.getter
    def versioning(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable versioning. Once you version-enable a bucket, it can never return to an unversioned state. You can, however, suspend versioning on that bucket. (Requires `access_key` and `secret_key`)

        * `lifecycle_rule` - (Optional) Lifecycle rules to be applied to the bucket. (Requires `access_key` and `secret_key`)

        * `cert` - (Optional) The bucket's TLS/SSL certificate.
        """
        return pulumi.get(self, "versioning")

    @versioning.setter
    def versioning(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "versioning", value)


@pulumi.input_type
class _ObjectStorageBucketState:
    def __init__(__self__, *,
                 access_key: Optional[pulumi.Input[builtins.str]] = None,
                 acl: Optional[pulumi.Input[builtins.str]] = None,
                 cert: Optional[pulumi.Input['ObjectStorageBucketCertArgs']] = None,
                 cluster: Optional[pulumi.Input[builtins.str]] = None,
                 cors_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_type: Optional[pulumi.Input[builtins.str]] = None,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 label: Optional[pulumi.Input[builtins.str]] = None,
                 lifecycle_rules: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectStorageBucketLifecycleRuleArgs']]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 s3_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[builtins.str]] = None,
                 versioning: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Input properties used for looking up and filtering ObjectStorageBucket resources.
        :param pulumi.Input[builtins.str] access_key: The access key to authenticate with. If not specified with the resource, its value can be
               * configured by `obj_access_key` in the provider configuration;
               * or, generated implicitly at apply-time if `obj_use_temp_keys` at provider-level is set.
        :param pulumi.Input[builtins.str] acl: The Access Control Level of the bucket using a canned ACL string. See all ACL strings [in the Linode API v4 documentation](https://techdocs.akamai.com/linode-api/reference/post-object-storage-bucket).
        :param pulumi.Input['ObjectStorageBucketCertArgs'] cert: The cert used by this Object Storage Bucket.
        :param pulumi.Input[builtins.str] cluster: The cluster of the Linode Object Storage Bucket. This is deprecated in favor of `region` attribute.
               For example, `us-mia-1` cluster can be translated into `us-mia` region. Exactly one of `region` and `cluster` is required for creating a bucket.
        :param pulumi.Input[builtins.bool] cors_enabled: If true, the bucket will have CORS enabled for all origins.
        :param pulumi.Input[builtins.str] endpoint: The endpoint for the bucket used for s3 connections.
        :param pulumi.Input[builtins.str] endpoint_type: The type of `s3_endpoint` available to the user in this region. See [Endpoint types](https://techdocs.akamai.com/cloud-computing/docs/object-storage#endpoint-type) for more information.
        :param pulumi.Input[builtins.str] hostname: The hostname where this bucket can be accessed. This hostname can be accessed through a browser if the bucket is made
               public.
        :param pulumi.Input[builtins.str] label: The label of the Linode Object Storage Bucket.
        :param pulumi.Input[Sequence[pulumi.Input['ObjectStorageBucketLifecycleRuleArgs']]] lifecycle_rules: Lifecycle rules to be applied to the bucket.
        :param pulumi.Input[builtins.str] region: The region of the Linode Object Storage Bucket. Exactly one of `region` and `cluster` is required for creating a bucket.
        :param pulumi.Input[builtins.str] s3_endpoint: The user's s3 endpoint URL, based on the `endpoint_type` and `region`.
        :param pulumi.Input[builtins.str] secret_key: The secret key to authenticate with. If not specified with the resource, its value can be
               * configured by `obj_secret_key` in the provider configuration;
               * or, generated implicitly at apply-time if `obj_use_temp_keys` at provider-level is set.
        :param pulumi.Input[builtins.bool] versioning: Whether to enable versioning. Once you version-enable a bucket, it can never return to an unversioned state. You can, however, suspend versioning on that bucket. (Requires `access_key` and `secret_key`)
               
               * `lifecycle_rule` - (Optional) Lifecycle rules to be applied to the bucket. (Requires `access_key` and `secret_key`)
               
               * `cert` - (Optional) The bucket's TLS/SSL certificate.
        """
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if cluster is not None:
            warnings.warn("""The cluster attribute has been deprecated, please consider switching to the region attribute. For example, a cluster value of `us-mia-1` can be translated to a region value of `us-mia`.""", DeprecationWarning)
            pulumi.log.warn("""cluster is deprecated: The cluster attribute has been deprecated, please consider switching to the region attribute. For example, a cluster value of `us-mia-1` can be translated to a region value of `us-mia`.""")
        if cluster is not None:
            pulumi.set(__self__, "cluster", cluster)
        if cors_enabled is not None:
            pulumi.set(__self__, "cors_enabled", cors_enabled)
        if endpoint is not None:
            warnings.warn("""Use `s3_endpoint` instead""", DeprecationWarning)
            pulumi.log.warn("""endpoint is deprecated: Use `s3_endpoint` instead""")
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if endpoint_type is not None:
            pulumi.set(__self__, "endpoint_type", endpoint_type)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if lifecycle_rules is not None:
            pulumi.set(__self__, "lifecycle_rules", lifecycle_rules)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if s3_endpoint is not None:
            pulumi.set(__self__, "s3_endpoint", s3_endpoint)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if versioning is not None:
            pulumi.set(__self__, "versioning", versioning)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The access key to authenticate with. If not specified with the resource, its value can be
        * configured by `obj_access_key` in the provider configuration;
        * or, generated implicitly at apply-time if `obj_use_temp_keys` at provider-level is set.
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access_key", value)

    @property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Access Control Level of the bucket using a canned ACL string. See all ACL strings [in the Linode API v4 documentation](https://techdocs.akamai.com/linode-api/reference/post-object-storage-bucket).
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "acl", value)

    @property
    @pulumi.getter
    def cert(self) -> Optional[pulumi.Input['ObjectStorageBucketCertArgs']]:
        """
        The cert used by this Object Storage Bucket.
        """
        return pulumi.get(self, "cert")

    @cert.setter
    def cert(self, value: Optional[pulumi.Input['ObjectStorageBucketCertArgs']]):
        pulumi.set(self, "cert", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""The cluster attribute has been deprecated, please consider switching to the region attribute. For example, a cluster value of `us-mia-1` can be translated to a region value of `us-mia`.""")
    def cluster(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The cluster of the Linode Object Storage Bucket. This is deprecated in favor of `region` attribute.
        For example, `us-mia-1` cluster can be translated into `us-mia` region. Exactly one of `region` and `cluster` is required for creating a bucket.
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter(name="corsEnabled")
    def cors_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, the bucket will have CORS enabled for all origins.
        """
        return pulumi.get(self, "cors_enabled")

    @cors_enabled.setter
    def cors_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "cors_enabled", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""Use `s3_endpoint` instead""")
    def endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The endpoint for the bucket used for s3 connections.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of `s3_endpoint` available to the user in this region. See [Endpoint types](https://techdocs.akamai.com/cloud-computing/docs/object-storage#endpoint-type) for more information.
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_type", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hostname where this bucket can be accessed. This hostname can be accessed through a browser if the bucket is made
        public.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The label of the Linode Object Storage Bucket.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="lifecycleRules")
    def lifecycle_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ObjectStorageBucketLifecycleRuleArgs']]]]:
        """
        Lifecycle rules to be applied to the bucket.
        """
        return pulumi.get(self, "lifecycle_rules")

    @lifecycle_rules.setter
    def lifecycle_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ObjectStorageBucketLifecycleRuleArgs']]]]):
        pulumi.set(self, "lifecycle_rules", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region of the Linode Object Storage Bucket. Exactly one of `region` and `cluster` is required for creating a bucket.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="s3Endpoint")
    def s3_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user's s3 endpoint URL, based on the `endpoint_type` and `region`.
        """
        return pulumi.get(self, "s3_endpoint")

    @s3_endpoint.setter
    def s3_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "s3_endpoint", value)

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The secret key to authenticate with. If not specified with the resource, its value can be
        * configured by `obj_secret_key` in the provider configuration;
        * or, generated implicitly at apply-time if `obj_use_temp_keys` at provider-level is set.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secret_key", value)

    @property
    @pulumi.getter
    def versioning(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable versioning. Once you version-enable a bucket, it can never return to an unversioned state. You can, however, suspend versioning on that bucket. (Requires `access_key` and `secret_key`)

        * `lifecycle_rule` - (Optional) Lifecycle rules to be applied to the bucket. (Requires `access_key` and `secret_key`)

        * `cert` - (Optional) The bucket's TLS/SSL certificate.
        """
        return pulumi.get(self, "versioning")

    @versioning.setter
    def versioning(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "versioning", value)


@pulumi.type_token("linode:index/objectStorageBucket:ObjectStorageBucket")
class ObjectStorageBucket(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[builtins.str]] = None,
                 acl: Optional[pulumi.Input[builtins.str]] = None,
                 cert: Optional[pulumi.Input[Union['ObjectStorageBucketCertArgs', 'ObjectStorageBucketCertArgsDict']]] = None,
                 cluster: Optional[pulumi.Input[builtins.str]] = None,
                 cors_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 endpoint_type: Optional[pulumi.Input[builtins.str]] = None,
                 label: Optional[pulumi.Input[builtins.str]] = None,
                 lifecycle_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ObjectStorageBucketLifecycleRuleArgs', 'ObjectStorageBucketLifecycleRuleArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 s3_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[builtins.str]] = None,
                 versioning: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        Provides a Linode Object Storage Bucket resource. This can be used to create, modify, and delete Linodes Object Storage Buckets.
        For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/post-object-storage-bucket).

        ## Example Usage

        The following example shows how one might use this resource to create an Object Storage Bucket:

        ```python
        import pulumi
        import pulumi_linode as linode

        foobar = linode.ObjectStorageBucket("foobar",
            region="us-mia",
            label="mybucket")
        ```

        Creating an Object Storage Bucket with Lifecycle rules:

        ```python
        import pulumi
        import pulumi_linode as linode

        mykey = linode.ObjectStorageKey("mykey", label="image-access")
        mybucket = linode.ObjectStorageBucket("mybucket",
            access_key=mykey.access_key,
            secret_key=mykey.secret_key,
            region="us-mia",
            label="mybucket",
            lifecycle_rules=[{
                "id": "my-rule",
                "enabled": True,
                "abort_incomplete_multipart_upload_days": 5,
                "expiration": {
                    "date": "2021-06-21",
                },
            }])
        ```

        Creating an Object Storage Bucket with Lifecycle rules using provider-level object credentials

        ## Import

        Linodes Object Storage Buckets can be imported using the resource `id` which is made of `cluster:label`, e.g.

        ```sh
        $ pulumi import linode:index/objectStorageBucket:ObjectStorageBucket mybucket us-east-1:foobar
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] access_key: The access key to authenticate with. If not specified with the resource, its value can be
               * configured by `obj_access_key` in the provider configuration;
               * or, generated implicitly at apply-time if `obj_use_temp_keys` at provider-level is set.
        :param pulumi.Input[builtins.str] acl: The Access Control Level of the bucket using a canned ACL string. See all ACL strings [in the Linode API v4 documentation](https://techdocs.akamai.com/linode-api/reference/post-object-storage-bucket).
        :param pulumi.Input[Union['ObjectStorageBucketCertArgs', 'ObjectStorageBucketCertArgsDict']] cert: The cert used by this Object Storage Bucket.
        :param pulumi.Input[builtins.str] cluster: The cluster of the Linode Object Storage Bucket. This is deprecated in favor of `region` attribute.
               For example, `us-mia-1` cluster can be translated into `us-mia` region. Exactly one of `region` and `cluster` is required for creating a bucket.
        :param pulumi.Input[builtins.bool] cors_enabled: If true, the bucket will have CORS enabled for all origins.
        :param pulumi.Input[builtins.str] endpoint_type: The type of `s3_endpoint` available to the user in this region. See [Endpoint types](https://techdocs.akamai.com/cloud-computing/docs/object-storage#endpoint-type) for more information.
        :param pulumi.Input[builtins.str] label: The label of the Linode Object Storage Bucket.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ObjectStorageBucketLifecycleRuleArgs', 'ObjectStorageBucketLifecycleRuleArgsDict']]]] lifecycle_rules: Lifecycle rules to be applied to the bucket.
        :param pulumi.Input[builtins.str] region: The region of the Linode Object Storage Bucket. Exactly one of `region` and `cluster` is required for creating a bucket.
        :param pulumi.Input[builtins.str] s3_endpoint: The user's s3 endpoint URL, based on the `endpoint_type` and `region`.
        :param pulumi.Input[builtins.str] secret_key: The secret key to authenticate with. If not specified with the resource, its value can be
               * configured by `obj_secret_key` in the provider configuration;
               * or, generated implicitly at apply-time if `obj_use_temp_keys` at provider-level is set.
        :param pulumi.Input[builtins.bool] versioning: Whether to enable versioning. Once you version-enable a bucket, it can never return to an unversioned state. You can, however, suspend versioning on that bucket. (Requires `access_key` and `secret_key`)
               
               * `lifecycle_rule` - (Optional) Lifecycle rules to be applied to the bucket. (Requires `access_key` and `secret_key`)
               
               * `cert` - (Optional) The bucket's TLS/SSL certificate.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ObjectStorageBucketArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Linode Object Storage Bucket resource. This can be used to create, modify, and delete Linodes Object Storage Buckets.
        For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/post-object-storage-bucket).

        ## Example Usage

        The following example shows how one might use this resource to create an Object Storage Bucket:

        ```python
        import pulumi
        import pulumi_linode as linode

        foobar = linode.ObjectStorageBucket("foobar",
            region="us-mia",
            label="mybucket")
        ```

        Creating an Object Storage Bucket with Lifecycle rules:

        ```python
        import pulumi
        import pulumi_linode as linode

        mykey = linode.ObjectStorageKey("mykey", label="image-access")
        mybucket = linode.ObjectStorageBucket("mybucket",
            access_key=mykey.access_key,
            secret_key=mykey.secret_key,
            region="us-mia",
            label="mybucket",
            lifecycle_rules=[{
                "id": "my-rule",
                "enabled": True,
                "abort_incomplete_multipart_upload_days": 5,
                "expiration": {
                    "date": "2021-06-21",
                },
            }])
        ```

        Creating an Object Storage Bucket with Lifecycle rules using provider-level object credentials

        ## Import

        Linodes Object Storage Buckets can be imported using the resource `id` which is made of `cluster:label`, e.g.

        ```sh
        $ pulumi import linode:index/objectStorageBucket:ObjectStorageBucket mybucket us-east-1:foobar
        ```

        :param str resource_name: The name of the resource.
        :param ObjectStorageBucketArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ObjectStorageBucketArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[builtins.str]] = None,
                 acl: Optional[pulumi.Input[builtins.str]] = None,
                 cert: Optional[pulumi.Input[Union['ObjectStorageBucketCertArgs', 'ObjectStorageBucketCertArgsDict']]] = None,
                 cluster: Optional[pulumi.Input[builtins.str]] = None,
                 cors_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 endpoint_type: Optional[pulumi.Input[builtins.str]] = None,
                 label: Optional[pulumi.Input[builtins.str]] = None,
                 lifecycle_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ObjectStorageBucketLifecycleRuleArgs', 'ObjectStorageBucketLifecycleRuleArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 s3_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[builtins.str]] = None,
                 versioning: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ObjectStorageBucketArgs.__new__(ObjectStorageBucketArgs)

            __props__.__dict__["access_key"] = access_key
            __props__.__dict__["acl"] = acl
            __props__.__dict__["cert"] = cert
            __props__.__dict__["cluster"] = cluster
            __props__.__dict__["cors_enabled"] = cors_enabled
            __props__.__dict__["endpoint_type"] = endpoint_type
            if label is None and not opts.urn:
                raise TypeError("Missing required property 'label'")
            __props__.__dict__["label"] = label
            __props__.__dict__["lifecycle_rules"] = lifecycle_rules
            __props__.__dict__["region"] = region
            __props__.__dict__["s3_endpoint"] = s3_endpoint
            __props__.__dict__["secret_key"] = None if secret_key is None else pulumi.Output.secret(secret_key)
            __props__.__dict__["versioning"] = versioning
            __props__.__dict__["endpoint"] = None
            __props__.__dict__["hostname"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["secretKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ObjectStorageBucket, __self__).__init__(
            'linode:index/objectStorageBucket:ObjectStorageBucket',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_key: Optional[pulumi.Input[builtins.str]] = None,
            acl: Optional[pulumi.Input[builtins.str]] = None,
            cert: Optional[pulumi.Input[Union['ObjectStorageBucketCertArgs', 'ObjectStorageBucketCertArgsDict']]] = None,
            cluster: Optional[pulumi.Input[builtins.str]] = None,
            cors_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            endpoint: Optional[pulumi.Input[builtins.str]] = None,
            endpoint_type: Optional[pulumi.Input[builtins.str]] = None,
            hostname: Optional[pulumi.Input[builtins.str]] = None,
            label: Optional[pulumi.Input[builtins.str]] = None,
            lifecycle_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ObjectStorageBucketLifecycleRuleArgs', 'ObjectStorageBucketLifecycleRuleArgsDict']]]]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            s3_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            secret_key: Optional[pulumi.Input[builtins.str]] = None,
            versioning: Optional[pulumi.Input[builtins.bool]] = None) -> 'ObjectStorageBucket':
        """
        Get an existing ObjectStorageBucket resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] access_key: The access key to authenticate with. If not specified with the resource, its value can be
               * configured by `obj_access_key` in the provider configuration;
               * or, generated implicitly at apply-time if `obj_use_temp_keys` at provider-level is set.
        :param pulumi.Input[builtins.str] acl: The Access Control Level of the bucket using a canned ACL string. See all ACL strings [in the Linode API v4 documentation](https://techdocs.akamai.com/linode-api/reference/post-object-storage-bucket).
        :param pulumi.Input[Union['ObjectStorageBucketCertArgs', 'ObjectStorageBucketCertArgsDict']] cert: The cert used by this Object Storage Bucket.
        :param pulumi.Input[builtins.str] cluster: The cluster of the Linode Object Storage Bucket. This is deprecated in favor of `region` attribute.
               For example, `us-mia-1` cluster can be translated into `us-mia` region. Exactly one of `region` and `cluster` is required for creating a bucket.
        :param pulumi.Input[builtins.bool] cors_enabled: If true, the bucket will have CORS enabled for all origins.
        :param pulumi.Input[builtins.str] endpoint: The endpoint for the bucket used for s3 connections.
        :param pulumi.Input[builtins.str] endpoint_type: The type of `s3_endpoint` available to the user in this region. See [Endpoint types](https://techdocs.akamai.com/cloud-computing/docs/object-storage#endpoint-type) for more information.
        :param pulumi.Input[builtins.str] hostname: The hostname where this bucket can be accessed. This hostname can be accessed through a browser if the bucket is made
               public.
        :param pulumi.Input[builtins.str] label: The label of the Linode Object Storage Bucket.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ObjectStorageBucketLifecycleRuleArgs', 'ObjectStorageBucketLifecycleRuleArgsDict']]]] lifecycle_rules: Lifecycle rules to be applied to the bucket.
        :param pulumi.Input[builtins.str] region: The region of the Linode Object Storage Bucket. Exactly one of `region` and `cluster` is required for creating a bucket.
        :param pulumi.Input[builtins.str] s3_endpoint: The user's s3 endpoint URL, based on the `endpoint_type` and `region`.
        :param pulumi.Input[builtins.str] secret_key: The secret key to authenticate with. If not specified with the resource, its value can be
               * configured by `obj_secret_key` in the provider configuration;
               * or, generated implicitly at apply-time if `obj_use_temp_keys` at provider-level is set.
        :param pulumi.Input[builtins.bool] versioning: Whether to enable versioning. Once you version-enable a bucket, it can never return to an unversioned state. You can, however, suspend versioning on that bucket. (Requires `access_key` and `secret_key`)
               
               * `lifecycle_rule` - (Optional) Lifecycle rules to be applied to the bucket. (Requires `access_key` and `secret_key`)
               
               * `cert` - (Optional) The bucket's TLS/SSL certificate.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ObjectStorageBucketState.__new__(_ObjectStorageBucketState)

        __props__.__dict__["access_key"] = access_key
        __props__.__dict__["acl"] = acl
        __props__.__dict__["cert"] = cert
        __props__.__dict__["cluster"] = cluster
        __props__.__dict__["cors_enabled"] = cors_enabled
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["endpoint_type"] = endpoint_type
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["label"] = label
        __props__.__dict__["lifecycle_rules"] = lifecycle_rules
        __props__.__dict__["region"] = region
        __props__.__dict__["s3_endpoint"] = s3_endpoint
        __props__.__dict__["secret_key"] = secret_key
        __props__.__dict__["versioning"] = versioning
        return ObjectStorageBucket(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The access key to authenticate with. If not specified with the resource, its value can be
        * configured by `obj_access_key` in the provider configuration;
        * or, generated implicitly at apply-time if `obj_use_temp_keys` at provider-level is set.
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter
    def acl(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Access Control Level of the bucket using a canned ACL string. See all ACL strings [in the Linode API v4 documentation](https://techdocs.akamai.com/linode-api/reference/post-object-storage-bucket).
        """
        return pulumi.get(self, "acl")

    @property
    @pulumi.getter
    def cert(self) -> pulumi.Output[Optional['outputs.ObjectStorageBucketCert']]:
        """
        The cert used by this Object Storage Bucket.
        """
        return pulumi.get(self, "cert")

    @property
    @pulumi.getter
    @_utilities.deprecated("""The cluster attribute has been deprecated, please consider switching to the region attribute. For example, a cluster value of `us-mia-1` can be translated to a region value of `us-mia`.""")
    def cluster(self) -> pulumi.Output[builtins.str]:
        """
        The cluster of the Linode Object Storage Bucket. This is deprecated in favor of `region` attribute.
        For example, `us-mia-1` cluster can be translated into `us-mia` region. Exactly one of `region` and `cluster` is required for creating a bucket.
        """
        return pulumi.get(self, "cluster")

    @property
    @pulumi.getter(name="corsEnabled")
    def cors_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        If true, the bucket will have CORS enabled for all origins.
        """
        return pulumi.get(self, "cors_enabled")

    @property
    @pulumi.getter
    @_utilities.deprecated("""Use `s3_endpoint` instead""")
    def endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The endpoint for the bucket used for s3 connections.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> pulumi.Output[builtins.str]:
        """
        The type of `s3_endpoint` available to the user in this region. See [Endpoint types](https://techdocs.akamai.com/cloud-computing/docs/object-storage#endpoint-type) for more information.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[builtins.str]:
        """
        The hostname where this bucket can be accessed. This hostname can be accessed through a browser if the bucket is made
        public.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def label(self) -> pulumi.Output[builtins.str]:
        """
        The label of the Linode Object Storage Bucket.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="lifecycleRules")
    def lifecycle_rules(self) -> pulumi.Output[Optional[Sequence['outputs.ObjectStorageBucketLifecycleRule']]]:
        """
        Lifecycle rules to be applied to the bucket.
        """
        return pulumi.get(self, "lifecycle_rules")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        The region of the Linode Object Storage Bucket. Exactly one of `region` and `cluster` is required for creating a bucket.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="s3Endpoint")
    def s3_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The user's s3 endpoint URL, based on the `endpoint_type` and `region`.
        """
        return pulumi.get(self, "s3_endpoint")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The secret key to authenticate with. If not specified with the resource, its value can be
        * configured by `obj_secret_key` in the provider configuration;
        * or, generated implicitly at apply-time if `obj_use_temp_keys` at provider-level is set.
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter
    def versioning(self) -> pulumi.Output[builtins.bool]:
        """
        Whether to enable versioning. Once you version-enable a bucket, it can never return to an unversioned state. You can, however, suspend versioning on that bucket. (Requires `access_key` and `secret_key`)

        * `lifecycle_rule` - (Optional) Lifecycle rules to be applied to the bucket. (Requires `access_key` and `secret_key`)

        * `cert` - (Optional) The bucket's TLS/SSL certificate.
        """
        return pulumi.get(self, "versioning")

