# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ObjectStorageObjectArgs', 'ObjectStorageObject']

@pulumi.input_type
class ObjectStorageObjectArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[builtins.str],
                 key: pulumi.Input[builtins.str],
                 access_key: Optional[pulumi.Input[builtins.str]] = None,
                 acl: Optional[pulumi.Input[builtins.str]] = None,
                 cache_control: Optional[pulumi.Input[builtins.str]] = None,
                 cluster: Optional[pulumi.Input[builtins.str]] = None,
                 content: Optional[pulumi.Input[builtins.str]] = None,
                 content_base64: Optional[pulumi.Input[builtins.str]] = None,
                 content_disposition: Optional[pulumi.Input[builtins.str]] = None,
                 content_encoding: Optional[pulumi.Input[builtins.str]] = None,
                 content_language: Optional[pulumi.Input[builtins.str]] = None,
                 content_type: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 force_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[builtins.str]] = None,
                 source: Optional[pulumi.Input[builtins.str]] = None,
                 website_redirect: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ObjectStorageObject resource.
        :param pulumi.Input[builtins.str] bucket: The name of the bucket to put the object in.
        :param pulumi.Input[builtins.str] key: They name of the object once it is in the bucket.
        :param pulumi.Input[builtins.str] access_key: The REQUIRED access key to authenticate with. If it's not specified with the resource, you must provide its value by
               * configuring the `obj_access_key` in the provider configuration;
               * or, opting-in generating it implicitly at apply-time using `obj_use_temp_keys` at provider-level.
        :param pulumi.Input[builtins.str] acl: The canned ACL to apply. (`private`, `public-read`, `authenticated-read`, `public-read-write`, `custom`) (defaults to `private`).
        :param pulumi.Input[builtins.str] cache_control: Specifies caching behavior along the request/reply chain Read [w3c cache_control](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9) for further details.
        :param pulumi.Input[builtins.str] cluster: The cluster the bucket is in. Required if `region` is not configured. Deprecated in favor of `region`.
        :param pulumi.Input[builtins.str] content: Literal string value to use as the object content, which will be uploaded as UTF-8-encoded text.
        :param pulumi.Input[builtins.str] content_base64: Base64-encoded data that will be decoded and uploaded as raw bytes for the object content. This allows safely uploading non-UTF8 binary data, but is recommended only for small content such as the result of the `gzipbase64` function with small text strings. For larger objects, use `source` to stream the content from a disk file.
        :param pulumi.Input[builtins.str] content_disposition: Specifies presentational information for the object. Read [w3c content_disposition](http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.5.1) for further information.
        :param pulumi.Input[builtins.str] content_encoding: Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Read [w3c content encoding](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.11) for further information.
        :param pulumi.Input[builtins.str] content_language: The language the content is in e.g. en-US or en-GB.
        :param pulumi.Input[builtins.str] content_type: A standard MIME type describing the format of the object data, e.g. application/octet-stream. All Valid MIME Types are valid for this input.
        :param pulumi.Input[builtins.str] endpoint: Used with the s3 client to make bucket changes and will be computed automatically if left blank, override for testing/debug purposes.
        :param pulumi.Input[builtins.str] etag: The specific version of this object.
        :param pulumi.Input[builtins.bool] force_destroy: Allow the object to be deleted regardless of any legal hold or object lock (defaults to `false`).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: A map of keys/values to provision metadata.
        :param pulumi.Input[builtins.str] region: The cluster the bucket is in. Required if `cluster` is not configured.
        :param pulumi.Input[builtins.str] secret_key: The REQUIRED secret key to authenticate with. If it's not specified with the resource, you must provide its value by
               * configuring the `obj_secret_key` in the provider configuration;
               * or, opting-in generating it implicitly at apply-time using `obj_use_temp_keys` at provider-level.
        :param pulumi.Input[builtins.str] source: The path to a file that will be read and uploaded as raw bytes for the object content. The path must either be relative to the root module or absolute.
        :param pulumi.Input[builtins.str] website_redirect: Specifies a target URL for website redirect.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if cache_control is not None:
            pulumi.set(__self__, "cache_control", cache_control)
        if cluster is not None:
            warnings.warn("""The cluster attribute has been deprecated, please consider switching to the region attribute. For example, a cluster value of `us-mia-1` can be translated to a region value of `us-mia`.""", DeprecationWarning)
            pulumi.log.warn("""cluster is deprecated: The cluster attribute has been deprecated, please consider switching to the region attribute. For example, a cluster value of `us-mia-1` can be translated to a region value of `us-mia`.""")
        if cluster is not None:
            pulumi.set(__self__, "cluster", cluster)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if content_base64 is not None:
            pulumi.set(__self__, "content_base64", content_base64)
        if content_disposition is not None:
            pulumi.set(__self__, "content_disposition", content_disposition)
        if content_encoding is not None:
            pulumi.set(__self__, "content_encoding", content_encoding)
        if content_language is not None:
            pulumi.set(__self__, "content_language", content_language)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if website_redirect is not None:
            pulumi.set(__self__, "website_redirect", website_redirect)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[builtins.str]:
        """
        The name of the bucket to put the object in.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[builtins.str]:
        """
        They name of the object once it is in the bucket.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The REQUIRED access key to authenticate with. If it's not specified with the resource, you must provide its value by
        * configuring the `obj_access_key` in the provider configuration;
        * or, opting-in generating it implicitly at apply-time using `obj_use_temp_keys` at provider-level.
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access_key", value)

    @property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The canned ACL to apply. (`private`, `public-read`, `authenticated-read`, `public-read-write`, `custom`) (defaults to `private`).
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "acl", value)

    @property
    @pulumi.getter(name="cacheControl")
    def cache_control(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies caching behavior along the request/reply chain Read [w3c cache_control](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9) for further details.
        """
        return pulumi.get(self, "cache_control")

    @cache_control.setter
    def cache_control(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cache_control", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""The cluster attribute has been deprecated, please consider switching to the region attribute. For example, a cluster value of `us-mia-1` can be translated to a region value of `us-mia`.""")
    def cluster(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The cluster the bucket is in. Required if `region` is not configured. Deprecated in favor of `region`.
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Literal string value to use as the object content, which will be uploaded as UTF-8-encoded text.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="contentBase64")
    def content_base64(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Base64-encoded data that will be decoded and uploaded as raw bytes for the object content. This allows safely uploading non-UTF8 binary data, but is recommended only for small content such as the result of the `gzipbase64` function with small text strings. For larger objects, use `source` to stream the content from a disk file.
        """
        return pulumi.get(self, "content_base64")

    @content_base64.setter
    def content_base64(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content_base64", value)

    @property
    @pulumi.getter(name="contentDisposition")
    def content_disposition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies presentational information for the object. Read [w3c content_disposition](http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.5.1) for further information.
        """
        return pulumi.get(self, "content_disposition")

    @content_disposition.setter
    def content_disposition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content_disposition", value)

    @property
    @pulumi.getter(name="contentEncoding")
    def content_encoding(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Read [w3c content encoding](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.11) for further information.
        """
        return pulumi.get(self, "content_encoding")

    @content_encoding.setter
    def content_encoding(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content_encoding", value)

    @property
    @pulumi.getter(name="contentLanguage")
    def content_language(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The language the content is in e.g. en-US or en-GB.
        """
        return pulumi.get(self, "content_language")

    @content_language.setter
    def content_language(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content_language", value)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A standard MIME type describing the format of the object data, e.g. application/octet-stream. All Valid MIME Types are valid for this input.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Used with the s3 client to make bucket changes and will be computed automatically if left blank, override for testing/debug purposes.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The specific version of this object.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allow the object to be deleted regardless of any legal hold or object lock (defaults to `false`).
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of keys/values to provision metadata.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The cluster the bucket is in. Required if `cluster` is not configured.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The REQUIRED secret key to authenticate with. If it's not specified with the resource, you must provide its value by
        * configuring the `obj_secret_key` in the provider configuration;
        * or, opting-in generating it implicitly at apply-time using `obj_use_temp_keys` at provider-level.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secret_key", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The path to a file that will be read and uploaded as raw bytes for the object content. The path must either be relative to the root module or absolute.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="websiteRedirect")
    def website_redirect(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies a target URL for website redirect.
        """
        return pulumi.get(self, "website_redirect")

    @website_redirect.setter
    def website_redirect(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "website_redirect", value)


@pulumi.input_type
class _ObjectStorageObjectState:
    def __init__(__self__, *,
                 access_key: Optional[pulumi.Input[builtins.str]] = None,
                 acl: Optional[pulumi.Input[builtins.str]] = None,
                 bucket: Optional[pulumi.Input[builtins.str]] = None,
                 cache_control: Optional[pulumi.Input[builtins.str]] = None,
                 cluster: Optional[pulumi.Input[builtins.str]] = None,
                 content: Optional[pulumi.Input[builtins.str]] = None,
                 content_base64: Optional[pulumi.Input[builtins.str]] = None,
                 content_disposition: Optional[pulumi.Input[builtins.str]] = None,
                 content_encoding: Optional[pulumi.Input[builtins.str]] = None,
                 content_language: Optional[pulumi.Input[builtins.str]] = None,
                 content_type: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 force_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[builtins.str]] = None,
                 source: Optional[pulumi.Input[builtins.str]] = None,
                 version_id: Optional[pulumi.Input[builtins.str]] = None,
                 website_redirect: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ObjectStorageObject resources.
        :param pulumi.Input[builtins.str] access_key: The REQUIRED access key to authenticate with. If it's not specified with the resource, you must provide its value by
               * configuring the `obj_access_key` in the provider configuration;
               * or, opting-in generating it implicitly at apply-time using `obj_use_temp_keys` at provider-level.
        :param pulumi.Input[builtins.str] acl: The canned ACL to apply. (`private`, `public-read`, `authenticated-read`, `public-read-write`, `custom`) (defaults to `private`).
        :param pulumi.Input[builtins.str] bucket: The name of the bucket to put the object in.
        :param pulumi.Input[builtins.str] cache_control: Specifies caching behavior along the request/reply chain Read [w3c cache_control](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9) for further details.
        :param pulumi.Input[builtins.str] cluster: The cluster the bucket is in. Required if `region` is not configured. Deprecated in favor of `region`.
        :param pulumi.Input[builtins.str] content: Literal string value to use as the object content, which will be uploaded as UTF-8-encoded text.
        :param pulumi.Input[builtins.str] content_base64: Base64-encoded data that will be decoded and uploaded as raw bytes for the object content. This allows safely uploading non-UTF8 binary data, but is recommended only for small content such as the result of the `gzipbase64` function with small text strings. For larger objects, use `source` to stream the content from a disk file.
        :param pulumi.Input[builtins.str] content_disposition: Specifies presentational information for the object. Read [w3c content_disposition](http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.5.1) for further information.
        :param pulumi.Input[builtins.str] content_encoding: Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Read [w3c content encoding](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.11) for further information.
        :param pulumi.Input[builtins.str] content_language: The language the content is in e.g. en-US or en-GB.
        :param pulumi.Input[builtins.str] content_type: A standard MIME type describing the format of the object data, e.g. application/octet-stream. All Valid MIME Types are valid for this input.
        :param pulumi.Input[builtins.str] endpoint: Used with the s3 client to make bucket changes and will be computed automatically if left blank, override for testing/debug purposes.
        :param pulumi.Input[builtins.str] etag: The specific version of this object.
        :param pulumi.Input[builtins.bool] force_destroy: Allow the object to be deleted regardless of any legal hold or object lock (defaults to `false`).
        :param pulumi.Input[builtins.str] key: They name of the object once it is in the bucket.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: A map of keys/values to provision metadata.
        :param pulumi.Input[builtins.str] region: The cluster the bucket is in. Required if `cluster` is not configured.
        :param pulumi.Input[builtins.str] secret_key: The REQUIRED secret key to authenticate with. If it's not specified with the resource, you must provide its value by
               * configuring the `obj_secret_key` in the provider configuration;
               * or, opting-in generating it implicitly at apply-time using `obj_use_temp_keys` at provider-level.
        :param pulumi.Input[builtins.str] source: The path to a file that will be read and uploaded as raw bytes for the object content. The path must either be relative to the root module or absolute.
        :param pulumi.Input[builtins.str] version_id: A unique version ID value for the object.
        :param pulumi.Input[builtins.str] website_redirect: Specifies a target URL for website redirect.
        """
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if cache_control is not None:
            pulumi.set(__self__, "cache_control", cache_control)
        if cluster is not None:
            warnings.warn("""The cluster attribute has been deprecated, please consider switching to the region attribute. For example, a cluster value of `us-mia-1` can be translated to a region value of `us-mia`.""", DeprecationWarning)
            pulumi.log.warn("""cluster is deprecated: The cluster attribute has been deprecated, please consider switching to the region attribute. For example, a cluster value of `us-mia-1` can be translated to a region value of `us-mia`.""")
        if cluster is not None:
            pulumi.set(__self__, "cluster", cluster)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if content_base64 is not None:
            pulumi.set(__self__, "content_base64", content_base64)
        if content_disposition is not None:
            pulumi.set(__self__, "content_disposition", content_disposition)
        if content_encoding is not None:
            pulumi.set(__self__, "content_encoding", content_encoding)
        if content_language is not None:
            pulumi.set(__self__, "content_language", content_language)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if version_id is not None:
            pulumi.set(__self__, "version_id", version_id)
        if website_redirect is not None:
            pulumi.set(__self__, "website_redirect", website_redirect)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The REQUIRED access key to authenticate with. If it's not specified with the resource, you must provide its value by
        * configuring the `obj_access_key` in the provider configuration;
        * or, opting-in generating it implicitly at apply-time using `obj_use_temp_keys` at provider-level.
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access_key", value)

    @property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The canned ACL to apply. (`private`, `public-read`, `authenticated-read`, `public-read-write`, `custom`) (defaults to `private`).
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "acl", value)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the bucket to put the object in.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="cacheControl")
    def cache_control(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies caching behavior along the request/reply chain Read [w3c cache_control](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9) for further details.
        """
        return pulumi.get(self, "cache_control")

    @cache_control.setter
    def cache_control(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cache_control", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""The cluster attribute has been deprecated, please consider switching to the region attribute. For example, a cluster value of `us-mia-1` can be translated to a region value of `us-mia`.""")
    def cluster(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The cluster the bucket is in. Required if `region` is not configured. Deprecated in favor of `region`.
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Literal string value to use as the object content, which will be uploaded as UTF-8-encoded text.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="contentBase64")
    def content_base64(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Base64-encoded data that will be decoded and uploaded as raw bytes for the object content. This allows safely uploading non-UTF8 binary data, but is recommended only for small content such as the result of the `gzipbase64` function with small text strings. For larger objects, use `source` to stream the content from a disk file.
        """
        return pulumi.get(self, "content_base64")

    @content_base64.setter
    def content_base64(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content_base64", value)

    @property
    @pulumi.getter(name="contentDisposition")
    def content_disposition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies presentational information for the object. Read [w3c content_disposition](http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.5.1) for further information.
        """
        return pulumi.get(self, "content_disposition")

    @content_disposition.setter
    def content_disposition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content_disposition", value)

    @property
    @pulumi.getter(name="contentEncoding")
    def content_encoding(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Read [w3c content encoding](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.11) for further information.
        """
        return pulumi.get(self, "content_encoding")

    @content_encoding.setter
    def content_encoding(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content_encoding", value)

    @property
    @pulumi.getter(name="contentLanguage")
    def content_language(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The language the content is in e.g. en-US or en-GB.
        """
        return pulumi.get(self, "content_language")

    @content_language.setter
    def content_language(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content_language", value)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A standard MIME type describing the format of the object data, e.g. application/octet-stream. All Valid MIME Types are valid for this input.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Used with the s3 client to make bucket changes and will be computed automatically if left blank, override for testing/debug purposes.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The specific version of this object.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allow the object to be deleted regardless of any legal hold or object lock (defaults to `false`).
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        They name of the object once it is in the bucket.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of keys/values to provision metadata.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The cluster the bucket is in. Required if `cluster` is not configured.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The REQUIRED secret key to authenticate with. If it's not specified with the resource, you must provide its value by
        * configuring the `obj_secret_key` in the provider configuration;
        * or, opting-in generating it implicitly at apply-time using `obj_use_temp_keys` at provider-level.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secret_key", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The path to a file that will be read and uploaded as raw bytes for the object content. The path must either be relative to the root module or absolute.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique version ID value for the object.
        """
        return pulumi.get(self, "version_id")

    @version_id.setter
    def version_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version_id", value)

    @property
    @pulumi.getter(name="websiteRedirect")
    def website_redirect(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies a target URL for website redirect.
        """
        return pulumi.get(self, "website_redirect")

    @website_redirect.setter
    def website_redirect(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "website_redirect", value)


@pulumi.type_token("linode:index/objectStorageObject:ObjectStorageObject")
class ObjectStorageObject(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[builtins.str]] = None,
                 acl: Optional[pulumi.Input[builtins.str]] = None,
                 bucket: Optional[pulumi.Input[builtins.str]] = None,
                 cache_control: Optional[pulumi.Input[builtins.str]] = None,
                 cluster: Optional[pulumi.Input[builtins.str]] = None,
                 content: Optional[pulumi.Input[builtins.str]] = None,
                 content_base64: Optional[pulumi.Input[builtins.str]] = None,
                 content_disposition: Optional[pulumi.Input[builtins.str]] = None,
                 content_encoding: Optional[pulumi.Input[builtins.str]] = None,
                 content_language: Optional[pulumi.Input[builtins.str]] = None,
                 content_type: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 force_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[builtins.str]] = None,
                 source: Optional[pulumi.Input[builtins.str]] = None,
                 website_redirect: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides a Linode Object Storage Object resource. This can be used to create, modify, and delete Linodes Object Storage Objects for Buckets.

        ## Example Usage

        ### Uploading a file to a bucket

        ```python
        import pulumi
        import pulumi_linode as linode
        import pulumi_std as std

        object = linode.ObjectStorageObject("object",
            bucket="my-bucket",
            region="us-mia",
            key="my-object",
            secret_key=my_key["secretKey"],
            access_key=my_key["accessKey"],
            source=std.pathexpand(input="~/files/log.txt").result)
        ```

        ### Uploading plaintext to a bucket

        ```python
        import pulumi
        import pulumi_linode as linode

        object = linode.ObjectStorageObject("object",
            bucket="my-bucket",
            region="us-mia",
            key="my-object",
            secret_key=my_key["secretKey"],
            access_key=my_key["accessKey"],
            content="This is the content of the Object...",
            content_type="text/plain",
            content_language="en")
        ```

        ### Creating an object using implicitly created object credentials

        ```python
        import pulumi
        import pulumi_linode as linode
        import pulumi_std as std

        object = linode.ObjectStorageObject("object",
            bucket="my-bucket",
            region="us-mia",
            key="my-object",
            source=std.pathexpand(input="~/files/log.txt").result)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] access_key: The REQUIRED access key to authenticate with. If it's not specified with the resource, you must provide its value by
               * configuring the `obj_access_key` in the provider configuration;
               * or, opting-in generating it implicitly at apply-time using `obj_use_temp_keys` at provider-level.
        :param pulumi.Input[builtins.str] acl: The canned ACL to apply. (`private`, `public-read`, `authenticated-read`, `public-read-write`, `custom`) (defaults to `private`).
        :param pulumi.Input[builtins.str] bucket: The name of the bucket to put the object in.
        :param pulumi.Input[builtins.str] cache_control: Specifies caching behavior along the request/reply chain Read [w3c cache_control](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9) for further details.
        :param pulumi.Input[builtins.str] cluster: The cluster the bucket is in. Required if `region` is not configured. Deprecated in favor of `region`.
        :param pulumi.Input[builtins.str] content: Literal string value to use as the object content, which will be uploaded as UTF-8-encoded text.
        :param pulumi.Input[builtins.str] content_base64: Base64-encoded data that will be decoded and uploaded as raw bytes for the object content. This allows safely uploading non-UTF8 binary data, but is recommended only for small content such as the result of the `gzipbase64` function with small text strings. For larger objects, use `source` to stream the content from a disk file.
        :param pulumi.Input[builtins.str] content_disposition: Specifies presentational information for the object. Read [w3c content_disposition](http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.5.1) for further information.
        :param pulumi.Input[builtins.str] content_encoding: Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Read [w3c content encoding](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.11) for further information.
        :param pulumi.Input[builtins.str] content_language: The language the content is in e.g. en-US or en-GB.
        :param pulumi.Input[builtins.str] content_type: A standard MIME type describing the format of the object data, e.g. application/octet-stream. All Valid MIME Types are valid for this input.
        :param pulumi.Input[builtins.str] endpoint: Used with the s3 client to make bucket changes and will be computed automatically if left blank, override for testing/debug purposes.
        :param pulumi.Input[builtins.str] etag: The specific version of this object.
        :param pulumi.Input[builtins.bool] force_destroy: Allow the object to be deleted regardless of any legal hold or object lock (defaults to `false`).
        :param pulumi.Input[builtins.str] key: They name of the object once it is in the bucket.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: A map of keys/values to provision metadata.
        :param pulumi.Input[builtins.str] region: The cluster the bucket is in. Required if `cluster` is not configured.
        :param pulumi.Input[builtins.str] secret_key: The REQUIRED secret key to authenticate with. If it's not specified with the resource, you must provide its value by
               * configuring the `obj_secret_key` in the provider configuration;
               * or, opting-in generating it implicitly at apply-time using `obj_use_temp_keys` at provider-level.
        :param pulumi.Input[builtins.str] source: The path to a file that will be read and uploaded as raw bytes for the object content. The path must either be relative to the root module or absolute.
        :param pulumi.Input[builtins.str] website_redirect: Specifies a target URL for website redirect.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ObjectStorageObjectArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Linode Object Storage Object resource. This can be used to create, modify, and delete Linodes Object Storage Objects for Buckets.

        ## Example Usage

        ### Uploading a file to a bucket

        ```python
        import pulumi
        import pulumi_linode as linode
        import pulumi_std as std

        object = linode.ObjectStorageObject("object",
            bucket="my-bucket",
            region="us-mia",
            key="my-object",
            secret_key=my_key["secretKey"],
            access_key=my_key["accessKey"],
            source=std.pathexpand(input="~/files/log.txt").result)
        ```

        ### Uploading plaintext to a bucket

        ```python
        import pulumi
        import pulumi_linode as linode

        object = linode.ObjectStorageObject("object",
            bucket="my-bucket",
            region="us-mia",
            key="my-object",
            secret_key=my_key["secretKey"],
            access_key=my_key["accessKey"],
            content="This is the content of the Object...",
            content_type="text/plain",
            content_language="en")
        ```

        ### Creating an object using implicitly created object credentials

        ```python
        import pulumi
        import pulumi_linode as linode
        import pulumi_std as std

        object = linode.ObjectStorageObject("object",
            bucket="my-bucket",
            region="us-mia",
            key="my-object",
            source=std.pathexpand(input="~/files/log.txt").result)
        ```

        :param str resource_name: The name of the resource.
        :param ObjectStorageObjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ObjectStorageObjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[builtins.str]] = None,
                 acl: Optional[pulumi.Input[builtins.str]] = None,
                 bucket: Optional[pulumi.Input[builtins.str]] = None,
                 cache_control: Optional[pulumi.Input[builtins.str]] = None,
                 cluster: Optional[pulumi.Input[builtins.str]] = None,
                 content: Optional[pulumi.Input[builtins.str]] = None,
                 content_base64: Optional[pulumi.Input[builtins.str]] = None,
                 content_disposition: Optional[pulumi.Input[builtins.str]] = None,
                 content_encoding: Optional[pulumi.Input[builtins.str]] = None,
                 content_language: Optional[pulumi.Input[builtins.str]] = None,
                 content_type: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 force_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[builtins.str]] = None,
                 source: Optional[pulumi.Input[builtins.str]] = None,
                 website_redirect: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ObjectStorageObjectArgs.__new__(ObjectStorageObjectArgs)

            __props__.__dict__["access_key"] = access_key
            __props__.__dict__["acl"] = acl
            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            __props__.__dict__["cache_control"] = cache_control
            __props__.__dict__["cluster"] = cluster
            __props__.__dict__["content"] = content
            __props__.__dict__["content_base64"] = content_base64
            __props__.__dict__["content_disposition"] = content_disposition
            __props__.__dict__["content_encoding"] = content_encoding
            __props__.__dict__["content_language"] = content_language
            __props__.__dict__["content_type"] = content_type
            __props__.__dict__["endpoint"] = endpoint
            __props__.__dict__["etag"] = etag
            __props__.__dict__["force_destroy"] = force_destroy
            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__.__dict__["key"] = key
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["region"] = region
            __props__.__dict__["secret_key"] = None if secret_key is None else pulumi.Output.secret(secret_key)
            __props__.__dict__["source"] = source
            __props__.__dict__["website_redirect"] = website_redirect
            __props__.__dict__["version_id"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["secretKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ObjectStorageObject, __self__).__init__(
            'linode:index/objectStorageObject:ObjectStorageObject',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_key: Optional[pulumi.Input[builtins.str]] = None,
            acl: Optional[pulumi.Input[builtins.str]] = None,
            bucket: Optional[pulumi.Input[builtins.str]] = None,
            cache_control: Optional[pulumi.Input[builtins.str]] = None,
            cluster: Optional[pulumi.Input[builtins.str]] = None,
            content: Optional[pulumi.Input[builtins.str]] = None,
            content_base64: Optional[pulumi.Input[builtins.str]] = None,
            content_disposition: Optional[pulumi.Input[builtins.str]] = None,
            content_encoding: Optional[pulumi.Input[builtins.str]] = None,
            content_language: Optional[pulumi.Input[builtins.str]] = None,
            content_type: Optional[pulumi.Input[builtins.str]] = None,
            endpoint: Optional[pulumi.Input[builtins.str]] = None,
            etag: Optional[pulumi.Input[builtins.str]] = None,
            force_destroy: Optional[pulumi.Input[builtins.bool]] = None,
            key: Optional[pulumi.Input[builtins.str]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            secret_key: Optional[pulumi.Input[builtins.str]] = None,
            source: Optional[pulumi.Input[builtins.str]] = None,
            version_id: Optional[pulumi.Input[builtins.str]] = None,
            website_redirect: Optional[pulumi.Input[builtins.str]] = None) -> 'ObjectStorageObject':
        """
        Get an existing ObjectStorageObject resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] access_key: The REQUIRED access key to authenticate with. If it's not specified with the resource, you must provide its value by
               * configuring the `obj_access_key` in the provider configuration;
               * or, opting-in generating it implicitly at apply-time using `obj_use_temp_keys` at provider-level.
        :param pulumi.Input[builtins.str] acl: The canned ACL to apply. (`private`, `public-read`, `authenticated-read`, `public-read-write`, `custom`) (defaults to `private`).
        :param pulumi.Input[builtins.str] bucket: The name of the bucket to put the object in.
        :param pulumi.Input[builtins.str] cache_control: Specifies caching behavior along the request/reply chain Read [w3c cache_control](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9) for further details.
        :param pulumi.Input[builtins.str] cluster: The cluster the bucket is in. Required if `region` is not configured. Deprecated in favor of `region`.
        :param pulumi.Input[builtins.str] content: Literal string value to use as the object content, which will be uploaded as UTF-8-encoded text.
        :param pulumi.Input[builtins.str] content_base64: Base64-encoded data that will be decoded and uploaded as raw bytes for the object content. This allows safely uploading non-UTF8 binary data, but is recommended only for small content such as the result of the `gzipbase64` function with small text strings. For larger objects, use `source` to stream the content from a disk file.
        :param pulumi.Input[builtins.str] content_disposition: Specifies presentational information for the object. Read [w3c content_disposition](http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.5.1) for further information.
        :param pulumi.Input[builtins.str] content_encoding: Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Read [w3c content encoding](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.11) for further information.
        :param pulumi.Input[builtins.str] content_language: The language the content is in e.g. en-US or en-GB.
        :param pulumi.Input[builtins.str] content_type: A standard MIME type describing the format of the object data, e.g. application/octet-stream. All Valid MIME Types are valid for this input.
        :param pulumi.Input[builtins.str] endpoint: Used with the s3 client to make bucket changes and will be computed automatically if left blank, override for testing/debug purposes.
        :param pulumi.Input[builtins.str] etag: The specific version of this object.
        :param pulumi.Input[builtins.bool] force_destroy: Allow the object to be deleted regardless of any legal hold or object lock (defaults to `false`).
        :param pulumi.Input[builtins.str] key: They name of the object once it is in the bucket.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: A map of keys/values to provision metadata.
        :param pulumi.Input[builtins.str] region: The cluster the bucket is in. Required if `cluster` is not configured.
        :param pulumi.Input[builtins.str] secret_key: The REQUIRED secret key to authenticate with. If it's not specified with the resource, you must provide its value by
               * configuring the `obj_secret_key` in the provider configuration;
               * or, opting-in generating it implicitly at apply-time using `obj_use_temp_keys` at provider-level.
        :param pulumi.Input[builtins.str] source: The path to a file that will be read and uploaded as raw bytes for the object content. The path must either be relative to the root module or absolute.
        :param pulumi.Input[builtins.str] version_id: A unique version ID value for the object.
        :param pulumi.Input[builtins.str] website_redirect: Specifies a target URL for website redirect.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ObjectStorageObjectState.__new__(_ObjectStorageObjectState)

        __props__.__dict__["access_key"] = access_key
        __props__.__dict__["acl"] = acl
        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["cache_control"] = cache_control
        __props__.__dict__["cluster"] = cluster
        __props__.__dict__["content"] = content
        __props__.__dict__["content_base64"] = content_base64
        __props__.__dict__["content_disposition"] = content_disposition
        __props__.__dict__["content_encoding"] = content_encoding
        __props__.__dict__["content_language"] = content_language
        __props__.__dict__["content_type"] = content_type
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["etag"] = etag
        __props__.__dict__["force_destroy"] = force_destroy
        __props__.__dict__["key"] = key
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["region"] = region
        __props__.__dict__["secret_key"] = secret_key
        __props__.__dict__["source"] = source
        __props__.__dict__["version_id"] = version_id
        __props__.__dict__["website_redirect"] = website_redirect
        return ObjectStorageObject(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The REQUIRED access key to authenticate with. If it's not specified with the resource, you must provide its value by
        * configuring the `obj_access_key` in the provider configuration;
        * or, opting-in generating it implicitly at apply-time using `obj_use_temp_keys` at provider-level.
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter
    def acl(self) -> pulumi.Output[builtins.str]:
        """
        The canned ACL to apply. (`private`, `public-read`, `authenticated-read`, `public-read-write`, `custom`) (defaults to `private`).
        """
        return pulumi.get(self, "acl")

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[builtins.str]:
        """
        The name of the bucket to put the object in.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="cacheControl")
    def cache_control(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies caching behavior along the request/reply chain Read [w3c cache_control](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9) for further details.
        """
        return pulumi.get(self, "cache_control")

    @property
    @pulumi.getter
    @_utilities.deprecated("""The cluster attribute has been deprecated, please consider switching to the region attribute. For example, a cluster value of `us-mia-1` can be translated to a region value of `us-mia`.""")
    def cluster(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The cluster the bucket is in. Required if `region` is not configured. Deprecated in favor of `region`.
        """
        return pulumi.get(self, "cluster")

    @property
    @pulumi.getter
    def content(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Literal string value to use as the object content, which will be uploaded as UTF-8-encoded text.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="contentBase64")
    def content_base64(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Base64-encoded data that will be decoded and uploaded as raw bytes for the object content. This allows safely uploading non-UTF8 binary data, but is recommended only for small content such as the result of the `gzipbase64` function with small text strings. For larger objects, use `source` to stream the content from a disk file.
        """
        return pulumi.get(self, "content_base64")

    @property
    @pulumi.getter(name="contentDisposition")
    def content_disposition(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies presentational information for the object. Read [w3c content_disposition](http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.5.1) for further information.
        """
        return pulumi.get(self, "content_disposition")

    @property
    @pulumi.getter(name="contentEncoding")
    def content_encoding(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Read [w3c content encoding](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.11) for further information.
        """
        return pulumi.get(self, "content_encoding")

    @property
    @pulumi.getter(name="contentLanguage")
    def content_language(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The language the content is in e.g. en-US or en-GB.
        """
        return pulumi.get(self, "content_language")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> pulumi.Output[builtins.str]:
        """
        A standard MIME type describing the format of the object data, e.g. application/octet-stream. All Valid MIME Types are valid for this input.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[builtins.str]:
        """
        Used with the s3 client to make bucket changes and will be computed automatically if left blank, override for testing/debug purposes.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[builtins.str]:
        """
        The specific version of this object.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> pulumi.Output[builtins.bool]:
        """
        Allow the object to be deleted regardless of any legal hold or object lock (defaults to `false`).
        """
        return pulumi.get(self, "force_destroy")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[builtins.str]:
        """
        They name of the object once it is in the bucket.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of keys/values to provision metadata.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The cluster the bucket is in. Required if `cluster` is not configured.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The REQUIRED secret key to authenticate with. If it's not specified with the resource, you must provide its value by
        * configuring the `obj_secret_key` in the provider configuration;
        * or, opting-in generating it implicitly at apply-time using `obj_use_temp_keys` at provider-level.
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The path to a file that will be read and uploaded as raw bytes for the object content. The path must either be relative to the root module or absolute.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> pulumi.Output[builtins.str]:
        """
        A unique version ID value for the object.
        """
        return pulumi.get(self, "version_id")

    @property
    @pulumi.getter(name="websiteRedirect")
    def website_redirect(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies a target URL for website redirect.
        """
        return pulumi.get(self, "website_redirect")

