"Main interface for stepfunctions service type defs"
from datetime import datetime
import sys
from typing import List

if sys.version_info >= (3, 8):
    from typing import Literal
else:
    from typing_extensions import Literal
if sys.version_info >= (3, 8):
    from typing import TypedDict
else:
    from typing_extensions import TypedDict


CreateActivityOutputTypeDef = TypedDict(
    "CreateActivityOutputTypeDef", {"activityArn": str, "creationDate": datetime}
)

CreateStateMachineOutputTypeDef = TypedDict(
    "CreateStateMachineOutputTypeDef", {"stateMachineArn": str, "creationDate": datetime}
)

DescribeActivityOutputTypeDef = TypedDict(
    "DescribeActivityOutputTypeDef", {"activityArn": str, "name": str, "creationDate": datetime}
)

_RequiredDescribeExecutionOutputTypeDef = TypedDict(
    "_RequiredDescribeExecutionOutputTypeDef",
    {
        "executionArn": str,
        "stateMachineArn": str,
        "status": Literal["RUNNING", "SUCCEEDED", "FAILED", "TIMED_OUT", "ABORTED"],
        "startDate": datetime,
        "input": str,
    },
)
_OptionalDescribeExecutionOutputTypeDef = TypedDict(
    "_OptionalDescribeExecutionOutputTypeDef",
    {"name": str, "stopDate": datetime, "output": str},
    total=False,
)


class DescribeExecutionOutputTypeDef(
    _RequiredDescribeExecutionOutputTypeDef, _OptionalDescribeExecutionOutputTypeDef
):
    pass


DescribeStateMachineForExecutionOutputTypeDef = TypedDict(
    "DescribeStateMachineForExecutionOutputTypeDef",
    {
        "stateMachineArn": str,
        "name": str,
        "definition": str,
        "roleArn": str,
        "updateDate": datetime,
    },
)

CloudWatchLogsLogGroupTypeDef = TypedDict(
    "CloudWatchLogsLogGroupTypeDef", {"logGroupArn": str}, total=False
)

LogDestinationTypeDef = TypedDict(
    "LogDestinationTypeDef", {"cloudWatchLogsLogGroup": CloudWatchLogsLogGroupTypeDef}, total=False
)

LoggingConfigurationTypeDef = TypedDict(
    "LoggingConfigurationTypeDef",
    {
        "level": Literal["ALL", "ERROR", "FATAL", "OFF"],
        "includeExecutionData": bool,
        "destinations": List[LogDestinationTypeDef],
    },
    total=False,
)

_RequiredDescribeStateMachineOutputTypeDef = TypedDict(
    "_RequiredDescribeStateMachineOutputTypeDef",
    {
        "stateMachineArn": str,
        "name": str,
        "definition": str,
        "roleArn": str,
        "type": Literal["STANDARD", "EXPRESS"],
        "creationDate": datetime,
    },
)
_OptionalDescribeStateMachineOutputTypeDef = TypedDict(
    "_OptionalDescribeStateMachineOutputTypeDef",
    {"status": Literal["ACTIVE", "DELETING"], "loggingConfiguration": LoggingConfigurationTypeDef},
    total=False,
)


class DescribeStateMachineOutputTypeDef(
    _RequiredDescribeStateMachineOutputTypeDef, _OptionalDescribeStateMachineOutputTypeDef
):
    pass


GetActivityTaskOutputTypeDef = TypedDict(
    "GetActivityTaskOutputTypeDef", {"taskToken": str, "input": str}, total=False
)

ActivityFailedEventDetailsTypeDef = TypedDict(
    "ActivityFailedEventDetailsTypeDef", {"error": str, "cause": str}, total=False
)

ActivityScheduleFailedEventDetailsTypeDef = TypedDict(
    "ActivityScheduleFailedEventDetailsTypeDef", {"error": str, "cause": str}, total=False
)

_RequiredActivityScheduledEventDetailsTypeDef = TypedDict(
    "_RequiredActivityScheduledEventDetailsTypeDef", {"resource": str}
)
_OptionalActivityScheduledEventDetailsTypeDef = TypedDict(
    "_OptionalActivityScheduledEventDetailsTypeDef",
    {"input": str, "timeoutInSeconds": int, "heartbeatInSeconds": int},
    total=False,
)


class ActivityScheduledEventDetailsTypeDef(
    _RequiredActivityScheduledEventDetailsTypeDef, _OptionalActivityScheduledEventDetailsTypeDef
):
    pass


ActivityStartedEventDetailsTypeDef = TypedDict(
    "ActivityStartedEventDetailsTypeDef", {"workerName": str}, total=False
)

ActivitySucceededEventDetailsTypeDef = TypedDict(
    "ActivitySucceededEventDetailsTypeDef", {"output": str}, total=False
)

ActivityTimedOutEventDetailsTypeDef = TypedDict(
    "ActivityTimedOutEventDetailsTypeDef", {"error": str, "cause": str}, total=False
)

ExecutionAbortedEventDetailsTypeDef = TypedDict(
    "ExecutionAbortedEventDetailsTypeDef", {"error": str, "cause": str}, total=False
)

ExecutionFailedEventDetailsTypeDef = TypedDict(
    "ExecutionFailedEventDetailsTypeDef", {"error": str, "cause": str}, total=False
)

ExecutionStartedEventDetailsTypeDef = TypedDict(
    "ExecutionStartedEventDetailsTypeDef", {"input": str, "roleArn": str}, total=False
)

ExecutionSucceededEventDetailsTypeDef = TypedDict(
    "ExecutionSucceededEventDetailsTypeDef", {"output": str}, total=False
)

ExecutionTimedOutEventDetailsTypeDef = TypedDict(
    "ExecutionTimedOutEventDetailsTypeDef", {"error": str, "cause": str}, total=False
)

LambdaFunctionFailedEventDetailsTypeDef = TypedDict(
    "LambdaFunctionFailedEventDetailsTypeDef", {"error": str, "cause": str}, total=False
)

LambdaFunctionScheduleFailedEventDetailsTypeDef = TypedDict(
    "LambdaFunctionScheduleFailedEventDetailsTypeDef", {"error": str, "cause": str}, total=False
)

_RequiredLambdaFunctionScheduledEventDetailsTypeDef = TypedDict(
    "_RequiredLambdaFunctionScheduledEventDetailsTypeDef", {"resource": str}
)
_OptionalLambdaFunctionScheduledEventDetailsTypeDef = TypedDict(
    "_OptionalLambdaFunctionScheduledEventDetailsTypeDef",
    {"input": str, "timeoutInSeconds": int},
    total=False,
)


class LambdaFunctionScheduledEventDetailsTypeDef(
    _RequiredLambdaFunctionScheduledEventDetailsTypeDef,
    _OptionalLambdaFunctionScheduledEventDetailsTypeDef,
):
    pass


LambdaFunctionStartFailedEventDetailsTypeDef = TypedDict(
    "LambdaFunctionStartFailedEventDetailsTypeDef", {"error": str, "cause": str}, total=False
)

LambdaFunctionSucceededEventDetailsTypeDef = TypedDict(
    "LambdaFunctionSucceededEventDetailsTypeDef", {"output": str}, total=False
)

LambdaFunctionTimedOutEventDetailsTypeDef = TypedDict(
    "LambdaFunctionTimedOutEventDetailsTypeDef", {"error": str, "cause": str}, total=False
)

MapIterationEventDetailsTypeDef = TypedDict(
    "MapIterationEventDetailsTypeDef", {"name": str, "index": int}, total=False
)

MapStateStartedEventDetailsTypeDef = TypedDict(
    "MapStateStartedEventDetailsTypeDef", {"length": int}, total=False
)

_RequiredStateEnteredEventDetailsTypeDef = TypedDict(
    "_RequiredStateEnteredEventDetailsTypeDef", {"name": str}
)
_OptionalStateEnteredEventDetailsTypeDef = TypedDict(
    "_OptionalStateEnteredEventDetailsTypeDef", {"input": str}, total=False
)


class StateEnteredEventDetailsTypeDef(
    _RequiredStateEnteredEventDetailsTypeDef, _OptionalStateEnteredEventDetailsTypeDef
):
    pass


_RequiredStateExitedEventDetailsTypeDef = TypedDict(
    "_RequiredStateExitedEventDetailsTypeDef", {"name": str}
)
_OptionalStateExitedEventDetailsTypeDef = TypedDict(
    "_OptionalStateExitedEventDetailsTypeDef", {"output": str}, total=False
)


class StateExitedEventDetailsTypeDef(
    _RequiredStateExitedEventDetailsTypeDef, _OptionalStateExitedEventDetailsTypeDef
):
    pass


_RequiredTaskFailedEventDetailsTypeDef = TypedDict(
    "_RequiredTaskFailedEventDetailsTypeDef", {"resourceType": str, "resource": str}
)
_OptionalTaskFailedEventDetailsTypeDef = TypedDict(
    "_OptionalTaskFailedEventDetailsTypeDef", {"error": str, "cause": str}, total=False
)


class TaskFailedEventDetailsTypeDef(
    _RequiredTaskFailedEventDetailsTypeDef, _OptionalTaskFailedEventDetailsTypeDef
):
    pass


_RequiredTaskScheduledEventDetailsTypeDef = TypedDict(
    "_RequiredTaskScheduledEventDetailsTypeDef",
    {"resourceType": str, "resource": str, "region": str, "parameters": str},
)
_OptionalTaskScheduledEventDetailsTypeDef = TypedDict(
    "_OptionalTaskScheduledEventDetailsTypeDef", {"timeoutInSeconds": int}, total=False
)


class TaskScheduledEventDetailsTypeDef(
    _RequiredTaskScheduledEventDetailsTypeDef, _OptionalTaskScheduledEventDetailsTypeDef
):
    pass


_RequiredTaskStartFailedEventDetailsTypeDef = TypedDict(
    "_RequiredTaskStartFailedEventDetailsTypeDef", {"resourceType": str, "resource": str}
)
_OptionalTaskStartFailedEventDetailsTypeDef = TypedDict(
    "_OptionalTaskStartFailedEventDetailsTypeDef", {"error": str, "cause": str}, total=False
)


class TaskStartFailedEventDetailsTypeDef(
    _RequiredTaskStartFailedEventDetailsTypeDef, _OptionalTaskStartFailedEventDetailsTypeDef
):
    pass


TaskStartedEventDetailsTypeDef = TypedDict(
    "TaskStartedEventDetailsTypeDef", {"resourceType": str, "resource": str}
)

_RequiredTaskSubmitFailedEventDetailsTypeDef = TypedDict(
    "_RequiredTaskSubmitFailedEventDetailsTypeDef", {"resourceType": str, "resource": str}
)
_OptionalTaskSubmitFailedEventDetailsTypeDef = TypedDict(
    "_OptionalTaskSubmitFailedEventDetailsTypeDef", {"error": str, "cause": str}, total=False
)


class TaskSubmitFailedEventDetailsTypeDef(
    _RequiredTaskSubmitFailedEventDetailsTypeDef, _OptionalTaskSubmitFailedEventDetailsTypeDef
):
    pass


_RequiredTaskSubmittedEventDetailsTypeDef = TypedDict(
    "_RequiredTaskSubmittedEventDetailsTypeDef", {"resourceType": str, "resource": str}
)
_OptionalTaskSubmittedEventDetailsTypeDef = TypedDict(
    "_OptionalTaskSubmittedEventDetailsTypeDef", {"output": str}, total=False
)


class TaskSubmittedEventDetailsTypeDef(
    _RequiredTaskSubmittedEventDetailsTypeDef, _OptionalTaskSubmittedEventDetailsTypeDef
):
    pass


_RequiredTaskSucceededEventDetailsTypeDef = TypedDict(
    "_RequiredTaskSucceededEventDetailsTypeDef", {"resourceType": str, "resource": str}
)
_OptionalTaskSucceededEventDetailsTypeDef = TypedDict(
    "_OptionalTaskSucceededEventDetailsTypeDef", {"output": str}, total=False
)


class TaskSucceededEventDetailsTypeDef(
    _RequiredTaskSucceededEventDetailsTypeDef, _OptionalTaskSucceededEventDetailsTypeDef
):
    pass


_RequiredTaskTimedOutEventDetailsTypeDef = TypedDict(
    "_RequiredTaskTimedOutEventDetailsTypeDef", {"resourceType": str, "resource": str}
)
_OptionalTaskTimedOutEventDetailsTypeDef = TypedDict(
    "_OptionalTaskTimedOutEventDetailsTypeDef", {"error": str, "cause": str}, total=False
)


class TaskTimedOutEventDetailsTypeDef(
    _RequiredTaskTimedOutEventDetailsTypeDef, _OptionalTaskTimedOutEventDetailsTypeDef
):
    pass


_RequiredHistoryEventTypeDef = TypedDict(
    "_RequiredHistoryEventTypeDef",
    {
        "timestamp": datetime,
        "type": Literal[
            "ActivityFailed",
            "ActivityScheduled",
            "ActivityScheduleFailed",
            "ActivityStarted",
            "ActivitySucceeded",
            "ActivityTimedOut",
            "ChoiceStateEntered",
            "ChoiceStateExited",
            "ExecutionAborted",
            "ExecutionFailed",
            "ExecutionStarted",
            "ExecutionSucceeded",
            "ExecutionTimedOut",
            "FailStateEntered",
            "LambdaFunctionFailed",
            "LambdaFunctionScheduled",
            "LambdaFunctionScheduleFailed",
            "LambdaFunctionStarted",
            "LambdaFunctionStartFailed",
            "LambdaFunctionSucceeded",
            "LambdaFunctionTimedOut",
            "MapIterationAborted",
            "MapIterationFailed",
            "MapIterationStarted",
            "MapIterationSucceeded",
            "MapStateAborted",
            "MapStateEntered",
            "MapStateExited",
            "MapStateFailed",
            "MapStateStarted",
            "MapStateSucceeded",
            "ParallelStateAborted",
            "ParallelStateEntered",
            "ParallelStateExited",
            "ParallelStateFailed",
            "ParallelStateStarted",
            "ParallelStateSucceeded",
            "PassStateEntered",
            "PassStateExited",
            "SucceedStateEntered",
            "SucceedStateExited",
            "TaskFailed",
            "TaskScheduled",
            "TaskStarted",
            "TaskStartFailed",
            "TaskStateAborted",
            "TaskStateEntered",
            "TaskStateExited",
            "TaskSubmitFailed",
            "TaskSubmitted",
            "TaskSucceeded",
            "TaskTimedOut",
            "WaitStateAborted",
            "WaitStateEntered",
            "WaitStateExited",
        ],
        "id": int,
    },
)
_OptionalHistoryEventTypeDef = TypedDict(
    "_OptionalHistoryEventTypeDef",
    {
        "previousEventId": int,
        "activityFailedEventDetails": ActivityFailedEventDetailsTypeDef,
        "activityScheduleFailedEventDetails": ActivityScheduleFailedEventDetailsTypeDef,
        "activityScheduledEventDetails": ActivityScheduledEventDetailsTypeDef,
        "activityStartedEventDetails": ActivityStartedEventDetailsTypeDef,
        "activitySucceededEventDetails": ActivitySucceededEventDetailsTypeDef,
        "activityTimedOutEventDetails": ActivityTimedOutEventDetailsTypeDef,
        "taskFailedEventDetails": TaskFailedEventDetailsTypeDef,
        "taskScheduledEventDetails": TaskScheduledEventDetailsTypeDef,
        "taskStartFailedEventDetails": TaskStartFailedEventDetailsTypeDef,
        "taskStartedEventDetails": TaskStartedEventDetailsTypeDef,
        "taskSubmitFailedEventDetails": TaskSubmitFailedEventDetailsTypeDef,
        "taskSubmittedEventDetails": TaskSubmittedEventDetailsTypeDef,
        "taskSucceededEventDetails": TaskSucceededEventDetailsTypeDef,
        "taskTimedOutEventDetails": TaskTimedOutEventDetailsTypeDef,
        "executionFailedEventDetails": ExecutionFailedEventDetailsTypeDef,
        "executionStartedEventDetails": ExecutionStartedEventDetailsTypeDef,
        "executionSucceededEventDetails": ExecutionSucceededEventDetailsTypeDef,
        "executionAbortedEventDetails": ExecutionAbortedEventDetailsTypeDef,
        "executionTimedOutEventDetails": ExecutionTimedOutEventDetailsTypeDef,
        "mapStateStartedEventDetails": MapStateStartedEventDetailsTypeDef,
        "mapIterationStartedEventDetails": MapIterationEventDetailsTypeDef,
        "mapIterationSucceededEventDetails": MapIterationEventDetailsTypeDef,
        "mapIterationFailedEventDetails": MapIterationEventDetailsTypeDef,
        "mapIterationAbortedEventDetails": MapIterationEventDetailsTypeDef,
        "lambdaFunctionFailedEventDetails": LambdaFunctionFailedEventDetailsTypeDef,
        "lambdaFunctionScheduleFailedEventDetails": LambdaFunctionScheduleFailedEventDetailsTypeDef,
        "lambdaFunctionScheduledEventDetails": LambdaFunctionScheduledEventDetailsTypeDef,
        "lambdaFunctionStartFailedEventDetails": LambdaFunctionStartFailedEventDetailsTypeDef,
        "lambdaFunctionSucceededEventDetails": LambdaFunctionSucceededEventDetailsTypeDef,
        "lambdaFunctionTimedOutEventDetails": LambdaFunctionTimedOutEventDetailsTypeDef,
        "stateEnteredEventDetails": StateEnteredEventDetailsTypeDef,
        "stateExitedEventDetails": StateExitedEventDetailsTypeDef,
    },
    total=False,
)


class HistoryEventTypeDef(_RequiredHistoryEventTypeDef, _OptionalHistoryEventTypeDef):
    pass


_RequiredGetExecutionHistoryOutputTypeDef = TypedDict(
    "_RequiredGetExecutionHistoryOutputTypeDef", {"events": List[HistoryEventTypeDef]}
)
_OptionalGetExecutionHistoryOutputTypeDef = TypedDict(
    "_OptionalGetExecutionHistoryOutputTypeDef", {"nextToken": str}, total=False
)


class GetExecutionHistoryOutputTypeDef(
    _RequiredGetExecutionHistoryOutputTypeDef, _OptionalGetExecutionHistoryOutputTypeDef
):
    pass


ActivityListItemTypeDef = TypedDict(
    "ActivityListItemTypeDef", {"activityArn": str, "name": str, "creationDate": datetime}
)

_RequiredListActivitiesOutputTypeDef = TypedDict(
    "_RequiredListActivitiesOutputTypeDef", {"activities": List[ActivityListItemTypeDef]}
)
_OptionalListActivitiesOutputTypeDef = TypedDict(
    "_OptionalListActivitiesOutputTypeDef", {"nextToken": str}, total=False
)


class ListActivitiesOutputTypeDef(
    _RequiredListActivitiesOutputTypeDef, _OptionalListActivitiesOutputTypeDef
):
    pass


_RequiredExecutionListItemTypeDef = TypedDict(
    "_RequiredExecutionListItemTypeDef",
    {
        "executionArn": str,
        "stateMachineArn": str,
        "name": str,
        "status": Literal["RUNNING", "SUCCEEDED", "FAILED", "TIMED_OUT", "ABORTED"],
        "startDate": datetime,
    },
)
_OptionalExecutionListItemTypeDef = TypedDict(
    "_OptionalExecutionListItemTypeDef", {"stopDate": datetime}, total=False
)


class ExecutionListItemTypeDef(
    _RequiredExecutionListItemTypeDef, _OptionalExecutionListItemTypeDef
):
    pass


_RequiredListExecutionsOutputTypeDef = TypedDict(
    "_RequiredListExecutionsOutputTypeDef", {"executions": List[ExecutionListItemTypeDef]}
)
_OptionalListExecutionsOutputTypeDef = TypedDict(
    "_OptionalListExecutionsOutputTypeDef", {"nextToken": str}, total=False
)


class ListExecutionsOutputTypeDef(
    _RequiredListExecutionsOutputTypeDef, _OptionalListExecutionsOutputTypeDef
):
    pass


StateMachineListItemTypeDef = TypedDict(
    "StateMachineListItemTypeDef",
    {
        "stateMachineArn": str,
        "name": str,
        "type": Literal["STANDARD", "EXPRESS"],
        "creationDate": datetime,
    },
)

_RequiredListStateMachinesOutputTypeDef = TypedDict(
    "_RequiredListStateMachinesOutputTypeDef", {"stateMachines": List[StateMachineListItemTypeDef]}
)
_OptionalListStateMachinesOutputTypeDef = TypedDict(
    "_OptionalListStateMachinesOutputTypeDef", {"nextToken": str}, total=False
)


class ListStateMachinesOutputTypeDef(
    _RequiredListStateMachinesOutputTypeDef, _OptionalListStateMachinesOutputTypeDef
):
    pass


TagTypeDef = TypedDict("TagTypeDef", {"key": str, "value": str}, total=False)

ListTagsForResourceOutputTypeDef = TypedDict(
    "ListTagsForResourceOutputTypeDef", {"tags": List[TagTypeDef]}, total=False
)

PaginatorConfigTypeDef = TypedDict(
    "PaginatorConfigTypeDef", {"MaxItems": int, "PageSize": int, "StartingToken": str}, total=False
)

StartExecutionOutputTypeDef = TypedDict(
    "StartExecutionOutputTypeDef", {"executionArn": str, "startDate": datetime}
)

StopExecutionOutputTypeDef = TypedDict("StopExecutionOutputTypeDef", {"stopDate": datetime})

UpdateStateMachineOutputTypeDef = TypedDict(
    "UpdateStateMachineOutputTypeDef", {"updateDate": datetime}
)
