"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CdkTypeScriptApp = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const awscdk_1 = require("projen/lib/awscdk");
const codeowners_1 = require("../../components/github/codeowners");
const pull_request_template_1 = require("../../components/github/pull-request-template");
const readme_1 = require("../../components/readme");
const merge_options_1 = require("../../utils/merge-options");
function getOptions(options) {
    const { name } = options;
    const defaults = {
        name,
        defaultReleaseBranch: 'main',
        gitignore: ['.npmrc', '.vscode'],
        pullRequestTemplateContents: pull_request_template_1.DEFAULT_PULL_REQUEST_TEMPLATE,
        projenrcTs: true,
    };
    return (0, merge_options_1.mergeOptions)(defaults, options);
}
/**
 * A CDK application in TypeScript
 *
 *
 * @pjid cdk-typescript-app
 */
class CdkTypeScriptApp extends awscdk_1.AwsCdkTypeScriptApp {
    constructor(options) {
        const mergedOptions = getOptions(options);
        super({
            ...mergedOptions,
        });
        new codeowners_1.CodeOwners(this, mergedOptions.codeOwners);
        this.readme = new readme_1.Readme(this, {
            description: mergedOptions.readme?.description,
        });
        this.readme.addSection('Getting Started', '```sh\nyarn install\nnpx projen build\n```');
        if (this.autoMerge) {
            this.github?.mergify?.addRule({
                name: 'Automatic approval for projen upgrade pull requests',
                conditions: [
                    'author=endor-projen[bot]',
                    ...(this.buildWorkflow?.buildJobIds?.map((id) => `status-success=${id}`) ?? []),
                ],
                actions: {
                    review: {
                        type: 'APPROVE',
                        message: 'Automatically approving projen upgrade',
                    },
                },
            });
            this.github?.mergify?.addRule({
                name: 'Assign PR when check fails',
                conditions: ['#check-failure > 0'],
                actions: {
                    assign: {
                        add_users: ['daveshepherd'],
                    },
                },
            });
        }
    }
}
exports.CdkTypeScriptApp = CdkTypeScriptApp;
_a = JSII_RTTI_SYMBOL_1;
CdkTypeScriptApp[_a] = { fqn: "projen-modules.CdkTypeScriptApp", version: "1.0.100" };
__exportStar(require("./cdk-typescript-app-options"), exports);
//# sourceMappingURL=data:application/json;base64,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