# generated by datamodel-codegen:
#   filename:  software_application.yaml
#   timestamp: 2025-11-04T12:13:41+00:00

from __future__ import annotations

from datetime import date
from typing import Any, List, Literal, Optional, Union

from pydantic import AliasChoices, AnyUrl, AwareDatetime, EmailStr, Field, RootModel
from transpiler_mate import TranspilerBaseModel


class Organization(TranspilerBaseModel):
    """
    An organization such as a school, NGO, corporation, club, etc.
    """

    field_type: Literal['https://schema.org/Organization'] = Field(
        'https://schema.org/Organization', alias='@type'
    )
    name: str = Field(
        ...,
        validation_alias=AliasChoices('name', 'https://schema.org/name'),
        serialization_alias='https://schema.org/name',
    )
    email: Optional[Union[EmailStr, List[EmailStr]]] = Field(
        default=None,
        validation_alias=AliasChoices('email', 'https://schema.org/email'),
        serialization_alias='https://schema.org/email',
    )
    identifier: Optional[Union[AnyUrl, str]] = Field(
        default=None,
        validation_alias=AliasChoices('identifier', 'https://schema.org/identifier'),
        serialization_alias='https://schema.org/identifier',
    )


class Person(TranspilerBaseModel):
    """
    A person (alive, dead, undead, or fictional).
    """

    field_type: Literal['https://schema.org/Person'] = Field(
        'https://schema.org/Person', alias='@type'
    )
    given_name: str = Field(
        ...,
        validation_alias=AliasChoices('givenName', 'https://schema.org/givenName'),
        serialization_alias='https://schema.org/givenName',
    )
    family_name: str = Field(
        ...,
        validation_alias=AliasChoices('familyName', 'https://schema.org/familyName'),
        serialization_alias='https://schema.org/familyName',
    )
    email: Union[EmailStr, List[EmailStr]] = Field(
        ...,
        validation_alias=AliasChoices('email', 'https://schema.org/email'),
        serialization_alias='https://schema.org/email',
    )
    identifier: Optional[Union[AnyUrl, str]] = Field(
        default=None,
        validation_alias=AliasChoices('identifier', 'https://schema.org/identifier'),
        serialization_alias='https://schema.org/identifier',
    )
    affiliation: Union[Organization, List[Organization]] = Field(
        ...,
        validation_alias=AliasChoices('affiliation', 'https://schema.org/affiliation'),
        serialization_alias='https://schema.org/affiliation',
    )


class Role(TranspilerBaseModel):
    """
    Represents additional information about a relationship or property.
    """

    field_type: Literal['https://schema.org/Role'] = Field(
        'https://schema.org/Role', alias='@type'
    )
    role_name: str = Field(
        ...,
        validation_alias=AliasChoices('roleName', 'https://schema.org/roleName'),
        serialization_alias='https://schema.org/roleName',
    )
    start_date: Optional[date] = Field(
        default=None,
        validation_alias=AliasChoices('startDate', 'https://schema.org/startDate'),
        serialization_alias='https://schema.org/startDate',
    )
    end_date: Optional[date] = Field(
        default=None,
        validation_alias=AliasChoices('endDate', 'https://schema.org/endDate'),
        serialization_alias='https://schema.org/endDate',
    )
    additional_type: Optional[AnyUrl] = Field(
        default=None,
        validation_alias=AliasChoices(
            'additionalType', 'https://schema.org/additionalType'
        ),
        exclude=True, # NOTE manual workaround, CodeMeta Validator does not recognize 'additionalType'
    )


class AuthorRole(Role):
    author: Person = Field(
        ...,
        validation_alias=AliasChoices('author', 'https://schema.org/author'),
        serialization_alias='https://schema.org/schema:author', # NOTE manual workaround, CodeMeta Validator does not recognize unqualified author
    )


class ContributorRole(Role):
    contributor: Person = Field(
        ...,
        validation_alias=AliasChoices('contributor', 'https://schema.org/contributor'),
        serialization_alias='https://schema.org/contributor',
    )


class DefinedTerm(TranspilerBaseModel):
    """
    A word, name, acronym, phrase, etc. with a formal definition. Often used in the context of category or subject classification, glossaries or dictionaries, product or creative work types, etc. Use the name property for the term being defined, use termCode if the term has an alpha-numeric code allocated, use description to provide the definition of the term.
    """

    field_type: Literal['https://schema.org/DefinedTerm'] = Field(
        'https://schema.org/DefinedTerm', alias='@type'
    )
    name: Optional[str] = Field(
        default=None,
        validation_alias=AliasChoices('name', 'https://schema.org/name'),
        serialization_alias='https://schema.org/name',
    )
    description: Optional[str] = Field(
        default=None,
        validation_alias=AliasChoices('description', 'https://schema.org/description'),
        serialization_alias='https://schema.org/description',
    )
    term_code: Optional[str] = Field(
        default=None,
        validation_alias=AliasChoices('termCode', 'https://schema.org/termCode'),
        serialization_alias='https://schema.org/termCode',
    )
    in_defined_term_set: Optional[AnyUrl] = Field(
        default=None,
        validation_alias=AliasChoices(
            'inDefinedTermSet', 'https://schema.org/inDefinedTermSet'
        ),
        serialization_alias='https://schema.org/inDefinedTermSet',
    )


class CreativeWork(TranspilerBaseModel):
    """
    The most generic kind of creative work, including books, movies, photographs, software programs, etc.
    """

    field_type: Literal['https://schema.org/CreativeWork'] = Field(
        'https://schema.org/CreativeWork', alias='@type'
    )
    name: Optional[str] = Field(
        default=None,
        validation_alias=AliasChoices('name', 'https://schema.org/name'),
        serialization_alias='https://schema.org/name',
    )
    url: Optional[AnyUrl] = Field(
        default=None,
        validation_alias=AliasChoices('url', 'https://schema.org/url'),
        serialization_alias='https://schema.org/url',
    )
    identifier: Optional[Union[AnyUrl, str]] = Field(
        default=None,
        validation_alias=AliasChoices('identifier', 'https://schema.org/identifier'),
        serialization_alias='https://schema.org/identifier',
    )


class SoftwareApplication(TranspilerBaseModel):
    """
    A software application.
    """

    field_type: Literal['https://schema.org/SoftwareApplication'] = Field(
        'https://schema.org/SoftwareApplication', alias='@type'
    )
    name: str = Field(
        ...,
        validation_alias=AliasChoices('name', 'https://schema.org/name'),
        serialization_alias='https://schema.org/name',
    )
    description: str = Field(
        ...,
        validation_alias=AliasChoices('description', 'https://schema.org/description'),
        serialization_alias='https://schema.org/description',
    )
    date_created: Union[date, AwareDatetime] = Field(
        ...,
        validation_alias=AliasChoices('dateCreated', 'https://schema.org/dateCreated'),
        serialization_alias='https://schema.org/dateCreated',
    )
    license: Union[CreativeWork, AnyUrl, List[Union[CreativeWork, AnyUrl]]] = Field(
        ...,
        validation_alias=AliasChoices('license', 'https://schema.org/license'),
        serialization_alias='https://schema.org/license',
    )
    identifier: Optional[Union[AnyUrl, str]] = Field(
        default=None,
        validation_alias=AliasChoices('identifier', 'https://schema.org/identifier'),
        serialization_alias='https://schema.org/identifier',
    )
    same_as: Optional[Union[AnyUrl, List[AnyUrl]]] = Field(
        default=None,
        validation_alias=AliasChoices('sameAs', 'https://schema.org/sameAs'),
        serialization_alias='https://schema.org/sameAs',
    )
    keywords: Optional[
        Union[str, AnyUrl, DefinedTerm, List[Union[str, AnyUrl, DefinedTerm]]]
    ] = Field(
        default=None,
        validation_alias=AliasChoices('keywords', 'https://schema.org/keywords'),
        serialization_alias='https://schema.org/keywords',
    )
    operating_system: Optional[Union[str, List[str]]] = Field(
        default=None,
        validation_alias=AliasChoices(
            'operatingSystem', 'https://schema.org/operatingSystem'
        ),
        serialization_alias='https://schema.org/operatingSystem',
    )
    software_requirements: Optional[
        Union[str, AnyUrl, List[Union[str, AnyUrl]]]
    ] = Field(
        default=None,
        validation_alias=AliasChoices(
            'softwareRequirements', 'https://schema.org/softwareRequirements'
        ),
        serialization_alias='https://schema.org/softwareRequirements',
    )
    software_version: str = Field(
        ...,
        validation_alias=AliasChoices(
            'softwareVersion', 'https://schema.org/softwareVersion'
        ),
        serialization_alias='https://schema.org/softwareVersion',
    )
    software_help: Union[CreativeWork, List[CreativeWork]] = Field(
        ...,
        validation_alias=AliasChoices(
            'softwareHelp', 'https://schema.org/softwareHelp'
        ),
        serialization_alias='https://schema.org/softwareHelp',
    )
    publisher: Organization = Field(
        ...,
        validation_alias=AliasChoices('publisher', 'https://schema.org/publisher'),
        serialization_alias='https://schema.org/publisher',
    )
    author: Union[AuthorRole, Person, List[Union[AuthorRole, Person]]] = Field(
        ...,
        validation_alias=AliasChoices('author', 'https://schema.org/author'),
        serialization_alias='https://schema.org/author',
    )
    contributor: Optional[
        Union[ContributorRole, Person, List[Union[ContributorRole, Person]]]
    ] = Field(
        default=None,
        validation_alias=AliasChoices('contributor', 'https://schema.org/contributor'),
        serialization_alias='https://schema.org/contributor',
    )


class Model(RootModel[SoftwareApplication]):
    root: SoftwareApplication
