# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FileArgs', 'File']

@pulumi.input_type
class FileArgs:
    def __init__(__self__, *,
                 output_path: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 exclude_symlink_directories: Optional[pulumi.Input[_builtins.bool]] = None,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 output_file_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 source_content: Optional[pulumi.Input[_builtins.str]] = None,
                 source_content_filename: Optional[pulumi.Input[_builtins.str]] = None,
                 source_dir: Optional[pulumi.Input[_builtins.str]] = None,
                 source_file: Optional[pulumi.Input[_builtins.str]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input['FileSourceArgs']]]] = None):
        """
        The set of arguments for constructing a File resource.
        :param pulumi.Input[_builtins.str] output_path: The output of the archive file.
        :param pulumi.Input[_builtins.str] type: The type of archive to generate. NOTE: `zip` and `tar.gz` is supported.
        :param pulumi.Input[_builtins.bool] exclude_symlink_directories: Boolean flag indicating whether symbolically linked directories should be excluded during the creation of the archive. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excludes: Specify files/directories to ignore when reading the `source_dir`. Supports glob file matching patterns including doublestar/globstar (`**`) patterns.
        :param pulumi.Input[_builtins.str] output_file_mode: String that specifies the octal file mode for all archived files. For example: `"0666"`. Setting this will ensure that cross platform usage of this module will not vary the modes of archived files (and ultimately checksums) resulting in more deterministic behavior.
        :param pulumi.Input[_builtins.str] source_content: Add only this content to the archive with `source_content_filename` as the filename. One and only one of `source`, `source_content_filename` (with `source_content`), `source_file`, or `source_dir` must be specified.
        :param pulumi.Input[_builtins.str] source_content_filename: Set this as the filename when using `source_content`. One and only one of `source`, `source_content_filename` (with `source_content`), `source_file`, or `source_dir` must be specified.
        :param pulumi.Input[_builtins.str] source_dir: Package entire contents of this directory into the archive. One and only one of `source`, `source_content_filename` (with `source_content`), `source_file`, or `source_dir` must be specified.
        :param pulumi.Input[_builtins.str] source_file: Package this file into the archive. One and only one of `source`, `source_content_filename` (with `source_content`), `source_file`, or `source_dir` must be specified.
        :param pulumi.Input[Sequence[pulumi.Input['FileSourceArgs']]] sources: Specifies attributes of a single source file to include into the archive. One and only one of `source`, `source_content_filename` (with `source_content`), `source_file`, or `source_dir` must be specified.
        """
        pulumi.set(__self__, "output_path", output_path)
        pulumi.set(__self__, "type", type)
        if exclude_symlink_directories is not None:
            pulumi.set(__self__, "exclude_symlink_directories", exclude_symlink_directories)
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if output_file_mode is not None:
            pulumi.set(__self__, "output_file_mode", output_file_mode)
        if source_content is not None:
            pulumi.set(__self__, "source_content", source_content)
        if source_content_filename is not None:
            pulumi.set(__self__, "source_content_filename", source_content_filename)
        if source_dir is not None:
            pulumi.set(__self__, "source_dir", source_dir)
        if source_file is not None:
            pulumi.set(__self__, "source_file", source_file)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)

    @_builtins.property
    @pulumi.getter(name="outputPath")
    def output_path(self) -> pulumi.Input[_builtins.str]:
        """
        The output of the archive file.
        """
        return pulumi.get(self, "output_path")

    @output_path.setter
    def output_path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "output_path", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of archive to generate. NOTE: `zip` and `tar.gz` is supported.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="excludeSymlinkDirectories")
    def exclude_symlink_directories(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean flag indicating whether symbolically linked directories should be excluded during the creation of the archive. Defaults to `false`.
        """
        return pulumi.get(self, "exclude_symlink_directories")

    @exclude_symlink_directories.setter
    def exclude_symlink_directories(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "exclude_symlink_directories", value)

    @_builtins.property
    @pulumi.getter
    def excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specify files/directories to ignore when reading the `source_dir`. Supports glob file matching patterns including doublestar/globstar (`**`) patterns.
        """
        return pulumi.get(self, "excludes")

    @excludes.setter
    def excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "excludes", value)

    @_builtins.property
    @pulumi.getter(name="outputFileMode")
    def output_file_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        String that specifies the octal file mode for all archived files. For example: `"0666"`. Setting this will ensure that cross platform usage of this module will not vary the modes of archived files (and ultimately checksums) resulting in more deterministic behavior.
        """
        return pulumi.get(self, "output_file_mode")

    @output_file_mode.setter
    def output_file_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "output_file_mode", value)

    @_builtins.property
    @pulumi.getter(name="sourceContent")
    def source_content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Add only this content to the archive with `source_content_filename` as the filename. One and only one of `source`, `source_content_filename` (with `source_content`), `source_file`, or `source_dir` must be specified.
        """
        return pulumi.get(self, "source_content")

    @source_content.setter
    def source_content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_content", value)

    @_builtins.property
    @pulumi.getter(name="sourceContentFilename")
    def source_content_filename(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set this as the filename when using `source_content`. One and only one of `source`, `source_content_filename` (with `source_content`), `source_file`, or `source_dir` must be specified.
        """
        return pulumi.get(self, "source_content_filename")

    @source_content_filename.setter
    def source_content_filename(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_content_filename", value)

    @_builtins.property
    @pulumi.getter(name="sourceDir")
    def source_dir(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Package entire contents of this directory into the archive. One and only one of `source`, `source_content_filename` (with `source_content`), `source_file`, or `source_dir` must be specified.
        """
        return pulumi.get(self, "source_dir")

    @source_dir.setter
    def source_dir(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_dir", value)

    @_builtins.property
    @pulumi.getter(name="sourceFile")
    def source_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Package this file into the archive. One and only one of `source`, `source_content_filename` (with `source_content`), `source_file`, or `source_dir` must be specified.
        """
        return pulumi.get(self, "source_file")

    @source_file.setter
    def source_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_file", value)

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FileSourceArgs']]]]:
        """
        Specifies attributes of a single source file to include into the archive. One and only one of `source`, `source_content_filename` (with `source_content`), `source_file`, or `source_dir` must be specified.
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FileSourceArgs']]]]):
        pulumi.set(self, "sources", value)


@pulumi.input_type
class _FileState:
    def __init__(__self__, *,
                 exclude_symlink_directories: Optional[pulumi.Input[_builtins.bool]] = None,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 output_base64sha256: Optional[pulumi.Input[_builtins.str]] = None,
                 output_base64sha512: Optional[pulumi.Input[_builtins.str]] = None,
                 output_file_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 output_md5: Optional[pulumi.Input[_builtins.str]] = None,
                 output_path: Optional[pulumi.Input[_builtins.str]] = None,
                 output_sha: Optional[pulumi.Input[_builtins.str]] = None,
                 output_sha256: Optional[pulumi.Input[_builtins.str]] = None,
                 output_sha512: Optional[pulumi.Input[_builtins.str]] = None,
                 output_size: Optional[pulumi.Input[_builtins.int]] = None,
                 source_content: Optional[pulumi.Input[_builtins.str]] = None,
                 source_content_filename: Optional[pulumi.Input[_builtins.str]] = None,
                 source_dir: Optional[pulumi.Input[_builtins.str]] = None,
                 source_file: Optional[pulumi.Input[_builtins.str]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input['FileSourceArgs']]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering File resources.
        :param pulumi.Input[_builtins.bool] exclude_symlink_directories: Boolean flag indicating whether symbolically linked directories should be excluded during the creation of the archive. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excludes: Specify files/directories to ignore when reading the `source_dir`. Supports glob file matching patterns including doublestar/globstar (`**`) patterns.
        :param pulumi.Input[_builtins.str] output_base64sha256: Base64 Encoded SHA256 checksum of output file
        :param pulumi.Input[_builtins.str] output_base64sha512: Base64 Encoded SHA512 checksum of output file
        :param pulumi.Input[_builtins.str] output_file_mode: String that specifies the octal file mode for all archived files. For example: `"0666"`. Setting this will ensure that cross platform usage of this module will not vary the modes of archived files (and ultimately checksums) resulting in more deterministic behavior.
        :param pulumi.Input[_builtins.str] output_md5: MD5 of output file
        :param pulumi.Input[_builtins.str] output_path: The output of the archive file.
        :param pulumi.Input[_builtins.str] output_sha: SHA1 checksum of output file
        :param pulumi.Input[_builtins.str] output_sha256: SHA256 checksum of output file
        :param pulumi.Input[_builtins.str] output_sha512: SHA512 checksum of output file
        :param pulumi.Input[_builtins.int] output_size: The byte size of the output archive file.
        :param pulumi.Input[_builtins.str] source_content: Add only this content to the archive with `source_content_filename` as the filename. One and only one of `source`, `source_content_filename` (with `source_content`), `source_file`, or `source_dir` must be specified.
        :param pulumi.Input[_builtins.str] source_content_filename: Set this as the filename when using `source_content`. One and only one of `source`, `source_content_filename` (with `source_content`), `source_file`, or `source_dir` must be specified.
        :param pulumi.Input[_builtins.str] source_dir: Package entire contents of this directory into the archive. One and only one of `source`, `source_content_filename` (with `source_content`), `source_file`, or `source_dir` must be specified.
        :param pulumi.Input[_builtins.str] source_file: Package this file into the archive. One and only one of `source`, `source_content_filename` (with `source_content`), `source_file`, or `source_dir` must be specified.
        :param pulumi.Input[Sequence[pulumi.Input['FileSourceArgs']]] sources: Specifies attributes of a single source file to include into the archive. One and only one of `source`, `source_content_filename` (with `source_content`), `source_file`, or `source_dir` must be specified.
        :param pulumi.Input[_builtins.str] type: The type of archive to generate. NOTE: `zip` and `tar.gz` is supported.
        """
        if exclude_symlink_directories is not None:
            pulumi.set(__self__, "exclude_symlink_directories", exclude_symlink_directories)
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if output_base64sha256 is not None:
            pulumi.set(__self__, "output_base64sha256", output_base64sha256)
        if output_base64sha512 is not None:
            pulumi.set(__self__, "output_base64sha512", output_base64sha512)
        if output_file_mode is not None:
            pulumi.set(__self__, "output_file_mode", output_file_mode)
        if output_md5 is not None:
            pulumi.set(__self__, "output_md5", output_md5)
        if output_path is not None:
            pulumi.set(__self__, "output_path", output_path)
        if output_sha is not None:
            pulumi.set(__self__, "output_sha", output_sha)
        if output_sha256 is not None:
            pulumi.set(__self__, "output_sha256", output_sha256)
        if output_sha512 is not None:
            pulumi.set(__self__, "output_sha512", output_sha512)
        if output_size is not None:
            pulumi.set(__self__, "output_size", output_size)
        if source_content is not None:
            pulumi.set(__self__, "source_content", source_content)
        if source_content_filename is not None:
            pulumi.set(__self__, "source_content_filename", source_content_filename)
        if source_dir is not None:
            pulumi.set(__self__, "source_dir", source_dir)
        if source_file is not None:
            pulumi.set(__self__, "source_file", source_file)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="excludeSymlinkDirectories")
    def exclude_symlink_directories(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean flag indicating whether symbolically linked directories should be excluded during the creation of the archive. Defaults to `false`.
        """
        return pulumi.get(self, "exclude_symlink_directories")

    @exclude_symlink_directories.setter
    def exclude_symlink_directories(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "exclude_symlink_directories", value)

    @_builtins.property
    @pulumi.getter
    def excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specify files/directories to ignore when reading the `source_dir`. Supports glob file matching patterns including doublestar/globstar (`**`) patterns.
        """
        return pulumi.get(self, "excludes")

    @excludes.setter
    def excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "excludes", value)

    @_builtins.property
    @pulumi.getter(name="outputBase64sha256")
    def output_base64sha256(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Base64 Encoded SHA256 checksum of output file
        """
        return pulumi.get(self, "output_base64sha256")

    @output_base64sha256.setter
    def output_base64sha256(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "output_base64sha256", value)

    @_builtins.property
    @pulumi.getter(name="outputBase64sha512")
    def output_base64sha512(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Base64 Encoded SHA512 checksum of output file
        """
        return pulumi.get(self, "output_base64sha512")

    @output_base64sha512.setter
    def output_base64sha512(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "output_base64sha512", value)

    @_builtins.property
    @pulumi.getter(name="outputFileMode")
    def output_file_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        String that specifies the octal file mode for all archived files. For example: `"0666"`. Setting this will ensure that cross platform usage of this module will not vary the modes of archived files (and ultimately checksums) resulting in more deterministic behavior.
        """
        return pulumi.get(self, "output_file_mode")

    @output_file_mode.setter
    def output_file_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "output_file_mode", value)

    @_builtins.property
    @pulumi.getter(name="outputMd5")
    def output_md5(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        MD5 of output file
        """
        return pulumi.get(self, "output_md5")

    @output_md5.setter
    def output_md5(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "output_md5", value)

    @_builtins.property
    @pulumi.getter(name="outputPath")
    def output_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The output of the archive file.
        """
        return pulumi.get(self, "output_path")

    @output_path.setter
    def output_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "output_path", value)

    @_builtins.property
    @pulumi.getter(name="outputSha")
    def output_sha(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SHA1 checksum of output file
        """
        return pulumi.get(self, "output_sha")

    @output_sha.setter
    def output_sha(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "output_sha", value)

    @_builtins.property
    @pulumi.getter(name="outputSha256")
    def output_sha256(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SHA256 checksum of output file
        """
        return pulumi.get(self, "output_sha256")

    @output_sha256.setter
    def output_sha256(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "output_sha256", value)

    @_builtins.property
    @pulumi.getter(name="outputSha512")
    def output_sha512(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SHA512 checksum of output file
        """
        return pulumi.get(self, "output_sha512")

    @output_sha512.setter
    def output_sha512(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "output_sha512", value)

    @_builtins.property
    @pulumi.getter(name="outputSize")
    def output_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The byte size of the output archive file.
        """
        return pulumi.get(self, "output_size")

    @output_size.setter
    def output_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "output_size", value)

    @_builtins.property
    @pulumi.getter(name="sourceContent")
    def source_content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Add only this content to the archive with `source_content_filename` as the filename. One and only one of `source`, `source_content_filename` (with `source_content`), `source_file`, or `source_dir` must be specified.
        """
        return pulumi.get(self, "source_content")

    @source_content.setter
    def source_content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_content", value)

    @_builtins.property
    @pulumi.getter(name="sourceContentFilename")
    def source_content_filename(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set this as the filename when using `source_content`. One and only one of `source`, `source_content_filename` (with `source_content`), `source_file`, or `source_dir` must be specified.
        """
        return pulumi.get(self, "source_content_filename")

    @source_content_filename.setter
    def source_content_filename(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_content_filename", value)

    @_builtins.property
    @pulumi.getter(name="sourceDir")
    def source_dir(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Package entire contents of this directory into the archive. One and only one of `source`, `source_content_filename` (with `source_content`), `source_file`, or `source_dir` must be specified.
        """
        return pulumi.get(self, "source_dir")

    @source_dir.setter
    def source_dir(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_dir", value)

    @_builtins.property
    @pulumi.getter(name="sourceFile")
    def source_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Package this file into the archive. One and only one of `source`, `source_content_filename` (with `source_content`), `source_file`, or `source_dir` must be specified.
        """
        return pulumi.get(self, "source_file")

    @source_file.setter
    def source_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_file", value)

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FileSourceArgs']]]]:
        """
        Specifies attributes of a single source file to include into the archive. One and only one of `source`, `source_content_filename` (with `source_content`), `source_file`, or `source_dir` must be specified.
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FileSourceArgs']]]]):
        pulumi.set(self, "sources", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of archive to generate. NOTE: `zip` and `tar.gz` is supported.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("archive:index/file:File")
class File(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 exclude_symlink_directories: Optional[pulumi.Input[_builtins.bool]] = None,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 output_file_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 output_path: Optional[pulumi.Input[_builtins.str]] = None,
                 source_content: Optional[pulumi.Input[_builtins.str]] = None,
                 source_content_filename: Optional[pulumi.Input[_builtins.str]] = None,
                 source_dir: Optional[pulumi.Input[_builtins.str]] = None,
                 source_file: Optional[pulumi.Input[_builtins.str]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FileSourceArgs', 'FileSourceArgsDict']]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Generates an archive from content, a file, or directory of files.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] exclude_symlink_directories: Boolean flag indicating whether symbolically linked directories should be excluded during the creation of the archive. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excludes: Specify files/directories to ignore when reading the `source_dir`. Supports glob file matching patterns including doublestar/globstar (`**`) patterns.
        :param pulumi.Input[_builtins.str] output_file_mode: String that specifies the octal file mode for all archived files. For example: `"0666"`. Setting this will ensure that cross platform usage of this module will not vary the modes of archived files (and ultimately checksums) resulting in more deterministic behavior.
        :param pulumi.Input[_builtins.str] output_path: The output of the archive file.
        :param pulumi.Input[_builtins.str] source_content: Add only this content to the archive with `source_content_filename` as the filename. One and only one of `source`, `source_content_filename` (with `source_content`), `source_file`, or `source_dir` must be specified.
        :param pulumi.Input[_builtins.str] source_content_filename: Set this as the filename when using `source_content`. One and only one of `source`, `source_content_filename` (with `source_content`), `source_file`, or `source_dir` must be specified.
        :param pulumi.Input[_builtins.str] source_dir: Package entire contents of this directory into the archive. One and only one of `source`, `source_content_filename` (with `source_content`), `source_file`, or `source_dir` must be specified.
        :param pulumi.Input[_builtins.str] source_file: Package this file into the archive. One and only one of `source`, `source_content_filename` (with `source_content`), `source_file`, or `source_dir` must be specified.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FileSourceArgs', 'FileSourceArgsDict']]]] sources: Specifies attributes of a single source file to include into the archive. One and only one of `source`, `source_content_filename` (with `source_content`), `source_file`, or `source_dir` must be specified.
        :param pulumi.Input[_builtins.str] type: The type of archive to generate. NOTE: `zip` and `tar.gz` is supported.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Generates an archive from content, a file, or directory of files.

        :param str resource_name: The name of the resource.
        :param FileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 exclude_symlink_directories: Optional[pulumi.Input[_builtins.bool]] = None,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 output_file_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 output_path: Optional[pulumi.Input[_builtins.str]] = None,
                 source_content: Optional[pulumi.Input[_builtins.str]] = None,
                 source_content_filename: Optional[pulumi.Input[_builtins.str]] = None,
                 source_dir: Optional[pulumi.Input[_builtins.str]] = None,
                 source_file: Optional[pulumi.Input[_builtins.str]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FileSourceArgs', 'FileSourceArgsDict']]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FileArgs.__new__(FileArgs)

            __props__.__dict__["exclude_symlink_directories"] = exclude_symlink_directories
            __props__.__dict__["excludes"] = excludes
            __props__.__dict__["output_file_mode"] = output_file_mode
            if output_path is None and not opts.urn:
                raise TypeError("Missing required property 'output_path'")
            __props__.__dict__["output_path"] = output_path
            __props__.__dict__["source_content"] = source_content
            __props__.__dict__["source_content_filename"] = source_content_filename
            __props__.__dict__["source_dir"] = source_dir
            __props__.__dict__["source_file"] = source_file
            __props__.__dict__["sources"] = sources
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["output_base64sha256"] = None
            __props__.__dict__["output_base64sha512"] = None
            __props__.__dict__["output_md5"] = None
            __props__.__dict__["output_sha"] = None
            __props__.__dict__["output_sha256"] = None
            __props__.__dict__["output_sha512"] = None
            __props__.__dict__["output_size"] = None
        super(File, __self__).__init__(
            'archive:index/file:File',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            exclude_symlink_directories: Optional[pulumi.Input[_builtins.bool]] = None,
            excludes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            output_base64sha256: Optional[pulumi.Input[_builtins.str]] = None,
            output_base64sha512: Optional[pulumi.Input[_builtins.str]] = None,
            output_file_mode: Optional[pulumi.Input[_builtins.str]] = None,
            output_md5: Optional[pulumi.Input[_builtins.str]] = None,
            output_path: Optional[pulumi.Input[_builtins.str]] = None,
            output_sha: Optional[pulumi.Input[_builtins.str]] = None,
            output_sha256: Optional[pulumi.Input[_builtins.str]] = None,
            output_sha512: Optional[pulumi.Input[_builtins.str]] = None,
            output_size: Optional[pulumi.Input[_builtins.int]] = None,
            source_content: Optional[pulumi.Input[_builtins.str]] = None,
            source_content_filename: Optional[pulumi.Input[_builtins.str]] = None,
            source_dir: Optional[pulumi.Input[_builtins.str]] = None,
            source_file: Optional[pulumi.Input[_builtins.str]] = None,
            sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FileSourceArgs', 'FileSourceArgsDict']]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'File':
        """
        Get an existing File resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] exclude_symlink_directories: Boolean flag indicating whether symbolically linked directories should be excluded during the creation of the archive. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excludes: Specify files/directories to ignore when reading the `source_dir`. Supports glob file matching patterns including doublestar/globstar (`**`) patterns.
        :param pulumi.Input[_builtins.str] output_base64sha256: Base64 Encoded SHA256 checksum of output file
        :param pulumi.Input[_builtins.str] output_base64sha512: Base64 Encoded SHA512 checksum of output file
        :param pulumi.Input[_builtins.str] output_file_mode: String that specifies the octal file mode for all archived files. For example: `"0666"`. Setting this will ensure that cross platform usage of this module will not vary the modes of archived files (and ultimately checksums) resulting in more deterministic behavior.
        :param pulumi.Input[_builtins.str] output_md5: MD5 of output file
        :param pulumi.Input[_builtins.str] output_path: The output of the archive file.
        :param pulumi.Input[_builtins.str] output_sha: SHA1 checksum of output file
        :param pulumi.Input[_builtins.str] output_sha256: SHA256 checksum of output file
        :param pulumi.Input[_builtins.str] output_sha512: SHA512 checksum of output file
        :param pulumi.Input[_builtins.int] output_size: The byte size of the output archive file.
        :param pulumi.Input[_builtins.str] source_content: Add only this content to the archive with `source_content_filename` as the filename. One and only one of `source`, `source_content_filename` (with `source_content`), `source_file`, or `source_dir` must be specified.
        :param pulumi.Input[_builtins.str] source_content_filename: Set this as the filename when using `source_content`. One and only one of `source`, `source_content_filename` (with `source_content`), `source_file`, or `source_dir` must be specified.
        :param pulumi.Input[_builtins.str] source_dir: Package entire contents of this directory into the archive. One and only one of `source`, `source_content_filename` (with `source_content`), `source_file`, or `source_dir` must be specified.
        :param pulumi.Input[_builtins.str] source_file: Package this file into the archive. One and only one of `source`, `source_content_filename` (with `source_content`), `source_file`, or `source_dir` must be specified.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FileSourceArgs', 'FileSourceArgsDict']]]] sources: Specifies attributes of a single source file to include into the archive. One and only one of `source`, `source_content_filename` (with `source_content`), `source_file`, or `source_dir` must be specified.
        :param pulumi.Input[_builtins.str] type: The type of archive to generate. NOTE: `zip` and `tar.gz` is supported.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FileState.__new__(_FileState)

        __props__.__dict__["exclude_symlink_directories"] = exclude_symlink_directories
        __props__.__dict__["excludes"] = excludes
        __props__.__dict__["output_base64sha256"] = output_base64sha256
        __props__.__dict__["output_base64sha512"] = output_base64sha512
        __props__.__dict__["output_file_mode"] = output_file_mode
        __props__.__dict__["output_md5"] = output_md5
        __props__.__dict__["output_path"] = output_path
        __props__.__dict__["output_sha"] = output_sha
        __props__.__dict__["output_sha256"] = output_sha256
        __props__.__dict__["output_sha512"] = output_sha512
        __props__.__dict__["output_size"] = output_size
        __props__.__dict__["source_content"] = source_content
        __props__.__dict__["source_content_filename"] = source_content_filename
        __props__.__dict__["source_dir"] = source_dir
        __props__.__dict__["source_file"] = source_file
        __props__.__dict__["sources"] = sources
        __props__.__dict__["type"] = type
        return File(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="excludeSymlinkDirectories")
    def exclude_symlink_directories(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean flag indicating whether symbolically linked directories should be excluded during the creation of the archive. Defaults to `false`.
        """
        return pulumi.get(self, "exclude_symlink_directories")

    @_builtins.property
    @pulumi.getter
    def excludes(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specify files/directories to ignore when reading the `source_dir`. Supports glob file matching patterns including doublestar/globstar (`**`) patterns.
        """
        return pulumi.get(self, "excludes")

    @_builtins.property
    @pulumi.getter(name="outputBase64sha256")
    def output_base64sha256(self) -> pulumi.Output[_builtins.str]:
        """
        Base64 Encoded SHA256 checksum of output file
        """
        return pulumi.get(self, "output_base64sha256")

    @_builtins.property
    @pulumi.getter(name="outputBase64sha512")
    def output_base64sha512(self) -> pulumi.Output[_builtins.str]:
        """
        Base64 Encoded SHA512 checksum of output file
        """
        return pulumi.get(self, "output_base64sha512")

    @_builtins.property
    @pulumi.getter(name="outputFileMode")
    def output_file_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        String that specifies the octal file mode for all archived files. For example: `"0666"`. Setting this will ensure that cross platform usage of this module will not vary the modes of archived files (and ultimately checksums) resulting in more deterministic behavior.
        """
        return pulumi.get(self, "output_file_mode")

    @_builtins.property
    @pulumi.getter(name="outputMd5")
    def output_md5(self) -> pulumi.Output[_builtins.str]:
        """
        MD5 of output file
        """
        return pulumi.get(self, "output_md5")

    @_builtins.property
    @pulumi.getter(name="outputPath")
    def output_path(self) -> pulumi.Output[_builtins.str]:
        """
        The output of the archive file.
        """
        return pulumi.get(self, "output_path")

    @_builtins.property
    @pulumi.getter(name="outputSha")
    def output_sha(self) -> pulumi.Output[_builtins.str]:
        """
        SHA1 checksum of output file
        """
        return pulumi.get(self, "output_sha")

    @_builtins.property
    @pulumi.getter(name="outputSha256")
    def output_sha256(self) -> pulumi.Output[_builtins.str]:
        """
        SHA256 checksum of output file
        """
        return pulumi.get(self, "output_sha256")

    @_builtins.property
    @pulumi.getter(name="outputSha512")
    def output_sha512(self) -> pulumi.Output[_builtins.str]:
        """
        SHA512 checksum of output file
        """
        return pulumi.get(self, "output_sha512")

    @_builtins.property
    @pulumi.getter(name="outputSize")
    def output_size(self) -> pulumi.Output[_builtins.int]:
        """
        The byte size of the output archive file.
        """
        return pulumi.get(self, "output_size")

    @_builtins.property
    @pulumi.getter(name="sourceContent")
    def source_content(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Add only this content to the archive with `source_content_filename` as the filename. One and only one of `source`, `source_content_filename` (with `source_content`), `source_file`, or `source_dir` must be specified.
        """
        return pulumi.get(self, "source_content")

    @_builtins.property
    @pulumi.getter(name="sourceContentFilename")
    def source_content_filename(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Set this as the filename when using `source_content`. One and only one of `source`, `source_content_filename` (with `source_content`), `source_file`, or `source_dir` must be specified.
        """
        return pulumi.get(self, "source_content_filename")

    @_builtins.property
    @pulumi.getter(name="sourceDir")
    def source_dir(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Package entire contents of this directory into the archive. One and only one of `source`, `source_content_filename` (with `source_content`), `source_file`, or `source_dir` must be specified.
        """
        return pulumi.get(self, "source_dir")

    @_builtins.property
    @pulumi.getter(name="sourceFile")
    def source_file(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Package this file into the archive. One and only one of `source`, `source_content_filename` (with `source_content`), `source_file`, or `source_dir` must be specified.
        """
        return pulumi.get(self, "source_file")

    @_builtins.property
    @pulumi.getter
    def sources(self) -> pulumi.Output[Optional[Sequence['outputs.FileSource']]]:
        """
        Specifies attributes of a single source file to include into the archive. One and only one of `source`, `source_content_filename` (with `source_content`), `source_file`, or `source_dir` must be specified.
        """
        return pulumi.get(self, "sources")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of archive to generate. NOTE: `zip` and `tar.gz` is supported.
        """
        return pulumi.get(self, "type")

