"""
Exploit Logger for LogicPwn Exploit Engine.
- Leverages core logging system
- Supports step and chain-level logging, request/response capture
- Extensible and interoperable
"""
import logging
from typing import Any, Dict, List

class ExploitLogger:
    def __init__(self, logger_name: str = "logicpwn.exploit_engine"):
        self.logger = logging.getLogger(logger_name)

    def log_step(self, step_name: str, status: str, info: Dict[str, Any]):
        self.logger.info(f"[Step] {step_name} | Status: {status} | Info: {info}")

    def log_chain(self, chain_name: str, results: List[Dict[str, Any]]):
        self.logger.info(f"[Chain] {chain_name} | Results: {results}")

    def log_request_response(self, step_name: str, request: Any, response: Any):
        self.logger.debug(f"[Request] {step_name} | Request: {request}")
        self.logger.debug(f"[Response] {step_name} | Response: {response}")

    def log_error(self, step_name: str, error: str):
        self.logger.error(f"[Error] {step_name} | {error}")

    def log_info(self, message: str, data: Any = None):
        """Log informational message with optional data."""
        if data:
            self.logger.info(f"{message} | Data: {data}")
        else:
            self.logger.info(message)