"""High level plotting API within puma, to avoid code duplication."""

from __future__ import annotations

from puma.hlplots.aux_results import AuxResults
from puma.hlplots.n_track_origin import n_tracks_per_origin
from puma.hlplots.results import Results, separate_kwargs
from puma.hlplots.tagger import Tagger
from puma.hlplots.yuma import YumaConfig
from puma.hlplots.yutils import combine_suffixes, get_included_taggers

__all__ = [
    "AuxResults",
    "Results",
    "Tagger",
    "YumaConfig",
    "combine_suffixes",
    "get_included_taggers",
    "n_tracks_per_origin",
    "separate_kwargs",
]
