This file is a merged representation of a subset of the codebase, containing specifically included files, combined into a single document by Repomix.
The content has been processed where security check has been disabled.

# File Summary

## Purpose
This file contains a packed representation of the entire repository's contents.
It is designed to be easily consumable by AI systems for analysis, code review,
or other automated processes.

## File Format
The content is organized as follows:
1. This summary section
2. Repository information
3. Directory structure
4. Repository files (if enabled)
5. Multiple file entries, each consisting of:
  a. A header with the file path (## File: path/to/file)
  b. The full contents of the file in a code block

## Usage Guidelines
- This file should be treated as read-only. Any changes should be made to the
  original repository files, not this packed version.
- When processing this file, use the file path to distinguish
  between different files in the repository.
- Be aware that this file may contain sensitive information. Handle it with
  the same level of security as you would the original repository.

## Notes
- Some files may have been excluded based on .gitignore rules and Repomix's configuration
- Binary files are not included in this packed representation. Please refer to the Repository Structure section for a complete list of file paths, including binary files
- Only files matching these patterns are included: docs/**/*.qmd
- Files matching patterns in .gitignore are excluded
- Files matching default ignore patterns are excluded
- Security check has been disabled - content may contain sensitive information
- Files are sorted by Git change count (files with more changes are at the bottom)

# Directory Structure
```
docs/
  advanced/
    inspect/
      index.qmd
    jupyter/
      kernel-execution.qmd
    typst/
      brand-yaml.qmd
      typst-css.qmd
    environment-vars.qmd
    index.qmd
  authoring/
    _embed-examples/
      sample-notebook-view.qmd
      sample.qmd
    _figure-examples/
      _examples.qmd
    _mermaid-examples/
      customize.qmd
      dark.qmd
      darkly.qmd
      default.qmd
      forest.qmd
      neutral.qmd
      sandstone.qmd
      solar.qmd
      vapor.qmd
    code-annotation-example/
      revealjs.qmd
    _brand-example.qmd
    _cross-reference-divs-diagram.qmd
    _cross-reference-divs-figure.qmd
    _cross-reference-divs-listing.qmd
    _cross-reference-divs-table.qmd
    _cross-reference-divs-video.qmd
    _cross-references-callouts.qmd
    _cross-references-listings.qmd
    _embeds-ipynb.qmd
    _kbd.qmd
    _mermaid-theming.qmd
    _pagebreak.qmd
    _shortcodes.qmd
    appendices.qmd
    article-layout.qmd
    brand.qmd
    callouts.qmd
    citations.qmd
    code-annotation.qmd
    conditional.qmd
    contents.qmd
    create-citeable-articles.qmd
    cross-reference-options.qmd
    cross-references-custom.qmd
    cross-references-divs.qmd
    cross-references.qmd
    diagrams.qmd
    figures.qmd
    front-matter.qmd
    includes.qmd
    language.qmd
    lipsum.qmd
    markdown-basics.qmd
    notebook-embed.qmd
    penguins-qmd.qmd
    placeholder.qmd
    shortcodes.qmd
    tables.qmd
    title-blocks.qmd
    variables.qmd
    version.qmd
    videos.qmd
  blog/
    posts/
      2022-02-13-feature-callouts/
        index.qmd
      2022-02-15-feature-tables/
        index.qmd
      2022-02-17-advanced-layout/
        index.qmd
      2022-06-21-rstudio-conf-2022-quarto/
        index.qmd
      2022-07-25-feature-extensions/
        index.qmd
      2022-10-25-shinylive-extension/
        index.qmd
      2023-03-13-code-annotation/
        index.qmd
      2023-03-15-multi-format/
        index.qmd
      2023-03-17-jupyter-cell-embedding/
        index.qmd
      2023-03-20-confluence/
        index.qmd
      2023-04-26-1.3-release/
        index.qmd
      2023-05-15-get-started/
        index.qmd
      2023-05-22-quarto-for-academics/
        index.qmd
      2023-12-05-asa-traveling-courses/
        index.qmd
      2023-12-07-quarto-dashboards-demo/
        index.qmd
      2024-01-24-1.4-release/
        index.qmd
      2024-03-26-hugging-face/
        index.qmd
      2024-04-01-manuscripts-rmedicine/
        index.qmd
      2024-05-28-conf-workshops/
        index.qmd
      2024-07-02-beautiful-tables-in-typst/
        examples/
          great-tables-oceania.qmd
          great-tables-solar-zenith.qmd
          gt-cars.qmd
          gt-islands.qmd
          pandas-acting-on-data.qmd
          pandas-confusion-matrix.qmd
        index.qmd
      2024-07-11-1.5-release/
        index.qmd
      2024-10-15-conf-workshops-materials/
        index.qmd
      2024-11-06-conf-talks/
        index.qmd
      2024-11-22-dashboards-workshop/
        index.qmd
      2024-11-25-1.6-release/
        index.qmd
      2024-12-04-websites-workshop/
        index.qmd
      2024-12-12-includes-meta/
        index.qmd
      2025-01-15-quarto-tip-brand-positron/
        index.qmd
      2025-04-28-1.7-release/
        index.qmd
      2025-05-19-quarto-codespaces/
        index.qmd
      2025-xx-xx-1.7-release/
        index.qmd
      _quarto-1.3-feature.qmd
    index.qmd
  books/
    _book-vs-website-key.qmd
    book-basics.qmd
    book-crossrefs.qmd
    book-output.qmd
    book-structure.qmd
  computations/
    caching.qmd
    execution-options.qmd
    inline-code.qmd
    julia.qmd
    ojs.qmd
    parameters.qmd
    python.qmd
    r.qmd
    render-scripts.qmd
  dashboards/
    _examples/
      inputs/
        card-toolbar.qmd
        column-layout.qmd
        inline-sidebar.qmd
        inline-toolbar.qmd
        input-panel.qmd
        page-sidebar.qmd
        right-sidebar.qmd
        toolbar.qmd
      julia/
        julia-plotly.qmd
      python/
        python-itables.qmd
        python-tabulate.qmd
      r/
        dt.qmd
      _TODO.qmd
      altair.qmd
      cell-layout.qmd
      flow.qmd
      gapminder-content.qmd
      gapminder.qmd
      leaflet.qmd
      markdown.qmd
      navigation.qmd
      penguins-obervable.qmd
      python-wide.qmd
      shiny-diamonds.qmd
      shiny-global-sidebar.qmd
      shiny-python-simple.qmd
      shiny-sidebar.qmd
      valuebox.qmd
    interactivity/
      shiny-python/
        _shiny-requirements.qmd
        execution.qmd
        index.qmd
        running.qmd
      index.qmd
      observable.qmd
      shiny-r.qmd
    _inputs.qmd
    _layouts-old.qmd
    data-display.qmd
    deployment.qmd
    index.qmd
    inputs.qmd
    layout.qmd
    parameters.qmd
    theming.qmd
  download/
    changelog/
      1.1/
        index.qmd
      1.2/
        index.qmd
      1.3/
        index.qmd
      1.4/
        index.qmd
      1.5/
        index.qmd
      1.6/
        index.qmd
    index.qmd
    prerelease.qmd
    release.qmd
    tarball.qmd
  extensions/
    _extension-trust.qmd
    _formats-common.qmd
    _listing-chooser.qmd
    _listing-footer.qmd
    _listing-preamble.qmd
    _shortcode-escaping.qmd
    creating.qmd
    distributing.qmd
    filters.qmd
    formats.qmd
    index.qmd
    listing-filters.qmd
    listing-formats.qmd
    listing-journals.qmd
    listing-revealjs.qmd
    lua-api.qmd
    lua.qmd
    managing.qmd
    metadata.qmd
    nbfilter.qmd
    project-types.qmd
    revealjs.qmd
    shortcodes.qmd
    starter-templates.qmd
  faq/
    index.qmd
    rmarkdown.qmd
  gallery/
    index.qmd
  get-started/
    authoring/
      _authoring-complete.qmd
      _authoring.qmd
      index.qmd
      jupyter.qmd
      neovim.qmd
      rstudio.qmd
      text-editor.qmd
      vscode.qmd
    computations/
      _computations-complete.qmd
      _computations-text-editor.qmd
      _computations.qmd
      index.qmd
      jupyter.qmd
      neovim.qmd
      rstudio.qmd
      text-editor.qmd
      vscode.qmd
    hello/
      rstudio/
        _hello.qmd
      _hello.qmd
      index.qmd
      jupyter.qmd
      neovim.qmd
      rstudio.qmd
      text-editor.qmd
      vscode.qmd
    index.qmd
  guide/
    index.qmd
  interactive/
    ojs/
      examples/
        _shiny/
          binning/
            binning-shiny-ojs.qmd
          data/
            data-shiny-ojs.qmd
          kmeans/
            kmeans-shiny-ojs.qmd
        arquero.qmd
        github.qmd
        layout.qmd
        noaa-co2.qmd
        penguins.qmd
        population.qmd
        sunburst.qmd
      _reactivity.qmd
      code-reuse.qmd
      data-sources.qmd
      index.qmd
      libraries.qmd
      ojs-cells.qmd
      shiny.qmd
    shiny/
      _examples/
        covid19-bicartogram/
          covid19-bicartogram.qmd
        diamonds/
          shiny-diamonds.qmd
        k-means/
          shiny-k-means.qmd
        old-faithful/
          shiny-old-faithful.qmd
      execution.qmd
      index.qmd
      resources.qmd
      running.qmd
    widgets/
      htmlwidgets.qmd
      jupyter.qmd
    index.qmd
    layout.qmd
  journals/
    _draft/
      create-extensions.qmd
      extension-templates.qmd
    authors.qmd
    formats.qmd
    index.qmd
    templates.qmd
  manuscripts/
    authoring/
      _authoring-content.qmd
      _citations.qmd
      _cross-refs.qmd
      _embeds-ipynb.qmd
      _embeds-qmd.qmd
      _equations.qmd
      _figures.qmd
      _files.qmd
      _footer.qmd
      _front-matter.qmd
      _inline-computations.qmd
      _markdown.qmd
      _overview.qmd
      _setup.qmd
      _structure.qmd
      _tables.qmd
      _visual-editor.qmd
      _workflow-ipynb.qmd
      _workflow-qmd.qmd
      _workflow.qmd
      index.qmd
      jupyterlab.qmd
      rstudio.qmd
      vscode.qmd
    components.qmd
    index.qmd
    next-steps.qmd
    publishing.qmd
  output-formats/
    examples/
      gt-temps.qmd
      pandas-temps.qmd
    _ssg-intro.qmd
    _ssg-workflow.qmd
    all-formats.qmd
    docusaurus.qmd
    gfm.qmd
    html-basics.qmd
    html-code.qmd
    html-lightbox-figures.qmd
    html-multi-format.qmd
    html-publishing.qmd
    html-themes-more.qmd
    html-themes.qmd
    hugo.qmd
    ms-word-templates.qmd
    ms-word.qmd
    page-layout.qmd
    pdf-basics.qmd
    pdf-engine.qmd
    typst-custom.qmd
    typst.qmd
  prerelease/
    1.3/
      custom-ast-nodes/
        callout.qmd
        conditional-block.qmd
        tabset.qmd
      _highlights.qmd
      _pre-release-feature.qmd
      ast.qmd
      index.qmd
      tables.qmd
      website-nav.qmd
    1.4/
      _highlights.qmd
      _pre-release-feature.qmd
      ast.qmd
      crossref.qmd
      email.qmd
      index.qmd
      lua_changes.qmd
    1.5/
      _highlights.qmd
      index.qmd
    1.6/
      _highlights.qmd
      _pre-release-feature.qmd
      index.qmd
    1.7/
      _highlights.qmd
      _pre-release-feature.qmd
      index.qmd
    1.8/
      _highlights.qmd
      index.qmd
    _highlights-prerelease.qmd
    _highlights-release.qmd
  presentations/
    revealjs/
      demo/
        mini/
          absolute.qmd
          auto-animate-code.qmd
          auto-animate-movement.qmd
          auto-animate-stack.qmd
          auto-animate.qmd
          fragments-custom.qmd
          fragments-nested.qmd
          fragments.qmd
          stack.qmd
          zoom.qmd
        index.qmd
      examples/
        _theme-dark.qmd
        background-color.qmd
        background-gradient.qmd
        background-no-title.qmd
        code-echo.qmd
        columns.qmd
        creating-slides-1.qmd
        creating-slides-2.qmd
        creating-slides-3.qmd
        executable-code-figure-size.qmd
        footer-and-logo.qmd
        image-background.qmd
        incremental-lists-1.qmd
        incremental-lists-2.qmd
        incremental-lists-3.qmd
        incremental-pause.qmd
        index.qmd
        line-highlighting-1.qmd
        line-highlighting-2.qmd
        line-highlighting-3.qmd
        line-highlighting-4.qmd
        no-footer-on-a-slide.qmd
        per-slide-footer.qmd
        scrollable-and-smaller.qmd
        scrollable.qmd
        slide-with-speaker-notes.qmd
        smaller.qmd
        tabset.qmd
      _callout-auto-stretch-scrollable.qmd
      advanced.qmd
      index.qmd
      presenting.qmd
      themes.qmd
    beamer.qmd
    index.qmd
    powerpoint.qmd
  projects/
    binder.qmd
    code-execution.qmd
    environment.qmd
    profiles.qmd
    quarto-projects.qmd
    scripts.qmd
    virtual-environments.qmd
  publishing/
    _confluence_examples/
      confluence-demo.qmd
    ci.qmd
    confluence.qmd
    github-pages.qmd
    hugging-face.qmd
    index.qmd
    netlify.qmd
    other.qmd
    posit-cloud.qmd
    quarto-pub.qmd
    rstudio-connect.qmd
  reference/
    cells/
      cells-jupyter.qmd
      cells-knitr.qmd
      cells-ojs.qmd
      index.qmd
    formats/
      markdown/
        commonmark.qmd
        gfm.qmd
        markua.qmd
      presentations/
        beamer.qmd
        pptx.qmd
        revealjs.qmd
      wiki/
        dokuwiki.qmd
        jira.qmd
        mediawiki.qmd
        xwiki.qmd
        zimwiki.qmd
      asciidoc.qmd
      context.qmd
      dashboard.qmd
      docbook.qmd
      docx.qmd
      epub.qmd
      fb2.qmd
      haddock.qmd
      html.qmd
      icml.qmd
      ipynb.qmd
      jats.qmd
      man.qmd
      ms.qmd
      muse.qmd
      odt.qmd
      opml.qmd
      org.qmd
      rst.qmd
      rtf.qmd
      tei.qmd
      texinfo.qmd
      textile.qmd
      typst.qmd
    metadata/
      brand.qmd
      citation.qmd
      crossref.qmd
    projects/
      books.qmd
      manuscripts.qmd
      options.qmd
      websites.qmd
    dates.qmd
    globs.qmd
    index.qmd
  tools/
    _examples/
      diagrams.qmd
      python.qmd
    positron/
      index.qmd
      notebook.qmd
      visual-editor.qmd
    vscode/
      index.qmd
      notebook.qmd
      visual-editor.qmd
    _jupyter-lab-extension-install.qmd
    jupyter-lab-extension.qmd
    jupyter-lab.qmd
    neovim.qmd
    rstudio.qmd
    text-editors.qmd
  triaging/
    index.qmd
  troubleshooting/
    index.qmd
  visual-editor/
    content.qmd
    index.qmd
    markdown.qmd
    options.qmd
    technical.qmd
  websites/
    website-about.qmd
    website-basics.qmd
    website-blog.qmd
    website-drafts.qmd
    website-listings-custom.qmd
    website-listings.qmd
    website-navigation.qmd
    website-search.qmd
    website-tools.qmd
```

# Files

## File: docs/advanced/inspect/index.qmd
```````
---
title: Quarto Inspect
summary: Project and document information in a machine-readable format
format: html
---

## Overview

The `quarto inspect` command produces a JSON object with information about the configuration of a Quarto project or document.
This information is particularly useful for authors of downstream tools and libraries which analyze Quarto content.

Whenever possible, we recommend using `quarto inspect` instead of direct inspection of documents or projects.

## Information available

`quarto inspect` provides information for Quarto projects, for individual documents outside of projects, and for documents within a project.

### Document-level information

Document-level information is obtained by calling `quarto inspect <DOCUMENT>`.
If no additional parameters are given, the output is produced on standard output.
If an additional parameter is given, the output is written to the specified path.

- `quarto`: an object describing the quarto version
- `engines`: the engine used in the document, as a singleton array (for simplicity of the schema, in compatibility with the project-wide information below)
- `formats`: an object whose keys are the document format name, and values are metadata associated with the document.
- `resources`: an array of paths describing additional resources required for the document to be rendered.
- `fileInformation`: an object whose keys are file names, and values are objects describing:
  - `includeMap`: an array of `source` and `target` paths describing the use of `include` shortcodes
  - `codeCells`: an array of objects describing the code cells in the document (including those referenced to from an include). The object has:
    - `start`: the line where the code cell starts
    - `end`: the line where the code cell ends
    - `file`: the path of the file where the code cell resides (this can be different from the original file because of includes)
    - `source`: the content of the code cell
    - `language`: the language of the code cell
    - `metadata`: the cell-level metadata for the code cell
- `project`: If the document is part of a project, then this contains the output that would be produced by `quarto inspect` on the project

### Project-level information

Project-level information is obtained by calling `quarto inspect` within a project, or explicitly passing a path, `quarto inspect <PATH_TO_PROJECT>`.
If no additional parameters are given, the output is produced on standard output.
If an additional parameter is given, the output is written to the specified path.

- `quarto`: an object describing the quarto version
- `dir`: the path to the directory where the project resides
- `engines`: an array of strings listing the engines used in the project.
- `config`: the project configuration metadata in JSON format
- `files`: information about the project files in an object. The object has:
  - `input`: an array of paths listing the input files
  - `resources`: an array of paths describing additional resources required for the project to be rendered.
  - `config`: the YAML configuration files that make up this project's configuration
  - `configResources`: an array of paths describing resources that are implied by the project configuration.
- `fileInformation`: an object containing information about each of the documents to be rendered by the project. 
  The keys of this object are the document paths, and the values are themselves objects with the following keys:
  - `includeMap`: an array of `source` and `target` paths describing the use of `include` shortcodes
  - `codeCells`: an array of objects describing the code cells in the document (including those referenced to from an include). The object has:
    - `start`: the line where the code cell starts
    - `end`: the line where the code cell ends
    - `file`: the path of the file where the code cell resides (this can be different from the original file because of includes)
    - `source`: the content of the code cell
    - `language`: the language of the code cell
    - `metadata`: the cell-level metadata for the code cell

## JSON Schemas

### Project data

This schema is also available as a [standalone file](./quarto-inspect-project-json-schema.json).

```json
{{< include quarto-inspect-project-json-schema.json >}}
```

### Document data

This schema is also available as a [standalone file](./quarto-inspect-document-json-schema.json).

```json
{{< include quarto-inspect-document-json-schema.json >}}
```
```````

## File: docs/advanced/jupyter/kernel-execution.qmd
```````
---
title: Jupyter Kernel Execution
format: html
summary: How to support Quarto from a Jupyter kernel
---

Quarto executes Jupyter notebooks using [`nbclient`](https://github.com/jupyter/nbclient) together with a few additional options
to support some of Quarto's features. Quarto has built-in support for these features in the `python` and `julia` Jupyter kernels.

In addition, starting in Quarto 1.5, any Jupyter kernel can configure itself to support the features described below.

## Setup and cleanup cells

In order for Quarto notebooks and documents to communicate global options
with a Jupyter Kernel, Quarto uses special _setup_ and _cleanup_ cells.

In `python` and `julia` kernels, the setup and cleanup cells are defined by the following files:

- Julia:
  - [setup](https://github.com/quarto-dev/quarto-cli/blob/main/src/resources/jupyter/lang/julia/setup.jl)
  - [cleanup](https://github.com/quarto-dev/quarto-cli/blob/main/src/resources/jupyter/lang/julia/cleanup.jl)
- Python:
  - [setup](https://github.com/quarto-dev/quarto-cli/blob/main/src/resources/jupyter/lang/python/setup.py)
  - [cleanup](https://github.com/quarto-dev/quarto-cli/blob/main/src/resources/jupyter/lang/python/cleanup.py)

### Adding support to a Jupyter kernel

{{< include /docs/prerelease/1.5/_pre-release-feature.qmd >}}

If a Jupyter kernel wants to execute in awareness of Quarto's context, it should signal its support by adding the following files to the kernelspec directory:

- `quarto_setup_cell`: the source code for a setup cell to be executed by nbclient at the beginning of execution of any Quarto notebook or document. Quarto will create a Jupyter notebook cell with the contents of this file as the `source` field.
- `quarto_cleanup_cell`: analogously to above, the source code for a cleanup cell.

::: callout-tip

In order to make the implementation of these features easier for writers of custom kernels, we have made available a fork of Jupyter's `echo_kernel`. 
This example kernel is meant to showcase the basics of a custom kernel implementation, and our fork adds the setup cell functionality.
See the [source for more](https://github.com/quarto-dev/quarto_echo_kernel).

:::

## Quarto document options

{{< include /docs/prerelease/1.5/_pre-release-feature.qmd >}}

Jupyter kernels can have access to a number of Quarto options that can affect cell execution.

Currently, the supported options are:

- `format`: the format that will be used to produce the document
- `params`: the parameters that will be used in a [parameterized execution](/docs/computations/parameters.qmd#jupyter)
- `allow_errors`: if `true`, then the kernel is asked to not stop execution if a cell produces an error
- `fig_width`: the requested figure width in inches
- `fig_height`: the requested figure height in inches
- `fig_format`: the requested format for figure output (`png`, `jpg`, etc)
- `fig_dpi`: the requested resolution for images in dots per inch
- `cache`: if `true`, then Jupyter cache will be used

Quarto uses [Jupyter Comms](https://jupyter-client.readthedocs.io/en/latest/messaging.html#custom-messages) to provide its options to a kernel during execution. Specifically, Quarto will
open a comm with target name `quarto_kernel_setup`, and its initialization message content will contain these options under the `options` key.

::: callout-tip

In order to make the implementation of these features easier for writers of custom kernels, we have made available a fork of Jupyter's `echo_kernel`. 
This example kernel is meant to showcase the basics of a custom kernel implementation, and our fork adds the setup cell functionality.
See the [source for more](https://github.com/quarto-dev/quarto_echo_kernel).

:::

## Daemonization

Quarto offers built-in support for `julia` and `python` kernels by default, see the docs for more ([Julia](/docs/computations/julia.qmd#kernel-daemon), [Python](/docs/computations/python.qmd#kernel-daemon)).

### Adding support to a Jupyter kernel

{{< include /docs/prerelease/1.5/_pre-release-feature.qmd >}}

Arbitrary Jupyter kernels can indicate support for daemons. To do so, provide a `quarto_setup_cell` file in the kernelspec directory so that setup cells can be executed, and ensure that the execution of the setup cell returns an output result with metadata indicating support for running as a daemon. The supported metadata options are:

- `daemonize`: if a kernel returns `true` when executing Quarto's setup cell, then Quarto will maintain a persistent kernel. The daemon options are the same as in the [documentation above](/docs/computations/python.qmd#kernel-daemon).
- `restart_kernel`: if a kernel returns `true`, then Quarto will forcibly restart the kernel. This allows kernels to detect that their configuration has been changed such that it cannot support continued execution in the same process.

::: callout-tip

In order to make the implementation of these features easier for writers of custom kernels, we have made available a fork of Jupyter's `echo_kernel`. 
This example kernel is meant to showcase the basics of a custom kernel implementation, and our fork adds the setup cell functionality.
See the [source for more](https://github.com/quarto-dev/quarto_echo_kernel).

:::
```````

## File: docs/advanced/typst/brand-yaml.qmd
```````
---
title: Typst Brand YAML
summary: Technical details on support for Brand YAML in Typst and Quarto
---

## Overview

Brand YAML allows consistent colors, fonts, and typography across formats and applications.

This document describes some details of the Typst implementation of Brand YAML for Quarto, and provides troubleshooting tips.

In general, Brand YAML properties use CSS conventions, so this feature relies on [Typst CSS](typst-css.qmd) functionality.

## Color

Brand YAML palette and theme colors are available in Typst `brand-color`, e.g. `brand-color.lime` or `brand-color.primary`.

Lighter versions of the colors, suitable as background colors, are available in `brand-background-color`, e.g. `brand-background-color.success`.

## Typography

Brand YAML is specified for the following elements and Brand YAML properties. Combinations that are not supported are marked NA.


|                  | base | headings | title[^1] | subtitle | monospace-inline | monospace-block | link  |
|------------------|------|----------|-----------|----------|------------------|-----------------|-------|
| family           |   ✓  |    ✓     |     ✓     |    ✓     |        ✓         |        ✓        |   NA  |
| size             |   ✓  |    NA    |     NA    |    NA    |        ✓         |        ✓        |   NA  |
| weight           |   ✓  |    ✓     |     ✓     |    ✓     |        ✓         |        ✓        |   ✓   |
| style            |  NA  |    ✓     |     ✓     |    ✓     |        NA        |        NA       |   NA  |
| color            |   ✓  |    ✓     |     ✓     |    ✓     |        ✓         |        ✓        |   ✓   |
| background-color |  NA  |    NA    |     NA    |    NA    |        ✓         |        ✓        |   ✓   |
| decoration       |  NA  |    NA    |     NA    |    NA    |        NA        |        NA       |   ✓   |
| line-height      |   ✓  |    ✓     |     ✓     |    ✓     |        NA        |        ✓        |   NA  |

[^1]: While being styled as headings, title and subtitle have a separate implementation.

The Quarto Typst and HTML implementations of Brand YAML implement all combinations (except size in revealjs).

Many of the NA combinations are possible in Typst, but were removed for compatibility with the spec in [1bd7a48](https://github.com/quarto-dev/quarto-cli/commit/1bd7a48a41fe683abf6437b55b3d4f4370ef347b). If any of those are desired, they can be implemented via a Typst raw block or `include-in-header`; consult that commit for details.

### Missing fonts in Typst

When Typst is unable to find the requested font, it will fall back to a default font. In Typst 0.13, shipped with Quarto 1.7, the default is Libertinus Serif.

Typst will warn `unknown font family` in this case.

To tell Typst to not fall back (and not to display fonts it can't find), you can add

```typst
#set text(fallback: false)
```

to your document.

Typst Brand YAML will automatically download fonts from Google Fonts and cache them in `.quarto/typst-font-cache`

Then it tells Typst to use this font directory, in addition to any system fonts available to Typst.

In rare cases, there may be ambiguities about a font's name that will cause Typst not to find the font. To see if a font is available to Typst, run

```
quarto typst fonts --ignore-system-fonts --font-path .quarto/typst-font-cache/
```

to list only the fonts downloaded by Quarto. (Adding ``--variants`` can be helpful for more detail.)

If the font is listed but it still isn't working, check for variation in the font name. For example, the Sono font can be downloaded from Google Fonts as Sono, but Typst will only accept Sono Extralight Monospace.

### "Big number" bug

![](big-number-bug.png)

If you encounter issue [#11683](https://github.com/quarto-dev/quarto-cli/issues/11683), with numbers displaying larger than surrounding text in table output, this is happening because none of the text fonts requested by your table package are available, but some of the emoji fonts are.

Please specify an available font to your table package. In the future, Quarto may implement "font stacks" like `system-ui` and `sans-serif` in Typst CSS to fix this bug, but currently these are passed through verbatim, and Typst won't recognize font stacks.

### Typography Test coverage

Which kitchen sink test files contain unique tests for a feature/element combination?

For non-unique tests, first file index is listed.

|                  | base | headings |   title   | subtitle | monospace-inline | monospace-block | link  |
|------------------|------|----------|-----------|----------|------------------|-----------------|-------|
| family           |   1  |    1     |     1     |    1     |        1         |        1        |   R   |
| size             |   1  |    NA    |     NA    |    NA    |        1         |        1        |   R   |
| weight           |   1  |    1     |     1     |    1     |        1         |        2        |   2   |
| style            |   R  |    1     |     1     |    1     |        R         |        R        |   R   |
| color            |   1  |    1     |     1     |    1     |        1         |        1        |   1   |
| background-color |   R  |    R     |     R     |    R     |        1         |        1        |   1   |
| decoration       |   R  |    R     |     R     |    R     |        R         |        R        |   1   |
| line-height      |   1  |    1     |     1     |    1     |        NA        |        1        |   NA  |
```````

## File: docs/advanced/typst/typst-css.qmd
```````
---
title: Typst CSS
summary: Quarto's translation of CSS properties to Typst properties
---

## Overview

The Typst CSS feature translates CSS properties into Typst properties, to allow similar styling between the HTML formats and the Typst format.

It is tuned for two use-cases:

- HTML Tables styled by table packages
- HTML `<pre>` tags representing console output with spans decorated with colors, e.g. from ANSI.

This document is designed for: 

* package developers who want to produce `table` or `pre` output which can be translated to Typst
* extension developers who want to improve the translation of CSS properties, or add other CSS properties

It describes how Typst CSS works, how to enable and disable this feature and the related `pre` tag processing, troubleshooting, and adding or changing the translation filters. 

## How Typst CSS works

Unless [table processing is disabled](/docs/authoring/tables.qmd#disabling-quarto-table-processing), tables in HTML raw blocks will be parsed into the Pandoc AST and then written by the output format. 

When the output format is Typst, Quarto will [`juice`](https://github.com/Automattic/juice) the HTML input, annotating the HTML elements with CSS properties from the rules in any style sheets included in the HTML raw block.
A Quarto post-processing filter translates the HTML attributes and CSS properties into attributes of the form `typst:property` or `typst:text:property`, and the Typst writer in Pandoc writes the output appropriately.

You can opt-in to have `pre` tags processed in the same way: see [`pre` tag processing](#pre-tags).

## Supported Elements and Properties

Typst CSS works for the specific combinations of HTML elements and CSS properties below:

|                  | span | div | table | td  |
|------------------|------|-----|-------|-----|
| background-color |   ✓  |  ✓  |       |  ✓  |
| border[^1]       |      |     |       |  ✓  |
| color            |   ✓  |  ✓  |       |  ✓  |
| font-family      |      |  ✓  |   ✓   |     |
| font-size        |      |  ✓  |   ✓   |     |
| opacity          |   ✓  |     |       |  ✓  |
| align[^2]        |      |     |       |  ✓  |


[^1]: `border`, `border-left` etc, `border-width`, `border-style`, `border-color`, `border-left-width` etc

[^2]: `text-align`, `vertical-align`


## Disabling Typst CSS

The CSS-to-Typst Lua filter operates over the entire AST (not just tables and pre-tags). For troubleshooting purposes, the filter can be disabled with:

``` yaml
format:
  typst:
    css-property-processing: none
```
    

## `pre` tag processing {#pre-tags}

`pre`-tag processing is intended for automatic translation of ANSI to Typst via HTML. Quarto does not currently capture ANSI output from execution, but this feature is available for packages and extensions.

`pre` tag processing is opt-in with `html-pre-tag-processing="parse"` on a div directly enclosing the HTML raw block:

```` markdown
::: {html-pre-tag-processing="parse"}

```{=html}
<pre>...</pre>
```
:::
````

## Troubleshooting

To make sure that a package is outputting HTML tables that can be translated with Typst CSS, render the document with `keep-md: true`. Then check the `.typst.md` file for HTML Raw Blocks like 

````html
```{=html}
<table>
</table>
```
````
The raw block must contain an HTML `<table>` tag, which may be preceded by stylesheets (`<style>`).

Similarly, a raw block intended for `pre` tag processing must contain a `<pre>` tag, which may be preceded by stylesheets.

## Modifying the translation

You can add your own Lua filters to add or change the translation of CSS properties into Typst properties.

Consult the Pandoc documentation for [Typst property output](https://pandoc.org/typst-property-output.html) and the source of the [Lua filter which translates CSS properties to Typst](https://github.com/quarto-dev/quarto-cli/blob/main/src/resources/filters/quarto-post/typst-css-property-processing.lua).

You can override the Typst CSS Lua filter's behavior by running your filter before it and removing CSS properties (untested). You can add support for other CSS properties by running your filter before or after the Typst CSS Lua filter.
```````

## File: docs/advanced/environment-vars.qmd
```````
---
title: "Environment Variables"
summary: Environment variables Quarto inspects and sets
format: html
---

## Variables Quarto inspects

These are variables that you can set to control how Quarto renders documents. For example, you can set them explicitly before running `quarto render`:

``` {.bash filename="Terminal"}
export QUARTO_R=/opt/R/4.2.3/bin
quarto render
```

You can read about other ways to set environment variables in Quarto Projects in [Environment Variables](/docs/projects/environment.qmd).

+---------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| Variable                        | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
+=================================+=============================================================================================================================================================================================================================================================================================================================================================================================================================================================+
| `QUARTO_R`                      | Explicit path to the version of `Rscript` to be used by the `knitr` engine and `quarto run *.R` command.                                                                                                                                                                                                                                                                                                                                                    |
+---------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| `QUARTO_PYTHON`                 | Explicit path to the version of `python` to be used by the `jupyter` engine and `quarto run *.py` command.                                                                                                                                                                                                                                                                                                                                                  |
+---------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| `QUARTO_JULIA`                  | Explicit path to the version of `julia` to be used by the `julia` engine.                                                                                                                                                                                                                                                                                                                                                                                   |
+---------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| `QUARTO_VERSION_REQUIREMENT`    | A [`semver`](https://semver.org/) string describing the Quarto version requested by the environment. If this check fails, Quarto will not run.                                                                                                                                                                                                                                                                                                              |
+---------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| `QUARTO_KNITR_RSCRIPT_ARGS`     | Comma separated list of command line argument to pass to `Rscript` started by Quarto when rendering with `knitr` engine, e.g.                                                                                                                                                                                                                                                                                                                               |
|                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
|                                 | ```                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
|                                 | QUARTO_KNITR_RSCRIPT_ARGS="--no-init-file,--max-connections=258"                                                                                                                                                                                                                                                                                                                                                                                            |
|                                 | ```                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
+---------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| `QUARTO_TEXLIVE_BINPATH`        | Explicit path to the TeX Live binaries to be passed to `tlmgr option sys_bin` used when setting `tlmgr` and related to `PATH` using `tlmgr add path` . By default, Quarto looks in known places.                                                                                                                                                                                                                                                            |
+---------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| `QUARTO_CHROMIUM`               | Explicit path to binary to use for chrome headless. Quarto uses [Chrome Devtools Protocol](https://chromedevtools.github.io/devtools-protocol/) to do screenshot of HTML diagrams for PDF insertion. The binary must be compatible with this protocol. (e.g. Chrome, Chromium, Chrome Headless Shell, Edge, ...)                                                                                                                                            |
+---------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| `QUARTO_CHROMIUM_HEADLESS_MODE` | Used for adaption of the `--headless` mode used with `QUARTO_CHROMIUM` binary. Set to `"none"` for `--headless` , or to `"old"` or `"new"` to pass as argument, e.g. `--headless=<QUARTO_CHROMIUM_HEADLESS_MODE>` . Quarto 1.6 sets `"old"` as default, which works from Chrome 112 to 131. Starting Quarto 1.7.13, `"none"` is the default as [Chrome 132 removed old headless mode](https://developer.chrome.com/blog/removing-headless-old-from-chrome). |
+---------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| `QUARTO_LOG`                    | Those variables controls the logging behavior:                                                                                                                                                                                                                                                                                                                                                                                                              |
|                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| `QUARTO_LOG_LEVEL`              | -   `QUARTO_LOG` is the same as using `--log` at command line. It is used to set the path to the log file                                                                                                                                                                                                                                                                                                                                                   |
|                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| `QUARTO_LOG_FORMAT`             | -   `QUARTO_LOG_LEVEL` is the same as using `--log-level` at command line. It is used to set the max level that will be log. Possible values are `DEBUG`, `INFO`(default), `WARNING`, and `ERROR`.                                                                                                                                                                                                                                                          |
|                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
|                                 | -   `QUARTO_LOG_FORMAT` is the same as using `--log-format` at command line. It is used to set the format for the log. Possible values are `plain` (default) and `json-stream`.                                                                                                                                                                                                                                                                             |
+---------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+

## Variables Quarto sets

These variables are set by Quarto you can query them. For example, you can query them in an executable code cell:

::: panel-tabset
## R

``` r
Sys.getenv("QUARTO_DOCUMENT_PATH")
```

## Python

``` python
import os
print(os.environ["QUARTO_DOCUMENT_PATH"])
```

## Julia

``` julia
ENV["QUARTO_DOCUMENT_PATH"]
```
:::

+--------------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| Variable                                   | Description                                                                                                                                                                                     |
+============================================+=================================================================================================================================================================================================+
| `QUARTO_PROJECT_ROOT`                      | Root of the project, or the directory of the file if not in project mode                                                                                                                        |
+--------------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| `QUARTO_DOCUMENT_PATH`                     | Directory of the document being rendered                                                                                                                                                        |
+--------------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| `QUARTO_DOCUMENT_FILE`                     | Name of the file being rendered                                                                                                                                                                 |
+--------------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| `QUARTO_PROFILE`                           | Profile used, e.g `QUARTO_PROFILE=advanced,production` for `quarto render --profile advanced,production`                                                                                        |
+--------------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| `QUARTO_FIG_WIDTH` and `QUARTO_FIG_HEIGHT` | Values for `fig-width` and `fig-height` as set in the document metadata                                                                                                                         |
+--------------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| `QUARTO_RUN_NO_NETWORK`                    | When `true`, Quarto project scripts written in TypeScript won't be allowed to use the network to download sources. In this setting, those scripts will not have access to the standard library. |
+--------------------------------------------+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
```````

## File: docs/advanced/index.qmd
```````
---
title: "Advanced User Documentation"
format: html
search: false
listing: 
  type: table
  fields: [title, summary]
  field-display-names:
    summary: Summary
---

Topics on this page may be of interest to advanced users of Quarto.
```````

## File: docs/authoring/_embed-examples/sample-notebook-view.qmd
```````
---
title: Exploration of penguin characteristics
author: Norah Jones
toc: true
notebook-view:
  - notebook: penguins.ipynb
    title: "Plots and Computations"
    url: https://colab.research.google.com/drive/12GsIPQ644SI4vkEEHiZn-Qqfbr-bD1
---

## How distinct are the species on the bill dimensions?

One interesting aspect of penguins is their bill shapes. Different species of penguins have bills that are adapted to their specific diet and habitat. 

{{< embed ../penguins.ipynb#fig-bill-marginal >}}

## What if we look at both dimensions together?
```````

## File: docs/authoring/_embed-examples/sample.qmd
```````
---
title: Exploration of penguin characteristics
author: Norah Jones
toc: true
---

## How distinct are the species on the bill dimensions?

One interesting aspect of penguins is their bill shapes. Different species of penguins have bills that are adapted to their specific diet and habitat. 

{{< embed ../penguins.ipynb#fig-bill-marginal >}}

## What if we look at both dimensions together?
```````

## File: docs/authoring/_figure-examples/_examples.qmd
```````
---
title: Examples used in `../figures.qmd`
fontsize: 1.5em
---

``` {.bash filename="Terminal"}
quarto render _examples.qmd
quarto render _examples.qmd --to pdf
quarto render _examples.qmd --to docx
quarto run take-screenshots.R
```

## Figure Basics

![Elephant](elephant.png){width="400px"}


## Subfigures

::: {#fig-elephants layout-ncol=2}

![Surus](surus.png){#fig-surus}

![Hanno](hanno.png){#fig-hanno}

Famous Elephants
:::

## Figure Panels

::: {#elephant-figures-no-subcaption layout-ncol=2}
![Surus](surus.png)

![Hanno](hanno.png)
:::

## Multiple Rows

::: {#elephant-rows layout-nrow=2}
![Surus](surus.png)

![Hanno](hanno.png)

![Abdul Abbas](abdul-abbas.png)

![Lin Wang](lin-wang.png)
:::

## Custom Layouts

::: {#layout-attrib layout="[[1,1], [1]]"}
![Surus](surus.png)

![Hanno](hanno.png)

![Lin Wang](lin-wang.png)
:::

::: {#layout-attrib-negative layout="[[40,-20,40], [100]]"}
![Surus](surus.png)

![Hanno](hanno.png)

![Lin Wang](lin-wang.png)
:::

## Vertical Alignment

::: {#valign layout="[15,-2,10]" layout-valign="bottom"}
![Surus](surus.png)

![Lin Wang](lin-wang.png)
:::
```````

## File: docs/authoring/_mermaid-examples/customize.qmd
```````
---
format:
  html:
    css: custom.css
---

```{mermaid}
flowchart LR
  qmd --> J([Jupyter])
  qmd --> K([knitr])
  J --> md
  K --> md
  md --> P([pandoc])
  P --> pdf
  P --> html
  P --> docx
```
```````

## File: docs/authoring/_mermaid-examples/dark.qmd
```````
---
format:
  html:
    mermaid:
      theme: dark
---

```{mermaid}
flowchart LR
  qmd --> J([Jupyter])
  qmd --> K([knitr])
  J --> md
  K --> md
  md --> P([pandoc])
  P --> pdf
  P --> html
  P --> docx
```
```````

## File: docs/authoring/_mermaid-examples/darkly.qmd
```````
---
format:
  html:
    theme: darkly
---

## Quarto Render

```{mermaid}
flowchart LR
  qmd --> J([Jupyter])
  qmd --> K([knitr])
  J --> md
  K --> md
  md --> P([pandoc])
  P --> pdf
  P --> html
  P --> docx
```

Read more on the [Quarto documentation site](https://quarto.org)
```````

## File: docs/authoring/_mermaid-examples/default.qmd
```````
---
format:
  html:
    mermaid:
      theme: default
---

```{mermaid}
flowchart LR
  qmd --> J([Jupyter])
  qmd --> K([knitr])
  J --> md
  K --> md
  md --> P([pandoc])
  P --> pdf
  P --> html
  P --> docx
```
```````

## File: docs/authoring/_mermaid-examples/forest.qmd
```````
---
format:
  html:
    mermaid:
      theme: forest
---

```{mermaid}
flowchart LR
  qmd --> J([Jupyter])
  qmd --> K([knitr])
  J --> md
  K --> md
  md --> P([pandoc])
  P --> pdf
  P --> html
  P --> docx
```
```````

## File: docs/authoring/_mermaid-examples/neutral.qmd
```````
---
format:
  html:
    mermaid:
      theme: neutral
---

```{mermaid}
flowchart LR
  qmd --> J([Jupyter])
  qmd --> K([knitr])
  J --> md
  K --> md
  md --> P([pandoc])
  P --> pdf
  P --> html
  P --> docx
```
```````

## File: docs/authoring/_mermaid-examples/sandstone.qmd
```````
---
format:
  html:
    theme: sandstone
---

## Quarto Render

```{mermaid}
flowchart LR
  qmd --> J([Jupyter])
  qmd --> K([knitr])
  J --> md
  K --> md
  md --> P([pandoc])
  P --> pdf
  P --> html
  P --> docx
```

Read more on the [Quarto documentation site](https://quarto.org)
```````

## File: docs/authoring/_mermaid-examples/solar.qmd
```````
---
format:
  html:
    theme: sandstone
---

## Quarto Render

```{mermaid}
flowchart LR
  qmd --> J([Jupyter])
  qmd --> K([knitr])
  J --> md
  K --> md
  md --> P([pandoc])
  P --> pdf
  P --> html
  P --> docx
```

Read more on the [Quarto documentation site](https://quarto.org)
```````

## File: docs/authoring/_mermaid-examples/vapor.qmd
```````
---
format:
  html:
    theme: vapor
---

## Quarto Render

```{mermaid}
flowchart LR
  qmd --> J([Jupyter])
  qmd --> K([knitr])
  J --> md
  K --> md
  md --> P([pandoc])
  P --> pdf
  P --> html
  P --> docx
```

Read more on the [Quarto documentation site](https://quarto.org)
```````

## File: docs/authoring/code-annotation-example/revealjs.qmd
```````
---
format: revealjs
code-annotations: hover
---

## Reveal Presentation

``` r
library(tidyverse)
library(palmerpenguins)
penguins |>                                      # <1>
  mutate(                                        # <2>
    bill_ratio = bill_depth_mm / bill_length_mm, # <2>
    bill_area  = bill_depth_mm * bill_length_mm  # <2>
  )                                              # <2>
```

1.  Take `penguins`, and then,
2.  add new columns for the bill ratio and bill area.
```````

## File: docs/authoring/_brand-example.qmd
```````
As an example, consider the following `_brand.yml` file:

``` {.yaml filename="_brand.yml"}
color:
  palette:
    dark-grey: "#222222"
    blue: "#ddeaf1"
  background: blue
  foreground: dark-grey
  primary: black

logo: 
  medium: logo.png

typography:
  fonts:
    - family: Jura
      source: google
  base: Jura
  headings: Jura
```

When this `_brand.yml` is placed in a project, webpages, presentations, PDF reports, and dashboards will share a common appearance:

::::::: {.column-body-outset-right layout-ncol="4"}
::: {}
![Webpage: `html`](/docs/authoring/images/brand-html.png){.lightbox group="brand-formats" fig-alt="Screenshot of a webpage. The text is dark grey on a light blue background, using a rounded sans-serif typeface, a logo appears in the navbar."}
:::

::: {}
![Dashboard `dashboard`](/docs/authoring/images/brand-dashboard.png){.lightbox group="brand-formats" fig-alt="Screenshot of a dashboard. The text is dark grey on a light blue background, using a rounded sans-serif typeface, a logo appears in the navbar."}
:::

::: {}
![Presentation: `revealjs`](/docs/authoring/images/brand-revealjs.png){.lightbox group="brand-formats" fig-alt="Screenshot of a presentation. The text is dark grey on a light blue background, using a rounded sans-serif typeface, a logo appears in bottom left of the slide."}
:::

:::{}
![PDF: `typst`](/docs/authoring/images/brand-typst.png){.lightbox group="brand-formats" fig-alt="Screenshot of a PDF document. The text is dark grey on a light blue background, using a rounded sans-serif typeface, a logo appears in top right of the page."}
::: 
:::


View the example: [Source](https://github.com/quarto-dev/quarto-examples/tree/main/brand/brand-simple#brand-simple) | [Live website](https://examples.quarto.pub/brand-simple)
```````

## File: docs/authoring/_cross-reference-divs-diagram.qmd
```````
To create a cross-references to a diagram using div syntax, treat it like a figure. For example, @fig-simple is created using:

````markdown
::: {#fig-simple}

```{dot}
graph {
  A -- B
}
```

This is a simple graphviz graph
:::
````

::: {#fig-simple .column-margin}

```{dot}
//| fig-width: 1.5
graph {
  A -- B
}
```

This is a simple graphviz graph
:::

If you would rather give diagrams a label and counter distinct from figures, consider defining [Custom Cross-Reference Types](cross-references-custom.qmd).
```````

## File: docs/authoring/_cross-reference-divs-figure.qmd
```````
To create a cross-reference to a figure using div syntax, create a fenced div with an id starting with `fig-`, include the image followed by the caption inside the div:

````markdown
::: {#fig-elephant}

![](elephant.png)

An Elephant
:::
````
```````

## File: docs/authoring/_cross-reference-divs-listing.qmd
```````
To create a cross-reference to a code listing using div syntax, create a fenced div with an id starting with `lst-`, include the code cell followed by the caption inside the div:   

````markdown
::: {#lst-customers}

```{.sql}
SELECT * FROM Customers
```

Customers Query

:::
````
```````

## File: docs/authoring/_cross-reference-divs-table.qmd
```````
To create a cross-reference to a table using div syntax, create a fenced div with an id starting with `tbl-`, include the table followed by the caption inside the div:

````markdown
::: {#tbl-letters}

| Col1 | Col2 | Col3 |
|------|------|------|
| A    | B    | C    |
| E    | F    | G    |
| A    | G    | G    |

My Caption

::: 
````
```````

## File: docs/authoring/_cross-reference-divs-video.qmd
```````
To add a cross-reference to a video, use the [cross-reference div syntax](cross-references-divs.qmd) and treat it like a figure. For example, 

````{.markdown shortcodes=false}
::: {#fig-cern}

{{< video https://www.youtube.com/embed/wo9vZccmqwc >}}

The video "CERN: The Journey of Discovery"

:::

In @fig-cern...
````

Which renders as:

![](images/crossrefs-video.png){fig-alt="Screenshot that shows a YouTube video followed by the caption, 'Figure 1: The video CERN: The Journey of Discovery'. Below the caption is the text 'In Figure 1 ...'."}

If you would rather give videos a label and counter distinct from figures, consider defining [Custom Cross-Reference Types](cross-references-custom.qmd).
```````

## File: docs/authoring/_cross-references-callouts.qmd
```````
To cross-reference a callout, add an ID attribute that starts with the appropriate callout prefix (see @tbl-callout-prefixes). You can then reference the callout using the usual `@` syntax. For example, here we add the ID `#tip-example` to the callout, and then refer back to it:

``` markdown
::: {#tip-example .callout-tip}
## Cross-Referencing a Tip

Add an ID starting with `#tip-` to reference a tip.
:::

See @tip-example...
```

This renders as follows:

::: {.border .p-3}
::: {#tip-example .callout-tip}
## Cross-Referencing a Tip

Add an ID starting with `#tip-` to reference a tip.
:::

See @tip-example...
:::

The prefixes for each type of callout are:

| Callout Type | Prefix  |
|--------------|---------|
| `note`       | `#nte-` |
| `tip`        | `#tip-` |
| `warning`    | `#wrn-` |
| `important`  | `#imp-` |
| `caution`    | `#cau-` |

: Prefixes for callout cross-references {#tbl-callout-prefixes}
```````

## File: docs/authoring/_cross-references-listings.qmd
```````
To cross-reference code from an executable code block, add the code cell options `lst-label` and `lst-cap`. The option `lst-label` provides the cross reference identifier and must begin with the prefix `lst-` to be treated as a code listing. The value of `lst-cap` provides the caption for the code listing. For example:

````{.markdown}
```{{python}}
#| lst-label: lst-import
#| lst-cap: Import pyplot

import matplotlib.pyplot as plt
```

@lst-import...
````

When rendered, this results in the following:

::: {.border .p-3}

```{python}
#| lst-label: lst-import
#| lst-cap: Import pyplot

import matplotlib.pyplot as plt
```

@lst-import...

:::

If the code cell produces a figure or table, you can combine the `lst-` options with `label` and `fig-cap`/`tbl-cap` to create cross references to both the code and output:

````{.markdown}
```{{python}}
#| label: fig-plot
#| fig-cap: Figure caption
#| lst-label: lst-plot
#| lst-cap: Listing caption

plt.plot([1,23,2,4])
plt.show()
```

The code in @lst-plot produces the figure in @fig-plot.
````

When rendered, this produces the following output:

:::{.border .p-3}
```{python}
#| label: fig-plot
#| fig-cap: Figure caption
#| lst-label: lst-plot
#| lst-cap: Listing caption

plt.plot([1,23,2,4])
plt.show()
```

The code in @lst-plot produces the plot in @fig-plot.
:::
```````

## File: docs/authoring/_embeds-ipynb.qmd
```````
An alternative to including computations directly in the article notebook is to embed output from other notebooks. This manuscript project includes the notebook `data-screening.ipynb` in the `notebooks/` folder.

To embed output from a notebook, you can use the `embed` shortcode. Quarto shortcodes are special markdown directives that generate content. The `embed` shortcode is used in `{{< meta tool.article-file >}}` in the line:

``` {.markdown shortcodes="false"}
{{< embed notebooks/data-screening.ipynb#fig-spatial-plot >}}
```

The double curly braces (`{{`) and angle brackets (`<`) indicate this is a shortcode. The `embed` shortcode requires a path to a notebook cell. In this case, it's the file path to `data-screening.ipynb`, followed by `#` and a cell identifier. Here, the cell identifier is the cell label, set using the Quarto cell option `label` in code cell in the `data-screening.ipynb` notebook:

``` {.python filename="data-screening.ipynb"}
#| label: fig-spatial-plot
#| fig-cap: "Locations of earthquakes on La Palma since 2017."
#| fig-alt: "A scatterplot of earthquake locations plotting latitude 
#|   against longitude."
from matplotlib import colormaps
cmap = colormaps['viridis_r']
ax = df.plot.scatter(x="Longitude", y="Latitude", 
                     s=40-df["Depth(km)"], c=df["Magnitude"], 
                     figsize=(12,10), grid="on", cmap=cmap)
colorbar = ax.collections[0].colorbar
colorbar.set_label("Magnitude")

plt.show()
```

Just like any figure, using a label starting with `fig-` allows it to be cross referenced in the text. Any other options, like the figure caption (`fig-cap`) and alt text (`fig-alt`), can also be set in the source notebook.

In this manuscript, the notebook `data-screening.ipynb` isn't reproducible: you can't regenerate all the outputs because some inputs (e.g. the data) aren't included in the project. However, you can change the Quarto cell options without rerunning the code cells in the notebook. If you edit the caption to:

``` python
#| fig-cap: "Earthquakes on La Palma since 2017."
```

When you save `data-screening.ipynb`, you'll find the preview updates and the caption is reflected in the article itself.
```````

## File: docs/authoring/_kbd.qmd
```````
{{< include ../_require-1.3.qmd >}}

The `kbd` [shortcode](shortcodes.qmd) can be used to describe keyboard shortcuts in documentation. On Javascript formats, it will attempt to detect the operating system of the format and show the correct shortcut. On print formats, it will print the keyboard shortcut information for all operating systems.

For example, writing the following markdown:

``` md
To print, press {{{< kbd Shift-Ctrl-P >}}}. To open an existing new project, press {{{< kbd mac=Shift-Command-O win=Shift-Control-O linux=Shift-Ctrl-L >}}}.
```

will render the keyboard shortcuts as:

To print, press {{< kbd Shift-Ctrl-P >}}. To open an existing new project, press {{< kbd mac=Shift-Command-O win=Shift-Control-O linux=Shift-Ctrl-L >}}.
```````

## File: docs/authoring/_mermaid-theming.qmd
```````
{{< include ../_require-1.3.qmd >}}

The following sections describe the ways in which you can control the color theme of Mermaid diagrams:

- Using the current document theme.
- Using one of Mermaid's own color themes via a YAML option.
- Using SCSS and CSS variables.

### Default Colors for Mermaid Diagrams

If you use Quarto's [bootswatch built-in themes](/docs/output-formats/html-themes.qmd), including the default theme, or a custom theme that uses the same SCSS variables, your Mermaid diagrams will automatically follow your theme.

The following examples demonstrate this with a few of Quarto's built-in bootswatch themes.

::: panel-tabset

## Darkly

![](images/mermaid-darkly.png){fig-alt="A screenshot of a Mermaid flowchart in a document using bootswatch's Darkly theme."}

## Sandstone

![](images/mermaid-sandstone.png){fig-alt="A screenshot of a Mermaid flowchart in a document using bootswatch's Sandstone theme."}

## Vapor

![](images/mermaid-vapor.png){fig-alt="A screenshot of a Mermaid flowchart in a document using bootswatch's Vapor theme."}
:::

You can read more about the correspondence between Bootstrap's SCSS variables and Quarto's Mermaid SCSS variables, and how to change it, below in [Customizing the Mermaid Theme](#customizing-mermaid).

### Using Mermaid's Built-in Themes

If you want to use Mermaid's own themes, you can do so by configuring the `mermaid` option in your YAML front matter:

``` yml
format:
  html:
    mermaid:
      theme: forest
```

The available themes from mermaid are: `default`, `dark`, `forest`, and `neutral`.

::: panel-tabset
## default

![](images/mermaid-default.png){fig-alt="A screenshot of a Mermaid flowchart using the Mermaid's default theme."}

## dark

![](images/mermaid-dark.png){fig-alt="A screenshot of a Mermaid flowchart using the Mermaid's dark theme."}

## forest

![](images/mermaid-forest.png){fig-alt="A screenshot of a Mermaid flowchart using the Mermaid's forest theme."}

## neutral

![](images/mermaid-neutral.png){fig-alt="A screenshot of a Mermaid flowchart using the Mermaid's neutral theme."}

:::

### Customizing the Mermaid Theme {#customizing-mermaid}

Quarto provides its own Mermaid SCSS and CSS variables that can be overwritten to allow some customization of the diagram theme. The SCSS variables, together with their default values, are:

<!-- This comes from quarto-dev/quarto-cli/src/resources/formats/html/_quarto-rules.scss -->

``` scss
$mermaid-bg-color: $body-bg;
$mermaid-edge-color: $secondary;
$mermaid-node-fg-color: $body-color;
$mermaid-fg-color: $body-color;
$mermaid-fg-color--lighter: lighten($body-color, 10%);
$mermaid-fg-color--lightest: lighten($body-color, 20%);
$mermaid-font-family: $font-family-sans-serif;
$mermaid-label-bg-color: $body-bg;
$mermaid-label-fg-color: $primary;
$mermaid-node-bg-color: rgba($primary, 0.1);
$mermaid-node-fg-color: $primary;

```

Their CSS variable counterparts are:

``` css
:root {
  --mermaid-bg-color: #{$mermaid-bg-color};
  --mermaid-edge-color: #{$mermaid-edge-color};
  --mermaid-node-fg-color: #{$mermaid-node-fg-color};
  --mermaid-fg-color: #{$mermaid-fg-color};
  --mermaid-fg-color--lighter: #{$mermaid-fg-color--lighter};
  --mermaid-fg-color--lightest: #{$mermaid-fg-color--lightest};
  --mermaid-font-family: #{$mermaid-font-family};
  --mermaid-label-bg-color: #{$mermaid-label-bg-color};
  --mermaid-label-fg-color: #{$mermaid-label-fg-color};
  --mermaid-node-bg-color: #{$mermaid-node-bg-color};
  --mermaid-node-fg-color: #{$mermaid-node-fg-color};
}
```

For example, to provide a custom color for the background of the nodes you could [add a custom CSS stylesheet](/docs/output-formats/html-basics.qmd#css-styles) containing:

```css
:root {
  --mermaid-node-bg-color: #375a7f;
}
```

You can find the correspondence between Quarto's variables and Mermaid's native CSS classes in Quarto's source code in the file [embed-mermaid.css](https://github.com/quarto-dev/quarto-cli/blob/main/src/resources/formats/html/mermaid/embed-mermaid.css).
```````

## File: docs/authoring/_pagebreak.qmd
```````
## Page Breaks

The `pagebreak` [shortcode](shortcodes.qmd) enables you to insert a native pagebreak into a document (.e.g in LaTeX this would be a `\newpage`, in MS Word a docx-native pagebreak, in HTML a `page-break-after: always` CSS directive, etc.):

```{.markdown shortcodes="false"}
page 1

{{< pagebreak >}}

page 2
```

Native pagebreaks are supported for HTML, LaTeX, Context, MS Word, Open Document, and ePub (for other formats a form-feed character `\f` is inserted).
```````

## File: docs/authoring/_shortcodes.qmd
```````
## Overview

Shortcodes are special markdown directives that generate various types of content. Quarto shortcodes are similar in form and function to [Hugo shortcodes](https://gohugo.io/content-management/shortcodes/) and [WordPress shortcodes](https://codex.wordpress.org/Shortcode).

For example, the following shortcode prints the `title` from document metadata:

``` {.markdown shortcodes="false"}
{{< meta title >}}
```

## Built-in Shortcodes

Quarto supports several shortcodes natively:

| Shortcode                                                     | Description                              |
|---------------------------------------------------------------|------------------------------------------|
| [version](/docs/authoring/version.qmd)                        | Print Quarto CLI version                 |
| [var](/docs/authoring/variables.qmd#var)                      | Print value from `_variables.yml` file   |
| [meta](/docs/authoring/variables.qmd#meta)                    | Print value from document metadata       |
| [env](/docs/authoring/variables.qmd#url)                      | Print system environment variable        |
| [pagebreak](/docs/authoring/markdown-basics.qmd#page-breaks)  | Insert a native page-break               |
| [kbd](/docs/authoring/markdown-basics.qmd#keyboard-shortcuts) | Describe keyboard shortcuts              |
| [video](/docs/authoring/videos.qmd)                           | Embed a video in a document              |
| [include](/docs/authoring/includes.qmd)                       | Include contents of another qmd          |
| [embed](/docs/authoring/notebook-embed.qmd)                   | Embed cells from a Jupyter Notebook      |
| [placeholder](/docs/authoring/placeholder.qmd)                | Add placeholder images to your document  |
| [lipsum](/docs/authoring/lipsum.qmd)                          | Add placeholder text to your document    |
| [contents](/docs/authoring/contents.qmd)                      | Rearrange content in your document       |
```````

## File: docs/authoring/appendices.qmd
```````
---
title: Appendices
---

## Overview

HTML pages rendered with Quarto include a formatted appendix at the end of the article. The appendix includes sections for citations and footnotes in the document, as well the attribution information (if specified) for the document itself.

A simple example document appendix looks like:

![](images/document-appendix-simple.png){.border fig-alt="Appendix with two sections: References, and Footnotes."}

To learn more about including document attribution information in the appendix, see [Creating Citeable Articles](/docs/authoring/create-citeable-articles.qmd).

## Custom Appendix Sections

Sections of your document can be added to the Appendix that appears at the end of your article by adding the `.appendix` class to any heading. For example:

``` yaml
## Acknowledgments {.appendix}

I am grateful for the insightful comments offered by the anonymous peer reviewers at Books & Texts. The generosity and expertise of one and all have improved this study in innumerable ways and saved me from many errors; those that inevitably remain are entirely my own responsibility.
```

Any sections marked with the `.appendix` class will be included at the front of the appendix in the order in which they appear in the document. A more complete example appendix including attribution and the above custom appendix section looks like:

![](images/document-appendix-full.png){.border fig-alt="Appendix with Acknowledgements, References, Footnes, and Citation sections. The Citation section contains both BibTex citation, and plain text for attribution."}

## License

If you include a license in the front matter or citation information for your document, a 'Reuse' section will automatically be added to the appendix. Read more about specifying a license in [Front Matter](/docs/authoring/front-matter.qmd#license).

Here is an example of a complete appendix including all the fields with an Attribution-ShareAlike Creative Commons license.

![](images/document-appendix-reuse.png){.border fig-alt="Appendix with Acknowledgements, References, Footnotes, Reuse, and Citation sections. The Reuse section contains a link to the Attribution-ShareAlike Creative Commons license."}


## Appendix Style

You can control how Quarto process the appendix of your document using the `appendix-style` option. There are three options available:

`default`

:   The default appendix treatment create a smaller font face and gathers the various sections into stylized groups at the end of the document.

`plain`

:   The plain treatment will do all the appendix processing (gathering and organizing the sections at the end of the document, creating sections like 'Reuse'), but will not apply the default appendix styling.

`none`

:   `none` disables appendix processing altogether. Content will not be processed or organized and information like 'Citation' and 'Reuse' will not be included in the document.
```````

## File: docs/authoring/article-layout.qmd
```````
---
title: "Article Layout"
format: html
reference-location: margin
citation-location: margin
aliases:
  - page-layout.html
---

## Overview

Quarto supports a variety of page layout options that enable you to author content that:

-   Fills the main content region
-   Overflows the content region
-   Spans the entire page
-   Occupies the document margin
-   Uses landscape mode in paginated formats

Quarto uses the concept of columns to describe page layout (e.g. the "body" column, the "margin" column, etc.). Below we'll describe how to arrange content into these columns. If you need to adjust the widths of the columns, see [Page Layout - Grid Customization](/docs/output-formats/page-layout.qmd#grid-customization).

All of the layout capabilities described in this document work for HTML output and many work for PDF and LaTeX output. For details about the PDF / LaTeX output, see [PDF/LaTeX Layout].

## Body Column

By default, elements are position in the body of the document and are allowed to span the content of the document, like the below.

::: {.layout-example .column-body}
.column-body
:::

But if you'd like, you can extend content slightly outside the bounds of the body by creating a div with the .`column-body-outset` class. For example:

``` markdown
:::{.column-body-outset}
Outset content...
:::
```

::: {.layout-example .column-body-outset}
.column-body-outset
:::

## Page Column

If you need even more space for your content, you can use the `.column-page` class to make the content much wider, though stopping short of extending across the whole document.

::: {.layout-example .column-page}
.column-page
:::

For example, to create a wider image, you could use:

``` markdown
:::{.column-page}
![](images/elephant.jpg)
:::
```

::: column-page
![](images/elephant.jpg){fig-alt="Three walking elephants in silhouette against the backdrop of a sunset."}
:::

For computational output, you can specify the page column in your code cell options. For example:

```{r}
#| column: page
#| echo: fenced

knitr::kable(
  mtcars[1:6, 1:10]
)
```

In addition, you can use `.column-page-inset` to inset the element from the page slightly, like so:

::: {.layout-example .column-page-inset}
.column-page-inset
:::

## Screen Column

You can have content span the full width of the page with no margin (full bleed). For this, use the `.column-screen` class or specify `column: screen` on a code cell. For example:

``` md
::: {.column-screen}
![A full screen image](/image.png)
:::
```

::: {.layout-example .column-screen}
.column-screen
:::

The following code displays a Leaflet map across the whole page.

```{r}
#| column: screen
#| echo: fenced

library(leaflet)
leaflet() %>%
  addTiles() %>%  # Add default OpenStreetMap map tiles
  addMarkers(lng=174.768, lat=-36.852, popup="The birthplace of R")
```

### Screen Inset

If you'd like a full width appearance, but would like to retain a margin, you can use inset or inset-shaded modifiers on the column. For example:

``` md
::: {.column-screen-inset}
![A full screen image](/image.png)
:::
```

::: {.layout-example .column-screen-inset}
.column-screen-inset
:::

The inset-shaded modifier results in a block spanning the full width but wrapped with a lightly shaded background. For example:

```{r}
#| column: screen-inset-shaded
#| echo: fenced

library(leaflet)
leaflet() %>%
  addTiles() %>%  # Add default OpenStreetMap map tiles
  addMarkers(lng=174.768, lat=-36.852, popup="The birthplace of R")
```

Column layouts like `screen-inset-shaded` will work with advanced figure layout. For example, it is straightforward to create a multi column presentation of figures that spans the document:

```{r}
#| column: screen-inset-shaded
#| layout-nrow: 1
#| echo: fenced

plot(cars)
plot(iris)
plot(pressure)
```

## Margin Content

You can place content within the right margin of Quarto document. For example, here we use the `.column-margin` class to place an image in the margin:

``` md
::: {.column-margin}
![A margin image](image.png)
:::
```

::: {.layout-example .column-margin style="margin-top: 18px;"}
.column-margin
:::

This also works for text content:

``` md
::: {.column-margin}
We know from *the first fundamental theorem of calculus* that for $x$ in $[a, b]$:

$$\frac{d}{dx}\left( \int_{a}^{x} f(u)\,du\right)=f(x).$$
:::
```

::: column-margin
We know from *the first fundamental theorem of calculus* that for $x$ in $[a, b]$:

$$\frac{d}{dx}\left( \int_{a}^{x} f(u)\,du\right)=f(x).$$
:::

### Margin Figures

Figures that you create using code cells can be placed in the margin by using the `column: margin` code cell option. If the code produces more than one figure, each of the figures will be placed in the margin.

```{r}
#| label: fig-mtcars
#| fig-cap: "MPG vs horsepower, colored by transmission."
#| column: margin
#| echo: fenced

library(ggplot2)
mtcars2 <- mtcars
mtcars2$am <- factor(
  mtcars$am, labels = c('automatic', 'manual')
)
ggplot(mtcars2, aes(hp, mpg, color = am)) +
  geom_point() +
  geom_smooth(formula = y ~ x, method = "loess") +
  theme(legend.position = 'bottom')
```

### Margin Tables

You can also place tables in the margin of your document by specifying `column: margin`.

```{r}
#| column: margin
#| echo: fenced

knitr::kable(
  mtcars[1:6, 1:3]
)
```

### Multiple Outputs

You can also target specific output types (for example, figures) to be placed in the margin. For example, the following code will render a table showing part of the `mtcars` dataset and produce a plot in the margin next to the table.

```{r}
#| fig-column: margin
#| echo: fenced

mtcars2 <- mtcars
mtcars2$am <- factor(
  mtcars$am, labels = c('automatic', 'manual')
)

knitr::kable(
  mtcars[1:6, 1:6]
)

library(ggplot2)
ggplot(mtcars2, aes(hp, mpg, color = am)) +
  geom_point() +
  geom_smooth(formula = y ~ x, method = "loess") +
  theme(legend.position = 'bottom')
```

{{< include _pagebreak.qmd >}}

## Margin References

Footnotes and the bibliography typically appear at the end of the document, but you can choose to have them placed in the margin by setting the following option[^1] in the document front matter:

``` yaml
---
reference-location: margin
citation-location: margin
---
```

With these options set, footnotes and citations will (respectively) be automatically be placed in the margin of the document rather than the bottom of the page. As an example, when I cite @xie2018, the citation bibliography entry itself will now appear in the margin.

### Asides

Asides allow you to place content aside from the content it is placed in. Asides look like footnotes, but do not include the footnote mark (the superscript number). [This is a span that has the class `aside` which places it in the margin without a footnote number.]{.aside}

``` markdown
[This is a span that has the class `aside` which places it in the margin without a footnote number.]{.aside}
```

## Margin Captions

For figures and tables, you may leave the content in the body of the document while placing the caption in the margin of the document. Using `cap-location: margin` in a code cell or document front matter to control this. For example:

```{r}
#| label: fig-cap-margin
#| fig-cap: "MPG vs horsepower, colored by transmission."
#| cap-location: margin
#| echo: fenced

library(ggplot2)
mtcars2 <- mtcars
mtcars2$am <- factor(
  mtcars$am, labels = c('automatic', 'manual')
)
ggplot(mtcars2, aes(hp, mpg, color = am)) +
  geom_point() +
  geom_smooth(formula = y ~ x, method = "loess") +
  theme(legend.position = 'bottom')
```

## Overflowing Content

You can also extend content outside the body region on only the left or right side of the document by using the `right` and `left` versions of the `body`, `page`, and `screen` columns to layout your content. The `left` or `right` version of these columns are as follows:

::: {.layout-example .column-body-outset-right .left}
.column-body-outset-right
:::

::: {.layout-example .column-page-inset-right .left}
.column-page-inset-right
:::

::: {.layout-example .column-page-right .left}
.column-page-right
:::

::: {.layout-example .column-screen-inset-right .left}
.column-screen-inset-right
:::

::: {.layout-example .column-screen-right .left}
.column-screen-right
:::

::: {.layout-example .column-body-outset-left .right}
.column-body-outset-left
:::

::: {.layout-example .column-page-inset-left .right}
.column-page-inset-left
:::

::: {.layout-example .column-page-left .right}
.column-page-left
:::

::: {.layout-example .column-screen-inset-left .right}
.column-screen-inset-left
:::

::: {.layout-example .column-screen-left .right}
.column-screen-left
:::

Use a div with one of the above classes to align content into one of the overflow regions. This also works using the `column` option of executable code cells:

```{r}
#| column: screen-inset-right
#| echo: fenced

library(leaflet)
leaflet() %>%
  addTiles() %>%  # Add default OpenStreetMap map tiles
  addMarkers(lng=174.768, lat=-36.852, popup="The birthplace of R")
```

## Options Reference

### Global Options

Some layout options can be specified globally in document yaml. For example:

``` yaml
---
fig-cap-location: margin
reference-location: margin
---
```

All of the below options currently only support setting a value of `margin` which tells Quarto to place the corresponding element in the margin.

+----------------------+---------------------------------------------------------------------------------------------------------+
| Option               | Description                                                                                             |
+======================+=========================================================================================================+
| `reference-location` | Where to place footnotes. Defaults to `document`.\                                                      |
|                      | \[`document` \| `section` \| `block` \| `margin` \]                                                     |
+----------------------+---------------------------------------------------------------------------------------------------------+
| `citation-location`  | Where to place citations. Defaults to `document`.\                                                      |
|                      | \[`document` \| `margin` \]                                                                             |
+----------------------+---------------------------------------------------------------------------------------------------------+
| `cap-location`       | Where to place figure and table captions. Defaults to `bottom` for figures and `top` for tables.\ |
|                      | \[`top` \| `bottom` \| `margin`\]                                                                       |
+----------------------+---------------------------------------------------------------------------------------------------------+
| `fig-cap-location`   | Where to place figure captions. Defaults to `bottom`.\                                                  |
|                      | \[`top` \| `bottom` \| `margin`\]                                                                       |
+----------------------+---------------------------------------------------------------------------------------------------------+
| `tbl-cap-location`   | Where to place table captions. Defaults to `top`.\                                                      |
|                      | \[`top` \| `bottom` \| `margin`\]                                                                       |
+----------------------+---------------------------------------------------------------------------------------------------------+

### Code Cell Options

You can also set layout column on specific code cells. This controls the layout of content that is produced by the code cell.

```{{r}}
#| column: page

plot(cars)
```

::: column-page-right
+--------------------+------------------------------------------------------------------------------------------------------------------------------+
| Option             | Description                                                                                                                  |
+====================+==============================================================================================================================+
| `column`           | Layout column to use for code cell outputs. See column options below.                                                        |
+--------------------+------------------------------------------------------------------------------------------------------------------------------+
| `fig-column`       | Layout column to use for code cell figure outputs. See column options below.                                                 |
+--------------------+------------------------------------------------------------------------------------------------------------------------------+
| `tbl-column`       | Layout column to use for code cell table outputs. See column options below.                                                  |
+--------------------+------------------------------------------------------------------------------------------------------------------------------+
| `cap-location`     | Where to place figure and table captions produced by this code cell. Defaults to `bottom` for figures and `top` for tables.\ |
|                    | \[`top` \| `bottom` \| `margin`\]                                                                                            |
+--------------------+------------------------------------------------------------------------------------------------------------------------------+
| `fig-cap-location` | Where to place captions for figures produced by this code cell. Defaults to `inline`.\                                       |
|                    | \[`inline` \| `margin`\]                                                                                                     |
+--------------------+------------------------------------------------------------------------------------------------------------------------------+
| `tbl-cap-location` | Where to place captions for tables produced by this code cell. Defaults to `inline`.\                                        |
|                    | \[`inline` \| `margin`\]                                                                                                     |
+--------------------+------------------------------------------------------------------------------------------------------------------------------+
:::

### Using Classes

In addition to global and code cell specific options, you may use divs with layout classes (prefixed with `.column-`) to arrange content into columns:

``` md
::: {.column-margin}
This content will appear in the margin!
:::
```

### Available Columns

Here are all of the available column specifiers:

::: column-page-right
+--------------+---------------------------------+---------------------------------+
| Column       | Code Cell `column`              | Class Name                      |
+==============+=================================+=================================+
| Body         |     column: body                |     .column-body                |
|              |     column: body-outset         |     .column-body-outset         |
|              |     column: body-outset-left    |     .column-body-outset-left    |
|              |     column: body-outset-right   |     .column-body-outset-right   |
+--------------+---------------------------------+---------------------------------+
| Page Inset   |     column: page-inset          |     .column-page-inset          |
|              |     column: page-inset-left     |     .column-page-inset-left     |
|              |     column: page-inset-right    |     .column-page-inset-right    |
+--------------+---------------------------------+---------------------------------+
| Page         |     column: page                |     .column-page                |
|              |     column: page-left           |     .column-page-left           |
|              |     column: page-right          |     .column-page-right          |
+--------------+---------------------------------+---------------------------------+
| Screen Inset |     column: screen-inset        |     .column-screen-inset        |
|              |     column: screen-inset-shaded |     .column-screen-inset-shaded |
|              |     column: screen-inset-left   |     .column-screen-inset-left   |
|              |     column: screen-inset-right  |     .column-screen-inset-right  |
+--------------+---------------------------------+---------------------------------+
| Screen       |     column: screen              |     .column-screen              |
|              |     column: screen-left         |     .column-screen-left         |
|              |     column: screen-right        |     .column-screen-right        |
+--------------+---------------------------------+---------------------------------+
| Margin       |     column: margin              |     .column-margin              |
+--------------+---------------------------------+---------------------------------+
:::

## PDF/LaTeX Layout {data-link="PDF/LaTeX Layout"}

While most of the layout capabilities described are supported for both HTML and PDF output, some are available only for HTML output. You can use the full set of columns for HTML. Then, when you render PDF or LaTeX output, content will automatically be placed in the most appropriate related column (typically this will mean using the main column and right margin). Here is how columns are mapped:

-   Any column that uses the right margin (e.g. `page`, `screen`, `screen-right`, etc.) will be rendered as `page-right` in LaTeX.
-   Any column that uses the left margin will be rendered as normal body content.

### Page Geometry

When you render a PDF using content in the margin or content that spans the page, Quarto will automatically adjust the page geometry for the default Quarto LaTeX document classes (KOMA `scrartcl`, `scrreport`, or `scrbook`) to create a slightly narrower body content region and a slightly wider margin region. This adjustment will incorporate known paper sizes to create a reasonable page geometry for most content.

You can control the page geometry directly yourself by setting `geometry` options in your document's front matter. For example:

``` yaml
---
geometry:
  - left=.75in
  - textwidth=4.5in
  - marginparsep=.25in
  - marginparwidth=2.25in
---
```

You can use these options to control the page geometry for the built-in document classes or to customize the geometry of other document classes that you may be using.

::: {.callout-tip appearance="simple"}
If you'd like to view the page geometry in your rendered PDF, you can pass `showframe` to the `geometry` option as in the below example.

``` {.yaml style="background: none;"}
---
geometry:
  - showframe
---
```
:::

### Code Blocks

When rendering a PDF that uses the margins for content, Quarto automatically adjusts the appearance of code blocks. Rather than having a solid background color, a left border treatment is used.

This enables non-breaking code to overflow into the margin without cosmetic issues created by the code block background (which does not overflow into the margin region).

You can disable this treatment by setting the following `code-block-border-left: false` in your document front matter.

## Landscape mode

In `docx`, `pdf` and `typst` formats, you can set portions of the document to landscape mode by wrapping the content around a fenced div with class `landscape`:

````markdown
---
format:
  docx: default
  typst: default
  pdf: default
---

This will appear in portrait mode.

::: {.landscape}

This will appear in landscape.

:::

This will appear in portrait mode again.
````



[^1]: You can also position references in other location (such as the bottom of the block, section, or document).
```````

## File: docs/authoring/brand.qmd
```````
---
title: Multiformat branding with `_brand.yml`
---

## Overview

Quarto supports [**brand.yml**](https://posit-dev.github.io/brand-yml/)---a single YAML file that can be used to customize the appearance of your documents across multiple formats. This is particularly useful for organizations that need a unified look across various formats.

{{< include _brand-example.qmd >}}

On this page:

-   Learn how to add a brand file.

-   Learn about the elements of **brand.yml** and how they are used in Quarto.

-   Learn how to access brand values outside of the brand file.

-   See a more comprehensive example.

-   Learn how to migrate projects created without `_brand.yml` to easily support `_brand.yml` features.

::: callout-warning
## Limitation

The **brand.yml** specification is an active area of work at Posit. Quarto's support for **brand.yml** is not yet complete. For now, we've highlighted places where Quarto doesn't yet support the full spec with special **Limitation** callouts, like this one.

Currently, the formats that support **brand.yml** are: `html`, `dashboard`, `revealjs` and `typst`.
:::

## Applying Brand

To specify a brand, create a `_brand.yml` file in the root directory of your project (i.e. alongside `_quarto.yml`).
Quarto will detect the presence of `_brand.yml` and automatically apply the brand to all documents of the supported formats in the project.

You can create a `_brand.yml` file outside of a Quarto project (e.g. without a `_quarto.yml`).
In this case, `_brand.yml` will automatically apply to documents in the same directory.

You can also set brand options in a document by specifying brand elements under the `brand` option:

```{.yaml filename="document.qmd"}
---
brand:
  color:
    background: "#eeeeee"
---
```

If you set `brand` in a document header, it will replace the entire brand from `_brand.yml`.

You can disable brand for a document by setting `brand` to `false`:

```{.yaml filename="document.qmd"}
---
brand: false
---
```

You can put  `_brand.yml` in a subdirectory of your project, and then use the `brand` key to specify the path to the brand file.
For example, to use the brand file at `brand/_brand.yml` for a single  document, add `brand` to the header:

```{.yaml filename="document.qmd"}
---
brand: brand/_brand.yml
---
```

To use the brand file at `brand/_brand.yml` for all documents in the project add `brand` to `_quarto.yml`:

```{.yaml filename="_quarto.yml"}
brand: brand/_brand.yml
```

Paths specified in `_brand.yml` are relative to the location of the brand file.

### Dark Brand

As with [Themes](/docs/output-formats/html-themes.qmd#dark-mode), you can specify both light and dark brands, making both a light and a dark version of your output available:

```{.yaml filename="document.qmd"}
---
brand:
  light: light-brand.yml
  dark: dark-brand.yml
---
```

This also works with brands specified directly in the document:

```{.yaml filename="document.qmd"}
---
brand:
  light:
    color:
      background: "#ffffff"
      foreground: "#333333"
  dark:
    color:
      background: "#333333"
      foreground: "#ffffff"
---
```

Light and dark brands can also be specified at the project-level:

```{.yaml filename="_quarto.yml"}
brand:
  light: light-brand.yml
  dark: dark-brand.yml
```


::: {.callout-warning}

## Limitation

The `revealjs` format does not support switching between light and dark modes.

:::


#### Typst

To choose a dark brand in Typst output use `brand-mode: dark`:

```{.yaml filename="document.qmd"}
---
format:
  typst:
    brand-mode: dark
---
```


## Brand Elements

The elements of **brand.yml** are specified in the documentation for the [**brand.yml** project](https://posit-dev.github.io/brand-yml/){.external}. 
In this section, learn how these elements are used in Quarto.

### Color 

[Color in the **brand.yml** docs](https://posit-dev.github.io/brand-yml/brand/color.html){.external}

Use `color` to define your brand's color palette and map your palette to the roles colors play, a.k.a semantic colors. A simple example might define the value `background` to a light blue:

``` {.yaml filename="_brand.yml"}
color:
  background: "#ddeaf1"
```

Use the `palette` key to define a set of named colors that can be referenced elsewhere in the `_brand.yml`. For example, you might define `blue` and set it as the `background`:

``` {.yaml filename="_brand.yml"}
color:
  palette:
    blue: "#ddeaf1"
  background: blue
```

The most commonly used semantic colors include `foreground`, `background` and `primary`:

``` {.yaml filename="_brand.yml"}
color:
  palette:
    dark-grey: "#222222"
    blue: "#ddeaf1"
  background: blue
  foreground: dark-grey
  primary: black
```

The colors `foreground` and `background` are used consistently across formats to set the color of the main text and color of the page it appears on.
The color `primary` sets the link color, navbar color (`html` and `dashboard`), and progress bar color (`revealjs`).

For HTML formats that use Bootstrap (`html`, `dashboard`) the remaining semantic colors are mapped directly to their Bootstrap counterparts with the same name.

::: {.callout-tip collapse="true"}

## Full list of semantic colors 

The full list of semantic colors you can set in `color` is:

+-----------------------+-------------------------------------------------------------------------------------------------------------------------------+
| Name                  | Description                                                                                                                   |
+=======================+===============================================================================================================================+
| `foreground`          | The main text color. Typically will be close to black and must have high contrast with the background color.                  |
+-----------------------+-------------------------------------------------------------------------------------------------------------------------------+
| `background`          | The main background color. Tyically will be close to white and must have high contrast with the foreground color.             |
+-----------------------+-------------------------------------------------------------------------------------------------------------------------------+
| `primary`             | The primary accent color, used for hyperlinks, active states, and primary action buttons.                                     |
+-----------------------+-------------------------------------------------------------------------------------------------------------------------------+
| `secondary`           | The secondary accent color, often used for lighter text or disabled states.                                                   |
+-----------------------+-------------------------------------------------------------------------------------------------------------------------------+
| `tertiary`            | The tertiary accent color, used for hover states, accents, and wells.                                                         |
+-----------------------+-------------------------------------------------------------------------------------------------------------------------------+
| `success`             | The color used for positive or successful actions and information.                                                            |
+-----------------------+-------------------------------------------------------------------------------------------------------------------------------+
| `info`                | The color used for neutral or informational actions and information.                                                          |
+-----------------------+-------------------------------------------------------------------------------------------------------------------------------+
| `warning`             | The color used for warning or cautionary actions and information.                                                             |
+-----------------------+-------------------------------------------------------------------------------------------------------------------------------+
| `danger`              | The color used for errors, dangerous actions, or negative information.                                                        |
+-----------------------+-------------------------------------------------------------------------------------------------------------------------------+
| `light`               | A bright color, used as a high-contrast foreground color on dark elements or low-contrast background color on light elements. |
+-----------------------+-------------------------------------------------------------------------------------------------------------------------------+
| `dark`                | A dark color, used as a high-contrast foreground color on light elements or high-contrast background color on light elements. |
+-----------------------+-------------------------------------------------------------------------------------------------------------------------------+

:::

You can access both named and semantic colors from your brand in SCSS and using the `brand` shortcode. See [Using `_brand.yml` values](#using-brand-values) for more details.

### Logo

[Logo in the **brand.yml** docs](https://posit-dev.github.io/brand-yml/brand/logo.html){.external}

Use `logo` to specify the logo for your brand:

``` {.yaml filename="_brand.yml"}
logo: 
  medium: logo.png
```

You can specify a local file path, relative to the location of `_brand.yml`, or a URL.

A single logo may not work well in all locations so **brand.yml** allows you to set three different logos: `small`, `medium` and `large`. For example:

``` {.yaml filename="_brand.yml"}
logo: 
  small: logo-small.png
  medium: logo.png
  large: logo-large.png
```

You don't need to specify all three---Quarto will use what you provide based on the following preferences:

+---------------------------+----------------------------------------------+-------------------------------+
| Format                    | Location                                     | Logo Preference (high to low) |
+===========================+==============================================+===============================+
| `html`/`dashboard`        | Top navigation bar                           | `small`\> `medium`\>`large`   |
+---------------------------+----------------------------------------------+-------------------------------+
| `html`                    | Side navigation                              | `medium`\>`small`\>`large`    |
+---------------------------+----------------------------------------------+-------------------------------+
| `typst`                   | Top left, control with `format: typst: logo` | `medium`\>`small`\>`large`    |
+---------------------------+----------------------------------------------+-------------------------------+
| `revealjs`                | Bottom right corner of slides                | `medium`\>`small`\>`large`    |
+---------------------------+----------------------------------------------+-------------------------------+
| `website`/`book` project  | `favicon` shown in browser tab               | `small`                       |
+---------------------------+----------------------------------------------+-------------------------------+

You can also specify named logos under `images` which you can reference in `small`, `medium` and `large`. In particular, this allows you to set alternative text for your logos using `alt`:

``` {.yaml filename="_brand.yml"}
logo: 
  images:
    quarto-logo: 
      path: https://quarto.org/quarto.png
      alt: "Quarto icon"
  small: quarto-logo
```

::: {.callout-warning}

## Limitation

The **brand.yml** specification allows you to specify a `light` and `dark` version of your logo, but Quarto currently only uses the `light` version.

::: 

#### Document logo customization

You can further customize the logo at the document level with the `logo` option.

For example, you can specify a particular brand logo resource:
```{.yaml filename="document.qmd"}
---
logo: large
---
```

Or, specify a brand logo and change the alt text:

```{.yaml filename="document.qmd"}
---
logo:
  path: large
  alt: Alternate alternate text
---
```

::: {.callout-warning}

## Limitation

It is [not currently possible](https://github.com/quarto-dev/quarto-cli/issues/11309) to customize the logo for a specific page within a website. Only the project's `_brand.yml` is applied.

::: 

The Typst implementation allows customization of the logo position at the document level:

```{.yaml filename="document.qmd"}
---
format:
  typst:
    logo:
      width: 1in
      location: right-top
      padding-right: 0.5in
      padding-top: 0.25in
      alt: Alternate alternate text
---
```

+--------------------------+------------------------------------------------------------------------------------------------------------------------------------------------+
| Option                   | Description                                                                                                                                    |
+==========================+================================================================================================================================================+
| `width`                  | Width in CSS units. Default `1.5in`.                                                                                                           |    
+--------------------------+------------------------------------------------------------------------------------------------------------------------------------------------+
| `location`               | Location on the page in `X-Y`, where `X` is `left`, `center`, or `right` and Y is `top`, `middle`, or `bottom`.                                |
|                          | Applied as Typst [`align`](https://typst.app/docs/reference/layout/align/).                                                                    |
+--------------------------+------------------------------------------------------------------------------------------------------------------------------------------------+
| `padding`, `padding-top`,| Amount of padding to add to each side of the logo, using CSS [`padding`](https://developer.mozilla.org/en-US/docs/Web/CSS/padding) conventions.| 
| `padding-right`,         | Padding options are applied in alphabetical order.                                                                                             |
| `padding-bottom`,        | Applied as Typst [`block.inset`](https://typst.app/docs/reference/layout/block/#parameters-inset).                                             |
| `padding-left`           | Default `padding: 0.75in`.                                                                                                                     |
+--------------------------+------------------------------------------------------------------------------------------------------------------------------------------------+


### Typography

[Typography in the **brand.yml** docs](https://posit-dev.github.io/brand-yml/brand/typography.html){.external}

The `typography` element allows you to specify fonts and their style. Use `fonts` to specify a list of fonts to use for your brand:

``` {.yaml filename="_brand.yml"}
typography:
  fonts:
    - family: Jura
      source: google
```

The properties you can set for a font under `fonts` depends on the `source`. You can see the other properties available in our [Reference for Brand](/docs/reference/metadata/brand.qmd#font-resource-definitions).


::: {.callout-warning}
## Limitation

HTML formats do not currently support `source: file`.
:::


You can then refer to fonts by `family` in the remaining typography options:

``` {.yaml filename="_brand.yml"}
typography:
  fonts:
    - family: Jura
      source: google
  base: Jura
  headings: Jura
```

The options `base` and `headings` set the typographic style of the main text and headings respectively. 
Use `links` to apply specific styles to links.
The option `monospace` sets the typographic style of code in general, and `monospace-inline` and `monospace-block` can be further used to style code that appears inline and in blocks respectively:

``` {.yaml filename="_brand.yml"}
typography:
  fonts:
    - family: Jura
      source: google
    - family: Space Mono
      source: google
  base: Jura
  headings: Jura
  link:
    decoration: underline
  monospace: Space Mono
  monospace-inline:
    color: "#222222"
    background-color: "#ddeaf1" # or use a named color from `color`
  monospace-block: 
    background-color: "#eef4f8"
```



The fields allowed for each element differ, expand the callout below to see what is supported in each field.

::: {.callout-tip collapse="true"}

## Full set of text elements and supported fields.

The full set of text elements that you can style with `typography` is:

+--------------------+--------------------------------------------------------------------------------------------------------+------------------------+
| Attribute          | Description                                                                                            | Supported Fields       |
+====================+========================================================================================================+========================+
| `base`             | Default text, primarily used in the document body.                                                     | -   `family`           |
|                    |                                                                                                        | -   `size`             |
|                    |                                                                                                        | -   `line-height`      |
|                    |                                                                                                        | -   `weight`           |
+--------------------+--------------------------------------------------------------------------------------------------------+------------------------+
| `headings`         | All heading levels (h1, h2, etc.).                                                                     | -   `family`           |
|                    |                                                                                                        | -   `weight`           |
|                    |                                                                                                        | -   `style`            |
|                    |                                                                                                        | -   `line-height`      |
|                    |                                                                                                        | -   `color`            |
+--------------------+--------------------------------------------------------------------------------------------------------+------------------------+
| `monospace`        | General monospaced text, typically used in code blocks and other programming-related content.          | -   `family`           |
|                    |                                                                                                        | -   `size`             |
|                    |                                                                                                        | -   `weight`           |
+--------------------+--------------------------------------------------------------------------------------------------------+------------------------+
| `monospace-inline` | Inline monospaced text, usually used for code snippets within regular text. Inherits from `monospace`. | -   `family`           |
|                    |                                                                                                        | -   `size`             |
|                    |                                                                                                        | -   `weight`           |
|                    |                                                                                                        | -   `color`            |
|                    |                                                                                                        | -   `background-color` |
+--------------------+--------------------------------------------------------------------------------------------------------+------------------------+
| `monospace-block`  | Block (multi-line) monospaced text, typically used for code blocks. Inherits from `monospace`.         | -   `family`           |
|                    |                                                                                                        | -   `size`             |
|                    |                                                                                                        | -   `weight`           |
|                    |                                                                                                        | -   `line-height`      |
|                    |                                                                                                        | -   `color`            |
|                    |                                                                                                        | -   `background-color` |
+--------------------+--------------------------------------------------------------------------------------------------------+------------------------+
| `link`             | Hyperlinks.                                                                                            | -   `weight`           |
|                    |                                                                                                        | -   `color`            |
|                    |                                                                                                        | -   `background-color` |
|                    |                                                                                                        | -   `decoration`       |
+--------------------+--------------------------------------------------------------------------------------------------------+------------------------+

The supported fields are generally described as follows:

-   `family`: The font family to be used for a typographic element. This should match a font resource declared in `typography.fonts`.

-   `size`: The font size for a typographic element. Should be specified using a CSS length unit (e.g., "14px", "1em", "0.9rem").

-   `weight`: The font weight (or boldness) of the text. Can be a numeric value between 100 and 900, or a string like "normal" or "bold".

-   `style`: The font style for the text, typically either "normal" or "italic".

-   `line-height`: The line height of the text, which refers to the vertical space between lines. Often expressed as a multiple of the font size or in fixed units.

-   `color`: The color of the text. Can be any CSS-compatible color definition or a reference to a color defined in the brand's color palette.

-   `background-color`: The background color for the text element. Can be any CSS-compatible color definition or a reference to a color defined in the brand's color palette.

-   `decoration`: The text decoration, typically used for links. Common values include "underline", "none", or "overline".

::: 

#### Typst

See [the Advanced documentation](/docs/advanced/typst/brand-yaml.qmd#typography) for more details on the Typst implementation, and troubleshooting tips for fonts.


### Defaults

[Defaults in the **brand.yml** docs](https://posit-dev.github.io/brand-yml/brand/defaults.html){.external}

The `defaults` section of **brand.yml** allows users to set options for specific tools that don't otherwise fit into the **brand.yml** schema. Quarto's implementation currently supports `defaults: bootstrap`.

#### Bootstrap

The `bootstrap` section of `defaults` follows [**brand.yml**](https://posit-dev.github.io/brand-yml/brand/defaults.html) and applies to the `html` and `dashboard` formats.
Quarto merges the options set under `defaults: bootstrap` in the appropriate layer of [Quarto's SCSS layering system](/docs/output-formats/html-themes-more.qmd).

The `defaults` option inside `bootstrap`, can take a string, or key-value pairs
corresponding to SCSS variable name-value pairs.
Building on our initial example, you could use `bootstrap: defaults` to set the SCSS variables `link-decoration` and `navbar-fg`:

``` {.yaml filename="_brand.yml"}
defaults:
  bootstrap:
    defaults: # defaults also supports a string as its value
      link-decoration: underline
      navbar-fg: "#fff"
```

The resulting HTML pages will have links that are underlined and use white for text in the navigation bar.

::::::: {.column-body-outset-right layout-ncol="2"}
::: {}
![Without `defaults: bootstrap` setting](/docs/authoring/images/brand-html-no-defaults.png){.lightbox group="brand-bootstrap-defaults" fig-alt="Screenshot of a webpage. The text is dark grey on a light blue background, using a rounded sans-serif typeface, a logo appears in the navbar."}
:::

::: {}
![With `defaults: bootstrap` setting: note the link decoration and the white color for the navbar text](/docs/authoring/images/brand-html-defaults.png){.lightbox group="brand-bootstrap-defaults" fig-alt="Screenshot of a webpage. It looks identical to the previous image, except for underlined links and white text on the navbar."}
:::
:::::::

In addition to the `defaults` option, Quarto supports `uses`, `functions`, `mixins` and `rules`, which all take a string value. 
For example, you could use `rules` to provide a CSS rule to remove the border below second-level headings:

```{.yaml filename="_brand.yml"}
defaults:
  bootstrap:
    # uses: <string>
    # functions: <string>
    # mixins: <string>
    rules: |
      h2 {
        border: none;
      }
```

### Meta

[Meta in the **brand.yml** docs](https://posit-dev.github.io/brand-yml/brand/meta.html){.external}

You can set brand metadata using the `meta` key:

``` {.yaml filename="_brand.yml"}
meta:
  name: Acme Corporation
  link: https://www.acmecorp.com
```

::: {.callout-warning}

## Limitation

Quarto does nothing with `meta` values.

::: 


## Using `_brand.yml` values {#using-brand-values}

Beyond the automatic application of your brand file, you can also directly access `_brand.yml` values in Quarto documents. In this section, you'll learn how to use the `brand` shortcode, use brand variables in SCSS files, and some format-specific ways to use access brand values.

### Shortcode - `{{{< brand >}}}`

Some values from the `_brand.yml` configuration file can be accessed via the `brand` shortcode. In particular, you can access colors and logos by name:

-   Use `{{{< brand color COLOR_NAME BRAND_MODE >}}}` to return the brand color named `COLOR_NAME` as a string.
-   Use `{{{< brand logo LOGO_NAME BRAND_MODE >}}}` to return the brand logo named `LOGO_NAME` as an image.

The `BRAND_MODE` is optional and defaults to `light`. To return the color from the [dark brand](#dark-brand) use `dark`.

For example, you could use the shortcode to place a brand image you've named `icon` in a dashboard sidebar:

````{.markdown filename="dashboard.qmd" shortcodes="false"}
---
format: dashboard
---

## Inputs {.sidebar}

{{< brand logo icon >}}

````

Or, you could use the shortcode to set the background of a revealjs slide to your `primary` brand color:

````{.markdown filename="slides.qmd" shortcodes="false"}
---
format: revealjs
---

## Slide Title {background-color='{{< brand color primary >}}'}
````


::: {.callout-warning}
## Limitation

You can't currently access `typography`, `meta`, or `defaults` values using the `brand` shortcode.
:::

### In SCSS

The colors defined in `palette` are set as SCSS variables of the form `brand-COLOR_NAME`. 
For example, if `_brand.yml` defines `blue`:

```{.yaml filename="_brand.yml"}
color:
  palette:
    blue: "#ddeaf1"
```

Then the variable `$brand-blue` is will be set to `#ddeaf1` in the `defaults` layer of  [Quarto's SCSS layering system](/docs/output-formats/html-themes-more.html#bootstrap-bootswatch-layering). 
You can add a custom SCSS file, `styles.scss`, in the usual way:
```{.yaml filename="_quarto.yml"}
format:
  html:
    theme: [styles.scss]
```

Then `styles.scss` can use these brand variables to make style tweaks. 
For example, you might want all `h1` elements to be `blue`:

```{.scss filename="styles.scss"}
/*-- scss:rules --*/

h1 {
  color: $brand-blue;
}
```

When you specify SCSS files without an explicit `brand` element, it is equivalent to listing them after `brand`.
For instance, the above `theme` is equivalent to:

```{.yaml filename="_quarto.yml"}
format:
  html:
    theme: [brand, styles.scss]
```

The order of elements in `theme` controls their priority. 
For example, you could layer brand and your custom SCSS on top of a built-in theme:

```{.yaml filename="_quarto.yml"}
format:
  html:
    theme: [cosmo, brand, styles.scss]
```

You can learn more about layering themes in [More About Quarto Themes](/docs/output-formats/html-themes-more.qmd).

### Typst

In Typst documents, brand colors are set in a [dictionary](https://typst.app/docs/reference/foundations/dictionary/) called `brand-color`. 
You can access them directory in raw Typst blocks using the syntax `brand-color.COLOR_NAME`.
For example, you could make a rectangle filled with your `primary` brand color:

````{.markdown filename="document.qmd"}

```{=typst}
#rect(fill: brand-color.primary)
```
````

### Lua API

Filters and shortcodes can access brand values using the `brand` Lua module.

``` lua
local brand = require('modules/brand/brand')
local primary = brand.get_color('primary')
```

## Migrating to `_brand.yml`: use the `brand` string in `theme`

::: callout-note

The following information is only necessary if you are migrating projects created with Quarto 1.5 and earlier to use `_brand.yml`.

:::

Migrating existing projects to Quarto 1.6's `_brand.yml` support is a straightforward process.
The usual way to create themes in Quarto 1.5 and earlier is to use one of the predefined bootswatch themes.
This is often combined with an additional user-defined `.scss` file.
In Quarto 1.5, a `_quarto.yml` file usually has an entry like the following:

```yaml
# Quarto 1.5 syntax
theme:
  - cosmo       # a predefined bootswatch theme
  - tweaks.scss # a user-defined customization
```

When using this syntax with Quarto 1.6's `_brand.yml` support, keep in mind that `_brand.yml` always takes _lowest_ priority in styles.
In other words, the configuration above is equivalent to the following:

```yaml
# Quarto 1.6 syntax
theme:
  - brand        # theming derived from `_brand.yml`
  - cosmo        # a predefined bootswatch theme
  - tweaks.scss  # a user-defined customization
```

As a result, values set by `brand` here are potentially overriden by the `cosmo` theme or by `tweaks.scss`.
This is sometimes useful, but often you will want to make `brand` _more_ important than the theme.
For these situations, use the following:

```yaml
# Quarto 1.6 syntax
theme:
  - cosmo        # a predefined bootswatch theme
  - brand        # theming derived from `_brand.yml`
  - tweaks.scss  # a user-defined customization
```

The analogous syntax also works for combining light and dark brands with light and dark themes:

```yaml
# Quarto 1.7 syntax
theme:
  light:
    - cosmo
    - brand
  dark:
    - slate
    - brand
```

Learn more about how Quarto generates styles in [More About Quarto Themes](/docs/output-formats/html-themes-more.qmd).
```````

## File: docs/authoring/callouts.qmd
```````
---
title: Callout Blocks
format: html
---

Callouts are an excellent way to draw extra attention to certain concepts, or to more clearly indicate that certain content is supplemental or applicable to only some scenarios.

## Callout Types

There are five different types of callouts available.

-   `note`
-   `warning`
-   `important`
-   `tip`
-   `caution`

The color and icon will be different depending upon the type that you select. Here are what the various types look like in HTML output:

::: callout-note
Note that there are five types of callouts, including: `note`, `tip`, `warning`, `caution`, and `important`.
:::

::: callout-warning
Callouts provide a simple way to attract attention, for example, to this warning.
:::

::: callout-important
## This is Important

Danger, callouts will really improve your writing.
:::

::: callout-tip
## Tip With Title

This is an example of a callout with a title.
:::

::: {.callout-caution collapse="true"}
## Expand To Learn About Collapse

This is an example of a 'collapsed' caution callout that can be expanded by the user. You can use `collapse="true"` to collapse it by default or `collapse="false"` to make a collapsible callout that is expanded by default.
:::

This feature is not available for Revealjs presentations yet (See Issue [1328](https://github.com/quarto-dev/quarto-cli/issues/1328))

## Markdown Syntax

Create callouts in markdown using the following syntax (note that the first markdown heading used within the callout is used as the callout heading):

``` markdown
::: {.callout-note}
Note that there are five types of callouts, including:
`note`, `warning`, `important`, `tip`, and `caution`.
:::

::: {.callout-tip}
## Tip with Title

This is an example of a callout with a title.
:::

::: {.callout-caution collapse="true"}
## Expand To Learn About Collapse

This is an example of a 'folded' caution callout that can be expanded by the user. You can use `collapse="true"` to collapse it by default or `collapse="false"` to make a collapsible callout that is expanded by default.
:::
```

Note that above callout titles are defined by using a heading at the top of the callout. If you prefer, you can also specify the title using the `title` attribute. For example:

```markdown
::: {.callout-tip title="Tip with Title"}
This is a callout with a title.
:::
```

## Customizing Appearance

### Collapse

You can create 'folded' callouts that can be expanded by the user by settings the `collapse` attribute on the callout. If you set `collapse=true`, the callout will be expandable, but will be collapsed by default. If you set `collapse=false`, the callout will be expandable, but will be expanded by default.

### Appearance

Callouts have 3 different looks you can use.

|           |                                                                                                                 |
|-----------|-----------------------------------------------------------------------------------------------------------------|
| `default` | The default appearance with colored header and an icon.                                                         |
| `simple`  | A lighter weight appearance that doesn't include a colored header background.                                   |
| `minimal` | A minimal treatment that applies borders to the callout, but doesn't include a header background color or icon. |

You can set the callout appearance either globally in the document (or project yaml):

``` yaml
callout-appearance: simple
```

or by setting the `appearance` attribute on the callout. For example

``` markdown
::: {.callout-note appearance="simple"}

## Pay Attention

Using callouts is an effective way to highlight content that your reader give special consideration or attention.

:::
```

which appears as:

::: {.callout-note appearance="simple"}
## Pay Attention

Using callouts is an effective way to highlight content that your reader give special consideration or attention.
:::

### Icons

In addition to controlling the appearance of the callout, you can also choose to directly suppress the icon by setting the global option in your document (or project) yaml:

``` yaml
callout-icon: false
```

or by setting an attribute directly on the callout:

``` markdown
::: {.callout-note icon=false}

## Pay Attention

Using callouts is an effective way to highlight content that your reader give special consideration or attention.

:::
```

Which will appear as:

::: {.callout-note icon="false"}
## Pay Attention

Using callouts is an effective way to highlight content that your reader give special consideration or attention.
:::

## Format Support

The following formats render callouts as illustrated above:

-   HTML
-   PDF
-   MS Word
-   EPUB
-   Revealjs (without collapse option)

Note that callout rendering for HTML is not available when you disable the standard HTML theme (e.g. if you specify the `theme: none` option). Also, some features are specific to document using Bootstrap, like collapsible callouts, and won't work in other documents.

When the target format doesn't support callouts, they are rendered as a simple blockquote with the title in bold.

## Cross-References

{{< include _cross-references-callouts.qmd >}}

Cross-referencing callouts is currently only supported for HTML, PDF and MS Word.
```````

## File: docs/authoring/citations.qmd
```````
---
title: Citations
format: html
link-citations: true
aliases: 
  - /docs/authoring/footnotes-and-citations.html
---

## Overview {#citations}

Quarto will use Pandoc to automatically generate citations and a bibliography in a number of styles. To use this capability, you will need:

-   A quarto document formatted with citations (see [Citation Markdown](#sec-citations)).

-   A bibliographic data source, for example a BibLaTeX (`.bib`) or BibTeX (`.bibtex`) file.

-   Optionally, a `CSL` file which specifies the formatting to use when generating the citations and bibliography (when not using `natbib` or `biblatex` to generate the bibliography).

::: {.callout-note}

When using `format: typst`, by default citation processing is handled by Typst, not Pandoc. See the [Typst](#typst) section below for more details.

::: 

## Bibliography Files

Quarto supports bibliography files in a wide variety of formats including BibLaTeX and CSL. Add a bibliography to your document using the `bibliography` YAML metadata field. For example:

``` yaml
---
title: "My Document"
bibliography: references.bib
---
```

::: callout-tip
You can provide more than one bibliography file if you would like by setting the `bibliography` field's value to a YAML array.
:::

See the [Pandoc Citations](https://pandoc.org/MANUAL.html#citations) documentation for additional information on bibliography formats.

## Citation Syntax {#sec-citations}

Quarto uses the standard Pandoc markdown representation for citations (e.g. `[@citation]`) --- citations go inside square brackets and are separated by semicolons. Each citation must have a key, composed of '\@' + the citation identifier from the database, and may optionally have a prefix, a locator, and a suffix. The citation key must begin with a letter, digit, or `_`, and may contain alphanumerics, `_`, and internal punctuation characters (`:.#$%&-+?<>~/`). Here are some examples:

+-------------------------------------------+---------------------------------------------------------------------+---------------------------------------------------------------------+
| Markdown Format                           | Output (default)                                                    | Output(`csl: diabetologia.csl`, see @sec-citations-style)           |
+===========================================+=====================================================================+=====================================================================+
|     Blah Blah [see @knuth1984, pp. 33-35; | Blah Blah [see @knuth1984, pp. 33-35; also @wickham2015, chap. 1]   | Blah Blah see [1], pp. 33-35; also [1], chap. 1                     |
|     also @wickham2015, chap. 1]           |                                                                     |                                                                     |
+-------------------------------------------+---------------------------------------------------------------------+---------------------------------------------------------------------+
|     Blah Blah [@knuth1984, pp. 33-35,     | Blah Blah [@knuth1984, pp. 33-35, 38-39 and passim]                 | Blah Blah [1], pp. 33-35, 38-39 and passim                          |
|     38-39 and passim]                     |                                                                     |                                                                     |
+-------------------------------------------+---------------------------------------------------------------------+---------------------------------------------------------------------+
|     Blah Blah [@wickham2015; @knuth1984]. | Blah Blah [@wickham2015; @knuth1984].                               | Blah Blah [1, 2].                                                   |
+-------------------------------------------+---------------------------------------------------------------------+---------------------------------------------------------------------+
|     Wickham says blah [-@wickham2015]     | Wickham says blah [-@wickham2015]                                   | Wickham says blah [1]                                               |
+-------------------------------------------+---------------------------------------------------------------------+---------------------------------------------------------------------+

You can also write in-text citations, as follows:

+-----------------------------------+-------------------------------+-------------------------------+
| Markdown Format                   | Output (author-date format)   | Output (numerical format)     |
+===================================+===============================+===============================+
|     @knuth1984 says blah.         | @knuth1984 says blah.         | [1] says blah.                |
+-----------------------------------+-------------------------------+-------------------------------+
|     @knuth1984 [p. 33] says blah. | @knuth1984 [p. 33] says blah. | [1] [p. 33] says blah.        |
+-----------------------------------+-------------------------------+-------------------------------+

See the [Pandoc Citations](https://pandoc.org/MANUAL.html#citations) documentation for additional information on citation syntax.

## Citation Style  {#sec-citations-style}


Quarto uses Pandoc to format citations and bibliographies. By default, Pandoc will use the [Chicago Manual of Style](https://chicagomanualofstyle.org/) author-date format, but you can specify a custom formatting using CSL ([Citation Style Language](https://citationstyles.org)). To provide a custom citation stylesheet, provide a path to a CSL file using the `csl` metadata field in your document, for example:

``` yaml
---
title: "My Document"
bibliography: references.bib
csl: nature.csl
---
```

You can find CSL files or learn more about using styles at the [CSL Project](https://github.com/citation-style-language/styles). You can browse the list of more than 8,500 Creative Commons CSL definitions in the CSL Project's [central repository](https://github.com/citation-style-language/styles) or Zotero's [style repository](https://www.zotero.org/styles).

`CSL` styling is only available when the `cite-method` is `citeproc` (which it is by default). If you are using another `cite-method`, you can control the formatting of the references using the mechanism provided by that method.

## Bibliography Generation

By default, Pandoc will automatically generate a list of works cited and place it in the document if the style calls for it. It will be placed in a div with the id `refs` if one exists:

``` markdown
### References

::: {#refs}
:::
```

If no such div is found, the works cited list will be placed at the end of the document. 

::: callout-tip
You can suppress generation of a bibliography by including `suppress-bibliography: true` option in your document metadata
:::

Here's an example of a generated bibliography:

::: {#refs}
:::

## Including Uncited Items

If you want to include items in the bibliography without actually citing them in the body text, you can define a dummy `nocite` metadata field and put the citations there:

```markdown
---
nocite: |
  @item1, @item2
---

@item3
```

In this example, the document will contain a citation for `item3` only, but the bibliography will contain entries for `item1`, `item2`, and `item3`.

It is possible to create a bibliography with all the citations, whether or not they appear in the document, by using a wildcard:

```markdown
---
nocite: |
  @*
---
```

## LaTeX: using BibLaTeX or natbib {#sec-biblatex}

{{< include ../output-formats/_pdf-citations.md >}} 

## Typst 

{{< include ../output-formats/_typst-citations.md >}}
```````

## File: docs/authoring/code-annotation.qmd
```````
---
title: Code Annotation
code-annotations: below
aliases:
  - /docs/prerelease/1.3/code-annotation.html
---

{{< include ../_require-1.3.qmd >}}

## Overview

Code blocks and executable code cells in Quarto can include line-based annotations. Line-based annotations provide a way to attach explanation to lines of code much like footnotes. 

For example, this code uses annotation to describe the steps in an R dplyr pipeline in plain language:

```r
library(tidyverse)
library(palmerpenguins)
penguins |>                                            # <1>
  mutate(                                              # <2>
    bill_ratio = bill_depth_mm / bill_length_mm,       # <2>
    bill_area  = bill_depth_mm * bill_length_mm        # <2>
  )                                                    # <2>
```
1. Take `penguins`, and then,
2. add new columns for the bill ratio and bill area.

The default HTML annotation style displays annotations in a list below the code block. Clicking on the annotation number in the list highlights the relevant lines in the code. Other [HTML styles](#html-styles) hide the annotations, revealing them in a tooltip when a user hovers or selects a marker, as illustrated in this example of a Revealjs presentation:

```{.yaml code-preview="code-annotation-example/revealjs.qmd"}
format: revealjs
```

The PDF format also allows for annotations, numbering, and displaying the annotation text below the code. In other formats, like Word and GitHub Markdown, annotations are instead labeled with the line of code (or lines of code) to which the annotation text applies.

::: panel-tabset
#### PDF

![](images/annote-pdf.png){fig-alt="Screenshot of output in PDF format showing code annotation."}

#### GitHub Flavored Markdown

````markdown
``` r
library(tidyverse)
library(palmerpenguins)
penguins |>
  mutate(
    bill_ratio = bill_depth_mm / bill_length_mm,
    bill_area  = bill_depth_mm * bill_length_mm
  )
```

Line 3  
Take `penguins`, and then,

Lines 4-7  
add new columns for the bill ratio and bill area.
````
:::


To add code annotation to a code block, you need to add two things: specially formatted code comments in your code cell, and an ordered list below the code cell with the annotation text. Read more in [Annotation Syntax](#annotation-syntax).

The `code-annotations` option controls how annotations appear in the HTML format (`below` (default), `hover` or `select`), and in all formats, whether annotation is disabled (`false`), or if annotations should be removed from the output (`none`).

## Annotation Syntax {#annotation-syntax}

Annotations for a code cell consist of two related elements:

1.  Each annotated line should be terminated with a comment (using the code cell's language comment character) followed by a space and then an annotation number enclosed in angle brackets (e.g. `# <2>`). You may repeat an annotation number if the annotation spans multiple lines.

2.  An ordered list that appears immediately after the code cell which includes the contents of each annotation. Each numbered item in the ordered list will correspond to the line(s) of code with the same annotation number.

For example, the annotations in the overview were produced with the following:

```` markdown
```r
library(tidyverse)
library(palmerpenguins)
penguins |>                                      # <1>
  mutate(                                        # <2>
    bill_ratio = bill_depth_mm / bill_length_mm, # <2>
    bill_area  = bill_depth_mm * bill_length_mm  # <2>
  )                                              # <2>
```
1. Take `penguins`, and then,
2. add new columns for the bill ratio and bill area.
````

## Annotation Style {#html-styles}

For HTML output, there are three annotation styles you can set with the `code-annotations` document option:

`below`

:   By default (or if `code-annotations: below` is specified), code annotation text will appear below the code cell.

`hover`

:   Code annotation text will be displayed when the user hovers over the annotation marker for a line of code. 

`select`

:   Code annotation text will be displayed when the user clicks on an annotation marker (selecting it). The annotation text can be dismissed by clicking the annotation marker once again.

For example, to set the display style to hover, the complete Quarto file would be:

```` markdown
---
code-annotations: hover
---

```r
library(tidyverse)
library(palmerpenguins)
penguins |>                                      # <1>
  mutate(                                        # <2>
    bill_ratio = bill_depth_mm / bill_length_mm, # <2>
    bill_area  = bill_depth_mm * bill_length_mm  # <2>
  )                                              # <2>
```
1. Take `penguins`, and then,
2. add new columns for the bill ratio and bill area.
````

You can control the colors used to highlight lines in a custom theme with [Code Annotation Sass Variables](/docs/output-formats/html-themes.qmd#code-annotation).

## Removing Annotations

For some formats, you may prefer to remove annotations from the output. In this case, you can set `code-annotations: none`, which will remove the annotation comments from your code and suppress the output of the ordered list which contains the annotation text.

## Disabling Annotation

You can disable code annotation by including the option `code-annotations: false` in your document. This will stop the processing of code annotations and leave your code (including the annotation comments) and the original ordered list as is.
```````

## File: docs/authoring/conditional.qmd
```````
---
title: "Conditional Content"
---

In some cases you may want to create content that only displays for a given output format (or only displays when *not* rendering to a format). You can accomplish this by creating divs, spans and code blocks with the `.content-visible` and `.content-hidden` classes.

## .content-visible

To make content visible only for a given format, you can create a div (`:::`) with the `.content-visible` class. For example, here we mark content as only visible in HTML:

``` markdown
::: {.content-visible when-format="html"}

Will only appear in HTML.

:::
```

You can also set conditions on non-executable code blocks:

```` markdown
```{.python .content-visible when-format="html"}
# code shown only in HTML
2+2
```
````

To apply a condition only to a part of a paragraph, use a span (`[]{}`):

``` markdown
Some text
[in HTML.]{.content-visible when-format="html"}
[in PDF.]{.content-visible when-format="pdf"}
```

You can also mark content as visible for all formats *except* a specified format. For example:

``` markdown
::: {.content-visible unless-format="pdf"}

Will not appear in PDF.

:::
```

Then `when-format` and `unless-format` attributes match the current Pandoc output format with some additional intelligence to alias related formats (e.g. html, html4, and html5). Details are provided below in [Format Matching](#format-matching)

`when-format` and `unless-format` can also be combined to create more complex conditions:

``` markdown
::: {.content-visible when-format="html" unless-format="revealjs"}

Will only appear in HTML and not in Reveal.js, but actually it appears.

:::

::: {.content-visible when-format="revealjs"}

Will only appear in Reveal.js and not in HTML or other formats.

:::
```

## .content-hidden

To prevent content from being displayed when rendering to a given format, use the `.content-hidden` class. For example, here we mark content as hidden in HTML:

``` markdown
::: {.content-hidden when-format="html"}

Will not appear in HTML.

:::
```

You can also mark content as hidden for all formats *except* a specified format. For example:

``` markdown
::: {.content-hidden unless-format="pdf"}

Will only appear in PDF.

:::
```

## Format Matching {#format-matching}

The `when-format` and `unless-format` clauses do some aliasing of related formats to make it more straightforward to target content. The following aliases are implemented:

{{< include _format-aliases.md >}}

## Matching against metadata

{{< include /docs/_require-1.4.qmd >}}

It's possible to match against boolean metadata values.
Use the attributes `unless-meta` and `when-meta`, and use periods `.` to separate metadata keys.
For example:

```` markdown
::: {.content-hidden unless-meta="path.to.metadata"}

This content will be hidden unless there exists a metadata entry like such:

```yml
path:
  to:
    metadata: true
```

:::
````

This feature is often useful alongside [project profiles](/docs/projects/profiles.qmd).
Different profiles can set different metadata values, and so can control the metadata used in conditional content.
```````

## File: docs/authoring/contents.qmd
```````
---
title: "`contents`: Rearrange content in your documents"
---

## Overview

Sometimes it's useful to define content in your document in an order that is different from
the order in which you want the document to be presented.
Although you can develop [Lua filters](/docs/extensions/filters.qmd) that solve this kind of problem, Quarto 1.6 and
later offers a simpler solution that works in many use cases: the `{{{< contents >}}}` shortcode.

Here's a minimal example of how it can be used:

````markdown
## A section

Here we define a plot.

```{{python}}
#| echo: false
#| label: a-cell
import matplotlib.pyplot as plt
plt.plot([1,2,3])
```

## Another section

Here we use the plot, inside a callout:

::: callout-note

## Note the following plot

{{{< contents a-cell >}}}

:::
````

The code above produces the following output:

![A screenshot of the resulting document](./images/use-cell-example.jpg)

## Why

`{{{< contents >}}}` increases your freedom in defining the document the most comfortable way you can.
It can simply be because you want to write the code in the middle of a different explanation, but you want the result to appear elsewhere.

One particularly important reason is that Jupyter notebooks do not allow code cells to "nest" inside Markdown. 
Many of Quarto's features are defined in terms of fenced divs, with Markdown that looks like this:

````markdown
::: {#div-id .class1 .class2 key1="value1"}

The contents of a fenced div

:::
````

In this case, authoring Quarto documents with `.ipynb` would otherwise be cumbersome. `{{{< contents >}}}` allows you to use the contents of a code cell inside a Markdown cell without having to split the Markdown in a way that Jupyter Notebook, Jupyter Lab, and Quarto's JupyterLab extensions don't know how to render.

## How it works

Quarto takes `{{{< contents <id> >}}}` shortcodes to mean "take the contents of cell with id `id` from the document and place it here instead". 

The most natural use case is for code cells, but `{{{< contents >}}}` also works with any document divs or spans, and uses the div and span ids.

::: callout-caution

The id of the following div is `a-div`, and _not_ `#a-div`.
As a result, refer to it in a `contents` shortcode as `{{{< contents a-div >}}}`.

```
::: {#a-div}

The contents of a fenced div

:::
```

:::

When using divs and spans with `{{{< contents >}}}`, make sure that you're moving them to appropriate locations.
Specifically, a div cannot be placed in the middle of a paragraph; that requires a span. As a result, you _cannot_ do the following:

````
```{{python}}
#| label: a-cell
print("some code")
```

The output of the code cell is {{{< contents a-cell >}}}. Etc.
````

If this is the style of organization you wish to use, you need to write the code inline, and wrap it in a span:

````markdown
We will define some values here. [`{python} "some code"`]{#a-span}

The output of that inline code cell is {{{< contents a-span >}}}. Etc.
````

## Limitations

Currently, `{{{< contents >}}}` itself does not work inside code elements. We may lift that limitation in the future.
```````

## File: docs/authoring/create-citeable-articles.qmd
```````
---
title: Creating Citeable Articles
---

You can make it easier for others to cite your work by providing additional metadata with the YAML front-matter of your article. Citations can be provided for both articles published to the web or for articles published in journals (with or without a DOI).

## Web Articles

To provide a citation for an article published to the web, include author and date metadata as well as a citation url. For example:

``` yaml
---
title: "Summarizing Output for Reproducible Documents"
description: | 
  A summary of the best practices for summarizing output of reproducible scientific documents.
date: 5/4/2018
author:
  - name: Norah Jones 
    url: https://example.com/norahjones
    affiliation: Spacely Sprockets
    affiliation-url: https://example.com/spacelysprockets
citation:
  url: https://example.com/summarizing-output
bibliography: biblio.bib
---
```
Name particles can be further defined in the `name` key following the [Citation Style Language (CSL) specification for naming particles](https://docs.citationstyles.org/en/stable/specification.html#name-particles). If you omit the citation url, Quarto will attempt to generate a citation url by using the `site-url` and the current page's location. If you'd like to allow Quarto to generate the citation url, you can omit the citation url and simply enable citation output on the page. For example:

``` yaml
---
title: "Summarizing Output for Reproducible Documents"
description: | 
  A summary of the best practices for summarizing output of reproducible scientific documents.
date: 5/4/2018
author:
  - name: Norah Jones 
    url: https://example.com/norahjones
    affiliation: Spacely Sprockets
    affiliation-url: https://example.com/spacelysprokets
citation: true
bibliography: biblio.bib
---
```

When this metadata is available, a citation appendix is automatically added to the article. The citation appendix will present both a copy-able `bibtex` representation of the document and a formatted representation of the citation (based upon the document's CSL file, if specified). For example:

![](images/appendix-citation.png){.border fig-alt="Appearance of a citation appendix contains both BibTeX citation and plain text citation for attribution."}

By default both the `bibtex` and formatted representations are displayed. You can use the `appendix-cite-as` option to control this behavior:

+-----------------------------+------------------------------------------------+
| `appendix-cite-as: false`   | Do not include any citations in the appendix.  |
+-----------------------------+------------------------------------------------+
| `appendix-cite-as: bibtex`  | Show only the BibTeX version of the citation.  |
+-----------------------------+------------------------------------------------+
| `appendix-cite-as: display` | Show only the display version of the citation. |
+-----------------------------+------------------------------------------------+

: {tbl-colwidths="\[50,50\]"}

## Journal Articles

If your article is published within a Journal, you can add the following the additional fields to generate the appropriate citation entry:

``` yaml
---
title: "Summarizing Output for Reproducible Documents"
description: | 
  A summary of the best practices for summarizing output of reproducible scientific documents.
date: 5/4/2018
author:
  - name: Norah Jones 
    url: https://example.com/norahjones
    affiliation: Spacely Sprockets
    affiliation-url: https://example.com/spacelysprokets
citation:
  type: article-journal
  container-title: "Journal of Data Science Software"
  doi: "10.23915/reprodocs.00010"
  url: https://example.com/summarizing-output
bibliography: biblio.bib
---
```

This is how the citation is presented in the appendix:

![](images/appendix-citation-journal.png){.border fig-alt="Appearance of a journal citation in document appendix with both BibTex and plain text citations given for attribution."}

## Other Types of Documents

The BibTeX and formatted attribution displayed in the document will be generated based upon the complete citation information that is present in the `citation` key, which is based upon the [Citation Style Language (CSL) specification for items](https://docs.citationstyles.org/en/stable/specification.html). You can learn more about the available options in the [Citation Metadata Reference](/docs/reference/metadata/citation.qmd).

## Google Scholar

Quarto documents can include metadata compatible with the format indexed by [Google Scholar](https://scholar.google.com). This makes it easy for indexing engines (Google Scholar or otherwise) to extract not only a citation for your article but also information on other sources which you cited. To enable this use the `google-scholar` option:

``` yaml
title: "Summarizing Output for Reproducible Documents"
description: | 
  A summary of the best practices for summarizing output of reproducible scientific documents.
date: 5/4/2018
author:
  - name: Norah Jones 
    url: https://example.com/norahjones
    affiliation: Spacely Sprockets
    affiliation-url: https://example.com/spacelysprokets
citation:
  type: article-journal
  container-title: "Journal of Data Science Software"
  doi: "10.23915/reprodocs.00010"
  url: https://example.com/summarizing-output
bibliography: biblio.bib 
google-scholar: true
```

For example, here is the Google Scholar metadata automatically included for a document created with the above metadata:

``` {.html style="font-size: 0.9em;"}
<meta name="citation_title" content="Summarizing Output for Reproducible Documents">
<meta name="citation_author" content="Norah Jones">
<meta name="citation_online_date" content="2018-05-04">
<meta name="citation_fulltext_html_url" content="https://example.com/summarizing-output">
<meta name="citation_publication_date" content="2018-05-04">
<meta name="citation_journal_title" content="Journal of Data Science Software">
<meta name="citation_reference" content="citation_title=Donald knuth;,citation_fulltext_html_url=http://dx.doi.org/10.7551/mitpress/
5485.003.0041;,citation_publication_date=1989;,citation_journal_title
=undefined;">
```

In the addition to the citation metadata from this document described above, Quarto will automatically generate a `citatation_reference` entry for each of the entries included in the document's bibliography.

## Citation Fields

Quarto's approach to emitting scholarly metadata is to take the standard CSL fields and make them into the corresponding Google Scholar / Zotero / Highwire metadata tags as appropriate. The following fields, when specified under the `citation` key of the document metadata, will generate scholarly meta tags in the rendered HTML document as described. These fields comprise the required Google Scholar fields as well as additional, optional fields that may also be included.

+-----------------------------------------------------------------------------------------------------------------------------------------------+-----------------------------------------------------------------------------------------+
| Document Yaml                                                                                                                                 | Metadata Tag                                                                            |
+===============================================================================================================================================+=========================================================================================+
| `title`\                                                                                                                                      | `citation_title`                                                                        |
| <sub>Document `title` will be used if not provided.</sub>                                                                                     |                                                                                         |
+-----------------------------------------------------------------------------------------------------------------------------------------------+-----------------------------------------------------------------------------------------+
| `author`\                                                                                                                                     | `citation_author`                                                                       |
| <sub>One or more authors[^1]. Document `author` will be used if not provided as a citation subkey.</sub>                                      |                                                                                         |
+-----------------------------------------------------------------------------------------------------------------------------------------------+-----------------------------------------------------------------------------------------+
| `editor`\                                                                                                                                     | `citation_editor`                                                                       |
| <sub>One or more editors[^2].</sub>                                                                                                           |                                                                                         |
+-----------------------------------------------------------------------------------------------------------------------------------------------+-----------------------------------------------------------------------------------------+
| `abstract`\                                                                                                                                   | `citation_abstract`                                                                     |
| <sub>Document `abstract` will be used if not provided.</sub>                                                                                  |                                                                                         |
+-----------------------------------------------------------------------------------------------------------------------------------------------+-----------------------------------------------------------------------------------------+
| `keyword`[^3]\                                                                                                                                | `citation_keywords`                                                                     |
| <sub>Document `keywords` will be used if not provided.</sub>                                                                                  |                                                                                         |
+-----------------------------------------------------------------------------------------------------------------------------------------------+-----------------------------------------------------------------------------------------+
| `issued`\                                                                                                                                     | `citation_publication_date`                                                             |
| <sub>Document `date` will be used if not provided.</sub>                                                                                      |                                                                                         |
|                                                                                                                                               | <sub>In addition, the issued date will be used to populate the following fields:</sub>\ |
|                                                                                                                                               | \                                                                                       |
|                                                                                                                                               | `citation_cover_date`\                                                                  |
|                                                                                                                                               | `citation_year`                                                                         |
+-----------------------------------------------------------------------------------------------------------------------------------------------+-----------------------------------------------------------------------------------------+
| `available-date`\                                                                                                                             | `citation_online_date`                                                                  |
| <sub>Document `date` will be used if not provided.</sub>                                                                                      |                                                                                         |
+-----------------------------------------------------------------------------------------------------------------------------------------------+-----------------------------------------------------------------------------------------+
| `url`\                                                                                                                                        | `citation_fulltext_html_url`                                                            |
| <sub>`url` will be synthesized for current document if a [`site-url`](/docs/websites/website-tools.qmd#preview-images) has been specified.</sub> |                                                                                         |
+-----------------------------------------------------------------------------------------------------------------------------------------------+-----------------------------------------------------------------------------------------+
| `pdf-url`                                                                                                                                     | `citation_pdf_url`                                                                      |
+-----------------------------------------------------------------------------------------------------------------------------------------------+-----------------------------------------------------------------------------------------+
| `language`\                                                                                                                                   | `citation_language`                                                                     |
| <sub>Document `lang` will be used if not provided.</sub>                                                                                      |                                                                                         |
+-----------------------------------------------------------------------------------------------------------------------------------------------+-----------------------------------------------------------------------------------------+
| `type`\                                                                                                                                       | `<none>`                                                                                |
| <sub>A valid CSL type. See <https://docs.citationstyles.org/en/stable/specification.html#appendix-iii-types></sub>.                           |                                                                                         |
+-----------------------------------------------------------------------------------------------------------------------------------------------+-----------------------------------------------------------------------------------------+
| `doi`\                                                                                                                                        | `citation_doi`                                                                          |
| <sub>Document `doi` will be used if not provided.</sub>                                                                                       |                                                                                         |
+-----------------------------------------------------------------------------------------------------------------------------------------------+-----------------------------------------------------------------------------------------+
| `isbn`                                                                                                                                        | `citation_isbn`                                                                         |
+-----------------------------------------------------------------------------------------------------------------------------------------------+-----------------------------------------------------------------------------------------+
| `issn`                                                                                                                                        | `citation_issn`                                                                         |
+-----------------------------------------------------------------------------------------------------------------------------------------------+-----------------------------------------------------------------------------------------+
| `eissn`                                                                                                                                       | `citation_eissn`                                                                        |
+-----------------------------------------------------------------------------------------------------------------------------------------------+-----------------------------------------------------------------------------------------+
| `pmid`                                                                                                                                        | `citation_pmid`                                                                         |
+-----------------------------------------------------------------------------------------------------------------------------------------------+-----------------------------------------------------------------------------------------+
| `issue`                                                                                                                                       | `citation_issue`                                                                        |
+-----------------------------------------------------------------------------------------------------------------------------------------------+-----------------------------------------------------------------------------------------+
| `volume`                                                                                                                                      | `citation_volume`                                                                       |
+-----------------------------------------------------------------------------------------------------------------------------------------------+-----------------------------------------------------------------------------------------+
| `page`\                                                                                                                                       | `citation_firstpage`                                                                    |
| <sub>Will be split on `-` to create appropriate page metadata.</sub>                                                                          |                                                                                         |
|                                                                                                                                               | `citation_lastpage`                                                                     |
+-----------------------------------------------------------------------------------------------------------------------------------------------+-----------------------------------------------------------------------------------------+
| `page-first`                                                                                                                                  | `citation_firstpage`                                                                    |
+-----------------------------------------------------------------------------------------------------------------------------------------------+-----------------------------------------------------------------------------------------+
| `page-last`                                                                                                                                   | `citation_lastpage`                                                                     |
+-----------------------------------------------------------------------------------------------------------------------------------------------+-----------------------------------------------------------------------------------------+
| `abstract-url`                                                                                                                                | `citation_abstract_html_url`                                                            |
+-----------------------------------------------------------------------------------------------------------------------------------------------+-----------------------------------------------------------------------------------------+
| `container-title`                                                                                                                             | `citation_journal_title`                                                                |
|                                                                                                                                               |                                                                                         |
|                                                                                                                                               | <small> For specific types, other meta tags will be produced:                           |
|                                                                                                                                               |                                                                                         |
|                                                                                                                                               | -   type: paper-conference\                                                             |
|                                                                                                                                               |     `citation_conference_title`                                                         |
|                                                                                                                                               |                                                                                         |
|                                                                                                                                               | -   type: book\                                                                         |
|                                                                                                                                               |     `citation_book_title`                                                               |
|                                                                                                                                               |                                                                                         |
|                                                                                                                                               | -   type: chapter\                                                                      |
|                                                                                                                                               |     `citation_inbook_title` </small>                                                    |
+-----------------------------------------------------------------------------------------------------------------------------------------------+-----------------------------------------------------------------------------------------+
| `number`                                                                                                                                      | `citation_technical_report_number`                                                      |
|                                                                                                                                               |                                                                                         |
|                                                                                                                                               | <sub>`citation_technical_report_number` will be created if the type is report.</sub>    |
+-----------------------------------------------------------------------------------------------------------------------------------------------+-----------------------------------------------------------------------------------------+
| `publisher`                                                                                                                                   | `citation_publisher`                                                                    |
|                                                                                                                                               |                                                                                         |
|                                                                                                                                               | <small>For specific types, other meta tags will be produced:                            |
|                                                                                                                                               |                                                                                         |
|                                                                                                                                               | -   type: paper-conference\                                                             |
|                                                                                                                                               |     `citation_conference`                                                               |
|                                                                                                                                               |                                                                                         |
|                                                                                                                                               | -   type: thesis\                                                                       |
|                                                                                                                                               |     `citation_dissertation_institution`                                                 |
|                                                                                                                                               |                                                                                         |
|                                                                                                                                               | -   type:report\                                                                        |
|                                                                                                                                               |     `citation_technical_report_institution`                                             |
|                                                                                                                                               |                                                                                         |
|                                                                                                                                               | </small>                                                                                |
+-----------------------------------------------------------------------------------------------------------------------------------------------+-----------------------------------------------------------------------------------------+
| `container-title-short`                                                                                                                       | `citation_journal_abbrev`                                                               |
+-----------------------------------------------------------------------------------------------------------------------------------------------+-----------------------------------------------------------------------------------------+
| `collection-title`                                                                                                                            | `citation_series_title`                                                                 |
+-----------------------------------------------------------------------------------------------------------------------------------------------+-----------------------------------------------------------------------------------------+

[^1]: Specify one or more authors using one of the following:

    ``` yaml
    author: Norah Jones
    ```

    or multiple values like:

    ``` yaml
    author:
    -   Norah Jones
    -   Nick Fury
    ```

    The list of authors provded under the citation key will be used instead of the document authors when generating the html metadata.

[^2]: Specify one or more editors using one of the following:

    ``` yaml
    editors: Norah Jones
    ```

    or multiple values like:

    ``` yaml
    editors:
    -   Norah Jones
    -   Nick Fury
    ```

[^3]: Note that the `keyword` citation field is a comma separated string of keywords (consistent with CSL).

For example, citation data for a published conference paper defined as such in the document front matter:

``` yaml
title: A Published Conference Paper
author:
  - name: Norah Jones
    affiliation: School of Hard Knocks
    orcid: 0000-0001-8715-9476
citation:
  type: paper-conference
  container-title: "Proceedings of the annual conference of the Society for Research"
  publisher: "Society for Research"
  issued: 2020/09/23
  volume: 2
  doi: "10.23915/reprodocs.00010"
  url: https://example.com/summarizing-output
  page-first: 46
  page-last: 53
  editor:
  - Don Draper
  - Nick Fury
google-scholar: true  
```

provides HTML metadata like:

``` html
<meta name="citation_title" content="A Published Conference Paper">
<meta name="citation_author" content="Norah Jones">
<meta name="citation_editor" content="Nick Cage">
<meta name="citation_editor" content="Don Draper">
<meta name="citation_publication_date" content="2020-09-23">
<meta name="citation_cover_date" content="2020-09-23">
<meta name="citation_year" content="2020">
<meta name="citation_fulltext_html_url" content="https://example.com/summarizing-output">
<meta name="citation_doi" content="10.23915/reprodocs.00010">
<meta name="citation_volume" content="2">
<meta name="citation_language" content="en">
<meta name="citation_conference_title" content="Proceedings of the annual conference of the Society for Research">
<meta name="citation_conference" content="Society for Research">
```
```````

## File: docs/authoring/cross-reference-options.qmd
```````
---
title: "Cross-Reference Options"
format: html
---

## Overview 

There are a wide variety of options available for customizing caption labels and references. These options are all specified within the `crossref` key of document metadata.

On this page we highlight some of the most useful, but you can find all available `crossref` options on the [Cross-Reference Options](/docs/reference/metadata/crossref.qmd) reference page.

::: {.callout-note appearance="simple"}
Note that since LaTeX does its own formatting and layout of figures and tables, not all of these options will apply when rendering to PDF. Specifically, delimiter options like `title-delim` and numbering options like `labels` don't work for PDF output. Additionally, formatting directives are not applied (e.g. italicizing the figure title) for LaTeX titles.
:::

## Titles

You can specify the title prefix used for captions using `*-title` options. You can also specify the delimiter used between the prefix and the caption using the `title-delim` option. For example:

``` yaml
---
title: "My Document"
crossref:
  fig-title: Fig     # (default is "Figure")
  tbl-title: Tbl     # (default is "Table")
  title-delim: "—"   # (default is ":")
---
```

## References {#references}

You can specify the prefix used for inline reference type using `*-prefix` options. You can also specify whether references should be hyper-linked using the `ref-hyperlink` option. For example:

``` yaml
---
title: "My Document"
crossref:
  fig-prefix: figure   # (default is "Figure")
  tbl-prefix: table    # (default is "Table")
  ref-hyperlink: false # (default is true)
---
```

## Numbering

There are a variety of numbering schemes available for cross-references, including:

-   `arabic` (1, 2, 3)

-   `roman` (I, II, III, IV)

-   `roman i` (i, ii, iii, iv)

-   `alpha x` (start from letter 'x')

-   `alpha X` (start from letter 'X')

You can specify the numbering scheme used for all types (other than sub-references) using the `labels` option. For sub-references (e.g. subfigures), you can specify the number scheme using the `subref-labels` option. For example:

``` yaml
---
title: "My Document"
crossref:
  labels: alpha a        # (default is arabic)
  subref-labels: roman i # (default is alpha a)
---
```

If you would like, you can specify the number scheme for a specific type using the `*-labels` options. For example:

``` yaml
---
title: "My Document"
crossref:
  fig-labels: alpha a    # (default is arabic)
  tbl-labels: alpha a    # (default is arabic)
  subref-labels: roman i # (default is alpha a)
---
```

If both `labels` and a type specific label option is provided, the type specific option will override the `labels` option.

## Chapter Numbering

You can use the `crossref: chapters` option to indicate that top-level headings (H1) in your document correspond to chapters, and that cross-references should be sub-numbered by chapter. For example:

``` markdown
---
title: "My Document"
author: "Jane Doe"
number-sections: true
crossref:
  chapters: true
---

# Introduction

![Elephant](elephant.png){#fig-elephant}

See @fig-elephant for an illustration.
```

![](images/crossref-chapters.png){fig-alt="A line drawing of an elephant. Above it is the text '1 Introduction' in large, bold font. The label 'Figure 1.1: Elephant' is centered underneath it. The text 'See fig. 1.1 for an illustration' is aligned to the left underneath that."}
```````

## File: docs/authoring/cross-references-custom.qmd
```````
---
title: Custom Float Cross-Reference Types
crossref:
  custom:
    - kind: float
      reference-prefix: Video
      key: vid
---

{{< include /docs/_require-1.4.qmd >}}

## Overview

Cross-referenceable [figures](#figures), [tables](#tables) and [code listings](#code-listings) are examples of *float* cross-references. Floats can appear in the rendered document at locations other than where they are defined, i.e. they float, and usually have captions. 

You can define custom float cross-reference types using the `custom` key to the `crossref` option either in your document or project metadata. At a minimum, a custom type needs:

- `kind`, which currently can only be `float`
- `key`, the abbreviation used in the reference identifier ("In `@fig-1`, ...")
- `reference-prefix`, used for the reference in output ("In Figure 1, ...")

For example, the following YAML defines a new cross-reference type for videos:

``` yaml
crossref:
  custom:
    - kind: float
      reference-prefix: Video
      key: vid
```

You can then use this new type with the [Cross-Reference Div Syntax](cross-references-divs.qmd) in a document:

``` {.markdown shortcodes="false"}
::: {#vid-cern}

{{< video https://www.youtube.com/embed/wo9vZccmqwc >}}

"CERN: The Journey of Discovery"

:::

In @vid-cern...
```

Which renders as:

::: {#vid-cern}
{{< video https://www.youtube.com/embed/wo9vZccmqwc >}}

"CERN: The Journey of Discovery"
:::

In @vid-cern...

There are some additional options that give you more control over the appearance of the cross-reference:

- `caption-prefix`, the text used to construct the caption title shown under the float ("Figure 1: ..."). If unspecified, Quarto will use the value of `reference-prefix`.

- `caption-location`, the position of the the caption. Options are: `top`, `bottom` (default) or `margin`.

- `space-before-numbering`, whether there is a space between the prefix and number. Set to `false` to omit the space (e.g. "Figure1").


You can find a complete listing of the options available for the `custom` key on the [Cross-Reference Options](/docs/reference/metadata/crossref.qmd#custom) reference page.

## PDF Output

If your output format is `pdf` you'll also need to specify `latex-env`, a name to be used for the float environment wrapped around the element in the intermediate TeX. For example, to use the custom video reference type you could add `latex-env: video`:

``` yaml
format: pdf
crossref:
  custom:
    - kind: float
      reference-prefix: Video
      key: vid
      latex-env: video
```

You can add a listing of your custom cross-references to your document by including a raw LaTeX `\listof` command. The name of the command is `listof` followed by the value of `latex-env`, followed by an `s`. For example, for the custom video type above, where the `latex-env` was `video`, the command is `\listofvideos{}`:

``` yaml
---
format: pdf
crossref:
  custom:
    - kind: float
      reference-prefix: Video
      key: vid
      latex-env: video
---

\listofvideos{}

```

By default, the title of the listing (e.g "List of Videos") is constructed from the `reference-prefix` value. You can specify something else with the `latex-list-of-description` value.

## Example: Supplemental Figures

As another example of a custom cross-reference type consider a document with supplemental figures. For instance, you might require: 

-   Supplemental figures have their own counter, distinct from that of figures.
-   Supplemental figures have labels that look like "Figure S1", "Figure S2" etc.
-   Supplemental figures appear in their own "List of Supplementary Figures" listing.

You could define this supplemental figure type with the following:

```yaml
crossref:
  custom:
    - kind: float
      key: suppfig
      latex-env: suppfig
      reference-prefix: Figure S
      space-before-numbering: false
      latex-list-of-description: Supplementary Figure
```

Note the use of `space-before-numbering: false`, which prevents a space between the `reference-prefix` or `caption-prefix` and the counter, so that labels will appear as "Figure S1", "Figure S2" etc.
```````

## File: docs/authoring/cross-references-divs.qmd
```````
---
title: Cross-Reference Div Syntax
---

{{< include /docs/_require-1.4.qmd >}}

## Overview

Cross-referenceable [figures](#figures), [tables](#tables) and [code listings](#listings) are known as *float* cross-references. Floats can appear in the rendered document at locations other than where they are defined, i.e. they float, and usually have captions. 

Along with compact syntax for the most common uses of cross-references, Quarto also provides a more general div syntax for declaring floats that can be cross-referenced. To declare a cross-referenceable float, place the content inside a fenced div with the reference identifier as an attribute. The last paragraph inside the fenced div will be treated as the caption. For example:

````{.markdown}
::: {#fig-example}

CONTENT

Caption

:::
````

To be recognized as a cross-reference the identifier must begin with one of the built-in float reference types (Figures (`fig-`), Tables (`tbl-`) and Listings (`lst-`)), or be defined as a [custom float cross-reference](cross-references-custom.qmd) type.

You can then refer to the element as usual with the `@` syntax, e.g. 

```markdown
@fig-example shows...
```

The content can be any Quarto markdown. For example, @fig-table is a markdown table treated like a figure:

````markdown
::: {#fig-table}

| A | B |
|---|---|
| C | D |

A table treated like a figure 

:::
````

::: {#fig-table .column-margin}

| A | B |
|---|---|
| C | D |

A table treated like a figure 

:::

@tbl-table is an image treated like a table:

````markdown
::: {#tbl-table}

![](table.png)

An image treated like a table

:::
````

::: {#tbl-table .column-margin}

![](images/crossref-div-table.png)

An image treated like a table

:::

@fig-code is a code cell treated like a figure:

````markdown
::: {#fig-code}

```r
library(tidyverse)
starwars |> 
  ggplot(aes(height, mass)) + 
  geom_point()
```

A code cell treated like a figure.

:::
````

::: {#fig-code .column-margin}

```r
library(tidyverse)
starwars |> 
  ggplot(aes(height, mass)) + 
  geom_point()
```

A code cell treated like a figure.

:::


On this page, we illustrate common use cases for [Figures](#figures), [Tables](#tables) and [Code Listings](#listings) then some applications of the div syntax to:

* [Cross-reference a video](#videos)
* [Cross-reference a diagram](#diagrams)
* [Produce subreferences to mixed content](#subreferences)
* [Use computed values in a caption](#computed-captions)

## Figures {#figures}

{{< include _cross-reference-divs-figure.qmd >}}

You can cross-reference a figure created by an executable code cell by including the code cell as the content:

````markdown
::: {#fig-line-plot}

```{{python}}
import matplotlib.pyplot as plt
plt.plot([1,23,2,4])
plt.show()
```

A line plot
:::
````

In the above example, you can reference the figure with `@fig-line-plot`, but not the code, which appears inline. If you would also like to be able to refer to the code, you can do so using code chunk options rather than the div syntax, see [Cross-References for Executable Code Blocks](cross-references.qmd#code-listings) for details.


## Tables

{{< include _cross-reference-divs-table.qmd >}}

If the table is produced by an executable code cell, put the cell inside the div as content, e.g:

````markdown
::: {#tbl-planets}

```{{python}}
from IPython.display import Markdown
from tabulate import tabulate
table = [["Sun","696,000",1.989e30],
         ["Earth","6,371",5.972e24],
         ["Moon","1,737",7.34e22],
         ["Mars","3,390",6.39e23]]
Markdown(tabulate(
  table, 
  headers=["Astronomical object","R (km)", "mass (kg)"]
))
```

Astronomical object

:::
````

In the above example, you can reference the table with `@tbl-planets`, but not the code, which appears inline. If you would also like to be able to refer to the code, you can do so using code chunk options rather than the div syntax, see [Cross-References for Executable Code Blocks](cross-references.qmd#code-listings) for details.

## Listings

{{< include _cross-reference-divs-listing.qmd >}}

This also works for executable code cells that produce no output:

````markdown
::: {#lst-assign}

```{{r}}
x <- 1
```

Assignment in R

:::
````

However, if any output is produced, it is assumed the output should be the content of the cross-reference, and the code is lifted out and placed inline. For example, the code cell here produces output:

````{.markdown}
::: {#lst-assign-output}

```{{r}}
x <- 1
x
```

Assignment in R

:::

@lst-assign-output

````

When rendered the above results in output being the contents of the listing, with the code appearing before the listing:

![](images/crossrefs-listing-output.png){fig-alt="Screenshot of a listing cross-reference. A code cell comes first, followed by Listing 1 which contains code output."}

If you need to reference both the code its output, use a combination of a display block and a code block with the code cell option `echo: false`:

````{.markdown}
::: {#lst-assign-both}

```r
x <- 1
x
```

```{{r}}
#| echo: false
x <- 1
x
```

Assignment in R

:::

````

When the output is a figure or table, you can reference the code and the output individually by using code cell options, rather than the div syntax, as described in [Cross-References for Executable Code Blocks](cross-references.qmd#code-listings).


## Diagrams

{{< include _cross-reference-divs-diagram.qmd >}}

## Videos 

{{< include _cross-reference-divs-video.qmd >}}

## Subreferences

::: callout-note

When your sub-content is either all figures or all tables there is abbreviated syntax, see the Cross References page for [Subfigures](cross-references.qmd#subfigures) and [Subtables](cross-references.qmd#subtables) for details.

:::

Cross-reference divs can be nested to create elements with subreferences. For example, the outer div here defines the `fig-subrefs` reference along with the main caption, while the inner divs define `fig-first` and `fig-second` along with their respective captions:

````markdown
:::: {#fig-subrefs}

::: {#fig-first}

CONTENT 1

First caption
:::

::: {#fig-second}

CONTENT 2

Second caption
:::

Main caption
::::
````

This renders as:

:::: {#fig-subrefs}

::: {#fig-first}

CONTENT 1

First caption
:::

::: {#fig-second}

CONTENT 2

Second caption
:::

Main caption
::::

Both the main element and the sub elements can be referenced directly in the text, e.g. 

```markdown
@fig-subrefs, @fig-first, @fig-second
```

This renders as: @fig-subrefs, @fig-first, @fig-second.

Combined with layout attributes, you can create complex layouts of mixed content where each element can be referenced. For example:

````markdown
:::: {#fig-complex layout="[[1, 1], [1]]"}

::: {#fig-elephant}

![](images/elephant.jpg)

An image file
:::

::: {#fig-scatterplot}

```{{r}}
#| echo: false
plot(1:10)
```

A computational figure
:::

::: {#fig-diagram}

```{dot}
//| fig-height: 2
digraph {
  rankdir = "LR";
  Transform -> Visualize
}
```

A diagram
:::

Example figure combining different types of content
::::
````

This renders as:

![](images/crossrefs-complex-layout.png){fig-alt="A screenshot of a figure layout with two rows. The top row has two columns: on the left an image of an elephant silhouetted against a sunset with the caption (a) An image file; on the right a scatterplot with the caption (b) A computational figure. In the bottom row is a flow chart with a node Transform linked to the node Visualize with the caption (c) A diagram. Below the layout is the caption: Figure 1: Example figure combining different types of content."}


## Computed Captions

If you want to include computed values in a caption, use the cross-reference div syntax, along with an [inline code expression](/docs/computations/execution-options.qmd#inline-code). For example:

:::: {.panel-tabset}

## Python


````markdown
::: {#fig-box}

```{{python}}
#| echo: false
import matplotlib.pyplot as plt

x = [1, 2, 3, 4, 5, 10]
p = plt.boxplot(x)
plt.show()
```

This dataset has `{python} len(x)` observations.

:::
````

## R

````markdown
::: {#fig-box}

```{{r}}
#| echo: false


x <- c(1, 2, 3, 4, 5, 10)
boxplot(x)

```

This dataset has `{r} length(x)` observations.

:::
````

::::

## Conditional Content

The cross-reference div syntax combined with [conditional content](/docs/authoring/conditional.qmd) allows the content of your reference to vary by format. For example, you might want an interactive JavaScript based plot when the format is HTML, but otherwise produce a static plot:


````markdown

::: {#fig-scatterplot}  
  
:::: {.content-visible when-format="html"}

```{{r}}
# Code to produce JavaScript based plot
```
::::

:::: {.content-visible unless-format="html"}

```{{r}}
# Code to produce static plot
```
::::

Scatterplot

:::

@fig-scatterplot
````
```````

## File: docs/authoring/cross-references.qmd
```````
---
title: "Cross References"
format: html
toc-expand: 2
toc-depth: 4
aliases: 
  - /docs/authoring/cross-references-listings.html
  - /docs/authoring/cross-references-callouts.html
---

## Overview

Cross-references make it easier for readers to navigate your document by providing numbered references and hyperlinks to various entities like figures and tables. Every cross-referenceable entity requires a label---a unique identifier prefixed with a cross-reference type e.g. `#fig-element`. For example, this is a cross-referenceable figure:

``` markdown
![Elephant](elephant.png){#fig-elephant}
```

The presence of the label (`#fig-elephant`) makes this figure referenceable. This enables you to use the following syntax to refer to it elsewhere in the document:

``` markdown
See @fig-elephant for an illustration.
```

Here is what this would look like rendered to HTML:

![](images/crossref-figure.png){.border fig-alt="A line drawing of an elephant. The caption 'Figure 1: Elephant' is centered beneath it." width="100%"}

Note that cross reference identifiers must start with their type (e.g. `fig-` or `tbl-`). So the identifier `#fig-elephant` is valid for a cross-reference but the identifiers `#elephant` and `#elephant-fig` are not.

::: {#reserved-prefixes}
::: {.callout-warning}

## Reserved Prefixes 

Unless you are creating a cross-reference, avoid using the reserved cross-reference prefixes for code cell labels (e.g. set using the `label` code cell option) and element IDs (set using a `#` in an attribute). 
 
The reserved prefixes are: `fig`, `tbl`, `lst`, `tip`, `nte`, `wrn`, `imp`, `cau`, `thm`, `lem`, `cor`, `prp`, `cnj`, `def`, `exm`, `exr`, `sol`, `rem`, `eq`, `sec`.

Also avoid using underscores (`_`) in labels and IDs as this can cause problems when rendering to PDF with LaTeX.

:::
:::

Quarto enables you to create cross-references to figures, tables, equations, sections, code listings, theorems, proofs, and more. Cross references can also be applied to dynamic output from Knitr and Jupyter. 

On this page you'll learn:

*  Different ways to use the `@` syntax to create [References](#references).
*  How to add [Lists](#lists) of references in LaTeX / PDF output.

Then, we enumerate the syntax for the different types of elements you might want to reference:

*  [Floats](#floats): [Figures](#figures), [Tables](#tables) and [Code Listings](#code-listings)
* Blocks: [Callouts](#callouts), [Theorems and Proofs](#theorems-and-proofs) and [Equations](#equations) 
*  [Sections](#sections)

There are options available that control the text used for titles and references. For example, you could change "Figure 1" to read "Fig 1" or "fig. 1". See the [options documentation](cross-reference-options.qmd) for details on how to customize the text used for cross-references.

## References

The examples on this page all use the default syntax for inline references (e.g. `@fig-elephant`), which results in the reference text "Figure 1", "Table 1", etc.

You can customize the appearance of inline references by either changing the syntax of the inline reference or by setting options. Here are the various ways to compose a cross-reference and their resulting output:

| Type          | Syntax                | Output   |
|---------------|-----------------------|----------|
| Default       | `@fig-elephant`       | Figure 1 |
| Capitalized   | `@Fig-elephant`       | Figure 1 |
| Custom Prefix | `[Fig @fig-elephant]` | Fig 1    |
| No Prefix     | `[-@fig-elephant]`    | 1        |

Note that the capitalized syntax makes no difference for the default output, but would indeed capitalize the first letter if the default prefix had been changed via an [option](cross-reference-options.qmd#references) to use lower case (e.g. "fig.").

These syntax variations work not only for Figures, but for all cross-referenceable elements in Quarto such as Tables, Equations, Theorems, and so on.

You can also group cross-references using the following syntax:

``` markdown
As illustrated in [@fig-elephant; @fig-panther; @fig-rabbit].
```

There are a number of options that can be used to further customize the treatment of cross-references. See the guide on [Cross Reference Options](cross-reference-options.qmd#references) for additional details.

## Lists

For LaTeX / PDF output, you can use the raw LaTeX commands `\listoffigures`, `\listoftables` and `\listoflistings` to produce listings of all figures, tables, etc. within a document. You can use the `lof-title`, `lot-title`, and `lol-title` crossref options to customize the title of the listing.

For example:

``` markdown
---
title: "My Document"
crossref:
  lof-title: "List of Figures"
format: pdf
---

\listoffigures
```

Note that the default titles for the lists use the form displayed above (i.e. "List of \<Type\>").

## Floats

[Figures](#figures), [tables](#tables) and [code listings](#code-listings) are known as "float" cross-references. Floats can appear in the rendered document at locations other than where they are defined, i.e. they float, and usually have captions. 

In addition to the compact syntax for the most common uses of float cross-references, you can also define float cross-references with a div syntax. Use the div syntax when you need more flexibility in the content of your cross-reference, for example, to have a [video](cross-references-divs.qmd#videos) be referenced as a figure. Basic examples of the div syntax are included in the sections below, but you can find more complicated examples in [Cross-Reference Div Syntax](cross-references-divs.qmd). 

You can also define custom types of float cross-reference to reference elements beyond figures, tables and code listings. Read more at [Custom Float Cross-References](cross-references-custom.qmd).


### Figures

As described on the Overview above, this is the markdown used to create a cross-referenceable figure and then refer to it:

``` markdown
![Elephant](elephant.png){#fig-elephant}

See @fig-elephant for an illustration.
```

Note again that cross-reference identifiers must start with their type (e.g. `#fig-`) and that cross-reference identifiers must be all lower case.

{{< include _cross-reference-divs-figure.qmd >}}

You can read about using div syntax with figures at [Cross-Reference Div Syntax](cross-references-divs.qmd#figures).

#### Subfigures

You may want to create a figure composed of multiple subfigures. To do this, enclose the figures in a div (with its own label and caption) and give each subfigure its own label and (optionally) caption. You can then refer to either the entire figure in a reference or a single subfigure:

``` markdown
::: {#fig-elephants layout-ncol=2}

![Surus](surus.png){#fig-surus}

![Hanno](hanno.png){#fig-hanno}

Famous Elephants
:::

See @fig-elephants for examples. In particular, @fig-hanno.
```

Here is what this looks like when rendered as HTML:

![](images/crossref-subfigures.png){.preview-image .border fig-alt="An artistic rendition of Surus, Hannibal's last war elephant, is on the left. Underneath this picture is the caption '(a) Surus.' On the right is a line drawing of Hanno, a famous elephant. Underneath this picture is the caption '(b) Hanno.' The words 'Figure 1: Famous elephants' are centered beneath both pictures. The text 'See fig. 1 for examples. In particular, fig. 1(b).' is underneath this text and is aligned to the left." width="100%"}

Note that we also used the `layout-ncol` attribute to specify a two-column layout. See the article on [Figures](figures.qmd) for more details on laying out panels of figures.

#### Computations

Figures produced by Jupyter and Knitr can also be cross-referenced. To do this, add a `label` and `fig-cap` option at the top of the code block. For example:

::: panel-tabset
##### Jupyter

    ```{{python}}
    #| label: fig-plot
    #| fig-cap: "Plot"

    import matplotlib.pyplot as plt
    plt.plot([1,23,2,4])
    plt.show()
    ```

    For example, see @fig-plot.

![](images/crossref-figure-jupyter.png){fig-alt="A line plot with the label 'Figure 1: Plot' centered underneath it. The text 'For example, see fig. 1' is underneath this label and aligned to the left."}

##### Knitr

    ```{{r}}
    #| label: fig-plot
    #| fig-cap: "Plot"

    plot(cars)
    ```

    For example, see @fig-plot.

![](images/crossref-figure-r.png){fig-alt="A scatter plot of speed versus distance for the `cars` dataset. The label 'Figure 1: Plot' is centered beneath it. The text 'For example, see fig. 1' is aligned to the left underneath that."}
:::

{{< include _computed-caption.md >}}

You can also create multiple figures within a code cell and reference them as subfigures. To do this use `fig-cap` for the main caption, and `fig-subcap` to provide an array of subcaptions. For example:

    ```{{python}}
    #| label: fig-plots
    #| fig-cap: "Plots" 
    #| fig-subcap:
    #|   - "Plot 1"
    #|   - "Plot 2" 
    #| layout-ncol: 2

    import matplotlib.pyplot as plt
    plt.plot([1,23,2,4])
    plt.show()

    plt.plot([8,65,23,90])
    plt.show()
    ```

    See @fig-plots for examples. In particular, @fig-plots-2.

![](images/crossref-subfigures-jupyter.png){fig-alt="Two line plots side-by-side. The plot on the left has the caption '(a) Plot 1' centered underneath it. The plot on the right has the caption '(b) Plot 2' centered underneath it. The text 'Figure 1: Plots' is centered underneath both of these plots. The text 'See fig. 1 for examples. In particular, fig. 1(b)' is aligned to the left underneath that."}

Note that subfigure reference labels are created automatically based on the main chunk label (e.g. `@fig-plots-1`, `@fig-plots-2`, etc.).

If you'd like subfigure captions that include only an identifier, e.g. "(a)", and not a text caption, then specify `fig-subcap: true` rather than providing explicit subcaption text:

```{{python}}
#| label: fig-plots
#| fig-cap: "Plots" 
#| fig-subcap: true
#| layout-ncol: 2
```

### Tables

{{< include _table-crossrefs.md >}}

::: callout-important
## Label Prefix

In order for a table to be cross-referenceable, its label must start with the `tbl-` prefix.
:::

{{< include _cross-reference-divs-table.qmd >}}

You can read more about using div syntax with tables at [Cross-Reference Div Syntax](cross-references-divs.qmd#tables).

#### Subtables

{{< include _table-crossrefs-subtables.md >}}

#### Computations

You can also cross-reference tables created from code executed via computations. To do this, add the `label` and `tbl-cap` cell options. For example:

```{{r}}
#| label: tbl-iris
#| tbl-cap: "Iris Data"

library(knitr)
kable(head(iris))
```

![](/docs/authoring/images/crossref-table-knitr.png){fig-alt="Example table output." fig-align="center" width="80%"}

{{< include _computed-caption.md >}}

You can also create multiple tables within a code cell and reference them as subtables. To do this, add a `tbl-subcap` option with an array of subcaptions. For example:

```{{r}}
#| label: tbl-tables
#| tbl-cap: "Tables"
#| tbl-subcap:
#|   - "Cars"
#|   - "Pressure"
#| layout-ncol: 2

library(knitr)
kable(head(cars))
kable(head(pressure))
```

![](/docs/authoring/images/crossref-subtable-knitr.png){fig-alt="Two tables side-by-side. Each table has 2 columns and 8 rows. The table on the left is titled '(a) Cars'. The table on the right is titled '(b) Pressure'. Centered underneath both tables is the text 'Table 1: Tables.'" fig-align="center" width="80%"}

If you'd like subtable captions that include only an identifier, e.g. "(a)", and not a text caption, then specify `tbl-subcap: true` rather than providing explicit subcaption text:

```{{r}}
#| label: tbl-tables
#| tbl-cap: "Tables"
#| tbl-subcap: true
#| layout-ncol: 2

library(knitr)
kable(head(cars))
kable(head(pressure))
```

![](/docs/authoring/images/crossref-subtable-nocaption-knitr.png){fig-align="center" width="80%"}


### Code Listings

To create a reference-able code block, add a `#lst-` identifier along with a `lst-cap` attribute. For example:

```` markdown
```{#lst-customers .sql lst-cap="Customers Query"}
SELECT * FROM Customers
```

Then we query the customers database (@lst-customers).
````

{{< include _cross-reference-divs-listing.qmd >}}

You can read more about using div syntax for code listings in [Cross-Reference Div Syntax](cross-references-divs.qmd).

{{< include _cross-references-listings.qmd >}}

## Callouts

{{< include _cross-references-callouts.qmd >}}

## Theorems and Proofs

Theorems are commonly used in articles and books in mathematics. To include a reference-able theorem, create a div with a `#thm-` label (or one of other theorem-type labels described below). You also need to specify a theorem name either via the first heading in the block. You can include any content you like within the div. For example:

``` markdown
::: {#thm-line}

## Line

The equation of any straight line, called a linear equation, can be written as:

$$
y = mx + b
$$
:::

See @thm-line.
```

![](images/crossref-theorem.png){fig-alt="A snippet of a LaTeX document. The first line reads: 'Thereom 1 (Line) The equation of any straight line, called a linear equation, can be written as:' Cenetered on a separate line is the equation 'y = mx + b'. The text 'See thm. 1' is aligned to the left underneath that."}

For LaTeX output, the [amsthm](https://ctan.org/pkg/amsthm?lang=en) package is used for typesetting theorems. For other formats an appropriate treatment is used (the above is an example of HTML output).

There are a number of theorem variations supported, each with their own label prefix:

| **Label Prefix** | **Printed Name** | **LaTeX Environment** |
|------------------|------------------|-----------------------|
| `#thm-`          | Theorem          | theorem               |
| `#lem-`          | Lemma            | lemma                 |
| `#cor-`          | Corollary        | corollary             |
| `#prp-`          | Proposition      | proposition           |
| `#cnj-`          | Conjecture       | conjecture            |
| `#def-`          | Definition       | definition            |
| `#exm-`          | Example          | example               |
| `#exr-`          | Exercise         | exercise              |
| `#sol-`          | Solution         | solution              |
| `#rem-`          | Remark           | remark                |

The `proof` environment receives similar typesetting as theorems, however it is not numbered (and therefore cannot be cross-referenced). To create a proof add the `.proof` class to a div:

``` markdown
::: {.proof}
By induction.
:::
```

As with theorems you can optionally include a heading as the first element of the div (or a `name` attribute) to give the environment a caption for typesetting (this typically appears in parentheses after the environment title).

For LaTeX output the [amsthm](https://ctan.org/pkg/amsthm?lang=en) package is used to typeset these environments. For other formats a similar treatment is used, but you can further customizing this using CSS.

## Equations

Provide an `#eq-` label immediately after an equation to make it referenceable. For example:

``` markdown
Black-Scholes (@eq-black-scholes) is a mathematical model that seeks to explain the behavior of financial derivatives, most commonly options:

$$
\frac{\partial \mathrm C}{ \partial \mathrm t } + \frac{1}{2}\sigma^{2} \mathrm S^{2}
\frac{\partial^{2} \mathrm C}{\partial \mathrm S^2}
  + \mathrm r \mathrm S \frac{\partial \mathrm C}{\partial \mathrm S}\ =
  \mathrm r \mathrm C 
$$ {#eq-black-scholes}
```

Black-Scholes (@eq-black-scholes) is a mathematical model that seeks to explain the behavior of financial derivatives, most commonly options:

$$
\frac{\partial \mathrm C}{ \partial \mathrm t } + \frac{1}{2}\sigma^{2} \mathrm S^{2}
\frac{\partial^{2} \mathrm C}{\partial \mathrm S^2}
  + \mathrm r \mathrm S \frac{\partial \mathrm C}{\partial \mathrm S}\ =
  \mathrm r \mathrm C 
$$ {#eq-black-scholes}

Note that the equation number is included (via `\qquad`) in the right margin of the equation.

## Sections

To reference a section, add a `#sec-` identifier to any heading. For example:

``` markdown
## Introduction {#sec-introduction}

See @sec-introduction for additional context.
```

Note that when using section cross-references, you will also need to enable the `number-sections` option (so that section numbering is visible to readers). For example:

``` yaml
---
title: "My Document"
number-sections: true
---
```
```````

## File: docs/authoring/diagrams.qmd
```````
---
title: "Diagrams"
aliases:
  - /docs/prerelease/1.3/mermaid.html
---

## Overview

Quarto has native support for embedding [Mermaid](https://mermaid-js.github.io/mermaid/#/) and [Graphviz](https://graphviz.org/) diagrams. This enables you to create flowcharts, sequence diagrams, state diagrams, gantt charts, and more using a plain text syntax inspired by markdown.

For example, here we embed a flowchart created using Mermaid:

```{mermaid}
%%| echo: fenced
flowchart LR
  A[Hard edge] --> B(Round edge)
  B --> C{Decision}
  C --> D[Result one]
  C --> E[Result two]
```

As illustrated above, Mermaid diagrams are embedded using `{mermaid}` executable cells.  Graphviz diagrams are embedded using `{dot}` executable cells. Note that cell options are added with slightly different syntax: `%%|` for `{mermaid}`, and `//|` for `{dot}`. 


::: callout-note
For print output formats like `pdf` or `docx`, diagram rendering makes use of the Chrome or Edge web browser to create a high-quality PNG. Quarto can automatically use an existing version of Chrome or Edge on your system, or alternatively if you don't have either installed, can use a lighter-weight library version of Chrome (see [Chrome Install](#chrome-install) below for details).
:::

## Mermaid

Mermaid is a Javascript based diagramming and charting tool that uses Markdown-inspired text definitions and a renderer to create and modify complex diagrams.

Mermaid diagrams use `%%` as their comment syntax, and so cell options are declared using `%%|`. Cell options **must** be included directly beneath the start of the diagram code chunk.

Above we demonstrated a flowchart created with Mermaid, here is a sequence diagram (also embedded using a `{mermaid}` executable cell):

```{mermaid}
%%| echo: fenced
sequenceDiagram
  participant Alice
  participant Bob
  Alice->>John: Hello John, how are you?
  loop Healthcheck
    John->>John: Fight against hypochondria
  end
  Note right of John: Rational thoughts <br/>prevail!
  John-->>Alice: Great!
  John->>Bob: How about you?
  Bob-->>John: Jolly good!
```

Note that Mermaid output varies depending on the target format (e.g. HTML vs. print-based). See the section below on [Mermaid Formats](#mermaid-formats) for additional details.

To learn more about using Mermaid, see the [Mermaid website](https://mermaid-js.github.io/mermaid/) or the [Mermaid book](https://www.amazon.com/Official-Guide-Mermaid-js-beautiful-flowcharts-dp-1801078025/dp/1801078025) (which is written by the creator of Mermaid).

## Graphviz

The Graphviz layout programs take descriptions of graphs in a simple text language, and make diagrams in useful formats. Graphviz has many useful features for concrete diagrams, such as options for colors, fonts, tabular node layouts, line styles, hyperlinks, and custom shapes.

Graphviz diagrams use `//` as their comment syntax, and so cell options are declared using `//|`. Cell options **must** be included directly beneath the start of the diagram code chunk.

For example, here is a simple undirected graph created using graphviz:

```{dot}
//| echo: fenced
graph G {
  layout=neato
  run -- intr;
  intr -- runbl;
  runbl -- run;
  run -- kernel;
  kernel -- zombie;
  kernel -- sleep;
  kernel -- runmem;
  sleep -- swap;
  swap -- runswap;
  runswap -- new;
  runswap -- runmem;
  new -- runmem;
  sleep -- runmem;
}
```


To learn more about Graphviz, see the [Graphviz website](https://graphviz.org/), this list of simple [Graphiz Examples](https://renenyffenegger.ch/notes/tools/Graphviz/examples/index), or the [Graphviz Gallery](https://graphviz.org/gallery/).

## Authoring

There are a variety of tools available to improve your productivity authoring diagrams:

1)  The [Mermaid Live Editor](https://mermaid.live/) is an online tool for editing and previewing Mermaid diagrams in real time.

2)  [Graphviz Online](https://dreampuf.github.io/GraphvizOnline/) provides a similar tool for editing Graphviz diagrams.

3)  [RStudio](https://www.rstudio.com/products/rstudio/download/) includes support for editing and previewing `.mmd` and `.dot` files (with help from the [DiagrammeR](https://rich-iannone.github.io/DiagrammeR/) package).

4)  The Quarto [VS Code Extension](https://marketplace.visualstudio.com/items?itemName=quarto.quarto) supports live preview of diagrams embedded in `.qmd` files and in `.mmd` and `.dot` files:

    ![](images/vscode-graphviz.gif){.border fig-alt="A Quarto document being edited in Visual Studio Code, with a live preview of the currenly edited diagram shown in a pane to the right"}

    Note that you should be sure to have installed the [very latest](https://marketplace.visualstudio.com/items?itemName=quarto.quarto) version of the Quarto VS Code extension to try this out.

## Cross-References

Diagrams can be treated as figures the same way that images and plot output are. For example, if we added the following figure options to the diagram above:

```{{dot}}
//| label: fig-simple
//| fig-cap: "This is a simple graphviz graph."
```

We'd get this output:

```{dot}
//| label: fig-simple
//| fig-cap: "This is a simple graphviz graph."
graph G {
  layout=neato
  run -- intr;
  intr -- runbl;
  runbl -- run;
  run -- kernel;
  kernel -- zombie;
  kernel -- sleep;
  kernel -- runmem;
  sleep -- swap;
  swap -- runswap;
  runswap -- new;
  runswap -- runmem;
  new -- runmem;
  sleep -- runmem;
}
```

We could then create a cross-reference to the diagram with:

```markdown
@fig-simple
```

{{< include _cross-reference-divs-diagram.qmd >}}

## File Include

You might find it more convenient to edit your diagram in a standalone `.dot` or `.mmd` file and then reference it from within your `.qmd` document. You can do this by adding the `file` option to a Mermaid or Graphviz cell.

For example, here we include a very complex diagram whose definition would be too unwieldy to provide inline:

```{{dot}}
//| label: fig-linux-kernel
//| fig-cap: "A diagram of the Linux kernel."
//| file: linux-kernel-diagram.dot
```

```{dot}
//| label: fig-linux-kernel
//| fig-cap: "A diagram of the Linux kernel."
//| file: images/linux-kernel-diagram.dot
```

Note that the `label` and `fig-cap` attributes still work as expected with `file` includes.

## Sizing

By default, diagrams are rendered at their natural size (i.e. they are not stretched to fit the default figure size for the current document). Within HTML output formats, diagrams are also made responsive, so that their width doesn't overflow the current page column. This is similar to the treatment given to images and dynamic JavaScript widgets.

You can disable responsive sizing by specifying the `fig-responsive: false` option. You can also specify explicit sizes via `fig-width` and `fig-height`. For example, here we want to make a mermaid diagram a bit bigger because it contains only a few elements:

```{mermaid}
%%| echo: fenced
%%| fig-width: 6.5
flowchart LR
  A[Hard edge] --> B(Round edge)
  B --> C{Decision}
```

## Mermaid Formats {#mermaid-formats}

When you include a Mermaid diagram in a document, the diagram format used is chosen automatically based on the output format:

| Format                              | Output                      |
|-------------------------------------|-----------------------------|
| HTML (`html`, `revealjs`, etc.)     | Mermaid native (JavaScript) |
| GitHub Flavored Markdown (`gfm`)    | Mermaid code block          |
| Other Formats (`pdf`, `docx`, etc.) | PNG image                   |

The Mermaid native format is used by default whenever the underlying output format supports JavaScript.

When using `format: gfm`, diagrams will be emitted as plain `mermaid` code blocks. This is because both [GitHub](https://github.blog/2022-02-14-include-diagrams-markdown-files-mermaid/) and [GitLab](https://docs.gitlab.com/ee/user/markdown.html#mermaid) natively support rendering Mermaid diagrams from code.

For formats that don't do special handling of Mermaid or lack a JavaScript run-time (e.g. formats like `pdf`, `docx`, `epub`, etc.) a PNG image is created using [Chrome](#chrome-install).

You can change the default behavior using the `mermaid-format` option. For example:

``` yaml
---
format:
  gfm:
    mermaid-format: png
---
```

Valid values for `mermaid-format` include `js`, `png`, and `svg`,

## Mermaid Themes {#mermaid-theming}

{{< include _mermaid-theming.qmd >}}

## Code Echo

Note that unlike other executable cell handlers (e.g. `{python}`), cells with diagrams don't display their code in the rendered document by default. You can display code by adding an `echo: true` option in a comment at the top the cell.

To include code for `{mermaid}`, add `%%| echo: true` to the top of the cell. For example:

```{{mermaid}}
%%| echo: true
```

To include code for `{dot}`, add `//| echo: true` to the top of the cell. For example:

```{{dot}}
//| echo: true
```

## Chrome Install {#chrome-install}

For printing to output formats like `pdf` or `docx`, diagram rendering makes use of the Chrome or Edge web browser to create a high-quality PNG.

Quarto can automatically use an existing version of Chrome or Edge on your system for rendering. Alternatively, if you don't have either, you can install a minimal version of Chrome for use by Quarto with the following command:

``` {.bash filename="Terminal"}
quarto install chromium
```

::: callout-note
Quarto installs headless Chromium via Puppeteer. The bundled Chromium that Puppeteer installs may not work on Docker containers; please check [the Puppeteer documentation](https://github.com/puppeteer/puppeteer/blob/main/docs/troubleshooting.md#running-puppeteer-in-docker) as well as [this article](https://pptr.dev/next/troubleshooting#running-puppeteer-on-wsl-windows-subsystem-for-linux) if you are attempting to install within Windows Subsystem for Linux (WSL).
:::
```````

## File: docs/authoring/figures.qmd
```````
---
title: "Figures"
format: html
aliases: 
  - figures-and-layout.html
  - figure-layout.html
---

Quarto includes a number of features aimed at making it easier to work with figures and subfigures, as well as for laying out panels that contain multiple figures, tables, or other content.

## Figure Basics

In Pandoc markdown, a figure is created whenever a captioned image appears by-itself in a paragraph. For example:

``` markdown
![Elephant](elephant.png)
```

This results in the following treatment for various output types:

| HTML                                                                              | PDF                                                                  | Word                                                                  |
|---------------------------|-----------------------|-----------------------|
| ![](images/html-figure.png){fig-alt="A line drawing of an elephant." width="340"} | ![](images/pdf-figure.png){fig-alt="A line drawing of an elephant."} | ![](images/word-figure.png){fig-alt="A line drawing of an elephant."} |

Note that for LaTeX / PDF output figures are automatically numbered (you can arrange for figures to be numbered in other formats using [Cross References](cross-references.qmd)).

### Figure Sizing

By default figures are displayed using their actual size (subject to the width constraints imposed by the page they are rendered within). You can change the display size by adding the `width` and `height` attributes to the figure. For example:

``` markdown
![Elephant](elephant.png){width=300}
```

Note that if only `width` is specified then `height` is calculated automatically. If you need to modify the default behaviour just add an explicit `height` attribute.

The default units for `width` and `height` are pixels. You can also specify sizes using a percentage or a conventional measurement like inches or millimetres. For example:

``` markdown
![Elephant](elephant.png){width=80%}
![Elephant](elephant.png){width=4in}
```

### Linked Figures

When rendering with Quarto, you can enclose a figure within a link and it will still be treated within output as a captioned figure. For example:

``` markdown
[![Elephant](elephant.png)](https://en.wikipedia.org/wiki/Elephant)
```

### Figure Alignment

Figures are center aligned by default. Add the `fig-align` attribute to the image to use a different alignment. For example:

``` markdown
![Elephant](elephant.png){fig-align="left"}
```

Note that figure captions are left aligned to accommodate longer caption text (which looks odd when center aligned).

### Alt Text

You can add alternative text to a figure by adding the `fig-alt` attribute to the image. For example, the following Markdown...

``` markdown
![](elephant.png){fig-alt="A drawing of an elephant."}
```

... will create the following HTML with the corresponding alt tag:

``` html
<img src="elephant.png" alt="A drawing of an elephant.">
```

Note that the figure caption, title, and alt text can all be different. For example, the following code...

``` markdown
![Elephant](elephant.png "Title: An elephant"){fig-alt="A drawing of an elephant."}
```

...produces this HTML:

``` html
<img src="elephant.png" title="Title: An elephant" alt="A drawing of an elephant.">
```

To render the caption instead as alt text
you can append a backslash to the line
as detailed in [the Pandoc documentation](https://pandoc.org/MANUAL.html#extension-implicit_figures):

``` markdown
![A drawing of an elephant.](elephant.png)\
```

### Multiformat Figures

You can write markdown that provides a distinct image file format depending on the target output format. To do this simply leave-off the extension, for example:

``` markdown
![](elephant)
```

By default this will look for `elephant.png`, however if you are rendering to PDF it will look for `elephant.pdf`. You can customize this behavior using the `default-image-extension` option. For example:

``` yaml
format:
  html:
    default-image-extension: svg
  pdf:
    default-image-extension: tex
```

### Lightbox Figures

In HTML output formats you can add  lightbox styling and behavior to images to allow a reader to click to see a larger version of the image. For example, the following image has lightbox treatment (click on the image to see lightbox in action):

![An elephant](elephant.png){.lightbox width=50%}

Lightbox treatment can be added by adding the class `.lightbox` to an image: 

```markdown
![An elephant](elephant.png){.lightbox}
```

For further details and other ways to enable and disable lightbox treatment see [Lightbox Figures](/docs/output-formats/html-lightbox-figures.qmd).

### Applying Multiple Parameters 
To combine the above methods, separate arguments by a space, for example:
``` markdown
![](elephant.png){fig-alt="A drawing of an elephant." fig-align="left" width=20%}
```

## Cross References

You can cross-reference figures by adding an ID with the `fig-` prefix to them, and then referencing the figure using the `@` prefix. For example:

``` markdown
![An Elephant](elephant.png){#fig-elephant}

This is illustrated well by @fig-elephant.
```

For figures produced by executable code cells, include a `label` with a `fig-` prefix to make them cross-referenceable. For example:

```` markdown
For a demonstration of a line plot, see @fig-line-plot.

```{{python}}
#| label: fig-line-plot
#| fig-cap: "A line plot "

import matplotlib.pyplot as plt
plt.plot([1,23,2,4])
plt.show()
```
````

::: callout-important
## Label Prefix

In order for a figure to be cross-referenceable, its label must start with the `fig-` prefix.
:::

See the article on [Cross References](cross-references.qmd) for additional details.

## Subfigures

If you have several figures that appear as a group, you can create a figure div to enclose them. For example:

``` markdown
::: {#fig-elephants layout-ncol=2}

![Surus](surus.png){#fig-surus}

![Hanno](hanno.png){#fig-hanno}

Famous Elephants
:::
```

Again, the last paragraph provides the main caption, and the individual figures carry the sub-captions. Here is what this looks like when rendered as HTML:

![](images/elephant-subfigures.png){fig-alt="An artistic rendition of Surus, Hannibal's last war elephant, is on the left. Underneath this picture is the caption '(a) Surus.' On the right is a line drawing of Hanno, a famous elephant. Underneath this picture is the caption '(b) Hanno.' The words 'Figure 1: Famous elephants' are centered beneath both pictures."}

Note that the empty lines between the figures (and between the last figure and the caption) are required (it's what indicates that these images belong to their own paragraphs rather than being multiple images within the same paragraph).

Note also that we also used a `layout-ncol` attribute to specify a two-column layout. The next section delves more into customizing figure layouts.

## Figure Panels

Above we demonstrate laying out two side-by-side figures with subcaptions and a main caption. You may or may not want the caption / sub-caption treatment, and you might also want to use multiple rows of figures. All of these variations are possible.

To layout two figures with their own standalone captions (and no main caption), just eliminate the `#fig` identifiers and main caption at the bottom:

``` markdown
::: {layout-ncol=2}
![Surus](surus.png)

![Hanno](hanno.png)
:::
```

![](images/elephant-figures-no-subcaption.png){fig-alt="An artistic rendition of Surus, Hannibal's last war elephant, is on the left. Underneath this picture is the caption 'Surus.' On the right is a line drawing of Hanno, a famous elephant. Underneath this picture is the caption 'Hanno.'"}

You can also eliminate the captions entirely:

``` markdown
::: {layout-ncol=2}
![](surus.png)

![](hanno.png)
:::
```

### Multiple Rows

If you have more than 2 images, you might want to lay them out across multiple rows. You can do this using the `layout-nrow` attribute. For example:

``` markdown
::: {layout-nrow=2}
![Surus](surus.png)

![Hanno](hanno.png)

![Abdul Abbas](abdul-abbas.png)

![Lin Wang](lin-wang.png)
:::
```

![](images/elephant-rows.png){fig-alt="A 2x2 grid of pictures of elephants. There are labels underneath each of the pictures. Clockwise from the upper left, the labels say: Surus, Hanno, Lin Wang, and Abdul Abbas."}

More complex figure arrangements (e.g. rows with varying column layouts) are possible. See the [Custom Layouts](#complex-layouts) section below for more details.

## Figure Divs

You can treat any markdown content you want as a figure by enclosing it in Pandoc div block with an identifier prefaced with `#fig-`. For example, here we create a figure that includes an embedded iframe:

``` markdown
::: {#fig-elephant}

<iframe width="560" height="315" src="https://www.youtube.com/embed/SNggmeilXDQ"></iframe>

Elephant
:::
```

Note that the last paragraph in the div block is used as the figure caption.

## LaTeX Figures

This section describes some figure handling options that are specific to LaTeX output.

One very important thing to note is that using the `fig-env` and `fig-pos` options described below will trigger the creation of a LaTeX floating environment (most often `\begin{figure}`). Depending upon where this LaTeX is generated (e.g., within another `\begin{figure}`), this could produce invalid LaTeX. To be on the safe side, these attributes should typically only be used for images at the very top level of your document.

### Environments

There are a number of LaTeX packages that provide custom figure environments. For example, in two-column formats, the `figure*` environment spans both columns of the document. You can explicitly pass the figure environment to use as the `fig-env` attribute of the image or the fenced div:

``` markdown
![Elephant](surus.jpg){#fig-elephant fig-env="figure*"}

::: {#fig-elephant-2 fig-env="figure*"}

![](surus.jpg)

Another elephant.

:::
```

### Figure Position

The default LaTeX `figure` is a floating environment, so the specific location it appears in your document will depend on its size and the nature of the other content around it. You can exercise some control over this behavior using the `fig-pos` option. The `fig-pos` option provides a placement specifier for the `figure` environment. For example, the `ht` in this LaTeX snippet is the `fig-pos`:

``` latex
\begin{figure}[ht]

\end{figure}
```

You can specify `fig-pos` either at the document level, as an executable code block option, or within markdown. Here we do all three:

```` markdown
---
title: "My Document"
format:
  pdf:
    fig-pos: 'h'
---

```{{python}}
#| fig-pos: 't'

```

![](figure.png){fig-pos='b'}
````

See [this article](https://www.latex-project.org/publications/2014-FMi-TUB-tb111mitt-float-placement.pdf) for additional details on LaTeX figure positioning.

::: callout-note
## Figures and Code Blocks

If your figure was generated by an executable code block and the code was included in the output (`echo: true`), then `fig-pos` will be set to `H` by default (to try to keep it alongside the code that generated it). In all other cases, default LaTeX handing of figure position is used unless you specify an explicit `fig-pos`.
:::

### Short Captions

You can provide a short caption that is used in the "List of Figures" using the `fig-scap` option.
You can specify `fig-scap` as an executable code block option or as an attribute on an image:

````markdown
```{{python}}
#| fig-cap: "Long caption"
#| fig-scap: "Short caption"

```

![Long Caption](figure.png){fig-scap='Short caption'}
````


### PGF/Ti*k*Z Graphics

If you are creating LaTeX output, Quarto will automatically emit the correct LaTeX for markdown images that reference `.tex` files containg [PGF/Ti*k*Z](https://en.wikipedia.org/wiki/PGF/TikZ) vector graphics. For example, the following markdown images:

``` markdown
![](image1.tex)

![](image2.tex){width=80%}
```

Will be written to LaTeX as:

``` tex
\input{image1.tex}

\resizebox{0.8\linewidth}{!}{\input{image2.tex}}
```

As shown above, `width` and `height` percentages are automatically converted to `\linewidth` scaled. Alternatively you can specify custom LaTeX for the `width` and `height` arguments of `\resizebox`.

## Caption Locations

By default, figure captions are positioned below figures. In HTML and PDF formats, you can modify this behavior using the `fig-cap-location` option. For example:

``` yaml
---
fig-cap-location: top
---
```

Note that this option is specified at the top level so that it can be shared by both PDF and HTML formats. If you are only targeting a single format you can place it alongside other `format` specific options.

Valid values for the caption location include:

| Value    | Description                            |
|----------|----------------------------------------|
| `top`    | Position the caption above the figure. |
| `bottom` | Position the caption below the figure. |
| `margin` | Position the caption in the margin.    |

See the article on [Article Layout](article-layout.qmd#margin-captions) for additional details on placing captions in the margin.

## Custom Layouts {#complex-layouts}

The examples above used the `layout-ncol` or `layout-nrow` attributes to create straightforward layouts where all columns are of equal sizes. The `layout` attribute enables the creation of much more complex layouts.

For example, this defines a layout with two equally sized figures in the first row, then another image that spans the entire second row:

``` markdown
::: {layout="[[1,1], [1]]"}
![Surus](surus.png)

![Hanno](hanno.png)

![Lin Wang](lin-wang.png)
:::
```

![](images/layout-attrib.png){fig-alt="Three elephant pictures arranged such that two pictures are side-by-side in the first row, and the third picture is underneath both of these. The picture on the left in the first row is captioned 'Surus' and the picture on the right is captioned 'Hanno'. The picture underneath these two is captioned 'Lin Wang' and is as as wide and tall as the other two put together."}

The `layout` attribute is a 2-dimensional array where the first dimension defines rows and the second columns. In this case `"layout="[[1,1], [1]]"` translates to: create two rows, the first of which has two columns of equal size and the second of which has a single column.

Note that the numbers in a row are arbitrary and don't need to add up to a particular total. You can therefore use whatever scheme is most natural. For example, here we define columns that occupy varying percentage widths of the row:

``` markdown
::: {layout="[[70,30], [100]]"}
![Surus](surus.png)

![Hanno](hanno.png)

![Lin Wang](lin-wang.png)
:::
```

You can also use negative values to create space between elements. For example:

``` markdown
::: {layout="[[40,-20,40], [100]]"}
![Surus](surus.png)

![Hanno](hanno.png)

![Lin Wang](lin-wang.png)
:::
```

![](images/layout-attrib-negative.png){fig-alt="Three elephant pictures arranged such that two pictures are side-by-side in the first row, and the third picture is underneath both of these. The picture on the left in the first row is captioned 'Surus' and the picture on the right is captioned 'Hanno'. The two pictures are separated by some whitespace. The picture underneath these two is captioned 'Lin Wang' and is wider and taller than the other two put together."}

### Vertical Alignment

If you have a layout with a row of images of differing heights, you can control their vertical alignment using the `layout-valign` attribute. A simple example:

``` markdown
::: {layout="[15,-2,10]" layout-valign="bottom"}
![Surus](surus.png)

![Lin Wang](lin-wang.png)
:::
```

![](images/valign.png){fig-alt="Two pictures of elephants side by side. The picture on the left has the label 'Figure 1: Surus' underneath it. The picture on the right has the label 'Figure 2: Lin Wang' underneath it. The figure on the left is more than twice the width and height of the figure on the right."}

Note that vertical alignment isn't limited to images, you can also vertically align any other elements that are included in a panel.

## Computations

Figures produced by executable code blocks are automatically included in your document. 
To set the ID, caption and link, use the chunk options `label`, `fig-cap` and `fig-link` respectively. 
Other attributes, e.g. `fig-align` and `fig-alt`, can be set using the chunk option of the same name.

You can control the default size for computational figures using the `fig-width` and `fig-height` options in the document header.  
Read more about these options in [Execution Options: Figure Options](/docs/computations/execution-options.qmd#figure-options).

### Layout 

Note that figure layout attributes also work for figures produced by executable code blocks. Here are examples for both Jupyter and Knitr:

::: panel-tabset
#### Jupyter

```{{python}}
#| layout-ncol: 2
#| fig-cap: 
#|   - "Line Plot 1"
#|   - "Line Plot 2"

import matplotlib.pyplot as plt
plt.plot([1,23,2,4])
plt.show()

plt.plot([8,65,23,90])
plt.show()
```

![](images/jupyter-figure-layout.png){fig-alt="Two line plots rendered by Jupyter side-by-side."}

#### Knitr

```{{r}}
#| layout-ncol: 2
#| fig-cap: 
#|   - "Speed and Stopping Distances of Cars"
#|   - "Vapor Pressure of Mercury as a Function of Temperature"

plot(cars)
plot(pressure)
```

![](images/knitr-figure-layout.png){fig-alt="Two scatter plots arranged side-by-side."}
:::

Note that in these examples we also use the `fig-cap` option to apply a caption to each of the generated figures.

### Subcaptions

You can create subcaptions for computational output by combining the `fig-cap` and `fig-subcap` options. When applying captions to computational output you can optionally include a `label` with a `fig-` prefix---if you do this then the figure will be numbered and [cross-referenceable](cross-references.qmd).

::: panel-tabset
#### Jupyter

```{{python}}
#| label: fig-charts
#| fig-cap: "Charts"
#| fig-subcap: 
#|   - "First"
#|   - "Second"
#| layout-ncol: 2

import matplotlib.pyplot as plt
plt.plot([1,23,2,4])
plt.show()

plt.plot([8,65,23,90])
plt.show()
```

![](images/jupyter-figure-layout-caption.png){fig-alt="Two line plots with captions rendered by Jupyter side-by-side."}

#### Knitr

```{{r}}
#| label: fig-charts
#| fig-cap: "Charts"
#| fig-subcap: 
#|   - "Cars"
#|   - "Pressure"
#| layout-ncol: 2

plot(cars)
plot(pressure)
```

![](images/knitr-figure-layout-caption.png){fig-alt="Two scatter plots with captions arranged side-by-side."}
:::

### Custom Layout

The `layout` works the same way for figures produced by Knitr or Jupyter. For example, here's an Rmd code chunk that produces 3 plots and defines a custom layout for them:

```{{r}}
#| layout: [[45,-10, 45], [100]]

plot(cars)
plot(pressure)
plot(mtcars)
```

![](images/knitr-layout-complex.png){.preview-image fig-alt="Two plots arranged side-by-side with a large plot underneath it. The top two plots are scatter plots visualizing the `cars` and `pressure` datasets. These two plots are separated by some additional white space. The plot on the bottom visualizes the `mtcars` dataset and is wider and taller than the other two plots combined. This plot is an 11 by 11 grid plotting each of the 11 variables in the `mtcars` dataset against each other as a scatterplot. Instead of scatter plots in the diagonal starting in the upper left and going to the lower right are text labels for each of the variable names. These are: 'mpg', 'cyl', 'disp', 'hp', 'drat', 'wt', 'qsec', 'vs', 'am', 'gear', and 'carb'."}

## Block Layout

While the examples above illustrate laying out figures, it's important to note that layout attributes can be used to layout any sort of block content. For example, here we layout 2 lists side-by-side:

``` markdown
::: {layout-ncol=2}
### List One

- Item A
- Item B
- Item C

### List Two

- Item X
- Item Y
- Item Z
:::
```

Note that headings are automatically combined with the block that follows them, so this markdown has a total of 2 columns to lay out. Here's an example of a paragraph next to a bullet list (without headings):

``` markdown
::: {layout-ncol=2}
- Item X
- Item Y
- Item Z

Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur gravida eu erat et fring. Morbi congue augue vel eros ullamcorper, eget convallis tortor sagittis. Fusce sodales viverra mauris a fringilla. Donec feugiat, justo eu blandit placerat, enim dui volutpat turpis, eu dictum lectus urna eu urna. Mauris sed massa ornare, interdum ipsum a, semper massa. 
:::
```

For more complicated content use divs (`:::`) to divide your content into blocks for the layout. For example, here's how you could lay out a code cell along with some text, next to a figure:

````markdown
:::: {layout="[ 40, 60 ]"}

::: {#first-column}
```r
# Some code
```

Some text that should be laid out below the code
:::

::: {#second-column}
![](elephant.png)
:::

::::
````

The id attributes (`#first-column` and `#second-column`) are optional, 
but aid readability.
```````

## File: docs/authoring/front-matter.qmd
```````
---
title: Front Matter
---

## Overview

Scholarly articles require much more detail in their front matter than simply a title and an author. Quarto provides a rich set of YAML metadata keys to describe these details. On this page, you'll learn how to specify authors and their affiliations, article summaries like an abstract and keywords, and how to include information on copyright, licensing and funding.

This YAML header includes examples of all the top level keys discussed on this page:

``` {.yaml filename="document.qmd"}
---
title: "Toward a Unified Theory of High-Energy Metaphysics: Silly String Theory"
date: 2008-02-29
author:
  - name: Josiah Carberry
    id: jc
    orcid: 0000-0002-1825-0097
    email: josiah@psychoceramics.org
    affiliation: 
      - name: Brown University
        city: Providence
        state: RI
        url: www.brown.edu
abstract: > 
  The characteristic theme of the works of Stone is 
  the bridge between culture and society. ...
keywords:
  - Metaphysics
  - String Theory
license: "CC BY"
copyright: 
  holder: Josiah Carberry
  year: 2008
citation: 
  container-title: Journal of Psychoceramics
  volume: 1
  issue: 1
  doi: 10.5555/12345678
funding: "The author received no specific funding for this work."
---
```

The documents produced by the above metadata for the HTML and JATS formats are shown below.

::: panel-tabset
## JATS

![](images/scholarly-front-matter-jats.png){fig-alt="Screenshot of the JATS preview from the document with the above metadata."}

## HTML

![](images/scholarly-front-matter-html.png){fig-alt="Screenshot of the HTML preview from the document with the above metadata."}
:::

Not all of the metadata keys are used in every format. However, the tags described on this page will generally be supported in [journal article formats](/docs/extensions/listing-journals.qmd). Currently the JATS format makes use of the broadest set of metadata tags, so if you want to check how things render we recommend previewing with `format: jats`.

## Authors & Affiliations {#authors-and-affiliations}

The simplest way to describe an author is with a string directly to the `author` key:

``` yaml
---
author: Norah Jones
---
```

However, the `author` key has a number of sub-keys that provide the additional detail required for scholarly articles. For instance, you can add an author's affiliation by using the `affiliation` key. In the simplest form, an author along with their affiliation can be described by passing a string to each of `name` and `affiliation`:

``` yaml
---
author:
  name: Norah Jones
  affiliation: Carnegie Mellon University
---
```

You can read about the other keys you can provide to `author` and `affiliation` in the corresponding [Author](#author) and [Affiliation](#affiliation) sections below.

Both `author` and `affiliation` can take multiple elements to describe multiple authors, or authors with multiple affiliations. As an example, here is the YAML to describe a document with two authors, the first of which has two affiliations:

``` yaml
---
author:
  - name: Norah Jones
    affiliation: 
      - Carnegie Mellon University
      - University of Chicago
  - name: Josiah Carberry
    affiliation: Brown University
---
```

Notice that each element of `author` and `affiliation` is prefaced by a `-` and indented appropriately. You can read more about shortcuts to avoid repetition when authors share affiliations in the [Multiple Authors](#multiple-authors) section below.

::: callout-note
## Singular or Plural?

Both of these keys can be specified using a singular (`author` and `affiliation`) or plural (`authors` and `affiliations`) form.
:::

### Author {#author}

Beyond `name` and `affiliation`, `author` can also take any of the following:

+----------------------+----------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| `email`\             | string         | Contact details for the author. Converted to hyperlinks in many formats.                                                                                            |
| `phone`\             |                |                                                                                                                                                                     |
| `fax`\               |                |                                                                                                                                                                     |
| `url`                |                |                                                                                                                                                                     |
+----------------------+----------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| `degrees`            | string(s)      | Academic titles or professional certifications displayed following a personal name.                                                                                 |
+----------------------+----------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| `orcid`              | string         | Author's Open Researcher and Contributor ID ([ORCID](https://orcid.org/)), in the form `0000-0000-0000-0000`. Creates a link to the author's ORCID in many formats. |
+----------------------+----------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| `note`\              | string         | Notes to attach to an author, such as contribution details;\                                                                                                        |
| `acknowledgements`   |                | Author's acknowledgements.                                                                                                                                          |
+----------------------+----------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| `roles`              | string(s)      | Author's roles. Read more in [Author Roles](#roles) below.                                                                                                          |
+----------------------+----------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| `corresponding`\     | `true`/`false` | Set this author as:\                                                                                                                                                |
| `equal-contributor`\ |                | the corresponding author;\                                                                                                                                          |
| `deceased`           |                | as having contributed equally with all other contributors;\                                                                                                         |
|                      |                | and/or deceased.                                                                                                                                                    |
+----------------------+----------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| `id`                 | string         | An identifier to be used to refer to this author in other fields. See an example in [Funding].                                                                      |
+----------------------+----------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------+

: Available keys to `author`

An `affiliations-url` key can also be provided to `author`, and will be propagated to the `url` key of `affiliation`.

As an example, a more complete description of an author might look like:

``` yaml
---
author:
  - name: Josiah Carberry
    orcid: 0000-0002-1825-0097
    url: https://en.wikipedia.org/wiki/Josiah_S._Carberry
    email: josiah@psychoceramics.org
    corresponding: true
---
```

#### Name Components

Quarto will automatically parse the `name` key into its components. However, if this parsing is incorrect you can specify the components, `given`, `family`, `dropping-particle`, and `non-dropping-particle` directly, for example:

``` yaml
---
author: 
  - name: 
      given: Charles
      family: Gaulle
      non-dropping-particle: de
  - name: 
      given: Ludwig
      family: Beethoven
      dropping-particle: van
---
```

#### Degrees

You may specify degrees or academic titles using the `degrees` field of authors:

``` yaml
author:
  - name: Josiah Carberry
    degrees: 
      - B.S.
      - PhD
```

#### Author Roles {#roles}

Use `roles` to describe an author's contributions to the work. You can use free form text as a string:

``` yaml
author:
  - name: Josiah Carberry
    roles: "Conceived and designed the study, analysed the results and wrote the manuscript."
```

Or alternatively, make use of the [Contributor Roles Taxonomy (CRediT)](https://credit.niso.org). To use CRediT roles provide one of the [14 contributor](#credit-roles) roles, e.g.:

``` yaml
author:
  - name: Josiah Carberry
    roles: conceptualization
```

Or, an array of roles:

``` yaml
author:
  - name: Josiah Carberry
    roles: [investigation, data curation]
```

Or specify the role along with a degree of contribution:

``` yaml
author:
  - name: Josiah Carberry
    roles: 
      - investigation: lead 
      - data curation: supporting
```

::: {#credit-roles .callout-tip collapse="true"}
## Expand to see the 14 Contributor Roles

+-------------------------------------------------------------------------------------------------+-------------+
| Value                                                                                           | Alias       |
+=================================================================================================+=============+
| [conceptualization](https://credit.niso.org/contributor-roles/conceptualization/)               |             |
+-------------------------------------------------------------------------------------------------+-------------+
| [data curation](https://credit.niso.org/contributor-roles/data-curation/)                       |             |
+-------------------------------------------------------------------------------------------------+-------------+
| [formal analysis](https://credit.niso.org/contributor-roles/formal-analysis/)                   | analysis    |
+-------------------------------------------------------------------------------------------------+-------------+
| [funding acquisition](https://credit.niso.org/contributor-roles/funding-acquisition/)           | funding     |
+-------------------------------------------------------------------------------------------------+-------------+
| [investigation](https://credit.niso.org/contributor-roles/investigation/)                       |             |
+-------------------------------------------------------------------------------------------------+-------------+
| [methodology](https://credit.niso.org/contributor-roles/methodology/)                           |             |
+-------------------------------------------------------------------------------------------------+-------------+
| [project administration](https://credit.niso.org/contributor-roles/project-administration/)     |             |
+-------------------------------------------------------------------------------------------------+-------------+
| [resources](https://credit.niso.org/contributor-roles/resources/)                               |             |
+-------------------------------------------------------------------------------------------------+-------------+
| [software](https://credit.niso.org/contributor-roles/software/)                                 |             |
+-------------------------------------------------------------------------------------------------+-------------+
| [supervision](https://credit.niso.org/contributor-roles/supervision/)                           |             |
+-------------------------------------------------------------------------------------------------+-------------+
| [validation](https://credit.niso.org/contributor-roles/validation/)                             |             |
+-------------------------------------------------------------------------------------------------+-------------+
| [visualization](https://credit.niso.org/contributor-roles/visualization/)                       |             |
+-------------------------------------------------------------------------------------------------+-------------+
| [writing – review & editing](https://credit.niso.org/contributor-roles/writing-review-editing/) | editing     |
+-------------------------------------------------------------------------------------------------+-------------+
| [writing – original draft](https://credit.niso.org/contributor-roles/writing-original-draft/)   | writing     |
+-------------------------------------------------------------------------------------------------+-------------+

: CRediT contributor values available in `roles`
:::

### Affiliation {#affiliation}

Like `author`, you can provide a string is directly to `affiliation`, as in:

``` yaml
---
author:
  name: Norah Jones
  affiliation: Carnegie Mellon University
---
```

Alternatively, you can provide the name explicitly to the `name` key, like:

``` yaml
---
author:
  name: Norah Jones
  affiliation: 
    name: Carnegie Mellon University
---
```

In addition to `name`, `affiliation` can take any of the following:

+----------------------+-----------+-----------------------------------------------------------------------------------------------------------------------------------------------+
| `department`         | String    |                                                                                                                                               |
+----------------------+-----------+-----------------------------------------------------------------------------------------------------------------------------------------------+
| `group`              | String    | Team or research group within the affiliation                                                                                                 |
+----------------------+-----------+-----------------------------------------------------------------------------------------------------------------------------------------------+
| `address`\           | String    | Affiliation's location. Provide one of `region` or `state`, and any combination of the other keys.                                            |
| `city`\              |           |                                                                                                                                               |
| `region` or `state`\ |           |                                                                                                                                               |
| `country`\           |           |                                                                                                                                               |
| `postal-code`        |           |                                                                                                                                               |
+----------------------+-----------+-----------------------------------------------------------------------------------------------------------------------------------------------+
| `url`                | String    | Affiliation's website. Converted to a link in many formats.                                                                                   |
+----------------------+-----------+-----------------------------------------------------------------------------------------------------------------------------------------------+
| \                    | \         | Affiliation IDs:\                                                                                                                             |
| `isni`\              | Numeric\  | 16 digit [International Standard Name Identifier (ISNI)](https://isni.org/);\                                                                 |
| `ringgold`\          | Numeric\  | 4-6 digit [Ringgold ID](https://www.ringgold.com/ringgold-identifier/);\                                                                      |
| `ror`                | String    | [Research Organization Registry (ROR) ID](https://ror.org/), starting with `https://ror.org/`, followed by a 9 digit alphanumeric identifier. |
+----------------------+-----------+-----------------------------------------------------------------------------------------------------------------------------------------------+

: Available keys to `affiliation`

For example, a more complete `affiliation` for an author might look like:

``` yaml
---
author:
  name: Josiah Carberry
  orcid: 0000-0002-1825-0097
  url: https://en.wikipedia.org/wiki/Josiah_S._Carberry
  email: josiah@psychoceramics.org
  corresponding: true
  affiliation: 
    - name: Brown University
      department: Psychoceramics
      city: Providence
      state: RI
      country: US
      url: www.brown.edu
      ringgold: 6752
      isni: 0000000419369094
---
```

### Multiple Authors {#multiple-authors}

When there are multiple authors of a document, it is common that they share affiliations. To avoid repeating an affiliation's details, you can describe an affiliation once, assign it an id, and then refer to the id in other fields.

One approach is to assign an `id` to each affiliation where they are described within an author. For example, here we assign the author's affiliations the ids `cmu` and `chicago`:

``` yaml
---
author:
  - name: Norah Jones
    affiliation:
      - id: cmu
        name: Carnegie Mellon University
      - id: chicago
        name: University of Chicago
---
```

Then, when adding additional authors, you can refer to affiliations using `ref:`:

``` yaml
---
author:
  - name: Norah Jones
    affiliation:
      - id: cmu
        name: Carnegie Mellon University
      - id: chicago
        name: University of Chicago
  - name: John Hamm
    affiliation:
      - ref: cmu
---
```

An alternative approach is to define affiliations at the top level, as opposed to within an `author`:

``` yaml
---
author:
  - name: Norah Jones
    affiliation:
      - ref: cmu
      - ref: chicago
  - name: John Hamm
    affiliation:
      - ref: cmu
affiliations:
  - id: cmu
    name: Carnegie Mellon University
  - id: chicago
    name: University of Chicago
---
```

This approach may be more convenient in cases where you also want to refer to affiliations in fields other than `author`, e.g. `funding`.

## Abstract

You can add an abstract with the `abstract` key. Since abstracts are generally longer than a line, and may contain markdown, you'll need to provide it using YAML's literal block style. That is, place a `|` on the same line as `abstract:` and indent your raw abstract text by two spaces.

For example:

``` yaml
---
abstract: |
  This article evaluates novel approaches to do
  some really important things.
---
```

## Keywords

Keywords can be added with `keywords`:

``` yaml
---
keywords: 
  - open-source 
  - scientific publishing
  - reproducible research
---
```

## Copyright

You can specify copyright in two ways. Either directly as a string to `copyright`:

``` yaml
---
copyright: "Copyright Acme, Inc. 2021. All Rights Reserved"
---
```

Which is equivalent to providing the same string to the `statement` sub-key:

``` yaml
---
copyright: 
  statement: "Copyright Acme, Inc. 2021. All Rights Reserved"
---
```

Or, alternatively, by specifying a `holder` and `year`:

``` yaml
---
copyright: 
  holder: Acme, Inc
  year: 2021
---
```

When specifying `year` you can also use a range (`year: 2021 - 2023`) or an array (`year: [2021, 2022, 2023]`).

## License

To specify a license, you can pass a string directly to `license`:

``` yaml
---
license: "This work is dedicated to the Public Domain"
---
```

This is equivalent to specifying the `text` sub-key directly:

``` yaml
---
license:
  text: "This work is dedicated to the Public Domain"
---
```

You can add additional details by providing the `type` and `url` sub-keys:

``` yaml
---
license:
  text: > 
    Permission is granted to copy, distribute and/or 
    modify this document under the terms of the GNU Free 
    Documentation License, Version 1.3 or any later version 
    published by the Free Software Foundation; with no 
    Invariant Sections, no Front-Cover Texts, and no 
    Back-Cover Texts. A copy of the license is included in 
    the section entitled "GNU Free Documentation License
  type: open-access
  url: https://www.gnu.org/licenses/fdl-1.3-standalone.html
---
```

If you are choosing a Creative Commons license you may simply pass an abbreviation:

``` yaml
---
license: "CC BY"
---
```

The available abbreviations are covered in the [Creative Commons](#cc) section below.

### Creative Commons {#cc}

The Creative Commons copyright licenses and tools forge a balance inside the traditional "all rights reserved" setting that copyright law creates. These tools give everyone from individual creators to large companies and institutions a simple, standardized way to grant copyright permissions to their creative work.

Here are some of the common forms of Creative Commons content license:

+---------------+--------------------------------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| License       | Name                                 | Description                                                                                                                                                                                                                                                                                                                                                                           |
+===============+======================================+=======================================================================================================================================================================================================================================================================================================================================================================================+
| `CC BY`       | Attribution                          | This license lets others distribute, remix, tweak, and build upon your work, even commercially, as long as they credit you for the original creation. This is the most accommodating of licenses offered.                                                                                                                                                                             |
+---------------+--------------------------------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| `CC BY-SA`    | Attribution-ShareAlike               | This license lets others remix, tweak, and build upon your work even for commercial purposes, as long as they credit you and license their new creations under the identical terms. This license is often compared to "copyleft" free and open source software licenses. All new works based on yours will carry the same license, so any derivatives will also allow commercial use. |
+---------------+--------------------------------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| `CC BY-ND`    | Attribution-NoDerivs                 | This license allows for redistribution, commercial and non-commercial, as long as it is passed along unchanged and in whole, with credit to you.                                                                                                                                                                                                                                      |
+---------------+--------------------------------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| `CC BY-NC`    | Attribution-NonCommercial            | This license lets others remix, tweak, and build upon your work non-commercially, and although their new works must also acknowledge you and be non-commercial, they don't have to license their derivative works on the same terms.                                                                                                                                                  |
+---------------+--------------------------------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| `CC BY-NC-SA` | Attribution-NonCommercial-ShareAlike | This license lets others remix, adapt, and build upon your work non-commercially, as long as they credit you and license their new creations under the identical terms. \|                                                                                                                                                                                                            |
+---------------+--------------------------------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| `CC BY-NC-ND` | Attribution-NonCommercial-NoDerivs   | This license is the most restrictive of the six main licenses, only allowing others to download your works and share them with others as long as they credit you, but they can't change them in any way or use them commercially.                                                                                                                                                     |
+---------------+--------------------------------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| `CC0`         |                                      | CC0 (aka CC Zero) is a public dedication tool, which enables creators to give up their copyright and put their works into the worldwide public domain. CC0 enables reusers to distribute, remix, adapt, and build upon the material in any medium or format, with no conditions.                                                                                                      |
+---------------+--------------------------------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+

If you specify a Creative Commons license for your content, Quarto will automatically include the relevant link to the appropriate license.

## Citation

The `citation` key allows you to specify additional metadata that is used to create a citation for the document. You can read more about this in [Creating Citeable Articles](/docs/authoring/create-citeable-articles.qmd).

## Funding

The `funding` key can directly take a string:

``` yaml
---
funding: "The author(s) received no specific funding for this work."
---
```

This is equivalent to providing the `statement` sub-key directly:

``` yaml
---
funding: 
  statement: "The author(s) received no specific funding for this work."
---
```

The `funding` key can also take the sub-keys `source`, `recipient` and `investigator`. Both `recipient` and `investigator` can take a string, or a reference to an author or affiliation using `ref:`. For example, this front matter adds funding where the investigator is specified using an author id:

``` yaml
---
author:
  - name: Norah Jones
    id: nj
funding:
  - source: "NIH (Grant #: 1-R01-MH99999-01A1)"
    investigator: 
      - ref: nj
---
```
```````

## File: docs/authoring/includes.qmd
```````
---
title: "Includes"
---

## Overview

Includes are a convenient way to re-use content across documents. Includes work for plain markdown content as well as for `.qmd` files with executable code cells (note however that the cells must all use the same engine -- i.e. knitr or jupyter, but not both).

To include a file, add the `{{{< include >}}}` shortcode at the location in your document where you want it included.

``` markdown
{{{< include _content.qmd >}}}
```

::: callout-important

Include shortcodes are equivalent to copying and pasting the text from the included file into the main file.
This means that relative references (links, images, other includes, etc.) inside the included file resolve based on the directory of the main file not the included file.
Use absolute (to the project root) paths for links, images, or other includes, in included files to ensure they resolve correctly, *e.g.*, `[A Figure Reused](/path/to/image.png)` or `{{< include /path/to/_file.qmd >}}`.

It also means that if the included file has a metadata block, that block will take effect in all included files. In most cases, having metadata blocks in an included file will cause unexpected behavior.

:::

::: callout-important

Include shortcodes need to appear by themselves in a line, and they need to be surrounded by empty lines. This means that you cannot use an include shortcode inside markdown syntax (such as an item in a bulleted list).

:::

## Content

A concrete example would be if you have several articles about a topic that share a common introduction. Here, we have an article titled "Revealjs Presentations" that wants to include some basic information on presentations not specific to Revealjs (we do that by including `_basics.qmd`). We also have some demo code stored as scripts that we want to include as non-executed examples (we do that by including `_demo.R` and `_demo.py` inside source code blocks):

```` markdown
---
title: "Revealjs Presentations"
---

## Overview

Revealjs Presentations are a great way to
present your ideas to others!

{{{< include _basics.qmd >}}}

## Revealjs Options

More content here...

## Do it yourself with R

```r 
{{{< include _demo.R >}}}
```

Copy the R code above in your session.

## Do it yourself with Python

```python
{{{< include _demo.py >}}}
```

Copy the Python code above and run it.


````

Note that we use an underscore (`_`) prefix for the included files. You should always use an underscore prefix with included files so that they are automatically ignored (i.e. not treated as standalone files) by a `quarto render` of a project.

## Computations

You can also include files with computational cells. For example, here we include a `.qmd` that does some data preprocessing that we want shared across multiple documents:

``` markdown
---
title: "My Document"
---

{{{< include _data.qmd >}}}


Use the data...
```

where the content would be 

````{.markdown filename="_data.qmd"}

Load the `sp500` from [`great_tables`](https://posit-dev.github.io/great-tables/)

```{{python}}
import great_tables as gt
from great_tables.data import sp500
sp500.head()
```

````

A couple of important things to remember when using computational includes:

1)  All computations still share a single engine (e.g. knitr or jupyter)

2)  Computational includes work only in `.qmd` files (they don't work in `.ipynb` notebook files)

Note that you can't use  the `include` shortcode within a computational code block itself - as the example above shows, the executable code block needs to be inside the included document.

```{=html}
<style type="text/css">
code span.in {
  font-style:  normal;
}
</style>
```
```````

## File: docs/authoring/language.qmd
```````
---
title: "Document Language"
---

## Overview

Document language plays a role in Pandoc's processing of most formats, and controls hyphenation in PDF output when using LaTeX (through [`babel`](https://ctan.org/pkg/babel) and [`polyglossia`](https://ctan.org/pkg/polyglossia)) or ConTeXt.

Additonally, Quarto, Pandoc, and LaTeX will sometimes generate textual output that requires localization. For example, "Figure" or "List of Figures" for cross references, callout captions like "Note" or "Warning", or the "Code" caption for folded code chunks.

## `lang` Option

The [`lang`](https://pandoc.org/MANUAL.html#language-variables) document option identifies the main language of the document using IETF language tags (following the [BCP 47](https://tools.ietf.org/html/bcp47) standard), such as `en` or `en-GB`. The [Language subtag lookup](https://r12a.github.io/app-subtags/) tool can look up or verify these tags.

For example, this document specifies the use of French:

``` yaml
---
title: "My Document"
lang: fr    
---
```

This will result in the use of French translations as well as the application of other language specific rules to document processing. The following languages currently have full translations available:

-   English (`en`, used by default)
-   Chinese (`zh`)
-   Spanish (`es`)
-   French (`fr`)
-   Japanese (`ja`)
-   German (`de`)
-   Portuguese (`pt`)
-   Russian (`ru`)
-   Czech (`cs`)
-   Finnish (`fi`)
-   Dutch (`nl`)
-   Italian (`it`)
-   Polish (`pl`)
-   Korean (`ko`)

## Alternate Language

If you aren't happy with the default language used for a given part of a document you can provide alternate language via the `language` key (this can be used at a document or project level). For example, to override the values for the "Author" and "Published" captions used within title blocks you could do this:

``` yaml
---
title: "My Document"
author: "Norah Jones"
date: 5/22/2022
language: 
  title-block-author-single: "Writer"
  title-block-published: "Updated"
---
```

As described below, you can also provide these translations in a standalone YAML file and reference it as follows:

``` yaml
---
title: "My Document"
author: "Norah Jones"
date: 5/22/2022
language: custom.yml
---
```

You can discover all of the `language` values that can be customized by referencing this file: <https://github.com/quarto-dev/quarto-cli/blob/main/src/resources/language/_language.yml>.

### Per-Language Alternates

Alternate values can be restricted to a particular target language using subkeys of the `language` key. This way, distinct values can be defined for each language. For example, you can override the English and French versions of the "Published" caption:

``` yaml
---
title: "My Document"
author: "Norah Jones"
date: 5/22/2022
lang: fr
language:
  en:
    title-block-published: "Updated"
  fr:
    title-block-published: "Mis à jour"
---
```

In this case the French "Mis à jour" will be used since `lang` is set to `fr`.

These language-specific alternate values can also be provided in a standalone YAML file. For example, the following file could be used by setting `language: custom-language.yml` in the metadata:

``` {.yaml filename="custom-language.yml"}
en:
  title-block-published: "Updated"
fr:
  title-block-published: "Mis à jour"
```

## Custom Translations

You can create and use a custom translation for a new language not supported by Quarto as follows:

1.  Make a copy of the default `_language.yml` file (<https://github.com/quarto-dev/quarto-cli/blob/main/src/resources/language/_language.yml>).

2.  Provide translations from the default English values.

3.  Specify the custom translation file using the `language` option. For example:

    ``` yaml
    ---
    language: custom.yml
    ---
    ```

The `language` option can be specified at a project or document level. Additionally, if you include a `_language.yml` file in the root of your project alongside your `_quarto.yml` config file it will be automatically used.

If you create a language translation file please consider contributing it so others can benefit from it. See the documentation on [contributing language translations](https://github.com/quarto-dev/quarto-cli/tree/main/src/resources/language) for additional details.
```````

## File: docs/authoring/lipsum.qmd
```````
---
title: Adding Placeholder Text to Your Documents
aliases:
  - /docs/prerelease/1.5/lipsum.html
---

## Overview

When you need to visualize how text will look in your document or your website, the `{{{< lipsum >}}}` shortcode comes in handy.
It inserts "Lorem Ipsum" dummy text, which is standard placeholder text used in the publishing and design industries.

## Example

Here's an example of `lipsum` generating two paragraphs of text, by adding `{{{< lipsum 2 >}}}` in a paragraph by itself.

{{< lipsum 2 >}}

## Usage

::: {layout-ncol=1}
```markdown
{{{< lipsum 1 >}}}
```
:::: {.border}
{{< lipsum 1 >}}
::::
:::

`lipsum` takes an optional parameter, in two possible formats:

- `{{{< lipsum nparas >}}}`: `nparas` describes the number of paragraphs of placeholder text to include in the document. 
- `{{{< lipsum start-end >}}}`: `start` and `end` are two numbers that describe the range of lorem ipsum paragraphs to include in the document.

`lipsum` produces placeholder text in a predictable manner[^1]. This means that the same parameters will always yield identical text.
However, you can choose to set `random=true` to generate a paragraph or a random collection of paragraphs.


- `{{{< lipsum 1 random=true >}}}`: This will generate a single paragraph of random lorem ipsum text.

[^1]: Since Quarto 1.7.14. Earlier versions of Quarto generate random text.
```````

## File: docs/authoring/markdown-basics.qmd
```````
---
title: Markdown Basics
format: html
language: 
  section-title-footnotes: Example Footnotes
aliases: 
  - /docs/authoring/
---

## Overview

Quarto is based on Pandoc and uses its variation of markdown as its underlying document syntax. Pandoc markdown is an extended and slightly revised version of John Gruber's [Markdown](https://daringfireball.net/projects/markdown/) syntax.

Markdown is a plain text format that is designed to be easy to write, and, even more importantly, easy to read:

> A Markdown-formatted document should be publishable as-is, as plain text, without looking like it's been marked up with tags or formatting instructions. -- [John Gruber](https://daringfireball.net/projects/markdown/syntax#philosophy)

This document provides examples of the most commonly used markdown syntax. See the full documentation of [Pandoc's Markdown](https://pandoc.org/MANUAL.html#pandocs-markdown) for more in-depth documentation.

## Text Formatting

+-----------------------------------------+-----------------------------------------+
| Markdown Syntax                         | Output                                  |
+=========================================+=========================================+
| ``` markdown                            | *italics*, **bold**, ***bold italics*** |
| *italics*, **bold**, ***bold italics*** |                                         |
| ```                                     |                                         |
+-----------------------------------------+-----------------------------------------+
| ``` markdown                            | superscript^2^ / subscript~2~           |
| superscript^2^ / subscript~2~           |                                         |
| ```                                     |                                         |
+-----------------------------------------+-----------------------------------------+
| ``` markdown                            | ~~strikethrough~~                       |
| ~~strikethrough~~                       |                                         |
| ```                                     |                                         |
+-----------------------------------------+-----------------------------------------+
| ``` markdown                            | `verbatim code`                         |
| `verbatim code`                         |                                         |
| ```                                     |                                         |
+-----------------------------------------+-----------------------------------------+

## Headings {#headings}

+------------------+-----------------------------------+
| Markdown Syntax  | Output                            |
+==================+===================================+
| ``` markdown     | # Heading 1 {.heading-output}     |
| # Heading 1      |                                   |
| ```              |                                   |
+------------------+-----------------------------------+
| ``` markdown     | ## Heading 2 {.heading-output}    |
| ## Heading 2     |                                   |
| ```              |                                   |
+------------------+-----------------------------------+
| ``` markdown     | ### Heading 3 {.heading-output}   |
| ### Heading 3    |                                   |
| ```              |                                   |
+------------------+-----------------------------------+
| ``` markdown     | #### Heading 4 {.heading-output}  |
| #### Heading 4   |                                   |
| ```              |                                   |
+------------------+-----------------------------------+
| ``` markdown     | ##### Heading 5 {.heading-output} |
| ##### Heading 5  |                                   |
| ```              |                                   |
+------------------+-----------------------------------+
| ``` markdown     | ###### Heading 6 {.heading-output}|
| ###### Heading 6 |                                   |
| ```              |                                   |
+------------------+-----------------------------------+

: {tbl-colwidths="[50, 50]"}

```{=html}
<style type="text/css">
.heading-output {
  border-bottom: none;
  margin-top: 0;
  margin-bottom: 0;
}
</style>
```
## Links & Images

+--------------------------------------------------------------+--------------------------------------------------------------------------------------------------------+
| Markdown Syntax                                              | Output                                                                                                 |
+==============================================================+========================================================================================================+
| ``` markdown                                                 | <https://quarto.org>                                                                                   |
| <https://quarto.org>                                         |                                                                                                        |
| ```                                                          |                                                                                                        |
+--------------------------------------------------------------+--------------------------------------------------------------------------------------------------------+
| ``` markdown                                                 | [Quarto](https://quarto.org)                                                                           |
| [Quarto](https://quarto.org)                                 |                                                                                                        |
| ```                                                          |                                                                                                        |
+--------------------------------------------------------------+--------------------------------------------------------------------------------------------------------+
| ``` markdown                                                 | ![Caption](elephant.png){fig-alt="A line drawing of an elephant."}                                     |
| ![Caption](elephant.png)                                     |                                                                                                        |
| ```                                                          |                                                                                                        |
+--------------------------------------------------------------+--------------------------------------------------------------------------------------------------------+
| ``` markdown                                                 | [![Caption](elephant.png)](https://quarto.org)                                                         |
| [![Caption](elephant.png)](https://quarto.org)               |                                                                                                        |
| ```                                                          |                                                                                                        |
+--------------------------------------------------------------+--------------------------------------------------------------------------------------------------------+
| ``` markdown                                                 | [![Caption](elephant.png "An elephant"){fig-alt="A line drawing of an elephant."}](https://quarto.org) |
| [![Caption](elephant.png "An elephant")](https://quarto.org) |                                                                                                        |
| ```                                                          |                                                                                                        |
+--------------------------------------------------------------+--------------------------------------------------------------------------------------------------------+
| ``` markdown                                                 | [![](elephant.png){fig-alt="A line drawing of an elephant."}](https://quarto.org)                      |
| [![](elephant.png){fig-alt="Alt text"}](https://quarto.org)  |                                                                                                        |
| ```                                                          |                                                                                                        |
+--------------------------------------------------------------+--------------------------------------------------------------------------------------------------------+

## Lists

+-----------------------------------+---------------------------------+
| Markdown Syntax                   | Output                          |
+===================================+=================================+
| ``` markdown                      |                                 |
| * unordered list                  | * unordered list                |
|   + sub-item 1                    |   + sub-item 1                  |
|   + sub-item 2                    |   + sub-item 2                  |
|     - sub-sub-item 1              |     - sub-sub-item 1            |
| ```                               |                                 |
+-----------------------------------+---------------------------------+
| ``` markdown                      |                                 |
| *   item 2                        | -   item 2                      |
|                                   |                                 |
|     Continued (indent 4 spaces)   |     Continued (indent 4 spaces) |
| ```                               |                                 |
+-----------------------------------+---------------------------------+
| ``` markdown                      |                                 |
| 1. ordered list                   |  1. ordered list                |
| 2. item 2                         |  2. item 2                      |
|    i) sub-item 1                  |     i) sub-item 1               |
|       A.  sub-sub-item 1          |        A.  sub-sub-item 1       |
| ```                               |                                 |
+-----------------------------------+---------------------------------+
| ```` markdown                     |                                 |
| 1. ordered list                   |  1. ordered list                |
| 2. item 2                         |  2. item 2                      |
|                                   |                                 |
|    ```python                      |     ```python                   |
|    print("Hello, World!")         |     print("Hello, World!")      |
|    ```                            |     ```                         |
|                                   |                                 |
|    A.  sub-sub-item 1             |     A.  sub-sub-item 1          |
| ````                              |                                 |
+-----------------------------------+---------------------------------+
| ``` markdown                      |                                 |
| - [ ] Task 1                      | - [ ] Task 1                    |
| - [x] Task 2                      | - [x] Task 2                    |
| ```                               |                                 |
+-----------------------------------+---------------------------------+
| ``` markdown                      |                                 |
| (@)  A list whose numbering       |  (1) A list whose numbering     |
|                                   |                                 |
| continues after                   |  continues after                |
|                                   |                                 |
| (@)  an interruption              |  (2) an interruption            |
| ```                               |                                 |
+-----------------------------------+---------------------------------+
| ``` markdown                      |                                 |
| ::: {}                            | ::: {}                          |
| 1. A list                         | 1. A list                       |
| :::                               | :::                             |
|                                   |                                 |
| ::: {}                            | ::: {}                          |
| 1. Followed by another list       | 1. Followed by another list     |
| :::                               | :::                             |
| ```                               |                                 |
+-----------------------------------+---------------------------------+
| ``` markdown                      |                                 |
| term                              | term                            |
| : definition                      | : definition                    |
| ```                               |                                 |
+-----------------------------------+---------------------------------+

Note that unlike other Markdown renderers (notably Jupyter and GitHub), lists in Quarto require an entire blank line above the list. Otherwise the list will not be rendered in list form, rather it will all appear as normal text along a single line.

## Footnotes

Pandoc supports numbering and formatting footnotes using the following syntax:

``` markdown
Here is a footnote reference,[^1] and another.[^longnote]

[^1]: Here is the footnote.

[^longnote]: Here's one with multiple blocks.

    Subsequent paragraphs are indented to show that they
belong to the previous footnote.

        { some.code }

    The whole paragraph can be indented, or just the first
    line.  In this way, multi-paragraph footnotes work like
    multi-paragraph list items.

This paragraph won't be part of the note, because it
isn't indented.
```

The above syntax generates the following output:

:::{.border .p-3}
Here is a footnote reference,[^1] and another.[^2]

This paragraph won't be part of the note, because it isn't indented.
:::

In addition, you can also write single paragraph footnotes inline using the following syntax:

``` markdown
Here is an inline note.^[Inlines notes are easier to write,
since you don't have to pick an identifier and move down to
type the note.]
```

This syntax generates the following output:

::: {.border .p-3}
Here is an inline note.[^3]
:::

::: {.callout-note}

## Footnote IDs should be unique

Footnote identifiers, e.g., the `1` in `^1`, need to be unique within a document. 
In Quarto books, chapters are combined into a single document for certain formats (including PDF, DOCX, and EPUB),
so footnote identifiers need to be unique **across** chapters. 

:::

The footnotes that are generated from the above examples are included in the [Example Footnotes](#example-footnotes) section at the bottom of the page. See the [Pandoc Footnotes](https://pandoc.org/MANUAL.html#footnotes) for additional information.

[^1]: Here is the footnote.

[^2]: Here's one with multiple blocks.

    Subsequent paragraphs are indented to show that they belong to the previous footnote.

        { some.code }

    The whole paragraph can be indented, or just the first line. In this way, multi-paragraph footnotes work like multi-paragraph list items.

[^3]: Inlines notes are easier to write, since you don't have to pick an identifier and move down to type the note.


## Tables

#### Markdown Syntax

``` markdown
| Right | Left | Default | Center |
|------:|:-----|---------|:------:|
|   12  |  12  |    12   |    12  |
|  123  |  123 |   123   |   123  |
|    1  |    1 |     1   |     1  |
```

#### Output

| Right | Left | Default | Center |
|------:|:-----|---------|:------:|
|    12 | 12   | 12      |   12   |
|   123 | 123  | 123     |  123   |
|     1 | 1    | 1       |   1    |

Learn more in the article on [Tables](tables.qmd).

## Source Code

Use ```` ``` ```` to delimit blocks of source code:

```` markdown
```
code
```
````

Add a language to syntax highlight code blocks:

```` markdown
```python
1 + 1
```
````

Pandoc supports syntax highlighting for over [140 different languages](https://github.com/jgm/skylighting/tree/master/skylighting-core/xml). If your language is not supported then you can use the `default` language to get a similar visual treatment:

```` markdown
```default
code
```
````

Equivalent to the short form used in the examples above is a longer form that uses the language as a class (i.e. `.python`) inside braces:

```` markdown
```{.python}
1 + 1
```
````

The longer form allows you to add attributes to the block in a similar way to [Divs](#sec-divs-and-spans).  Some specific features that use this syntax are [Lines Numbers](/docs/output-formats/html-code.qmd#line-numbers) and [Code Filename](/docs/output-formats/html-code.qmd#code-filename). Here is an example of the latter:

```` markdown
```{.python filename="run.py"}
code
```
````

If you are creating HTML output there is a wide variety of options available for code block output. See the article on [HTML Code](/docs/output-formats/html-code.qmd) for additional details.

## Raw Content

Raw content can be included directly without Quarto parsing it using [Pandoc's raw attribute](https://pandoc.org/MANUAL.html#extension-raw_attribute). A raw block starts with ` ```{=` followed by a format and closing `}`, e.g. here's a raw HTML block:

```` markdown
```{=html}
<iframe src="https://quarto.org/" width="500" height="400"></iframe>
```
````

For PDF output use a raw LaTeX block:

```` markdown
```{=latex}
\renewcommand*{\labelitemi}{\textgreater}
```
````

As another example, if you are using the [Typst format](/docs/output-formats/typst.qmd) you can use a raw block to include Typst syntax:

```` markdown
```{=typst} 
#set text(fill: red)
This text is red.
```
````

You can also include raw content inline:
```markdown
 Here's some raw inline HTML: `<a>html</a>`{=html}
```

## Equations

Use `$` delimiters for inline math and `$$` delimiters for display math. For example:

+---------------------------+-------------------------+
| Markdown Syntax           | Output                  |
+===========================+=========================+
| ``` markdown              |                         |
| inline math: $E = mc^{2}$ | inline math: $E=mc^{2}$ |
| ```                       |                         |
+---------------------------+-------------------------+
| ``` markdown              |                         |
| display math:             | display math:           |
|                           |                         |
| $$E = mc^{2}$$            | $$E = mc^{2}$$          |
| ```                       |                         |
+---------------------------+-------------------------+

If you want to define custom TeX macros, include them within `$$` delimiters enclosed in a `.hidden` block. For example:

``` tex
::: {.hidden}
$$
 \def\RR{{\bf R}}
 \def\bold#1{{\bf #1}}
$$
:::
```

For HTML math processed using [MathJax](https://docs.mathjax.org/) (the default) you can use the `\def`, `\newcommand`, `\renewcommand`, `\newenvironment`, `\renewenvironment`, and `\let` commands to create your own macros and environments.  

## Diagrams

Quarto has native support for embedding [Mermaid](https://mermaid-js.github.io/mermaid/#/) and [Graphviz](https://graphviz.org/) diagrams. This enables you to create flowcharts, sequence diagrams, state diagrams, Gantt charts, and more using a plain text syntax inspired by markdown.

For example, here we embed a flowchart created using Mermaid:

```{mermaid}
%%| echo: fenced
flowchart LR
  A[Hard edge] --> B(Round edge)
  B --> C{Decision}
  C --> D[Result one]
  C --> E[Result two]
```

Learn more in the article on [Diagrams](diagrams.qmd).

## Videos

You can include videos in documents using the `{{{< video >}}}` [shortcode](shortcodes.qmd). For example, here we embed a YouTube video:

``` {.markdown shortcodes="false"}
{{< video https://www.youtube.com/embed/wo9vZccmqwc >}}
```

Videos can refer to video files (e.g. MPEG) or can be links to videos published on YouTube, Vimeo, or Brightcove. Learn more in the article on [Videos](videos.qmd).

{{< include _pagebreak.qmd >}}

## Divs and Spans {#sec-divs-and-spans}

You can add classes, attributes, and other identifiers to regions of content using Divs and Spans.
Although the terms *Div* and *Span* originate in HTML, the syntax is used in Quarto across output formats.
For example, [Callout Blocks](#callout-blocks) are specified using the div syntax, and [Small Caps](#other-spans) are specified using the span syntax, and both work for many formats beyond HTML.
You may also use CSS and/or a [Filter](/docs/extensions/filters.qmd) along with Divs and Spans to provide styling or other behavior within rendered documents beyond what Quarto provides.

### Divs

For example, here we add the "border" class to a region of content using a div (`:::`):

``` markdown
::: {.border}
This content can be styled with a border
:::
```

Once rendered to HTML, Quarto will translate the markdown into:

``` html
<div class="border">
  <p>This content can be styled with a border</p>
</div>
```

Divs start with a fence containing at least three consecutive colons plus some attributes. The attributes may optionally be followed by another string of consecutive colons. The Div ends with another line containing a string of at least three consecutive colons. The Div should be separated by blank lines from preceding and following blocks. Divs may also be nested. For example

``` markdown
::::: {#special .sidebar}

::: {.warning}
Here is a warning.
:::

More content.
:::::
```

Once rendered to HTML, Quarto will translate the markdown into:

``` html
<div id="special" class="sidebar">
  <div class="warning">
    <p>Here is a warning.</p>
  </div>
  <p>More content.</p>
</div>
```

Fences without attributes are always closing fences. Unlike with fenced code blocks, the number of colons in the closing fence need not match the number in the opening fence. However, it can be helpful for visual clarity to use fences of different lengths to distinguish nested divs from their parents.

### Spans 

A bracketed sequence of inlines, as one would use to begin a link, will be treated as a `Span` with attributes if it is followed immediately by attributes:

``` markdown
[This is *some text*]{.class key="val"}
```

Once rendered to HTML, Quarto will translate the markdown into:

``` html
<span class="class" data-key="val">
  This is <em>some text</em>
</span>
```

### Ordering of Attributes

Both divs and spans in Pandoc can have any combination of identifiers, classes, and (potentially many) key-value attributes. In order for these to be recognized by Pandoc, they have to be provided in a specific order: identifiers, classes, and then key-value attributes. Any of these can be omitted, but must follow that order if they are provided. For example, the following is valid:

``` markdown
[This is good]{#id .class key1="val1" key2="val2"}
```

However, the following *will not be recognized by Pandoc*:

``` markdown
[This does *not* work!]{.class key="val" #id}
```

This ordering restriction applies to both divs and spans. See Pandoc's documentation on [Divs and Spans](https://pandoc.org/MANUAL.html#divs-and-spans) for additional details.

## Callout Blocks

#### Markdown Syntax

``` markdown
:::{.callout-note}
Note that there are five types of callouts, including: 
`note`, `tip`, `warning`, `caution`, and `important`.
:::
```

#### Output

::: callout-note
Note that there are five types of callouts, including `note`, `tip`, `warning`, `caution`, and `important`.
:::

Learn more in the article on [Callout Blocks](callouts.qmd).

## Other Blocks

+--------------------------+--------------------------+
| Markdown Syntax          | Output                   |
+==========================+==========================+
| ``` markdown             | > Blockquote             |
| > Blockquote             |                          |
| ```                      |                          |
+--------------------------+--------------------------+
| ``` markdown             | ::: classname            |
| ::: {.classname}         | Div                      |
| Div                      | :::                      |
| :::                      |                          |
| ```                      |                          |
+--------------------------+--------------------------+
| ``` markdown             | | Line Block             |
| | Line Block             | |    Spaces and newlines |
| |   Spaces and newlines  | |    are preserved       |
| |   are preserved        |                          |
| ```                      |                          |
+--------------------------+--------------------------+

## Other Spans {#other-spans}

To create text in small caps, that is underlined, or that is highlighted, use a span with one of the 
classes `.smallcaps`, `.underline` or `.mark` respectively.

+----------------------------------------+-------------------------------------------+
| Markdown Syntax                        | Output                                    |
+========================================+===========================================+
| ``` markdown                           | [This text is smallcaps]{.smallcaps}      |
| [This text is smallcaps]{.smallcaps}   |                                           |
| ```                                    |                                           |
+----------------------------------------+-------------------------------------------+
| ``` markdown                           | [This text is underlined]{.underline}     |
| [This text is underlined]{.underline}  |                                           |
| ```                                    |                                           |
+----------------------------------------+-------------------------------------------+
| ``` markdown                           | [This text is highlighted]{.mark}         |
| [This text is highlighted]{.mark}      |                                           |
| ```                                    |                                           |
+----------------------------------------+-------------------------------------------+

::: {.callout-note}

## In supported formats only

Support for these classes comes directly from Pandoc. 
Not all formats support all of these classes. 
In particular, `.mark` is not currently supported in `format: pptx`.

:::

## Special Characters

+-----------------+---------------+
| Markdown Syntax | Output        |
+=================+===============+
| ``` markdown    | endash: --    |
| endash: --      |               |
| ```             |               |
+-----------------+---------------+
| ``` markdown    | emdash: ---   |
| emdash: ---     |               |
| ```             |               |
+-----------------+---------------+

## Keyboard Shortcuts {#keyboard-shortcuts}

{{< include _kbd.qmd >}}
```````

## File: docs/authoring/notebook-embed.qmd
```````
---
title: Embedding from Other Documents
aliases:
  - /docs/prerelease/1.3/embed.html
---

{{< include ../_require-1.4.qmd >}}

## Overview

You can include the output of another Quarto document (`.qmd` or `.ipynb`) with the `embed` shortcode. To embed the output of a code block or notebook cell, provide the path to document and an identifier for the block or cell. For example, this Jupyter notebook called `penguins.ipynb` has a cell labelled `fig-bill-scatter`:

![](images/notebook-simple.png){fig-alt="A screenshot of a Jupyter Notebook with the name 'penguins.ipynb', with a cell highlighted that has the code chunk option label set to fig-bill-scatter. Below the cell is the resulting plot." width=80%}

You can use the following shortcode to embed the output of this cell:

```{.markdown shortcodes=false}
{{< embed penguins.ipynb#fig-bill-scatter >}}
```

This will embed the plot as follows:

{{< embed penguins.ipynb#fig-bill-scatter >}}

A link to the source notebook is automatically provided beneath the plot. Following the link takes users to a rendered version of the notebook, allowing them to explore the notebook without having to download and run it locally. For example, clicking on the link to `penguins.ipynb` gets you to a page that looks like the following:

![](images/notebook-view.png){.border fig-alt="A screenshot of webpage with the title 'penguins.ipynb', a large blue button labelled 'Download Notebook', followed by the notebook contents."}

You can embed output to and from both Jupyter Notebooks (`.ipynb`) and Quarto documents (`.qmd`). In this article, we'll refer to the source document generically as a *notebook*.

Beyond this basic usage, you can also:

-   Specify cells or blocks in multiple ways, see [Specifying Cells](#specifying-cells).

-   Control the output using code cell options in the source notebook, including things like figure captions, figure layout, and code display, see [Code Cell Options](#code-cell-options).

-   Include the code along with the output by adding an `echo` option to the shortcode, see [Embedding Code](#embedding-code).

-   Customize or exclude the link to the source notebook, see [Links to Source Notebooks](#linked-source-notebooks).

## Specifying Cells {#specifying-cells}

The `embed` shortcode specifies source notebooks using a relative path followed by a cell or code block identifier (e.g. `penguins.ipynb#fig-bill-scatter`). If the identifier is omitted, all of the cells or code blocks in the notebook will be embedded in the document.

### Quarto Documents

When the source is a Quarto document (`.qmd`), use the `label` of the code block as the identifier. For example, if the source document `penguins.qmd` contained the following code block:

````{.markdown filename="penguins.qmd"}
```{{r}}
#| label: fig-size-scatter
ggplot(penguins, aes(body_mass_g, flipper_length_mm)) +
  geom_point(aes(color = species)) +
  scale_color_manual(values = colors) +
  theme_minimal()
```
````

You would embed the output of that block with:

```{.markdown shortcodes=false}
{{< embed penguins.qmd#fig-size-scatter >}}
```

Which results in the following output:

{{< embed penguins-qmd.qmd#fig-size-scatter >}}


### Jupyter Notebooks

When the source is a Jupyter Notebook, the identifier used to locate the proper cell follows these heuristics:

1.  **Cell `id`**\
    First, the cell metadata will be checked for a matching `id`. ([Cell IDs](https://jupyter.org/enhancement-proposals/62-cell-id/cell-id.html) are a newer feature of Jupyter Notebooks that are not yet well supported in Jupyter front ends, but `id` is checked first to allow for future compatibility as they become more common).
2.  **Label**\
    If no cell with a matching `id` is found, Quarto will use a cell that has a `label` in the code metadata which matches the cell identifier.
3.  **Tags**\
    If no cell has been found, Quarto will use a cell or cell(s) whose tag matches the cell identifier.

#### Cell Tags

For example, to embed the output of a cell that you have given the tag `bill-ratio` within Jupyter Lab:

![](images/notebook-tag.png){.border fig-alt="Screenshot of a code cell in a Jupyter Notebook with the cell tags open in the cell toolbar and displaying the tag 'bill-ratio'." width=80%}

You would use the following embed:

```{.markdown shortcodes=false}
{{< embed penguins.ipynb#bill-ratio >}}
```

Which results in the following output:

{{< embed penguins.ipynb#bill-ratio >}}

## Code Cell Options {#code-cell-options}

Code cell options from the source notebook are propagated to the document in which they are embedded. For instance, you may specify code cell options like `fig-cap`, `fig-alt` and `layout-ncol`, to control aspects of embedded figures. For example, this cell in `penguins.ipynb` specifies figure options including a caption, sub-caption, alt text and layout:

```{.python filename="penguins.ipynb"}
#| label: fig-bill-marginal
#| fig-cap: "Marginal distributions of bill dimensions"
#| fig-subcap: 
#|   - "Gentoo penguins tend to have thinner bills,"
#|   - "and Adelie penguins tend to have shorter bills."
#| fig-alt:
#|   - "Density plot of bill depth by species."
#|   - "Density plot of bill length by species."
#| layout-ncol: 2

sns.displot(penguins, 
            x = "bill_depth_mm", 
            hue = "species", 
            kind = "kde", fill = True, aspect = 2, height = 3)
plt.show()
sns.displot(penguins, 
            x = "bill_length_mm", 
            hue = "species", 
            kind = "kde", fill = True, aspect = 2, height = 3)
plt.show()
```

When this cell is embedded:

```{.markdown shortcodes=false}
{{< embed penguins.ipynb#fig-bill-marginal >}}
```

The following output is produced:

{{< embed penguins.ipynb#fig-bill-marginal >}}

## Embedding Code {#embedding-code}

You may include the code from a cell or block along with the output by using the `echo=true` option to the `embed` shortcode. For example, to include the code and the plot from the cell labelled `species-counts` in `penguins.ipynb` the embed would be:

```{.markdown shortcodes=false}
{{< embed penguins.ipynb#species-counts echo=true >}}
```

The result in the document is both the code and output for the cell:

{{< embed penguins.ipynb#species-counts echo=true >}}

Like figure options, options for displaying the code will propagate from the source notebook. For example, to fold the code for this cell, you could add `code-fold: true` to the options for the `species-counts` cell:

```{.python filename="penguins.ipynb"}
#| label: species-counts
#| code-fold: true
penguins.groupby("species").size().reset_index(name = "count")
```

The options set in the YAML header for the document in which these cells are embedded will also control these code cells. For example, to fold all the code, including the code embedded from `penguins.ipynb`, you could add `code-fold: true` to the document YAML:

```{.yaml filename="sample.qmd"}
title: Exploration of penguin characteristics
author: Norah Jones
toc: true
format:
  html:
    code-fold: true
```

## Links to Source Notebooks {#linked-source-notebooks}

When you embed the contents of notebooks in a Quarto document and render the document to HTML, Quarto will automatically include links to the source notebooks that provided the embedded content. These links will by default appear both inline below the embedded content, as well as below the table of contents. For example, the following document embeds content from the notebook `penguins.ipynb`. You can see the links in the rendered HTML document below:

![](images/notebook-links.png){.border fig-alt="Screenshot of a rendered page with an embedded plot. A link to the Source 'penguins.ipynb' is shown directly below the plot. A similar link is shown below the table of contents under the heading 'Notebooks'."}

### Link Placement

You can control the placement of the links to source notebooks by specifying the option `notebook-links`{spellcheck="false"} in the document YAML with one of the following values:

`true`{spellcheck="false"} (default)

:   Display links to source notebooks inline below the embedded content, and alongside the table of contents.

`false`{spellcheck="false"}

:   Do not display any links to source notebooks.

`inline`{spellcheck="false"}

:   Display only the links inline below the embedded content.

`global`{spellcheck="false"}

:   Display only the links alongside the table of contents. 

### Notebook Views

By default, the link to the source notebook goes to an automatically generated HTML render of the notebook. This makes it easier for users to view the notebook contents without needing to download and run the notebook locally. This notebook view displays the contents of the notebook and includes a button to download the notebook.  For example:

![](images/notebook-view.png){.border fig-alt="A screenshot of webpage with the title 'penguins.ipynb', a large blue button labelled 'Download Notebook', followed by the notebook contents."}

As an example, you can view the live previews for the [`penguins.ipynb` notebook](penguins-preview.html) and [`penguins.qmd` notebook](penguins-qmd.embed-preview.html) used in this document.

### View Options

You can control the behavior of notebook views using `notebook-view`. For each source notebook, you can provide a `title` and a `url`. The `title` will be used as the text of the any links to the source notebook and will also appear at the top of the rendered notebook view. The `url`, if provided, will be used as the `href` of any links to the source notebook. This is useful if you have deployed a copy of the source notebook to a site like Github, Google Colab, or Kaggle and would rather link to that instead.

For example:

``` {.markdown style="whitespace: pre-wrap;"}
notebook-view:
  - notebook: penguins.ipynb
    title: "Plots and Computations"
    url: https://colab.research.google.com/drive/12GsIPQ644SI4vkEEHiZn-Qqfbr-bD1__
```

will result in links to the source notebook like so:

![](images/notebook-links-updated.png){.border fig-alt="Screenshot of a rendered page with an embedded plot. A link to the Source 'Plots and Computations' is shown directly below the plot. A similar link is shown below the table of contents under the heading 'Notebooks'."}

To disable the notebook views, and instead link directly to the notebook (so the user may download the notebook with no intermediary view), set `notebook-view` to `false`.
```````

## File: docs/authoring/penguins-qmd.qmd
```````
---
title: "Palmer Penguins (.qmd)"
---

```{r}
library(tidyverse)
library(palmerpenguins)
```

Data from [Palmer Penguins R package](https://allisonhorst.github.io/palmerpenguins/)


```{r}
penguins |> count(species)
```


```{r}
colors <- c("#FF8C00", "#A020F0", "#008B8B")
```

```{r}
#| label: fig-size-scatter
#| fig-width: 3
#| fig-height: 3
ggplot(penguins, aes(body_mass_g, flipper_length_mm)) +
  geom_point(aes(color = species)) +
  scale_color_manual(values = colors) +
  theme_minimal()
```
```````

## File: docs/authoring/placeholder.qmd
```````
---
title: Adding Placeholder Images to Your Documents
aliases:
  - /docs/prerelease/1.5/lipsum.html
---

## Overview

The `{{{< placeholder >}}}` shortcode generates a placeholder image, which is incredibly useful when you're designing your document or website layout but the final images aren't ready yet.
It helps maintain the design integrity without interrupting the development flow.
Placeholder images can have configurable sizes and will be generated in either PNG or SVG format.

## Example

Here's an example of a placeholder image:

{{< placeholder >}}

By default, the `placeholder` shortcode creates 100x100 pixel images in the PNG format.
You can customize the size and format of the image by providing parameters to the shortcode.

## Usage

The `placeholder` shortcode can take additional arguments controling the size and format of the image:

::: {layout-ncol=1}
```markdown
{{{< placeholder 400 200 format=svg >}}}
```

{{< placeholder 400 200 format=svg >}}
:::
This will create a scalable vector graphic (SVG) placeholder image with dimensions of 400x200 pixels.

It also takes an optional `format` keyword argument.

- `{{{< placeholder >}}}`: Create a 100x100 pixel PNG placeholder image.
- `{{{< placeholder width >}}}`: Create a `width`x`width` pixel PNG placeholder image.
- `{{{< placeholder width height >}}}`: Create a `width`x`height` pixel PNG placeholder image.
- `{{{< placeholder format="svg" >}}}`: Create a 100x100 SVG placeholder image.
- `{{{< placeholder width format="svg" >}}}`: Create a `width`x`width` SVG placeholder image.
- `{{{< placeholder width height format="svg" >}}}`: Create a `width`x`height` SVG placeholder image.
```````

## File: docs/authoring/shortcodes.qmd
```````
---
title: Shortcodes
---

{{< include /docs/authoring/_shortcodes.qmd >}}

If you want to dive in to creating your own shortcode, check out the article on [Creating Shortcodes](/docs/extensions/shortcodes.qmd).
```````

## File: docs/authoring/tables.qmd
```````
---
title: Tables
engine: jupyter
aliases: 
  - /docs/prerelease/1.5/lua-table-processing.html
---

## Overview

Quarto includes a number of features aimed at making it easy to to author and customize markdown table output, including:

-   Specifying column alignment and widths.
-   Providing captions, subcaptions, and cross-references.
-   Generating tables dynamically from executable code cells.

This article covers using these features in-depth.

## Markdown Tables

The most commonly used markdown table is known as a pipe table. Pipe tables support specifying per column alignment as well as captions. For example:


::: {layout-ncol="2"}

:::: {}

``` markdown
| Default | Left | Right | Center |
|---------|:-----|------:|:------:|
| 12      | 12   |    12 |   12   |
| 123     | 123  |   123 |  123   |
| 1       | 1    |     1 |   1    |

: Demonstration of pipe table syntax
```

::::

:::: {}

| Default | Left | Right | Center |
|---------|:-----|------:|:------:|
| 12      | 12   |    12 |   12   |
| 123     | 123  |   123 |  123   |
| 1       | 1    |     1 |   1    |

: Demonstration of pipe table syntax

::::

:::

The beginning and ending pipe characters are optional, but pipes are required between all columns. The colons indicate column alignment as shown. The header cannot be omitted, however you can simulate a headerless table by including a header with blank cells.

Since the pipes indicate column boundaries, columns need not be vertically aligned, as they are in the above example. So, this is a perfectly legal (though ugly) pipe table:

``` markdown
fruit| price
-----|-----:
apple|2.05
pear|1.37
orange|3.09
```

The cells of pipe tables cannot contain block elements like paragraphs and lists, and cannot span multiple lines. If a pipe table contains a row whose markdown content is wider than the column width (see `columns` option), then the table will take up the full text width and the cell contents will wrap, with the relative cell widths determined by the number of dashes in the line separating the table header from the table body.

For example `---|-` would make the first column 3/4 and the second column 1/4 of the full text width. On the other hand, if no lines are wider than column width, then cell contents will not be wrapped, and the cells will be sized to their contents.

### Using Bootstrap classes

Bootstrap table classes given as attributes next to a table caption are inserted into the `<table>` element.
The classes permitted are those that apply expressly to the entire table, and these are:
`"primary"`, `"secondary"`, `"success"`, `"danger"`, `"warning"`, `"info"`, `"light"`, `"dark"`, `"striped"`, `"hover"`, `"active"`, `"bordered"`, `"borderless"`, `"sm"`, `"responsive"`, `"responsive-sm"`, `"responsive-md"`, `"responsive-lg"`, `"responsive-xl"`, `"responsive-xxl"`.
For example, the following Markdown table will be rendered with row stripes and the rows will also be highlighted on hover:

::: {layout-ncol="2"}

:::: {}


``` markdown
| fruit  | price  |
|--------|--------|
| apple  | 2.05   |
| pear   | 1.37   |
| orange | 3.09   |

: Fruit prices {.striped .hover}
```

::::

:::: {}

| fruit  | price  |
|--------|--------|
| apple  | 2.05   |
| pear   | 1.37   |
| orange | 3.09   |

: Fruit prices {.striped .hover}

::::

:::

### Authoring

For simple tables with only a few cells it's straightforward to create them directly in markdown. As tables get larger, it makes sense to use an authoring tool. Some table authoring tools to consider include:

+------------------------------------------------------------------------+---------------------------------------------------------------+
| [TablesGenerator](https://www.tablesgenerator.com/markdown_tables)     | Online tool for generating markdown tables                    |
+------------------------------------------------------------------------+---------------------------------------------------------------+
| [Emacs TableMode](https://www.emacswiki.org/emacs/TableMode)           | Text based table creation and editing capabilities for Emacs. |
+------------------------------------------------------------------------+---------------------------------------------------------------+
| [Quarto Visual Editor](/docs/visual-editor/content.qmd#editing-tables) | Visual editor for `.qmd` files with table editing support.    |
+------------------------------------------------------------------------+---------------------------------------------------------------+

: {tbl-colwidths="\[35,65\]"}

## Column Widths

Above we describe a means of specifying column widths using the relative number of dashes in each column header (_e.g._, `---|-` to get a 75% / 25% split for a two-column table).

You can also explicitly specify columns widths using the `tbl-colwidths` attribute or document-level option. For an individual markdown table, add the attribute after the caption. For example:

::: {layout-ncol="2"}

:::: {}

``` markdown
| fruit  | price  |
|--------|--------|
| apple  | 2.05   |
| pear   | 1.37   |
| orange | 3.09   |

: Fruit prices {tbl-colwidths="[75,25]"}
```

::::

:::: {}

| fruit  | price  |
|--------|--------|
| apple  | 2.05   |
| pear   | 1.37   |
| orange | 3.09   |

: Fruit prices {tbl-colwidths="[75,25]"}

::::

:::

If your table doesn't have a caption, then you can still specify only `tbl-colwidths`:

::: {layout-ncol="2"}

:::: {}

``` markdown
| fruit  | price  |
|--------|--------|
| apple  | 2.05   |
| pear   | 1.37   |
| orange | 3.09   |

: {tbl-colwidths="[75,25]"}
```

::::

:::: {}

| fruit  | price  |
|--------|--------|
| apple  | 2.05   |
| pear   | 1.37   |
| orange | 3.09   |

: {tbl-colwidths="[75,25]"}

::::

:::

Column widths can also be specified at the document level (_e.g._, to have uniform widths across a set of tables):

``` yaml
---
title: "My Document"
format: html
tbl-colwidths: [75,25]
---
```

## Cross References

For tables produced by executable code cells, include a label with a `tbl-` prefix to make them cross-referenceable.
For example:

```{python}
#| label: tbl-planets
#| tbl-cap: "Astronomical object"
#| echo: fenced

from IPython.display import Markdown
from tabulate import tabulate
table = [["Sun","696,000",1.989e30],
         ["Earth","6,371",5.972e24],
         ["Moon","1,737",7.34e22],
         ["Mars","3,390",6.39e23]]
Markdown(tabulate(
  table, 
  headers=["Astronomical object","R (km)", "mass (kg)"]
))
```

::: callout-important
## Label Prefix

In order for a table to be cross-referenceable, its label must start with the `tbl-` prefix.
:::

{{< include _table-crossrefs.md >}}

See the article on [Cross References](cross-references.qmd) for additional details.

### Subtables

{{< include _table-crossrefs-subtables.md >}}

## Caption Location

By default, table captions are positioned above tables. You can modify this behavior using the `tbl-cap-location` option. For example:

``` yaml
---
tbl-cap-location: top
---
```

Note that this option is specified at the top level so that it can be shared by both PDF and HTML formats. If you are only targeting a single format you can place it alongside other `format` specific options.

Valid values for the caption location include:

| Value    | Description                           |
|----------|---------------------------------------|
| `top`    | Position the caption above the table. |
| `bottom` | Position the caption below the table. |
| `margin` | Position the caption in the margin.   |

See the article on [Article Layout](article-layout.qmd#margin-captions) for additional details on placing captions in the margin.

## Computations

All of the options described above work for tables produced by executable code cells. For example, here we use the Python [tabulate](https://pypi.org/project/tabulate/) package along with the `Markdown()` function from the IPython [display](https://ipython.readthedocs.io/en/stable/api/generated/IPython.display.html#) module to print a markdown table:

```{python}
#| label: tbl-planet-measures
#| tbl-cap: "Astronomical object"
#| echo: fenced

from IPython.display import Markdown
from tabulate import tabulate
table = [["Sun","696,000",1.989e30],
         ["Earth","6,371",5.972e24],
         ["Moon","1,737",7.34e22],
         ["Mars","3,390",6.39e23]]
Markdown(tabulate(
  table, 
  headers=["Astronomical object","R (km)", "mass (kg)"]
))
```

Here we apply the `tbl-cap` and `tbl-colwidths` options to a code cell that uses the knitr `kable()` function to write a markdown table:

```{{r}}
#| label: tbl-cars
#| tbl-cap: "Cars"
#| tbl-colwidths: [60,40]

kable(head(cars))
```

If your code cell produces multiple tables, you can also specify subcaptions and layout using cell options:

::: {.panel-tabset group="language"}

## Python

````python
```{{python}}
#| label: tbl-example
#| tbl-cap: "Example"
#| tbl-subcap: 
#|   - "MPG"
#|   - "Taxis"
#| layout-ncol: 2

import seaborn as sns
from IPython.display import Markdown, display
mpg = sns.load_dataset("mpg").head(10)
taxis = sns.load_dataset("taxis").head(10)

display(Markdown(mpg.to_markdown(index = False)))
display(Markdown(taxis.to_markdown(index = False)))
```
````

Note that we use the [`display()`](https://ipython.readthedocs.io/en/stable/api/generated/IPython.display.html#IPython.display.display) function imported from `IPython` so that we can render multiple outputs from a single cell (by default cells only output their last expression).

## R

````python
```{{r}}
#| label: tbl-example
#| tbl-cap: "Example"
#| tbl-subcap: 
#|   - "Cars"
#|   - "Pressure"
#| layout-ncol: 2

library(knitr)
kable(head(cars))
kable(head(pressure))
```
````


:::

### Computational Table Styling

Quarto adds additional styling to tables generated by computations. By default, such tables are styled to be smaller and have striped rows.
If you want to disable this treatment, add `plain` to the classes of the code cell:

````python
```{{r}}
#| classes: plain

tibble::tribble(
  ~fruit,   ~price,
  "apple",  2.05,
  "pear",   1.37,
  "orange", 3.09
) |> 
  gt::gt()
```
````

## Grid Tables

Grid tables are a more advanced type of markdown tables that allow arbitrary block elements (multiple paragraphs, code blocks, lists, etc.). For example:


``` markdown
+-----------+-----------+--------------------+
| Fruit     | Price     | Advantages         |
+===========+===========+====================+
| Bananas   | $1.34     | - built-in wrapper |
|           |           | - bright color     |
+-----------+-----------+--------------------+
| Oranges   | $2.10     | - cures scurvy     |
|           |           | - tasty            |
+-----------+-----------+--------------------+

: Sample grid table.
```

Which looks like this when rendered to HTML:

+-----------+-----------+--------------------+
| Fruit     | Price     | Advantages         |
+===========+===========+====================+
| Bananas   | $1.34     | - built-in wrapper |
|           |           | - bright color     |
+-----------+-----------+--------------------+
| Oranges   | $2.10     | - cures scurvy     |
|           |           | - tasty            |
+-----------+-----------+--------------------+

: Sample grid table.


The row of `=`s separates the header from the table body, and can be omitted for a headerless table. The cells of grid tables may contain arbitrary block elements (multiple paragraphs, code blocks, lists, etc.)

Alignments can be specified as with pipe tables, by putting colons at the boundaries of the separator line after the header:


``` markdown
+---------+--------+------------------+
| Right   | Left   | Centered         |
+========:+:=======+:================:+
| Bananas | $1.34  | built-in wrapper |
+---------+--------+------------------+
```
Which looks like this when rendered to HTML:

+---------+--------+------------------+
| Right   | Left   | Centered         |
+========:+:=======+:================:+
| Bananas | $1.34  | built-in wrapper |
+---------+--------+------------------+


For headerless tables, the colons go on the top line instead:

``` markdown
+----------:+:----------+:--------:+
| Right     | Left      | Centered |
+-----------+-----------+----------+
```

Which looks like this when rendered to HTML:

+----------:+:----------+:--------:+
| Right     | Left      | Centered |
+-----------+-----------+----------+


Note that grid tables are quite awkward to write with a plain text editor (because unlike pipe tables, the column indicators must align). Here are some tools that can assist with creating grid tables:

-   Emacs' [table-mode](https://www.gnu.org/software/emacs/manual/html_node/emacs/Text-Based-Tables.html) (`M-x table-insert`)
-   Quarto [Visual Editor](/docs/visual-editor/content.qmd#editing-tables)
-   Tables Generator's [Plain Text mode](https://www.tablesgenerator.com/text_tables) with `Use reStructuredText syntax` enabled

## HTML Tables

Quarto can process HTML tables in `html` `RawBlock` nodes (_i.e._, `{=html}`) and convert them to Markdown tables, regardless of the output format (intentionally including non-HTML formats).
As a result, you can use HTML table syntax in your documents and it will be converted to Markdown syntax for all formats.
Additionally, libraries that emit computational tables in HTML format can work in other output formats.

For example, consider the following raw HTML block:

````markdown
```{=html}
<table>
  <caption>As described in the section above, Quarto tables are great.</caption>
  <thead>
    <tr>
      <th>Header 1</th>
      <th>Header 2</th>
    </tr>
  </thead>
  <tbody>
    <tr>
    <td><img src="https://upload.wikimedia.org/wikipedia/commons/thumb/3/37/African_Bush_Elephant.jpg/220px-African_Bush_Elephant.jpg" alt="African Bush Elephant" /></td>
      <td>Regular output</td>
    </tr>
  </tbody>
</table>
```
````

When rendered, this results in the following output for HTML and PDF formats:

::: {layout-ncol=2}

:::: {}
### HTML Output

```{=html}
<table>
  <caption>As described in the section above, Quarto tables are great.</caption>
  <thead>
    <tr>
      <th>Header 1</th>
      <th>Header 2</th>
    </tr>
  </thead>
  <tbody>
    <tr>
    <td><img src="https://upload.wikimedia.org/wikipedia/commons/thumb/3/37/African_Bush_Elephant.jpg/220px-African_Bush_Elephant.jpg" alt="African Bush Elephant" /></td>
      <td>Regular output</td>
    </tr>
  </tbody>
</table>
```
::::

:::: {}
### PDF Output

![](images/raw-table-pdf.png){.border fig-alt="Screenshot of PDF output showing a table with a caption and two columns. The column headers are Header 1 and Header 2, and the cell contents are an image of an elephant and text that reads Regular Output."}
::::

:::

In addition, Quarto supports the specification of embedded  Markdown content in tables.
This is done by providing a data attribute `qmd` or `qmd-base64` in an embedded `span` or `div` node.
These nodes can appear anywhere that such content is allowed: table headers, footers, cells, captions, _etc._ 

For example, the following table includes a cross reference, markdown formatting and a shortcode:

:::: {layout-nrow="2"}

::: {}

```` markdown
## HTML Tables Example {#sec-html-tables}

```{=html}
<table>
  <caption><span data-qmd="As described in [Section -@sec-html-tables], Quarto are great."></span></caption>
  <thead>
    <tr>
      <th><span data-qmd="_Header 1_"></span></th>
      <th><span data-qmd="_Header 2_"></span></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><span data-qmd="{{{< video https://www.youtube.com/embed/wo9vZccmqwc >}}}"></span></td>
      <td>Regular output</td>
    </tr>
  </tbody>
</table>
```
````

:::

::: {}

Which renders as follows:

## HTML Tables Example {#sec-html-tables}

```{=html}
<table>
  <caption><span data-qmd="As described in [Section -@sec-html-tables], Quarto are great."></span></caption>
  <thead>
    <tr>
      <th><span data-qmd="_Header 1_"></span></th>
      <th><span data-qmd="_Header 2_"></span></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><span data-qmd="{{< video https://www.youtube.com/embed/wo9vZccmqwc >}}"></span></td>
      <td>Regular output</td>
    </tr>
  </tbody>
</table>
```

:::

::::

### Colspans and Rowspans

Tables containing cells spanning multiple rows or columns are supported across output formats[except in PDF margins]{.aside}.

However, using markdown, it is tricky to draw grid tables with spans, and there is no way to express spans in pipe tables. 

If you are comfortable with HTML, or use a package that generates HTML, the table cell HTML attributes `colspan` and `rowspan` are a better option.

```{=html}
{{< include col-and-row-span.html >}}
```

````html
```{=html}
{{< include col-and-row-span.html >}}
```
````


### Individual cell alignment

Markdown supports specification of alignment by column, but does not allow setting the alignment of individual cells. The CSS properties `text-align` and `vertical-align` are only available through Raw HTML. (These are not currently supported by PDF/Latex or Pptx output formats, and Docx only supports `text-align`.)


```{=html}
{{< include cell-alignment.html >}}
```

````html
```{=html}
{{< include cell-alignment.html >}}
```
````

## Disabling Quarto Table Processing

It's possible that Quarto's processing of HTML tables may interfere with the HTML produced computationally with table packages in R and Python (or other supported languages).


When you disable Quarto's HTML table processing, tables are not translated to Markdown, will not be rendered to other output formats, and can not use Quarto Markdown features, like cross-references, shortcodes, etc.
The tables also won't be visible to Lua filters that act on `Table` nodes.

You can disable Quarto's HTML table processing at a document level or project level with the option `html-table-processing`:

```{.yaml}
---
format:
  html:
    html-table-processing: none
---
```

This option is also available as a code cell option for Knitr and Jupyter, e.g. 

````{markdown}
```{{r}}
#| html-table-processing: none

# R Code that generates an HTML table
```
````

To disable Quarto's HTML table processing for parts of a document use a div with the attribute `html-table-processing="none"`:

````{.markdown}
::: {html-table-processing="none"}

Content with HTML tables you don't want processed.

:::
````

### Library authors

If you are the author of a library that emits HTML tables you might like to disable Quarto's processing of HTML tables by adding the attribute `data-quarto-disable-processing="true"` to the `<table>` element. For example:

```html
<table data-quarto-disable-processing="true">
  ...
</table>
```

Additionally, you can add the comment `<!--| quarto-html-table-processing: none -->` to the HTML raw block, and Quarto will not attempt to process it.
```````

## File: docs/authoring/title-blocks.qmd
```````
---
title: Title Blocks
---

## Overview

HTML pages rendered with Quarto include a formatted title block at the start of the article. The title block contains the title, subtitle, authors, date, doi, and abstract.

A simple example title block looks like:

![](images/document-title-block.png){.border fig-alt="Document with header reading: Summarizing Output for Reproducible Documents. Below is Author (Nora Jones), Affiliation (Spacely Sprockets), Published (5/4/2018). Below that is a description which reads: A summary of best practices for summarizing output of reproducible scientific documents."}

The title block will automatically layout elements from the front matter of the document. If you'd like, you can control the behavior using `title-block-style`.

There are three options available:

`default`

:   The default title-block treatment create a smaller font face and gathers the various title elements into stylized groups in the title block of the document.

`plain`

:   The plain treatment will do all the title element processing (gathering and organizing the elements), but will not apply the default title block styling.

`none`

:   `none` disables title block processing altogether. Content will not be processed or organized and the title block will be emitted verbatim from Pandoc.

## Title Banners

In addition, if you'd like a more prominent title block, you can use `title-block-banner` to create a banner style title block. A banner style title block will position the title, subtitle, description, and categories in a banner above the article. For example:

``` yaml
---
title-block-banner: true
---
```

will render a title block like:

![](images/document-title-block-banner.png){.border fig-alt="Title block with title and description against a blue background up top, and below a section with author, affilitation, and date published."}

### Custom Backgrounds

In this case, the color of the banner is automatically determined based upon the theme. However, you can control the banner background by providing either a CSS color (e.g. `"#FFDDFF"`, or `red`) or the path to an image which will be used the background. For example, to use a banner image, you might write:

``` yaml
---
title-block-banner: images/banner.jpeg
---
```

which would render a banner title block like:

![](images/document-title-block-banner-custom.png){.border fig-alt="Title block with title and description against an image background up top, and below a section with author, affilitation, and date published."}

When you provide an explicit background color or image, Quarto assumes that the color of the background will contrast with the body background color and automatically uses the body background color as the text color over the banner.

### Foreground Color

You can specify the color the for the text of the banner as well, using `title-block-banner-color` and providing a CSS color (e.g. `"#FFDDFF"`, or `red`) .

## Date

Quarto includes the document's `date` in the title block. In addition to writing a standard date, you may also use a few special keywords which will generate a date for you. `today` will provide the current date with the current time set to 0, `now` will provide the current date and time, and `last-modified` will provide the file modification date and time of the document itself.

### Formatting

When your title block is output using the `default` or `plain` styles, Quarto will automatically format the date based upon the document locale (`lang`). You can control formatting by specifying a `date-format` in the document front matter. For example:

``` yaml
---
title: Summarizing Output for Reproducible Documents
date: 2018-05-04
date-format: short
---
```

For more about date formats, see the Quarto [date format reference](/docs/reference/dates.qmd).

## Metadata Labels

The labels for the metadata included in the title block have default values that are properly localized, but you may want to provide your own labels for metadata. You can use the following to customize the labels:

| Option              | Label          | Styles                     |
|---------------------|----------------|----------------------------|
| `author-title`      | Authors        | `plain`, `default`         |
| `affiliation-title` | Affiliations   | `plain`, `default`         |
| `abstract-title`    | Abstract       | `plain`, `default`, `none` |
| `description-title` | Description    | `plain`, `default`         |
| `published-title`   | Date Published | `plain`, `default`         |
| `doi-title`         | DOI            | `plain`, `default`         |

## Custom Title Pages

To learn more about providing a complete custom title block, see the [documentation on template partials](/docs/journals/templates.qmd#template-partials).
```````

## File: docs/authoring/variables.qmd
```````
---
title: "Variables"
---

## Overview

There are a number of ways to include dynamic variables within documents rendered by Quarto. This is useful for externalizing content that varies depending on context, or as an alternative to repeating a value in multiple places (e.g. a version number).

For example, the following prints the `title` from document metadata:

``` {.markdown shortcodes="false"}
{{< meta title >}}
```

The `{{{< meta >}}}` syntax used here is an example of a [shortcode](/docs/extensions/shortcodes.qmd). Quarto supports the following shortcodes for dynamic variables:

| Shortcode     | Description                          |
|---------------|--------------------------------------|
| [var](#var)   | Value from `_variables.yml` file     |
| [meta](#meta) | Value from document metadata         |
| [env](#env)   | Value of System environment variable |

## var {#var}

If you are using a Quarto project, the `var` shortcode enables you to insert content from a project-level `_variables.yml` file. Create this file alongside your `_quarto.yml` project file, and then include references to those variables within any document in your project.

Variables can be either simple values or markdown content. To define variables, create a `_variables.yml` file in the root directory of your project. For example:

``` yaml
version: 1.2

email:
  info: info@example.com
  support: support@example.com

engine:
  jupyter: "[Jupyter](https://jupyter.org)"
  knitr: "[Knitr](<https://yihui.name/knitr>)"
```

Note that the `engine` variable values include markdown for hyperlinks. 
Any markdown provided needs to be well-formed, and cannot change the structure of the content around it (e.g. by closing a div opened before the variable inclusion).

To include the value of a variable, use the `{{</* var */>}}` shortcode, for example:

``` {.markdown shortcodes="false"}
Version {{< var version >}} is a minor upgrade.

Please contact us at {{< var email.info >}}.

Quarto includes {{< var engine.jupyter >}} and 
{{< var engine.knitr >}} computation engines.
```

## meta {#meta}

The `meta` shortcode allows you to insert content from Pandoc metadata (e.g. YAML at the top of the document and/or in `_quarto.yml`).

For example, the following shortcode inserts the value of the `title` field from YAML metadata:

``` {.markdown shortcodes="false"}
{{< meta title >}}
```

You can dereference sub-keys using the dot (`.`) delimiter. For example:

``` {.markdown shortcodes="false"}
{{< meta labels.description >}}
```

You can also index into an array with the dot (`.`) delimiter. For example, to
extract the first in the array of authors:

``` {.markdown shortcodes="false"}
{{< meta author.1 >}}
```

To reference a field that contains a dot (`.`), escape the dot with a double backslash (`\\`). For example, to get `field.with.dots`:


``` {.markdown shortcodes="false"}
{{< meta field\\.with\\.dots >}}
```

## env {#env}

The `env` shortcode enables you to read values from environment variables. For example:

``` {.markdown shortcodes="false"}
Version {{< env PRODUCT_VERSION >}} is a minor upgrade.
```

You can provide a fallback value if the environment variable isn't set by providing a second argument:

``` {.markdown shortcodes="false"}
Version {{< env PRODUCT_VERSION "*.*" >}} is a minor upgrade.
```

You can read more about setting environment variables in Quarto projects in  [Environment Variables](/docs/projects/environment.qmd).

{{< include ../extensions/_shortcode-escaping.qmd >}}
```````

## File: docs/authoring/version.qmd
```````
---
title: Displaying Quarto CLI Version
---

## Overview

The `version` shortcode prints the version of the Quarto CLI that is being used to build the document as part of the document content.

## Example

Here's an example of the `{{{< version >}}}` shortcode in action:

> Quarto CLI {{< version >}} is being used to build this document.

## Usage

::: {layout-ncol=2}
```markdown
Quarto CLI {{{< version >}}} is amazing.
```
:::: {.border}
Quarto CLI {{< version >}} is amazing.
::::
:::
```````

## File: docs/authoring/videos.qmd
```````
---
title: "Videos"
---

## Overview

You can embed videos in documents using the `{{{< video >}}}` shortcode. For example, here we embed a YouTube video:

``` {.markdown shortcodes="false"}
{{< video https://www.youtube.com/embed/wo9vZccmqwc >}}
```

Videos can refer to video files (e.g. `.mp4`) or can be links to videos published on YouTube, Vimeo, or Brightcove.

Here are some additional examples that demonstrate using various video sources and options:

``` {.default shortcodes="false"}
{{< video local-video.mp4 >}}

{{< video https://www.youtube.com/embed/wo9vZccmqwc >}}

{{< video https://vimeo.com/548291297 >}}

{{< video https://youtu.be/wo9vZccmqwc width="400" height="300" >}}

{{< video https://www.youtube.com/embed/wo9vZccmqwc
    title="What is the CERN?"
    start="116"
    aspect-ratio="21x9" 
>}}
```

In HTML formats the video will be embedded within the document. For other formats, a simple link to the video will be rendered.

Next, we'll cover the various options available for video embedding. For additional details on using videos within Revealjs presentations (including how to create slides with full-screen video backgrounds), see the [Revealjs](#revealjs) section below.

## Video URL

The video URL can specify either a path to a video file (e.g. a `.mp4`) alongside the document, a remote URL to a video file, or a URL to a video service (YouTube, Vimeo, or Brightcove).

These are valid URLs for video files:

``` {.default shortcodes="false"}
{{< video local-video.mp4 >}}
{{< video https://videos.example.com/video.mp4 >}}
```

For video services, a variety of URL forms are supported. For example, the following video service URLs are all valid:

``` {.default .code-overflow-scroll shortcodes="false"}
{{< video https://youtu.be/wo9vZccmqwc >}}
{{< video https://www.youtube.com/watch?v=wo9vZccmqwc >}}
{{< video https://www.youtube.com/embed/wo9vZccmqwc >}}
{{< video https://vimeo.com/548291297 >}}
{{< video https://players.brightcove.net/1460825906/default_default/index.html?videoId=5988531335001 >}}
```

Note that YouTube videos support both the URL that is available in the address bar when watching a video as well as the standard URLs used for linking and embedding. Brightcove videos are embedded using the standard [iframe embed code](https://studio.support.brightcove.com/publish/choosing-correct-embed-code.html).

## Options

### Aspect Ratio

Videos are automatically rendered responsively using the full width of the document's main text column. The `aspect-ratio` specifies how the height should vary with changes in width. For example:

``` {.default shortcodes="false"}
{{< video https://youtu.be/wo9vZccmqwc aspect-ratio="4x3" >}}
```

Available [aspect ratios](https://getbootstrap.com/docs/5.0/helpers/ratio/#aspect-ratios) include `1x1`, `4x3`, `16x9` (the default), and `21x9`.

#### Width and Height

You can disable responsive sizing by providing explicit `width` and `height` attributes. For example:

``` {.default shortcodes="false"}
{{< video https://youtu.be/wo9vZccmqwc width="250" height="175" >}}
```

This will produce a video that renders at the specified dimensions and is not responsive. Note that when no `height` or `width` are specified, videos will size responsively given the space available to them.

### Start Time

For YouTube videos, you can specify a `start` option to indicate how many seconds into the video you want to start playing:

``` {.default shortcodes="false"}
{{< video https://youtu.be/wo9vZccmqwc start="10" >}}
```

### Frame Title

The `title` option adds a `title` attribute to the video `<iframe>`:

``` {.default shortcodes="false"}
{{< video https://www.youtube.com/embed/wo9vZccmqwc 
    title='What is the CERN?' 
>}}
```

## Revealjs {#revealjs}

You can include videos within [Revealjs](/docs/presentations/revealjs/index.qmd) presentations in one of two ways:

-   A video that appears within the contents of a slide.

-   A video that occupies the entire background of a slide.

### Slide Content

Here's a video on a slide without a title:

``` {.default shortcodes="false"}
---

{{< video https://youtu.be/wo9vZccmqwc width="100%" height="100%" >}}
```

Note that we set the `width` and `height` explicitly to 100% so that the video fills the slide.

Here's a video on a slide with a title.

``` {.default shortcodes="false"}
## Video Slide 

{{< video https://youtu.be/wo9vZccmqwc width="100%" height="85%" >}}
```

Note that we set the `height` to 85% to leave room for the title.

### Backgrounds

For videos on slides without titles, you might prefer to have the video fill the entire background of the slide. You can do this using the `background-video` attribute. For example:

``` markdown
## {background-video="intro-cern.mp4"}

## {background-video="https://videos.example.com/intro-cern.mp4"}

## {background-video="https://youtu.be/wo9vZccmqwc?autoplay=1"}

## {background-video="https://vimeo.com/548291297"}
```

Note that when using `background-video` for video files (as distinct from services like YouTube) you can specify a number of other attributes, including:

{{< include ../presentations/revealjs/_background-video.md >}}

## Cross-References

{{< include _cross-reference-divs-video.qmd >}}
```````

## File: docs/blog/posts/2022-02-13-feature-callouts/index.qmd
```````
---
title: Using Callouts
subtitle: Use callouts to draw attention to important complementary content without interupting the document flow
description: |
  Callouts are an excellent way to draw extra attention to certain concepts, or to more clearly indicate that certain content is supplemental or applicable to only some scenarios.
categories:
  - Features
  - Authoring
author: Charles Teague
date: 2/13/2022
image: callouts.png
image-alt: "Three calout boxes: A note (has a blue banner with info icon preceding the header), a tip (has a green banner with lightbulb icon preceding the header), and an important (has a red banner with info exclamation-point icon preceding the header)."
---

Callouts are an excellent way to draw extra attention to certain concepts, or to more clearly indicate that certain content is supplemental or applicable to only some scenarios.

![](callouts.png){.preview-image fig-align="center" fig-alt="Three calout boxes: A note (has a blue banner with info icon preceding the header), a tip (has a green banner with lightbulb icon preceding the header), and an important (has a red banner with info exclamation-point icon preceding the header)."}

## Callout Basics

There are five different types of callouts available.

-   note
-   tip
-   important
-   caution
-   warning

The color and icon will be different depending upon the type that you select.

## Syntax

Create callouts in markdown using the following syntax (note that the first markdown heading used within the callout is used as the callout heading):

``` markdown
:::{.callout-note}
Note that there are five types of callouts, including:
`note`, `tip`, `warning`, `caution`, and `important`.
:::

:::{.callout-tip}
## Tip With Caption

This is an example of a callout with a caption.
:::
```

See our documentation on [Callouts](/docs/authoring/callouts.qmd), to learn more, including more about how to customize the appearance and behavior of callouts.
```````

## File: docs/blog/posts/2022-02-15-feature-tables/index.qmd
```````
---
title: Customizing Table Output
subtitle: Author and customize markdown tables using Quarto
description: |
  This post provides an overview of these capabilities in Quarto. For more detail about all the features Quarto for authoring tables, see [Tables](/docs/authoring/tables.qmd).
categories:
  - Features
  - Authoring
  - Tables
author: JJ Allaire
date: "2/15/2022"
image: table.png
image-alt: "Table 1: Example. Has two subtables: Subtable a, Cars, with columns for speed and dist; and subtable b, Pressure, with columns for temperature and pressure."
---

Quarto includes a number of features aimed at making it easy to author and customize markdown table output, including:

-   Specifying column alignment and widths.
-   Providing captions, subcaptions, and cross-references.
-   Generating tables dynamically from executable code cells.

This post provides an overview of these capabilities in Quarto. For more detail about all the features Quarto for authoring tables, see [Tables](/docs/authoring/tables.qmd).

## Markdown Tables

The most commonly used markdown table is known as a pipe table. Pipe tables support specifying per column alignment as well as captions. For example:

``` markdown
| Default | Left | Right | Center |
|---------|:-----|------:|:------:|
| 12      | 12   |    12 |   12   |
| 123     | 123  |   123 |  123   |
| 1       | 1    |     1 |   1    |

: Demonstration of pipe table sytnax
```

Here is the table rendered to HTML:

| Default | Left | Right | Center |
|---------|:-----|------:|:------:|
| 12      | 12   |    12 |   12   |
| 123     | 123  |   123 |  123   |
| 1       | 1    |     1 |   1    |

: Demonstration of pipe table syntax

#### Caption Location

By default, table captions are positioned above tables. You can modify this behavior using the `tbl-cap-location` option. For example:

``` yaml
---
tbl-cap-location: top
---
```

## Explicit Column Widths

Beyond standard pipe table syntax for expressing column width, you can also explicitly specify columns widths using the `tbl-colwidths` attribute or document-level option. For an individual markdown table, add the attribute after the caption. For example:

``` markdown
| fruit  | price  |
|--------|--------:
| apple  | 2.05   |
| pear   | 1.37   |
| orange | 3.09   |

: Fruit prices {tbl-colwidths="[75,25]"}
```

Note that this option is specified at the top level so that it can be shared by both PDF and HTML formats. If you are only targeting a single format you can place it alongside other `format` specific options.

Valid values for the caption location include:

| Value    | Description                           |
|----------|---------------------------------------|
| `top`    | Position the caption above the table. |
| `bottom` | Position the caption below the table. |
| `margin` | Position the caption in the margin.   |

## Computations

All of the options described above work for tables produced by executable code cells. For example, here we apply the `tbl-cap`, `tbl-colwidths` and `tbl-caption-location` options to a code cell:

```{{r}}
#| tbl-cap: "Cars"
#| tbl-colwidths: [60,40]
#| tbl-cap-location: margin

library(knitr)
kable(head(cars))
```

In addition to the above, which focused on some of the features of Quarto when writing pipe tables in markdown, you can also author tables using grid syntax. You review the [documentation](/docs/authoring/tables.qmd). for more detail.
```````

## File: docs/blog/posts/2022-02-17-advanced-layout/index.qmd
```````
---
title: Positioning Content in the Margin
subtitle: Create 'Tufte' style documents with sidenotes, margin tables and figures, and other margin content
description: |
  This post demonstrates a few of the capabilities for positioning content in the margin of the page. You can read more about the complete capabilities in the [Article Layout Guide](/docs/authoring/article-layout.qmd).
author: Charles Teague
date: "2/17/2022"
categories:
  - Features
  - Layout
image: margin-content.png
image-alt: "Screenshot of two sections of post: Margin Figures, which has a plot in the margin; and Arbitrary Margin Content, which has text with a LaTeX equation in the margin."
reference-location: margin
citation-location: margin
---

Quarto supports a variety of page layout options that enable you to author content that

-   Fills the main content region
-   Overflows the content region
-   Spans the entire page
-   Occupies the document margin

This post will demonstrate a few of the capabilities for positioning content in the margin of the page. You can read more about the complete capabilities in the [Article Layout Guide](/docs/authoring/article-layout.qmd).\

## Margin Figures

Figures that you create using code cells can be placed in the margin by using the `column: margin` code cell option. If the code produces more than one figure, each of the figures will be placed in the margin.

```{r}
#| label: fig-mtcars
#| fig-cap: "MPG vs horsepower, colored by transmission."
#| column: margin
#| echo: fenced

library(ggplot2)
mtcars2 <- mtcars
mtcars2$am <- factor(
  mtcars$am, labels = c('automatic', 'manual')
)
ggplot(mtcars2, aes(hp, mpg, color = am)) +
  geom_point() +
  geom_smooth(formula = y ~ x, method = "loess") +
  theme(legend.position = 'bottom')
```

## Margin Tables

You an also place tables in the margin of your document by specifying `column: margin`.

```{r}
#| column: margin
#| echo: fenced

knitr::kable(
  mtcars[1:3, 1:3]
)
```

## Other Content

You can also place content in the margin by targeting the margin column using a div with the .`column-margin` class. For example:

``` md
::: {.column-margin}
We know from *the first fundamental theorem of calculus* that for $x$ in $[a, b]$:

$$\frac{d}{dx}\left( \int_{a}^{x} f(u)\,du\right)=f(x).$$
:::
```

::: column-margin
We know from *the first fundamental theorem of calculus* that for $x$ in $[a, b]$:

$$\frac{d}{dx}\left( \int_{a}^{x} f(u)\,du\right)=f(x).$$
:::

## Margin References

Footnotes and the bibliography typically appear at the end of the document, but you can choose to have them placed in the margin by setting the following option\[\^1\] in the document front matter:

``` yaml
---
reference-location: margin
citation-location: margin
---
```

With these options set, footnotes and citations will (respectively) be automatically be placed in the margin of the document rather than the bottom of the page. As an example, when I cite @xie2018, the citation bibliography entry itself will now appear in the margin.

### Asides

Asides allow you to place content aside from the content it is placed in. Asides look like footnotes, but do not include the footnote mark (the superscript number). [This is a span that has the class `aside` which places it in the margin without a footnote number.]{.aside}

``` markdown
[This is a span that has the class aside which places it in the margin without a footnote number.]{.aside}
```

## Margin Captions

For figures and tables, you may leave the content in the body of the document while placing the caption in the margin of the document. Using `cap-location: margin` in a code cell or document front matter to control this. For example:

```{r}
#| label: fig-cap-margin
#| fig-cap: "MPG vs horsepower, colored by transmission."
#| cap-location: margin
#| echo: fenced

library(ggplot2)
mtcars2 <- mtcars
mtcars2$am <- factor(
  mtcars$am, labels = c('automatic', 'manual')
)
ggplot(mtcars2, aes(hp, mpg, color = am)) +
  geom_point() +
  geom_smooth(formula = y ~ x, method = "loess") +
  theme(legend.position = 'bottom')
```
```````

## File: docs/blog/posts/2022-06-21-rstudio-conf-2022-quarto/index.qmd
```````
---
title: Quarto at rstudio::conf(2022)
subtitle: Quarto-related workshops and talks at rstudio::conf(2022)
description: | 
    [rstudio::conf(2022)](https://rstd.io/conf) will feature a variety of workshops and talks on Quarto. Join us in Washington DC this July 25-28 to learn more about Quarto and hear from folks using Quarto to create, share, and collaborate.
categories:
  - Conf
  - Workshop
  - Talk
author: Mine Çetinkaya-Rundel
date: "6/21/2022"
image: conf2022.png
image-alt: "rstudio:conf(2022) logo: orange background with the outline of the Washington DC skyline."
---

[rstudio::conf(2022)](https://rstd.io/conf) will feature a variety of workshops and talks on Quarto. Join us in Washington DC this July 25-28 to learn more about Quarto and hear from folks using Quarto to create, share, and collaborate.

![](conf2022.png){.preview-image fig-alt="rstudio::conf(2022) logo: orange background with the outline of the Washington DC skyline." fig-align="center"}

Here is a list of Quarto-related talks and workshops (and scroll down for details on each):

-   Keynote: [Reimagine + Collaborate + Share with Quarto](https://sched.co/11iZo)
-   Workshops:
    -   [Getting Started with Quarto](https://www.rstudio.com/conference/2022/workshops/get-started-quarto/)
    -   [From R Markdown to Quarto](https://www.rstudio.com/conference/2022/workshops/rmd-to-quarto/)
-   Talks:
    -   [Quarto for R Markdown users](https://sched.co/11iZa)
    -   [These are a few of my favorite things (about Quarto presentations)](https://sched.co/11ibN)
    -   [Literate Programming With Jupyter Notebooks and Quarto](https://sched.co/11ibe)
    -   [Websites & Books & Blogs, oh my! Creating Rich Content with Quarto](https://sched.co/11ibV)

## Keynote

[**Reimagine + Collaborate + Share with Quarto**](https://sched.co/11iZo) **(Keynote)**: [(Talk recording)](https://www.rstudio.com/conference/2022/keynotes/collaborate-with-quarto/)

-   Presented by [Julia Stewart Lowndes](https://jules32.github.io/) (Director, Openscapes) and [Mine Çetinkaya-Rundel](http://mine-cr.com/) (Developer Educator at RStudio and Professor at Duke University).
-   Thursday July 28, 9:00am - 10:00am EDT.
-   What is Quarto? In this talk, in four acts, we will discuss how Quarto unifies and extends the R Markdown ecosystem. Through our work with NASA Openscapes, Duke University, and RStudio, we will share our experiences authoring, teaching, and collaborating with Quarto. Full of demos with Quarto in RStudio and Jupyter and weaving together narrative, R, and Python code, we will showcase features of Quarto that have enabled us to reimagine our reproducible workflows. This talk will help you get the most out of Quarto regardless of your background with R Markdown, the computing language(s) you use, and your tool of choice for authoring.

## Workshops

We will have two Quarto workshops at the conference, held on July 25-26, one for those who have no or little prior experience with R Markdown and the other for those who want to take their R Markdown skills and expertise and apply them in Quarto.

-   [**Getting Started with Quarto**](https://www.rstudio.com/conference/2022/workshops/get-started-quarto/)**:** This workshop is designed for those who have no or little prior experience with R Markdown. In this 2 day workshop you will learn about the Quarto format for technical communication and computation. The workshop will teach you how to get started creating and fully customizing Quarto outputs (HTML, PDF, Presentations) and the use of RStudio's Visual Editor which provides a user interface for editing all of Pandoc markdown. The workshop will also provide an overview of Quarto's developer tooling support in alternative tools such as Jupyter, VS Code, and any text editors. The workshop will briefly cover how to add interactivity to Quarto with Shiny, Observable JS, htmlwidgets or Jupyter Widgets. Lastly, the workshop will cover Quarto Projects for aggregating many files such as complex web sites or entire books. Presented by [Tom Mock](https://themockup.blog/about.html), Customer Enablement Lead at RStudio, this workshop will be appropriate for attendees who answer yes to these questions:

    -   Have you programmed in R and want to better encapsulate your code, documentation, and outputs in a cohesive "data product"?
    -   Do you want to learn about the next generation of RMarkdown for data science?
    -   Do you want to have a better interactive experience when writing technical or scientific documents with literate programming?

    Find out more about this workshop and register at [https://www.rstudio.com/conference/2022/workshops/get-started-quarto/](https://www.rstudio.com/conference/2022/workshops/get-started-quarto).

-   [**From R Markdown to Quarto**](https://www.rstudio.com/conference/2022/workshops/rmd-to-quarto)**:** This workshop is designed for those who want to take their R Markdown skills and expertise and apply them in Quarto. In this workshop you will learn how to apply your reproducible authoring skills to the Quarto format and learn about new tools and workflows for authoring with Quarto in RStudio. You will learn to create static documents, to add interactivity to them with Shiny and htmlwidgets, and to create presentations in various formats such as reveal.js, beamer, and pptx. The workshop will also introduce you to Quarto projects which you can use to build websites and write blogs and books. Finally, you will learn various ways to deploy and publish your Quarto projects on the web. Independent modules will also highlight authoring in Quarto with Jupyter and VS Code as well as other text editors. Presented by [Andrew Bray](https://bids.berkeley.edu/people/andrew-bray), Associate Teaching Professor in the Department of Statistics at UC Berkeley, this workshop will be appropriate for you if you answer yes to any of these questions:

    -   Have you authored R Markdown documents and are you interested in migrating your workflow to its successor format, Quarto?
    -   Are you interested in exploring the wide spectrum of documents that can be produced with Quarto, including static documents, websites, and slides?

    Find out more about this workshop and register at <https://www.rstudio.com/conference/2022/workshops/rmd-to-quarto>.

## Talks

-   [**Quarto for R Markdown users**](https://sched.co/11iZa): [(Talk recording)](https://www.rstudio.com/conference/2022/talks/quarto-for-rmarkdown-users/)
    -   Presented by [Tom Mock](https://themockup.blog/about.html), Customer Enablement Lead at RStudio.
    -   Wednesday July 27, 3:20pm - 3:40pm EDT.
    -   Are you curious about Quarto? Maybe you saw it on Twitter or the RStudio::conf agenda. Perhaps this raised questions like: What exactly is Quarto? What about RMarkdown? (don't worry it's not going away!) What features does Quarto add? What should I do with my existing Rmd/ipynb files? This talk will answer all of those questions and more! I'll present Quarto as a next-gen version of RMarkdown, compare the similarities, and then discuss the new features in Quarto for publishing documents, presentations, blog posts, lab notebooks and more! Lastly, I'll cover what this means for our customers using RStudio Team, and the exciting new world for Python users.
-   [**These are a few of my favorite things (about Quarto presentations)**](https://sched.co/11ibN): [(Talk recording)](https://www.rstudio.com/conference/2022/talks/my-favorite-things-quarto-presentations/)
    -   Presented by [Tracy Teal](https://twitter.com/tracykteal), Open Source Program Director at RStudio.
    -   Thursday July 28, 2022 3:20pm - 3:40pm EDT.
    -   Quarto is the next generation of RMarkdown, and comes with a new presentation format, revealjs. In this talk, I'll show a few of my favorite things about making interactive HTML presentations with Quarto. Along the way you'll learn about the visual editor, multiple columns, delivering an effective talk with speaker notes and mode, making your presentations pop with transitions, effective ways to incorporate code into your presentation, beautiful themes (and how to match your corporate style guide), and sharing it as pdf and HTML. I'll finish off with a brief look at generating a PowerPoint presentation from a template.
-   [**Literate Programming With Jupyter Notebooks and Quarto**](https://sched.co/11ibe): [(Talk recording)](https://www.rstudio.com/conference/2022/talks/literate-programming-quarto/)
    -   Presented by [Hamel Husain](https://hamel.dev/), head of Data Science at [Outerbounds](https://outerbounds.com/) (the developers of [Metaflow](https://metaflow.org/)) and core developer at [fast.ai](https://www.fast.ai/).
    -   Thursday July 28, 3:40pm - 4:00pm EDT.
    -   Jupyter Notebooks play a critical role in in the workflow of many users. Notebooks are used to document existing code, to quickly prototype and iterate on ideas, and as a medium of technical communication. However, package developers typically use an entirely separate set of more traditional development tools, and the context switching between these tools and notebooks can be frustrating. Not only do you lose the ability to iterate fast, but you lose the ability to document and test your code in-situ, requiring you to create documentation and tests separately from source code. Nbdev is a literate programming framework that allows you to develop Python libraries within Jupyter Notebooks. This talk will describe the integration between Nbdev and Quarto, which enables library developers to author their documentation right alongside their code, and automatically produce a Quarto website for their package. The result is a seamless workflow for developing, documenting, and testing software packages all within Jupyter Notebooks, with no context-switching required.
-   [**Websites & Books & Blogs, oh my! Creating Rich Content with Quarto**](https://sched.co/11ibV): [(Talk recording)](https://www.rstudio.com/conference/2022/talks/sessions/quarto-deep-dive/websites-books-blogs-quarto/)
    -   Presented by [Devin Pastoor](https://github.com/dpastoor), Solutions Engineer at RStudio.
    -   Thursday July 28, 4:00pm - 4:20pm EDT.
    -   A number of packages have emerged in the R ecosystem to help create websites (hugodown), books (bookdown), and blogs (blogdown). In this talk, I'll show you how Quarto handles creating these types of content and more. Whether you're a grad student considering your first blog post about R, or a python expert about to write a technical book, I'll show you how Quarto enables you to focus on content while it takes care of the rest. In addition, I'll show the RStudio team is making it as easy as possible to publish and share content within your organization and to the whole community.

To find out more about the conference and register, visit [rstd.io/conf](https://rstd.io/conf). Looking forward to seeing you in DC!

Can't make it to the conference in person, but don't want to miss this content? You can follow along with the talks remotely via the live stream and we will share materials from the workshops in a post-conf roundup post.
```````

## File: docs/blog/posts/2022-07-25-feature-extensions/index.qmd
```````
---
title: Quarto Extensions
subtitle: Extend Quarto with new capabilities
description: | 
    Quarto Extensions are a powerful way to modify or extend the behavior of Quarto, and can be created and distributed by anyone. Extension types include filters, shortcodes, and custom formats.
categories:
  - Extensions
  - Features
author: J.J. Allaire
date: "7/25/2022"
image: extensions.png
image-alt: "The main page for the quarto-ext GitHub organization which lists extensions published by the Quarto core team."
---

Quarto Extensions are a powerful way to modify or extend the behavior of Quarto, and can be created and distributed by anyone. There are three types of extensions available:

-   [Shortcodes](/docs/extensions/shortcodes.qmd) are special markdown directives that generate various types of content. For example, you could create shortcodes to embed tweets or videos in a document.

-   [Filters](/docs/extensions/filters.qmd) are a flexible and powerful tool for introducing new global behaviors and/or new markdown rendering behaviors. For example, you could create filters to implement output folding, an image carousel, or just about anything you can imagine!

-   [Formats](/docs/extensions/formats.qmd) enable you to create new output formats by bundling together document options, templates, stylesheets, and other content.

Here are some examples of extensions developed and maintained by the core Quarto team:

| **Extension**                                                        | **Description**                                                                                 |
|------------------------------|------------------------------------------|
| [lightbox](https://github.com/quarto-ext/lightbox/)                  | Create lightbox treatments for images in your HTML documents.                                   |
| [fancy-text](https://github.com/quarto-ext/fancy-text)               | Output nicely formatted versions of fancy strings such as LaTeX and BibTeX in multiple formats. |
| [fontawesome](https://github.com/quarto-ext/fontawesome)             | Use Font Awesome icons in HTML and PDF documents.                                               |
| [latex-environment](https://github.com/quarto-ext/latex-environment) | Quarto extension to output custom LaTeX environments.                                           |

: {tbl-colwidths="\[30,70\]"}

To learn more about using extensions, see the [Extensions](/docs/extensions/index.qmd) documentation on the Quarto website. If you want to dive in to creating your own extensions check out the articles on [Creating Shortcodes](/docs/extensions/shortcodes.qmd), [Creating Filters](/docs/extensions/filters.qmd), and [Creating Formats](/docs/extensions/formats.qmd).
```````

## File: docs/blog/posts/2022-10-25-shinylive-extension/index.qmd
```````
---
title: Shinylive Extension
subtitle: Embed Shinylive applications in Quarto documents
description: |
  With Shinylive, you can embed Shiny for Python applications into Quarto documents and run the entire application (including the Python runtime) inside the user's web browser.
categories:
  - Extensions
  - Features
author: Winston Chang
date: "10/25/2022"
image: shinylive-embedded-app.png
image-alt: "Screenshot of a Quarto document with an embedded Shinylive application."
---

The new [Shinylive Quarto extension](https://github.com/quarto-ext/shinylive) makes it easy to embed Shiny for Python applications in your Quarto documents. This makes it possible to add interactivity to your documents with just Python code. For example, you can include an interactive Shiny application like this, directly inside your Quarto document.

[![](shinylive-embedded-app.png){.preview-image fig-align="center" fig-alt="Shinylive application embedded in a Quarto document."}](https://quarto-ext.github.io/shinylive/sine.html)

In case you're not already familiar with Shiny, here's some background: [Shiny](https://shiny.rstudio.com/) is a framework for creating web applications. Shiny was originally just for R, but we've recently released an alpha version of [Shiny for Python](https://shiny.rstudio.com/py/).

One of the exciting new features of Shiny for Python is a deployment method called Shinylive: the application can be run entirely within the browser, without needing a remote server running Python. Instead, Python runs _in the web browser_, thanks to the magic of [WebAssembly](https://webassembly.org/). In essence, but the server and client sides of the Shiny application run in the browser.

The Shiny for Python [website](https://shiny.rstudio.com/py/) contains many interactive, editable Shiny applications, and is built using this extension.

Bear in mind that not all Shiny applications can be deployed with Shinylive, in part because not all Python packages can run in WebAssembly -- but for those that can, this extension makes it possible to deploy the Quarto document with the embedded application on any web hosting service. To learn more about Shinylive, see [this page](https://shiny.rstudio.com/py/docs/shinylive.html).

The new Shinylive Quarto extension makes it easy to embed Shiny for Python applications in Quarto documents. This is a great way of adding interactive components to your Quarto document. And, once again, you don't need a server running Python to share these Quarto documents -- just deploy the generated files as you would for any other Quarto website.
```````

## File: docs/blog/posts/2023-03-13-code-annotation/index.qmd
```````
---
title: Code Annotation
subtitle: Add line based annotations to your code chunks
description: |
  In Quarto 1.3, you can add line based annotations to code chunks to highlight or explain parts of your code.
categories:
  - Features
  - Authoring
  - Quarto 1.3
author: Charlotte Wickham
date: "03/13/2023"
image: annotation.png
image-alt: "Screenshot a code chunk with annotations. Annotations appear in the code chunk as numbers within circles, and repeat below the code chunk along with the text content of the annotations."
code-annotations: below
---

{{< include ../_quarto-1.3-feature.qmd >}}

Code blocks and executable code cells in Quarto may now include line-based annotations. Line-based annotations provide a way to attach explanation to lines of code much like footnotes.

For example, this code uses annotation to describe the steps in an R dplyr pipeline in plain language:

``` r
library(tidyverse)
library(palmerpenguins)
penguins |>                                            # <1>
  mutate(                                              # <2>
    bill_ratio = bill_depth_mm / bill_length_mm,       # <2>
    bill_area  = bill_depth_mm * bill_length_mm        # <2>
  )                                                    # <2>
```

1.  Take `penguins`, and then,
2.  add new columns for the bill ratio and bill area.

The default HTML annotation style displays annotations in a list below the code block. Clicking on the annotation number in the list highlights the relevant lines in the code. Other HTML styles hide the annotations, revealing them in a tooltip when a user hovers or selects a marker.

The PDF format also allows for annotations, numbering, and displaying the annotation text below the code. In other formats, like Word and GitHub Markdown, annotations are instead labeled with the line of code (or lines of code) to which the annotation text applies.

::: panel-tabset
#### PDF

![](annote-pdf.png){fig-alt="Screenshot of output in PDF format showing code annotation."}

#### GitHub Flavored Markdown

```` markdown
``` r
library(tidyverse)
library(palmerpenguins)
penguins |>
  mutate(
    bill_ratio = bill_depth_mm / bill_length_mm,
    bill_area  = bill_depth_mm * bill_length_mm
  )
```

Line 3  
Take `penguins`, and then,

Lines 4-7  
add new columns for the bill ratio and bill area.
````
:::

To add code annotation to a code block, you need to add two things: specially formatted code comments in your code cell, and an ordered list below the code cell with the annotation text:

1.  **Code Comments**: Each annotated line in the code cell should be terminated with a comment (using the code cell's language comment character) followed by a space and then an annotation number enclosed in angle brackets (e.g. `# <2>`). You may repeat an annotation number if the annotation spans multiple lines.

2.  **Ordered List**: An ordered list should appear immediately after the code cell, and include the contents of each annotation. Each numbered item in the ordered list will correspond to the line(s) of code with the same annotation number.

For example, the annotations above were produced by including the following in the Quarto document:

```` markdown
```r
library(tidyverse)
library(palmerpenguins)
penguins |>                                      # <1>
  mutate(                                        # <2>
    bill_ratio = bill_depth_mm / bill_length_mm, # <2>
    bill_area  = bill_depth_mm * bill_length_mm  # <2>
  )                                              # <2>
```
1. Take `penguins`, and then,
2. add new columns for the bill ratio and bill area.
````

You can read more about how to control the annotation style, and whether annotations appear at all on the [Code Annotation page](/docs/authoring/code-annotation.qmd) of the pre-release highlights.
```````

## File: docs/blog/posts/2023-03-15-multi-format/index.qmd
```````
---
title: Multi-format Publishing
subtitle: Automatically link to other formats in HTML documents
description: |
  In Quarto 1.3, additional formats listed in HTML documents will automatically be linked in an "Other Formats" section near the top of the page.
categories:
  - Features
  - Authoring
  - Quarto 1.3
author: Charlotte Wickham
date: "03/15/2023"
image: multi-format.png
image-alt: "Screenshot of a Quarto webpage showing a section entitled 'Other Formats' with items Jupyter and MS Word"
format:
  html: default
  ipynb: default
  docx: default
---

{{< include ../_quarto-1.3-feature.qmd >}}

Starting in Quarto 1.3, HTML pages (either standalone or in a website) can automatically include links to other formats specified in the document front matter. For example, the following document front matter:

``` yaml
title: Sample Page
author: Norah Jones
date: last-modified
toc: true
format: 
  html: default
  ipynb: default
```

Results in an HTML page that includes a link to the additional notebook format in the right margin below the table of contents:

![](other-format.png){.border fig-alt="Screenshot of a HTML page that includes a link to the Jupyter format below the table of contents under the heading Other Formats."}

If a table of contents is enabled for the page, the additional formats will be automatically placed within the table of contents as a new section. If no table of contents is displayed, the additional formats will be displayed in the right margin at the top of the document.

Links to additional formats are displayed by default, but you can control whether they are shown or even which specific formats are included with the `format-links` YAML option.

Read more about this feature on the [Multi-format page](/docs/output-formats/html-multi-format.qmd) of the pre-release highlights.
```````

## File: docs/blog/posts/2023-03-17-jupyter-cell-embedding/index.qmd
```````
---
title: Jupyter Notebook Cell Embedding
subtitle: Embed output from an external Jupyter Notebook in a Quarto document
description: |
  Quarto 1.3 adds support for embedding cells from a Jupyter Notebook into a Quarto document via an `embed` shortcode. In HTML documents, links are automatically added that point to a rendered version of the external notebook.
categories:
  - Features
  - Authoring
  - Quarto 1.3
author: Charlotte Wickham
date: "03/17/2023"
image: embed.png
image-alt: "A screenshot of a Quarto page that includes a plot, below the plot is the phrase Source: penguins.ipynb."
---

{{< include ../_quarto-1.3-feature.qmd >}}

Starting in Quarto 1.3, you can include the output of an external Jupyter notebook in a Quarto document with the `embed` shortcode. To embed a notebook cell, provide the path to a Jupyter Notebook and a cell identifier. For example, this notebook called `penguins.ipynb` has a cell labelled `fig-bill-scatter`:

![](notebook-simple.png){fig-alt="A screenshot of a Jupyter Notebook with the name 'penguins.ipynb', with a cell highlighted that has the code chunk option label set to fig-bill-scatter. Below the cell is a plot that has been output."}

You can use the following shortcode to embed the output of this cell:

``` {.markdown shortcodes="false"}
{{< embed penguins.ipynb#fig-bill-scatter >}}
```

This will embed the plot as follows:

{{< embed penguins.ipynb#fig-bill-scatter >}}

A link to the source notebook is automatically provided beneath the plot. Following the link takes users to a rendered version of the notebook, allowing them to explore the notebook without having to download and run it locally. For example, clicking on the link to `penguins.ipynb` gets you to a page that looks like the following:

![](notebook-view.png){.border fig-alt="A screenshot of webpage with the title 'penguins.ipynb', a large blue button labelled 'Download Notebook', followed by the notebook contents."}

Beyond this basic usage, head to the [Jupyter Cell Embedding highlight docs](/docs/authoring/notebook-embed.qmd) to learn how to:

-   Specify cells in multiple ways, see [Specifying Cells](/docs/authoring/notebook-embed.qmd#specifying-cells).

-   Control the output using code cell options in the source Notebook, including things like figure captions, figure layout, and code display, see [Code Cell Options](/docs/authoring/notebook-embed.qmd#code-cell-options).

-   Include the cell code along with the output by adding an `echo` option to the shortcode, see [Embedding Code](/docs/authoring/notebook-embed.qmd#embedding-code).

-   Customize or exclude the link to the source notebook, see [Links to Source Notebooks](/docs/authoring/notebook-embed.qmd#linked-source-notebooks).
```````

## File: docs/blog/posts/2023-03-20-confluence/index.qmd
```````
---
title: Confluence Publishing
subtitle: Publish from Quarto to Confluence
description: |
  Quarto 1.3 adds support for publishing individual documents, and projects containing many documents to Atlassian Confluence.
categories:
  - Features
  - Authoring
  - Quarto 1.3
author: Charlotte Wickham
date: "03/20/2023"
image: confluence-logo-gradient-blue-attribution_rgb@2x.png
image-alt: "Atlassian Confluence Logo"
---

{{< include ../_quarto-1.3-feature.qmd >}}

[Atlassian Confluence](https://www.atlassian.com/software/confluence) is a publishing platform for supporting team collaboration. Confluence has a variety of hosting options which include both free and paid subscription plans.

Quarto 1.3 adds support for publishing individual documents, as well as projects composed of multiple documents into [Confluence Spaces](https://support.atlassian.com/confluence-cloud/docs/use-spaces-to-organize-your-work/).

::: {layout-ncol="2"}
![A Quarto Document](images/confluence-qmd.png){fig-alt="A screenshot of a Quarto document with the title Using R - Doc in the RStudio Editor."}

![Published to Confluence](images/confluence-page.png){fig-alt="A screenshot of a document with the title Using R - Doc in a Confluence Space."}
:::

::: {layout="[800,969]"}
![A Quarto Project](images/confluence-project.png){fig-alt="A screenshot of a Quarto project in VS Code. On the left in the Explorer, the project folder is called 'Guide-site', and contains folders 'authoring', and 'computation', along with some other files. A document from the folder 'python' inside the folder 'computations' with the title 'Using Python - site' is open in the Source Pane. "}

![Published to Confluence](images/confluence-site.png){fig-alt="A screenshot of Space in Confluence. On the left in the Sdiebar under Pages is a page called 'Guide-site'. Nested under this page are pages called 'authoring', and 'computation', along with some other pages. The 'computation' page item is expanded and shows a page called 'Using Python - site', nested under a page called 'python'. A page is displayed on the right with the title 'Using Python - site'"}
:::

Managing Confluence content with Quarto allows you to author content in Markdown, manage that content with your usual version control tools like Git and GitHub, and leverage Quarto's tools for including computational output.

<!-- Quick overview of key features: new format and project type, local preview, `quarto publish confluence`. -->

If you're curious about using Confluence Publishing for your own project, head to the [Confluence Publishing page](/docs/publishing/confluence.qmd) of the pre-release highlights to learn more.
```````

## File: docs/blog/posts/2023-04-26-1.3-release/index.qmd
```````
---
title: Quarto 1.3 
subtitle: Quarto 1.3 is officially released
description: |
  Quarto 1.3 brings new features, improvements, and fixes.
categories:
  - Quarto 1.3
  - Releases
author: Charlotte Wickham
date: "04/26/2023"
image: "arthur-chauvineau-Dn7P1U26ZkE-unsplash.jpeg"
image-alt: "Fireworks with a silhouette of an audience"
---

We are happy to announce that Quarto 1.3 has been released. You can grab the current release from the [download page](/docs/download/index.qmd).

If you are ever wondering which version of Quarto you are using, a quick way to check on the command line is:

``` {.bash filename="Terminal"}
quarto --version
```

We've previously blogged about some of the features of this release that we were most excited about, but let's highlight them again.

## Code Annotation

You can now add line-based annotations to your code blocks using special code comments along with an ordered list. Code annotations work across many formats, and are interactive in HTML-based formats.

![Code Annotation in an HTML document](../2023-03-13-code-annotation/annotation.png){fig-alt="Screenshot a code chunk with annotations. Annotations appear in the code chunk as numbers within circles, and repeat below the code chunk along with the text content of the annotations."}

To learn more, check out the [Code Annotation](/docs/authoring/code-annotation.qmd) documentation.

## Multi-format Publishing

HTML pages (either standalone or in a website) now automatically include links to other formats specified in the document front matter. For example, the following document front matter:

``` yaml
title: Sample Page
author: Norah Jones
date: last-modified
toc: true
format: 
  html: default
  ipynb: default
```

Results in an HTML page that includes a link to the additional notebook format in the right margin below the table of contents:

![An HTML document with a link to another format](/docs/output-formats/images/other-format.png){.border fig-alt="Screenshot of an HTML page that includes a link to the Jupyter format below the table of contents under the heading Other Formats."}

Find out more in the documentation on [Including Other Formats](/docs/output-formats/html-multi-format.qmd).

## Jupyter Cell Embedding

Easily include the output of an external Jupyter notebook in a Quarto document with the `embed` shortcode. Provide the path to a Jupyter Notebook and a cell identifier and the output will be included in your document along with a link back to the source Notebook.

![A plot embedded in a document from a Jupyter Notebook](../2023-03-17-jupyter-cell-embedding/embed.png){fig-alt="A screenshot of a Quarto page that includes a plot, below the plot is the phrase Source: penguins.ipynb."}

Learn more about the embed shortcode in [Embedding Jupyter Notebook Cells](/docs/authoring/notebook-embed.qmd) in the docs.

## Confluence Publishing

[Atlassian Confluence](https://www.atlassian.com/software/confluence) is a publishing platform for supporting team collaboration. Quarto now provides support for publishing individual documents, as well as projects composed of multiple documents, into [Confluence Spaces](https://support.atlassian.com/confluence-cloud/docs/use-spaces-to-organize-your-work/).

::: {layout="[800,969]"}
![A Quarto Project](/docs/publishing/images/confluence-project.png){fig-alt="A screenshot of a Quarto project in VS Code. On the left in the Explorer, the project folder is called 'Guide-site', and contains folders 'authoring', and 'computation', along with some other files. A document from the folder 'python' inside the folder 'computations' with the title 'Using Python - site' is open in the Source Pane. "}

![Published to Confluence](/docs/publishing/images/confluence-site.png){fig-alt="A screenshot of Space in Confluence. On the left in the Sdiebar under Pages is a page called 'Guide-site'. Nested under this page are pages called 'authoring', and 'computation', along with some other pages. The 'computation' page item is expanded and shows a page called 'Using Python - site', nested under a page called 'python'. A page is displayed on the right with the title 'Using Python - site'"}
:::

To learn more, head to the documentation on [Confluence Publishing](/docs/publishing/confluence.qmd).

## Other Highlights

Some other notable highlights include:

-   [Article Grid Customization](/docs/output-formats/page-layout.qmd#grid-customization)---Customize the widths of layout components in HTML documents

-   [Quarto Book AsciiDoc Support](/docs/books/book-basics.qmd)---Output Quarto books to AsciiDoc files

-   [Website Navigation Improvements](/docs/prerelease/1.3/website-nav.qmd)---Include tools in your navbar, and provide better navigation for Quarto websites on mobile devices

-   [Mermaid Diagram Theming](/docs/authoring/diagrams.qmd#mermaid-theming)---Use your document theme, or built-in Mermaid themes, for your Mermaid diagrams 

-   [PDF: SVG and Remote Images](/docs/prerelease/1.3/pdf.qmd)---Include SVG images and remote images in PDF documents

-   [`kbd` Shortcode](/docs/authoring/markdown-basics.qmd#keyboard-shortcuts)---Show well-formatted keyboard shortcuts in Quarto documents.

You can find all the other changes in 1.3, in the [Release Notes](/docs/download/index.qmd#download-section-news).

## Acknowledgements

We'd like to say a huge thank you to everyone who contributed to this release by opening issues and pull requests:

[ABohynDOE](https://github.com/ABohynDOE), [aborruso](https://github.com/aborruso), [agerlach](https://github.com/agerlach), [aimundo](https://github.com/aimundo), [alperyilmaz](https://github.com/alperyilmaz), [ameliaritger](https://github.com/ameliaritger), [anaveenan](https://github.com/anaveenan), [andrewheiss](https://github.com/andrewheiss), [apreshill](https://github.com/apreshill), [apsteinmetz](https://github.com/apsteinmetz), [arnaudgallou](https://github.com/arnaudgallou), [aronatkins](https://github.com/aronatkins), [arronlacey](https://github.com/arronlacey), [ArturKlauser](https://github.com/ArturKlauser), [astrowonk](https://github.com/astrowonk), [ats](https://github.com/ats), [awehrfritz](https://github.com/awehrfritz), [b-rodrigues](https://github.com/b-rodrigues), [baptiste](https://github.com/baptiste), [batpigandme](https://github.com/batpigandme), [bayeslearner](https://github.com/bayeslearner), [benabel](https://github.com/benabel), [BertTijhuis](https://github.com/BertTijhuis), [boshek](https://github.com/boshek), [brunomioto](https://github.com/brunomioto), [busemorose](https://github.com/busemorose), [bvancil](https://github.com/bvancil), [bwelman](https://github.com/bwelman), [cboettig](https://github.com/cboettig), [cgoo4](https://github.com/cgoo4), [ChoCho66](https://github.com/ChoCho66), [cicarrascog](https://github.com/cicarrascog), [coatless](https://github.com/coatless), [code86](https://github.com/code86), [condwanaland](https://github.com/condwanaland), [daniel-smit-haw](https://github.com/daniel-smit-haw), [daranzolin](https://github.com/daranzolin), [davidbudzynski](https://github.com/davidbudzynski), [DavidD003](https://github.com/DavidD003), [ddobrinskiy](https://github.com/ddobrinskiy), [dgkf](https://github.com/dgkf), [DhruvaSambrani](https://github.com/DhruvaSambrani), [directknowledge](https://github.com/directknowledge), [dkubek](https://github.com/dkubek), [dmalan](https://github.com/dmalan), [dmenne](https://github.com/dmenne), [drcaprosser](https://github.com/drcaprosser), [drscotthawley](https://github.com/drscotthawley), [edoson](https://github.com/edoson), [eeholmes](https://github.com/eeholmes), [eitsupi](https://github.com/eitsupi), [elgabbas](https://github.com/elgabbas), [EllaKaye](https://github.com/EllaKaye), [emmansh](https://github.com/emmansh), [ericvmai](https://github.com/ericvmai), [espinielli](https://github.com/espinielli), [etiennebacher](https://github.com/etiennebacher), [EvoArt](https://github.com/EvoArt), [fire](https://github.com/fire), [fortunewalla](https://github.com/fortunewalla), [freestatman](https://github.com/freestatman), [fuhrmanator](https://github.com/fuhrmanator), [fulem](https://github.com/fulem), [g-simmons](https://github.com/g-simmons), [gadenbuie](https://github.com/gadenbuie), [GegznaV](https://github.com/GegznaV), [ghost](https://github.com/ghost), [giabaio](https://github.com/giabaio), [githubpsyche](https://github.com/githubpsyche), [GraceEMc](https://github.com/GraceEMc), [gregswinehart](https://github.com/gregswinehart), [GShotwell](https://github.com/GShotwell), [guoruizhong](https://github.com/guoruizhong), [harrelfe](https://github.com/harrelfe), [hemonika](https://github.com/hemonika), [henningsway](https://github.com/henningsway), [iandol](https://github.com/iandol), [ijlyttle](https://github.com/ijlyttle), [iusgit](https://github.com/iusgit), [ivanek](https://github.com/ivanek), [jake-wittman](https://github.com/jake-wittman), [jakobarendt](https://github.com/jakobarendt), [jakub-jedrusiak](https://github.com/jakub-jedrusiak), [javajon](https://github.com/javajon), [jcmkk3](https://github.com/jcmkk3), [jcolomb](https://github.com/jcolomb), [jdutant](https://github.com/jdutant), [JeffreyRacine](https://github.com/JeffreyRacine), [jensschroer](https://github.com/jensschroer), [jeremiahpslewis](https://github.com/jeremiahpslewis), [jfbarthelemy](https://github.com/jfbarthelemy), [jhelvy](https://github.com/jhelvy), [Jiayou-Chao](https://github.com/Jiayou-Chao), [jimjam-slam](https://github.com/jimjam-slam), [jkylearmstrong](https://github.com/jkylearmstrong), [jmbarbone](https://github.com/jmbarbone), [jmbuhr](https://github.com/jmbuhr), [jmcastagnetto](https://github.com/jmcastagnetto), [joelvonrotz](https://github.com/joelvonrotz), [JoFrhwld](https://github.com/JoFrhwld), [johannes4998](https://github.com/johannes4998), [jrcuesta](https://github.com/jrcuesta), [jthomasmock](https://github.com/jthomasmock), [juba](https://github.com/juba), [justanothergithubber](https://github.com/justanothergithubber), [KaiWaldrant](https://github.com/KaiWaldrant), [kalenkovich](https://github.com/kalenkovich), [kdheepak](https://github.com/kdheepak), [kelly-sovacool](https://github.com/kelly-sovacool), [KittJonathan](https://github.com/KittJonathan), [kmasiello](https://github.com/kmasiello), [knuesel](https://github.com/knuesel), [koehlerson](https://github.com/koehlerson), [koushikkhan](https://github.com/koushikkhan), [lcnbr](https://github.com/lcnbr), [leovan](https://github.com/leovan), [linogaliana](https://github.com/linogaliana), [m-legrand](https://github.com/m-legrand), [m4jing](https://github.com/m4jing), [machow](https://github.com/machow), [maelle](https://github.com/maelle), [malcolmbarrett](https://github.com/malcolmbarrett), [marierivers](https://github.com/marierivers), [MattF-NSIDC](https://github.com/MattF-NSIDC), [mattsams89](https://github.com/mattsams89), [mattwarkentin](https://github.com/mattwarkentin), [maxdrohde](https://github.com/maxdrohde), [mccarthy-m-g](https://github.com/mccarthy-m-g), [MHellmund](https://github.com/MHellmund), [mikheyev](https://github.com/mikheyev), [mine-cetinkaya-rundel](https://github.com/mine-cetinkaya-rundel), [mksinicus](https://github.com/mksinicus), [mrajeev08](https://github.com/mrajeev08), [nanxstats](https://github.com/nanxstats), [NeubertJonas](https://github.com/NeubertJonas), [nikcleju](https://github.com/nikcleju), [njbart](https://github.com/njbart), [patrickvdb](https://github.com/patrickvdb), [petrbouchal](https://github.com/petrbouchal), [philip-khor](https://github.com/philip-khor), [philwunderlich](https://github.com/philwunderlich), [Pierre9344](https://github.com/Pierre9344), [pitmonticone](https://github.com/pitmonticone), [pmagwene](https://github.com/pmagwene), [poldrack](https://github.com/poldrack), [pommevilla](https://github.com/pommevilla), [psychelzh](https://github.com/psychelzh), [ratnanil](https://github.com/ratnanil), [ravimakhija](https://github.com/ravimakhija), [RaymondBalise](https://github.com/RaymondBalise), [reuning](https://github.com/reuning), [rexdouglass](https://github.com/rexdouglass), [rgaiacs](https://github.com/rgaiacs), [richardsprague](https://github.com/richardsprague), [rjake](https://github.com/rjake), [rleyvasal](https://github.com/rleyvasal), [rmcd1024](https://github.com/rmcd1024), [RobTour](https://github.com/RobTour), [rsenft1](https://github.com/rsenft1), [runlevel0](https://github.com/runlevel0), [sagikazarmark](https://github.com/sagikazarmark), [salim-b](https://github.com/salim-b), [SamEdwardes](https://github.com/SamEdwardes), [samperman](https://github.com/samperman), [schochastics](https://github.com/schochastics), [ScientiaFelis](https://github.com/ScientiaFelis), [scottamain](https://github.com/scottamain), [scottfranz](https://github.com/scottfranz), [sebastian-c](https://github.com/sebastian-c), [seeM](https://github.com/seeM), [shafayetShafee](https://github.com/shafayetShafee), [singuyenmai](https://github.com/singuyenmai), [sje30](https://github.com/sje30), [snhansen](https://github.com/snhansen), [streepvaren](https://github.com/streepvaren), [thedabs91](https://github.com/thedabs91), [thomashallam](https://github.com/thomashallam), [timothee-bacri](https://github.com/timothee-bacri), [tomshafer](https://github.com/tomshafer), [tomsutch](https://github.com/tomsutch), [tomvaneyck](https://github.com/tomvaneyck), [topepo](https://github.com/topepo), [tverbeiren](https://github.com/tverbeiren), [TylerHillery](https://github.com/TylerHillery), [ucpresearch](https://github.com/ucpresearch), [verbalins](https://github.com/verbalins), [vfacta](https://github.com/vfacta), [vlyubchich](https://github.com/vlyubchich), [VMTdeJong](https://github.com/VMTdeJong), [vpratz](https://github.com/vpratz), [white-c](https://github.com/white-c), [wklimowicz](https://github.com/wklimowicz), [XiangyunHuang](https://github.com/XiangyunHuang), [Xitian9](https://github.com/Xitian9), [xl0](https://github.com/xl0), [xtimbeau](https://github.com/xtimbeau), [y9c](https://github.com/y9c), [yevgenryeznik](https://github.com/yevgenryeznik), [zachcp](https://github.com/zachcp), [zkwabm](https://github.com/zkwabm)
```````

## File: docs/blog/posts/2023-05-15-get-started/index.qmd
```````
---
title: Get Started with Quarto
subtitle: A video to jumpstart your Quarto journey
description: |
  A new video for getting started with Quarto using R and RStudio.
categories:
  - Learn
author: Mine Çetinkaya-Rundel
date: "05/15/2023"
image: "get-started-video-cover.png"
image-alt: "Quarto logo on a blue background and the title of the video - Get started with Quarto"
---

Have you been hearing about Quarto but didn't give it a try yet? Perused the [Get Started](/docs/get-started/index.qmd) pages but would like another intro? Or have about 20 minutes to spare and want to pick up a few Quarto tips? You've come to the right place!

{{< video "https://www.youtube.com/embed/_f3latmOhew" >}}

In this video, I walk you through creating documents, presentations, and websites and publishing with Quarto. The video features authoring Quarto documents with executable R code chunks using the [RStudio Visual Editor](/docs/visual-editor/index.qmd).

Select highlights include:

-   Inserting [cross references](/docs/authoring/cross-references.qmd) to tables and figures
-   Adding a [citation](/docs/visual-editor/technical.qmd#citations) from a DOI
-   Seamlessly switching between output formats as well as creating [multi-format documents](/docs/output-formats/html-multi-format.qmd)
-   Customizing the [output location](/docs/presentations/revealjs/#output-location) of code in presentations
-   Creating a [website](/docs/websites/website-basics.qmd) from scratch
-   Publishing the website to [QuartoPub](/docs/publishing/quarto-pub.qmd)

If you would like to follow along as you watch the video, you can find the source code for everything created in the video in [this GitHub repository](https://github.com/mine-cetinkaya-rundel/get-started-quarto) and the published [website on QuartoPub](https://mine.quarto.pub/welcome-to-quarto/).
```````

## File: docs/blog/posts/2023-05-22-quarto-for-academics/index.qmd
```````
---
title: Quarto for Academics
subtitle: A potpourri of Quarto features useful for academics
description: |
  A video highlighting some of Quarto's features that are especially useful for academics, as educators and as researchers.
categories:
  - Learn
author: Mine Çetinkaya-Rundel
date: "05/22/2023"
image: "quarto-for-academics-video-cover.png"
image-alt: "Quarto logo on a blue background and the title of the video - Quarto for Academics"
---

Quarto offers a myriad of features that are especially useful for academics, as educators and as researchers. These range from chunk options that enable automatic linking of code to documentation, to article templates for manuscript submission to multiple journals. The following video walks you through some of these features.

{{< video "https://www.youtube.com/embed/EbAAmrB0luA" >}}

Select highlights include:

-   Linking to documentation from code with [`code-link`](/docs/output-formats/html-code.qmd#code-linking).
-   Informative YAML errors and YAML completion.
-   Creating Quarto slides with [revealjs](/docs/presentations/revealjs/index.qmd).
-   [PDF export](/docs/presentations/revealjs/presenting.qmd#print-to-pdf) of HTML slides.
-   Annotating slides with [`chalkboard`](/docs/presentations/revealjs/presenting.qmd#chalkboard).
-   Advancing slides for your audience with [`multiplex`](/docs/presentations/revealjs/presenting.qmd#multiplex).
-   Highlighting code with [`code-line-numbers`](/docs/presentations/revealjs/#line-highlighting).
-   Customizing output location with [`output-location`](/docs/presentations/revealjs/index.qmd#output-location).
-   Showing code chunk fences with [`echo: fenced`](/docs/computations/execution-options.qmd#fenced-echo).
-   [Code annotation](/docs/authoring/code-annotation.qmd).
-   Authoring manuscripts with Quarto [journal templates](/docs/journals/index.qmd).
-   [Inserting citations](/docs/visual-editor/technical.qmd#citations) from Zotero or from a DOI with the [RStudio Visual Editor](/docs/visual-editor/index.qmd).

If you would like to follow along as you watch, you can find the source code for everything created in the video in [this GitHub repository](https://github.com/mine-cetinkaya-rundel/quarto-for-academics).
```````

## File: docs/blog/posts/2023-12-05-asa-traveling-courses/index.qmd
```````
---
title: ASA Traveling Courses on Quarto
subtitle: From R Markdown to Quarto
description: |
  Series of workshops for learning Quarto with R and RStudio, aimed primarily at R Markdown users.
categories:
  - Learn
author: Mine Çetinkaya-Rundel
date: "12/5/2023"
image: "asa-traveling-courses.png"
image-alt: "Screenshots of homepages of six courses titled From R Markdown to Quarto"
---

In 2023, [Dr. Andrew Bray](https://andrewpbray.github.io/) and I gave a series of six workshops on Quarto as part of the [Traveling Courses](https://community.amstat.org/coc/chapterresources/travelingcourse) program sponsored by the [American Statistical Association](https://www.amstat.org/).

The workshop was designed for those who want to take their R Markdown skills and expertise and apply them in Quarto, the next generation of R Markdown. Participants learned how to apply their reproducible authoring skills to the Quarto format and about new tools and workflows for authoring with Quarto in RStudio. The workshop covered creating static documents and presentations, building websites, and writing blogs and books. Finally, participants learned various ways to deploy and publish their Quarto projects on the web.

Home pages and links to source code for each of the six workshops are listed below:

+--------------------------------------------------------------------------------------------------------+-----------------------------------------------------------------------------------------------------------------------------------------------+
| Nebraska Chapter\                                                                                      | [![](asa-nebraska.png){fig-alt="Homepage of Nebraska Chapter workshop" width="400"}](https://mine.quarto.pub/quarto-asa-nebraska/)            |
| Omaha, Nebraska\                                                                                       |                                                                                                                                               |
| April 28, 2023\                                                                                        |                                                                                                                                               |
| [mine.quarto.pub/quarto-asa-nebraska](https://mine.quarto.pub/quarto-asa-nebraska/)\                   |                                                                                                                                               |
| [Source](https://github.com/asa-quarto/website-nebraska/tree/nebraska-workshop)\                       |                                                                                                                                               |
+--------------------------------------------------------------------------------------------------------+-----------------------------------------------------------------------------------------------------------------------------------------------+
| Oregon Chapter\                                                                                        | [![](asa-oregon.png){fig-alt="Homepage of Oregon Chapter workshop" width="400"}](https://andrew.quarto.pub/oregon-asa/)                       |
| Portland, Oregon\                                                                                      |                                                                                                                                               |
| June 10, 2023\                                                                                         |                                                                                                                                               |
| [andrew.quarto.pub/oregon-asa](https://andrew.quarto.pub/oregon-asa/)\                                 |                                                                                                                                               |
| [Source](https://github.com/andrewpbray/quarto-asa/tree/oregon-chapter)\                               |                                                                                                                                               |
+--------------------------------------------------------------------------------------------------------+-----------------------------------------------------------------------------------------------------------------------------------------------+
| Alaska Chapter\                                                                                        | [![](asa-alaska.png){fig-alt="Homepage of Alaska Chapter workshop" width="400"}](https://andrew.quarto.pub/alaska-asa/)                       |
| Anchorage, Alaska\                                                                                     |                                                                                                                                               |
| June 20, 2023\                                                                                         |                                                                                                                                               |
| [andrew.quarto.pub/alaska-asa/](https://andrew.quarto.pub/alaska-asa/)\                                |                                                                                                                                               |
| [Source](https://github.com/asa-quarto/website/tree/alaska-workshop)\                                  |                                                                                                                                               |
+--------------------------------------------------------------------------------------------------------+-----------------------------------------------------------------------------------------------------------------------------------------------+
| Ohio Chapter\                                                                                          | [![](asa-ohio.png){fig-alt="Homepage of Ohio Chapter workshop" width="400"}](https://andrew.quarto.pub/ohio-asa/)                             |
| Virtual Workshop on Zoom\                                                                              |                                                                                                                                               |
| August 18, 2023\                                                                                       |                                                                                                                                               |
| [andrew.quarto.pub/ohio-as](https://andrew.quarto.pub/ohio-asa/)\                                      |                                                                                                                                               |
| [Source](https://github.com/asa-quarto/website/tree/ohio-workshop)\                                    |                                                                                                                                               |
+--------------------------------------------------------------------------------------------------------+-----------------------------------------------------------------------------------------------------------------------------------------------+
| Boston Chapter\                                                                                        | [![](asa-boston.png){fig-alt="Homepage of Boston Chapter workshop" width="400"}](https://andrew.quarto.pub/boston-asa/)                       |
| Virtual Workshop on Zoom\                                                                              |                                                                                                                                               |
| September 20, 2023\                                                                                    |                                                                                                                                               |
| [andrew.quarto.pub/boston-asa](https://andrew.quarto.pub/boston-asa/)\                                 |                                                                                                                                               |
| [Source](https://github.com/asa-quarto/website/tree/boston-workshop)\                                  |                                                                                                                                               |
+--------------------------------------------------------------------------------------------------------+-----------------------------------------------------------------------------------------------------------------------------------------------+
| Mid-Tennessee Chapter\                                                                                 | [![](asa-mid-tennessee.png){fig-alt="Homepage of Mid-Tennessee Chapter workshop" width="400"}](https://mine.quarto.pub/quarto-asa-nashville/) |
| Nashville, Tennessee\                                                                                  |                                                                                                                                               |
| October 20, 2023\                                                                                      |                                                                                                                                               |
| [mine.quarto.pub/quarto-asa-nashville](https://github.com/asa-quarto/website/tree/nashville-workshop)\ |                                                                                                                                               |
| [Source](https://github.com/asa-quarto/website/releases/tag/nashville-workshop)\                       |                                                                                                                                               |
+--------------------------------------------------------------------------------------------------------+-----------------------------------------------------------------------------------------------------------------------------------------------+

: {tbl-colwidths="\[50,50\]"}

One of the Quarto features we leveraged in organizing these materials is that you can publish to different QuartoPub URLs from the same repository with `quarto publish`. After each workshop, we created a release on GitHub to take a snapshot of the materials for that workshop, and for the subsequent workshop, we made edits to the materials on the `main` branch and published them to a new URL.

The source code for everything can be found at [github.com/asa-quarto/website](https://github.com/asa-quarto/website). Also in the GitHub organization is a repo containing the "your turn" exercises for the workshops: [github.com/asa-quarto/exercises](https://github.com/asa-quarto/exercises).

All materials are released with Creative Commons Attribution-ShareAlike 4.0 International license. If you are teaching a Quarto workshop, feel free to reuse any and all of these materials. And if you're learning Quarto, you might find it helpful to follow along with any of the workshops listed above.

Happy learning and happy teaching!
```````

## File: docs/blog/posts/2023-12-07-quarto-dashboards-demo/index.qmd
```````
---
title: Quarto Dashboards Demonstration
subtitle: A brief tour of how to build a dashboard in Quarto v1.4.
categories:
  - Demo
  - Quarto 1.4
author: Andrew Holz
date: "12/7/2023"
image: "quarto-dashboards-video-cover.png"
image-alt: "Quarto logo on a blue background with the title Quarto Dashboards, Charles Teague and an abstract dashboard sketch"
---

Quarto has a host of exciting new features in release v1.4 with one of the most anticipated being Quarto Dashboards. In a recent internal presentation, Charles Teague demonstrated the new capabilities and we wanted to share it with community.

Please note that you can use this feature today, but to access it you need to be running on a recent [Quarto prerelease build](/docs/download/prerelease.qmd). We also encourage users to review our [pre-release documentation](/docs/dashboards/index.qmd) which offers additional information and examples of the dashboard functionality.

{{< video “https://www.youtube.com/watch?v=_VGJIPRGTy4&ab_channel=PositPBC” >}}
```````

## File: docs/blog/posts/2024-01-24-1.4-release/index.qmd
```````
---
title: Quarto 1.4 
subtitle: Quarto 1.4 is released
description: |
  Quarto 1.4 brings new formats for dashboards and Typst, a new manuscript project type, a cross-reference overhaul, Shiny for Python support, and a ton of other updates.
categories:
  - Quarto 1.4
  - Releases
author: Charlotte Wickham
date: "01/24/2024"
image: "images/thumbnail.png"
image-alt: "Quarto 1.4 with a party popper"
---

Quarto 1.4 has been officially released! You can get the current release from the [download page](/docs/download/index.qmd)

This release has tons of new features. Some of the big ones we want to spotlight are: Dashboards, Typst, Inline Code Syntax, Cross-References and Manuscripts.

## Dashboards

Quarto Dashboards streamline the creation of interactive dashboards, giving you an effortless way to lay out interactive components, visualizations, tabular data, and annotations. Here are some examples (click on the image to visit the live version):

::: {layout-ncol="3"}
[![](/docs/dashboards/examples/thumbnails/stock-explorer-dashboard.png){.border fig-alt="Screenshot of a Stock Trader dashboard: a row of three values boxes, then a row with a stock ticker graph and a table of closing values. Navy blue and green theme."}](https://jjallaire.github.io/stock-explorer-dashboard/)

[![](/docs/dashboards/examples/thumbnails/customer-churn-dashboard.png){.border fig-alt="Screenshot of a Customer Churn dashboard: a row of three values boxes, then a row with two plots, then a row with a table. Light blue and yellow theme."}](https://jjallaire.github.io/customer-churn-dashboard/)

[![](/docs/dashboards/examples/thumbnails/penguins-dashboard.png){.border fig-alt="Screenshot of a Palmer Penguins dashboard: a sidebar with checkboxes and a dropdown, and two plots in main panel. Blue theme."}](https://jjallaire.shinyapps.io/penguins-dashboard/)
:::

For the source code of these dashboards and additional examples see the [examples gallery](/docs/gallery/index.qmd#dashboards). When you are ready to build your own Quarto dashboard head to our guide on [Dashboards](/docs/dashboards/index.qmd).

## Typst

[Typst](https://github.com/typst/typst){.external} is a new open-source markup-based typesetting system that is designed to be as powerful as LaTeX while being much easier to learn and use. Typst creates beautiful PDF output with blazing fast render times.

Quarto 1.4 includes the Typst CLI, so all you need to get started creating PDFs via Typst is to use `format: typst`: 

````{.markdown filename="hello-typst.qmd"}
---
title: "Hello Typst!"
format: typst
---

My first Typst document
````

We are particularly excited about how easy it is to make templates for journal articles, conference posters, newsletters and more with Typst. Here are some examples you can use in Quarto as [custom formats](/docs/output-formats/typst-custom.qmd):

::: {layout-ncol=4}

![IEEE](images/typst-format-ieee.png){.lightbox group="custom-formats" fig-alt="Screenshot of a page showing a article styled according IEEE standards. The title is centered with authors below in two columns."}

![Poster](images/typst-format-poster.png){.lightbox group="custom-formats" fig-alt="Screenshot of a poster in landscape orientiation. The poster includes a logo in the top right, a title in the top left, and content arranged in three columns."}

![Letter](images/typst-format-letter.png){.lightbox group="custom-formats" fig-alt="Screenshot of a page showing a letter. A sender address is across the top of the page, followed by a recipient address left justified. The body of the letter includes a subject line in bold."}

![Dept News](images/typst-format-dept-news.png){.lightbox group="custom-formats" fig-alt="Screenshot of a page showing a department newsletter. The page is split vertically with a white column on the left and a red one on the right. An image spans across the column with the text \"Award Winning Science\" oriented to run vertically down its right side."}

:::

Start your Typst journey with Quarto in our guide on [Typst Basics](/docs/output-formats/typst.qmd).

## Inline Code Syntax

Quarto 1.4 introduces a unified syntax for including computed values inline. The syntax for inline code is similar to code blocks, except you use a single tick (`` ` ``) rather than triple ticks (```` ``` ````), and you can use it in the middle of markdown:

::: {layout-ncol="3"}

::: {}
### Jupyter

```` markdown
```{{python}}
radius = 5
```

The radius of the circle is `{python} radius`
````

This syntax works for any Jupyter kernel---so for Julia you would write an inline expression as `` `{julia} radius` ``).

:::

::: {}

### Knitr

```` markdown
```{{r}}
radius <- 5
```

The radius of the circle is `{r} radius`
````

:::

::: {}
### OJS

```` markdown
```{{ojs}}
radius = 5
```

The radius of the circle is `{ojs} radius`
````
:::

:::

And don't worry if you are used to using `` `r ` `` that syntax remains fully supported. Read more at [Inline Code](/docs/computations/inline-code.qmd).

## Cross-References

Cross-references have been overhauled in Quarto 1.4, enabling you to do things like:

*   Flexibly define the content of float cross-references (e.g. figures, tables and code listings) with the new [Cross-Reference Div Syntax](/docs/authoring/cross-references-divs.qmd). For example, @tbl-table is an image treated like a table:
    
    ::: {layout-ncol="2"}

    ````markdown
    ::: {#tbl-table}

    ![](table.png)

    An image treated like a table

    :::
    ````
    
    ::: {#tbl-table}

    ![](images/crossref-div-table.png)

    An image treated like a table

    :::

    :::
    
    And notice if you hover over the reference as it appears in the text, e.g. hover over this link to @tbl-table, you'll get a floating preview of the content---that's new too.

*   Define [custom types of float cross-reference](/docs/authoring/cross-references-custom.qmd), which you could use to create cross-references to Videos, Diagrams or [Supplemental Figures](/docs/authoring/cross-references-custom.qmd#example-supplemental-figures).
    
*   Cross-reference [executable code cells](/docs/authoring/cross-references.qmd#code-listings), [callouts](/docs/authoring/cross-references.qmd#callouts) and [remarks and solutions](/docs/authoring/cross-references.qmd#theorems-and-proofs).

## Manuscripts

Quarto manuscript projects provide a framework for writing and publishing scholarly articles. You can use notebooks (`.qmd` or `.ipynb`) as the source of content and computations, and then publish these computations alongside the manuscript, allowing readers to dive into your code.

The output of a manuscript project is a website containing the article in multiple formats (e.g. LaTeX, MS Word) along with rendered versions of the notebooks in the project:

::: {layout="[[3,1]]"}

![Article Content](images/article-content.png){fig-alt="A screenshot of the content area on the manuscript webpage. Content shows a title block including the article title, authors, and abstract, body text, and an image with a caption." .border}

![Navigation](images/webpage-menu.png){fig-alt="A screenshot of the menu on the right hand side of the manuscript webpage. The menu has headings: Table of contents, Other Formats, Notebooks and Other Links." .border}

:::

Read more about manuscripts and how to get started in our guide to [Manuscripts](/docs/manuscripts/index.qmd).

## Other Highlights

Some other highlights include:

-   [Shiny for Python](/docs/dashboards/interactivity/shiny-python/index.qmd)---Support for using Shiny for Python within Quarto documents. 

-   [Script Rendering](/docs/computations/render-scripts.qmd)---Render specially formatted `.py`, `.jl` and `.r` script files.
    
-   [Easy Binder Configuration for Quarto Projects](/docs/projects/binder.qmd)---Support for generating files required to deploy a Quarto project to [Binder](https://mybinder.org/){.external}.

-   [Connect Email Generation](https://docs.posit.co/connect/user/quarto/#email-customization){.external}---Extends the `html` output format so that HTML/text emails can be created and selectively delivered through Posit Connect.

-   [Publish to Posit Cloud](/docs/publishing/posit-cloud.qmd)---Adds `posit-cloud` as a venue for `quarto publish`.

-   [Lightbox Treatment for Images and Figures](/docs/output-formats/html-lightbox-figures.qmd)---Support for zooming into images and figures as well as grouping multiple images into a gallery.

If you build Quarto extensions, you should also be aware of some developer-facing changes:

-   [Lua changes](/docs/prerelease/1.4/lua_changes.qmd)---New Support for crossreferenceable elements in filters, extensible renderers of quarto AST nodes such as `FloatRefTarget` and `Callout`, the use of relative paths in `require()` calls, and more precise specification of where a filter will be inserted.

-   [AST processing changes](/docs/prerelease/1.4/ast.qmd)---Improvements to the HTML table processing added in v1.3 and a way for LaTeX raw blocks to include Quarto-compatible markdown for processing.

You can find all the other changes in 1.4 in the [Release Notes](/docs/download/#download-section-news).

## Acknowledgements

We'd like to say a huge thank you to everyone who contributed to this release by opening issues and pull requests:

{{< include _contribs.md >}}

The party popper emoji in the [listing and social card image](images/thumbnail.png) for this post comes from [OpenMoji](https://openmoji.org/){.external}– the open-source emoji and icon project. License: [CC BY-SA 4.0](https://creativecommons.org/licenses/by-sa/4.0/#){.external}
```````

## File: docs/blog/posts/2024-03-26-hugging-face/index.qmd
```````
---
title: Quarto on Hugging Face
description: |
  You can now host Quarto sites on Hugging Face using the new Quarto Space template.
author: Gordon Shotwell
date: "03/26/2024"
image: "images/hugging-face-thumb.png"
image-alt: "Hugging Face Logo"
---

We're happy to announce that you can now host Quarto Websites on [Hugging Face](https://huggingface.co/) using the new [Quarto Template](https://quarto.org/docs/publishing/hugging-face.html). This template allows you to deploy Quarto sites to Hugging Face with a click of a button, making it easy to integrate them with other Hugging Face models and datasets.

![Hugging Face Space selection screen](images/hf-space-screen.png){fig-alt="Screenshot of Hugging Face Space selection screen showing Docker selected as the SDK, and Quarto selected as the Docker template."}

## About Hugging Face

Hugging Face is the most used open platform for AI, where the machine learning community has shared more than 500,000 models, 115,000 datasets, and 160,000 ML apps, including Stable Diffusion, Llama, GPT-J, and open-source ChatGPT alternatives.

These apps enable the community to explore models, replicate results, and lower the barrier of entry for ML. At Posit, we’ve been extremely impressed with the Hugging Face community and their commitment to supporting open-source machine learning models.

## What does Quarto add?

We think that Quarto is one of the best frameworks for scientific writing, making it a perfect tool for the Hugging Face community. With Quarto, you can interleave code and text to produce accurate, reproducible, and beautiful documents. You use simple markdown or Jupyter notebook files to generate [presentations](https://quarto.org/docs/presentations/), [manuscripts](https://quarto.org/docs/manuscripts/), [dashboards](https://quarto.org/docs/dashboards/), and [more](https://quarto.org/docs/output-formats/all-formats.html).

## Conclusion

Our mission at Posit is to support open-source scientific software, and so we’re very proud to support Hugging Face's effort to build advanced AI models under open-source licenses. We can't wait to see what people build with this integration.
```````

## File: docs/blog/posts/2024-04-01-manuscripts-rmedicine/index.qmd
```````
---
title: Quarto for Reproducible Medical Manuscripts 
description: |
  R/Medicine webinar on Quarto manuscripts
author: Mine Çetinkaya-Rundel
date: "04/01/2024"
image: "images/manuscripts-thumbnail.png"
image-alt: "From multiple Quarto documents and scripts in R and python to PDF or Word output."
categories:
  - Learn
---

Recently I gave a webinar for R/Medicine titled "Quarto for Reproducible Medical Manuscripts". You can watch the video below or on the R Consortium website at <https://www.r-consortium.org/r-medicine-quarto-for-reproducible-medical-manuscripts>.[^1]

{{< video https://www.youtube.com/embed/NK1onTLcgY4 >}}

Some highlights from the webinar include:

-   Step-by-step instructions for getting started with a new manuscript project

-   Obtaining multiple formats from one source

-   An overview of the rich front matter

-   Embedding computations from supplementary notebooks

    -   Note that I demoed embedding computations in R from .qmd files however it's also possible to embed computations from Jupyter notebooks and computations done in Python.

-   A live-coding demo of authoring Quarto manuscripts with RStudio and all the bells-and-whistles of the visual editor, including:

    -   cross referencing
    -   citations
    -   inline code

-   Ability to actually interact with code from a manuscript with Binder

-   And a rich Q&A, thanks to the audience!

The slides (also written in Quarto!) and their source code can be found at the links below:

-   Slides: <https://mine.quarto.pub/quarto-manuscripts-rmed>

-   Source code for slides: <https://github.com/mine-cetinkaya-rundel/quarto-manuscripts-rmed>

In addition, the webinar featured a reproduction of a medical manuscript with Quarto.[^2] Materials from this reproduction can be found at the links below:

-   Manuscript homepage: <https://mine-cetinkaya-rundel.github.io/indo-rct>

    -   This is an HTML page but you can also access PDF and MS Word versions of the manuscript by clicking on their respective links.
    -   You can also find a link to the Binder instance for this manuscript.[^3]

-   Source code for manuscript: <https://github.com/mine-cetinkaya-rundel/indo-rct>

Ready to get started writing a manuscript with Quarto? Go to <https://quarto.org/docs/manuscripts> for more info and a step-by-step tutorial. Happy authoring!

[^1]: Huge thanks to the R Consortium for hosting the webinar and making the recording available so quickly!

[^2]: Huge thanks to [Peter Higgins](https://github.com/higgi13425) who pointed me to this article as well as the R package that contains code from the article ([**medicaldata**](https://higgi13425.github.io/medicaldata/)) and shared some starter code with me.

[^3]: The Binder instance takes a few minutes to launch, you can leave that running in a tab while you browse the rest of the manuscript in another tab.
```````

## File: docs/blog/posts/2024-05-28-conf-workshops/index.qmd
```````
---
title: Quarto workshops at posit::conf(2024)
description: |
  On August 12, we're hosting a day of workshops featuring three dedicated to Quarto at posit::conf(2024) in Seattle
author: Isabella Velásquez and Mine Çetinkaya-Rundel
date: "05/28/2024"
image: "images/conf-workshops-thumbnail.png"
image-alt: "posit::conf(2024) iconography including Seattle skyline on the left and the words 'Quarto workshops' on the right."
categories:
  - Learn
  - Workshop
---

Join us for posit::conf(2024) in Seattle! On August 12, we're hosting a day of workshops featuring three dedicated to Quarto. Check out the options below and find the workshop that's just right for you. Already found your ideal Quarto workshop? [Register today](https://posit.co/conference/)!

[**Introduction to Quarto**]

-   Led by [Andrew Bray](https://bids.berkeley.edu/people/andrew-bray), Berkeley University

-   Ideal for beginners looking to create rich documents

[**Build-a-Dashboard Workshop (with Quarto, R, and/or Python)**]

-   Led by [Mine Çetinkaya-Rundel](https://mine-cr.com/), Posit, PBC, Duke University

-   Perfect for those familiar with computational notebooks in R and/or Python who want to create eye-catching dashboards

[**Quarto Websites**]

-   Led by [Charlotte Wickham](https://www.cwick.co.nz/) and [Emil Hvitfeldt](https://emilhvitfeldt.com/), Posit, PBC

-   Great choice for those wanting to build a website from scratch with Quarto

## **Introduction to Quarto**

This workshop will prepare you to author a rich array of documents in Quarto, the next generation of R Markdown. Quarto is an open-source scientific and technical publishing system that offers multilingual programming language support to create dynamic and static documents, books, presentations, blogs, and other online resources.

This workshop focuses on single documents. You will learn to create static documents, add interactivity to them with Shiny and HTML widgets, or steer them toward sophisticated scientific documents.

In the afternoon, you'll use the same authoring approaches to create slide presentations in various formats, such as reveal.js, Beamer, and PPTX.

**This workshop is for you if you:**

-   Have a basic knowledge of how to use the RStudio IDE,

-   Have some familiarity with Markdown, or

-   Are excited to author flexible single documents like technical reports and slide presentations.

## **Build-a-Dashboard Workshop (with Quarto, R, and/or Python)**

You already analyze and summarize your data in computational notebooks with R and/or Python. What's next? 

You can share your insights or allow others to make their own conclusions in eye-catching dashboards and straight-forward to author, design, and deploy Quarto Dashboards, regardless of the language of your data processing, visualization, analysis, etc. With Quarto Dashboards, you can create elegant and production-ready dashboards using a variety of components, including static graphics (ggplot2, Matplotlib, Seaborn, etc.), interactive widgets (Plotly, Leaflet, Jupyter Widgets, htmlwidgets, etc.), tabular data, value boxes, text annotations, and more. Additionally, with intelligent resizing of components, your Quarto Dashboards look great on devices of all sizes.

And importantly, you can author Quarto Dashboards without leaving the comfort of your “home” – in plain text markdown with any text editor (VS Code, RStudio, Neovim, etc.) or any notebook editor (JupyterLab, etc.). This workshop will walk you through building an increasingly complex dashboard using various layout options and deploying them as static web pages (with no special server required), as well as with a Shiny Server on the backend for enhanced interactivity.

**This workshop is for you if you:**

-   Do data analysis in computational notebooks,

-   Share your results with your audience in static or interactive dashboards and

-   Want to improve the design, user interface, and experience of your dashboards.

## **Quarto Websites**

Do you need a professional website to showcase your work? Or have you got an idea for a website at work, but it needs to reflect your organization's brand? If you've used Quarto to produce a document, you've already got the technical skills to create a Quarto website. In this workshop, you'll learn everything else you need to build a website and customize its appearance.

You'll get a running start by using a template we've designed to be functional and attractive but also act as a guide for your learning. Then you'll:

-   Add pages and navigation, and learn best practices for structuring your content.

-   Master the basics of SCSS and CSS and how they apply to Quarto websites to customize your site's visual appearance.

-   Use listings, a special kind of page, to showcase related content like blog posts, projects, or talks.

By the end of the workshop, you'll have built and published (if you want) a personal website, but the same tools and techniques will apply to any kind of website you might like to build.

We'll assume you've used Quarto to produce documents, but we won't assume you have any HTML, CSS/SCSS, or Git/GitHub experience, nor will we assume any particular programming language (R, Python, etc.) or level of programming experience.

**This workshop is for you if you:**

-   Have used Quarto to generate documents (e.g., HTML, PDF, MS Word, etc.)

-   Are comfortable editing plain text documents (e.g., \`.qmd\`) in your IDE (e.g., RStudio, Visual Studio Code, etc.) and

-   Want to walk away with your own personal website.

## **Learn more about posit::conf(2024)**

Want to explore the complete catalog of posit::conf(2024) workshops and talks?

-   Workshops on August 12: Head over to our [workshop listing](https://reg.conf.posit.co/flow/posit/positconf24/publiccatalog/page/publiccatalog?search=&search.sessiontype=1675316728702001wr6r) to discover detailed information about the courses and instructors.

-   Talks on August 13 and August 14: Peruse the [conference agenda](https://reg.conf.posit.co/flow/posit/positconf24/publiccatalog/page/publiccatalog?search=&tab.day=20240813).

    -   Tip: For a quick view of all Quarto talks, filter for "Quarto" under topics.

Ready to secure your spot? Visit the [conference website](https://posit.co/conference/) for comprehensive details on pricing and the agenda, and [register today](https://reg.conf.posit.co/flow/posit/positconf24/reg/login)!
```````

## File: docs/blog/posts/2024-07-02-beautiful-tables-in-typst/examples/great-tables-oceania.qmd
```````
---
title: "Great Tables - Oceania"
format: 
  typst: default
  html:
    format-links: false
bibliography: []
references:
  - type: website
    id: great-tables
    url: https://posit-dev.github.io/great-tables/examples/
---

```{=typst}
#set page(numbering: none)
```

```{python}
#| classes: plain
from great_tables import GT
from great_tables.data import countrypops
import polars as pl
import polars.selectors as cs

# Get vectors of 2-letter country codes for each region of Oceania
oceania = {
    "Australasia": ["AU", "NZ"],
    "Melanesia": ["NC", "PG", "SB", "VU"],
    "Micronesia": ["FM", "GU", "KI", "MH", "MP", "NR", "PW"],
    "Polynesia": ["PF", "WS", "TO", "TV"],
}

# Create a dictionary mapping country to region (e.g. AU -> Australasia)
country_to_region = {
    country: region for region, countries in oceania.items() for country in countries
}

wide_pops = (
    pl.from_pandas(countrypops)
    .filter(
        pl.col("country_code_2").is_in(list(country_to_region))
        & pl.col("year").is_in([2000, 2010, 2020])
    )
    .with_columns(pl.col("country_code_2").replace(country_to_region).alias("region"))
    .pivot(index=["country_name", "region"], columns="year", values="population")
    .sort("2020", descending=True)
)

(
    GT(wide_pops, rowname_col="country_name", groupname_col="region")
    .tab_header(title="Populations of Oceania's Countries in 2000, 2010, and 2020")
    .tab_spanner(label="Total Population", columns=cs.all())
    .fmt_integer()
)
```
```````

## File: docs/blog/posts/2024-07-02-beautiful-tables-in-typst/examples/great-tables-solar-zenith.qmd
```````
---
title: "Great Tables - Solar Zenith"
format: 
  typst: default
  html:
    format-links: false
bibliography: []
references:
  - type: website
    id: great-tables
    url: https://posit-dev.github.io/great-tables/examples/
---

```{=typst}
#set page(numbering: none)
```

```{python}
#| classes: plain
from great_tables import GT, html
from great_tables.data import sza
import polars as pl
import polars.selectors as cs

sza_pivot = (
    pl.from_pandas(sza)
    .filter((pl.col("latitude") == "20") & (pl.col("tst") <= "1200"))
    .select(pl.col("*").exclude("latitude"))
    .drop_nulls()
    .pivot(values="sza", index="month", columns="tst", sort_columns=True)
)

(
    GT(sza_pivot, rowname_col="month")
    .data_color(
        domain=[90, 0],
        palette=["rebeccapurple", "white", "orange"],
        na_color="white",
    )
    .tab_header(
        title="Solar Zenith Angles from 05:30 to 12:00",
        subtitle=html("Average monthly values at latitude of 20&deg;N."),
    )
    .sub_missing(missing_text="")
)
```
```````

## File: docs/blog/posts/2024-07-02-beautiful-tables-in-typst/examples/gt-cars.qmd
```````
---
title: "gt - gtcars"
format: 
  typst: default
  html:
    format-links: false
bibliography: []
references:
  - type: website
    id: gt-cookbook
    url: https://themockup.blog/static/resources/gt-cookbook.html#multiple-colors
---

```{=typst}
#set page(numbering: none)
```

```{r}
#| classes: plain
library(dplyr)
library(gt)

gtcars %>%
  dplyr::filter(mfr == "Ferrari", hp < 900) %>%
  dplyr::select(model, hp, mpg_c, mpg_h, msrp) %>%
  gt() %>%
  data_color(
    columns = hp,
    palette = c("white", "orange", "red"),
    domain = c(500, 750)
  ) %>%
  data_color(
    columns = c(mpg_c, mpg_h),
    palette = c("white", "green"),
    domain = c(10, 25)
  ) %>%
  data_color(
    columns = msrp,
    palette = c("white", "pink", "red"),
    domain = NULL
  )
```
```````

## File: docs/blog/posts/2024-07-02-beautiful-tables-in-typst/examples/gt-islands.qmd
```````
---
title: "gt - Islands"
format: 
  typst: default
  html:
    format-links: false
bibliography: []
---

```{=typst}
#set page(numbering: none)
```


```{r}
#| classes: plain
library(gt)
library(dplyr)

islands_tbl <-
  tibble(
    name = names(islands),
    size = islands
  ) |>
  arrange(desc(size)) |>
  slice(1:10)

gt_tbl <- gt(islands_tbl)

gt_tbl <-
  gt_tbl |>
  tab_header(
    title = "Large Landmasses of the World",
    subtitle = "The top ten largest are presented"
  )

gt_tbl <-
  gt_tbl |>
  tab_source_note(
    source_note = "Source: The World Almanac and Book of Facts, 1975, page 406."
  ) |>
  tab_source_note(
    source_note = md("Reference: McNeil, D. R. (1977) *Interactive Data Analysis*. Wiley.")
  )

# Show the gt table
gt_tbl

```
```````

## File: docs/blog/posts/2024-07-02-beautiful-tables-in-typst/examples/pandas-acting-on-data.qmd
```````
---
title: "Pandas - Acting on Data"
format: 
  typst: default
  html:
    format-links: false
    theme: default
bibliography: []
references:
  - type: website
    id: pandas-user-guide
    url: https://pandas.pydata.org/pandas-docs/version/2.2.2/user_guide/style.html#Acting-on-the-Index-and-Column-Headers
---

```{=typst}
#set page(numbering: none)
```

```{python}
#| classes: plain
import pandas as pd
import numpy as np

np.random.seed(0)
df2 = pd.DataFrame(np.random.randn(10,4), columns=['A','B','C','D'])

def style_negative(v, props=''):
    return props if v < 0 else None
s2 = df2.style.map(style_negative, props='color:red;')\
              .map(lambda v: 'opacity: 20%;' if (v < 0.3) and (v > -0.3) else None)

def highlight_max(s, props=''):
    return np.where(s == np.nanmax(s.values), props, '')

# darkblue, pink
s2.apply(highlight_max, props='color:white;background-color:#00008b', axis=0)\
.apply(highlight_max, props='color:white;background-color: #ffc0cb;', axis=1)\
.apply(highlight_max, props='color:white;background-color:purple', axis=None)

```
```````

## File: docs/blog/posts/2024-07-02-beautiful-tables-in-typst/examples/pandas-confusion-matrix.qmd
```````
---
title: "Pandas - Confusion Matrix"
format: 
  typst: default
  html:
    format-links: false
bibliography: []
references:
  - type: website
    id: pandas-user-guide
    url: https://pandas.pydata.org/pandas-docs/version/2.2.2/user_guide/style.html#Tooltips-and-Captions
---

```{=typst}
#set page(numbering: none)
```

```{python}
#| classes: plain
import pandas as pd
import numpy as np

df = pd.DataFrame([[38.0, 2.0, 18.0, 22.0, 21, np.nan],[19, 439, 6, 452, 226,232]],
                  index=pd.Index(['Tumour (Positive)', 'Non-Tumour (Negative)'], name='Actual Label:'),
                  columns=pd.MultiIndex.from_product([['Decision Tree', 'Regression', 'Random'],['Tumour', 'Non-Tumour']], names=['Model:', 'Predicted:']))

s = df.style.format('{:.0f}').hide([('Random', 'Tumour'), ('Random', 'Non-Tumour')], axis="columns")

cell_hover = {  # for row hover use <tr> instead of <td>
    'selector': 'td:hover',
    'props': [('background-color', '#ffffb3')]
}
index_names = {
    'selector': '.index_name',
    # darkgr[ae]y
    'props': 'font-style: italic; color: #a9a9a9; font-weight:normal;'
}
headers = {
    'selector': 'th:not(.index_name)',
    'props': 'background-color: #000066; color: white;'
}
s.set_table_styles([cell_hover, index_names, headers])

s.set_table_styles([  # create internal CSS classes
    {'selector': '.true', 'props': 'background-color: #e6ffe6;'},
    {'selector': '.false', 'props': 'background-color: #ffe6e6;'},
], overwrite=False)
cell_color = pd.DataFrame([['true ', 'false ', 'true ', 'false '],
                           ['false ', 'true ', 'false ', 'true ']],
                          index=df.index,
                          columns=df.columns[:4])
s.set_td_classes(cell_color)
s.set_table_styles([  # create internal CSS classes
    {'selector': '.border-red', 'props': 'border: 2px dashed red;'},
    {'selector': '.border-green', 'props': 'border: 2px dashed green;'},
], overwrite=False)
cell_border = pd.DataFrame([['border-green ', ' ', ' ', 'border-red '],
                           [' ', ' ', ' ', ' ']],
                          index=df.index,
                          columns=df.columns[:4])
s.set_td_classes(cell_color + cell_border)
```
```````

## File: docs/blog/posts/2024-07-02-beautiful-tables-in-typst/index.qmd
```````
---
title: Beautiful Tables in Typst
description: |
  You can use HTML Tables with CSS styling in Typst via Quarto.
author: Gordon Woodhull
date: "07/02/2024"
image: beautiful-tables-typst.png
image-alt: "typst snapshot tk"
bibliography: []
format:
  html:
    css: layout.css
    number-sections: true
categories:
  - Quarto 1.5
  - Tables
---

Quarto now allows HTML Tables with CSS styling to be output in Typst.

It does this by translating CSS properties into Typst properties. You can read about the feature [in the Guide](/docs/output-formats/typst.qmd#typst-css).[technical details [in the Advanced Docs](/docs/advanced/typst/typst-css.qmd)]{.aside}

Let's look at 6 HTML tables using a variety of CSS properties also supported by Typst in Quarto.

You can click on the links below the examples to see the full documents, with source code.

## Confusion Matrix (Pandas / Python)

This example uses a dashed border to draw attention to two cells.

:::::: {.column-page .room}
::::: columns
::: {.column width="50%" style="padding-top:1.5em"}
![](images/pandas-confusion-matrix.png){width="700"} [Typst](examples/pandas-confusion-matrix.pdf){target="_blank"}
:::

::: {.column width="50%"}
```{=html}
<iframe class="html-demo" src="demo/pandas-confusion-matrix.html" width=700 height=250 scrolling="no"></iframe>
```

[HTML](examples/pandas-confusion-matrix.HTML){target="_blank"}
:::
:::::
::::::

## Cars heatmap (gt / R)

This example uses cell background colors to encode ranges of values.

:::::: {.column-page .room}
::::: columns
::: {.column width="50%" style="padding-top:2.2em"}
![](images/gt-cars.png){width="430"}

[Typst](examples/gt-cars.pdf){target="_blank"}
:::

::: {.column width="50%"}
```{=html}
<iframe class="html-demo" src="demo/gt-cars.html" width=430 height=375 scrolling="no"></iframe>
```

[HTML](examples/gt-cars.HTML){target="_blank"}
:::
:::::
::::::

## Oceania (Great Tables / Python)

Borders can show the structure of grouped rows.

:::::: {.column-page .room}
::::: columns
::: {.column width="50%" style="padding-top:2.1em"}
![](images/great-tables-oceania.png){width="600"}

[Typst](examples/great-tables-oceania.pdf){target="_blank"}
:::

::: {.column width="50%"}
```{=html}
<iframe class="html-demo" src="demo/great-tables-oceania.html" width=600 height=907 scrolling="no"></iframe>
```

[HTML](examples/great-tables-oceania.HTML){target="_blank"}
:::
:::::
::::::

## Islands (gt / R)

Font sizes and minimal borders make this table stand out.

:::::: {.column-page .room}
::::: columns
::: {.column width="50%" style="padding-top:2.2em"}
![](images/gt-islands.png){width="500"}

[Typst](examples/gt-islands.pdf){target="_blank"}
:::

::: {.column width="50%"}
```{=html}
<iframe class="html-demo" src="demo/gt-islands.html" width=400 height=580 scrolling="no"></iframe>
```

[HTML](examples/gt-islands.HTML){target="_blank"}
:::
:::::
::::::

## Solar Zenith (Great Tables / Python)

Another cool heatmap.

:::::: {.column-page .room}
::::: columns
::: {.column width="50%" style="padding-top:1.7em"}
![](images/great-tables-solar-zenith.png){width="750"}

[Typst](examples/great-tables-solar-zenith.pdf){target="_blank"}
:::

::: {.column width="50%"}
```{=html}
<iframe class="html-demo" src="demo/great-tables-solar-zenith.html" width=850 height=565 scrolling="no"></iframe>
```

[HTML](examples/great-tables-solar-zenith.HTML){target="_blank"}
:::
:::::
::::::

## Acting on Data (Pandas / Python)

Applying colors and transparency based on data.

:::::: {.column-page .room}
::::: columns
::: {.column width="50%" style="padding-top:2.2em"}
![](images/pandas-acting-on-data.png){width="540"}

[Typst](examples/pandas-acting-on-data.pdf){target="_blank"}
:::

::: {.column width="50%"}
```{=html}
<iframe class="html-demo" src="demo/pandas-acting-on-data.html" width=600 height=505 scrolling="no"></iframe>
```

[HTML](examples/pandas-acting-on-data.HTML){target="_blank"}
:::
:::::
::::::

We can't wait to see what you do with this new feature!
```````

## File: docs/blog/posts/2024-07-11-1.5-release/index.qmd
```````
---
title: Quarto 1.5 
description: |
  Quarto 1.5 improves Typst support, has some website enhancements like draft handling and announcement bars, adds a native Julia engine, and adds a couple of shortcodes for generating placeholder content. 
categories:
  - Quarto 1.5
  - Releases
author: Charlotte Wickham
date: "07/11/2024"
image: "images/thumbnail.png"
image-alt: "Quarto 1.5 with a balloon"
---

Quarto 1.5 is out! You can find the current release on the [download page](/docs/download/index.qmd).

Below, we'll highlight the improved Typst support, website enhancements like draft handling and announcement bars, the native Julia engine, and a couple of shortcodes for generating placeholder content. You can see all the changes in the [Release Notes](/docs/download/changelog/1.5/).

## Typst CSS

We've already blogged about one feature that is now available in 1.5: [Beautiful Tables in Typst](/docs/blog/posts/2024-07-02-beautiful-tables-in-typst/). The CSS properties from HTML tables produced in your code are translated to Typst properties, so the tables you lovingly craft for HTML should look just as good in PDFs produced using `format: typst`.

Beyond tables, CSS properties on divs and spans are also translated to Typst properties. So, for example, you could get text with a green background like this:

``` markdown
Here is a [span with a green background]{style="background-color:green"}.
```

You can read more about using CSS in Typst at [Typst Basics: Typst CSS](/docs/output-formats/typst.qmd#typst-css).

## Improved Website Draft Support

![A `draft` post with the new draft banner](images/website-drafts-banner.png){.border fig-alt="Screenshot of a post titled 'Post With Code', displaying a banner at the top of the page titled 'Draft'."}

Quarto 1.5 brings improved support for workflows involving draft posts and pages:

-   Adds the `drafts` option to the `website` key offering new ways to specify drafts: directly in `_quarto.yml`, and via metadata includes and profiles.

-   Introduces the `draft-mode` option to the `website` key to control how drafts are rendered. Drafts can be `gone`, `unlinked` or `visible`.

-   Adds a draft banner to draft pages that are rendered.

-   Improves the linking behavior of draft documents. Now, in addition to being excluded from search results, listings, and the sitemap, drafts will not appear in navigation, or be linked from in-text hyperlinks when `draft-mode` is `gone` or `unlinked`.

-   Changes the behavior of `quarto preview` for drafts. Drafts will be `visible` in previews regardless of the `draft-mode` setting. In particular, this allows an easier way to preview the appearance of draft content in navigation and listings.

Read more at [Website Drafts](/docs/websites/website-drafts.qmd).

## Website Announcements

You can now use an `announcement` option to add a customizable banner at the top of your website. You can set an icon, make it dismissable, and include markdown formatted content like bold text:

![An example announcement bar](images/website-announcement.png){fig-alt="Screenshot of the quarto documentation showing a blue bar below the navbar, starting with the text 'Alert:...'."}

Read about your options at [Website Tools: Announcement Bar](/docs/websites/website-tools.qmd#announcement-bar).

## Native Julia Engine

Prior to 1.5, Julia code cells were executed through the Jupyter engine. Now you can opt-in to a native Julia engine:

``` yaml
---
title: Julia without Jupyter
engine: julia
---
```

Read about the details in [Using the `julia` engine](https://quarto.org/docs/computations/julia.html#using-the-julia-engine).

Part of the reason we are excited about this feature is that it was an external contribution. Thank you [\@jkrumbiegel](https://github.com/jkrumbiegel)!

## Placeholder Shortcodes

We've also added a couple of shortcodes that add placeholder content: `lipsum` for text, and `placeholder` for images:

``` {.markdown shortcodes="false"}
{{< placeholder 400 200 format=svg >}}
{{< lipsum 1 >}}
```

This example produces a 400px x 200px SVG image, and one paragraph of [Lorem Ipsum](https://en.wikipedia.org/wiki/Lorem_ipsum) text:

::: {.border .p-3}
{{< placeholder 400 200 format=svg >}}

{{< lipsum 1 >}}
:::

Read more about their options at [Placeholder Images](/docs/authoring/placeholder.qmd) and [Placeholder Text](/docs/authoring/lipsum.qmd).

## Acknowledgements

Finally, we'd like to give a huge high five to everyone who contributed to this release by opening issues and pull requests:

{{< include _contribs.md >}}

The balloon emoji in the [listing and social card image](images/thumbnail.png) for this post comes from [OpenMoji](https://openmoji.org/){.external}– the open-source emoji and icon project. License: [CC BY-SA 4.0](https://creativecommons.org/licenses/by-sa/4.0/#){.external}
```````

## File: docs/blog/posts/2024-10-15-conf-workshops-materials/index.qmd
```````
---
title: posit::conf(2024) Quarto workshop materials
description: |
  Back in August, we hosted three Quarto workshops at posit::conf(2024); the materials from those workshops are available to learn and teach from!
categories:
  - Learn
  - Workshop
author: Mine Çetinkaya-Rundel and Charlotte Wickham
date: "10/15/2024"
image: "images/thumbnail.png"
image-alt: "posit::conf(2024) logo "
---

This year at posit::conf(2024) we had three day-long Quarto workshops. The materials from those workshops are available for all to learn from. Additionally, you're welcomed to use them in full or part when talking or teaching about Quarto; they are all released with a [CC BY-SA 4.0](https://creativecommons.org/licenses/by-sa/4.0/) license.

::: {layout="[70,30]"}

::: {}
[**Introduction to Quarto**](https://posit-conf-2024.github.io/quarto-intro/){data-heading="Introduction to Quarto"}

<https://posit-conf-2024.github.io/quarto-intro>

\

-   Led by [Andrew Bray](https://bids.berkeley.edu/people/andrew-bray), UC Berkeley

-   Ideal for beginners looking to create rich documents
:::

:::{}

[![](images/intro.png){fig-alt="Illustration of a seaplane."}](https://posit-conf-2024.github.io/quarto-intro/)
:::

:::

:::: {layout="[70,30]"}

::: {}
[**Build-a-Dashboard Workshop (with Quarto, R, and/or Python)**](https://posit-conf-2024.github.io/quarto-dashboards/)

[https://posit-conf-2024.github.io/quarto-dashboards](https://posit-conf-2024.github.io/quarto-dashboards/)

\

-   Led by [Mine Çetinkaya-Rundel](https://mine-cr.com/), Posit, PBC, Duke University

-   Perfect for those familiar with computational notebooks in R and/or Python who want to create eye-catching dashboards
:::

::: {}
[![](images/dashboards.png){fig-alt="An illustration of a dashboard made with Quarto"}](https://posit-conf-2024.github.io/quarto-dashboards/)
:::

::::

:::: {layout="[70,30]"}

::: {}
[**Quarto Websites**](https://posit-conf-2024.github.io/quarto-websites/){data-heading="Quarto Websites"}

[https://posit-conf-2024.github.io/quarto-websites](https://posit-conf-2024.github.io/quarto-websites/)

\

-   Led by [Charlotte Wickham](https://www.cwick.co.nz/) and [Emil Hvitfeldt](https://emilhvitfeldt.com/), Posit, PBC

-   Great choice for those wanting to build a website from scratch with Quarto

:::

:::{}
[![](images/websites.png){fig-alt="A diagram showing switching between navbar and sidebar navigation for a Quarto website."}](https://posit-conf-2024.github.io/quarto-websites/)
:::

::::
```````

## File: docs/blog/posts/2024-11-06-conf-talks/index.qmd
```````
---
title: posit::conf(2024) Quarto talks
description: |
  Videos of talks from posit::conf(2024) are posted, we've compiled a playlist of Quarto talks for you!
categories:
  - Learn
  - Conference
author: Mine Çetinkaya-Rundel and Charlotte Wickham
date: "11/06/2024"
image: "images/thumbnail.jpg"
image-alt: "Collage of speakers with Quarto talks at posit::conf(2024)"
---

Videos of posit::conf(2024) talks are now posted [on YouTube](https://www.youtube.com/watch?v=s_Vh9HIeLVg&list=PL9HYL-VRX0oSFkdF4fJeY63eGDvgofcbn). We have also made playlist of talks that are about using, building with, and building on Quarto.

<iframe width="560" height="315" src="https://www.youtube.com/embed/videoseries?si=Xwt6NHL_f4k9agzh&amp;list=PLNUVZZ6hfXX1Y4Is-SbbMF_HutRDJBwiO" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>

Talks included in this playlist are as follows:

-   [Updates from Posit, with Hadley Wickham, Charlotte Wickham, George Stagg, and James Blair](https://youtu.be/s_Vh9HIeLVg?si=jsIWeETKQG154dFi)
-   [Andrew Bray - Closeread: bringing Scrollytelling to Quarto](https://youtu.be/KqLxy66B3lQ?si=fe1zVCBozVmWKufO)
-   [Meghan Hall - Designing and Deploying Internal Quarto Templates](https://youtu.be/VJEBg1Ke0lE?si=LUMa5-IF3gWORr3I)
-   [David Keyes - Report Design in R: Small Tweaks that Make a Big Difference](https://youtu.be/bp1SMhLoz_M?si=tyvyO-FP0AEBV6W2)
-   [Mine Çetinkaya-Rundel - Reproducible, dynamic, and elegant books with Quarto](https://youtu.be/fsfoqpQYN2k?si=sDUOZTEBXvXLNVHq)
-   [Cynthia Huang - Quarto for Knowledge Management](https://youtu.be/4zy9R26B8kk?si=rO_5BIjTC3ENVC2c)
-   [Regina Lionheart - Making Waves with R, Python, and Quarto](https://youtu.be/UOMcGBMvVdo?si=yo3dFtWScKn06iXy)
-   [Joshua Cook - Quarto: A Multifaceted Publishing Powerhouse for Medical Researchers](https://youtu.be/PITfti4JRiU?si=TMi-CJOi04zViU_p)
-   [Tyler Morgan-Wall - Quarto, AI, and the Art of Getting Your Life Back](https://youtu.be/U8_Dc_ru8fg?si=-fEK5Ou57f-QhSba)
-   [Sean Nguyen - Beyond Dashboards: Dynamic Data Storytelling with Python, R, and Quarto Emails](https://youtu.be/fzykFa6c3LI?si=wV83nh1WvctfRAiu)
-   [Richie Moluno - JSquarto: Bridging JavaScript Documentation with Quarto's Power](https://youtu.be/CySpBKJD5vY?si=zQ2TowaD_Wk0Du8X)
-   [Mika Braginsky - DataPages for interactive data sharing using Quarto](https://youtu.be/1gUl-vWqScc?si=nLEJ8JsLzBv8UqqT)
-   [Brennan Antone - Democratizing Organizational Surveys with Quarto and Shiny](https://youtu.be/ceW3nQssV88?si=caHnzvBHorxWFn00)
```````

## File: docs/blog/posts/2024-11-22-dashboards-workshop/index.qmd
```````
---
title: Quarto dashboards video series
description: |
  Learn how to build a Quarto dashboard with a three-part video series.
categories:
  - Learn
  - Workshop
author: 
  - Charlotte Wickham
  - Mine Çetinkaya-Rundel
date: "11/22/2024"
image: "quarto-dashboards.jpg"
image-alt: "Build a dashboard workshop with Quarto, R and/or Python."
---

If you've been looking to get your head around Quarto dashboards, 
check out the Quarto dashboards video series by [Mine Çetinkaya-Rundel](https://mine-cr.com/).

Materials: [YouTube playlist](https://youtube.com/playlist?list=PLitrm9UndxcsapDsLimKGn3dEjQZy5vYs&si=oLK2D1PuyF9MKVon) | [Slides](https://mine.quarto.pub/quarto-dashboards/) | [Starter code](https://github.com/mine-cetinkaya-rundel/olympicdash)

## 1. Hello, Quarto Dashboards

Start by getting to know Quarto dashboards and make your very first dashboard using either R or Python and share it online. [Slides](https://mine.quarto.pub/quarto-dashboards/1-hello-dashboards/#/title-slide)

{{< video https://www.youtube.com/watch?v=HW7QbqI4fH0 >}}

## 2. Quarto Dashboards Components

Then, build up your arsenal of dashboard components to add navigation, sidebars, tabsets, value boxes, and fine-tune layout. [Slides](https://mine.quarto.pub/quarto-dashboards/2-dashboard-components/#/title-slide)

{{< video https://www.youtube.com/watch?v=KdsQgwaY950 >}}

## 3. Quarto Dashboards Theming and Styling

Finally, make your dashboard pop by adding a theme and making styling tweaks. [Slides](https://mine.quarto.pub/quarto-dashboards/3-theming-styling/#/title-slide)

{{< video https://www.youtube.com/watch?v=NigWSB-jG4Y >}}
```````

## File: docs/blog/posts/2024-11-25-1.6-release/index.qmd
```````
---
title: Quarto 1.6
description: |
  Quarto 1.6 supports unified branding across formats, updates to RevealJS, a new shortcode to reorder content, a landscape page block, and more. There are also a couple of breaking changes that will affect a small number of users.
categories:
  - Quarto 1.6
  - Releases
author: Charlotte Wickham
date: "11/25/2024"
image: "thumbnail.png"
image-alt: "Quarto 1.6 with a palette."
---

Quarto 1.6 has been officially released! You can get the current release from the [download page](/docs/download/index.qmd).

We are particularly excited about:

-   Support for **brand.yml**---a single file that defines your organization's branding and style preferences across formats.

-   RevealJS updates, including the new navigation features: scroll mode and jump to slide.

-   The `contents` shortcode for reordering your content.

-   `landscape` blocks for placing content on a landscape page.

-   Improvements in how you can specify subpanels of cross-references from code blocks.

You can read about these new features and a couple of breaking changes in the sections below. You can find all the changes in this version in the [Release Notes](/docs/download/changelog/1.6/).

## Cross-format theming with **brand.yml**

[**brand.yml**](https://posit-dev.github.io/brand-yml/) is a Posit project outside Quarto that defines brand information using a simple YAML file. Quarto is a flagship adopter of **brand.yml** and supports brand-themed output for `html`, `dashboard`, `typst` and `revealjs` formats.

{{< include /docs/authoring/_brand-example.qmd >}}

Get started by reading the Quarto [Guide to Brand](/docs/authoring/brand.qmd).

## RevealJS update

Quarto v1.6 updates RevealJS to v5.1.0. With the update comes two notable features:

[**Jump to Slide**](/docs/presentations/revealjs/presenting.qmd#jump-to-slide): Quickly navigate to a slide. Press {{< kbd G >}} to activate, type a slide number or ID, and hit Enter/Return.

[**Scroll Mode**](/docs/presentations/revealjs/presenting.qmd#scroll-view): Scroll rather than click to advance slides. Press {{< kbd R >}}, add `?view=scroll` to your URL, or use the Navigation menu to activate. Automatically activated on small screens.

## Contents shortcode

The `contents` shortcode lets you compose content in one location in your document and then display it in another. For example, you might use a code cell to generate a plot:

```` markdown
```{{python}}
#| echo: false
#| label: a-cell
import matplotlib.pyplot as plt
plt.plot([1,2,3])
```
````

Then use the `contents` shortcode to display that plot in a callout by referencing its label, `a-cell`:

``` {.markdown shortcodes="false"}
::: callout-note
## Note the following plot

{{< contents a-cell >}}

:::
```

Find all the details on our guide page on the [contents shortcode](/docs/authoring/contents.qmd).

## Landscape mode

In `pdf`, `docx,` and `typst` formats, you can now put content on a landscape page by placing it inside a [`landscape` block](/docs/authoring/article-layout.html#landscape-mode):

``` markdown
::: {.landscape}

This will appear in landscape.

:::
```

## Cross-reference improvements

It should now be easier to get Quarto to recognize subfloats (subtables, subfigures, etc) when they're emitted by code cells. If the `subcap` attribute of a code cell has as many entries as the number of outputs from your code cell, Quarto knows to accept those as subfloats. See [#10328](https://github.com/quarto-dev/quarto-cli/issues/10328){.external} for details.

Minimal example:

```{{{r}}}
#| label: tbl-example
#| tbl-cap: I want these images to be interpreted as Tables.
#| tbl-subcap:
#|   - This is the subcaption for the first subtable
#|   - This is the subcaption for the second subtable
plot(1:10)
plot(11:20)
```

![The result of executing the above code cell in HTML format](./subcells-and-subfloats.png){.border fig-alt="Screenshot of a document showing two plots with an overall caption labelled 'Table 1', and each plot with a caption starting '(a)' and '(b)' respectively."}

## Breaking Changes

We try very hard to keep Quarto backward compatible. However, in this release, there are a couple of breaking changes due to upstream dependencies. You may be affected if:

-   **You have TypeScript files (`*.ts`) that you use either with pre- or post-render scripts, or with `quarto run`, that import Deno standard libraries.**

    The import syntax has changed. Please see [Deno Scripts](/docs/projects/scripts.html#deno-scripts) for the necessary changes.

-   **You override the LaTeX `graphics.tex` partial, or you have a completely custom LaTeX template that doesn't use the `graphics.tex` partial.**

    A Pandoc change means some images are now wrapped in `\pandocbounded`. Consequently, your `graphics.tex` partial, or your template, needs to define `\pandocbounded`. You can look at our [source code for `graphics.tex`](https://github.com/quarto-dev/quarto-cli/blob/main/src/resources/formats/pdf/pandoc/graphics.tex){.external} to see the necessary changes and read more about the upstream change in [Pandoc commit 26b25a4](https://github.com/jgm/pandoc/commit/26b25a4428815b04c255e33e95ee86ca7b6ee30e){.external}.

## Acknowledgments

We want to say a huge thank you to everyone who contributed to this release by opening issues and pull requests:

{{< include _contribs.md >}}

The palette emoji in the [listing and social card image](images/thumbnail.png) for this post comes from [OpenMoji](https://openmoji.org/){.external}– the open-source emoji and icon project. License: [CC BY-SA 4.0](https://creativecommons.org/licenses/by-sa/4.0/#){.external}
```````

## File: docs/blog/posts/2024-12-04-websites-workshop/index.qmd
```````
---
title: Quarto website video series
description: |
  Build a personal website with Quarto by following this four-part video series on YouTube.
categories:
  - Learn
  - Workshop
author: 
  - Charlotte Wickham
  - Mine Çetinkaya-Rundel
date: "12/04/2024"
image: "quarto-websites.jpg"
image-alt: "Quarto Websites Workshop"
---

Do you need a professional website to showcase your work? If you’ve used Quarto to produce a document, you’ve already got the technical skills to create a Quarto website. In this video series, taught by [Charlotte Wickham](https://www.cwick.co.nz/) and [Emil Hvitfeldt](https://emilhvitfeldt.com/), you’ll learn everything else you need to build a website and customize its appearance.

[YouTube Playlist](https://www.youtube.com/playlist?list=PLitrm9Undxcu7eExaTg9Y-JYLv9O6uxGu) 

## Quarto Websites 1: Build your homepage 

In this video, you’ll get a running start by using a template we've designed to be functional and attractive, and that will serve as a foundation for the rest of the video series. You’ll customize the content of your homepage, and how it looks, and along the way learn about the two key files in a Quarto website index.qmd and _quarto.yml. Finally, you’ll learn one way to publish your website so other people can see it.

{{< video https://youtu.be/l7r24gTEkEY >}}

Links: [About pages](/docs/websites/website-about.qmd) | [YAML appearance options](/docs/output-formats/html-themes.qmd#basic-options) 

Code: [Starter](https://github.com/EmilHvitfeldt/website-template ) | [Final](https://github.com/cwickham/quarto-website-video/tree/v0.1)

## Quarto Websites 2: Add pages and navigation

Now you’ve got a homepage, you’ll likely want to add some other pages. In this video, learn how to add pages to your website, and help people find them, by adding them to your website navigation.

{{< video https://youtu.be/k65E-8PXZmA >}}

Links: [Bootstrap icons](https://icons.getbootstrap.com/) | [Navigation bar options](/docs/websites/website-navigation.qmd#top-navigation) |  [Quarto website navigation](/docs/websites/website-navigation.qmd)

Code: [Starter](Starter source code: https://github.com/cwickham/quarto-website-video/tree/v0.1) |  [Final](https://github.com/cwickham/quarto-website-video/tree/v0.2)


## Quarto Websites 3: Customize appearance with CSS/SCSS

You now have a set of content you are happy with on your website, but how do you customize the look and feel of your site beyond options set in YAML? In this video, you’ll start by learning the basics of CSS and SCSS and how to make good design choices. Then, you’ll see how to apply these choices to your Quarto website.

{{< video https://youtu.be/pAN2Hiq0XGs >}}

Links: [Color contrast checker](https://colourcontrast.cc/) | [Google fonts](https://fonts.google.com/)

Code: [Starter](https://github.com/cwickham/quarto-website-video/tree/v0.2) | [Final](https://github.com/cwickham/quarto-website-video/tree/v0.3)

## Quarto Websites 4: Add lists of content with listings

Adding a listing page to your website is a great way to showcase your projects, talks, publications or blog posts. In this video you’ll learn how to create a listing page in Quarto and see two ways to populate it with content: Quarto documents, or a yaml file.

{{< video https://www.youtube.com/watch?v=bv_Cw-3HI1Y >}}

Links: [Listings](/docs/websites/website-listings.qmd) | [Andrew Heiss’ teaching listing](https://www.andrewheiss.com/teaching/ ) 

Code: [Starter](https://github.com/cwickham/quarto-website-video/tree/v0.3) | [Final](https://github.com/cwickham/quarto-website-video/tree/v0.4)
```````

## File: docs/blog/posts/2024-12-12-includes-meta/index.qmd
```````
---
title: "Use `meta` + `include` to customize reusable content"
description: |
  The "Includes" feature in Quarto lets you efficiently reuse content across multiple files. Combined with the "meta" shortcode, it enables you to set precise, file-specific values.
categories:
  - Learn
  - Authoring
author:
  - Ashley Henry
date: "12/12/2024"
image: "thumbnail.jpg"
image-alt: "Quarto logo with single source publishing icon."
---

::: {.callout-tip}

## Re-posted from posit.co

This post was originally published on the [Posit Blog](https://posit.co/blog/quarto-meta-shortcode-variables/). 

The worked example below is also available at: [Source](https://github.com/quarto-dev/quarto-examples/tree/main/websites/quarto-meta-includes) | [Live Website](https://examples.quarto.pub/quarto-meta-includes/)

::: 

There may be times when you would like to single-source content across multiple pages/files to reduce the risk of errors, produce consistent content that is easy to maintain, and ultimately save valuable time. [Quarto](/index.qmd) (an open-source technical publishing system), provides an [Includes](/docs/authoring/includes.html) feature (the equivalent of an R Markdown “child” document) that allows you to reuse content across multiple documents/files/pages. 

To achieve this, simply create chunks of content (text, tables, code, callouts, images, etc.) and then insert it using the Include shortcode: `{{{< include _content.qmd >}}}`.

Typically, you must keep your content general enough so it can be reused in several places. In other words, if you needed to add a name or an image that is specific to that file, you would assume that you wouldn’t be able to use an include, or you would have to use several smaller includes sewn into uniquely written content.

But what if you need your single-sourced content to be more specific? You can use Includes with `meta` shortcode (variables) to add precise values defined at the file level.

## Walkthrough example

Let us walk you through an example of how to achieve this.

Before you begin:

* Quarto version 1.5+ was used for this walkthrough example.
* This has been tested with both new and existing Website projects.
* A `var` shortcode enables you to insert content from the project or file level.
* The `meta` shortcode allows you to insert content from Pandoc metadata (e.g., YAML at the top of the document and/or in `_quarto.yml`).
* As you preview your site, pages will be rendered and updated. However, if you make changes to global options (e.g. `_quarto.yml` or included files) you need to fully re-render your site to have all of the changes reflected. Consequently, you should always fully `quarto render` your site before deploying it, even if you have already previewed changes to some pages with the preview server.

### Create the content:

Here is an example of a file with content we want to reuse across several pages.

```markdown
In this document, we cover facts that are unique to the state, like the state's population, its flower, and animal.
```

This content is general enough to use as each state’s introduction but lacks the facts that are unique to each state. So, we could insert the Include into each state’s file and then add specific content that is unique to the state:

```markdown
---
title: New York
---

{{{< include _snippets/state-intro.qmd >}}}

New York has a geographical size of 54,555, making it the 27th largest state with an estimated population size of 19.8 million.

The state's flower is the Rose, as shown below:

![](images/ny/flower.png)
```

### Why are we doing this?

Instead of copying and pasting this content into each file, and then updating it with each state’s fact (which introduces a higher risk of making an error), we can use meta variables to insert specific values.

### Let’s execute

First, I create a file within my `_snippets` directory named `facts.qmd`. Throughout the file, I am going to insert a unique `meta` variable for each occurrence that I want the content to be specific to the state: 

```markdown
{{{< meta state >}}} covers approximately {{{< meta square-miles >}}} making it the {{{< meta size-rank >}}} largest state in the United States. As of 2023, {{{< meta state >}}} has an approximate population of about {{{< meta population >}}}.
```

I can define each of the `meta` variables within the individual file that I plan on reusing this content. So, in my `ny.qmd` file, I define each variable in the YAML metadata. Then, insert the `facts.qmd` file with the undefined meta shortcodes using an include:

```markdown
---
title: New York
state-abbr: ny
state: New York
size-rank: 27th
square-miles: 54,555
population: 19.8 million
---


{{{< include _snippets/facts.qmd >}}}
```

As you can see, the rendered file has the meta shortcodes populated with the definitions that you assigned to each value in the file’s YAML.

![](images/img1.png){fig-align="center" style="box-shadow: 5px 5px 15px rgba(0, 0, 0, 0.3); border-radius: 5px;"}


But, I would also like to add the state’s flower and animal with images of each. You can achieve this by editing the document to add this information and images:

```markdown
{{{< include _snippets/facts.qmd >}}}

New York's official flower is the Rose:

![](../images/ny/flower.png)

And the official animal is the Beaver:

![](../images/ny/animal.png)
```

Or, you can get creative and use `meta` shortcodes in your image paths so you can continue to manage all of the content in a single file:

```markdown
{{{< meta state >}}}'s official flower is the {{{< meta flower >}}}, pictured below:

![The official {{{< meta state >}}} state flower, the {{{< meta flower >}}}](../images/{{{< meta state-abbr >}}}/flower.png)

Lastly, {{{< meta state >}}}'s official animal is the {{{< meta animal >}}}, pictured below:

![The official {{{< meta state >}}} state animal, the {{{< meta animal >}}}](../images/{{{< meta state-abbr >}}}/animal.png)
```

As you can see, my image paths have `{{{< meta state-abbr >}}}` which is defined in the new-york file as “ny”.

When we render the project, the image path updates to /images/ny/flower.png pointing to the existing flower image in the `ny` directory:

![](images/img2.png){fig-align="center" style="box-shadow: 5px 5px 15px rgba(0, 0, 0, 0.3); border-radius: 5px;"}


In theory, you could do this for each state as long as each directory follows the same naming conventions, i.e., `pa/flower.png` and `vt/flower.png`.

This does require an organized and scalable approach since the images will have to follow the same directory and file-naming conventions, but in doing so, you can create individualized pages and images using a single include.

### The rendered example

Here is New York’s page:

![](images/img3.png){fig-align="center" style="box-shadow: 5px 5px 15px rgba(0, 0, 0, 0.3); border-radius: 5px;"}


Here is Pennsylvania’s page:

![](images/img4.png){fig-align="center" style="box-shadow: 5px 5px 15px rgba(0, 0, 0, 0.3); border-radius: 5px;"}

Each page was built using a single (shared) file:

```markdown
{{{< include _snippets/facts.qmd >}}}
```

## Learn more about Quarto Includes

Quarto's Includes feature allows you to improve your content creation process by reducing redundancy and maintaining consistency across multiple documents. Whether you're managing technical documentation, educational materials, or any other content, this approach can help you save time, reduce errors, and deliver polished results.

Learn more with these resources:

* [Get Started - Quarto](/docs/get-started/)
* [Quarto - Includes](/docs/authoring/includes.html)
* [Quarto - meta Variables](/docs/authoring/variables.html#meta)
* An overview of [Single Source Authoring](https://technicalwriterhq.com/writing/technical-writing/single-source-authoring/){.external}
```````

## File: docs/blog/posts/2025-01-15-quarto-tip-brand-positron/index.qmd
```````
---
title: "Tip - use Positron to choose colors for your project brand"
description: |
  Use Positron's integrated color picker for an easy way to choose colors for
  your next project's `_brand.yml`.
categories:
  - Learn
  - Tip
  - brand
author: 
  - Carlos Scheidegger
date: "2025-01-15"
image: brand.png
---

In today's Quarto Tip, we show you how [Positron](https://positron.posit.co)
enables a very easy workflow for creating and changing colors in your `_brand.yml`
file. Quarto 1.6 includes [support for `_brand.yml`](https://posit-dev.github.io/brand-yml/), a
standard for creating a single style configuration file that is usable across formats and
systems.

{{< video https://youtu.be/Mly_DK-2BnI >}}

Additional links:

- [Quarto 1.6 release post](/docs/blog/posts/2024-11-25-1.6-release/index.qmd)
- [Download Positron](https://positron.posit.co/download.html)
- [Quarto's `_brand.yml` documentation](/docs/authoring/brand.qmd)
```````

## File: docs/blog/posts/2025-04-28-1.7-release/index.qmd
```````
---
title: Quarto 1.7 
description: |
  Quarto 1.7 brings big improvements to dark mode along with updates to Typst, Pandoc, a new `version` shortcode, and improvements to the `julia` engine.
categories:
  - Quarto 1.7
  - Releases
author: Charlotte Wickham
date: "2025-04-28"
draft: false
image: thumbnail-1.7.jpeg
image-alt: "Quarto 1.7: half the Quarto logo is light on dark, the other half dark on light"
---

Quarto 1.7 is out! You can get the current release from the [download page](/docs/download/index.qmd).

We are especially enthusiastic about the improvements 1.7 brings to dark mode: you can now specify light and dark themes via brand, map computational outputs to themes, and have your website theme follow your viewer's preference.
To celebrate these changes, this site, [quarto.org](/), now has a light and dark mode.
Toggle the switch in the navigation bar (`<i class="bi bi-toggle-off"></i>`{=html}) to see the difference.

You can read about these improvements and some other highlights below. You can find all the changes in this version in the [Release Notes](/docs/download/changelog/1.7/).

## Dark Mode Improvements

### Specify light and dark themes via **brand.yml**

You can now specify a light and dark brand.
For example, at a project-level you can provide two brand files:

```{.yaml filename="_quarto.yml"}
brand:
  light: light-brand.yml
  dark: dark-brand.yml
```

Standalone HTML pages, websites, and dashboards will gain a light switch toggle allowing viewers to switch between the light and dark themes. 

::: {layout-ncol=2}

![`light` brand](light.png){fig-alt="Screenshot of a webpage with a light blue body and charcoal text. A switch toggle in the navbar is 'off'."}

![`dark` brand](dark.png){fig-alt="Screenshot of a webpage with a dark charcoal body and light blue text. A switch toggle in the navbar is 'on'."}

:::


By default Typst documents will use the light brand, but you can set the `brand-mode` option to use the dark brand instead:

```{.yaml filename="document.qmd"}
---
format:
  typst:
    brand-mode: dark
---
```

Read about other ways to set a light and dark brand in [Guide > Brand](/docs/authoring/brand.qmd#dark-brand).


###  Map computational outputs to themes

A new code cell option, `renderings`, allows you to indicate which computational outputs should be displayed in light and dark mode. 
Create light and dark versions of your outputs in a single code cell, 
and add the option `renderings` to specify the order of the outputs.
For example, this cell creates a `light` version of a plot, 
then a `dark` version:

```{r}
#| echo: fenced
#| renderings: [light, dark]
plot(1:10) # Shown in `light` mode

par(bg = "#000000", fg = "#FFFFFF", col.axis = "#FFFFFF")
plot(1:10) # Shown in `dark` mode
```

Both outputs are produced, but you'll only see the one corresponding to the current state of the light switch.
Toggle the switch in the navigation bar to see the image change to reflect the theme.

### Respect user color scheme

Set the new `html` format option `respect-user-color-scheme` to `true` if you would like your site to honor the viewer’s operating system or browser preference for light or dark mode:

```{.yaml filename="_quarto.yml"}
format:
  html:
    respect-user-color-scheme: true
```

## Other Highlights

-  Typst updated to 0.13.0
-  Pandoc updated to 3.6.3
-  New [`version` shortcode](/docs/authoring/version.qmd) to insert the version of Quarto used to build your document:
   
   ::: {layout-ncol=2 layout-valign="center"}
   
   ```{.markdown shortcodes="false"}
   Rendered with Quarto {{< version >}}
   ```
   ::: {.border .p-1}
   Rendered with Quarto {{< version >}}
   :::

   :::

-  Updated LaTeX and Beamer template partials:

    - [LaTeX partials](/docs/journals/templates.html#latex-partials)
    - [Beamer partials](/docs/journals/templates.html#beamer-partials)

    These changes reflect the updates made in Pandoc 3.5 to separate the LaTeX and Beamer document templates and introduce some additional partials for both. 
    If you have custom formats that provide custom templates or partials, you may need to update them to work with the new partials.   

-  Improvements to the `julia` engine: 
   - [`juliaup` integration](/docs/computations/julia.qmd#juliaup-integration): Use specific versions of Julia in your notebooks.
   
   - [R and Python support](/docs/computations/julia.qmd#r-and-python-support): Include `{r}` and `{python}` executable code cells via the RCall and PythonCall packages.
   
   - [Caching](/docs/computations/julia.qmd#caching-julia): Save time rendering long-running notebooks by caching results.
   
   - [Revise.jl integration](/docs/computations/julia.qmd#revise.jl-integration): Automatically update function definitions in Julia sessions.



## Acknowledgements

We'd like to say a huge thank you to everyone who contributed to this release by opening issues and pull requests:

{{< include _contribs.md >}}
```````

## File: docs/blog/posts/2025-05-19-quarto-codespaces/index.qmd
```````
---
author:
  - name: "Mickaël CANOUIL, _Ph.D._"
    orcid: "0000-0002-3396-4549"
    url: "https://mickael.canouil.fr"
title: "How to use GitHub Codespaces to simplify your Quarto workshops"
description: |
  In this post, I'll teach you the basics of GitHub Codespaces and how to use them to make it easier to teach using Quarto.
date: "2025-05-19"
categories:
  - GitHub Codespaces
  - Teaching
  - Dev Container
image: featured.png
image-alt: |
  Quarto icon and text above GitHub Codespaces.
lang: en-GB
---

## What Is GitHub Codespaces?

[GitHub Codespaces](https://github.com/features/codespaces) is a cloud-powered, on-demand development environment that runs either in your browser or in Visual Studio Code via the [GitHub Codespaces extension](https://marketplace.visualstudio.com/items?itemName=GitHub.codespaces).
It eliminates the need for lengthy local setup by providing a fully configured development container, complete with all necessary dependencies and tools.
This means that whether you're an instructor or a developer, you can start coding immediately with a consistent environment tailored to your specific project, right on your web browser.

More importantly, the participants of your workshops can use GitHub Codespaces just as easily as you can.
With Codespaces, you and your participants all work on identical environments, minimising the "it doesn't work on my machine" problems we are all too aware of.

In this post, I am assuming the case of a workshop instructor and a room full of participants with different laptops and operating systems.
Codespaces are also useful for development, though, as you will notice reading on.

## The Power of Combining Quarto CLI with Codespaces

Imagine a world where your participants are instantly equipped with the same environment with all the tools, libraries, and sample projects ready to go in the cloud.
That's the magic of using Codespaces:

1. **Immediate Onboarding:** Workshop participants or students can bypass the hassle of local setup.
   They simply launch a Codespace (running on their web browser of choice, independently of operating system), and the pre-configured environment is available immediately.

1. **A Consistent Environment:** Ensuring that everyone has the same tools and dependencies can be challenging.
   Codespaces lets you pre-define your environment with container configurations, reducing the risk of discrepancies in software versions or settings.

2. **Reproducible Workflows:** Whether you're teaching a data science workshop or collaborating on a research paper, reproducibility is crucial.
   Because GitHub Codespaces uses the [Dev Container specification](https://containers.dev/), you can ensure that your code can be run in the same environment.
   When participants are ready to run their projects locally, they can use Codespace to build an equivalent Docker container.

GitHub provides ["deep link"](https://docs.github.com/en/codespaces/setting-up-your-project-for-codespaces/setting-up-your-repository/facilitating-quick-creation-and-resumption-of-codespaces) to Codespaces, allowing you to create a link you can share with your students or workshop participants.

For example, the [`quarto-codespaces` repository](https://github.com/mcanouil/quarto-codespaces) provides several Dev Container / Codespaces configurations.
The following link will create a new Codespace using the `.devcontainer/universal/devcontainer.json` configuration file instead of the default `.devcontainer/devcontainer.json` file.

:::: {style="text-align: center;"}
[![](https://github.com/codespaces/badge.svg)](https://codespaces.new/mcanouil/quarto-codespaces?quickstart=1&devcontainer_path=.devcontainer%2Funiversal%2Fdevcontainer.json)
:::

```markdown
[![Open in GitHub Codespaces](https://github.com/codespaces/badge.svg)](https://codespaces.new/mcanouil/quarto-codespaces?quickstart=1&devcontainer_path=.devcontainer%2Funiversal%2Fdevcontainer.json)
```

The link can include a specific branch, a particular file, or even a specific line in a file, allowing you to guide participants directly to the relevant content and setup.
By doing nothing more than clicking that one link, participants create or resume an existing execution environment.

:::: {.dark-content}
:::: {layout-ncol="2"}
![](quarto-codespaces-new-001-dark.png){.lightbox group="codespaces-dark" fig-alt="GitHub Codespaces interface showing the 'Create codespace' page. The page includes a section with the repository 'mcanouil/quarto-codespaces' and a message stating 'No codespace to resume'. There are two buttons: 'Change options' and 'Create new codespace'."}

![](quarto-codespaces-new-002-dark.png){.lightbox group="codespaces-dark" fig-alt="image_url" alt="Screenshot of Visual Studio Code interface showing a GitHub Codespace for a project named 'quarto-codespaces'. The left sidebar contains a file explorer with folders and files such as .devcontainer, .github, init-env.sh, LICENSE, and README.md. The terminal at the bottom displays logs related to configuring the codespace, including commands and their outcomes. The right sidebar has a section titled 'Edit with Copilot' explaining how to use Copilot in agent mode."}
:::
:::

:::: {.light-content}

:::: {layout-ncol="2"}
![](quarto-codespaces-new-001-light.png){.lightbox group="codespaces-light" fig-alt="GitHub Codespaces interface showing the 'Create codespace' page. The page includes a section with the repository 'mcanouil/quarto-codespaces' and a message stating 'No codespace to resume'. There are two buttons: 'Change options' and 'Create new codespace'."}

![](quarto-codespaces-new-002-light.png){.lightbox group="codespaces-light" fig-alt="image_url" alt="Screenshot of Visual Studio Code interface showing a GitHub Codespace for a project named 'quarto-codespaces'. The left sidebar contains a file explorer with folders and files such as .devcontainer, .github, init-env.sh, LICENSE, and README.md. The terminal at the bottom displays logs related to configuring the codespace, including commands and their outcomes. The right sidebar has a section titled 'Edit with Copilot' explaining how to use Copilot in agent mode."}
:::
:::

## Setting Up Your Own Quarto-Codespaces Environment

If you're considering using Codespaces with Quarto CLI for your next workshop or teaching module, here's how to get started:

Leverage the example provided by the [`quarto-codespaces` repository](https://github.com/mcanouil/quarto-codespaces) or [create your own Codespaces using the default](https://github.com/codespaces/new/).

### Use an Existing Docker Image {#use-existing-docker-image}

The easiest way to get started is to use an existing Docker image that has Quarto CLI and all the dependencies you need.
There are several pre-built images available with or without the Quarto CLI:

- Official Docker images:
  - [`ghcr.io/quarto-dev/quarto`](https://github.com/quarto-dev/quarto-cli/pkgs/container/quarto)
  - [`ghcr.io/quarto-dev/quarto-full`](https://github.com/quarto-dev/quarto-cli/pkgs/container/quarto-full)
- Community Docker images:
  - [`ghcr.io/mcanouil/quarto-codespaces`](https://github.com/mcanouil/quarto-codespaces/pkgs/container/quarto-codespaces)
- Default Codespaces image:
  - [`mcr.microsoft.com/devcontainers/universal`](https://github.com/devcontainers/images/tree/main/src/universal)

You can use any of these images as a base for your Codespace.
Inside the `.devcontainer/devcontainer.json` file, you can specify the image you want to use.
The `.devcontainer/devcontainer.json` file serves as the blueprint for your Codespace.

```json
{
  "name": "My Workshop Setup",
  "image": "ghcr.io/mcanouil/quarto-codespaces:latest", // <1>
  "remoteUser": "vscode",
  "customizations": {
    "vscode": {
      "extensions": [
        "quarto.quarto", // <2>
        "mcanouil.quarto-wizard" // <3>
      ]
    },
    "codespaces": {
      "openFiles": [ // <4>
        "exercises/intro-to-quarto.qmd",
        "exercises/computation.qmd"
      ]
    }
  }
}
```

1. The Docker image is specified in the `image` field.
   It's built using a Dev Container specification that you can find in [`.github/.devcontainer`](https://github.com/mcanouil/quarto-codespaces/tree/main/.github/.devcontainer).
2. The [`quarto` extension](https://github.com/quarto-dev/quarto) for Visual Studio Code / Positron to provide support for Quarto documents.
3. The [`quarto-wizard` extension](https://github.com/mcanouil/quarto-wizard) for Visual Studio Code / Positron to provide assistance in managing Quarto extensions
4. The `openFiles` field specifies the files to open when the Codespace is created.
   This is useful for guiding participants to the right files or folders.
   See the [Codespaces documentation](https://docs.github.com/en/codespaces/setting-up-your-project-for-codespaces/configuring-dev-containers/automatically-opening-files-in-the-codespaces-for-a-repository) for more information.

### Configure the Development Container

You can fork the [`quarto-codespaces` repository](https://github.com/mcanouil/quarto-codespaces) as a starting point for your own Codespaces.
This repository includes the Dev Container configuration file (*i.e.*, `.devcontainer/devcontainer.json`) that instruct Codespaces on how to set up an environment complete with Quarto CLI and other essential tools.

The `.devcontainer/devcontainer.json` configuration file ensures that every instance of your Codespace is identical, capturing everything from the Quarto CLI version to additional libraries or extensions you might need.

The [`quarto-codespaces` repository](https://github.com/mcanouil/quarto-codespaces) is a great starting point as it provides a prebuilt Docker image with the latest Quarto CLI, Python, R, and Julia installed (*i.e.*, [`ghcr.io/mcanouil/quarto-codespaces`](https://github.com/mcanouil/quarto-codespaces/pkgs/container/quarto-codespaces) using [`.github/.devcontainer/devcontainer.json`](https://github.com/mcanouil/quarto-codespaces/tree/main/.github/.devcontainer)).

```json
{
  "name": "Quarto",
  // "image": "buildpack-deps:jammy-curl", // <1>
  "build": {
    "dockerfile": "./Dockerfile",
    "context": ".",
    "args": {
      "VARIANT": "jammy"
    }
  },
  "remoteUser": "vscode",
  "features": { // <2>
    "./quarto-computing-dependencies": { // <3>
      "rDeps": "rmarkdown,languageserver,nx10/httpgd@v2.0.3,prompt,lintr",
      "pythonDeps": "jupyter,papermill",
      "juliaDeps": "IJulia"
    },
    "./uv": { // <4>
      "version": "latest"
    },
    "ghcr.io/rocker-org/devcontainer-features/quarto-cli:1": { // <5>
      "version": "release",
      "installTinyTex": "true",
      "installChromium": "false"
    }
  },
  "customizations": { // <6>
    "vscode": {
      "extensions": [
        "quarto.quarto",
        "mcanouil.quarto-wizard",
        "REditorSupport.r",
        "Posit.air-vscode"
      ],
      "settings": {
        "r.rterm.option": [
          "--no-save",
          "--no-restore-data",
          "--quiet"
        ],
        "[r]": {
          "editor.defaultFormatter": "Posit.air-vscode",
          "editor.formatOnSave": true
        }
      }
    }
  }
}
```

1. The `image` field specifies the base image for the container.
   You can customise this to suit your needs.
2. The `features` section allows you to add additional tools or libraries.
   See the [Dev Container Features available](https://containers.dev/features/) for a comprehensive list of available features.
3. The `quarto-computing-dependencies` feature is a "local" custom feature that installs the computing dependencies: R, Python, and Julia.
   This is a great way to ensure that your Codespace has everything it needs to run Quarto documents.
4. The `uv` feature installs the [`uv` tool](https://docs.astral.sh/uv/) to manage Python packages and project dependencies.
5. The `quarto-cli` feature installs the Quarto CLI.
   You can specify the version you want to install, and it will be automatically downloaded and installed in your Codespace.
   You can see the code for this feature in the source repository: <https://github.com/rocker-org/devcontainer-features/tree/main/src/quarto-cli>.
6. The `customizations` section allows you to specify settings and extensions for Visual Studio Code.

You can also add additional features to the `devcontainer.json` to suit your needs or start directly using the image as is as shown in [Use an Existing Docker Image](#use-existing-docker-image).

For example, you might want to add additional R packages or Python libraries.
You can do this by using the `quarto-computing-dependencies` custom feature and changing the `rDeps`, `pythonDeps`, and `juliaDeps` fields to include the packages you want to install globally, or by using the `postStartCommand` field to run a script that installs the packages you need.

```json
{
  "name": "My Workshop Setup",
  "image": "ghcr.io/mcanouil/quarto-codespaces:latest",
  "remoteUser": "vscode",
  "postStartCommand": "uv venv && source .venv/bin/activate && uv pip install -r requirements.txt"
}
```

You can also use the `postStartCommand` field to run a script that installs the packages you need.

```json
{
  "name": "My Workshop Setup",
  "image": "ghcr.io/mcanouil/quarto-codespaces:latest",
  "remoteUser": "vscode",
  "postStartCommand": "bash ./init-env.sh --what all --force" // <1>
}
```

1. The `postStartCommand` field specifies a command to run after the Codespace is started.
   In this case, it runs the [`init-env.sh` script](https://github.com/mcanouil/quarto-codespaces/blob/main/init-env.sh) from [`quarto-codespaces` repository](https://github.com/mcanouil/quarto-codespaces) with the `--what all` and `--force` options.

## Benefits for Workshops and Teaching

When it comes to educational sessions, consistency and ease-of-use are paramount.
Pairing Codespaces with Quarto CLI brings many direct benefits to a teaching environment:

- **Streamlined Onboarding:** Students and workshop attendees can get right to work without spending time installing and configuring local environments.
- **Live, Interactive Sessions:** Instructors can demonstrate live edits to Quarto documents.
  Changes can be rendered instantly and reflect in each participant's environment: perfect for a hands-on, interactive learning experience.
- **Collaboration and Version Control:** All changes can be recorded in Git, making it easy to track progress, handle peer reviews, and manage collaborative projects, all within a single hosted environment.
- **Elimination of "Dependency Hell":** With containerised development, all attendees work from the same baseline, ensuring that version conflicts or missing libraries don't derail a session.

## Final Thoughts and Future Directions

Whether you're running a workshop, teaching a class, or collaborating on research, using Codespaces can reduce setup hassles, foster reproducibility, and encourage interactive learning.

In addition to the benefits mentioned above, other features further enhance your experience with Codespaces and Quarto CLI:

- **Automated Pipelines:** Integrating CI/CD tools to automatically validate Quarto document renders and catch errors using the exact same environment.
  See [GitHub Actions: Running jobs in a container](https://docs.github.com/en/actions/writing-workflows/choosing-where-your-workflow-runs/running-jobs-in-a-container)
- **Real-Time Co-Editing Features:** Enhancing collaborative sessions with simultaneous multi-user editing directly in Codespaces.
  See [GitHub Codespaces: Real-time collaboration](https://docs.github.com/en/codespaces/developing-in-a-codespace/working-collaboratively-in-a-codespace)

This post covered the basics of using Codespaces and Quarto together, but there's much more to Codespaces.
Learn more by [consulting their documentation](https://docs.github.com/en/codespaces).

Happy teaching!

## Disclaimer {.appendix .unnumbered}

GitHub Codespaces is a product of GitHub, Inc. and comes with a quota of free usage, including CPU hours and storage.
Be sure to check the [GitHub Codespaces billing documentation](https://docs.github.com/en/billing/managing-billing-for-your-products/managing-billing-for-github-codespaces/about-billing-for-github-codespaces) and your current GitHub plan to avoid unexpected charges.
If you are a student or an educator, you can explore the [GitHub Education program](https://education.github.com/pack) and [GitHub Classroom](https://docs.github.com/en/education/manage-coursework-with-github-classroom/integrate-github-classroom-with-an-ide/using-github-codespaces-with-github-classroom).

## Acknowledgements {.appendix .unnumbered}

Thanks to [Carlos Scheidegger](https://github.com/cscheid), [Julia Silge](https://github.com/juliasilge), and [James J. Balamuta](https://github.com/coatless) for their feedback and suggestions on this post.
```````

## File: docs/blog/posts/2025-xx-xx-1.7-release/index.qmd
```````
---
title: Quarto 1.6 
description: |
  Quarto 1.7 ...
categories:
  - Quarto 1.7
  - Releases
author: Charlotte Wickham
date: "xx/xx/2025"
draft: true
# image: 
# image-alt: 
---

Quarto 1.7 has been officially released! You can get the current release from the [download page](/docs/download/index.qmd)

You can read about these new features and a couple of breaking changes in the sections below. You can find all the changes in this version in the [Release Notes](/docs/download/changelog/1.7/).


## Acknowledgements

We'd like to say a huge thank you to everyone who contributed to this release by opening issues and pull requests:

{{< include _contribs.md >}}
```````

## File: docs/blog/posts/_quarto-1.3-feature.qmd
```````
::: callout-note
## Quarto 1.3 Feature

This post is part of a series highlighting new features in the 1.3 release of Quarto. Get the latest release the [download page](/docs/download/index.qmd)
:::
```````

## File: docs/blog/index.qmd
```````
---
title: Quarto Blog
subtitle: News, tips, and commentary about all things Quarto
listing:
  sort: "date desc"
  contents: "posts/*/index.qmd"
  sort-ui: false
  filter-ui: false
  categories: true
  feed: true
page-layout: full
margin-header: signup.html
title-block-banner: true
search: false
image: quarto-blog-v2.png
---
```````

## File: docs/books/_book-vs-website-key.qmd
```````
One important thing to note about using website tools is that while these tools are added to websites within the `website` key, in a book you should include the same options in the `book` key. For example, in a website you would include a favicon and twitter card as follows:

```yaml
website:
  favicon: logo.png
  twitter-card: true
  site-url: https://example.com
```

In a book you'd use the `book` key instead:

```yaml
book:
  favicon: logo.png
  twitter-card: true
  site-url: https://example.com
```
```````

## File: docs/books/book-basics.qmd
```````
---
title: "Creating a Book"
format:
  html:
    output-file: index.html
---

## Overview

Quarto Books are combinations of multiple documents (chapters) into a single manuscript. Books can be created in a variety of formats:

-   HTML
-   PDF
-   MS Word
-   EPUB
-   AsciiDoc

HTML books are actually just a special type of [Quarto Website](/docs/websites/website-basics.qmd) and consequently support all of the same features as websites including full-text search. The most important difference is that HTML books use chapter numbers and therefore support [Cross References](/docs/authoring/cross-references.qmd) between different chapters.

Here are some examples of books created with Quarto:

| Book                                                                             | Source                                                        |
|----------------------------------------|-------------------------------|
| [R for Data Science](https://r4ds.hadley.nz)                                     | [Code](https://github.com/hadley/r4ds/)                       |
| [Python for Data Analysis](https://wesmckinney.com/book/)                        | [Code](https://github.com/wesm/pydata-book/tree/3rd-edition)  |
| [Visualization Curriculum](https://jjallaire.github.io/visualization-curriculum) | [Code](https://github.com/jjallaire/visualization-curriculum) |

Quarto books can be published to a wide variety of destinations including GitHub Pages, Netlify, RStudio Connect, or any other static hosting service or intranet web server. See the documentation on [Publishing Websites](/docs/publishing/index.qmd) for additional details.


## Quick Start

Follow the Quick Start for your tool of choice to get a simple book up and running. After covering the basics, read on to learn about more advanced book features.

::: {.panel-tabset group="tools-tabset"}

### VS Code

To create a new book project within VS Code, execute the **Quarto: Create Project** command from the command-palette:

![](/docs/websites/images/vscode-create-project-command.png)

Then, select **Book Project**:

![](/docs/websites/images/vscode-create-project-book.png){.border}

You'll be prompted to select a parent directory to create the project within. Then, you'll be asked to name the directory for your book project:

![](/docs/websites/images/vscode-create-project-directory.png){.border}

The new book project will be created and opened within VS Code. Click the **Preview** button (![](/docs/tools/images/vscode-preview-icon.svg){fig-alt="Preview icon"}) to preview the book:

![](/docs/websites/images/vscode-create-project-render-book.png)

The preview will show to the right of the source file. As you re-render `index.qmd` or render other files like `intro.qmd`, the preview is automatically updated.


### RStudio

To create a new book project within RStudio, use the **New Project** command and select **Quarto Book**:

:::{layout-ncol="2"}

![](/docs/websites/images/rstudio-project-new-directory.png){.border}

![](/docs/websites/images/rstudio-project-book.png){.border}
:::

Then, provide a directory name and other relevant options for the book:

![](/docs/websites/images/rstudio-project-book-options.png){.border}

Click the **Render** button to preview the book:

![](/docs/websites/images/rstudio-project-book-preview.png)

The preview will show to the right of the source file. As you re-render `index.qmd` or render other files like `intro.qmd`, the preview is automatically updated.


### Terminal

To create a new book project from the Terminal, use the `quarto create project` command, following the prompt to select the type and to provide a name for the project (will be used as the directory name):

```{.bash filename="Terminal"}
quarto create project book mybook
```

This will create the scaffolding for a simple book in the `mybook` sub-directory. Use the `quarto preview` command to render and preview the book:

```{.bash filename="Terminal"}
quarto preview mybook
```

The book preview will open in a new web browser. As you edit and save `index.qmd` (or other files like `intro.qmd`) the preview is automatically updated.

:::


## Workflow

Above we demonstrated how to create and edit a simple book with chapters contained in the files `index.qmd`, `intro.qmd`, `summary.qmd`. Here we'll cover additional aspects of book workflow in more depth.

### Config File

A Quarto project file (`_quarto.yml`) is contained within the book project directory. This file contains the initial configuration for your book. For example:

``` yaml
project:
  type: book

book:
  title: "mybook"
  author: "Jane Doe"
  date: "8/18/2021"
  chapters:
    - index.qmd
    - intro.qmd
    - summary.qmd
    - references.qmd

bibliography: references.bib

format:
  html:
    theme: cosmo
  pdf:
    documentclass: scrreprt
  epub:
    cover-image: cover.png
```



See the [Project Basics](/docs/projects/quarto-projects.qmd) article to learn more about working with projects, including how to add custom pre and post render scripts to your book.

### Book Preview

If you are using VS Code or RStudio, the **Preview** button (VS Code), or **Render** button (RStudio), automatically renders and runs `quarto preview` in an embedded window. You can also do the same thing from the Terminal if need be:

``` {.bash filename="Terminal"}
# preview the book in the current directory
quarto preview
```

Note that when you preview a book (either using VS Code / RStudio integrated tools or from the terminal)  changes to configuration files (e.g. `_quarto.yml`) as well as book resources (e.g. theme or CSS files) will cause an automatic refresh of the preview.

You can customize the behavior of the preview server (port, whether it opens a browser, etc.) using command line options or the `_quarto.yml` config file. See `quarto preview help` or the [project file reference](/docs/reference/projects/options.qmd#preview) for additional details.


::: callout-important
As you preview your book, chapters will be rendered and updated. However, if you make changes to global options (e.g. `_quarto.yml` or included files) you need to fully re-render your book to have all of the changes reflected. Consequently, you should always fully `quarto render` your site before deploying it, even if you have already previewed changes to some pages with the preview server.
:::

For AsciiDoc Books we recommend using the HTML format to preview your book, read more in [AsciiDoc Books](#asciidoc-books).

### Publishing

When you are ready to publish the book, use the `render` command to render all output formats:

``` {.bash filename="Terminal"}
quarto render
```

If you pass no arguments to `quarto render`, all formats will be rendered. You can also render individual formats via the `--to` argument:

``` {.bash filename="Terminal"}
quarto render           # render all formats
quarto render --to pdf  # render PDF format only
```

The output of your book will be written to the `_book` sub-directory of your book project:

``` {.bash filename="Terminal"}
mybook/
  _book/
    index.html # and other book files
    mybook.pdf
    mybook.epub
```

See the documentation on [Publishing Websites](/docs/publishing/index.qmd) for details on how to publish books to GitHub Pages, Netlify, and other services. Note that in that documentation the `output-dir` may be referred to as `_site`: for publishing books you should use `_book` rather than `_site`.

### AsciiDoc Books {#asciidoc-books}

For AsciiDoc books, we recommend that while you are working on your book, you preview your content using Quarto's built in HTML format, which allows an iterative workflow using the preview capabilities of Quarto. Once you're ready to produce AsciiDoc, you can use the AsciiDoctor tools to compile your book to PDF or HTML output to preview the content in its final rendered form.

#### Previewing PDF with Asciidoctor-pdf

Creating a PDF preview with the AsciiDoc toolchain is a useful way to verify that the AsciiDoc output of your book can be rendered properly. To do this, follow these instructions:

1.  First, install Asciidoctor PDF by following the instructions here: <https://docs.asciidoctor.org/pdf-converter/latest/install/>

2.  From the terminal in the root of your project, use the following command to compile your AsciiDoc book to a PDF:
      
    ``` bash
    $  asciidoctor-pdf _book/book-asciidoc/<title>.adoc
    ```

3.  The PDF will be placed at `_book/book-asciidoc/<title>.pdf`.

#### Previewing HTML with Asciidoctor

Creating an HTML preview with the AsciiDoc toolchain is a useful way to verify that the AsciiDoc output of your book can be rendered properly. To do this, follow these instructions:

1.  First, install Asciidoctor by following the instructions here: <https://docs.asciidoctor.org/asciidoctor/latest/install/>

2.  From the terminal in the root of your project, use the following command to compile your AsciiDoc book to HTML:
    
    ``` bash
    $  asciidoctor _book/book-asciidoc/<title>.adoc
    ```

3.  A single HTML file (with the entire contents of the book) will be placed at `_book/book-asciidoc/<title>.html`. The HTML file will contain references to files and images in the `_book/book-asciidoc/` folder, so the HTML will not display these properly if it is moved without also moving those folders.

## Learning More

Once you've got the basic book template up and running check out these articles for various ways to enhance your book:

- [Book Structure](book-structure.qmd) delves into different ways to structure a book (numbered and unnumbered chapters/sections, creating multiple parts, adding appendices, etc.)

- [Book Crossrefs](book-crossrefs.qmd) explains how to create cross references to sections, figures, tables, equations and more within books.

- [Book Output](book-output.qmd) covers customizing the style and appearance of your book in the various output formats as well as how to provide navigation and other tools for readers.

- [Book Options](/docs/reference/projects/books.qmd) provides a comprehensive reference to all of the available book options.

- [Code Execution](/docs/projects/code-execution.qmd) provides tips for optimizing the rendering of books with large numbers of documents or expensive computations.

- [Publishing Websites](/docs/publishing/index.qmd) enumerates the various options for publishing your book as a website including GitHub Pages, Netlify, and RStudio Connect.
```````

## File: docs/books/book-crossrefs.qmd
```````
---
title: "Book Crossrefs"
---

## Overview

One important difference between creating a website and a book is that in addition to their web output, books can also be rendered as a single continuous document (e.g a PDF or MS Word document). Books also may or may not be read digitally (which means that internal hyperlinks may or may not be available).

To create books that are consumable in all of these mediums, special care should be taken when creating links to other chapters or sections within chapters (note though that if your book targets *only* HTML output you can feel free to use conventional hyperlinks).

Quarto cross references provide automatic numbering and reference creation for figures, tables, equations, sections, listings, theorems, and proofs. In books, cross references work the same way except they can reach across chapters.

If you aren't already familiar with using crossrefs you may want to read the documentation on [cross references](/docs/authoring/cross-references.qmd) before reading on about how they work with books.

## Creating References

To reference a figure, table, or other cross-referenceable entity, use the `@` syntax (similar to citations) along with the ID / label of the entity you are referencing: For example:

``` markdown
See @fig-penginus-by-island for a breakdown by island.
```

References made this way will be automatically resolved across chapters (including the requisite chapter number in the reference).

To make a chapter or section reference-able, you add a `#sec` prefix to its main heading. For example:

``` markdown
# Introduction {#sec-introduction}
```

::: callout-important
## Label Prefix

In order for a chapter to be cross-referenceable, its label must start with the `sec-` prefix.
:::


To refer to a section, include a cross-reference to it using an `@` identifier as we did above in the figure example:

``` markdown
See @sec-introduction for additional discussion.
```

Which, for example, will render as:

> See [Chapter 1](#) for additional discussion.

The appropriate prefix, "Chapter" or "Section", will be added to the reference based on the level of the heading.
To suppress the prefix, use bracket syntax and prepend `-` before `@`. For example, `[-@sec-introduction]` will produce just "1" without the "Chapter" prefix.

To provide a custom prefix, e.g. "Chapter" for a section heading, spell out the prefix in the bracket syntax. For example:

``` markdown
See [Chapter @sec-visualization] for more details on visualizing model diagnostics.
```

Which might render as:

> See [Chapter 1.2](#) for more details on visualizing model diagnostics.

## Section Numbers

By default, all headings in your document create a numbered section. You customize numbering depth using the `number-depth` option. For example, to only number sections immediately below the chapter level, use this:

``` yaml
number-depth: 2
```

Note that `toc-depth` is independent of `number-depth` (i.e. you can have unnumbered entries in the TOC if they are masked out from numbering by `number-depth`).

## Chapter Numbering

In books, figures, tables and other cross-reference targets automatically include a chapter number. For example, the following markdown located in Chapter 3 of your book:

``` markdown
As illustrated in @fig-geo-comparison, the western states have a much higher incidence of forest fires.
```

Might be rendered as:

> As illustrated in [fig. 3.2](#), the western states have a much higher incidence of forest fires.

Note that while books do support unnumbered chapters, you naturally cannot create cross-references to content in chapters without numbers.

## Hyperlinks

If you are creating an HTML-only book (or a PDF / MS Word book that you don't expect will be printed) then you can feel free to use normal hyperlinks rather than section cross-references.

To create a hyperlink within a book, provide the source file as the link target. You can also add hash identifiers (`#`) to the source file if you want to link to a particular section in the document. For example:

``` markdown
[about](about.qmd)
[about](about.qmd#section)
```

Using the source file as the link target ensures that links will be resolved correctly both for HTML output and for formats that produce a single file (e.g. PDF or MS Word).

Note that if you are targeting printed output for your book you should use explicit cross references to other chapters and sections rather than simple links as shown above. This is because In printed output links aren't navigable so you need to provide readers with numbered references (e.g. "sec. 5.3") rather than hyperlinks.
```````

## File: docs/books/book-output.qmd
```````
---
title: "Customizing Book Output"
format: html
project-type: book
---

This article covers customizing the output of book projects, including how to tailor the styles and appearance of books in each supported output format.

## Format Options

If you want to specify rendering options (including format-specific options), you do it within the `_quarto.yml` project file rather than within the individual markdown documents. This is because when rendering a book all of the chapters are combined together into a single document (with a single set of format options).

Here's an example configuration:

``` yaml
highlight-style: pygments

format:
  html:
    theme: cosmo
    code-copy: true
  pdf: default
    
bibliography: references.bib
csl: citestyle.csl
```

Note that in the above configuration the `highlight-style` option applies to all formats whereas the `html` options apply to only HTML output. The bibliography related options naturally also apply to all formats.

## Reader Tools

### Website Tools

HTML books are at their core [Quarto Websites](/docs/websites/website-basics.qmd) with some special navigational behavior built in. This means that all of the features described for enhancing websites are also available for books, including:

-   [Navbars](/docs/websites/website-navigation.qmd#top-navigation)
-   [Social Metadata](/docs/websites/website-tools.qmd#social-metadata)
-   [Full Text Search](/docs/websites/website-search.qmd)
-   [Google Analytics](/docs/websites/website-tools.qmd#google-analytics)
-   [Headers and Footers](/docs/websites/website-tools.qmd#headers-footers)
-   [Dark Mode](/docs/websites/website-tools.qmd#dark-mode)

{{< include _book-vs-website-key.qmd >}}



### Sidebar Tools

Books automatically include a navigational sidebar that can optionally include tools for searching book contents, sharing links to the book, etc. Here is an example `_quarto.yml` file that enables these options:

``` yaml
book:
  title: "Hands-On Programming with R"
  author: "Garrett Grolemund"
  search: true
  repo-url: https://github.com/jjallaire/hopr/
  repo-actions: [edit]
  downloads: [pdf, epub]
  sharing: [twitter, facebook]
  
comments:
  hypothesis: true
```

Note the various tools that now appear:

![](images/book-tools.png){.border .preview-image fig-alt="A screen shot of a Quarto page rendered with the options indicated in the immediately preceding yaml. There are icons for accessing the page's Github repo, downloading the page as a PDF, and sharing the page on social media in the top section of the sidebar. Immediately below this in the sidebar is a search bar. There are icons for the Hypothesis collaborative annotation software in the upper right hand corner of the page. There is an 'Edit this Page' link underneath the page table of contents on the right; there is a Github icon to the left of the word 'Edit.'"}

-   The search box enables full text search of the entire book

-   The buttons immediately below the book title in the sidebar provide a link to the GitHub repo for the book, downloads for PDF and ePub versions of the book, and links for sharing the book on Twitter and Facebook.

-   Immediately below the table of contents on the right there is an "Edit this page" link that takes the reader to the edit interface on GitHub for the current chapter. Note that in this example we specify `repo-actions: [edit]`. You can optionally also add `issue` and `source` actions (e.g. `repo-actions: [edit, issue, source]`). There are additional options available (`repo-subdir` and `repo-branch`) for [customizing repository links](/docs/websites/website-navigation.qmd#github-links).

-   The [Hypothesis](https://web.hypothes.is/) commenting bar appears on the far right of the page. Note that [commenting](/docs/output-formats/html-basics.qmd#commenting) is a feature available for all Quarto HTML output so appears in its own YAML key.

#### Sidebar Options

Note that books utilize the standard sidebar component from [Quarto Websites](/docs/websites/website-basics.qmd). This means that you can use any of the available [sidebar options](/docs/websites/website-navigation.qmd#side-navigation) within your `book` configuration. For example, here we specify a docked sidebar with a light background:

``` yaml
book:
  title: "Hands-On Programming with R"
  author: "Garrett Grolemund"
  sidebar:
    style: docked
    background: light
```

## Cover Images

You can provide a cover image for EPUB and/or HTML formats using the `cover-image` option. For example:

``` yaml
book:
  cover-image: cover.png
```

You can also do this on a per-format basis (if for example you want to provide a higher resolution image for EPUB and a lower resolution image for HTML to reduce download time). For example:

``` yaml
format:
   html: 
     cover-image: cover.png
   epub:
     cover-image: cover-highres.png
```

You can specify HTML alt-text for book cover images using the `cover-image-alt` option:

``` yaml
book:
  cover-image: cover.png
  cover-image-alt: |
    Alternative text describing the book cover 
```

## Output Path

By default, book output is written to the `_book` directory of your project. You can change this via the `output-dir` project option. For example:

``` yaml
project:
  type: book
  output-dir: docs
```

Single file outputs like PDF, EPUB, etc. are also written to the `output-dir`. Their file name is derived from the book `title`. You can change this via the `output-file` option:

``` yaml
book:
  title: "My Book"
  output-file: "my-book"
```

Note that the `output-file` should *not* have a file extension (that will be provided automatically as appropriate for each format).

## LaTeX Output

In some cases you'll want to do customization of the LaTeX output before creating the final printed manuscript (e.g. to affect how text flows between pages or within and around figures). The best way to approach this is to develop your book all the way to completion, then render to the `latex` format

``` {.bash filename="Terminal"}
quarto render --to latex
```

The complete LaTeX source code of your book will be output into the `_book/book-latex` directory.  

At this point you should probably make a copy or git branch of the `_book` directory to perform your final LaTeX modifications within (since the modifications you make to LaTeX will not be preserved in your markdown source, and will therefore be overwritten the next time you render).

## HTML Styles

HTML output can be customized either by adding (or enhancing) a custom theme, or by providing an ordinary CSS file. Use the `theme` option to specify a theme:

``` yaml
format:
  html:
    theme: cosmo
```

To further customize a theme add a custom theme file:

``` yaml
format:
  html:
    theme: [cosmo, theme.scss]
```

You can learn more about creating theme files in the documentation on [HTML Themes](/docs/output-formats/html-themes.qmd).

You can also just use plain CSS. For example:

``` yaml
format:
  html:
    css: styles.css
```

## EPUB Styles

You can also use CSS to customize EPUB output:

``` yaml
format:
  epub:
    css: epub-styles.css
    epub-cover-image: epub-cover.png
```

Note that we also specify a cover image. To learn more about other EPUB options, see the Pandoc [documentation on EPUBs](https://pandoc.org/MANUAL.html#epubs).

## PDF Styles

You can include additional LaTeX directives in the preamble of your book using the `include-in-header` option. You can also add `documentclass` and other options (see the Pandoc documentation on [LaTeX options](https://pandoc.org/MANUAL.html#variables-for-latex) for additional details). For example:

``` yaml
format:
  pdf: 
    documentclass: scrbook
    include-in-header: preamble.tex
    fontfamily: libertinus
```

Quarto uses the [KOMA Script](https://ctan.org/pkg/koma-script) `scrreprt` document class by default for PDF books. KOMA-Script classes are drop-in replacements for the standard classes with an emphasis on typography and versatility.

You can switch to KOMA `scrbook` as demonstrated above, or to the standard LaTeX `book` and `report` classes. You can find a summary of the differences between `book` and `report` here: <https://tex.stackexchange.com/questions/36988>

## MS Word Styles

You can customize MS Word output by creating a new [reference doc](https://pandoc.org/MANUAL.html#option--reference-doc), and then applying it to your book as follows:

``` yaml
format:
  docx:
    reference-doc: custom-reference.docx
```

Learn more about creating and customizing a reference document in the documentation on [Word templates](/docs/output-formats/ms-word-templates.qmd).
```````

## File: docs/books/book-structure.qmd
```````
---
title: "Book Structure"
format: html
project-type: book
---

## Overview

The structure of a Quarto book can be as simple as a list of chapters, or can alternatively incorporate multiple parts and/or appendices. Quarto book chapters and sections are automatically numbered (for cross-referencing), however you can also specify that some parts of the book should remain unnumbered.

The simple book configuration generated by `quarto create project book` illustrates the basics. 
Book properties like the title, author and chapter structure are listed under `book`:

``` {.yaml filename="_quarto.yml"}
book:
  title: "mybook"
  author: "Jane Doe"
  date: "5/9/2021"
  chapters:
    - index.qmd
    - intro.qmd
    - summary.qmd
    - references.qmd
```

-   The `index.qmd` file is required (because Quarto books also produce a website in HTML format). This page should include the preface, acknowledgements, etc. The HTML version of the book will use the `index.qmd` as the home page and if provided, will place the `cover-image` on that page.
-   The remainder of `chapters` includes one or more book chapters.
-   The `references.qmd` file will include the generated bibliography (see [References] below for details).

Rendering options that should apply to all chapters and all formats are listed at the top-level of `_quarto.yml`(i.e. not nested under `book`):

``` {.yaml filename="_quarto.yml"}
bibliography: references.bib
```

Rendering options that should apply to all chapters for specific formats are listed under `format`:

``` {.yaml filename="_quarto.yml"}
format:
  html:
    theme: cosmo
  pdf:
    documentclass: scrreprt
```

## Titles

Since rendering options are provided in `_quarto.yml`, you'll typically see a simple level-one heading at the top of chapters. For example:

``` {.markdown filename="intro.qmd"}
# Introduction
```

Note that the following is also still perfectly valid:

```{.yaml filename="intro.qmd"}
---
title: "Introduction"
---
```

In the absence of a level-one heading or a title set in the YAML front matter, the first heading in the page will be used as the title.

## Chapter Numbers

All chapters are numbered by default. If you want a chapter to be unnumbered simply add the `.unnumbered` class to its main heading. For example, it is common to omit the chapter number for `index.qmd`:

```{.markdown filename="index.qmd"}
# Preface {.unnumbered}
```

You can mix together numbered and unnumbered chapters. Note however that while you can link to unnumbered chapters, you can't [cross reference](/docs/authoring/cross-references.qmd) figures, tables, etc. within them. Unnumbered chapters are therefore mostly useful for prefatory content or references at the end of your book.

## Section Numbers

You can set the numbering depth via the `number-depth` option. For example, to only number sections immediately below the chapter level, use this:

```{.yaml filename="_quarto.yml"}
number-depth: 1
```

Note that `number-depth` is a format option, not a `book` option so it is placed at the top-level of `_quarto.yml`, not nested under `book`. 
If you want `number-depth` to only apply to a certain format, nest it under `format`:

```{.yaml filename="_quarto.yml"}
format:
  pdf:
    number-depth: 1
```

The `toc-depth` option is independent of `number-depth` (i.e. you can have unnumbered entries in the TOC if they are masked out from numbering by `number-depth`).

## References

You should include a `div` with the id `#refs` at the location in your book where you'd like the bibliography to be generated. For example the `references.qmd` file generated by `quarto create project book` includes this:

```{.markdown filename="references.qmd"}
# References {.unnumbered}

::: {#refs}
:::
```

Note that you can change the chapter title to whatever you like, remove `.unnumbered` to have it be numbered like other chapters, and add other content before or after the bibliography as necessary.

## Creating an Index

For PDF output, you can create an index using the LaTeX [makeidx](https://ctan.org/pkg/makeidx?lang=en) package along with the `\index` command.

To add an index to the PDF output for a book, add these `include-in-header` and `include-after-body` entries to your `pdf` format configuration in `_quarto.yml`:

```{.yaml filename="_quarto.yml"}
format:
  html:
    theme: cosmo
  pdf:
    documentclass: scrreprt
    include-in-header: 
      text: |
        \usepackage{makeidx}
        \makeindex
    include-after-body: 
      text: |
        \printindex
```

Then, add `\index{entry}` commands wherever you want an index entry. For example:

```{.latex filename="chapter.qmd"}
Markdown\index{Markdown} allows you to write using
an easy-to-read, easy-to-write plain text format.
```

Alternatively, you can also use the [imakeidx](https://ctan.org/pkg/imakeidx) package.
This packages offers additional features for formatting the index. For example:

```{.yaml filename="_quarto.yml"}
format:
  html:
    theme: cosmo
  pdf:
    documentclass: scrreprt
    include-in-header: 
      text: |
        \usepackage{imakeidx}
        \makeindex[intoc=true, columns=3, columnseprule=true, options=-s latex/indexstyles.ist]
    include-after-body: 
      text: |
        \printindex
```

In the above example, `intoc=true` will include an entry for the index into the table of contents,
`columns=3` will format the index into three columns, and `columnseprule=true` will display a line between index columns.
Finally, `options=-s latex/indexstyles.ist` will use additional formatting options from an index-style file located at `latex/indexstyles.ist`.
Many other features are available in the [imakeidx](https://ctan.org/pkg/imakeidx) package. Please refer to its documentation for further details.

Note that `\index` commands are automatically ignored for non-PDF output.

## Parts & Appendices

:::{.callout-note}

## Please Note

Note that EPUB and Word (Docx) formats do not currently support organizing books into parts. When rendering a book with parts to these formats, the parts will be ignored.

:::

You can divide your book into parts using `part` within the book `chapters`. For example:

```{.yaml filename="_quarto.yml"}
book:
  chapters:
    - index.qmd
    - preface.qmd
    - part: dice.qmd
      chapters: 
        - basics.qmd
        - packages.qmd
    - part: cards.qmd
      chapters:
        - objects.qmd
        - notation.qmd
        - modifying.qmd
        - environments.qmd
```

Note that the markdown files `dice.qmd` and `cards.qmd` contain the part title (as a level one heading) as well as some introductory content for the part. If you just need a part title then you can alternatively use this syntax:

```{.yaml filename="_quarto.yml"}
book:
  chapters:
    - index.qmd
    - preface.qmd
    - part: "Dice"
      chapters: 
        - basics.qmd
        - packages.qmd
```

You can include appendices by adding an `appendices` key to your `book` config. For example:

```{.yaml filename="_quarto.yml"}
book:
  chapters:
    - index.qmd
    - intro.qmd
    - summary.qmd
    - references.qmd
  appendices:
    - tools.qmd
    - resources.qmd
  
```

Parts and appendices show up like this in HTML output:

![](images/book-parts-appendices.png){.border fig-alt="A screenshot of the welcome page of a book rendered with Quarto. In the sidebar, content is separated by three different bold section titles. From top to bottom, these are: 'PROJECT 1: WEIGHTED DICE', 'PROJECT 2: PLAYING CARDS', and 'APPENDICES.'"}

In LaTeX output, the `\part` command is used for parts. In EPUB and MS Word output parts are ignored entirely.

Appendices are numbered using uppercase alpha, and have a prefix inserted into their title to indicate they are an appendix (e.g. "Appendix A --- Additional Resources"). You can customize the prefix and delimiter using the following options:

```{.yaml filename="_quarto.yml"}
crossref:
  appendix-title: "App."
  appendix-delim: ":"
```

Which would result in the above example being output as: "App. A: Additional Resources". 
Note that `crossref` is a format option and is not nested under `book`.

{{< include ../websites/_page-navigation.md >}} 

{{< include ../websites/_footer.md >}}
```````

## File: docs/computations/caching.qmd
```````
---
title: "Caching"
---

## Overview

When rendering documents with embedded computations becomes time-consuming, you may want to consider adding an execution cache, which will store the results of cell executions so they aren't re-executed with every document render.

Quarto integrates with the [Jupyter Cache](https://jupyter-cache.readthedocs.io/en/latest/) and [Knitr Cache](https://bookdown.org/yihui/rmarkdown-cookbook/cache.html) to cache time consuming code chunks. These two caching facilities distinct capabilities, and we'll cover each in detail below.

## Jupyter Cache

[Jupyter Cache](https://jupyter-cache.readthedocs.io/en/latest/) enables you to cache all of the cell outputs for a notebook. If any of the cells in the notebook change then all of the cells will be re-executed.

To use Jupyter Cache you'll want to first install the `jupyter-cache` package:

+-----------+---------------------------------------+
| Platform  | Command                               |
+===========+=======================================+
| Mac/Linux | ``` {.bash filename="Terminal"}       |
|           | python3 -m pip install jupyter-cache  |
|           | ```                                   |
+-----------+---------------------------------------+
| Windows   | ``` {.powershell filename="Terminal"} |
|           | py -m pip install jupyter-cache       |
|           | ```                                   |
+-----------+---------------------------------------+
| Conda     | ``` {.bash filename="Terminal"}       |
|           | conda install jupyter-cache           |
|           | ```                                   |
+-----------+---------------------------------------+

::: callout-note
## Julia Installation

Note that if you are using Julia along with the integrated Python environment provided by `IJulia` then you should alternatively follow the directions on [Installing Jupyter Cache for Julia](julia.qmd#jupyter-cache).
:::

To enable the cache for a document, add the `cache` option. For example:

``` yaml
---
title: "My Document"
format: html
execute: 
  cache: true
jupyter: python3
---
```

You can also specify caching at the project level. For example, within a project file:

``` yaml
project:
  type: website
  
format:
  html:
    theme: united
    
execute:
  cache: true
```

Note that changes within a document that aren't within code cells (e.g. markdown narrative) do not invalidate the document cache. This makes caching a very convenient option when you are working exclusively on the prose part of a document.

Jupyter Cache include a `jcache` command line utility that you can use to analyze and manage the notebook cache. See the [Jupyter Cache](https://jupyter-cache.readthedocs.io/en/latest/) documentation for additional details.

## Knitr Cache

The Knitr Cache operates at the level of individual cells rather than the entire document. While this can be very convenient, it also introduced some special requirements around managing the dependencies between cells.

You can enable the Knitr cache at the document or project level using standard YAML options:

``` yaml
---
title: "My Document"
format: html
execute: 
  cache: true
---
```

You can also enable caching on a per-cell basis (in this you would *not* set the document level option):

```{{r}}
#| cache: true

summary(cars)
```

There are a variety of other cell-level options that affect Knitr caching behavior. You can learn about them in the Knitr [cell options](/docs/reference/cells/cells-knitr.qmd#cache) reference. Another excellent resource is Yihui Xie's article on [cache invalidation](https://yihui.org/en/2018/06/cache-invalidation/).

## Rendering

You can use \`quarto render\` command line options to control caching behavior without changing the document's code. Use options to force the use of caching on all chunks, disable the use of caching on all chunks (even if it's specified in options), or to force a refresh of the cache even if it has not been invalidated:

``` {.bash filename="Terminal"}
# use a cache (even if the document options don't enable it)
quarto render example.qmd --cache 

# don't use a cache (even if the documentation options enable it)
quarto render example.qmd --no-cache 

# use a cache and force a refresh (even if the cells haven't changed)
quarto render example.qmd --cache-refresh 
```

## Alternatives

If you are using caching to mitigate long render-times, there are some alternatives you should consider alongside caching.

### Disabling Execution

If you are working exclusively with prose / markdown, you may want to disable execution entirely. Do this by specifying the `enabled: false` execute option For example:

``` yaml
---
title: "My Document"
format: html
execute: 
  enabled: false
---
```

Note that if you are authoring using Jupyter `.ipynb` notebooks (as opposed to plain-text `.qmd` files) then this is already the default behavior: no execution occurs when you call `quarto render` (rather, execution occurs as you work within the notebook).

### Freezing Execution

If you are working within a project and your main concern is the cumulative impact of rendering many documents at once, consider using the `freeze` option.

{{< include ../projects/_freeze-basics.md >}} 


Learn more about using `freeze` with projects in the article on [managing project execution](/docs/projects/code-execution.qmd#freeze).
```````

## File: docs/computations/execution-options.qmd
```````
---
title: Execution Options
format: html
---

## Output Options

There are a wide variety of options available for customizing output from executed code. All of these options can be specified either globally (in the document front-matter) or per code-block. For example, here's a modification of the Python example to specify that we don't want to "echo" the code into the output document:

``` yaml
---
title: "My Document"
execute:
  echo: false
jupyter: python3
---
```

Note that we can override this option on a per code-block basis. For example:

```{{python}}
#| echo: true

import matplotlib.pyplot as plt
plt.plot([1,2,3,4])
plt.show()
```

Code block options are included in a special comment at the top of the block (lines at the top prefaced with `#|` are considered options).

Options available for customizing output include:

+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| Option       | Description                                                                                                                                                                                       |
+==============+===================================================================================================================================================================================================+
| `eval`       | Evaluate the code chunk (if `false`, just echos the code into the output).                                                                                                                        |
+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| `echo`       | Include the source code in output                                                                                                                                                                 |
+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| `output`     | Include the results of executing the code in the output (`true`, `false`, or `asis` to indicate that the output is raw markdown and should not have any of Quarto's standard enclosing markdown). |
+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| `warning`    | Include warnings in the output.                                                                                                                                                                   |
+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| `error`      | Include errors in the output (note that this implies that errors executing code will not halt processing of the document).                                                                        |
+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| `include`    | Catch all for preventing any output (code or results) from being included (e.g. `include: false` suppresses all output from the code block).                                                      |
+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| `renderings` | Specify rendering names for the plot or table outputs of the cell, e.g. `[light, dark]`                                                                                                           |
+--------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+

Here's a Knitr example with some of these additional options included:

````         
---
title: "Knitr Document"
execute:
  echo: false
---

```{{r}}
#| warning: false

library(ggplot2)
ggplot(airquality, aes(Temp, Ozone)) + 
  geom_point() + 
  geom_smooth(method = "loess", se = FALSE)
```

```{{r}}
summary(airquality)
```
````

### Cell Renderings

Here is an example of using `renderings` to provide light and dark versions of a plot. Note that the number of cell outputs must match the number of renderings.

````
---
title: "Dark mode"
format: 
  html:
    theme:
      light: flatly
      dark: darkly
---

```{{r}}
#| renderings: [light, dark]
par(bg = "#FFFFFF", fg = "#000000")
plot(1:10) # Shown in `light` mode

par(bg = "#000000", fg = "#FFFFFF", col.axis = "#FFFFFF")
plot(1:10) # Shown in `dark` mode
```
````

::: {layout-ncol=2}

![light rendering](images/renderings-light-mode.png)

![dark rendering](images/renderings-dark-mode.png)

:::

The `renderings` cell option does not currently work correctly with cell cross-reference options (`label` starting with `fig-`, `tbl-`, etc.) or cell caption options (`fig-cap`, `tbl-cap`, etc.).


To combine `renderings` with crossrefs and/or captions, use the fenced div syntax:


````
---
title: "Dark mode"
format:
  html:
    theme:
      light: flatly
      dark: darkly
---

::: {#fig-caption-crossref}

```{{r}}
#| label: caption-crossref
#| renderings: [light, dark]
par(bg = "#FFFFFF", fg = "#000000")
plot(1:10) # Shown in `light` mode


par(bg = "#000000", fg = "#FFFFFF", col.axis = "#FFFFFF")
plot(1:10) # Shown in `dark` mode
```

Light and dark renderings with a caption and crossref

:::
````

Note the use of a `label` that is not a cross-reference, i.e. that does not start with one of the [cross reference types](../authoring/cross-references.qmd#overview). It is a good practice to have named cells with `label`, for debuggability and stable resource names. However, cross-reference labels that start with `fig-`, `tbl-`, etc., will not work with `renderings`.



::: callout-tip
When using the Knitr engine, you can also use any of the available native options (e.g. `collapse`, `tidy`, `comment`, etc.). See the [Knitr options documentation](https://yihui.org/knitr/options/) for additional details. You can include these native options in option comment blocks as shown above, or on the same line as the `{r}` as shown in the Knitr documentation.
:::

::: callout-tip
The Knitr engine can also *conditionally* evaluate a code chunk using objects or expressions. See [Using R: Knitr Options](r.qmd#chunk-options).
:::

## Figure Options

There are a number of ways to control the default width and height of figures generated from code. First, it's important to know that Quarto sets a default width and height for figures appropriate to the target output format. Here are the defaults (expressed in inches):

| Format                  | Default   |
|-------------------------|-----------|
| Default                 | 7 x 5     |
| HTML Slides             | 9.5 x 6.5 |
| HTML Slides (reveal.js) | 9 x 5     |
| PDF                     | 5.5 x 3.5 |
| PDF Slides (Beamer)     | 10 x 7    |
| PowerPoint              | 7.5 x 5.5 |
| MS Word, ODT, RTF       | 5 x 4     |
| EPUB                    | 5 x 4     |
| Hugo                    | 8 x 5     |

These defaults were chosen to provide attractive well proportioned figures, but feel free to experiment to see whether you prefer another default size. You can change the default sizes using the `fig-width` and `fig-height` options. For example:

``` yaml
---
title: "My Document"
format: 
  html:
    fig-width: 8
    fig-height: 6
  pdf:
    fig-width: 7
    fig-height: 5
---
```

How do these sizes make their way into the engine-level defaults for generating figures? This differs by engine:

-   For the Knitr engine, these values become the default values for the `fig.width` and `fig.height` chunk options. You can override these default values via chunk level options.

-   For Python, these values are used to set the [Matplotlib](https://matplotlib.org/stable/tutorials/introductory/customizing.html) `figure.figsize` rcParam (you can of course manually override these defaults for any given plot).

-   For Julia, these values are used to initialize the default figure size for the [Plots.jl](https://docs.juliaplots.org/stable/) GR backend.

    If you are using another graphics library with Jupyter and want to utilize these values, you can read them from `QUARTO_FIG_WIDTH` and `QUARTO_FIG_HEIGHT` environment variables.

::: callout-caution
When using the Jupyter engine, `fig-width` and `fig-height` are only supported if specified at the document- or project-level. 
However, when using the Knitr engine, these options are also supported as code cell options on a per-cell basis.
:::

### Caption and Alt Text

You can specify the caption and alt text for figures generated from code using the `fig-cap` and `fig-alt` options. For example, here we add these options to a Python code cell that creates a plot:

```{{python}}
#| fig-cap: "Polar axis plot"
#| fig-alt: "A line plot on a polar axis"

import numpy as np
import matplotlib.pyplot as plt

r = np.arange(0, 2, 0.01)
theta = 2 * np.pi * r
fig, ax = plt.subplots(subplot_kw={'projection': 'polar'})
ax.plot(theta, r)
ax.set_rticks([0.5, 1, 1.5, 2])
ax.grid(True)
plt.show()
```

## Inline Code

Jupyter, Knitr and OJS all support executing inline code within markdown (e.g. to allow narrative to automatically use the most up to date computations). See [Inline Code](inline-code.qmd) for details.

## Raw Output

The `output: asis` option enables you to generate raw markdown output. When `output: asis` is specified none of Quarto's standard enclosing divs will be included. For example, here we specify `output: asis` in order to generate a pair of headings:

::: panel-tabset
## Jupyter

```{{python}}
#| echo: false
#| output: asis

print("# Heading 1\n")
print("## Heading 2\n")
```

## Knitr

```{{r}}
#| echo: false
#| output: asis

cat("# Heading 1\n")
cat("## Heading 2\n")
```
:::

Which generates the following output:

``` default
# Heading 1

## Heading 2
```

Note that we also include the `echo: false` option to ensure that the code used to generate markdown isn't included in the final output.

If we had not specified `output: asis` the output, as seen in the intermediate markdown, would have included Quarto's `.cell-output` div:

```` default
::: {.cell-output-stdout}
```
# Heading 1

## Heading 2
  
```
:::
````

For the Jupyter engine, you can also create raw markdown output using the functions in `IPython.display`. For example:

```{{python}}
#| echo: false
radius = 10
from IPython.display import Markdown
Markdown(f"The _radius_ of the circle is **{radius}**.")
```

{{< include _knitr-options.md >}}

## Jupyter Options

### Expression Printing

When multiple expressions are present in a code cell, by default, only the last top-level expression is captured in the rendered output. For example, consider the code cell:

::: {layout-ncol="2"}
```` markdown
```{{python}}
"first"
"last"
```
````
:::

When rendered to HTML the output generated is:

``` markdown
'last'
```

This behavior corresponds to the `last_expr` setting for [Jupyter shell interactivity](https://ipython.readthedocs.io/en/stable/config/options/terminal.html#configtrait-InteractiveShell.ast_node_interactivity).

You can control this behavior with the `ipynb-shell-interactivity` option. For example, to capture all top-level expressions set it to `all`:

``` yaml
---
title: All expressions
format: html
ipynb-shell-interactivity: all
---
```

Now the above code cell results in the output:

``` markdown
'first'

'last'
```

::: callout-note
## All Expressions are Printed in Dashboards

For [dashboards](/docs/dashboards/index.qmd) the default setting of `ipynb-shell-interactivity` is `all.`
:::

## Intermediates

On the way from markdown input to final output, there are some intermediate files that are created and automatically deleted at the end of rendering. You can use the following options to keep these intermediate files:

+--------------+------------------------------------------------------------------------------------------------+
| Option       | Description                                                                                    |
+==============+================================================================================================+
| `keep-md`    | Keep the markdown file generated by executing code.                                            |
+--------------+------------------------------------------------------------------------------------------------+
| `keep-ipynb` | Keep the notebook file generated from executing code (applicable only to markdown input files) |
+--------------+------------------------------------------------------------------------------------------------+

For example, here we specify that we want to keep the jupyter intermediate file after rendering:

``` yaml
---
title: "My Document"
execute:
  keep-ipynb: true
jupyter: python3
---
```

## Fenced Echo

If you are writing a tutorial or documentation on using Quarto code blocks, you'll likely want to include the fenced code delimiter (e.g. ```` ```{python} ````) in your code output to emphasize that executable code requires that delimiter. You can do this using the `echo: fenced` option. For example, the following code block:

```{{python}}
#| echo: fenced
1 + 1
```

Will be rendered as:

```{python}
#| echo: fenced
1 + 1
```

This is especially useful when you want to demonstrate the use of cell options. For example, here we demonstrate the use of the `output` and `code-overflow` options:

```{{python}}
#| echo: fenced
#| output: false
#| code-overflow: wrap
1 + 1
```

This code block appears in the rendered document as:

```{python}
#| echo: fenced
#| output: false
#| code-overflow: wrap
1 + 1
```

Note that all YAML options will be included in the fenced code output *except for* `echo: fenced` (as that might be confusing to readers).

This behavior can also be specified at the document level if you want all of your executable code blocks to include the fenced delimiter and YAML options:

``` yaml
---
title: "My Document"
format: html
execute:
  echo: fenced
---
```

#### Unexecuted Blocks

{{< include _unexecuted-blocks.md >}}

## Engine Binding

Earlier we said that the engine used for computations was determined automatically. You may want to customize this---for example you may want to use the Jupyter [R kernel](https://github.com/IRkernel/IRkernel) rather than Knitr, or you may want to use Knitr with Python code (via [reticulate](https://rstudio.github.io/reticulate/)).

Here are the basic rules for automatic binding:

+-----------+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| Extension | Engine Binding                                                                                                                                                                                                                         |
+===========+========================================================================================================================================================================================================================================+
| .qmd      | Use Knitr engine if an `{r}` code block is discovered within the file                                                                                                                                                                  |
|           |                                                                                                                                                                                                                                        |
|           | Use Jupyter engine if *any other* executable code block (e.g. `{python}`, `{julia}`, `{bash}`, etc.) is discovered within the file. The kernel used is determined based on the language of the first executable code block discovered. |
|           |                                                                                                                                                                                                                                        |
|           | Use no engine if no executable code blocks are discovered.                                                                                                                                                                             |
+-----------+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| .ipynb    | Jupyter engine                                                                                                                                                                                                                         |
+-----------+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| .Rmd      | Knitr engine                                                                                                                                                                                                                           |
+-----------+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
| .md       | No engine (note that if an `md` document does contain executable code blocks then an error will occur)                                                                                                                                 |
+-----------+----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+

::: callout-note

## Using python and r together

If your quarto document includes both `{python}` and `{r}` code blocks, then quarto will automatically use Knitr engine and [reticulate](https://rstudio.github.io/reticulate/) R package to execute the python content.
:::

For `.qmd` files in particular, you can override the engine used via the `engine` option. For example:

``` markdown
engine: jupyter
```

``` markdown
engine: knitr
```

You can also specify that no execution engine should be used via `engine: markdown`.

The presence of the `knitr` or `jupyter` option will also override the default engine:

``` markdown
knitr: true
```

``` markdown
jupyter: python3
```

Variations with additional engine-specific options also work to override the default engine:

``` markdown
knitr:
  opts_knit:
    verbose: true
```

``` markdown
jupyter:
  kernelspec:
    display_name: Python 3
    language: python
    name: python3
```

## Shell Commands

Using shell commands (from Bash, Zsh, etc.) within Quarto computational documents differs by engine. If you are using the Jupyter engine you can use [Jupyter shell magics](https://jakevdp.github.io/PythonDataScienceHandbook/01.05-ipython-and-shell-commands.html). For example:

```` markdown
---
title: "Using Bash"
engine: jupyter
---

```{{python}}
!echo "foo"
```
````

Note that `!` preceding `echo` is what enables a Python cell to be able to execute a shell command.

If you are using the Knitr engine you can use ```` ```{bash} ```` cells, for example:

```` markdown
---
title: "Using Bash"
engine: knitr
---

```{{bash}}
echo "foo" 
```
````

Note that the Knitr engine also supports ```` ```{python} ```` cells, enabling the combination of R, Python, and Bash in the same document
```````

## File: docs/computations/inline-code.qmd
```````
---
title: "Inline Code"
format: html
aliases: 
  - /docs/prerelease/1.4/inline.html
---

## Overview

Inline code allows you to execute code within markdown, e.g. to automatically use the most up-to-date computations in narrative. Quarto provides an inline code syntax that works across all three engines (Jupyter, Knitr and OJS).

The syntax for inline code is similar to code blocks, except you use a single tick (`` ` ``) rather than triple ticks (```` ``` ````), and you can use it in the middle of markdown. For example, the following code stores the variable `radius` in a code block and then accesses it in a sentence using inline code:

::: {.panel-tabset group="engine"}
## Jupyter

```` markdown
```{{python}}
radius = 5
```

The radius of the circle is `{python} radius`
````

This syntax works for any Jupyter kernel---so for Julia you would write an inline expression as `` `{julia} radius` ``).

## Knitr

```` markdown
```{{r}}
radius <- 5
```

The radius of the circle is `{r} radius`
````

## OJS

```` markdown
```{{ojs}}
radius = 5
```

The radius of the circle is `{ojs} radius`
````
:::

The result of the code is this markdown output:

``` markdown
The radius of the circle is 5.
```

::: callout-caution

## Keep Inline Code Simple

Inline expressions should be confined to simple values that you have pre-computed within normal code cells (rather than function calls that do non-trivial work). This is because the protocol used for inline expressions is not compatible with some Python libraries (especially those that use multi-threading or multi-processing).
:::

Quarto also supports the native syntaxes of Knitr and OJS. Read more below in [Syntax Compatibility].

::: {.callout-important}

## Inline Code Cannot be Used in YAML

Inline expressions are not generally supported inside YAML strings, e.g. you cannot use inline code to generate  the `title` document option, or a `fig-cap` code cell option.

If you need to generate a dynamic caption, instead of using the `fig-cap` or `tbl-cap` code cell option, combine inline code with the [Cross-Reference Div Syntax](/docs/authoring/cross-references-divs.qmd#computed-captions).

:::

## Usage in Notebooks

Inline expressions are always evaluated when rendering and previewing `.qmd` files. However, for notebooks you need to execute the notebook with Quarto to evaluate inline expressions (i.e. they won't be evaluated within the JupyterLab, VS Code, or PyCharm notebook editor).

You can work in your favorite notebook front-end without Quarto execution, then once you are ready to publish execute the notebook during rendering as follows:

``` {.bash filename="Terminal"}
$ quarto render notebook.ipynb --execute
```

You can also turn on execution within the YAML options of a notebook. For example:

``` yaml
---
title: "My Notebooks"
execute:
  enabled: true
---
```

## Markdown Output

By default, the output of inline expressions is treated as ordinary text (i.e. markdown within it is not rendered). Any markdown-like syntax within the output of inline expressions will be automatically escaped. For example, the following inline expression:

``` markdown
 `{python} '**not bold**'` 
```

Will produce the following markdown:

``` markdown
\*\*not bold\*\*
```

To explicitly create markdown output, you'll need to use a function specific to your engine:

::: {.panel-tabset group="engine"}
### Jupyter

Use the `Markdown()` function from `IPython.display`:

```` markdown
```{{python}}
from IPython.display import Markdown
```

This is `{python} Markdown('**bold**')`
````

### Knitr

Use the `I()` function:

``` markdown
This is `{r} I("**bold**")`
```

### OJS

Use the `md` function:

```` markdown
```{{ojs}}
text = md`This is **bold**`
```

`{ojs} text`
````
:::

## Escaping

If you are writing documentation about inline expressions (as we are in this article!) then you may need to escape the syntax so that it doesn't execute. You can do that in one of two ways:

1)  Use a double-brace around the expression. For example: `` `{{{python}}} x` ``

2)  Enclose the expression in an extra backtick. For example: ``` ``{python} x`` ```

Each of the expressions above will render (unevaluated) as `` `{{python}} x` `` within the output document.

## Engine Binding

If you use inline expressions in a document that does not have any executable code blocks then you should explicitly set the `engine` document option to ensure that your expressions are evaluated (automatic engine binding works for blocks but not inlines). For example:

``` markdown
---
title: "My Document"
engine: jupyter
---

`{python} "hello"`
```

## Syntax Compatibility

To make it easier to learn and use expressions across engines, Quarto provides a single syntax that works for all engines. However, you can also use the native syntaxes of Knitr and Observable.

### Knitr

The native Knitr syntax also uses single backticks (`` ` ``) but doesn't enclose `r` in curly braces. For example:

``` markdown
The radius of the circle is `r radius`.
```

The native Knitr inline syntax has a different default behavior for handling [Markdown Output]. Specifically, it treats all inline output as *containing markdown*. This means the above example is equivalent to:

```markdown
The radius of the circle is `{r} I(radius)`.
```

### OJS

Natively, OJS uses the syntax `${expr}`. For example:

``` markdown
The radius of the circle is ${radius}
```
```````

## File: docs/computations/julia.qmd
```````
---
title: "Using Julia"
jupyter-language: "Julia"
jupyter-screenshot: "![](images/julia-jupyter.png){.border fig-alt='Side-by-side preview of notebook on the left and live preview in the browser on the right.'}"
vscode-extension: "[Julia Extension](https://www.julia-vscode.org/docs)"
vscode-screenshot: "![](images/julia-vscode){.border fig-alt='Screen shot of VS Code with quarto document containing Julia code on the left, the output of a plot from the Julia code on the right, and the Quarto Help pane at the bottom.'}"
---

# Overview

Quarto supports executable Julia code blocks within markdown. This allows you to create fully reproducible documents and reports---the Julia code required to produce your output is part of the document itself, and is automatically re-run whenever the document is rendered.

Quarto has two available engines for executing Julia code, the newer [`julia` engine](#using-the-julia-engine) is using the [QuartoNotebookRunner.jl](https://github.com/PumasAI/QuartoNotebookRunner.jl/) package to render notebooks, the older [`jupyter` engine](#using-the-jupyter-engine) is using the [IJulia](https://github.com/JuliaLang/IJulia.jl) Jupyter kernel.

This table lists some of the reasons why the `julia` engine was created:

|                                                                                                                                 | julia Engine | jupyter Engine |
|---------------------------------------------------------------------------------------------------------------------------------|--------------|----------------|
| Execute Julia code blocks                                                                                                       | ✅           | ✅              |
| Keep sessions alive for fast reruns                                                                                             | ✅           | ✅              |
| No Python installation required                                                                                                 | ✅           | ❌              |
| No global package installation needed                                                                                           | ✅           | ❌              |
| Automatic integration with juliaup (no kernel installation)                                                                     | ✅           | ❌              |
| Python & R Codeblocks (via PythonCall.jl and RCall.jl)                                                                          | ✅           | ❌              |
| "Expandable cells" or programmatic document generation (via [QuartoTools.jl](https://pumasai.github.io/QuartoTools.jl/stable/)) | ✅           | ❌              |

::: {.callout-note}
For most users, the `julia` engine should offer the best experience.
However, for backwards compatibility the `jupyter` engine remains the default engine for Julia code.
The `julia` engine has to be [specifically enabled either in the frontmatter or the project file](#enabling-the-julia-engine).
:::

Using either of the two engines will require manually installing Julia if
you have not done so already. Installation via `juliaup` is recommended, for further
information check the [official Julia website](https://julialang.org/install/).

Now, we will cover the basics of creating and rendering documents with Julia code blocks.

### Code Blocks

Code blocks that use braces around the language name (e.g. ```` ```{julia} ````) are executable, and will be run by Quarto during render. Here is a simple example:

```` markdown
---
title: "Plots Demo"
author: "Norah Jones"
date: "5/22/2021"
format:
  html:
    code-fold: true
engine: julia
---

### Parametric Plots

Plot function pair (x(u), y(u)). 
See @fig-parametric for an example.

```{{julia}}
#| label: fig-parametric
#| fig-cap: "Parametric Plots"

using Plots

plot(sin, 
     x->sin(2x), 
     0, 
     2π, 
     leg=false, 
     fill=(0,:lavender))
```
````

You'll note that there are some special comments at the top of the code block. These are cell level options that make the figure [cross-referenceable](/docs/authoring/cross-references.qmd).

This document would result in the following rendered output:

![](/images/hello-julia.png){.border fig-alt="Example Plots Demo output with title, author, date published and main section on Parametric plots which contains text, a toggleable code field, and the output of the plot, with the caption Figure 1 Parametric Plots."}

You can produce a wide variety of output types from executable code blocks, including plots, tabular output from data frames, and plain text output (e.g. printing the results of statistical summaries).

There are many options which control the behavior of code execution and output, you can read more about them in the article on [Execution Options](execution-options.qmd).

In addition to code blocks which interrupt the flow of Markdown, you can also include code inline. Read more about inline code in the [Inline Code](inline-code.qmd) article.

#### Multiple Outputs

By default Julia cells will automatically print the value of their last statement (as with the example above where the call to `plot()` resulted in plot output). If you want to display multiple plots (or other types of output) from a single cell you should call the `display()` function explicitly. For example, here we output two plots side-by-side with sub-captions:

```{{julia}}
#| label: fig-plots
#| fig-cap: "Multiple Plots"
#| fig-subcap:
#|   - "Plot 1"
#|   - "Plot 2"
#| layout-ncol: 2

using Plots
display(plot(sin, x -> sin(2x), 0, 2))
display(plot(x -> sin(4x), y -> sin(5y), 0, 2))
```

{{< include _jupyter-rendering.md >}}

{{< include _jupyter-authoring-tools.md >}}

# Using the `julia` engine

{{< include /docs/prerelease/1.5/_pre-release-feature.qmd >}}

## Installation {#installation-julia-engine}

The `julia` engine uses the [QuartoNotebookRunner.jl](https://github.com/PumasAI/QuartoNotebookRunner.jl/) package to render notebooks. When you first attempt to render a notebook with the `julia` engine, Quarto will automatically install this package into a private environment that is owned by Quarto. This means you don't have to install anything in your global Julia environment for Quarto to work and Quarto will not interfere with any other Julia environments on your system. Quarto will use the `julia` binary on your PATH by default, but you can override this using the `QUARTO_JULIA` environment variable.

:::{.callout-note}

## Using custom versions of `QuartoNotebookRunner`

In special circumstances, you may not want to use the specific `QuartoNotebookRunner` version that Quarto installs for you. For example, you might be developing `QuartoNotebookRunner` itself, or you need to use a fork or an unreleased version with a bugfix. In this case, set the [environment variable](/docs/projects/environment.qmd) `QUARTO_JULIA_PROJECT` to a directory of a julia environment that has `QuartoNotebookRunner` installed. 

As an example, you could install the main branch of `QuartoNotebookRunner` into the directory `/some/dir` by executing `]activate /some/dir` in a julia REPL followed by `]add QuartoNotebookRunner#main`. As long as there is no server currently running, running a command like `QUARTO_JULIA_PROJECT=/some/dir quarto render some_notebook.qmd` in your terminal will ensure the server process is started using the custom `QuartoNotebookRunner`. You can also set `quarto`'s `--execute-debug` flag and check the output to verify that the custom environment is being used.
:::

## Enabling the `julia` engine

To use the `julia` engine, you have to specifically enable it. For that, you have two options.

Either specify the engine in your frontmatter:

```` markdown
---
title: "A julia engine notebook"
engine: julia
---

```{{julia}}
1 + 2
```
````

Or, starting with Quarto 1.7, you can prioritize the julia engine project-wide by adding `julia` to the `engines` array in your project file, giving it priority over all unlisted engines (more under [Engine prioritization](#engine-prioritization)). Note that the project file approach is the only option in order to use the `julia` engine with percent-script files.

```{.yaml filename="_quarto.yml"}
engines: ['julia']
```

## Rendering notebooks

Requesting the first render of a notebook which contains Julia code blocks and has the `julia` engine enabled will start a persistent server process that loads QuartoNotebookRunner.jl.
This package is installed automatically in an environment private to Quarto.

The server spins up a separate Julia worker process for each notebook you want to render.
Every purple node in the following graph represents a separate Julia process which runs independently from each short-lived `quarto` process that communicates with the server.

```{mermaid}
flowchart LR
    A[<b>quarto render ...</b>] <-.-> B[<b>Server Process</b><br/>QuartoNotebookRunner.jl]
    B <--> C[<b>Worker Process 1</b><br/>notebook_A.qmd]
    B <--> D[<b>Worker Process 2</b><br/>notebook_B.qmd]
    B <--> E[<b>Worker Process 3</b><br/>notebook_C.qmd]

    style A color:#333
    style B fill:#cb9be0,color:#333
    style C fill:#e7d0f2,color:#333
    style D fill:#e7d0f2,color:#333
    style E fill:#e7d0f2,color:#333
```

You can check the status of the server, request it to shut down, and more using the [`call julia engine` commands](#quarto-call-engine-julia-commands).
The server will stay alive for five minutes after the last worker process has exited, unless it's closed manually.
Changes to environment variables that influence the server process will only be picked up once the next new server process is started.

### Notebook environments

By default, QuartoNotebookRunner will use the `--project=@.` flag when starting a worker. This makes Julia search for an environment (a `Project.toml` or `JuliaProject.toml` file) starting in the directory where the quarto notebook is stored and walking up the directory tree from there.

For example, for a file `/some/dir/notebook.qmd` it will look at `/some/dir/[Julia]Project.toml`, `/some/[Julia]Project.toml` and so on. You could use this behavior to let all notebooks in a quarto project share the same Julia environment, by placing it at the project's top-level directory.

If no environment has previously been set up in any of these directories, the worker process will start with an empty environment. This means that only Julia's standard library packages will be available for use in the notebook.

::: {.callout-note}
Creating a separate environment for each notebook or each set of closely related notebooks is considered best practice.
If too many different notebooks share the same environment (for example the main shared environment that Julia usually loads by default), you're likely to break some of them unintentionally whenever you make a change to the environment.
:::

You can create a Julia environment in multiple ways, for more information have a look at the [official documentation](https://pkgdocs.julialang.org/v1/environments/). One simple option for adding packages to the default environment of a new quarto notebook is to add some `Pkg` installation commands to the notebook and run it once. Afterwards, those commands can be deleted and a `Project.toml` and `Manifest.toml` file representing the environment should be present in the notebook's directory.

````markdown
---
engine: julia
---

```{{julia}}
using Pkg
Pkg.add("DataFrames")
```
````

Another option is to start `julia` in a terminal which loads the REPL, and to press `]` to switch to the `Pkg` REPL mode.
In this mode, you can first activate the desired environment by running `activate /some/dir` and then, for example, install the `DataFrames` package with the command `add DataFrames`.

If you do not want to use the notebook's directory as the environment, you may specify a different directory via the `--project` flag in the `exeflags` frontmatter setting:

````markdown
---
engine: julia
julia:
  exeflags: ["--project=/some/other/dir"]
---
````

### Worker process reuse

An idle worker process will be kept alive for 5 minutes by default, this can be changed by passing the desired number of seconds to the `daemon` key:

````markdown
---
title: "A julia notebook with ten minutes timeout"
engine: julia
execute:
  daemon: 600
---
````

Each re-render of a notebook will reuse the worker process with all dependencies already loaded, which reduces latency.
As far as technically possible, QuartoNotebookRunner.jl will release resources from previous runs to the garbage collector.
In each run, the code is evaluated into a fresh module so you cannot run into conflicts with variables defined in previous runs.
Note, however, that certain state changes like modifications to package runtime settings or the removal or addition of function methods will persist across runs.
If necessary, you can use the `--execute-daemon-restart` flag to force a restart of a notebook's worker process.

You can also disable the daemon which will use a new process for each render (with higher latency due to package reloads):

```yaml
execute:
  daemon: false
```

The server process itself will time out after five minutes if no more worker processes exist.

## Engine options

Engine options can be passed under the `julia` top-level key:

````markdown
---
title: "A julia engine notebook"
engine: julia
julia:
  key: value
---
````

The currently available options are:

- `exeflags`: An array of strings which are appended to the `julia` command that starts the worker process. For example, a notebook is run with `--project=@.` by default (the environment in the directory where the notebook is stored) but this could be overridden by setting `exeflags: ["--project=/some/directory/"]`.
- `env`: An array of strings where each string specifies one environment variable that is passed to the worker process. For example, `env: ["SOMEVAR=SOMEVALUE"]`.

## `quarto call engine julia` commands

Starting with Quarto 1.7, The julia engine offers CLI commands for configuration and monitoring via the `quarto call engine julia` entrypoint.

### `status`

The `status` command prints out information about the currently running server process as well as potential worker processes. For example:

```
$ quarto call engine julia status
QuartoNotebookRunner server status:
  started at: 9:44:31 (47 seconds ago)
  runner version: 0.15.0
  environment: /Users/username/Library/Caches/quarto/julia/
  pid: 42008
  port: 8000
  julia version: 1.11.4
  timeout: 5 minutes
  workers active: 1
    worker 1:
      path: /Users/username/notebook.qmd
      run started: 9:44:38 (40 seconds ago)
      run finished: -
      timeout: 5 minutes
      pid: 42026
      exe: `julia`
      exeflags: ["--color=yes"]
      env: ["JULIA_PROJECT=@."]
```

### `close`

The `close` command allows shutting down notebook worker processes.
By default, only closing of idle worker processes is allowed.
A worker process is idle when its `run finished` status is populated. In this case, we can call `close` on it:

```
$ quarto call engine julia status
QuartoNotebookRunner server status:
  started at: 9:44:31 (5 minutes 41 seconds ago)
  runner version: 0.15.0
  environment: /Users/username/Library/Caches/quarto/julia/
  pid: 42008
  port: 8000
  julia version: 1.11.4
  timeout: 5 minutes
  workers active: 1
    worker 1:
      path: /Users/username/notebook.qmd
      run started: 9:44:38 (5 minutes 34 seconds ago)
      run finished: 9:46:21 (took 1 minute 43 seconds)
      timeout: 5 minutes (1 minute 9 seconds left)
      pid: 42026
      exe: `julia`
      exeflags: ["--color=yes"]
      env: ["JULIA_PROJECT=@."]

$ quarto call engine julia close /Users/username/notebook.qmd
Worker closed successfully.
```

To force a busy worker to close, for example if it's stuck in an endless loop or because a computation is taking too long, the `--force` flag can be added.
Using this flag means losing all the work that the worker process has done so far.
At the next run, the worker process will have to be started from scratch and all packages loaded again:

```
$ quarto call engine julia status                                                     
QuartoNotebookRunner server status:
  started at: 11:2:40 (16 seconds ago)
  runner version: 0.15.0
  environment: /Users/username/Library/Caches/quarto/julia/
  pid: 50642
  port: 8000
  julia version: 1.11.4
  timeout: 5 minutes
  workers active: 1
    worker 1:
      path: /Users/username/notebook.qmd
      run started: 11:2:47 (9 seconds ago)
      run finished: -
      timeout: 5 minutes
      pid: 50650
      exe: `julia`
      exeflags: ["--color=yes"]
      env: ["JULIA_PROJECT=@."]

$ quarto call engine julia close /Users/username/notebook.qmd
ERROR: Julia server returned error after receiving "close" command:

Failed to close notebook: /Users/username/notebook.qmd

The underlying Julia error was:

Tried to close file "/Users/username/notebook.qmd" but the corresponding worker is busy.

Stack trace:
  [omitted for brevity]

$ quarto call engine julia close --force /Users/username/notebook.qmd
Worker force-closed successfully.

$ quarto call engine julia status                                                     
QuartoNotebookRunner server status:
  started at: 11:2:40 (46 seconds ago)
  runner version: 0.15.0
  environment: /Users/username/Library/Caches/quarto/julia/
  pid: 50642
  port: 8000
  julia version: 1.11.4
  timeout: 5 minutes (4 minutes 56 seconds left)
  workers active: 0
```

### `stop`

The `stop` command shuts down the server process gracefully. Note that you will get an error if any workers are currently busy:

```
$ quarto call engine julia status
QuartoNotebookRunner server status:
  started at: 11:2:40 (3 minutes 43 seconds ago)
  runner version: 0.15.0
  environment: /Users/username/Library/Caches/quarto/julia/
  pid: 50642
  port: 8000
  julia version: 1.11.4
  timeout: 5 minutes (1 minute 59 seconds left)
  workers active: 0

$ quarto call engine julia stop 
Server stopped.

$ quarto call engine julia status
Julia control server is not running.
```

### `kill`

The `kill` command shuts the server process down forcefully. This command is intended as a last resort when the server is in a bad state and unresponsive. Note that all worker processes will be killed as well, so you will lose all progress.

### `log`

The `log` command prints the output of the internal log file of the server process. If the server process fails to start or unexpectedly quits, this log file might contain useful information.

## `juliaup` integration

[`juliaup`](https://github.com/JuliaLang/juliaup) is the recommended way to
install and manage Julia versions. The `julia` engine supports using
`juliaup`'s `+` channel specifier to select the Julia version that a notebook
uses. This allow users to run several notebooks concurrently with different
Julia versions on the same machine without the need for customizing their
`PATH` in any way.

To use this feature, ensure that you have used `juliaup` to install the channels
that you wish to use in your notebooks. Then add the channel specifier to the notebook
frontmatter in the `julia.exeflags` option:

````markdown
---
title: "A Julia 1.11 notebook"
engine: julia
julia:
  exeflags: ["+1.11"]
---

```{{julia}}
VERSION
```
````

`QuartoNotebookRunner` currently supports running Julia versions from 1.6
onwards. Support for earlier versions is not planned.

## Revise.jl integration

[Revise](https://github.com/timholy/Revise.jl) allows for automatically
updating function definitions in Julia sessions. It is an essential tool in the
Julia ecosystem for any user that wishes to develop their own packages or large
projects. The `julia` engine supports using `Revise` within notebook processes
by simply importing the package into a cell at the start of a notebook. Once
imported `Revise` will automatically update functions imported from locally
developed packages in the same way as it behaves in a Julia REPL.

Ensure that `Revise` is installed in the project environment that the notebook
is using, since the global environment is not included in the load path
provided to Julia, unlike the behaviour of a Julia REPL session.

## Caching {#caching-julia}

The engine has built-in support for caching notebook results. This feature is disabled by
default but can be enabled by setting the `execute.cache` option to `true` in a notebook's
frontmatter:

````markdown
---
title: "A caching example"
engine: julia
execute:
  cache: true
---

```{{julia}}
rand()
```
````

Notebook caches are invalidated based on the following criteria:

- Using a different Julia version to run the notebook.
- Changes to the `Manifest.toml` of the environment the notebook is run in. Adding, removing, or changing package versions will invalidate the cache.
- Changing any contents in the notebook's frontmatter.
- Changing any contents of any executable Julia cells, including cell options.

Changes that do not invalidate a cache:

- Editing Markdown content outside of executable Julia cells.

Caches are saved to file in a `.cache` directory alongside the notebook file.
This directory is safe to remove if you want to invalidate all caches. The
contents of the individual cache files is an internal implementation detail and
should not be relied upon.

These caches are safe to save in CI via such tools as GitHub Actions
`action/cache` to help improve the render time of long-running notebooks that
do not often change.

## R and Python support

`{{r}}` and `{{python}}` executable code blocks are supported in the `julia`
engine via integrations with the
[RCall](https://github.com/JuliaInterop/RCall.jl) and
[PythonCall](https://github.com/JuliaPy/PythonCall.jl) packages respectively.
Using this feature requires the notebook author to explicitly `import` those
packages into their notebooks in a `{{julia}}` cell afterwhich they can use
`{{r}}` and `{{python}}` cells.

````markdown
---
title: "Multi-language notebooks"
engine: julia
---

```{{julia}}
import PythonCall
import RCall
```

Create some data in Julia:

```{{julia}}
data = sin.(0:0.1:4pi)
```

Then plot it in R by interpolating the `data` variable from Julia into `R` via
the `$` syntax:

```{{r}}
plot($data)
```

The same `$` syntax can be used to interpolate Julia variables into Python code as well:

```{{python}}
len($data)
```
````

## Engine "extensions"

The implementation of `QuartoNotebookRunner` allows for extending the behaviour
of notebooks via external Julia packages.

One example of this is the
[QuartoTools.jl](https://pumasai.github.io/QuartoTools.jl) package, which
enables fine-grained function call caching, support for serializing data
between notebook processes and normal `julia` processes, and "expandable" cell
outputs that allow for programatic creating of cell inputs and outputs within
notebooks. See the linked documentation for more thorough discussion of that
package's features.

The same approach used by that package can be applied to other third-party
packages that wish to extend the functionality of notebooks in other ways.
Please direct questions and requests regarding this functionality to the
[QuartoNotebookRunner](https://github.com/PumasAI/QuartoNotebookRunner.jl)
repository.

# Using the `jupyter` engine

### Installation {#installation}

In order to render documents with embedded Julia code you'll need to install the following components:

1)  IJulia
2)  Revise.jl
3)  Optionally, Jupyter Cache

We'll cover each of these in turn below.

#### IJulia {#ijulia}

[IJulia](https://julialang.github.io/IJulia.jl/stable) is a Julia-language execution kernel for Jupyter. You can install IJulia from within the Julia REPL as follows:

``` julia
using Pkg
Pkg.add("IJulia")
using IJulia
notebook()
```

The first time you run `notebook()`, it will prompt you for whether it should install Jupyter. Hit enter to have it use the [Conda.jl](https://github.com/Luthaf/Conda.jl) package to install a minimal Python+Jupyter distribution (via [Miniconda](https://docs.conda.io/projects/conda/en/stable/user-guide/install/index.html)) that is private to Julia (not in your `PATH`). On Linux, it defaults to looking for `jupyter` in your `PATH` first, and only asks to installs the Conda Jupyter if that fails.

If you choose not to use Conda.jl to install Python and Jupyter you will need to make sure that you have another installation of it on your system (see the section on [Installing Jupyter](#installing-jupyter) if you need help with this).

#### Revise.jl

In addition to IJulia, you'll want to install [Revise.jl](https://timholy.github.io/Revise.jl/stable) and configure it for use with IJulia. Revise.jl is a library that helps you keep your Julia sessions running longer, reducing the need to restart when you make changes to code.

Quarto maintains a persistent [kernel daemon](#kernel-daemon) for each document to mitigate Jupyter start up time during iterative work. Revise.jl will make this persistent process robust in the face of package updates, git branch checkouts, etc. Install Revise.jl with:

``` julia
using Pkg
Pkg.add("Revise")
```

To configure Revise to launch automatically within IJulia, create a `.julia/config/startup_ijulia.jl` file with the contents:

``` julia
try
  @eval using Revise
catch e
  @warn "Revise init" exception=(e, catch_backtrace())
end
```

You can learn more about Revise.jl at <https://timholy.github.io/Revise.jl/stable>.

#### Jupyter Cache

[Jupyter Cache](https://jupyter-cache.readthedocs.io/en/latest/) enables you to cache all of the cell outputs for a notebook. If any of the cells in the notebook change then all of the cells will be re-executed.

If you are using the integrated version of Jupyter installed by `IJulia.notebook()`, then you will need to add `jupyter-cache` to the Python environment managed by IJulia. You can do that as follows:

``` julia
using Conda
Conda.add("jupyter-cache")
```

Alternatively, if you are using Jupyter from within any other version of Python not managed by IJulia, see the instructions below on [Installing Jupyter](#installing-jupyter) for details on installing `jupyter cache`,

{{< include _jupyter-cache.md >}}

{{< include _caching-more.md >}}

### Kernel Selection

You'll note in our first example that we specified the use of the `julia-1.8` kernel explicitly in our document options (shortened for brevity):

``` markdown
---
title: "StatsPlots Demo"
jupyter: julia-1.8
---
```

If no `jupyter` kernel is explicitly specified, then Quarto will attempt to automatically discover a kernel on the system that supports Julia.

You can discover the available Jupyter kernels on your system using the `quarto check` command:

``` {.bash filename="Terminal"}
quarto check jupyter
```

{{< include _jupyter-daemon.md >}}


### Installing Jupyter {#installing-jupyter}

You can rely on the minimal version of Python and Jupyter that is installed automatically by **IJulia**, or you can choose to install Python and Jupyter separately. If you need to install another version of Jupyter this section describes how.

{{< include _jupyter-install.md >}}

#### Jupyter Cache

[Jupyter Cache](https://jupyter-cache.readthedocs.io/en/latest/) enables you to cache all of the cell outputs for a notebook. If any of the cells in the notebook change then all of the cells will be re-executed.

To use Jupyter Cache you'll want to first install the `jupyter-cache` package:

+-----------+--------------------------------------+
| Platform  | Command                              |
+===========+======================================+
| Mac/Linux | ```{.bash filename="Terminal"}       |
|           | python3 -m pip install jupyter-cache |
|           | ```                                  |
+-----------+--------------------------------------+
| Windows   | ```{.powershell filename="Terminal"} |
|           | py -m pip install jupyter-cache      |
|           | ```                                  |
+-----------+--------------------------------------+
| Conda     | ```{.bash filename="Terminal"}       |
|           | conda install jupyter-cache          |
|           | ```                                  |
+-----------+--------------------------------------+

To enable the cache for a document, add the `cache` option. For example:
```````

## File: docs/computations/ojs.qmd
```````
---
title: "Using Observable"
execute:
  echo: false
search: false
---

## Overview

Quarto includes native support for [Observable JS](https://observablehq.com/@observablehq/observables-not-javascript), a set of enhancements to vanilla JavaScript created by [Mike Bostock](https://en.wikipedia.org/wiki/Mike_Bostock) (also the author of [D3](https://d3js.org/)). Observable JS is distinguished by its [reactive runtime](https://github.com/observablehq/runtime), which is especially well suited for interactive data exploration and analysis.

The creators of Observable JS (Observable, Inc.) run a hosted service at <https://observablehq.com/> where you can create and publish notebooks. Additionally, you can use Observable JS ("OJS") in standalone documents and websites via its [core libraries](https://github.com/observablehq). Quarto uses these libraries along with a [compiler](https://github.com/asg017/unofficial-observablehq-compiler/tree/beta) that is run at render time to enable the use of OJS within Quarto documents.

OJS works in any Quarto document (plain markdown as well as Jupyter and Knitr documents). Just include your code in an `{ojs}` executable code block. The rest of this article explains the basics of using OJS with Quarto.

## Example

We'll start with a simple example based on Allison Horst's [Palmer Penguins](https://allisonhorst.github.io/palmerpenguins/) dataset. Here we look at how penguin body mass varies across both sex and species (use the provided inputs to filter the dataset by bill length and island):

```{ojs}
data = FileAttachment("palmer-penguins.csv").csv({ typed: true })
```

```{ojs}
filtered = data.filter(function(penguin) {
  return bill_length_min < penguin.bill_length_mm &&
         islands.includes(penguin.island);
})
```

```{ojs}
viewof bill_length_min = Inputs.range(
  [32, 50], 
  {value: 35, step: 1, label: "Bill length (min):"}
)
viewof islands = Inputs.checkbox(
  ["Torgersen", "Biscoe", "Dream"], 
  { value: ["Torgersen", "Biscoe"], 
    label: "Islands:"
  }
)
```

```{ojs}
Plot.rectY(filtered, 
  Plot.binX(
    {y: "count"}, 
    {x: "body_mass_g", fill: "species", thresholds: 20}
  ))
  .plot({
    facet: {
      data: filtered,
      x: "sex",
      y: "species",
      marginRight: 80
    },
    marks: [
      Plot.frame(),
    ]
  }
)
```

Let's take a look at the source code for this example. First we create an `{ojs}` cell that reads in some data from a CSV file (*e.g.*, [`palmer-penguins.csv`](palmer-penguins.csv){target="_blank" download="palmer-penguins.csv"}) using a [FileAttachment](https://observablehq.com/@observablehq/file-attachments):

```{{ojs}}
data = FileAttachment("palmer-penguins.csv").csv({ typed: true })
```

The example above doesn't plot all of the data but rather a filtered subset. To create our filter we'll need some inputs, and we'll want to be able to use the values of these inputs in our filtering function. To do this, we use the `viewof` keyword and with some standard [Inputs](https://observablehq.com/@observablehq/inputs):

```{{ojs}}
viewof bill_length_min = Inputs.range(
  [32, 50], 
  {value: 35, step: 1, label: "Bill length (min):"}
)
viewof islands = Inputs.checkbox(
  ["Torgersen", "Biscoe", "Dream"], 
  { value: ["Torgersen", "Biscoe"], 
    label: "Islands:"
  }
)
```

Now we write the filtering function that will transform the `data` read from the CSV using the values of `bill_length_min` and `island`.

```{{ojs}}
filtered = data.filter(function(penguin) {
  return bill_length_min < penguin.bill_length_mm &&
         islands.includes(penguin.island);
})
```

Here we see reactivity in action: we don't need any special syntax to refer to the dynamic input values, they "just work", and the filtering code is automatically re-run when the inputs change. This works in much the same way a spreadsheet works when you update a cell and other cells that refer to it are recalculated.

Finally, we'll plot the filtered data using [Observable Plot](https://observablehq.com/@observablehq/plot) (an open-source JavaScript library for quick visualization of tabular data):

```{{ojs}}
Plot.rectY(filtered, 
  Plot.binX(
    {y: "count"}, 
    {x: "body_mass_g", fill: "species", thresholds: 20}
  ))
  .plot({
    facet: {
      data: filtered,
      x: "sex",
      y: "species",
      marginRight: 80
    },
    marks: [
      Plot.frame(),
    ]
  }
)
```

Note that as with our inputs, we refer to the `filtered` variable with no special syntax---the plotting code will be automatically re-run whenever `filtered` changes (which in turn is updated whenever an input changes).

That covers a basic end-to-end use of OJS (see the [Penguins](/docs/interactive/ojs/examples/penguins.qmd) examples for the full source code).

::: {.callout-tip appearance="simple"}
If you take a look at the [Penguins](/docs/interactive/ojs/examples/penguins.qmd) code, you'll notice something curious: the inputs and plotting code are defined *before* the data processing code. This demonstrates a critical difference between OJS cell execution and traditional notebooks: cells do not need to be defined in any particular order.

Because execution is fully reactive, the runtime will automatically execute cells in the correct order based on how they reference each other. This is more akin to a spreadsheet than a traditional notebook with linear cell execution.
:::

## Libraries

Our example above made use of several standard libraries, including:

1.  [Observable stdlib](https://github.com/observablehq/stdlib) --- Core primitives for DOM manipulation, file handling, importing code, and much more.

2.  [Observable Inputs](https://github.com/observablehq/inputs) --- Standard inputs controls including sliders, drop-downs, tables, check-boxes, etc.

3.  [Observable Plot](https://github.com/observablehq/plot) --- High level plotting library for exploratory data visualization.

The libraries are somewhat special because they are automatically available within notebooks on <https://observablehq.com> as well as within `{ojs}` cells in Quarto documents.

Using other JavaScript libraries is also straightforward, they just need to be explicitly imported. For example, here we import a some libraries using the [require](https://github.com/observablehq/stdlib#require) function (which in turn loads NPM modules from [jsDelivr](https://www.jsdelivr.com/){.uri}):

```{{ojs}}
d3 = require("d3@7")
topojson = require("topojson")
```

See the article on [Libraries](/docs/interactive/ojs/libraries.qmd) to learn more about using standard and third-party libraries.

## Data Sources

In our initial example we used a [FileAttachment](https://github.com/observablehq/stdlib#file-attachments) as our data source. File attachments support many formats including CSV, TSV, JSON, Arrow (uncompressed), and SQLite so are a convenient way to read a dataset that has already been prepared for analysis.

Frequently, you'll need pre-process your data in Python or R before it's ready for visualization. Using Quarto, you can do this pre-processing during document render, and then make the results available to OJS.

Use the `ojs_define()` function from Python or R to define variables that you want to use within JavaScript. For example, to reproduce the simple CSV read in Python you might do this:

```{{python}}
import pandas as pd
penguins = pd.read_csv("palmer-penguins.csv")
ojs_define(data = penguins)
```

The call to `ojs_define(data = penguins)` says that we want to make a variable named `data` (with the value of the `penguins` data frame) available to OJS

Depending on the visualization library you use, one additional step may be required to consume the data from JavaScript. In this case, the `Plot` function expects data by row rather than by column, so we `transpose()` it before filtering:

```{{ojs}}
filtered = transpose(data).filter(function(penguin) {
  return bill_length_min < penguin.bill_length_mm &&
         islands.includes(penguin.island);
})
```

See the article on [Data Sources](/docs/interactive/ojs/data-sources.qmd) to learn more about the various ways to prepare and read data.

## OJS Cells

There are many options available to customize the behavior of `{ojs}` code cells, including showing, hiding, and collapsing code as well as controlling the visibility and layout of outputs.

The most important cell option to be aware of is the `echo` option, which controls whether source code is displayed. You'll have different preferences depending on whether you are embedding visualizations in an article or creating a notebook or full-on tutorial.

Code in `{ojs}` cells is displayed by default. To prevent display of code for an entire document, set the `echo: false` option in YAML metadata:

``` yaml
---
title: "My Document"
execute:
  echo: false
---
```

You can also specify this option on a per-cell basis. For example:

```{{ojs}}
//| echo: false
data = FileAttachment("palmer-penguins.csv").csv({ typed: true })
```

To learn about all of the options available, see the article on [OJS Cells](/docs/interactive/ojs/ojs-cells.qmd).

In addition to OJS cells which interupt the flow of markdown, you can also include code inline. Read more about inline code in the [Inline Code](inline-code.qmd) article.

## Learning More

These articles go into more depth on using OJS in Quarto documents:

-   [Libraries](/docs/interactive/ojs/libraries.qmd) covers using standard libraries and external JavaScript libraries.

-   [Data Sources](/docs/interactive/ojs/data-sources.qmd) outlines the various ways to read and pre-process data.

-   [OJS Cells](/docs/interactive/ojs/ojs-cells.qmd) goes into more depth on cell execution, output, and layout.

-   [Shiny Reactives](/docs/interactive/ojs/shiny.qmd) describes how to integrate Shiny with OJS.

-   [Code Reuse](/docs/interactive/ojs/code-reuse.qmd) delves into ways to re-use OJS code across multiple documents.

If you want to learn more about the underlying mechanics of reactivity, check out these notebooks from [Mike Bostock](https://observablehq.com/@mbostock):

-   [Five Minute Introduction](https://observablehq.com/@observablehq/five-minute-introduction)

-   [Observable's not JavaScript](https://observablehq.com/@observablehq/observables-not-javascript)

-   [Introduction to Views](https://observablehq.com/@observablehq/introduction-to-views)


-   [How Observable Runs](https://observablehq.com/@observablehq/how-observable-runs)
```````

## File: docs/computations/parameters.qmd
```````
---
title: "Parameters"
document: "document"
---

{{< include _parameters.md >}}
```````

## File: docs/computations/python.qmd
```````
---
title: "Using Python"
jupyter-language: "Python"
jupyter-screenshot: "![](/docs/get-started/hello/images/jupyter-basics.png){.border fig-alt='A Jupyter notebook titled Quarto Basics containing some text, a code cell, and the result of the code cell, which is a line plot on a polar axis.'}"
vscode-extension: "[Python Extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)"
vscode-screenshot: "![](images/python-vscode){.border fig-alt='Screen shot of VS Code editor with three vertical sections. The leftmost includes the file explorer, and quarto help. The second pane is the source code for a quarto file with python code. The third is interactive with Python running and output of the code cells shown.'}"
---

## Overview

Quarto supports executable Python code blocks within markdown. This allows you to create fully reproducible documents and reports---the Python code required to produce your output is part of the document itself, and is automatically re-run whenever the document is rendered.

If you have Python and the `jupyter` package installed then you have all you need to render documents that contain embedded Python code (if you don't, we'll cover this in the [installation](#installation) section below). Next, we'll cover the basics of creating and rendering documents with Python code blocks.

### Code Blocks

Code blocks that use braces around the language name (e.g. ```` ```{python} ````) are executable, and will be run by Quarto during render. Here is a simple example:

```` markdown
---
title: "matplotlib demo"
format:
  html:
    code-fold: true
jupyter: python3
---

For a demonstration of a line plot on a polar axis, see @fig-polar.

```{{python}}
#| label: fig-polar
#| fig-cap: "A line plot on a polar axis"

import numpy as np
import matplotlib.pyplot as plt

r = np.arange(0, 2, 0.01)
theta = 2 * np.pi * r
fig, ax = plt.subplots(
  subplot_kw = {'projection': 'polar'} 
)
ax.plot(theta, r)
ax.set_rticks([0.5, 1, 1.5, 2])
ax.grid(True)
plt.show()
```
````

You'll note that there are some special comments at the top of the code block. These are cell level options that make the figure [cross-referenceable](/docs/authoring/cross-references.qmd).

This document would result in the following rendered output:

![](/images/hello-jupyter.png){.border fig-alt="Example output where header reads: matplotlib demo, the body reads: For a demonstration of a line plot on a polar axis, see Figure 1. Below the body text is a toggleable field to reveal the code, and the Figure 1 image with a caption that reads: Figure 1: A line plot on a polar axis."}

You can produce a wide variety of output types from executable code blocks, including plots, tabular output from data frames, and plain text output (e.g. printing the results of statistical summaries).

There are many options which control the behavior of code execution and output, you can read more about them in the article on [Execution Options](execution-options.qmd).

In addition to code blocks which interrupt the flow of markdown, you can also include code inline. Read more about inline code in the [Inline Code](inline-code.qmd) article.

{{< include _jupyter-rendering.md >}}

## Installation {#installation}

If you already have Python 3 and Jupyter installed in your environment, then you should have everything required to render Jupyter notebooks with Python kernels.

{{< include _jupyter-install.md >}}

{{< include _jupyter-authoring-tools.md >}}

{{< include _jupyter-cache.md >}}

{{< include _caching-more.md >}}


## Kernel Selection

The Jupyter kernel used by Quarto is determined using the `jupyter` metadata option. For example, to use the [Xeus Python](https://github.com/jupyter-xeus/xeus-python) kernel, do this:

``` yaml
---
title: "My Document"
jupyter: xpython
---
```

Note that you can also provide a full `kernelspec`, for example:

``` yaml
---
title: "My Document"
jupyter: 
  kernelspec:
    name: "xpython"
    language: "python"
    display_name: "Python 3.7 (XPython)"
---
```

If no Jupyter kernel is specified, then the kernel is determined by finding an available kernel that supports the language of the first executable code block found within the file (e.g. ```` ```{python} ````).

::: callout-important
## Kernels from Conda

If you are using a kernel that is contained within an external conda environment you need to take an extra step to make sure it is recognized by Quarto. Please follow the instructions here to make conda managed kernels available:

<https://github.com/Anaconda-Platform/nb_conda_kernels#use-with-nbconvert-voila-papermill>

Note that this step is not required if you are merely using conda with Quarto. It applies to using kernels other than the default Python kernel that happen to be installed within a conda environment separate from the one you are using.
:::

{{< include _jupyter-daemon.md >}}
```````

## File: docs/computations/r.qmd
```````
---
title: "Using R"
---

## Overview

Quarto is a multi-language, next generation version of R Markdown from RStudio, with many new features and capabilities. Like R Markdown, Quarto uses [Knitr](https://yihui.org/knitr/) to execute R code, and is therefore able to render most existing Rmd files without modification.

We'll start by covering the basics of Quarto, then delve into the differences between Quarto and R Markdown in the sections on [Chunk Options](#chunk-options) and [Output Formats](#output-formats) below.

### Code Blocks

Code blocks that use braces around the language name (e.g. ```` ```{r} ````) are executable, and will be run by Quarto during render. Here is a simple example:

```` markdown
---
title: "ggplot2 demo"
author: "Norah Jones"
date: "5/22/2021"
format: 
  html:
    code-fold: true
---

## Air Quality

@fig-airquality further explores the impact of temperature on ozone level.

```{{r}}
#| label: fig-airquality
#| fig-cap: "Temperature and ozone level."
#| warning: false

library(ggplot2)

ggplot(airquality, aes(Temp, Ozone)) + 
  geom_point() + 
  geom_smooth(method = "loess")
```
````

You'll note that there are some special comments at the top of the code block. These are cell level options that make the figure [cross-referenceable](/docs/authoring/cross-references.qmd).

This document results in the following rendered output:

![](/images/hello-knitr.png){.border fig-alt="Example output with title (ggplot2 demo), author (Norah Jones), and date (5/22/2021). Below is a header reading Air Quality followed by body text (Figure 1 further explores the impact of temperature on ozone level.) with a toggleable code field, and figure with caption that reads Figure 1 Temperature and ozone level."}

You can produce a wide variety of output types from executable code blocks, including plots, tabular output from data frames, and plain text output (e.g. printing the results of statistical summaries).

There are many options which control the behavior of code execution and output, you can read more about them in the article on [Execution Options](execution-options.qmd). 

In addition to code blocks which interrupt the flow of markdown, you can also include code inline. Read more about inline code in the [Inline Code](inline-code.qmd) article.

### Rendering

When a Quarto document is rendered, R code blocks are automatically executed. You can render Quarto documents in a variety of ways:

1)  Using the **Render** button in RStudio:

    ![](/docs/tools/images/rstudio-render.png){.border-bottom width="612" fig-alt="The top section of a qmd file as displayed in RStudio. There is a toolbar right above the document containing various options, including 'Render.' There is a stylized, segmented blue arrow pointing at the word."}
    
    The **Render** button will render the first format listed in the document YAML. If no format is specified, then it will render to HTML.

2)  From the system shell using the `quarto render` command:

    ```{.bash filename="Terminal"}
    quarto render document.qmd # all formats
    quarto render document.qmd --to pdf
    quarto render document.qmd --to docx
    ```

    Note that the target file (in this case `document.qmd`) should always be the very first command line argument. 
    
    The `render` command will render all formats listed in the document YAML. If no formats are specified, then it will render to HTML. You can also provide the `--to` argument to target a specific format.

3)  From the R console using the **quarto** R package:

    ``` r
    library(quarto)
    quarto_render("document.qmd") # all formats
    quarto_render("document.qmd", output_format = "pdf")
    ```
    
    The function `quarto_render()` is a wrapper around `quarto render` and by default, will render all formats listed in the document YAML. 
     
    Note that the Quarto R package is a convenience for command line rendering from R, and is not required for using Quarto with R. 

## Installation

To use Quarto with R, you should install the **rmarkdown** R package:

``` r
install.packages("rmarkdown")
```

Installation of the **rmarkdown** package will also install the **knitr** package so you will have everything required to render documents containing R code.

Quarto will select a version of R by looking on the system `PATH`. In addition, on Windows when R is not found on the `PATH`, the registry will be scanned for the current R version. You can override the version of R used by Quarto by setting the `QUARTO_R` environment variable to the directory where the R binary `RScript` is. 

## RStudio

{{< include ../tools/_rstudio.md >}}


## VS Code

The [Quarto Extension](https://marketplace.visualstudio.com/items?itemName=quarto.quarto) for VS Code provides a variety of tools for working with `.qmd` files in VS Code. The extension integrates directly with the [R Extension](https://marketplace.visualstudio.com/items?itemName=REditorSupport.r) to provide the following R-specific capabilities:

1)  Code completion
2)  Cell execution
3)  Contextual help

![](images/r-vscode.png){.border fig-alt="Screen shot of qmd file open in VS code with source markdown shown in left pane and output plot shown in the right."}

You can install the VS Code extension by searching for 'quarto' in the extensions panel or from the [extension marketplace](https://marketplace.visualstudio.com/items?itemName=quarto.quarto).

The VS Code extension includes a **Quarto: Preview** command that can be accessed via the Command Palette, the keyboard shortcut {{< kbd mac=Command-Shift-K win=Control-Shift-K linux=Control-Shift-K >}}, or a **Preview** button (![](/docs/tools/images/vscode-preview-icon.svg){fig-alt="Preview icon"}) in the editor. 
After rendering, a preview is displayed in a pane within VS Code alongside your document.

You can read more about using VS Code in [Tools: VS Code](/docs/tools/vscode/index.qmd).

## Emacs

The [quarto-mode](https://melpa.org/#/quarto-mode) MELPA package is an Emacs mode for editing Quarto documents. Install `quarto-mode` as follows:

``` default
M-x package-refresh-contents
M-x package-install
  quarto-mode
```

If you have [ESS](https://ess.r-project.org/), `quarto-mode` will make use of it for executing R code.

Use `M-x quarto-preview` to start a `quarto preview` server that watches quarto content for changes and automatically refreshes it. If the current buffer has an associated file that exists in a quarto project, the command will preview the entire project. Otherwise, it will preview the specific file.

## Chunk Options {#chunk-options}

{{< include ../tools/_chunk-options.md >}}

## Chunk Labels

You can set a label for a code chunk with the `label`  option:

````markdown
```{{r}}
#| label: convert
airquality$TempC <- (5 / 9) * (airquality$Temp - 32)
```
````

Unless you want to specify a cross-reference avoid using the [reserved cross-reference prefixes](/docs/authoring/cross-references.qmd#reserved-prefixes) for chunk labels.

## Output Formats {#output-formats}

Another difference between R Markdown and Quarto is related to output formats. Quarto includes many more built in output formats (and many more options for customizing each format). Quarto also has native features for special project types like [Websites](/docs/websites/), [Books](/docs/books/), and [Blogs](/docs/websites/website-blog.qmd) (rather than relying on external packages).

To use a format in Quarto you use the `format` key rather than the `output` key as you did in R Markdown. Here's a comparison of equivalent format specifications:

::: {layout-ncol="2"}
#### R Markdown

``` yaml
title: "My Document"
output:
  html_document:
    toc: true
    number_sections: true
    css: styles.css
```

#### Quarto

``` yaml
title: "My Document"
format:
  html:
    toc: true
    number-sections: true
    css: styles.css
```
:::

One source of the difference in syntax is that Quarto is more closely aligned with [Pandoc](https://pandoc.org) format names and options (thus the use of `-` as a word separator rather than `_`).

See the listing of all [supported formats](/docs/output-formats/all-formats.qmd) along with their user guides and reference pages for more details.

See the articles on creating [Websites](/docs/websites/), [Books](/docs/books/), and [Blogs](/docs/websites/website-blog.qmd) for additional details on more advanced output formats.


## Data Frames

{{< include _knitr-df-print.md >}}

{{< include _knitr-options.md >}}


## Caching

The [Knitr Cache](https://bookdown.org/yihui/rmarkdown-cookbook/cache.html) operates at the level of individual cells rather than the entire document. While this can be very convenient, it also introduced some special requirements around managing the dependencies between cells.

You can enable the Knitr cache at the document or project level using standard YAML options:

``` yaml
---
title: "My Document"
format: html
execute: 
  cache: true
---
```

You can also enable caching on a per-cell basis (in this you would *not* set the document level option):

```{{r}}
#| cache: true

summary(cars)
```

There are a variety of other cell-level options that affect Knitr caching behavior. You can learn about them in the Knitr [cell options](/docs/reference/cells/cells-knitr.qmd#cache) reference. Another excellent resource is Yihui Xie's article on [cache invalidation](https://yihui.org/en/2018/06/cache-invalidation/).

{{< include _caching-more.md >}}
```````

## File: docs/computations/render-scripts.qmd
```````
---
title: "Rendering Script Files"
format: html
code-annotations: select
aliases: 
  - /docs/prerelease/1.4/script-r.html
  - /docs/prerelease/1.4/script.html
---

{{< include /docs/_require-1.4.qmd >}}

## Overview

Quarto supports rendering script files (e.g. `.py`, `.jl`, or `.r`) that are specially formatted as notebooks. The specific syntax for the format is different for the Jupyter and Knitr engines. The Jupyter engine can render Python, Julia, and R (using the [IRkernel](https://irkernel.github.io)) scripts, whereas the Knitr engine only renders R scripts.

On this page you can learn the [syntax](#syntax) for Jupyter and Knitr notebook scripts, how to [Render and Preview](#render-and-preview) notebook scripts as well as using notebook [Scripts in Projects](#scripts-in-projects).

## Syntax {#syntax}

The syntax for delineating YAML, code and Markdown depends on whether you are rendering with the Jupyter or Knitr engine. For Python and Julia scripts use the Jupyter engine. For R scripts, you can use either the Jupyter or Knitr engine.

### Jupyter

Script rendering for Jupyter makes use of the [percent format](https://jupytext.readthedocs.io/en/latest/formats-scripts.html) that is supported by several other tools including Spyder, VS Code, PyCharm, and Jupytext.

In the percent format:

-   Markdown cells are delimited by `# %% [markdown]`, and can include content as single line comments (`#`) or multi-line strings (`"""`).

-   Code cells are delimited by `# %%`.

There are also Quarto-specific additions:

-   The script must start with a markdown cell that includes a YAML header block (including the usual `---` YAML delimiters).

-   You can add code cell options in the usual way with `#|` comments.

For example, here is a Python script that includes both markdown and code cells (you can click on the numbers on the right for further details):

``` {.python filename="script.py"}
# %% [markdown]                           #<1>
# ---                                     #<1>
# title: Palmer Penguins                  #<1>
# author: Norah Jones                     #<1>
# date: 3/12/23                           #<1>
# ---                                     #<1>

# %%                                      #<2>
#| echo: false                            #<2>
import pandas as pd                       #<2>
df = pd.read_csv("palmer-penguins.csv")   #<2>

# %% [markdown]                           #<3>
"""                                       #<3>
## Exploring the data                     #<3>
                                          #<3>
See @fig-bill-sizes for an exploration of bill sizes by species. #<3>
"""                                       #<3>

# %% 
#| label: fig-bill-sizes                  #<4>
#| fig-cap: Bill Sizes by Species         #<4>
                                          
import matplotlib.pyplot as plt           
import seaborn as sns
                                          #<5>
g = sns.FacetGrid(df, hue="species", height=3, aspect=3.5/1.5)
g.map(plt.scatter, "bill_length_mm", "bill_depth_mm").add_legend()
```

1.  Scripts rendered with Quarto must begin with a markdown cell containing the YAML header.
2.  A code cell.
3.  A markdown cell containing a multiline string (`"""`).
4.  Code cell options specified with `#|` comments.
5.  You can include blank lines within cells---cells continue until another cell is encountered.

#### Generating Markdown

Jupyter scripts are especially convenient when most of your document consists of code that dynamically generates markdown. You can write markdown from Python using functions in the `IPython.display` module. For example:

``` python
# %%
#| echo: false
radius = 10
from IPython.display import Markdown
Markdown(f"The _radius_ of the circle is **{radius}**.")
```

Note that dynamically generated markdown will still be enclosed in the standard Quarto output divs. If you want to remove all of Quarto's default output enclosures use the `output: asis` option. For example:

``` python
# %%
#| echo: false
#| output: asis
radius = 10
from IPython.display import Markdown
Markdown(f"The _radius_ of the circle is **{radius}**.")
```

#### Raw Cells

You can include raw cells (e.g. HTML or LaTeX) within scripts using the `# %% [raw]` cell delimiter along with a `format` attribute, for example:

``` python
# %% [raw] format="html"
"""
<iframe width="560" height="315" src="https://www.youtube.com/embed/lJIrF4YjHfQ?si=aP7PxA1Pz8IIoQUX"></iframe>
"""
```

### Knitr

Script rendering for Knitr is based on the `knitr::spin()` feature and makes use of the same [syntax rules](https://bookdown.org/yihui/rmarkdown-cookbook/spin.html):

-   Markdown content is included on lines starting with a special `#'` comment.

-   Lines that don't start with `#` are code. Code blocks are split when Markdown content occurs , e.g. use `#'` to create another code block.

There are also Quarto-specific additions:

-   The R script must start with YAML header block using the special `#'` comment.

-   You can add code cell options in the usual way with `#|` comments.

For example, here is an R script that includes both markdown and code cells (you can click on the numbers on the right for further details):

``` {.r filename="script.R"}
#' ---                                #<1>
#' title: Palmer Penguins             #<1>
#' author: Norah Jones                #<1>
#' date: 3/12/23                      #<1>
#' format: html                       #<1>
#' ---                                #<1>

library(palmerpenguins)               #<2>

#' ## Exploring the data                                            #<3>
#' See @fig-bill-sizes for an exploration of bill sizes by species. #<3>

#| label: fig-bill-sizes                        #<4>
#| fig-cap: Bill Sizes by Species               #<4>
#| warning: false                               #<4>
library(ggplot2)
ggplot(data = penguins,
       aes(x = bill_length_mm,
           y = bill_depth_mm,
           group = species)) +
  geom_point(aes(color = species,
                 shape = species),
             size = 3,
             alpha = 0.8) +
  labs(title = "Penguin bill dimensions",
       subtitle = "Bill length and depth for Adelie, Chinstrap and Gentoo Penguins at Palmer Station LTER",
       x = "Bill length (mm)",
       y = "Bill depth (mm)",
       color = "Penguin species",
       shape = "Penguin species")
```

1.  Scripts rendered with Quarto must begin with a YAML header using `#'` comments.
2.  R code is the main content of the R script and is included without any delimitation.
3.  Preface Markdown content with the `#'` comment.
4.  Code cell options are specified with `#|` comments and apply to code below them.

## Render and Preview {#render-and-preview}

You can render and preview notebook scripts just as you would a `.qmd` or `.ipynb` file. For example, the following commands are all valid:

``` bash
$ quarto render script.py
$ quarto render script.jl
$ quarto render script.R

$ quarto preview script.py
$ quarto preview script.jl
$ quarto preview script.R
```

The script must begin with the appropriate [syntax](#syntax) for the YAML block to be rendered with Quarto. Based on the syntax detected Quarto will render with the Jupyter or Knitr engine.

The [Quarto VS Code Extension](https://marketplace.visualstudio.com/items?itemName=quarto.quarto) also implements support for rendering and previewing scripts.

## Scripts in Projects {#scripts-in-projects}

Notebook scripts can also be included within [projects](/docs/projects/quarto-projects.qmd) (e.g. websites, blogs, etc.). Scripts within projects are only rendered by Quarto when they start with the appropriate [syntax](#syntax).

If for some reason you need to ignore such a script, you can create an explict render list in `_quarto.yml` that excludes individual scripts as required, for example:

``` yaml
project:
  type: website
  render:
    - "*.{qmd,R,py}"
    - "!utils.py"
```

Note that this technique is documented for the sake of completeness---in practice you should almost never need to do this since scripts rarely begin with a YAML block unless you are authoring them specifically for report rendering.
```````

## File: docs/dashboards/_examples/inputs/card-toolbar.qmd
```````
---
title: "Penguin Bills"
format: dashboard
server: shiny
---

```{python}
import seaborn as sns
penguins = sns.load_dataset("penguins")
```

```{python}
#| content: card-sidebar
from shiny.express import ui, render
ui.input_select("x", "Variable:",
                choices=["bill_length_mm", "bill_depth_mm"])
ui.input_select("dist", "Distribution:", choices=["hist", "kde"])
ui.input_checkbox("rug", "Show rug marks", value = False)
```

```{python}
#| title: Penguin Bills
@render.plot
def displot():
  sns.displot(
    data=penguins, hue="species", multiple="stack",
    x=input.x(), rug=input.rug(), kind=input.dist())
```
```````

## File: docs/dashboards/_examples/inputs/column-layout.qmd
```````
---
title: "Palmer Penguins"
author: "Cobblepot Analytics"
format: dashboard
server: shiny
---

```{python}
#| context: setup
import seaborn as sns
penguins = sns.load_dataset("penguins")
species = list(penguins["species"].value_counts().index)
islands = list(penguins["island"].value_counts().index)
```

::: {.inputs header-for="next" layout-ncol="3"}

```{python}
from shiny import reactive
from shiny.express import render, ui
ui.input_checkbox_group(
    "species", "Species:",
    species, selected = species
)
```

```{python}
ui.input_checkbox_group(
    "islands", "Islands:",
    islands, selected = islands
)
```

```{python}
ui.input_select("dist", "Distribution:", choices=["kde", "hist"])
ui.input_checkbox("rug", "Show rug marks", value = False)
```

:::



```{python}
@reactive.calc
def filtered_penguins():
    data = penguins[penguins["species"].isin(input.species())]
    data = data[data["island"].isin(input.islands())]
    return data
```


```{python}
#| title: Bill Depth
@render.plot
def depth():
    return sns.displot(
        filtered_penguins(), x = "bill_depth_mm",
        hue = "species", kind = input.dist(),
        fill = True, rug=input.rug()
    )
```
```````

## File: docs/dashboards/_examples/inputs/inline-sidebar.qmd
```````
---
title: "Palmer Penguins"
author: "Cobblepot Analytics"
format: dashboard
server: shiny
---

```{python}
import seaborn as sns
penguins = sns.load_dataset("penguins")
```


## Row

### {.sidebar}

```{python}
from shiny.express import render, ui
ui.input_select("x", "Variable:",
                choices=["bill_length_mm", "bill_depth_mm"])
ui.input_select("dist", "Distribution:", choices=["hist", "kde"])
ui.input_checkbox("rug", "Show rug marks", value = False)
```

### Column

```{python}
@render.plot
def displot():
    sns.displot(
        data=penguins, hue="species", multiple="stack",
        x=input.x(), rug=input.rug(),kind=input.dist())
```

## Row

```{python}
@render.data_frame
def dataview():
    return render.DataGrid(penguins, height = "100%")
```
```````

## File: docs/dashboards/_examples/inputs/inline-toolbar.qmd
```````
---
title: "Palmer Penguins"
author: "Cobblepot Analytics"
format:
  dashboard:
    orientation: columns
server: shiny
---

```{python}
import seaborn as sns
penguins = sns.load_dataset("penguins")
```


## Column

### {.toolbar}

```{python}
from shiny.express import render, ui
ui.input_select("dist", "Distribution:", choices=["hist", "kde"])
ui.input_checkbox("rug", "Show rug marks", value = False)
```

### Row

```{python}
@render.plot
def displot():
    sns.displot(
        data=penguins, hue="species", multiple="stack",
        x="bill_length_mm", rug=input.rug(),kind=input.dist())
```

## Column

```{python}
@render.data_frame
def dataview():
    return render.DataGrid(penguins, height = "100%")
```
```````

## File: docs/dashboards/_examples/inputs/input-panel.qmd
```````
---
title: "Penguin Bills"
format: dashboard
server: shiny
---

```{python}
import seaborn as sns
penguins = sns.load_dataset("penguins")
```


## {.toolbar}




## Row

::: {.card-toolbar}

```{python}
#| content: card-toolbar
from shiny.express import render, ui
ui.input_select("x", "Variable:",
                choices=["bill_length_mm", "bill_depth_mm"])
ui.input_select("dist", "Distribution:", choices=["hist", "kde"])
ui.input_checkbox("rug", "Show rug marks", value = False)
```

:::

```{python}
@render.plot
def displot():
    sns.displot(
        data=penguins, hue="species", multiple="stack",
        x=input.x(), rug=input.rug(), kind=input.dist())
```
```````

## File: docs/dashboards/_examples/inputs/page-sidebar.qmd
```````
---
title: "Penguin Bills"
format: dashboard
server: shiny
---

```{python}
import seaborn as sns
penguins = sns.load_dataset("penguins")
```

## {.sidebar}

```{python}
from shiny.express import render, ui
ui.input_select("x", "Variable:",
                choices=["bill_length_mm", "bill_depth_mm"])
ui.input_select("dist", "Distribution:", choices=["hist", "kde"])
ui.input_checkbox("rug", "Show rug marks", value = False)
```

## Column

```{python}
@render.plot
def displot():
    sns.displot(
        data=penguins, hue="species", multiple="stack",
        x=input.x(), rug=input.rug(),kind=input.dist())
```
```````

## File: docs/dashboards/_examples/inputs/right-sidebar.qmd
```````
---
title: "Palmer Penguins"
author: "Cobblepot Analytics"
format: dashboard
server: shiny
---

```{python}
#| context: setup
from shiny import reactive
from shiny.express import render, ui
import seaborn as sns
penguins = sns.load_dataset("penguins")
species = list(penguins["species"].value_counts().index)
islands = list(penguins["island"].value_counts().index)
```

## Column

```{python}
#| title: Bill Depth
@render.plot
def depth():
    return sns.displot(
        filtered_penguins(), x = "bill_depth_mm",
        hue = "species", kind = input.dist(),
        fill = True, rug=input.rug()
    )
```

```{python}
#| title: Bill Length
@render.plot
def length():
    return sns.displot(
        filtered_penguins(), x = "bill_length_mm",
        hue = "species", kind = input.dist(),
        fill = True, rug=input.rug()
    )
```

## {.sidebar width="300px"}

![](penguins.png){width="80%"}

```{python}
ui.input_checkbox_group(
    "species", "Species:",
    species, selected = species
)

ui.input_checkbox_group(
    "islands", "Islands:",
    islands, selected = islands
)

@reactive.calc
def filtered_penguins():
    data = penguins[penguins["species"].isin(input.species())]
    data = data[data["island"].isin(input.islands())]
    return data
```

```{python}
ui.input_select("dist", "Distribution:", choices=["kde", "hist"])
ui.input_checkbox("rug", "Show rug marks", value = False)
```

[Learn more](https://pypi.org/project/palmerpenguins/) about the
Palmer Penguins dataset.
```````

## File: docs/dashboards/_examples/inputs/toolbar.qmd
```````
---
title: "Penguin Bills"
format: dashboard
server: shiny
---

```{python}
from shiny.express import ui, render
import seaborn as sns
penguins = sns.load_dataset("penguins")
```

## {.toolbar}

```{python}
ui.input_select("x", "Variable:",
                choices=["bill_length_mm", "bill_depth_mm"])
ui.input_select("dist", "Distribution:", choices=["hist", "kde"])
ui.input_checkbox("rug", "Show rug marks", value = False)
```

## Row

```{python}
@render.plot
def displot():
  sns.displot(
    data=penguins, hue="species", multiple="stack",
    x=input.x(), rug=input.rug(), kind=input.dist())
```
```````

## File: docs/dashboards/_examples/julia/julia-plotly.qmd
```````
---
title: "Julia Plotly"
format: dashboard
---


```{julia}
using Plots
plot(sin, 
     x->sin(3x), 
     0, 
     2π, 
     leg=false, 
     fill=(0,:lavender))
```
```````

## File: docs/dashboards/_examples/python/python-itables.qmd
```````
---
title: "Python Test"
format: dashboard
execute: 
  daemon: false
---

```{python}
import seaborn as sns
from itables import show
penguins = sns.load_dataset("penguins")

#options.classes = "display nowrap compact"
# options.dom = "ifrt"
# options.language = { "info": "Showing _TOTAL_ entries" }
# options.paging = False

```


## First

```{python}
show(penguins)
```


## Second

```{python}
show(penguins)
```



```{python}
#| classes: flow
#show(penguins, maxBytes = 1000)
```

```{python}
# sns.displot(penguins, x = "bill_depth_mm", 
#         hue = "species", fill = True, rug=True)
```
```````

## File: docs/dashboards/_examples/python/python-tabulate.qmd
```````
---
title: "Python Tabulate"
format: dashboard
---


```{python}
import pandas as pd
from IPython.display import Markdown
from tabulate import tabulate
penguins = pd.read_csv("penguins.csv")
```


```{python}
Markdown(penguins.to_markdown(index=False))
```

```{python}
Markdown(tabulate(
  penguins, 
  showindex=False,
  headers=penguins.columns
))
```
```````

## File: docs/dashboards/_examples/r/dt.qmd
```````
---
title: "DataTables"
format: dashboard
---

```{r}
knitr::kable(mtcars)
```


```{r}
options(DT.options = list(bPaginate = FALSE, dom = "ifrt", language = list(info = "Showing _TOTAL_ entries")))
```

```{r}
library(DT)
datatable(mtcars)
```
```````

## File: docs/dashboards/_examples/_TODO.qmd
```````
---
title: "TODO"
---

-   Fake Navigation Bar
-   `width` and `height` attributes
    -   In the presence of not all rows/columns specified, unspecified rows and columns should distribute
    -   Unitless numbers should be interpreted as pixels
    -   Percents should work as expected
    -   Cards need to be able have width and height (which means `width` and `height` cell options need to work
-   Tabsets
    -   Headings should be able to create tabsets
    -   Tabsets without titles (left align tabs)
-   Sidebars
-   Markdown cells in notebooks should be cards
-   Value Boxes (`compontent: valuebox`)
-   Real Navigation Bar
```````

## File: docs/dashboards/_examples/altair.qmd
```````
---
title: "Altair"
format: dashboard
---


```{python}
#| title: Iowa Electricity
import altair as alt
from vega_datasets import data

source = data.iowa_electricity()

alt.Chart(source).mark_area(opacity=0.3).encode(
    x="year:T",
    y=alt.Y("net_generation:Q").stack(None),
    color="source:N"
)
```
```````

## File: docs/dashboards/_examples/cell-layout.qmd
```````
---
title: "Cell Layout"
format: dashboard
---

```{python}
import plotly.express as px
df = px.data.tips()
```

```{python}
#| title: "Tipping Behavior"
#| layout-ncol: 2

px.box(df, x="sex", y="total_bill", color="smoker")

px.violin(df, x="sex", y="total_bill", color="smoker")
```
```````

## File: docs/dashboards/_examples/flow.qmd
```````
---
title: "Development Indicators by Continent"
author: "Gapminder Analytics Group"
format: dashboard
---

```{python}
import plotly.express as px
df = px.data.gapminder()
```

```{python}
px.area(df, x="year", y="pop", color="continent", line_group="country")
```

```{python}
px.line(df, x="year", y="lifeExp", color="continent", line_group="country")
```

## {.flow}

Mauris quis ex leo. Duis sagittis vel odio ac interdum. Sed molestie mauris neque, sed commodo est iaculis fringilla. Curabitur molestie suscipit sem, vitae condimentum dolor feugiat eget. Cras tincidunt sem vel dolor feugiat, et vehicula mauris fermentum. Nulla iaculis libero vitae porttitor consectetur. Vivamus ultricies lectus imperdiet elit lacinia congue. Etiam efficitur tortor est, nec pharetra mi congue quis. Curabitur accumsan, ante id condimentum elementum, felis odio suscipit felis, eget pellentesque justo tortor quis odio. Quisque nec ex et enim tempor dapibus quis ut libero. Quisque feugiat justo ipsum, eu tincidunt justo posuere id. Donec non ullamcorper eros. Curabitur maximus lacus vel lectus pulvinar vehicula.

Maecenas nunc leo, molestie quis augue ac, interdum fringilla ante. Sed ut nunc diam. Etiam aliquet elit eget volutpat dignissim. Cras cursus bibendum eros, a pellentesque mauris venenatis non. In iaculis porta justo, vitae luctus lectus consectetur ut. Integer pretium dolor aliquet massa eleifend faucibus. Ut sed metus lacinia, fringilla neque eget, ultrices nunc.
```````

## File: docs/dashboards/_examples/gapminder-content.qmd
```````
---
title: "Gapminder: Development Indicators by Continent"
format: 
  dashboard:
    orientation: columns
---

```{python}
import plotly.express as px
df = px.data.gapminder()
```

## Column

```{python}
#| title: Population
px.area(df, x="year", y="pop", color="continent", 
        line_group="country")
```


```{python}
#| title: Life Expectancy
px.line(df, x="year", y="lifeExp", color="continent", 
        line_group="country")
```

::: {.card .flow}

Gapminder combines data from multiple sources into
unique coherent time-series that can’t be found
elsewhere. Learn more about the Gapminder dataset at
 <https://www.gapminder.org/data/>.
 
:::
```````

## File: docs/dashboards/_examples/gapminder.qmd
```````
---
title: "Development Indicators by Continent"
author: "Gapminder Analytics Group"
format: 
  dashboard:
    expandable: false
---

```{python}
import plotly.express as px
df = px.data.gapminder()
```

## Row {height=60%}

```{python}
#| title: GDP and Life Expectancy 
#| expandable: true
px.scatter(
  df, x="gdpPercap", y="lifeExp", 
  animation_frame="year", animation_group="country",
  size="pop", color="continent", hover_name="country", 
  facet_col="continent", log_x=True, size_max=45, 
  range_x=[100,100000], range_y=[25,90]
)
```

## Row {height=40%}

```{python}
#| title: Population
px.area(df, x="year", y="pop", color="continent", line_group="country")
```


```{python}
#| title: Life Expectancy
px.line(df, x="year", y="lifeExp", color="continent", line_group="country")
```
```````

## File: docs/dashboards/_examples/leaflet.qmd
```````
---
title: "Leaflet"
format: dashboard
---


```{python}
from ipyleaflet import Map, basemaps, basemap_to_tiles
Map(basemap=basemap_to_tiles(basemaps.OpenStreetMap.Mapnik),
    center=(48.204793, 350.121558), zoom=2)
```
```````

## File: docs/dashboards/_examples/markdown.qmd
```````
---
title: "Markdown"
format: dashboard
---

```{python}
import plotly.express as px
gapminder = px.data.gapminder()
```




```{python}
from itables import show
show(gapminder)
```



```{python}
from IPython.display import Markdown
Markdown(f"""The model is old""")
```
```````

## File: docs/dashboards/_examples/navigation.qmd
```````
---
title: "Palmer Penguins"
author: "Cobblepot Analytics"
format: 
   dashboard:
      logo: penguins.png
      nav-buttons:
        - linkedin
        - twitter
        - github
---
 
# Bills 

```{python}
1
```

# Flippers {orientation="columns"}

## Column 

```{python}
1
```

## Column

```{python}
1
```

```{python}
1
```

# Data
```````

## File: docs/dashboards/_examples/penguins-obervable.qmd
```````
---
title: "Palmer Penguins"
author: "Cobblepot Analytics"
format: dashboard
---

```{ojs}
//| output: false

data = FileAttachment("penguins.csv").csv({ typed: true })

filtered = data.filter(function(penguin) {
  return bill_length_min < penguin.bill_length_mm &&
         islands.includes(penguin.island);
})
```

# {.sidebar}

![](images/penguins.png){width="80%"}

```{ojs}
viewof bill_length_min = Inputs.range(
  [32, 50], 
  {value: 35, step: 1, label: "Bill length (min):"}
)

viewof islands = Inputs.checkbox(
  ["Torgersen", "Biscoe", "Dream"], 
  { value: ["Torgersen", "Biscoe"], 
    label: "Islands:"
  }
)
```

A simple example based on Allison Horst's [Palmer Penguins](https://
allisonhorst.github.io/palmerpenguins/) dataset. Here we look at how penguin body mass varies across both sex and species.

# Plot

```{ojs}
Plot.rectY(filtered, 
  Plot.binX(
    {y: "count"}, 
    {x: "body_mass_g", fill: "species", thresholds: 20}
  ))
  .plot({
    facet: {
      data: filtered,
      x: "sex",
      y: "species",
      marginRight: 80
    },
    marks: [
      Plot.frame(),
    ]
  }
)
```

# Data

```{ojs}
Inputs.table(filtered)
```
```````

## File: docs/dashboards/_examples/python-wide.qmd
```````
---
title: "Wide"
format: dashboard
---

```{python}
import seaborn as sns
sns.set_theme(style="darkgrid")

# Load an example dataset with long-form data
fmri = sns.load_dataset("fmri")
```

```{python}
sns.lineplot(x="timepoint", y="signal",
             hue="region", style="event",
             data=fmri)
```


```{python}
import matplotlib.pyplot as plt
plt.rcParams['figure.figsize'] = (12, 4)
sns.lineplot(x="timepoint", y="signal",
             hue="region", style="event",
             data=fmri)
```


```{python}
# Plot the responses for different events and regions
sns.lineplot(x="timepoint", y="signal",
             hue="region", style="event",
             data=fmri)
```
```````

## File: docs/dashboards/_examples/shiny-diamonds.qmd
```````
---
title: "Diamonds Explorer"
author: "Barkamian Analytics"
format: dashboard
server: shiny
---

```{r}
#| context: setup
library(ggplot2)
dataset <- diamonds
```

## {.sidebar}

```{r}
sliderInput('sampleSize', 'Sample Size', 
            min=1, max=nrow(dataset),
            value=min(1000, nrow(dataset)), 
            step=500, round=0)
br()
checkboxInput('jitter', 'Jitter')
checkboxInput('smooth', 'Smooth')
```

```{r}
selectInput('x', 'X', names(dataset))
selectInput('y', 'Y', names(dataset), names(dataset)[[2]])
selectInput('color', 'Color', c('None', names(dataset)))
```

```{r}
selectInput('facet_row', 'Facet Row',
  c(None='.', names(diamonds[sapply(diamonds, is.factor)])))
selectInput('facet_col', 'Facet Column',
  c(None='.', names(diamonds[sapply(diamonds, is.factor)])))
```

## Column {.tabset}

```{r}
#| title: Plot
plotOutput('plot')
```

```{r}
#| title: Data
tableOutput('data')
```

```{r}
#| context: server

dataset <- reactive({
  diamonds[sample(nrow(diamonds), input$sampleSize),]
})
 
output$plot <- renderPlot({
  
  p <- ggplot(
    dataset(), 
    aes_string(x=input$x, y=input$y)) + geom_point()
  
  if (input$color != 'None')
    p <- p + aes_string(color=input$color)
  
  facets <- paste(input$facet_row, '~', input$facet_col)
  if (facets != '. ~ .')
    p <- p + facet_grid(facets)
  
  if (input$jitter)
    p <- p + geom_jitter()
  if (input$smooth)
    p <- p + geom_smooth()
  
  p
  
})

output$data <- renderTable({
  dataset()
})
```
```````

## File: docs/dashboards/_examples/shiny-global-sidebar.qmd
```````
---
title: "Palmer Penguins"
author: "Cobblepot Analytics"
format: dashboard
server: shiny
---

```{python}
#| context: setup
import seaborn as sns
penguins = sns.load_dataset("penguins")
species = list(penguins["species"].value_counts().index)
islands = list(penguins["island"].value_counts().index)
```

# {.sidebar}

![](images/penguins.png){width="80%"}

```{python}
from shiny import reactive
from shiny.express import render, ui

ui.input_checkbox_group(
    "species", "Species:",
    species, selected = species
)

ui.input_checkbox_group(
    "islands", "Islands:",
    islands, selected = islands
)

@reactive.calc
def filtered_penguins():
    data = penguins[penguins["species"].isin(input.species())]
    data = data[data["island"].isin(input.islands())]
    return data
```

```{python}
ui.input_select("dist", "Distribution:", choices=["kde", "hist"])
ui.input_checkbox("rug", "Show rug marks", value = False)
```

[Learn more](https://pypi.org/project/palmerpenguins/) about the
Palmer Penguins dataset.


# Plots

```{python}
#| title: Bill Depth
@render.plot
def depth():
    return sns.displot(
        filtered_penguins(), x = "bill_depth_mm",
        hue = "species", kind = input.dist(),
        fill = True, rug=input.rug()
    )
```

```{python}
#| title: Bill Length
@render.plot
def length():
    return sns.displot(
        filtered_penguins(), x = "bill_length_mm",
        hue = "species", kind = input.dist(),
        fill = True, rug=input.rug()
    )
```

# Data

```{python}
@render.data_frame
def dataview():
    return render.DataGrid(filtered_penguins(), height = "100%")
```
```````

## File: docs/dashboards/_examples/shiny-python-simple.qmd
```````
---
title: "Penguin Bills"
format: dashboard
server: shiny
---

```{python}
import seaborn as sns
penguins = sns.load_dataset("penguins")
```

## {.sidebar}

```{python}
from shiny.express import render, ui
ui.input_select("x", "Variable:",
                choices=["bill_length_mm", "bill_depth_mm"])
ui.input_select("dist", "Distribution:", choices=["hist", "kde"])
ui.input_checkbox("rug", "Show rug marks", value = False)
```

## Column

```{python}
@render.plot
def displot():
    sns.displot(
        data=penguins, hue="species", multiple="stack",
        x=input.x(), rug=input.rug(),kind=input.dist())
```
```````

## File: docs/dashboards/_examples/shiny-sidebar.qmd
```````
---
title: "Palmer Penguins"
author: "Cobblepot Analytics"
format: dashboard
server: shiny
---

```{python}
#| context: setup
import seaborn as sns
penguins = sns.load_dataset("penguins")
species = list(penguins["species"].value_counts().index)
islands = list(penguins["island"].value_counts().index)
```

## {.sidebar}

![](images/penguins.png){width="80%"}

```{python}
from shiny import reactive
from shiny.express import render, ui

ui.input_checkbox_group(
    "species", "Species:",
    species, selected = species
)

ui.input_checkbox_group(
    "islands", "Islands:",
    islands, selected = islands
)

@reactive.calc
def filtered_penguins():
    data = penguins[penguins["species"].isin(input.species())]
    data = data[data["island"].isin(input.islands())]
    return data
```

```{python}
ui.input_select("dist", "Distribution:", choices=["kde", "hist"])
ui.input_checkbox("rug", "Show rug marks", value = False)
```

[Learn more](https://pypi.org/project/palmerpenguins/) about the
Palmer Penguins dataset.


## Column

```{python}
#| title: Bill Depth
@render.plot
def depth():
    return sns.displot(
        filtered_penguins(), x = "bill_depth_mm",
        hue = "species", kind = input.dist(),
        fill = True, rug=input.rug()
    )
```

```{python}
#| title: Bill Length
@render.plot
def length():
    return sns.displot(
        filtered_penguins(), x = "bill_length_mm",
        hue = "species", kind = input.dist(),
        fill = True, rug=input.rug()
    )
```
```````

## File: docs/dashboards/_examples/valuebox.qmd
```````
---
title: "Value Boxes"
format: dashboard
engine: jupyter
---

```{python}
articles = 45
comments = 126
```

## Row 

```{python}
#| content: valuebox
#| title: "Articles per day"
#| icon: pencil
#| color: primary

articles
```

```{python}
#| content: valuebox
#| title: "Comments per day"

dict(
  icon = "pencil",
  color = "primary",
  value = comments
)
```

## Row

Here we go
```````

## File: docs/dashboards/interactivity/shiny-python/_shiny-requirements.qmd
```````
::: {.callout-note}
### Shiny Prerequisites

In order to use Shiny within Quarto documents you will need the latest version of the `shiny` (>=0.9.0) and `shinywidgets` (>=0.3.1) packages. You can install the latest version of these with:

```{.bash}
pip install --upgrade shiny shinywidgets
```
:::
```````

## File: docs/dashboards/interactivity/shiny-python/execution.qmd
```````
---
title: "Execution Contexts"
---

## Overview

Shiny interactive documents contain both code that executes at render time as well as code that executes on the server in response to user actions and changes in input values. A solid understanding of these execution contexts is important both to have the right mental model during development as well as to optimize the performance of your document.

## Default Execution

By default, all of the Python code in your document is executed at two different times:

1)  When you render the document using `quarto render` or `quarto preview`; and

2)  Whenever a new user connects to the Shiny application generated from the document.

If the render time of your document is short, this default execution pattern will likely serve you well and you don't need to think further about optimizing execution contexts.

## Setup Context

Many documents include setup code that loads required packages and data. If this setup code takes longer than a couple of seconds, it may make sense to explicitly designate it as setup code using the `context: setup` cell option. For example:

````python
```{{python}}
#| context: setup
import seaborn as sns
penguins = sns.load_dataset("penguins")
```
````

When you add `context: setup` to a cell, the code cell will be executed:

1)  When you render the document using `quarto render` or `quarto preview`; and

2)  At the startup of the Shiny application (this is in contrast to the default behavior which is to run the code whenever a new user connects to the application).

Explicitly designating setup code using `context: setup` is likely the only thing you'll need to do in terms of explicitly specifying execution contexts. Not only does `context: setup` address the most common performance issues, it also preserves simple and easy to reason about source code (all data and functions in the document are available at both render and serve time).

## UI Context

It's possible that you have cells in your document that _only_ contribute to the user interface and does not need to execute on the server. For example, this could be a static visualization that is never dynamically redrawn in response to changes in inputs.

To designate a call as only contributing to the user interface, specify the `context: ui` cell option. For example:

````python
```{{python}}
#| context: ui

# plot that isn't ever updated after initial rendering 
sns.lmplot(
    data=penguins,
    x="bill_length_mm", y="bill_depth_mm", hue="species",
    height=5
)
```
````

Cells with `context: ui` will only run during `quarto render`. Code and data created by this cell are not available when the application is served. 

## Learning More

To learn more about Shiny for Python interactive documents see the following articles:

-   [Getting Started](index.qmd) explains the basics of Shiny interactive documents.

-   [Component Browser](https://jcheng.shinyapps.io/shiny-component-browser/#outputs) enumerates the available Shiny inputs and outputs, along with code snippets you can copy and paste into your dashboard. 

-   [Input Layout](/docs/dashboards/inputs.qmd) describes various ways to layout inputs (sidebars, input panels, attaching inputs directly to cards, etc.).

-   [Running Dashboards](running.qmd) covers how to run interactive dashboards both within VS Code and at the command line, as well as how to deploy them to end users.

-   [Shiny for Python](https://shiny.posit.co/py/) provides in-depth documentation on all of the available UI and ouput widgets, as well as conceptual discussions on how things work.
```````

## File: docs/dashboards/interactivity/shiny-python/index.qmd
```````
---
title: "Dashboards with Shiny for Python"
code-annotations: select
lightbox: auto
aliases:
  - /docs/dashboards/interactivity/shiny-python.html
---

{{< include /docs/_require-1.4.qmd >}}



## Introduction

The [Shiny](https://shiny.posit.co/py/) package provides an easy way to build web applications with Python. Quarto dashboards can include embedded Shiny components (e.g. a plot with sliders that control its inputs).

This section assumes you have no experience with Shiny, and will teach you the basic concepts you need to get up and running with Shiny with Quarto. <!-- You can learn much more about Shiny at the official [Shiny website](https://shiny.posit.co/py/)--although note that the documentation there is written for non-Quarto uses of Shiny, which currently involve a slightly different syntax. -->

If you are using R rather than Python, see the documentation on using [Shiny for R](../shiny-r.qmd).

{{< include _shiny-requirements.qmd >}}

## Hello, Shiny

We'll start with a very simple dashboard that consists of a single plot and some inputs to drive its display:

{{< include _shiny-sidebar.md >}}

In this dashboard, you can choose different values from the select boxes on the left, and the plot will update to reflect your choices. You can also click the checkbox to show or hide rug marks. Let's go through the construction of this Shiny-enabled dashboard one step at a time.

### Metadata

The first thing to do is add `server: shiny` to the front matter. This tells Quarto that the document should be rendered as a Shiny dashboard (which requires a Python runtime whenever the dashboard is being viewed), rather than as a static HTML page. When you run `quarto preview <filename>.qmd` on a `server: shiny` document, Quarto will start and maintain a Shiny process for you and open the dashboard in your browser.

### Adding Input Controls

Next, we use functions matching the pattern `ui.input_xxx` to create input controls. For example, `ui.input_select()` creates a select box, `ui.input_slider()` creates a slider, and so on. The values returned by these functions are then rendered into HTML and JavaScript by Quarto.

This example only uses two types of inputs, but Shiny has many more. Use the [Shiny Component Browser](https://jcheng.shinyapps.io/shiny-component-browser/) to see them all, along with code snippets you can copy and paste into your dashboard.

The example above defined an input with the following code:


```` {.python .pymd}
```{{python}}
ui.input_select("x", label="Variable:",
                choices=["bill_length_mm", "bill_depth_mm"])
```
````

**Every input function takes an input ID as its first argument.** An input ID is string that uniquely identifies this input; it must be a simple, syntactically valid Python variable name. We will use this ID to access the input's value from other parts of the dashboard.

::: {.callout-warning}
Make sure each input ID in your Shiny dashboard is unique. If you use the same ID for two different inputs, Shiny will not be able to tell them apart, and your dashboard will not work correctly.
:::

The second argument for each input function is usually a human-readable string that will be displayed next to the input control. For example, the `ui.input_select()` function passes `"Variable:"`as the second argument, which is why the select box has the label "Variable:" next to it.

#### Sidebars and Toolbars

In many dashboards, it's desirable to visually gather all of your input controls into a sidebar. You can do this by adding the `.sidebar` class to a level 2 heading, as we did in the example:

````{.python .pymd}
## {.sidebar}

```{{python}}
ui.input_select("x", "Variable:",
                choices=["bill_length_mm", "bill_depth_mm"])
ui.input_select("dist", "Distribution:", choices=["hist", "kde"])
ui.input_checkbox("rug", "Show rug marks", value = False)
```
````

As an alternative to sidebars, you can also layout inputs horizontally, or even attach them directly to cards. See the article on [Inputs](/docs/dashboards/inputs.qmd) for further details.



### Displaying Dynamic Output

In Shiny, dashboards can contain outputs---plots, tables, text, etc.---that dynamically update in response to user input.

The example above defined a dynamic plot with the following code:

```` {.python .pymd}
```{{python}}
@render.plot
def displot():
    sns.displot(
        data=penguins, hue="species", multiple="stack",
        x=input.x(), rug=input.rug(), kind=input.dist())
```
````

The function here is given the name `displot`. The body of the function is using typical Seaborn code to create the plot. And a `@render.plot` decorator is added to the function, to indicate to Shiny that this function should be used to create a plot. (If you haven't seen decorators before, they're a Python feature that allows you to add additional behavior to a function.)

The `input.x()`, `input.rug()`. and `input.dist()` method calls are retrieving the values of the `x`, `rug`, and `dist` inputs created earlier in the dashboard.

Note that our code never calls the `displot()` function! Just the act of defining the function, and decorating it with `@render.plot`, is enough to tell Shiny and Quarto to:

* Insert a plot into the dashboard at this location.
* Use the function body to create the plot.
* Automatically re-run the function body whenever the values of `input.x()`, `input.rug()`, or `input.dist()` change due to user interaction, and use the result to update the existing plot.

This example only contains a single `@render.plot` output, but it's possible for Shiny apps to contain multiple outputs, and outputs of different types, as you'll see in the following example. Check out the [Shiny Component Browser](https://jcheng.shinyapps.io/shiny-component-browser/#outputs) to see what types of outputs are available.

### Reactive Programming

In the previous section, we said that the `displot` function would re-run _automatically_ whenever any of the inputs it referred to changed. Shiny is a **reactive programming** framework, meaning it takes care of tracking the relationships between inputs and outputs in your app. When an input changes, only outputs that are affected by that input are re-rendered. This is a powerful feature that makes it easy to create dashboards that respond to user input efficiently.

::: {.callout-note}
The `input` object is designed to be tracked by Shiny's reactive framework,

Shiny specifically tracks changes to _reactivity-aware_ objects like the `input` object, not to just any arbitrary Python variable. You can't just write `x = 100`, then use `x` from the `displot` function, and expect `displot` to automatically rerun whenever `x` changes.

Similarly, Shiny will only automatically re-run functions that are reactivity-aware, like ones decorated with `@render.plot`. It will not help re-execute code at the top level of the document or code in regular Python functions.
:::

## Additional Features

Next, we'll explore a more in-depth example that covers more features, including factoring out setup code, reactive calculations, and more advanced layout constructs like pages. Here is the interactive document we'll be building:

![](/docs/dashboards/images/penguins-shiny.png){.border fig-alt="Screenshot of a Palmer Penguins dashboard. Navigation bar shows two pages: Plots and Data. On the left is a sidebar with an image of penguins followed by four inputs: a set of checkboxes for Species; a set of checkboxes for Islands; and dropdown for Distribution; and a checkbox to show rug marks. On the right the page is divided into two rows each showing a density plot: the top row of bill_depth_mm; the bottom row of bill_length_mm"}

Here is the source code for this dashboard. You can click on the numbers on the far right for additional explanation of syntax and mechanics, and we'll also explain in more detail below.

{{< include _shiny-advanced.md >}}

### Setup Cell

In static Quarto documents, `{python}` code cells run only when the document is rendered, not when it is viewed. In `server: shiny` documents, `{python}` code cells are run both during render time _and_ each time the dashboard is loaded in a browser. This is important because each visitor to the dashboard needs their own independent copies of inputs/outputs in memory, so that simultaneous users don't interfere with each other.

However, sometimes we have code that would be excessive to run for every user, and we only want the code to run once, when the document's Shiny runtime process is starting up. For example, in the example above, we import packages and load data using `sns.load_dataset("penguins")`:

````{.python .pymd}
```{{python}}
#| context: setup
import seaborn as sns
from shiny import reactive
from shiny.express import render, ui
penguins = sns.load_dataset("penguins")
```
````

We do this in a setup cell because it would be wasteful in terms of both time and memory to load the data once for each user, instead of once for the process.

By simply adding `#| context: setup` to the code cell, we can tell Quarto to run the code only once, when the Shiny process starts up. Setup cells are a great way to factor out code that you want to run once, not on every page load. Variables you define in setup cells can be read by all other code cells in the document.

### Dashboard Pages

At the top of this dashboard, you can see "Plots" and "Data" headings. These are called **dashboard pages**. Dashboard pages are a way to organize your dashboard into multiple pages, each with its own set of outputs. You can insert dashboard pages by adding level 1 headings to your Markdown. In this case, `# Plots` and `# Data`:

```` {.python .pymd}
# Plots

# Data
````

### Data Frame Outputs

On the Data page, there's a dynamic data frame output. This is created by the following code:

```` {.python .pymd}
```{{python}}
@render.data_frame
def dataview():
    return render.DataGrid(filtered_penguins())
```
````

In a `@render.data_frame` function, you can simply return a Pandas data frame, and Shiny will automatically render it as an interactive data grid. (The `filtered_penguins()` function is a reactive calculation that returns a data frame--we'll explore that next.)

You also have the option of wrapping the data frame object in a [`render.DataGrid`](https://shiny.posit.co/py/api/render.DataGrid.html) or [`render.DataTable`](https://shiny.posit.co/py/api/render.DataTable.html#shiny.render.DataTable) constructor; in this case, we're using the former. This is not strictly necessary, but it allows you to set additional options on the data grid or table, such as filtering and selection.

The only difference between `render.DataGrid` and `render.DataTable` is the appearance of the rendered table: `render.DataGrid` uses a more compact, spreadsheet-like appearance, while `render.DataTable` uses a more traditional table appearance.

### Reactive Calculations

In this example, the user uses select boxes to filter a dataset, and the filtered dataset is displayed in three different dynamic outputs: two plots and a data frame. Remember that as inputs change, Shiny automatically re-executes functions decorated with `@render.plot` and `@render.data_frame` that are affected by those inputs. But where do we put the code that filters the dataset?

The most obvious place would be to duplicate the code in each of the three rendering functions. But this is a bad idea, both because duplicate code is annoying to maintain, and because it would be inefficient to re-run the same filtering code three times just to get the exact same results. We could extract the duplicated code into a function, which would remove the maintenance problem, but it would not be any more efficient.

Shiny has a solution: **reactive calculations**. A reactive calculation is a reactive-aware function that is re-executed whenever its inputs change, but whose return value is not rendered into the dashboard. Instead, the return value is cached, and can be accessed by rendering functions (or even by other reactive calculations). This allows us to place the filtering logic in a single reactive calculation, and then have the three rendering functions access the filtered dataset from the reactive calculation.

To create a reactive calculation, we use the `@reactive.calc` decorator. The following code creates a reactive calculation called `filtered_penguins`:

```` {.python .pymd}
```{{python}}
@reactive.calc
def filtered_penguins():
    data = penguins[penguins["species"].isin(input.species())]
    data = data[data["island"].isin(input.islands())]
    return data
```
````

To read the value of a reactive calc, call it like a function. For example, the `depth` plot looks like this:

```` {.python .pymd}
```{{python}}
@render.plot
def depth():
    return sns.displot(
        filtered_penguins(), x = "bill_depth_mm",
        hue = "species", kind = input.dist(),
        fill = True, rug=input.rug()
    )
```
````

Note the `filtered_penguins()` call. To reiterate, this call does not necessarily cause the `filtered_penguins` function to run. Instead, it usually returns the cached value of the function, which is automatically updated whenever the inputs it refers to change. And because the `depth` plot refers to the `filtered_penguins` calculation, it will be re-rendered whenever those inputs change.

## Learning More

To learn more about Shiny for Python interactive documents see the following articles:

[Component Browser](https://jcheng.shinyapps.io/shiny-component-browser/#outputs) enumerates the available Shiny inputs and outputs, along with code snippets you can copy and paste into your dashboard.

[Input Layout](/docs/dashboards/inputs.qmd) describes various ways to layout Shiny inputs (sidebars, input panels, attaching inputs directly to cards, etc.)

[Running Dashboards](running.qmd) covers in more depth how to run Shiny dashboards both within VS Code and at the command line, as well as how to deploy them to end users.

[Execution Contexts](execution.qmd) goes in depth on when different code cells run (e.g. rendering vs. serving).

[Shiny for Python](https://shiny.posit.co/py/) provides in-depth documentation on all of the available UI and ouput widgets, as well as conceptual discussions on how things work.
```````

## File: docs/dashboards/interactivity/shiny-python/running.qmd
```````
---
title: "Running Dashboards"
lightbox: auto
---

## Overview

There are a number of ways to run Shiny for Python interactive documents:

1.  Use the **Quarto: Preview** command within VS Code.
2.  Use the `quarto preview` command line interface with any editor.
3.  Deploy them to a server for use by a wider audience.

We'll cover all of these scenarios in depth here.

{{< include _shiny-requirements.qmd >}}

## VS Code

The [Quarto VS Code Extension](https://marketplace.visualstudio.com/items?itemName=quarto.quarto) provides integrated support for previewing Shiny interactive documents (just use the **Quarto: Preview** command as you normally would with a static document):

![](images/preview-dashboard.png){.border fig-alt="Screenshot of VS Code with the file shiny.qmd open in the left pane. On the right is a pane labelled Quarto Preview showing the live dashboard."}

Note that you need the very latest version of the VS Code extension (v1.105.0 or greater) to preview Shiny interactive documents.

## Command Line

If you are using another notebook or text editor, you can also preview Shiny interactive documents from the command line via `quarto preview`. This works the same for notebooks (`.ipynb`) and plain text markdown (`.qmd`). For example:

``` {.bash filename="Terminal"}
quarto preview example.ipynb
quarto preview example.qmd
```

There are a number of options to the `preview` command to control the port and host of the document server as well as whether a browser is automatically opened for the running document. You can learn more about these options with `quarto preview help`.

If you want to serve your document without the features of `quarto preview` (i.e. automatic re-rendering when the document changes) you can use the `quarto serve` command:

``` {.bash filename="Terminal"}
quarto serve example.qmd
```


## Deployment

{{< include _shiny-deployment.md >}}


## Debugging

You can run an interactive debugging session for Shiny  documents by debugging the generated `.py` application file (e.g. `hello-app.py`). Use the **Debug Shiny App** menu command at the top right of the editor to launch a debugging session:

![](images/debug.png){.border fig-alt="Screenshot of VS Code with the file hello-app.py open. In the top right, a menu is open from the Run dropdown with the Debug Shiny App item selected."}

::: {.callout-caution title="Important Note"}
The file you are debugging (e.g. `hello-app.py`) is _generated_ from your interactive document. You should therefore not edit this file directly (as it will be overwritten on the next render) but rather the source document from which it is generated (e.g. `hello.qmd`).
:::

## Learning More

To learn more about Shiny for Python interactive documents see the following articles:

-   [Getting Started](index.qmd) explains the basics of Shiny interactive documents.

-   [Component Browser](https://jcheng.shinyapps.io/shiny-component-browser/#outputs) enumerates the available Shiny inputs and outputs, along with code snippets you can copy and paste into your dashboard. 

-   [Input Layout](/docs/dashboards/inputs.qmd) describes various ways to layout Shiny inputs (sidebars, input panels, attaching inputs directly to cards, etc.)


-   [Execution Contexts](execution.qmd) goes in depth on when different code cells run (e.g. rendering vs. serving).

-   [Shiny for Python](https://shiny.posit.co/py/) provides in-depth documentation on all of the available UI and ouput widgets, as well as conceptual discussions on how things work.
```````

## File: docs/dashboards/interactivity/index.qmd
```````
---
title: "Interactive Dashboards"
---

## Overview

Adding interactivity to a dashboard helps uses explore the concepts and data you are presenting more deeply. There are several ways to add interactive components to Quarto dashboards:

- [Shiny for Python](shiny-python/index.qmd) for dashboards that use Jupyter for computations (requires a server component for deployment).

- [Shiny for R](shiny-r.qmd) for dashboards that use Knitr for computations (requires a server component for deployment).

- [Observable JS](observable.qmd) for client-side interactivity using the Observable dialect of JavaScript.

- [Jupyter Widgets](/docs/interactive/widgets/jupyter.qmd) or [htmlwidgets](/docs/interactive/widgets/htmlwidgets.qmd) for client-side interactivity based on standard Python and R JavaScript widget frameworks.

::: {.callout-note appearance="simple"}
Using Shiny-based interactivity is generally much more flexible and capable than client-only interactivity, however requires a server for deployment.
:::

## Input Layout

No matter which type of interactivity you choose, you'll want to present user inputs in a clear, accessible fashion. While you can locate inputs anywhere within a dashboard, there are some special containers that are tuned for this purpose:

- [Sidebars](/docs/dashboards/inputs.qmd#sidebars) provide a collapsible, full height panel for inputs.

- [Toolbars](/docs/dashboards/inputs.qmd#toolbars) provide a full page width horizontal panel for inputs.

- [Card Toolbars](/docs/dashboards/inputs.qmd#card-toolbars) are directly embedded in the header or footer of cards.

The article on [Inputs](/docs/dashboards/inputs.qmd) covers these methods in depth along with tips on doing more sophisticated layout of groups of inputs.
```````

## File: docs/dashboards/interactivity/observable.qmd
```````
---
title: "Dashboards with Observable JS"
code-annotations: select
lightbox: auto
---

## Introduction

Quarto includes native support for [Observable JS](https://observablehq.com/@observablehq/observables-not-javascript), a set of enhancements to vanilla JavaScript created by [Mike Bostock](https://en.wikipedia.org/wiki/Mike_Bostock) (also the author of [D3](https://d3js.org/)). Observable JS is distinguished by its [reactive runtime](https://github.com/observablehq/runtime), which is especially well suited for interactive data exploration and analysis.

The creators of Observable JS (Observable, Inc.) run a hosted service at <https://observablehq.com/> where you can create and publish notebooks. Additionally, you can use Observable JS ("OJS") in standalone documents and websites via its [core libraries](https://github.com/observablehq). Quarto uses these libraries along with a [compiler](https://github.com/asg017/unofficial-observablehq-compiler/tree/beta) that is run at render time to enable the use of OJS within Quarto documents.

## Walkthrough

Quarto Dashboards are a great way to present interactive OJS visualizations. Below we'll provide a complete example which will give you a high level view of the basics. If you want to learn more, please see the complete documentation on [Using OJS with Quarto](/docs/interactive/ojs/index.qmd).

This example covers many of the techniques you'll use when creating dashboards with OJS, including reactive calculations and more advanced layout constructs like sidebars and tabsets. Here is the interactive document we'll be building:

![](../images/penguins-ojs.png){.border fig-alt="A screenshot of a Palmer Penguins dashboard. The navigation bar shows two pages: Plot (active) and Data. On the left a sidebar with an image of penguins and two inputs: a range input for Bill length; and a set of checkboxes for Islands. On the right a plot with histgrams of body mass facetted by sex and species, with bars colored by species."}

The source code for this dashboard is below. Note that we add the <br/>
`//| output: false` option to the first cell: this is to designate the cell as having only intermediate computations (so it should not be turned into a card in the dashboard layout).

Click on the numbers on the far right for additional explanation of syntax and mechanics)

```` {.python .pymd}
---
title: "Palmer Penguins"
author: "Cobblepot Analytics"
format: dashboard
---

```{{ojs}}
//| output: false # <1>

data = FileAttachment("penguins.csv") # <2>
  .csv({ typed: true }) # <2>

filtered = data.filter(function(penguin) {  # <3>
  return bill_length_min < penguin.bill_length_mm && # <3>
         islands.includes(penguin.island); # <3>
}) # <3>
```

# {.sidebar} # <4>

![](images/penguins.png){width="80%"}

```{{ojs}} # <5>
viewof bill_length_min = Inputs.range(
  [32, 50], 
  {value: 35, step: 1, label: "Bill length (min):"}
)
viewof islands = Inputs.checkbox(
  ["Torgersen", "Biscoe", "Dream"], 
  { value: ["Torgersen", "Biscoe", "Dream"], 
    label: "Islands:"
  }
)
``` # <5>

# Plot # <6>

```{{ojs}} # <7>
Plot.rectY(filtered, 
  Plot.binX(
    {y: "count"}, 
    {x: "body_mass_g", fill: "species", thresholds: 20}
  ))
  .plot({
    facet: {
      data: filtered,
      x: "sex",
      y: "species",
      marginRight: 80
    },
    marks: [
      Plot.frame(),
    ]
  }
)
```  # <7>

# Data

```{{ojs}} # <8>
Inputs.table(filtered)
``` # <8>
````

1. We set `output: false` to indicate that this cell includes only intermediate calculations and should not have its contents printed.

2.  We read the raw penguins dataset from a CSV when the page loads.

3.  `filtered` is a value that is automatically recomputed when variables declared with `viewof` change (in this case `bill_length_min` and `islands`).

4.  Create global sidebars by adding the `.sidebar` class to a level 1 heading. Sidebars can include code cells as well as images, narrative, and links.

5.  Here we define our inputs using `viewof` so that the `filtered` dataset is automatically recomputed when they change.

6. Level 1 headings (here `# Plots` and `# Data`) create pages within the dashboard.

7.  The plot is automatically redrawn whenever the `filtered` dataset changes.

8.  The tabular data display is automatically refreshed whenever the `filtered` dataset changes.

## Learning More

To learn more about using OJS with Quarto, see the following articles:

[Input](/docs/dashboards/inputs.qmd) describes various ways to layout  inputs (sidebars, input panels, attaching inputs directly to cards, etc.).

[Using OJS](/docs/interactive/ojs/index.qmd) provides an introduction and overview of other topics.

[OJS Libraries](/docs/interactive/ojs/libraries.qmd) covers using standard libraries and external JavaScript libraries.

[OJS Data Sources](/docs/interactive/ojs/data-sources.qmd) outlines the various ways to read and pre-process data.

[OJS Cells](/docs/interactive/ojs/ojs-cells.qmd) goes into more depth on cell execution, output, and layout.

[OJS Code Reuse](/docs/interactive/ojs/code-reuse.qmd) delves into ways to re-use OJS code across multiple documents.
```````

## File: docs/dashboards/interactivity/shiny-r.qmd
```````
---
title: "Dashboards with Shiny for R"
code-annotations: select
lightbox: auto
---

{{< include /docs/_require-1.4.qmd >}}


## Introduction

The [Shiny](https://shiny.posit.co/r/getstarted/shiny-basics/lesson1/index.html) package provides an easy way to build web applications with R. Quarto dashboards can include embedded Shiny components (e.g. a plot with sliders that control its inputs).

This section covers integrating Shiny with Quarto and assumes that you already have basic familiarity with Shiny. To learn more about Shiny please visit <https://shiny.posit.co/r/getstarted/shiny-basics/lesson1/index.html>. If you are using Python rather than R, see the documentation on using [Shiny for Python](shiny-python/index.qmd).

## Walkthrough

Here we'll explore an in-depth example that covers many of the techniques you'll use when creating dashboards with Shiny, including factoring out setup code, reactive calculations, and more advanced layout constructs like sidebars and tabsets. Here is the interactive document we'll be building:

![](../images/shiny-diamonds.png){.border fig-alt="Screenshot of a Diamonds Explorer App. The navigation bar shows two pages: Plot (active), and Data. On the left a sidebar contains eight inputs: a sample size slider; two checkboxes for Jitter and Smooth (both checked); and a dropdown for each of X, Y, Color, Facet Row and Facet Col. On the right, a plot of cut versus carat using points colored by clarity."}

Here is the source code for this dashboard (click on the numbers on the far right for additional explanation of syntax and mechanics):

```` {.python .pymd}
---
title: "Diamonds Explorer"
author: "Barkamian Analytics"
format: dashboard
server: shiny # <1>
---

```{{r}} # <2>
#| context: setup
library(ggplot2)
dataset <- diamonds
``` # <3>

# {.sidebar} # <3>

```{{r}}
sliderInput('sampleSize', 'Sample Size', 
            min=1, max=nrow(dataset),
            value=min(1000, nrow(dataset)), 
            step=500, round=0)
br()
checkboxInput('jitter', 'Jitter')
checkboxInput('smooth', 'Smooth')
```

```{{r}} # <4>
selectInput('x', 'X', names(dataset)) 
selectInput('y', 'Y', names(dataset), names(dataset)[[2]])
selectInput('color', 'Color', c('None', names(dataset)))
```

```{{r}}
selectInput('facet_row', 'Facet Row',
  c(None='.', names(diamonds[sapply(diamonds, is.factor)])))
selectInput('facet_col', 'Facet Column',
  c(None='.', names(diamonds[sapply(diamonds, is.factor)])))
``` # <4>

# Plot # <5>

```{{r}}
plotOutput('plot')
```

# Data

```{{r}}
tableOutput('data')
``` # <5>

```{{r}}
#| context: server # <6>

dataset <- reactive({ # <7>
  diamonds[sample(nrow(diamonds), input$sampleSize),] # <7>
}) # <7>
 
output$plot <- renderPlot({  # <8>
  
  p <- ggplot(
    dataset(), 
    aes_string(x=input$x, y=input$y)) + geom_point()
  
  if (input$color != 'None')
    p <- p + aes_string(color=input$color)
  
  facets <- paste(input$facet_row, '~', input$facet_col)
  if (facets != '. ~ .')
    p <- p + facet_grid(facets)
  
  if (input$jitter)
    p <- p + geom_jitter()
  if (input$smooth)
    p <- p + geom_smooth()
  
  p
  
})

output$data <- renderTable({ # <9>
  dataset()
})
```
````


1.  The `server: shiny` option instructs Quarto to run a Shiny Server behind the document.

2.  The `context: setup` cell option indicates that this code cell should run when the application starts (as opposed to when each new client session starts). Expensive initialization code (e.g. loading data) should be placed in `context: setup`.

3.  Create global sidebars by adding the `.sidebar` class to level 1 headings. Sidebars can include code cells as well as images, narrative, and links.

4.  These select inputs have their contents dynamically driven from the available columns in the dataset.

5.   Level 1 headings (here `# Plots` and `# Data`) create pages within the dashboard.

6.  Include server code (reactives that compute values or render output) in a cell with `context: server`.

7.  The `dataset()` reactive will be called to re-sample the dataset every time the sample size changes.

8.  The `renderPlot()` function regenerates the plot whenever the `dataset()` reactive or another input option changes.

9. The `renderTable()` function regenerates the table whenever the `dataset()` reactive changes.

## Learning More

To learn more about Shiny for R interactive documents see the following articles:

[Input Layout](/docs/dashboards/inputs.qmd) describes various ways to layout Shiny inputs (sidebars, input panels, attaching inputs directly to cards, etc.)

[Running Documents](/docs/interactive/shiny/running.qmd) covers how to run interactive documents both within RStudio and at the command line, as well as how to deploy them to end users.

[Execution Contexts](/docs/interactive/shiny/execution.qmd) goes in depth on when different code blocks (e.g. rendering vs. serving) run as well as how to cache expensive computations for more responsive documents.

[External Resources](/docs/interactive/shiny/resources.qmd) describes how to make sure that Shiny can locate resources (e.g. CSS, JS, images, etc.) that you include in your document.
```````

## File: docs/dashboards/_inputs.qmd
```````
## Sidebars

Sidebars are a great place to group inputs for Shiny interactive dashboards. To include a sidebar, add the `.sidebar` class to a level 2 heading:

```` {.python .pymd style="overflow-x: hidden;"}
---
title: "Sidebar"
format: dashboard
---

## {.sidebar}

```{{python}}
```

## Column

```{{python}}
```

```{{python}}
```
````

Here's how a sidebar would appear (note there is a button in the top right that enables the user to optionally close the sidebar):

![](/docs/dashboards/images/sidebar.png){.border fig-alt="A screenshot of a Penguin Bills dashboard. A sidebar on the left contains two dropdown menus, one for Variable and one for Distribution and a checkbox to show rugmarks. On the right there are two plots: a histogram of bill_length_mm colored by species and a histogram of bill_depth_mm colored by species."}

### Global Sidebar

If you have a dashboard with [multiple pages](#pages), you may want the sidebar to be global (i.e. visible across all pages). To do this, add the `.sidebar` class to a level 1 heading:

```` {.python .pymd}
---
title: "Sidebar"
format: dashboard
---

# {.sidebar}

Sidebar content

# Plots

```{{python}}
```

# Data

```{{python}}
```
````



## Toolbars

Toolbars are similar to sidebars, but provide a horizontal layout for inputs. Create a toolbar by adding the `.toolbar` class to a level 2 row heading. For example, here we create a toolbar for an interactive dashboard that uses Shiny:

```` {.python .pymd}
---
title: "Toolbar"
format: dashboard
server: shiny
---

## {.toolbar}

```{{python}}
from shiny.express import ui, render
ui.input_select("x", "Variable:",
                choices=["bill_length_mm", "bill_depth_mm"])
ui.input_select("dist", "Distribution:", choices=["hist", "kde"])
ui.input_checkbox("rug", "Show rug marks", value = False)
```

## Row

```{{python}}
@render.plot
def displot():
  sns.displot(
    data=penguins, hue="species", multiple="stack",
    x=input.x(), rug=input.rug(), kind=input.dist())
```
````

### Global Toolbar

If you have a dashboard with [multiple pages](#pages), you may want the toolbar to be global (i.e. visible across all pages). To do this, add the `.toolbar` class to a level 1 heading:


```` {.python .pymd}
---
title: "Toolbar"
format: dashboard
server: shiny
---

# {.toolbar}

Toolbar content

# Page 1

```{{python}}
```

# Page 2

```{{python}}
```
````


## Card Toolbars

In some cases you may want to marry inputs more directly to a single output. To do this, define a card toolbar immediately above the cell that generates the output. You can do this by either adding the `content: card-toolbar` option to a cell or by creating a div with the `.card-toolbar` class. For example:

```` {.python .pymd}
```{{python}}
#| title: Penguin Bills
#| content: card-toolbar
from shiny.express import ui, render
ui.input_select("x", "Variable:",
                choices=["bill_length_mm", "bill_depth_mm"])
ui.input_select("dist", "Distribution:", choices=["hist", "kde"])
ui.input_checkbox("rug", "Show rug marks", value = False)
```

```{{python}}
@render.plot
def displot():
  sns.displot(
    data=penguins, hue="species", multiple="stack",
    x=input.x(), rug=input.rug(), kind=input.dist())
```
````

![](/docs/dashboards/images/card-toolbar.png){.border fig-alt="A screenshot of a Penguin Bills card. The card toolbar contains two dropdown menus, one for Variable and one for Distribution and a checkbox to show rugmarks. Below, a plot shows a histogram of bill_length_mm colored by species."}

Note that the `title` attribute is optional for card toolbars (if there is no title then inputs will left aligned in the place where the title is normallly displayed).
```````

## File: docs/dashboards/_layouts-old.qmd
```````
---
title: "Dashboard Layouts"
---

## Overview

This page includes a variety of sample layouts which you can use as a starting point for your own dashboards.

When creating a layout, it's important to decide up front whether you want your charts to fill the web page vertically (changing in height as the browser changes) or if you want the charts to maintain their original height (with the page scrolling as necessary to display all of the charts).

Filling the page is generally a good choice when you have only one or two charts vertically stacked. Alternatively you can use `scrolling: true` to specify a scrolling layout, which is generally a better choice for three or more charts vertically stacked.

## Chart Stack

This layout is a simple stack of two charts. This dashboard fills the page and allocates height evenly across the two charts.

::: {.chart-example .grid}
::: g-col-6
```` {.python .pymd}
---
title: "Stack"
format: dashboard  
---
    
```{{python}}

```

```{{python}}

```







````
:::

::: g-col-6
![](images/chart-stack-fill.png){fig-alt="Page is split into two equal height rows: Chart 1 is in top row, Chart 2 in bottom row. Dashboard Schematic."}
:::
:::

## Chart Stack (Height)

Here we use the `height` option to allocate more space to the top chart. Note that we don't specify a height on the bottom chart as it will be automatically computed to fill the remaining space.

::: {.chart-example .grid}
::: g-col-6
```` {.python .pymd}
---
title: "Stack w/ Height"
format: dashboard
---
    
```{{python}}
#| height: 70%

```

```{{python}}

```




````
:::

::: g-col-6
![](images/chart-stack-height.png){fig-alt="Page is split into two rows, the top row has a larger height than bottom row. Chart 1 is in top row, Chart 2 in bottom row. Dashboard Schematic."}
:::
:::

## Chart Stack (Scrolling)

This layout is a simple stack of three charts. To provide enough room to display all the charts a scrolling layout is used (`scrolling: true`). Note that because of its ability to scroll this layout could easily accommodate many more charts.

::: {.chart-example .grid}
::: g-col-6
```` {.python .pymd}
---
title: "Stack (Scrolling)"
format: 
  dashboard:
    scrolling: true 
---
    
```{{python}}
```

```{{python}}
```

```{{python}}
```

````
:::

::: g-col-6
![](images/chart-stack-scrolling.png){fig-alt="Page is split into three equal height rows. Chart 1 is in top row, Chart 2 in middle row, Chart 3 in bottom row. Dashboard Schematic."}
:::
:::

## Focal Chart (Top)

This layout fills the page completely and gives prominence to a single chart at the top (with two secondary charts included below). To achieve this layout it specifies `height` attributes on each row to establish their relative sizes.

::: {.chart-example .grid}
::: g-col-6
```` {.python .pymd}
---
title: "Focal (Top)"
format: dashboard
---
    
## Row {height=70%}

```{{python}}
```

## Row {height=30%}

```{{python}}
```

```{{python}}
```
````
:::

::: g-col-6
![](images/chart-focal-top.png){fig-alt="Page is split into two rows. The top row has a larger height than the second row. Chart 1 is in the top row and spans the full page width. The bottom row is split into two equal width columns. Chart 3 is in the left column; Chart 4 is in the right column. Dashboard Schematic."}
:::
:::

## Focal Chart (Left)

This layout fills the page completely and gives prominence to a single chart on the left (with two secondary charts included to the right). To achieve this layout we use `orientation: columns` (so that top level headings map to columns rather than rows). Additionally, we specify `width` attributes on each column to establish their relative sizes.

::: {.chart-example .grid}
::: g-col-6
```` {.python .pymd}
---
title: "Focal (Left)"
format: 
  dashboard:
    orientation: columns
---
    
## Column {width=60%}

```{{python}}
```

## Column {width=40%}

```{{python}}
```

```{{python}}
```
````
:::

::: g-col-6
![](images/chart-focal-left.png){fig-alt="Page is split into two columns. The left column is wider than the right, and contains Chart 1 spanning the full page height. The second column is split into two equal height rows: Chart 2 in the top row, and Chart 3 in the bottom row. Dashboard Schematic."}
:::
:::

## Chart Grid (2x2)

This layout is a 2x2 grid of charts. This layout uses the default filling behavior however depending on the ideal display size for the charts it might be preferable to allow the page to scroll (`scrolling: true`).

::: {.chart-example .grid}
::: g-col-6
```` {.python .pymd}
---
title: "Grid (2x2)"
format: dashboard
---
    
## Row 

```{{python}}
```

```{{python}}
```

## Row

```{{python}}
```

```{{python}}
```
````
:::

::: g-col-6
![](images/chart-grid.png){fig-alt="Page is split into a grid with two equal height rows and two equal width columns. Chart 1 top left; Chart 2 top right; Chart 3 bottom left; Chart 4 bottom right. Dashboard Schematic."}
:::
:::

## Multiple Pages

This layout defines multiple pages using level 1 markdown headers. Each page has its own top-level navigation tab. Further, the second page uses a distinct orientation via the `orientation` attribute. The use of multiple columns and rows with custom `width` and `height` attributes is also demonstrated.

````{.python .pymd}
---
title: "Multiple Pages"
format: dashboard
---

# Page 1
    
## Column {width="60%"}
    
```{{python}}
```
   
## Column {width="40%"}
   
```{{python}}
```  

# Page 2 {orientation="rows"}
   
## Row {height="60%"}
 
```{{python}}
```

## Row {height="40%"}
   
```{{python}}
```
    
````

## Tabset (Column)

This layout displays the right column as a set of two tabs. Tabs are especially useful when you have a large number of components to display and prefer not to require the user to scroll to access everything. Note that we specify a `title` option in each of the cells that produce a tab.

::: {.chart-example .grid}
::: g-col-6
```` {.python .pymd}
---
title: "Tabset (Column)"
format: 
  dashboard:
    orientation: columns
---
    
## Column

```{{python}}
```

## Column {.tabset}

```{{python}}
#| title: Chart 2
```

```{{python}}
#| title: Chart 3
```
````
:::

::: g-col-6
![](images/chart-tabset-column.png){fig-alt="Page is split into two equal width columns. The left column has Chart 1 spanning the full page height. The right column has a tabset spanning the full page height: Chart 2 is selected; Chart 3 is unselected. Dashboard Schematic."}
:::
:::

## Tabset (Row)

This layout displays the bottom row as a set of two tabs.

::: {.chart-example .grid}
::: g-col-6
```` {.python .pymd}
---
title: "Tabset (Row)"
format: dashboard
---
    
## Row

```{{python}}
```

## Row {.tabset}

```{{python}}
#| title: Chart 2
```

```{{python}}
#| title: Chart 3
```
````
:::

::: g-col-6
![](images/chart-tabset-row.png){fig-alt="Page is split into two equal height rows. The top row has Chart 1 spanning the full page width. The bottom row has a tabset spanning the full page width: Chart 2 is selected; Chart 3 is unselected. Dashboard Schematic."}
:::
:::

## Tabset (Nested)

You can include tabsets as arbitrarily deep levels. Here we include a tabset within a column of a top level row.

::: {.chart-example .grid}
::: g-col-6
```` {.python .pymd}
---
title: "Tabset (Card)"
format: dashboard
---
    
## Row {height=70%}

```{{python}}
```

## Row {height=30%}

### Column {.tabset}

```{{python}}
#| title: Chart 2
```

```{{python}}
#| title: Chart 3
```

### Column

```{{python}}
```
````
:::

::: g-col-6
![](images/chart-tabset-card.png){fig-alt="Page is split into two rows: the first higher than the second. Chart 1 is in the top row and spans the full page width. The bottom row is split into two equal width columns. The left column has a tabset: Chart 2 is selected; Chart 3 is unselected. The right column contains Chart 4. Dashboard Schematic."}
:::
:::

## Input Sidebar

This layout demonstrates how to add a sidebar to a dashboard page (Shiny or ObservableJS based dashboards will often present user input controls in a sidebar). To include a sidebar you add the `.sidebar` class to a level 2 heading

::: {.chart-example .grid}
::: g-col-6
```` {.python .pymd}
---
title: "Sidebar"
format: dashboard
---
    
## {.sidebar}

```{{python}}
```

## Column 

```{{python}}
```

```{{python}}
```
````
:::

::: g-col-6
![](images/chart-input-sidebar.png){fig-alt="Page is split into two columns. The column on the left is narrower than the right, and has a grey background representing the sidebar. The column on the right is split into two rows: Chart 1 in the top row; Chart 2 in the bottom row. Dashboard Schematic."}
:::
:::

## Global Sidebar

If you have a dashboard with [multiple pages](#multiple-pages), you may want the sidebar to be global (i.e. visible across all pages). To do this, add the `.sidebar` class to a level one heading:

```` {.python .pymd}
---
title: "Sidebar"
format: dashboard
---
    
# {.sidebar}

Sidebar content

# Page 1 

```{{python}}
```

# Page 2

```{{python}}
```
````


## Input Toolbar

Toolbars are similar to sidebars, but provide a horizontal layout for inputs. Create a toolbar by adding the `.toolbar` class to a row heading. For example:


```` {.python .pymd}
    
## {.toolbar}
    
```{{python}}
```

## Row

```{{python}}
```
````

## Card Toolbar

In some cases you may want to marry inputs more directly to a single output. To do this, define a card toolbar immediately above the cell that generates the output. For example:

```` {.python .pymd}     
```{{python}}
#| content: card-toolbar
```

```{{python}}
```
````


## Learning More


[Dashboard Components](components.qmd) shows you how to control the navigation bar, and how to arrange your content across pages, rows, columns, tabsets, sidebars, and cards.

[Data Display](data-display.qmd) shows you how to display data in your dashboard as plots, tables, value boxes, and text.

[Examples](/docs/gallery/index.qmd#dashboards) provides a gallery of example dashboards you can use as inspiration for your own.

[Theming](theming.qmd) describes the various way to customize the fonts, colors, layout and other aspects of dashboard appearance.

[Parameters](parameters.qmd) explains how to create dashboard variants by defining parameters and providing distinct values for them on the command line.

[Deployment](deployment.qmd) covers how to deploy both static dashboards (which require only a web host, but not a server) and Shiny dashboards (which require a Shiny Server).

[Interactivity](interactivity/index.qmd) explores the various ways to create interactive dashboards that enable more flexible data exploration.
```````

## File: docs/dashboards/data-display.qmd
```````
---
title: "Dashboard Data Display"
lightbox: auto
aliases: 
  - data-presentation.html
---

{{< include /docs/_require-1.4.qmd >}}

Dashboards are compositions of components used to provide navigation and present data. Below we'll cover presenting data using plots, tables, and value boxes, as well how to include narrative content within dashboards.

## Plots

Plots are by far the most common content type displayed in dashboards. Both interactive JavaScript-based plots (e.g. [Altair](https://altair-viz.github.io) and [Plotly](https://plotly.com/graphing-libraries/)) and standard raster based plots (e.g. [Matplotlib](https://matplotlib.org) or [ggplot2](https://ggplot2.tidyverse.org)) are supported.

Below we provide some language specific tips and techniques for including plots within dashboards.

::: {.panel-tabset group="language"}
## Python

### plotly

[Plotly](https://plotly.com/python/) is a popular Python package for JavaScript based plots, and works very well in dashboard layouts. Plotly is also noteworthy because it includes many interactive features while still not requiring a server. For example, this plot supports an animated display of values changing over time:

```` {.python .pymd}
```{{python}}
#| title: GDP and Life Expectancy
import plotly.express as px
df = px.data.gapminder()
px.scatter(
  df, x="gdpPercap", y="lifeExp", 
  animation_frame="year", animation_group="country",
  size="pop", color="continent", hover_name="country", 
  facet_col="continent", log_x=True, size_max=45, 
  range_x=[100,100000], range_y=[25,90]
)
```
````

![](images/plotly-interactive.png){fig-alt="Screenshot of a card titled GDP and Life Expectancy. The card contains a plot with a set of scatterplots. Below the plot is a slider of years with a play and stop button."}

### altair

[Altair](https://altair-viz.github.io) is a declarative statistical visualization library for Python based on Vega and Vega-Lite. Altair plots are JavaScript based so automatically resize themselves to fit their container within dashboards.

```` {.python .pymd}
```{{python}}
#| title: Iowa Electricity
import altair as alt
from vega_datasets import data
source = data.iowa_electricity()
alt.Chart(source).mark_area(opacity=0.3).encode(
  x="year:T",
  y=alt.Y("net_generation:Q").stack(None),
  color="source:N"
)
```
````

![](images/altair.png)

### matplotlib

{{< include _plots-raster.md >}}

If you are using [Matplotlib](https://matplotlib.org) (or libraries built on it like [Seaborn](https://seaborn.pydata.org)) then you can set plot sizes using the `figure.figsize` global option (or alternatively per-figure if that's more convenient):

```` python
```{{python}}
import matplotlib.pyplot as plt
plt.rcParams['figure.figsize'] = (12, 3)
```
````

In the case that your plots are laid out at a wider aspect ratio, setting this option can make a huge difference in terms of using available space. For example, the top plot in the stack below uses the default figure size of 8 x 5 and the bottom one uses the 12 x 3 ratio specified above:

![](images/matplotlib-size.png){fig-alt="Screenshot of a two cards one above the other. The top card contains a plot with large areas of white space on either side. The bottom card contains the same plot but resized to reduce the white space."}

Note that the need to explicitly size plots is confined to traditional plotting libraries---if you use Plotly or another JavaScript based plotting system plots will automatically resize to fill their container.

## R

### htmlwidgets

The [htmlwidgets](https://www.htmlwidgets.org/) framework provides high-level R bindings for JavaScript data visualization libraries. Some popular htmlwidgets include [Plotly](https://plot.ly/r/), [Leaflet](https://rstudio.github.io/leaflet/), and [dygraphs](https://rstudio.github.io/dygraphs).

You can use htmlwidgets just like you use normal R plots. For example, here is how we embed a Leaflet map:

```` python
```{{r}}
library(leaflet)
leaflet() %>%
  addTiles() %>% 
  addMarkers(lng=174.768, lat=-36.852, 
             popup="The birthplace of R")
```
````

There are dozens of packages on CRAN that provide htmlwidgets. You can find example uses of several of the more popular htmlwidgets in the htmlwidgets [showcase](https://www.htmlwidgets.org/showcase_leaflet.html) and browse all available widgets in the [gallery](https://gallery.htmlwidgets.org).

### R Graphics

You can use any chart created with standard R raster graphics (base, lattice, grid, etc.) within dashboards. When using standard R graphics with static dashboards, you'll need to pay a bit more attention to getting the size of plots right for the layout they'll be viewed in. Note that this is not a concern for plots in interactive Shiny dashboards since all plot types are resized dynamically by Shiny.

The key to good sizing behavior in static dashboards is to define knitr `fig-width` and `fig-height` options that enable the plots to fit into their layout container as closely as possible.

Here's an example of a layout that includes 3 charts from R base graphics:

```` {.python .pymd}
## Row {height="65%"}

```{{r}}
#| fig-width: 10
#| fig-height: 8
plot(cars)
```

## Row {height="35%"}
        
```{{r}}
#| fig-width: 5
#| fig-height: 4
plot(pressure)
```
    
```{{r}}
#| fig-width: 5
#| fig-height: 4
plot(airmiles)
```
````

We've specified an explicit `fig-height` and `fig-width` for each plot so that their rendered size fits their layout container as closely as possible. Note that the ideal values for these dimensions typically need to be determined by experimentation.
:::

::: callout-tip
{{< include _plots-interactive.md >}}
:::

## Tables

You can include data tables within dashboards in one of two ways:

-   As a simple tabular display.
-   As an interactive widget that includes sorting and filtering.

Below we provide some language specific tips and techniques for including tables within dashboards.

::: {.panel-tabset group="language"}
## Python

There are many Python packages available for producing tabular output. We'll cover two of the more popular libraries (itables and tabulate) below.


### itables

The Python [itables](https://mwouts.github.io/itables/quick_start.html) package supports creating interactive data tables from Pandas and Polars DataFrames that you can sort and filter.

Use the `show()` method from `itables` to display an interactive table:

```` python
```{{python}}
from itables import show
show(penguins)
```
````

![](images/itables-scrolling.png){fig-alt="Screenshot of a card showing a table of penguins data. Above the table a Search box appears. The data frame column names appear bold in a row at top and each columns has sorting buttons."}


#### Options

Note that a few `itables` options are set automatically within dashboards to ensure that they display well in cards of varying sizes. The option defaults are:

``` python
from itables import options
options.dom = 'fiBrtlp'
options.maxBytes = 1024 * 1024
options.language = dict(info = "Showing _TOTAL_ entries")
options.classes = "display nowrap compact"
options.paging = False
options.searching = True
options.ordering = True
options.info = True
options.lengthChange = False
options.autoWidth = False
options.responsive = True
options.keys = True
options.buttons = []
```

You can specify alternate options as you like to override these defaults. Options can be specified in the call to `show()` or globally as illustrated above. Here's an example of specifying an option with `show()`:

```python
show(penguins, searching = False, ordering = False)
```

You can find the reference for all of the DataTables options here: <https://datatables.net/reference/option/>. All base options are available, as well as the options for the following extensions (which are automatically included by Quarto):

- <https://datatables.net/extensions/buttons/>
- <https://datatables.net/extensions/keytable/>
- <https://datatables.net/extensions/responsive/>

For example, to enable the copy and export (excel/pdf) buttons in a call to `show()`:

```python
show(penguins, buttons = ['copy', 'excel', 'pdf'])
```

Or alternatively, to enable these buttons for all tables:

``` python
from itables import options
options.buttons = ['copy', 'excel', 'pdf']
```


#### Downsampling

When a table is displayed, the table data is embedded in the dashboard output. To prevent dashboards from being too heavy to load for larger datasets, itables will display only a subset of the table---one that fits into `maxBytes` (1024kb by default).

If you wish, you can increase the value of `maxBytes` or even deactivate the limit (with `maxBytes=0)`. For example, to set a limit of 200kb:

```` python
```{{python}}
show(penguins, maxBytes = 200 * 1024)
```
````


### tabulate

The Python [tabulate](https://github.com/astanin/python-tabulate) package supports creating markdown tables from Pandas data frames, NumPy arrays, and many other data types. You can generate a markdown table from any Pandas data frame via the `to_markdown()` method (being sure to wrap it as `Markdown` output using IPython):

```` python
```{{python}}
import pandas as pd
from IPython.display import Markdown
penguins = pd.read_csv("penguins.csv")
Markdown(penguins.to_markdown(index=False))
```
````

Note that the `index = False` parameter supresses the display of the row index. Here is a card containing output from `tabulate`:

![](images/tabulate.png){fig-alt="Screenshot of a card showing a table of penguins data. The data frame column names appear bold in a row at top. Data rows have a background that alternates between white and grey."}

You can also import `tabulate` directly and pass in the object to print directly:

```` python
```{{python}}
from tabulate import tabulate
Markdown( 
  tabulate(penguins, showindex=False, 
           headers=penguins.columns)
)
```
````

## R

There are many R packages available for producing tabular output. We'll cover two of the more popular approaches (kable and DT) below.

### kable

Simple markdown tables are ideal for smaller numbers of records (i.e. 20-250 rows). Use the `knitr::kable()` function to output markdown tables:

```` {.python .pymd}
```{{r}}
knitr::kable(mtcars)
```
````

![](images/kable.png){fig-alt="Screenshot of a card showing a table of penguins data. The data frame column names appear bold in a row at top. Data rows have a background that alternates between white and grey."}

Simple markdown tables in dashboards automatically fill their container (scrolling horizontally and vertically as required).

### DT

The [DT](https://rstudio.github.io/DT/) package (an interface to the DataTables JavaScript library) can display R matrices or data frames as interactive HTML tables that support filtering, pagination, and sorting.

To include a DataTable you use the `DT::datatable` function:

```` {.python .pymd}
```{{r}}
library(DT)
datatable(mtcars)
```
````

![](images/dt.png){fig-alt="Screenshot of a card showing a table of penguins data. Above the table a Search box appears. The data frame column names appear bold in a row at top and each columns has sorting buttons."}

#### Options

Note that a few `DT` options are set automatically within dashboards to ensure that they display well in cards of varying sizes. The option defaults are:

``` r
options(DT.options = list(
  bPaginate = FALSE, 
  dom = "ifrt", 
  language = list(info = "Showing _TOTAL_ entries")
))
```

You can specify alternate options as you like to override these defaults.
:::

## Value Boxes

Value boxes are a great way to prominently display simple values within a dashboard. For example, here is a dashboard row with three value boxes:

![](images/value-boxes.png){fig-alt="A row of three value boxes. The first has a grey background, a large pencil icon, small text that says Articles per day, and a large number 45. The second has a grey background, a large comment icon, small text that says Comments per day, and a large number 126. The third has a yellow background, a large trashcan icon, small text that says Spam per day, and a large number 50. "}

Here is the code you might use to create these value boxes. Note that we use a mix of Python and R cells in this example to illustrate the syntax for each language. Note also that we assume the variables `articles`, `comments`, and `spam` are computed previously within the document.

```` {.python .pymd}
## Row 

```{{python}}
#| content: valuebox
#| title: "Articles per day"
#| icon: pencil
#| color: primary
dict(
  value = articles
)
```

```{{python}}
#| content: valuebox
#| title: "Comments per day"
dict(
  icon = "chat",
  color = "primary",
  value = comments
)
```

```{{r}}
#| content: valuebox
#| title: "Spam per day"
list(
  icon = "trash",
  color = "danger",
  value = spam
)
```
````

You can choose between specifying value box options within YAML or within a `dict()` or `list()` (for Python and R, respectively) printed by the cell. The latter syntax is handy when you want the `icon` or `color` to be dynamic based on the value.

### Icon and Color

The `icon` used in value boxes can be any of the 2,000 available [bootstrap icons](https://icons.getbootstrap.com).

The `color` can be any CSS color value, however there are some color aliases that are tuned specifically for dashboards that you might consider using by default:

{{< include _valuebox-colors.md >}}

You can override these defaults by specifying [value box Sass variables](theming.qmd#value-boxes) in a custom theme.

While the aliases apply to all [themes](theming.qmd), the colors they correspond to vary.

### Shiny

In a Shiny interactive dashboard you can have value boxes that update dynamically based on the state of the application. The details on how to do this are language-specific:

::: {.panel-tabset group="language"}
#### Python

Use the `ui.value_box()` function within a function decorated with `@render.ui`. For example:

```` python
```{{python}}
from shiny.express import render, ui
@render.ui
def value():
    return ui.value_box("Value", input.value())
```
````

#### R

Use the `bslib::value_box()` function along with an optional icon drawn from the `bsicons` package. For example:

```` python
```{{r}}
library(bslib)
library(bsicons)
value_box(
  title = "Value",
  value = textOutput("valuetext"),
  showcase = bs_icon("music-note-beamed")
)
```
````
:::

### Markdown Syntax

You can also create value boxes using plain markdown, in which case you'll typically include the value via an inline expression. For example:

``` {.python .pymd}
## Row

::: {.valuebox icon="pencil" color="blue"}
Articles per day

`{python} articles`
:::
```

## Text Content

While you often fill dashboard cards with plots and tables, you can also include arbitrary markdown content anywhere within a dashboard.

### Content Cards

Here is a dashboard where the last card in a column is plain markdown:

![](images/text-content-column.png){.border fig-alt="Screenshot of a dashboard with three cards arranged vertically in a column. The first two cards contain plots, the last card contains text that begins 'Gapminder combines data ...'."}

To do this just include a `.card` div alongside the other cells:

```` {.python .pymd}
## Column

```{{python}}
#| title: Population
px.area(df, x="year", y="pop", color="continent", 
        line_group="country")
```

```{{python}}
#| title: Life Expectancy
px.line(df, x="year", y="lifeExp", color="continent", 
        line_group="country")
```

::: {.card}
Gapminder combines data from multiple sources into
unique coherent time-series that can’t be found
elsewhere. Learn more about the Gampminder dataset at
<https://www.gapminder.org/data/>.
:::
````

Note that if you are authoring using a Jupyter Notebook then markdown cells automatically become `.card` divs (i.e. they don't need the explicit `:::` div enclosure).

### Content within Cells

To include content alongside the ouptut of a cell, just enclose the both the cell and the content in a `.card` div. For example:

```` {.python .pymd}
::: {.card title="Life Expectancy"}

```{{python}}
px.line(df, x="year", y="lifeExp", color="continent", 
        line_group="country")
```

Gapminder combines data from multiple sources into
unique coherent time-series that can’t be found
elsewhere. Learn more about the Gampminder dataset at
<https://www.gapminder.org/data/>.
:::
````

![](images/text-content-fused.png){.border fig-alt="Screenshot of a single card. The card contains a plot then text below it that begins 'Gapminder combines data...'."}

### Leading Content

Content that is included at the very top of a dashboard (and not explicitly within a `.content` div) is considered leading content, and will be included as is with no card styling (e.g. with no border). For example:

```` {.python .pymd}
---
title: "My Dashboard"
format: dashboard
---

This content will appear above all of the other 
rows/columns, with no border.

## Row

```{{python}}
```
````

### Dynamic Content

You can use [inline expressions](/docs/computations/inline-code.qmd) to make text content dynamic. For example, here we have a row with text content that makes use of Python expressions:

``` {.python .pymd}
::: {.card}
The sample size was `{python} sample`. The mean reported 
rating was `{python} rating`.
:::
```

## Cell Output {#cell-output}

The output of each computational cell within your notebook or source document will be contained within a [Card](layout.qmd#cards). Below we describe some special rules observed when creating cards.

### Dynamic Titles

You can create a dynamic `title` by printing a `title=` expression as a cell's first output (in contrast to including the `title` as a YAML cell option). For example:

{{< include _dynamic-title.md >}}

### Excluded Cells

Cells that produce no output do not become cards (for example, cells used to import packages, load and filter data, etc). If a cell produces unexpected output that you want to exclude add the `output: false` option to the cell:

```` {.python .pymd}
```{{python}}
#| output: false
# (code that produces unexpected output)
```
````

### Expression Printing

By default, all output from top level expressions is displayed within dashboards. This means that multiple plots can easily be generated from a cell. For example:

```` {.python .pymd}
```{{python}}
#| title: "Tipping Behavior"
px.box(df, x="sex", y="total_bill", color="smoker")
px.violin(df, x="sex", y="total_bill", color="smoker")
```
````

This behavior corresponds to the `"all"` setting for [Jupyter shell interactivity](https://ipython.readthedocs.io/en/stable/config/options/terminal.html#configtrait-InteractiveShell.ast_node_interactivity). You can customize this behavior within Quarto using the `ipynb-shell-interactivity` option.

### Card Layout

If a cell produces multiple outputs you can use cell layout options to organize their display. For example, here we modify the example to display plots side-by-side using the `layout-ncol` option:

```` {.python .pymd}
```{{python}}
#| title: "Tipping Behavior"
#| layout-ncol: 2
px.box(df, x="sex", y="total_bill", color="smoker")
px.violin(df, x="sex", y="total_bill", color="smoker")
```
````

![](images/card-layout-ncol.png){fig-alt="A screenshot of a dashboard card with the title Tipping behavior showing two plots side by side."}

See the article on [Figures](/docs/authoring/figures.qmd#complex-layouts) for additional documentation on custom layouts.

## Learning More

[Layout](layout.qmd) shows you how to control the navigation bar, and how to arrange your content across pages, rows, columns, tabsets, and cards.

[Inputs](inputs.qmd) demonstrates various ways to layout inputs for interactive dashboards (sidebars, toolbars, attaching inputs directly to cards, etc.)

[Examples](/docs/gallery/index.qmd#dashboards) provides a gallery of example dashboards you can use as inspiration for your own.

[Theming](theming.qmd) describes the various way to customize the fonts, colors, layout and other aspects of dashboard appearance.

[Parameters](parameters.qmd) explains how to create dashboard variants by defining parameters and providing distinct values for them on the command line.

[Deployment](deployment.qmd) covers how to deploy both static dashboards (which require only a web host, but not a server) and Shiny dashboards (which require a Shiny Server).

[Interactivity](interactivity/index.qmd) explores the various ways to create interactive dashboards that enable more flexible data exploration.
```````

## File: docs/dashboards/deployment.qmd
```````
---
title: "Dashboard Deployment"
lightbox: auto
---

## Overview

There are a wide variety of ways to deploy dashboards created using Quarto. The mechanics of deployment are different depending on whether you are publishing a [Static Dashboard](#static-dashboards) (with no server dependencies) or a [Shiny Dashboard](#shiny-dashboards). Both scenarios are covered in detail below.

## Static Dashboards {#static-dashboards}

If you are deploying a static dashboard (i.e. not using Shiny for interactivity) then you can publish dashboards to any web server. Quarto includes a `quarto publish` command to make it easy to publish to a few popular services as well as automate publishing via Continuous Integration (CI).

To get started, review the documentation for using one of the following publishing services:

{{< include /docs/publishing/_providers.md >}}

```{=html}
<style type="text/css">
/* remove confluence */
#static-dashboards table tr:nth-child(5) {
  display: none;
}
</style>
```
## Shiny Dashboards {#shiny-dashboards}

Dashboards that use [Shiny for Python](/docs/dashboards/interactivity/shiny-python/index.qmd) or [Shiny for R](/docs/dashboards/interactivity/shiny-r.qmd) are web applications that require a server for deployment (so they can't just be deployed to a generic web host). Deployment options for Shiny applications include:

-   Public hosting services like [shinyapps.io](https://www.shinyapps.io) and [Hugging Face](https://huggingface.co/docs/hub/spaces-sdks-docker-shiny).

-   [Shiny Server](https://posit.co/products/open-source/shinyserver/) (an open-source server developed by the Shiny team).

-   [Posit Connect](https://posit.co/products/enterprise/connect/) (an on-premises commercial server product).

Below we'll cover some deployment basics for Python and R and provide links to additional documentation on using the various available methods.

### Shiny for Python

{{< include interactivity/shiny-python/_shiny-deployment.md >}}

### Shiny for R

Quarto Dashboards that use Shiny for R can be deployed using all of the tooling and services available for normal Shiny applications. Shiny for R dashboards are run using the `quarto serve` command:

``` {.bash filename="Terminal"}
quarto serve dashboard.qmd
```

The `quarto serve` command is supported natively by [shinyapps.io](https://www.shinyapps.io), [Shiny Server](https://posit.co/products/open-source/shinyserver/) , and [Posit Connect](https://posit.co/products/enterprise/connect/). See the in-depth documentation on [Shiny for R Deployment](/docs/interactive/shiny/running.qmd#deployment) for details.
```````

## File: docs/dashboards/index.qmd
```````
---
title: "Quarto Dashboards"
code-annotations: select
lightbox: auto
format:
  html:
    include-in-header: 
      - '../download/_download.html'
    include-after-body: 
      text: |
        <script type="text/javascript">
        window['quarto-download-release'] = true;
        window['quarto-download-prerelease'] = true;
        window['quarto-download-nonews'] = true;
        window["quarto-prerelease-mode"] = '{{< meta prerelease-mode >}}';
        </script>   
---

{{< include /docs/_require-1.4.qmd >}}

## Overview

Quarto Dashboards make it easy to create interactive dashboards using Python, R, Julia, and Observable:

-   Publish a group of related data visualizations as a dashboard. Use a wide variety of components including [Plotly](https://plotly.com/python/), [Leaflet](https://ipyleaflet.readthedocs.io/en/latest/), [Jupyter Widgets](/docs/interactive/widgets/jupyter.qmd), [htmlwidgets](https://www.htmlwidgets.org/); static graphics (Matplotlib, Seaborn, ggplot2, etc.); tabular data; value boxes; and text annotations.

-   Flexible and easy to specify row and column-based [Layouts](layout.qmd). Components are intelligently re-sized to fill the browser and adapted for display on mobile devices.

-   Author using any notebook editor ([JupyterLab](/docs/tools/jupyter-lab.qmd), etc.) or in plain text markdown with any text editor ([VS Code](/docs/tools/vscode/index.qmd), [RStudio](/docs/tools/rstudio.qmd), [Neovim](/docs/tools/neovim.qmd), etc.)

-   Dashboards can be deployed as static web pages (no special server required) or you can optionally integrate a backend [Shiny Server](/docs/dashboards/interactivity/shiny-python/index.qmd) for enhanced interactivity.

## Examples

You can create highly customized layouts and use a wide variety of dashboard themes as illustrated in these examples (click to see them in more detail):

::: {layout-ncol="3"}
![](/docs/dashboards/examples/thumbnails/stock-explorer-dashboard.png){.border fig-alt="Screenshot of a Stock Trader dashboard: a row of three values boxes, then a row with a stock ticker graph and a table of closing values. Navy blue and green theme."}

![](/docs/dashboards/examples/thumbnails/customer-churn-dashboard.png){.border fig-alt="Screenshot of a Customer Churn dashboard: a row of three values boxes, then a row with two plots, then a row with a table. Light blue and yellow theme."}

![](/docs/dashboards/examples/thumbnails/penguins-dashboard.png){.border fig-alt="Screenshot of a Palmer Penguins dashboard: a sidebar with checkboxes and a dropdown, and two plots in main panel. Blue theme."}
:::

For live versions of these dashboards, source code, and additional examples see the [dashboard section of the gallery](/docs/gallery/index.qmd#dashboards).

## Walkthrough

Here we'll walk through a simple example to illustrate the basics. Then, we'll provide detailed instructions on how to get started with building your own dashboards.

This simple single-page Python dashboard uses interactive Plotly visualizations to explore development indicators in the [Gapminder](http://www.gapminder.org/data/) dataset. The dashboard includes two rows, the second of which includes two columns:

![](images/gapminder.png){.border fig-alt="Screenshot of a Development Indicators dashboard: a row titled GDP and Life Expectancy with a single plot, then a row with two plots arranged side by side titled Population and Life Expectancy."}

Dashboards consist of several components:

1)  **Navigation Bar** --- Icon, title, and author along with links to sub-pages (if more than one page is defined).

2)  **Pages, Rows, Columns, and Tabsets** --- Pages, rows and columns are defined using markdown headings (with optional attributes to control height, width, etc.). Tabsets can be used to further divide content within a row or column.

3)  **Cards, Sidebars, and Toolbars** --- Cards are containers for plots, data display, and free form content. The content of cards typically maps to *cells* in your notebook or source document. Sidebars and toolbars are used to present inputs within interactive dashboards.

Dashboards can be created either using Jupyter notebooks (`.ipynb`) or using plain text markdown (`.qmd`). Here is the code for the notebook version of the above example (click the image for a zoomed view):

![](images/gapminder-jupyter.png){.border fig-alt="Screenshot of a gapminder-notebook.ipynb open in Jupyter Lab. After cells for Quarto settings and python setup, there is a markdown cell containing the heading Row, followed by a python code cell generating a plot. Then another markdown cell containing the heading Row, followed by two python code cells each generating a plot."}

Here is the plain text `.qmd` version of the dashboard (click on the numbers on the far right for additional explanation of syntax and mechanics):

```` python
--- 
title: "Development Indicators by Continent" # <1>
author: "Gapminder Analytics Group" # <1>
format: dashboard # <1>
--- 

```{{python}}
import plotly.express as px
df = px.data.gapminder()
```

## Row {height=60%} # <2>

```{{python}}  # <3>
#| title: GDP and Life Expectancy 
px.scatter(  
  df, x="gdpPercap", y="lifeExp", 
  animation_frame="year", animation_group="country", 
  size="pop", color="continent", hover_name="country",
  facet_col="continent", log_x=True, size_max=45, 
  range_x=[100,100000], range_y=[25,90] 
)  
``` # <3>

## Row {height=40%}

```{{python}} # <4>
#| title: Population
px.area(
  df, x="year", y="pop", 
  color="continent", line_group="country"
)
```

```{{python}}
#| title: Life Expectancy
px.line(
  df, x="year", y="lifeExp", 
  color="continent", line_group="country"
)
``` # <4>
````

1.  The document options define the `title` and `author` for the navigation bar as well as specifying the use of the `dashboard` format.
2.  Rows and columns are defined using headings. In this example we define two rows and specify their relative sizes using the `height` option.
3.  Computational cells become cards that live within rows or columns. Cards can have an optional title (which here we specify using the `title` option).
4.  The second row includes two computational cells, which are automatically split into two side by side cards.

## Getting Started

### Step 1: Install Quarto

Dashboards are a feature in the Quarto v1.4. Before you get started, make sure you install the **latest release** version of Quarto.

{{< include ../download/_download.md >}}

```{=html}
<style type="text/css">
#download-table {
  display: none;
}
</style>
```

You can find release notes and installers for all platforms in the [download page](/docs/download/prerelease.qmd).

### Step 2: Learn the Basics

Start by learning how to lay out your dashboard and populate it with content:

[Dashboard Layout](layout.qmd) shows you how to control the navigation bar, and how to arrange your content across pages, rows, columns, tabsets, and cards.

[Data Display](data-display.qmd) shows you how to display data in your dashboard as plots, tables, value boxes, and text.

### Step 3: Explore Further

Once you've mastered the basics, check out these additional articles to learn more.

[Examples](/docs/gallery/index.qmd#dashboards) provides a gallery of example dashboards you can use as inspiration for your own.

[Inputs](inputs.qmd) demonstrates various ways to layout inputs for interactive dashboards (sidebars, toolbars, attaching inputs directly to cards, etc.)

[Theming](theming.qmd) describes the various way to customize the fonts, colors, layout and other aspects of dashboard appearance.

[Parameters](parameters.qmd) explains how to create dashboard variants by defining parameters and providing distinct values for them on the command line.

[Deployment](deployment.qmd) covers how to deploy both static dashboards (which require only a web host, but not a server) and Shiny dashboards (which require a Shiny Server).

[Interactivity](interactivity/index.qmd) explores the various ways to create interactive dashboards that enable more flexible data exploration.
```````

## File: docs/dashboards/inputs.qmd
```````
---
title: "Dashboard Input Layout"
---

## Overview

There are several ways to layout inputs within interactive dashboards:

-   [Sidebars](#sidebars) provide a collapsible vertical panel for inputs.

-   [Toolbars](#toolbars) provide a horizontal panel for inputs.

-   [Card Inputs](#card-inputs) provide a panel for card-specific inputs.

These techniques all create regions for inputs with a special background color to distinguish them from ordinary content. You can also locate inputs anywhere else you wish within a dashboard (i.e. in a standard card).

## Sidebars {#sidebars}

Sidebars are a great place to group inputs for dashboards. To include a sidebar, add the `.sidebar` class to a level 2 heading. For example:

```` {.python .pymd style="overflow-x: hidden;"}
---
title: "Sidebar"
format: dashboard
server: shiny
---
    
## {.sidebar}

```{{python}}
```

## Column 

```{{python}}
```

```{{python}}
```
````

Here's how a sidebar would appear (note there is a button in the top right that enables the user to optionally close the sidebar):

![](/docs/dashboards/images/sidebar.png){.border fig-alt="A screenshot of a Penguin Bills dashboard. A sidebar on the left contains two dropdown menus, one for Variable and one for Distribution and a checkbox to show rugmarks. On the right there are two plots: a histogram of bill_length_mm colored by species and a histogram of bill_depth_mm colored by species."}

### Global Sidebar

If you have a dashboard with [multiple pages](/docs/dashboards/layout.qmd#pages), you may want the sidebar to be global (i.e. visible across all pages). To do this, add the `.sidebar` class to a level 1 heading:

```` {.python .pymd}
---
title: "Sidebar"
format: dashboard
---
    
# {.sidebar}

Sidebar content

# Plots

```{{python}}
```

# Data

```{{python}}
```
````

### Inline Sidebar

While sidebars are often laid out at the page level (i.e. spanning the dashboard from top to bottom) you can actually include them anywhere within a layout. For example, here we have a sidebar that is within a row (rather than spanning all rows):

```` {.python .pymd}
---
title: "Palmer Penguins"
format: dashboard
server: shiny
---

## Row

### {.sidebar}

```{{python}}
```

### Column

```{{python}}
```

## Row

```{{python}}
```
````

![](/docs/dashboards/images/inline-sidebar.png){.border fig-alt="A screenshot of a Penguin Bills dashboard. A sidebar on the left side of the top row contains two dropdown menus, one for Variable and one for Distribution and a checkbox to show rugmarks. On the right there is a histogram of bill_length_mm colored by species. In the second row there is a table displaying the raw penguins data."}

### Location and Size

Sidebars can be located on either the left or right side. Layout a sidebar on the right by including it *after* the column(s) it is adjacent to. You can also modify the size of sidebars using the `width` attribute. This example demonstrates both of these techniques:

```` {.python .pymd style="overflow-x: hidden;"}
---
title: "Sidebar"
format: dashboard
server: shiny
---
    
## Column 

```{{python}}
```

```{{python}}
```

## {.sidebar width="300px"}

```{{python}}
```
````

![](/docs/dashboards/images/sidebar-right.png){.border fig-alt="A screenshot of a Penguin Bills dashboard. A sidebar on the right contains two dropdown menus, one for Variable and one for Distribution and a checkbox to show rugmarks. On the left there are two plots: a histogram of bill_length_mm colored by species and a histogram of bill_depth_mm colored by species."}

## Toolbars {#toolbars}

Toolbars are similar to sidebars, but provide a horizontal layout. Create a toolbar by adding the `.toolbar` class to a level 2 row heading. For example:

```` {.python .pymd}
---
title: "Toolbar"
format: dashboard
server: shiny
---
    
## {.toolbar}
    
```{{python}}
```

## Row

```{{python}}
```
````

![](/docs/dashboards/images/toolbar.png){.border}

### Global Toolbar

If you have a dashboard with [multiple pages](/docs/dashboards/layout.qmd#pages), you may want the toolbar to be global (i.e. visible across all pages). To do this, add the `.toolbar` class to a level 1 heading:

```` {.python .pymd}
---
title: "Toolbar"
format: dashboard
server: shiny
---
    
# {.toolbar}

Toolbar content

# Page 1 

```{{python}}
```

# Page 2

```{{python}}
```
````

### Inline Toolbar

While toolbars are often laid out at the page level (i.e. spanning the dashboard from left to right) you can actually include them anywhere within a layout. For example, here we have a toolbar that is within a column (rather than spanning all columns):

```` {.python .pymd}
---
title: "Palmer Penguins"
format: 
  dashboard:
    orientation: columns
server: shiny
---

## Column 

### {.toolbar}

```{{python}}
```

### Row

```{{python}}
```

## Column

```{{python}}
```
````

![](/docs/dashboards/images/toolbar-inline.png){.border}

### Location

Toolbars can be located on either the top or bottom of content. Layout a toolbar on the bottom by including it *after* the rows(s) it is adjacent to. For example:

```` {.python .pymd}
---
title: "Penguin Bills"
format: dashboard
server: shiny
---

## Row

```{{python}}
```

## {.toolbar}

```{{python}}
```
````

![](/docs/dashboards/images/toolbar-bottom.png){.border}

## Card Inputs {#card-inputs}

In some cases you may want to connect inputs more directly to a single output. You can do this using either a card toolbar or card sidebar.

### Card Toolbars

To add a toolbar to a card, define it immediately above or below the cell that generates the output. You can do this by either adding the `content: card-toolbar` option to a cell or by creating a div with the `.card-toolbar` class. For example:

```` {.python .pymd}
```{{python}}
#| content: card-toolbar

```

```{{python}}
#| title: Penguin Bills

```
````

![](/docs/dashboards/images/card-toolbar.png){.border fig-alt="A screenshot of a Penguin Bills card. The card toolbar contains two dropdown menus, one for Variable and one for Distribution and a checkbox to show rugmarks. Below, a plot shows a histogram of bill_length_mm colored by species."}

Note that the `title` attribute is optional for cells with toolbars (if there is no `title` then the inputs will be left rather than right aligned).

### Card Sidebars

To add a sidebar to a card, define it immediately to the left or the right of the cell that generates the output. You can do this either by adding the `content: card-sidebar` option to a cell or by creating a div with the `.card-sidebars` class. For example:

```` {.python .pymd}
```{{python}}
#| content: card-sidebar

```

```{{python}}
#| title: Penguin Bills

```
````

![](/docs/dashboards/images/card-sidebar.png){.border fig-alt="A screenshot of a Penguin Bills card. The card sidebar on the left contains two dropdown menus, one for Variable and one for Distribution and a checkbox to show rugmarks. To the right, a plot shows a histogram of bill_length_mm colored by species."}
```````

## File: docs/dashboards/layout.qmd
```````
---
title: "Dashboard Layout"
lightbox: auto
aliases: 
  - components.html
  - layouts.html
---

{{< include /docs/_require-1.4.qmd >}}

Dashboards are compositions of components used to provide navigation and present data. Below we'll describe the components that are used to structure the navigation and layout of dashboards.

## Navigation

All dashboards include a top-level navigation bar that provide a title and (optionally) a logo and author. Dashboards with [multiple pages](#pages) also contain a link to each page on the navigation bar:

![](images/navigation-toolbar.png){fig-alt="Screenshot of a dashboard navigation bar. The bar begins with a logo of three penguins, then the title Palmer Penguins followed by the author Cobblepot Analytics. There are also three links to pages: Bills, Flippers and Data."}

The `title` and `author` are specified as they are with normal documents. You can also include a `logo` and one or more `nav-buttons`:

``` yaml
--- 
title: "Palmer Penguins"
author: "Cobblepot Analytics"
format: 
  dashboard:
    logo: images/penguins.png
    nav-buttons: [linkedin, twitter, github]
---
```

The following special aliases are recognized for navigation buttons: `linkedin`, `facebook`, `reddit`, `twitter`, and `github`. You can also create custom buttons as described in [Nav Items](/docs/reference/projects/websites.qmd#nav-items). For example:

```` yaml
format:
  dashboard:
    nav-buttons:
      - reddit
      - icon: gitlab
        href: https://gitlab.com/
````

## Layout

Within a page, dashboard components are laid out using alternating sets of rows and columns. Rows and columns are in turn defined by markdown headings and computational cells. For example, here's a simple layout with two rows, where the second row is split into two columns:

::: {.chart-example .grid}
::: g-col-5
```` {.python .pymd}
---
title: "Palmer Penguins"
author: "Cobblepot Analytics"
format: dashboard
---
    
## Row {height=70%}

```{{python}}
```

## Row {height=30%}

```{{python}}
```

```{{python}}
```
````
:::

::: g-col-7
![](images/chart-focal-top.png){fig-alt="A schematic of a page layout showing Chart 1 at the top using the full page width, then Chart 2 and Chart 3 side by side in a row below it."}
:::
:::

Here, level 2 markdown headings (e.g. `## Row {height=70%}`) define the contents of rows as well as their relative height. The ```` ```{python} ```` code cells in turn automatically create cards that are laid out in columns within the row. 


::: {.callout-note}

## Heading text isn't required

Although markdown headings are used to define the layout of rows and columns in Quarto dashboards, the heading text itself is discarded. We use the headings `Row` and `Column` in these docs to aid understanding of the layouts, but you can use more descriptive headings if they help you navigate your source code.

:::

### Orientation

By default, dashboard pages are laid out first by row, then by column. However, you can change this by specifying the `orientation: columns` document option:

::: {.chart-example .grid}
::: g-col-5
```` {.python .pymd}
---
title: "Diamonds Explorer"
format: 
  dashboard:
    orientation: columns
---
    
## Column {width=60%}

```{{python}}
```

## Column {width=40%}

```{{python}}
```

```{{python}}
```
````
:::

::: g-col-7
![](images/chart-focal-left.png){fig-alt="A schematic of a page layout showing Chart 1 on the left using the full page height, and on the right Chart 2 and Chart 3 are one above the other."}
:::
:::

### Fill vs. Flow

Each row in your dashboard that is not given an explicit height will determine its size by either filling available space or by flowing to its natural height. Filling layout is generally the default, however for certain types of content (e.g. markdown text) flow layout is the default.

If the default behavior isn't what you want, you can explicitly specify filling or flowing behavior using the `.fill` and `.flow` classes applied to a row. For example:

````{.python .pymd}
## Row {.fill}

## Row {.flow}
````



### Scrolling

By default, dashboard content fills all available space in the page. You can alternatively specify the `scrolling: true` option to layout content using its natural height and scroll to accommodate page overflow. For example:

::: {.chart-example .grid}
::: g-col-5
```` {.python .pymd}
---
title: "Scrolling"
format: 
  dashboard:
    scrolling: true 
---
    
```{{python}}
```

```{{python}}
```

```{{python}}
```
````
:::

::: g-col-7
![](images/chart-stack-scrolling.png){fig-alt="A schematic of a dashboard layout showing three charts stacked vertically."}
:::
:::

Because of its ability to scroll this layout could easily accommodate many more charts. While this is useful, you might also consider [Pages](#pages) and [Tabsets](#tabsets) (described in the next two sections) as alternate ways to present content within layouts that fill their page.

## Pages {#pages}

The layout examples above demonstrated only single-page dashboards. To introduce multiple pages, use level 1 headings above the level 2 headings used to define rows and columns. The text of the level 1 headings will be used to link to the pages in the navigation bar. For example, here is a dashboard that splits content across two pages:

```` {.python .pymd}
---
title: "Palmer Penguins"
format: dashboard
---
    
# Bills 

```{{python}}
```

# Flippers {orientation="columns" scrolling="true"}

## Column

```{{python}}
```

```{{python}}
```

## Column 

```{{python}}
```
````

Note that we can set a per-page orientation by adding an `orientation` attribute to the page heading (here `orientation="columns"` for the second page). In addition, you can control per-page scrolling behavior using a `scrolling` attribute on the page heading (shown using `scrolling="true"` for the second page above).

## Tabsets {#tabsets}

Use tabsets to include multiple views of data or to include content of secondary importance without having it crowd the main display. Tabsets are created by adding the `.tabset` class to a row or column. For example, this layout displays the bottom row as a set of two tabs.

::: {.chart-example .grid}
::: g-col-5
```` {.python .pymd}
---
title: "Palmer Penguins"
format: dashboard
---
    
## Row

```{{python}}
```

## Row {.tabset}

```{{python}}
#| title: Chart 2
```

```{{python}}
#| title: Chart 3
```
````
:::

::: g-col-7
![](images/chart-tabset-row.png){fig-alt="Schematic of a dashboard layout showing Chart 1 at the top using the full page width. Below Chart 1, a panel with two tabs is shown: the Chart 2 tab is selected and occupies the full page width; the Chart 3 tab is unselected."}
:::
:::

You can include tabsets at arbitrarily deep levels. Here we include a tabset within a column of a top level row:

::: {.chart-example .grid}
::: g-col-5
```` {.python .pymd}
---
title: "Palmer Penguins"
format: dashboard
---
    
## Row {height=70%}

```{{python}}
```

## Row {height=30%}

### Column {.tabset}

```{{python}}
#| title: Chart 2
```

```{{python}}
#| title: Chart 3
```

### Column

```{{python}}
```
````
:::

::: g-col-7
![](images/chart-tabset-card.png){fig-alt="Schematic of a dashboard layout showing Chart 1 at the top using the full page width. The row below Chart 1 is split into two columns. In the left column is a panel with two tabs: Chart 2 and Chart 3. In the right column is Chart 4."}
:::
:::

Each cell within the tabset column becomes a tab, and we provide navigational titles for our tabs by adding a `title` option to the cell used to produce each tab.

You can also have tabs that contain only markdown. To do this use a `::: {.card}` div and include a `title` attribute for the tab:

````python
::: {.card title="My Title"}
Card text 
:::
````

In the examples above, each tab included a single card. If you want tabs to contain multiple cards, introduce another level of headings below the tabset row or column. For example:

````{.python .pymd}
---
title: "Palmer Penguins"
format: dashboard
---
    
## Row {.tabset}

### Plots

```{{python}}
```

```{{python}}
```

### Data

```{{python}}
```
````


## Cards {#cards}

Cards are the fundamental unit of display within dashboards. Cards are created automatically for cells and markdown content that are within rows and columns. So for example, each of the Python cells here become cards:

```` {.python .pymd}
## Column {width=40%}

```{{python}}
```

```{{python}}
```
````

You can also create cards that contain arbitrary markdown via a `.card` div. For example:

```` {.python .pymd}
## Column {width=40%}

```{{python}}
```

::: {.card}
This text will be displayed within a card
:::

```{{python}}
```
````

To provide a title for a markdown card use the `title` attribute. For example:

````python
::: {.card title="My Title"}
This text will be displayed within a card
:::
````

Note that if you are authoring within a Jupyter Notebook then markdown cells automatically become `.card` divs.

For additional details on how cells and their content are mapped to cards (e.g. excluding cells, cells with multiple outputs, etc.), see [Cell Output](data-display.qmd#cell-output).

### Display Options

By default, cards are displayed with no title and a small bit of padding around the edges. Here is a card that displays a [Leaflet](https://ipyleaflet.readthedocs.io) map:

![](images/leaflet-card.png){fig-alt="Screenshot of a map inset from a light grey border around the card."}

You can add a title to a card by including the `title` cell option. You can also customize the padding using the `padding` option. For example, here we add a title and remove the padding entirely:

```` {.python .pymd}
```{{python}}
#| title: "World Map"
#| padding: 0px
from ipyleaflet import Map, basemaps, basemap_to_tiles
Map(basemap=basemap_to_tiles(basemaps.OpenStreetMap.Mapnik),
    center=(48.204793, 350.121558), zoom=2)
```
````

![](images/leaflet-card-title-padding.png){fig-alt="Screenshot of a card with the title World Map displayed in the light grey bar at the top. The card contains a map with no inset from the card border."}


You can create a dynamic `title` by printing a `title=` expression as a cell's first output. For example:

{{< include _dynamic-title.md >}}

#### Expanding Cards

By default, you can zoom in on the content of cards using the expand button in the bottom right:

![](images/leaflet-card-expandable.png){fig-alt="Screenshot of a card with the cursor hovering over an icon in the bottom right showing the pop up text Expand."}

If you don't want cards to be expandable you can specify `expandable: false` (either at the document level or for individual cards).

#### Card Fill Behavior

Quarto inspects card contents and generally choose a fill behavior that best matches the contents of the card (by default cards will fill their container, though in specific cases like simple markdown the card will choose a `flow` layout). You can explicit control the fill behavior of card using the `fill` attribute with the desired boolean value. For example `fill="false"` will cause the card's height to match the size of the content (not filling).

## Learning More

[Data Display](data-display.qmd) shows you how to display data in your dashboard as plots, tables, value boxes, and text.

[Inputs](inputs.qmd) demonstrates various ways to layout inputs for interactive dashboards (sidebars, toolbars, attaching inputs directly to cards, etc.)

[Examples](/docs/gallery/index.qmd#dashboards) provides a gallery of example dashboards you can use as inspiration for your own.

[Theming](theming.qmd) describes the various way to customize the fonts, colors, layout and other aspects of dashboard appearance.

[Parameters](parameters.qmd) explains how to create dashboard variants by defining parameters and providing distinct values for them on the command line.

[Deployment](deployment.qmd) covers how to deploy both static dashboards (which require only a web host, but not a server) and Shiny dashboards (which require a Shiny Server).

[Interactivity](interactivity/index.qmd) explores the various ways to create interactive dashboards that enable more flexible data exploration.
```````

## File: docs/dashboards/parameters.qmd
```````
---
title: Dashboard Parameters
document: "dashboard"
---

{{< include /docs/computations/_parameters.md >}}
```````

## File: docs/dashboards/theming.qmd
```````
---
title: "Dashboard Theming"
tbl-colwidths: [40,60]
is_dashboards: true
---

## Overview

Quarto Dashboards use same Bootstrap 5 based theming system as regular HTML documents (so themes you have built for HTML websites can also be used with dashboards). Use the `theme` option to choose a theme:

``` yaml
theme: cosmo
```

Quarto includes 25 themes from the [Bootswatch](https://bootswatch.com/) project (for example, the website uses the [cosmo](https://bootswatch.com/cosmo/) theme). Available themes include:

{{< include /docs/output-formats/_theme-list.md >}}

Use of any of these themes via the `theme` option. For example:

``` yaml
format:
  dashboard:
    theme: united
```

In the following sections we'll describe how you can customize these themes or create your own new themes.

{{< include /docs/output-formats/_theme-options.md >}}

{{< include /docs/output-formats/_theme-custom.md >}}

{{< include /docs/output-formats/_theme-variables.md >}}
```````

## File: docs/download/changelog/1.1/index.qmd
```````
---
title: "1.1 Release Notes"
format: html
---

{{< include _changelog.md >}}
```````

## File: docs/download/changelog/1.2/index.qmd
```````
---
title: "1.2 Release Notes"
format: html
---

{{< include _changelog.md >}}
```````

## File: docs/download/changelog/1.3/index.qmd
```````
---
title: "1.3 Release Notes"
format: html
---

{{< include _changelog.md >}}
```````

## File: docs/download/changelog/1.4/index.qmd
```````
---
title: "1.4 Release Notes"
format: html
---

{{< include _changelog.md >}}
```````

## File: docs/download/changelog/1.5/index.qmd
```````
---
title: 1.5 Release Notes
format: html
---

{{< include _changelog.md >}}
```````

## File: docs/download/changelog/1.6/index.qmd
```````
---
title: 1.6 Release Notes
format: html
---

{{< include _changelog.md >}}
```````

## File: docs/download/index.qmd
```````
---
title: "Download Quarto"
subtitle: "Install a release or pre-release build of Quarto."
format:
  html:
    include-in-header: 
      - '_download.html'
    include-after-body: 
      text: |
        <script type="text/javascript">
        window['quarto-download-prerelease'] = true;
        window['quarto-download-release'] = true;
        window['quarto-download-archives'] = true;
        window["quarto-prerelease-mode"] = '{{< meta prerelease-mode >}}';
        </script>
page-layout: full
toc: false
anchor-sections: false
editor: source
image: /images/hero_right.png
listing:
  id: download-older
  contents: /_download-older.yml
  sort: "date desc"
  fields: 
    - title
    - changelog
    - date
    - path
  field-display-names: 
    path: "URL"
    title: "Version"
    changelog: "Release Notes"
  field-links: 
    - path
    - title
  type: table
  filter-ui: false
  sort-ui: false
---


::: {.content-visible when-profile="rc"}

::: {.panel-tabset}

## **{{< meta prerelease-title >}}** --- v[]{.download-pre-version}

{{< include _download-pre.md >}}


## **Current Release** --- v[]{.download-version}

{{< include _download.md >}}

## **Older Releases**

Pages containing all installers for the most recent releases of older versions of Quarto are linked below.

:::{#download-older}

:::

:::

:::

::: {.content-hidden when-profile="rc"}

::: {.panel-tabset}

## **Current Release** --- v[]{.download-version}

{{< include _download.md >}}

## **{{< meta prerelease-title >}}** --- v[]{.download-pre-version}

{{< include _download-pre.md >}}

## **Older Releases**

Pages containing all installers for the most recent releases of older versions of Quarto are linked below.

:::{#download-older}

:::

:::

:::
```````

## File: docs/download/prerelease.qmd
```````
---
title: "{{< meta prerelease-title >}} Builds"
subtitle: "Install a {{< meta prerelease-lower >}} build of Quarto."
format:
  html:
    include-in-header: 
      - '_download.html'
    include-after-body: 
      text: |
        <script type="text/javascript">
        window['quarto-download-prerelease'] = true;
        window['quarto-download-archives'] = true;
        window["quarto-prerelease-mode"] = '{{< meta prerelease-mode >}}';
        </script>
page-layout: full
toc: false
anchor-sections: false
editor: source
image: /images/hero_right.png
aliases:
  - changelog/1.8/
---

::: {.content-visible when-profile="prerelease"}

:::{.callout-note}
Pre-release builds are intended for testing purposes, and are not recommended for general use. For stable builds, please visit [Release Builds](release.qmd).
:::

:::

{{< include _download-pre.md >}}
```````

## File: docs/download/release.qmd
```````
---
title: "Release Builds"
subtitle: "Install a release build of Quarto."
format:
  html:
    include-in-header: 
      - '_download.html'
    include-after-body: 
      text: |
        <script type="text/javascript">
        window['quarto-download-release'] = true;
        window['quarto-download-archives'] = true;
        </script>
page-layout: full
toc: false
anchor-sections: false
editor: source
image: /images/hero_right.png
aliases:
  - changelog/1.7/
---

{{< include _download.md >}}
```````

## File: docs/download/tarball.qmd
```````
---
title: Tarball Installation On Linux
format:
  html:
    include-in-header: 
      - '_download.html'
    include-after-body: tarball-after-body.html
search: false
---

::: {#download-button .download-button}
<div>

[\_](_ "Download Quarto"){#download-url .btn .btn-action .btn-action-primary}
[Find your operating system in the table below]{#download-text .hidden .download-text}

</div>
:::


You can install Quarto for a single user on Linux by using the Quarto tarball and following the below set of steps. 

**1. Download the tarball**

```{.bash filename="Terminal"}
wget https://github.com/quarto-dev/quarto-cli/releases/download/v^version^/quarto-^version^-linux-amd64.tar.gz
```

**2. Extract Files**

Extract the contents of the tarball to the location where you typically install software (e.g. `~/opt`). For example:

```{.bash filename="Terminal"}
mkdir ~/opt
tar -C ~/opt -xvzf quarto-^version^-linux-amd64.tar.gz
```

**3. Create a Symlink**

Create a symlink to `bin/quarto` in a folder that is in your path. If there is no such folder, you can create a folder such as `~/.local/bin` and place the symlink there. For example:

For example:

```{.bash filename="Terminal"}
mkdir ~/.local/bin
ln -s ~/opt/quarto-^version^/bin/quarto ~/.local/bin/quarto
```

**4. Ensure Folder in on Path**

If you can run `quarto -v` at this point, jump ahead to the next step.

Otherwise, ensure that the folder where you created a symlink is in the path. For example:

```{.bash filename="Terminal"}
( echo ""; echo 'export PATH=$PATH:~/.local/bin\n' ; echo "" ) >> ~/.profile
source ~/.profile
```

**5. Check The Installation**

Use `quarto check` to confirm that the installation is successful:

```{.bash filename="Terminal"}
quarto check
```
```````

## File: docs/extensions/_extension-trust.qmd
```````
::: {.callout-warning appearance="simple"}
### Extension Trust

Quarto extensions may execute code when documents are rendered. Therefore, if you do not trust the author of an extension, we recommend that you do not install or use the extension.
:::
```````

## File: docs/extensions/_formats-common.qmd
```````
## Distributing Formats

You can distribute format extensions in one of two ways:

1.  As a template that includes both the format in the `_extensions` directory and the `template.qmd` (which is automatically renamed to match the name of the enclosing directory).

2.  As a plain format with no template scaffolding (this is useful for adding the format to an existing document or project).

If you have a GitHub repository containing the files enumerated above in the `{{< meta example-format >}}` example, users could install your extension and associated template as follows (where `{{< meta example-org >}}` is the GitHub organization hosting the repo):

``` {.bash filename="Terminal"}
quarto use template {{< meta example-org >}}/{{< meta example-format >}}
```

This is often the preferred way to get started with a format as it provides the user with a working document right out of the box. It's also possible to install *only* the format if you are working with an existing project:

``` {.bash filename="Terminal"}
quarto add {{< meta example-org >}}/{{< meta example-format >}}
```

Note that it is possible to bundle and distribute extensions as simple gzip archives (as opposed to using a GitHub repository as described above). See the article on [Distributing Extensions](/docs/extensions/distributing.qmd) for additional details.

## Multiple Formats

A single format extension can support more than one output format. For example, an extension may target `html` and `pdf` output. To support multiple formats in your extension, you can add additional base formats to the `contributes / format` key like so:

``` yaml
contributes:
  format:
    html:
      # html-specific options
    pdf:
      # pdf-specific options
```

## Common Metadata

If you have metadata that is common to any output format when your format extension is targeted, you can place that metadata under the `common` key. For example:

``` yaml
contributes:
  format:
    common:
      filters:
        - filter.lua
      shortcodes:
        - quarto-ext/fancy-text
    html:
      # html-specifc
    pdf:
      # pdf-specifc
```

## Format Resources

You can usually include other files and resources within a format extension by placing those files within the extension directory and using relative paths to reference them in your `_extension.yml` metadata file. These relative paths will be properly handled as your extension's metadata is merged with the rendered document metadata.

If there are resources that you need to have copied to the input directory as a part of rendering the document (for example, a `bst` file for LaTeX bibliographies or a logo or other file referenced from a LaTeX template), you can provide `format-resources`, which is a list of file paths[^_formats-common-1]. Each of these files will be copied into the directory containing the input that is being rendered when the document is rendered. For example:

``` yaml
contributes:
  format:
    pdf:
      format-resources:
        - plos2015.bst
```

## Extension Embedding

In some cases format extensions will want to make use of other extensions. This is permitted, but adding extensions for use within a custom format must be done with a special command line flag to ensure they are embedded correctly.

``` {.bash filename="Terminal"}
quarto create extension format:pdf myformat
cd myformat
quarto add quarto-ext/fancy-text --embed myformat
```

For example, here we want to make the [fancy-text](https://github.com/quarto-ext/fancy-text) extension (which provides special formatting for the words {{< latex >}} and {{< bibtex >}}) available for users of the [jss](https://github.com/quarto-journals/jss) custom format:

``` {.bash filename="Terminal"}
quarto add quarto-ext/fancy-text --embed jss
```

This will produce the following output:

``` {.bash filename="Output"}
quarto-journals/jss
└── _extensions
    └── jss
        ├── _extensions
        │   └── quarto-ext
        │       └── fancy-text
        └── partials
```

This will add the `quarto-ext/fancy-text` extension into the `jss` extension in the `_extensions` folder. By embedding an extension you make it available without creating the potential for conflict with other versions of the extension that users might already have installed.

[^_formats-common-1]: This is most common in the the case of PDF based formats which have a secondary step of converting the LaTeX produced by Pandoc into a PDF. If there are files that are referenced indirectly by the LaTeX, they will need to be discoverable and should typically be copied into the same directory that contains the LaTeX input.
```````

## File: docs/extensions/_listing-chooser.qmd
```````
::: column-page-inset-right
```{=html}

<style type="text/css">
.nav-tabs {
  margin-top: 0.5rem;
  border-bottom: none;
}

.callout {
  margin-top: 0;
}

.nav-tabs .nav-link {
  text-align: center;
  margin-right: 15px;
  margin-top: 10px;
  width: 147px;
  font-size: 0.8em;
  font-weight: 600;
}


.nav-tabs .nav-link, 
.nav-tabs .nav-link.active, 
.nav-tabs .nav-item.show .nav-link {
  border: 1px solid  rgb(222, 226, 230);
  border-radius: 10px;
  color: rgb(80,146,221);
}
.nav-tabs .nav-link:hover {
   border-color: rgb(80,146,221);
   border-width: 1px;
} 

.nav-tabs .nav-link.active, 
.nav-tabs .nav-item.show .nav-link {
  border-color: rgb(80,146,221);
  border-width: 2px;
}


.nav-tabs .nav-link i {
  display: block;
  font-size: 3rem;
  color: rgb(80,146,221);
  margin-bottom: 5px;
}

.quarto-listing {
  margin-top: 2em;
}

.quarto-listing .listing-name,
.quarto-listing .listing-author {
  white-space: nowrap;
}

.quarto-listing .listing-actions-group h3 {
  margin-top: 0;
}

 
</style>

<ul id="index-chooser" class="nav nav-tabs" role="tablist">
  <li class="nav-item" role="presentation">
    <a class="nav-link" href="listing-filters.html">
      <i class="bi bi-gear"></i>Shortcode/Filter
    </a>
  </li>
  <li class="nav-item" role="presentation">
    <a class="nav-link" href="listing-journals.html">
      <i class="bi bi-journal-text"></i>Journal Articles
    </a>
  </li>
  <li class="nav-item" role="presentation">
    <a class="nav-link" href="listing-formats.html">
      <i class="bi bi-file-earmark-richtext"></i>Custom Formats
    </a>
  </li>
  <li class="nav-item" role="presentation">
    <a class="nav-link" href="listing-revealjs.html">
      <i class="bi bi-easel3"></i>Revealjs
    </a>
  </li>
</ul>

<script type="text/javascript">
document.addEventListener("DOMContentLoaded", function() {
  // get file name
  const filename = window.location.pathname.split("/").slice(-1)[0];

  // latch active
  const toolLinks = window.document.querySelectorAll("#index-chooser a");
  for (const tool of toolLinks) {
    if (filename && filename !== "index.html") {
      if (tool.href.endsWith(filename)) {
        tool.classList.add("active");
      } 
    } else {
      if (tool.href.endsWith("listing-filters.html")) {
        tool.classList.add("active");
      }
    }
  }
  
  // move heading into table
  document.querySelector(".listing-actions-group").prepend(document.querySelector("h3.unlisted"));
});

</script>
```
:::
```````

## File: docs/extensions/_listing-footer.qmd
```````
::: {.column-body-outset-right}



:::
```````

## File: docs/extensions/_listing-preamble.qmd
```````
::: column-body-outset-right
{{< include _extension-version.qmd >}}

Extensions are a powerful way to modify and extend the behavior of Quarto. Below is a listing of available extensions (please [let us know](https://github.com/quarto-dev/quarto-web/tree/main/docs/extensions/listings) if you have an extension you'd like to see added to the list).

See the articles on [Creating Extensions](creating.qmd) to learn how to develop your own extensions.
:::

{{< include _listing-chooser.qmd >}}
```````

## File: docs/extensions/_shortcode-escaping.qmd
```````
## Escaping

If you are writing documentation about using variable shortcodes (for example, this article!) you might need to prevent them from being processed. You can do this in two ways:

1.  Escape the shortcode reference with extra braces like this:

    ``` {.default shortcodes="false"}
    {{{< var version >}}}
    ```

2.  Add a `shortcodes=false` attribute to any code block you want to prevent processing of shortcodes within:

    ```` default
    ```{{shortcodes=false}}
    {{{< var version >}}}
    ```
    ````
```````

## File: docs/extensions/creating.qmd
```````
---
title: Creating Extensions
---

{{< include _extension-version.qmd >}}

## Overview

Quarto Extensions are a powerful way to modify or extend the behavior of Quarto, and can be created and distributed by anyone. There are several types of extensions available:

| Extension                                   | Description                                                                                                                                                                                                                                                   |
|----------------------------------|-----------------------------------------------------------------------------------|
| [Shortcodes](shortcodes.qmd)                | Special markdown directives that generate various types of content. For example, you could create shortcodes to embed tweets or videos in a document.                                                                                                         |
| [Filters](filters.qmd)                      | A flexible and powerful tool for introducing new global behaviors and/or new markdown rendering behaviors. For example, you could create filters to implement output folding, an image carousel, or just about anything you can imagine!                      |
| [Journal Articles](/docs/journals/formats.qmd) | Enable authoring of professional Journal articles using markdown, and produce both LaTeX (PDF) and HTML versions of the articles.                                                                                                                             |
| [Custom Formats](formats.qmd)               | Create new output formats by bundling together document options, templates, style sheets, and other content.                                                                                                                                                  |
| [Revealjs Plugins](revealjs.qmd)            | Extend the capabilities of HTML presentations created with Revealjs.                                                                                                                                                                                          |
| [Project Types](project-types.qmd)          | Create new project project types that bundle together standard content and options, or make it easy to create a website for a custom HTML format.                                                                                                             |
| [Starter Templates](starter-templates.qmd)  | Help users get started with new projects by providing a template and example content. Starter templates aren't strictly extensions (i.e. they aren't installed in the `_extensions` directory) but they are often used with custom formats and project types. |
| [Metadata](metadata.qmd) | Provide YAML configuration that can be merged into existing Quarto projects. |

: {tbl-colwidths="\[30,70\]"}

## Development

Each type of extension has its own development requirements: in some cases an extension can be created with YAML metadata alone, however in many cases you'll end up doing some custom scripting using Lua.

These articles provide in-depth documentation on learning and using Lua for extension development:

-   [Lua Development](lua.qmd) helps you get started with Lua (the language used to create extensions)

-   [Lua API Documentation](lua-api.qmd) provides documentation on the Pandoc and Quarto Lua APIs used for creating extensions.

## Distribution

There are two distinct ways to distribute extensions to end users:

-   Publish your extension in a public GitHub repository.

-   Bundle your extension into a `.zip` or `.tar.gz` archive.

[Distributing Extensions](distributing.qmd) goes into more depth on how to package and distribute extensions, both on GitHub and using plain gzip archives.

## Examples

The documentation linked to above provides simple motivating examples for each type of extension. Once you understand these, check out the following for more sophisticated examples of each type of extension:

The [Quarto Extensions](https://github.com/quarto-ext/) GitHub organization provides a set of extensions developed by the core Quarto team. Many of these extensions implement frequently requested features, and all of them provide sound examples of how to implement extensions.

The [Quarto Journals](https://github.com/quarto-journals/) GitHub organization contains a set of Journal Article formats developed by the core Quarto team or contributed by third parties.

Finally, most [published extensions](index.qmd) are hosted on GitHub and therefore have source code available that you can learn from.
```````

## File: docs/extensions/distributing.qmd
```````
---
title: "Distributing Extensions"
---

{{< include _extension-version.qmd >}}

## Overview

Quarto extensions are directories that contain an `_extensions` sub-directory with one or more extensions. The files above the `_extensions` directory are not installed, so typically contain README and LICENSE files, examples, test cases, etc.

There are two distinct ways to distribute extensions to end users:

1.  Publish your extension in a public GitHub repository.

2.  Bundle your extension into a `.zip` or `.tar.gz` archive.

Each method has benefits and drawbacks that will be explored below. First we'll cover the basic file structure and contents of an extension.

## Extension Contents

Quarto Extensions are directories that contain an `_extensions` folder that contains one or more extension contributions. While the most common case is the distribution of a single extension, it is possible to create a single extension directory that includes multiple shortcodes, multiple filters, or a combination of both.

Here is the contents of an extension named `my-filter`:

``` default
README.md
LICENSE
example.qmd
_extensions/
  my-filter/
    _extension.yml
    my-filter.lua
```

Note that the only thing strictly required is the `_extensions` directory (anything above that is for your own purposes and is ignored during installation). Even so, it's good practice to include a `README.md` and `LICENSE` file, and the `example.qmd` will be useful for developing your extension.

### \_extension.yml

Each extension is defined by its `_extension.yml` file which contains the metadata about the extension as well as the what items it contributes when used. For example, here is the `_extension.yml` for a filter extension:

``` yaml
title: My Filter
author: Cooltools
version: 1.0.0
quarto-required: ">=1.2.0"
contributes:
  filters:
    - my-filter.lua
```

Here are all of the fields that can be specified in the `_extension.yml` file:

`title`

:   The extension's name

`author`

:   The author of the extension

`version`

:   A semantic version number this release. When installing, updating, or releasing an extension, this version number will be used to present a summary of actions to the user.

`quarto-required`

:  A semantic version number indicating the minimum quarto version required to run this extension.

`contributes`

:   The items that this extension will contribute to the render. These are allowed subkeys:

::: {style="margin-left: 1em;"}

`shortcodes`

:   A list of shortcode files that should be loaded when this extension is installed.

`filters`

:   A list of filters that should be loaded when this extension is included in the list of filters used to render a document or project. The order of the filters in this list will be preserved.

`formats`

:   A record containing the key value pairs of output formats and the metadata associated with that output format.
:::

:::{.callout-note}
The `version` field is checked for conformity to [semantic versioning](https://semver.org/). For example, valid `version` values would be:

- 1.0.0
- 2.3.4-alpha
- 1.2.3-beta+build567
- 3.0.0-alpha.2
- 4.2.1+build.987

Invalid `version` values would be: 

- 1.2 (missing patch version)
- 1.2.3.4 (extra version segment)
- 1.2.3-beta.5+build (missing build metadata identifier)
:::

## GitHub Distribution

Distributing extensions on GitHub has a number of benefits, including compact syntax (e.g. `quarto add org-name/extension`), the use of organizations as a "namespace" for managing name conflicts, and the ability to target specific releases or tags.

For example, the extensions in the [`quarto-ext`](https://github.com/quarto-ext/) GitHub organization can be added to a project with these commands:

``` {.bash filename="Terminal"}
quarto add quarto-ext/lightbox
quarto add quarto-ext/fontawesome
```

By default, extensions are added from the `HEAD` of the `main` branch of the repository. You can also target tags and/or branches in your repository by including an `@` after the repository name. For example:

``` {.bash filename="Terminal"}
quarto add quarto-ext/lightbox@v1.2
quarto add quarto-ext/lightbox@bugfix-22
```

Extensions added from GitHub have another special property: the GitHub organization can be used as a namespace qualifier to disambiguate extensions that have the same name. For example, if you have two different `lightbox` extensions in your project, you explicitly specify the `quarto-ext` one as follows:

``` yaml
---
filters:
  - quarto-ext/lightbox
---
```

You can also add an extension from a subdirectory of a GitHub repository. For example, here we install two different extensions from the `cooltools/icons` repository:

``` {.bash filename="Terminal"}
quarto add cooltools/icons/fontawesome
quarto add cooltools/icons/iconify
```

## Archive Distribution

Distributing extensions as a `.zip` or `.tar.gz` archive has the benefit of not requiring public distribution. These extensions can also be added directly from non-GitHub version control services using the archive URLs normally provided for repositories.

Note that unlike GitHub hosted extensions, extensions installed from archives do not have an organizational namespace (they all share a single namespace).

### Git Repositories

To add an extension to a project from a GitLab repository you could do this:

``` {.bash filename="Terminal"}
quarto add https://gitlab.com/cooltools/shorty/-/archive/main/shorty-main.zip
```

You'll note that the above URL references the `main` branch. You can similarly target any other branch, tag, or release. For example, to add an extension using the `v1.0` tag:

``` {.bash filename="Terminal"}
quarto add https://gitlab.com/cooltools/shorty/-/archive/v1.0/shorty-main.zip
```

If you are using BitBucket, Azure DevOps, or another Git hosting provider, consult the appropriate service documentation to learn how to form archive URLs for repositories.

### Archive Files

The above examples demonstrate adding an extension from a Git repository, you can also add an extension from an archive published to an ordinary web host. For example:

``` {.bash filename="Terminal"}
quarto add https://cooltools.org/quarto/shorty.zip
```

Or alternatively from a local archive file or even ordinary uncompressed directory:

``` {.bash filename="Terminal"}
quarto add ~/Downloads/shorty.zip
quarto add /share/quarto/extensions/shorty
```
```````

## File: docs/extensions/filters.qmd
```````
---
title: "Creating Filters"
aliases: 
  - /docs/authoring/shortcodes-and-filters.html
  - /docs/authoring/filters.html
---

{{< include _extension-version.qmd >}}

## Overview

If the base features of Pandoc and Quarto don't do exactly what you need, you can very likely create a [Pandoc Filter](https://pandoc.org/filters.html) that bridges the gap.

Pandoc consists of a set of readers and writers. When converting a document from one format to another, text is parsed by a reader into pandoc's intermediate representation of the document---an "abstract syntax tree" or AST---which is then converted by the writer into the target format. The pandoc AST format is defined in the module [`Text.Pandoc.Definition`](https://hackage.haskell.org/package/pandoc-types-1.22/docs/Text-Pandoc-Definition.html) in the pandoc-types package.

A "filter" is a program that modifies the AST, between the reader and the writer.

    INPUT --reader--> AST --filter--> AST --writer--> OUTPUT

Pandoc's built-in citation processing is implemented as a filter, as are many of Quarto's internal extensions (e.g. cross-references, figure layout, etc.).

You can write Pandoc filters using Lua (via Pandoc's built-in Lua interpreter) or using any other language using a JSON representation of the Pandoc AST piped to/from an external process. We strongly recommend using Lua Filters, which have the following advantages:

-   No external dependencies
-   High performance (no serialization or process execution overhead)
-   Access to the [Pandoc](https://pandoc.org/lua-filters.html#pandoc-module) and [Quarto](lua.qmd) libraries of Lua helper functions.

## Activating Filters

If you've developed a filter and want to use it within a document you need to add it to the list of `filters` for the document. For example, here we arrange for the [spellcheck](https://github.com/pandoc/lua-filters/tree/master/spellcheck) filter to run:

``` yaml
---
filters:
  - spellcheck.lua
---
```

By default, user filters are run before Quarto's built-in filters. For some filters you'll want to modify this behavior. For example, here we arrange to run `spellcheck` before Quarto's filters and `fontawesome` after:

``` yaml
filters:
  - spellcheck.lua
  - quarto
  - fontawesome
```

You'll notice that one of the extensions (`spellcheck.lua`) has a file extension and the other (`fontawesome`) does not. This difference stems from how the extensions are distributed: an extension distributed as a plain Lua file uses `.lua` whereas a filter distributed as a [Quarto Extension](index.qmd) does not. The next section explores how to create filters as extensions.


## Filter Extensions 

### Quick Start

Here we'll describe how to create a simple filter extension. We'll use the `quarto create` command to do this. If you are using VS Code or RStudio you should execute `quarto create` within their respective integrated Terminal panes. 

To get started, execute `quarto create extension filter` within the parent directory where you'd like the filter extension to be created:

```{.bash filename="Terminal"}
$ quarto create extension filter
 ? Extension Name › fancy-header
```

As shown above, you'll be prompted for an extension name. Type `fancy-header` and press Enter---the filter extension is then created:

```bash
Creating extension at /Users/jjallaire/quarto/dev/fancy-header:
  - Created README.md
  - Created _extensions/fancy-header/_extension.yml
  - Created _extensions/fancy-header/fancy-header.lua
  - Created .gitignore
  - Created example.qmd
```

If you are running within VS Code or RStudio a new window will open with the extension project. 

Here's what the contents of the files in `_extensions/fancy-header/` look like:

``` {.yaml filename="_extensions/fancy-header/_extension.yml"}
title: Fancy-header
author: J.J. Allaire
version: 1.0.0
quarto-required: ">=99.9.0"
contributes:
  filters:
    - fancy-header.lua
```

``` {.lua filename="_extensions/fancy-header/fancy-header.lua"}
-- Reformat all heading text 
function Header(el)
  el.content = pandoc.Emph(el.content)
  return el
end
```

Finally, the `example.qmd` file includes code that exercises the extension. For example:

``` {.markdown filename="example.qmd"}
---
title: "Fancy-header Example"
filters:
  - fancy-header
---

## Heading

This filter adds formatting to heading text.
```

Note that the value provided to `filters` in `example.qmd` should be the name of the extension (`fancy-header`), not the filename of the filter (`fancy-header.lua`). This allows you to bundle more than one filter in your extension:

``` {.yaml filename="_extensions/fancy-header/_extension.yml"}
contributes:
  filters:
    - fancy-header.lua
    - make-fancier.lua
```

All of filters in your extension will be applied when a user uses your extension in their document.

To develop your filter, render/preview `example.qmd`, and then make changes to `fancy-header.lua` (the preview will automatically refresh when you change `fancy-header.lua`).

### Development

To learn more about developing filter extensions:

1.  If necessary, brush up on [Lua Development](lua.qmd) (Lua is the language used to create filters).

2.  Review the Pandoc documentation on [Writing Lua Filters](https://pandoc.org/lua-filters.html).

3.  Read the [Lua API Reference](lua-api.qmd), which describes the Lua extension API for Quarto.

If you want to write a JSON filter, see the documentation on [Writing JSON filters](https://pandoc.org/filters.html).

To create a new filter extension, use the `quarto create extension filter` command as described above.

### Distribution

If your extension source code is located within a GitHub repository, then it can be added to a project by referencing the GitHub organization and repository name. For example:

``` {.bash filename="Terminal"}
# target the current HEAD of the extension
quarto add cooltools/output-folding

# target a branch or tagged release of the extension
quarto add cooltools/output-folding@v1.2
quarto add cooltools/output-folding@bugfix-22
```

Note that it is possible to bundle and distribute extensions as simple gzip archives (as opposed to using a GitHub repository as described above). See the article on [Distributing Extensions](distributing.qmd) for additional details.

### Examples

You might also find it instructive to examine the source code of these filter extensions authored by the Quarto team:

| **Extension name**                                                   | **Description**                                               |
|--------------------------------------|----------------------------------|
| [latex-environment](https://github.com/quarto-ext/latex-environment) | Quarto extension to output custom LaTeX environments.         |
| [lightbox](https://github.com/quarto-ext/lightbox)                   | Create lightbox treatments for images in your HTML documents. |

: {tbl-colwidths="\[35,65\]"}
```````

## File: docs/extensions/formats.qmd
```````
---
title: "Custom Formats"
example-org: lexcorp
example-format: lexconf
---

{{< include _extension-version.qmd >}}


## Overview

Quarto format extensions enable you to add new formats to the built-in formats (e.g. `html`, `pdf`, `docx`) already available. Custom formats can provide default document options, style-sheets, header, footer, or logo elements, and even bundle other extensions like [filters](filters.qmd) and [shortcodes](shortcodes.qmd). They are a great way to provide a common baseline for authoring documents or presentations within an organization, for a particular type of project or analysis, or for a specific publication.

You can specify a custom format beneath the `format` key just like a built-in format. For example:

``` yaml
---
title: "My Document"
format:
   acm-pdf: 
     toc: true
---
```

Custom formats all derive from one of the base formats, and include that base format as a suffix. Formats can also provide multiple variations that derive from distinct base formats. For example:

``` yaml
---
title: "My Document"
toc: true
format:
   acm-pdf: default
   acm-html: default
---
```

Note that we moved the `toc` option to the top level since it is shared between both of the formats.

Custom formats can also be used with the `--to` argument to `quarto render`. For example:

``` {.bash filename="Terminal"}
quarto render document.qmd --to acm-html
```

 Note that if you are specifically interested in using or creating custom formats for journals and manuscripts, you may want to proceed instead to the documentation on [Journal Articles](/docs/journals/index.qmd).

## Quick Start

Here we'll describe how to create a simple HTML-based format extension. We'll use the `quarto create` command to do this. If you are using VS Code or RStudio you should execute `quarto create` within their respective integrated Terminal panes. 

To get started, execute `quarto create extension format:html` within the parent directory where you'd like the format to be created:

```{.bash filename="Terminal"}
$ quarto create extension format:html
 ? Extension Name › lexdoc
```

As shown above, you'll be prompted for an extension name. Type `lexdoc` (a document format for a fictional company named LexCrop) and press Enter---the custom format extension is then created:

```bash
Creating extension at /Users/jjallaire/quarto/dev/lexdoc:
  - Created README.md
  - Created _extensions/lexdoc/custom.scss
  - Created _extensions/lexdoc/_extension.yml
  - Created template.qmd
```

If you are running within VS Code or RStudio a new window will open with the extension project. 

::: {.callout-note appearance="simple"}
Note that this example creates a format that is derivative of the Quarto base `html` format. You can similarly create formats that are derivative of `pdf`, `docx`, and `revealjs` as follows:

```{.bash filename="Terminal"}
quarto create extension format:pdf
quarto create extension format:docx
quarto create extension format:revealjs
```
:::

Here's what the contents of the files in `_extensions/lexdoc/` look like:

``` {.yaml filename="_extensions/lexdoc/_extension.yml"}
title: Lexdoc
author: J.J. Allaire
version: 1.0.0
quarto-required: ">=1.2.222"
contributes:
  formats:
    html:
      toc: true
      theme: [yeti, custom.scss]
```

The custom HTML format defined here is very simple. It takes the base `html` format, turns on the table of contents by default, and sets the theme as `yeti` along with a `custom.scss` file for additional customizations:

```{.css filename="_extensions/lexdoc/custom.scss"}
/*-- scss:defaults --*/

/* TODO: Customize appearance with SCSS variables */
/* See [HTML theme](https://quarto.org/docs/output-formats/html-themes.html#theme-options) */

/*-- scss:rules --*/

/* TODO: Provide custom CSS rules */
```

Finally, the `template.qmd` provides a base example article for users of the format:

``` {.markdown filename="template.qmd"}
---
title: "Lexdoc Example"
format:
  lexdoc-html: default
author: J.J. Allaire
date: last-modified
---

## Introduction

*TODO* Create an example file that demonstrates the formatting and features of your format.

## More Information

You can learn more about controlling the appearance of HTML output here: <https://quarto.org/docs/output-formats/html-basics.html>
```

To develop your format, render/preview `template.qmd`, and then make changes to the various files in the `_extensions` directory (the preview will automatically refresh when you change these files).


## Example: Revealjs

Next, we'll walk through the creation of a custom format that extends the `revealjs` presentation format. Here is what the source code repository of the format extension might look like:

``` default
README.md
LICENSE
template.qmd
_extensions/
  lexconf/
    _extension.yml
    theme.scss
    logo.png
    title.png
```

Note that the format suffix (`revealjs`) is excluded from the directory name (this is to account for the possibility of multiple formats e.g. `lexconf-revealjs`, `lexconf-pptx`, etc.)

As with other types of extensions, the only thing strictly required is the `_extensions` directory (anything above that is for your own purposes and is ignored during format installation). Even so, it's good practice to include a `README.md` and `LICENSE` file. The `template.qmd` file serves a couple of purposes:

1.  It can be rendered as you develop your format to ensure that things work as expected.
2.  It can serve as the basis for a format template (which helps users gets started with using your format).

Here is what the contents of `_extension.yml` might look like:

``` yaml
title: LexConf 2022 Presentation
author: LexCorp
version: 1.0.0
quarto-required: ">=1.2.0"
contributes:
  formats:
    revealjs:
       theme: [default, theme.scss]
       logo: logo.png
       footer: | 
         Copyright 2022 (c) LexCorp, Inc.
       title-slide-attributes:
          data-background-image: title.png
          data-background-size: contain
       preview-links: auto
       
```

This format mostly provides organization-level content and theming. As mentioned above, formats can also include filters which allow for adding custom markdown constructs and rendering behavior.

Here is what the contents of `template.qmd` might look like:

``` markdown
---
title: "Presentation"
subtitle: "LexConf 2022"
author: "Your Name"
date: today
format: lexconf-revealjs
---

# Overview
```

Extension repositories are structured in such a way that you can test your extension and the template by simply rendering the `template.qmd` file right in the root of your repository. The `template.qmd` will be able to load your extension just as it would when installed, so testing and iterating should be as simple as working within your extension directory until you're satisfied (without the need to repeatedly install or update the extension in order to test it).

## Format Templates

Above we described including a `template.qmd` alongside your extension and then installing the template and format together with:

``` {.bash filename="Terminal"}
quarto use template <gh-organization>/<extension>
```

The `template.qmd` should demonstrate the functionality of the format and serve as a sound starting point for the user. When the extension template is copied into the target directory, the `template.qmd` will automatically be renamed to match the name that the user provided for the directory.

You can also include other files alongside `template.qmd` and they will be copied as well. Note that by default, Quarto will exclude common Github repository files when copying an extension template. This includes any file name or directory starting with a `.` (e.g. `.gitignore`), `README.md`, `LICENSE`, etc.. If you'd like, you can place a `.quartoignore` file in the root of your repository with each line of the file being a glob describing file(s) to ignore (using syntax like a `.gitignore` file).

{{< include _formats-common.qmd >}}
```````

## File: docs/extensions/index.qmd
```````
---
title: "Quarto Extensions"
listing: 
  id: listing-filters
  contents: listings/shortcodes-and-filters.yml
metadata-files: 
  - listings/_metadata.yml
---

{{< include _listing-preamble.qmd >}}

### Shortcodes and Filters {.unlisted}

::: {#listing-filters .column-body-outset-right}
:::

{{< include _listing-footer.qmd >}}
```````

## File: docs/extensions/listing-filters.qmd
```````
---
title: "Quarto Extensions"
listing: 
  id: listing-filters
  contents: listings/shortcodes-and-filters.yml
metadata-files: 
  - listings/_metadata.yml
---

{{< include _listing-preamble.qmd >}}

### Shortcodes and Filters {.unlisted}

::: {#listing-filters .column-body-outset-right}
:::

{{< include _listing-footer.qmd >}}
```````

## File: docs/extensions/listing-formats.qmd
```````
---
title: "Quarto Extensions"
listing: 
  id: listing-formats
  contents: 
    - listings/custom-formats.yml
    - listings/revealjs-formats.yml
metadata-files: 
  - listings/_metadata.yml
---

{{< include _listing-preamble.qmd >}}

### Custom Formats {.unlisted}

::: {#listing-formats .column-body-outset-right}
:::

{{< include _listing-footer.qmd >}}
```````

## File: docs/extensions/listing-journals.qmd
```````
---
title: "Quarto Extensions"
listing: 
  id: listing-journals
  contents: listings/journal-articles.yml
metadata-files: 
  - listings/_metadata.yml
---

{{< include _listing-preamble.qmd >}}

### Journal Articles {.unlisted}

::: {#listing-journals .column-body-outset-right}
:::

{{< include _listing-footer.qmd >}}
```````

## File: docs/extensions/listing-revealjs.qmd
```````
---
title: "Quarto Extensions"
listing: 
  id: listing-revealjs
  contents: 
    - listings/revealjs.yml
    - listings/revealjs-formats.yml
metadata-files: 
  - listings/_metadata.yml
---

{{< include _listing-preamble.qmd >}}

### Revealjs Extensions {.unlisted}

::: {#listing-revealjs .column-body-outset-right}
:::

{{< include _listing-footer.qmd >}}
```````

## File: docs/extensions/lua-api.qmd
```````
---
title: "Lua API Reference"
---

{{< include _extension-version.qmd >}}

## Overview

This article provides documentation on the standard APIs available when implementing Lua filters and shortcodes. There are three major sets of APIs available:

-   **Lua Base API**---Base functions provided for string handling, pattern matching, table manipulation, and file input and output.

-   **Pandoc Lua API**---Core API provided by Pandoc for filter development, and includes both core AST types (e.g. `pandoc.Div`, `pandoc.CodeBlock`, etc.) as well as a wide variety of helper functions for common tasks.

-   **Quarto Lua API**---Additional functions used for debugging, format detection, encoding (e.g. JSON), and adding dependencies to documents (e.g. JavaScript libraries or LaTeX packages).

To get started with programming in Lua and learn about some recommended tools and workflow, see the article on [Lua Development](lua.qmd).

## Lua Base API

The Lua standard library provides core functions for low-level string, math, table, and file operations. Here we provide links to a few of the more useful standard libaries (complete documentation can be found in the [Lua Reference Manual](https://www.lua.org/manual/5.3/)).

| Library | Description |
|---------------------------------|---------------------------------------|
| [string](https://www.lua.org/manual/5.3/manual.html#6.4) | This library provides generic functions for string manipulation, such as finding and extracting substrings, and pattern matching. |
| [utf8](https://www.lua.org/manual/5.3/manual.html#6.5) | This library provides basic support for UTF-8 encoding. |
| [table](https://www.lua.org/manual/5.3/manual.html#6.6) | This library provides generic functions for table manipulation. |
| [math](https://www.lua.org/manual/5.3/manual.html#6.7) | This library provides basic mathematical functions. |
| [io](https://www.lua.org/manual/5.3/manual.html#6.8), [file](https://www.lua.org/manual/5.3/manual.html#6.8) | The I/O library provides two different styles for file manipulation: one uses implicit file handles and the other explicit handles. |
| [os](https://www.lua.org/manual/5.3/manual.html#6.9) | Date/time, locales, environment variables, etc. |

: {tbl-colwidths="\[30,70\]"}

## Pandoc Lua API

Complete documentation for the Pandoc Lua API can be found in the [Lua Filters](https://pandoc.org/lua-filters.html) article available on the Pandoc website. Here are the various components of the API along with links to their reference documentation:

| Lua Module | Description |
|--------------------------|----------------------------------------------|
| [pandoc](https://pandoc.org/lua-filters.html#module-pandoc) (ast) | Constructors for document tree elements (e.g. `pandoc.Div()`, `pandoc.Strong()`, etc.) as well as core components (e.g. `pandoc.Attr()`) |
| [pandoc](https://pandoc.org/lua-filters.html#helper-functions) (functions) | Functions to parse text in a given format, filter and modify a sub-tree, and run child processes. |
| [pandoc.text](https://pandoc.org/lua-filters.html#module-text) | UTF-8 aware text manipulation functions (e.g. `upper()`, `lower()`, etc.) |
| [pandoc.List](https://pandoc.org/lua-filters.html#module-pandoc.list) | This module defines pandoc's list type. It comes with useful methods and convenience function (e.g `find_if()`, `includes()`, `filter()`, `map()`, etc.) |
| [pandoc.utils](https://pandoc.org/lua-filters.html#module-pandoc.utils) | Internal pandoc functions and utility functions (e.g. `blocks_to_inlines()`, `stringify()`, `citeproc()`, etc.) |
| [pandoc.path](https://pandoc.org/lua-filters.html#module-pandoc.path) | Module for file path manipulations (e.g. `is_absolute()`, `is_relative()`, `join()`, etc. |
| [pandoc.system](https://pandoc.org/lua-filters.html#module-pandoc.system) | Access to system information and functionality (e.g. `get_working_directory()`, `list_directory()`, etc. |
| [pandoc.mediabag](https://pandoc.org/lua-filters.html#module-pandoc.mediabag) | Access to pandoc's media storage. The "media bag" is used when pandoc is called with the `--extract-media` or (for HTML only) `--embed-resources` option. |
| [pandoc.template](https://pandoc.org/lua-filters.html#module-pandoc.template) | Compile and access defualt pandoc templates (e.g. `compile()`) |
| [pandoc.types](https://pandoc.org/lua-filters.html#module-pandoc.types) | Constructors for types which are not part of the pandoc AST (e.g. `Version()`) |

: {tbl-colwidths="\[30,70\]"}

## Quarto Lua API

### Utility Functions

Various utility functions are provided:

| Function | Description |
|---------------------|---------------------------------------------------|
| `quarto.version` | Return the current Quarto version as a `pandoc.Version` object. |
| `quarto.log.output(obj)` | Dump a text representation of the passed object to stdout. |
| `quarto.utils.resolve_path(path)` | Compute the full path to a file that is installed alongside your extension's Lua script. This is useful for *internal* resources that your filter needs but should not be visible to the user. |

Quarto includes the [pandoc-lua-logging](https://github.com/wlupton/pandoc-lua-logging) library, which should be used in preference to the dump function. For example, you can examine an element passed to a filter function as follows:

``` lua
function Div(el)
  quarto.log.output(el)
end
```

### Format Detection

Extensions will often need to detect the current format to create custom content depending on the target output medium. The `quarto.doc.is_format()` function

| Function | Description |
|---------------------|---------------------------------------------------|
| `quarto.doc.is_format(name)` | Detect if the current format matches `name`. |
| `quarto.doc.has_bootstrap()` | Query whether [Bootstrap CSS](https://getbootstrap.com/) is available within the current document (it is by default for standard `html` documents but this may have been overridden by e.g. `theme: none`). |

The `name` parameter can match an exact Pandoc format name (e.g. `docx`, `latex`, etc. or can match based on an alias that groups commonly targeted formats together. The following values format aliases are handled specially by `quarto.doc.is_format()`:

{{< include ../authoring/_format-aliases.md >}}

For example, here we check for PDF and HTML output:

``` lua
if quarto.doc.is_format("pdf") then
  -- pdf specific output
elseif quarto.doc.is_format("html") then
  -- html specific output
else
  -- output for other formats
end
```

For LaTeX output, you may need to additionally detect which citation utility and pdf engine are being used for the current render. You can use these functions to do that detection:

| Function | Description |
|----------------------|--------------------------------------------------|
| `quarto.doc.cite_method()` | Returns a string (`citeproc`, `natbib`, or `biblatex)` indicating the cite method in use. |
| `quarto.doc.pdf_engine()` | Returns a string (`pdflatex`, `xelatex`, `lualatex`, or `tectonic`) indicating the PDF engine being used to render the document. |

### Includes

Sometimes extensions need to inject content into the target document. There are three locations that content can be included (pass one of these locations as the first argument of the include functions):

| Location | Description |
|----------------------|--------------------------------------------------|
| `in-header` | In the header of the document (HTML `<head>` tag or LaTeX preamble) |
| `before-body` | Before the document body |
| `after-body` | After the document body |

Note that the included content should use the *raw target format* (e.g. HTML or LaTeX) rather than markdown. You can use these functions to include text or the contents of a file:

| Function | Description |
|----------------------|--------------------------------------------------|
| `quarto.doc.include_text(location, text)` | Include text at the specified location (`in-header`, `before-body`, or `after-body`) |
| `quarto.doc.include_file(location, file)` | Include file at the specified location (`in-header`, `before-body`, or `after-body`). The path to the file should *relative* to the Lua script calling this function. |

For example the following code includes an HTML file after the body in the rendered document:

``` lua
quarto.doc.include_file("after-body", "comments.html")
```

### Dependencies

Extensions will sometimes want to add external dependencies (for example, a JavaScript library and related CSS, or the usage of a LaTeX package). This can be accomplished with the following functions:

| Function | Description |
|---------------------|---------------------------------------------------|
| `quarto.doc.add_html_dependency(dep)` | Add an HTML dependency (additional resources and content) to a document. See docs on the [HTML Dependencies](#html-dependencies) below for additional details. |
| `quarto.doc.attach_to_dependency(name, attach)` | Attach a file to an existing dependency. `attach` is a file path relative to the Lua filter or table with \`path\` and \`name\` for renaming the file as its copied. |
| `quarto.doc.use_latex_package(pkg, opt)` | Adds a `\usepackage` statement to the LaTeX output (along an options string specified in `opt`) |
| `quarto.doc.add_format_resource(path)` | Add a format resource to the document. Format resources will be copied into the directory next to the rendered output. This is useful, for example, if your format references a `bst` or `cls` file which must be copied into the LaTeX output directory. |

For example, here we add a LaTeX package dependency:

``` lua
quarto.doc.use_latex_package("gamebook")
```

#### HTML Dependencies {#html-dependencies}

HTML Dependencies can bundle together JavaScript, CSS, and even arbitrary content to inject into the `<head>` of the document. These dependencies have a name and a version, which is used to ensure that the same dependency isn't bundled into the document more than once.

The `dep` object passed to `quarto.doc.add_html_dependency()` has the following fields:

| Field | Description |
|---------------------|---------------------------------------------------|
| `name` | Unique name. Required. |
| `version` | Version number (as a string). Required. |
| `scripts` | List of scripts to include (paths can be absolute or relative to the Lua file calling the function). Scripts can be either a simple path or a [script object](#script-object). |
| `stylesheets` | List of CSS style-sheets to include (paths can be absolute or relative to the Lua file calling the function). Stylesheets can either be a simple path or a [stylesheet object](#stylesheet-object) |
| `links` | List of link tags to add to the document. Each tag should be a table with `rel` and `ref` (required) and optionally `type` |
| `resources` | Additional files to copy to the input directory (each resource is an object with `name` (target file name in input directory) and `path` (source file name relative to Lua script). |
| `serviceworkers` | JavaScript serviceworker files that should be copied to the root output directory (can be a simple string file name or table with \`path\` and \`name\` for renaming the file as its copied). |
| `meta` | Table of optional `key = value` meta tags to insert into the document `<head>` |
| `head` | Arbitrary string to include in document `<head>` |

For example, here we add a dependency to a JavaScript library:

``` lua
quarto.doc.add_html_dependency({
  name = "glightbox",
  version = "3.2.0",
  scripts = {"glightbox.min.js"},
  stylesheets = {"glightbox.min.css"}
})
```

#### Script Object {#script-object}

The easiest way to specify `scripts` is with simple paths. However, in some cases you may need to add attributes to the `<script>` tag or specify that the script should go after the body. In those cases pass a script object:

| Field | Description |
|----------------------|--------------------------------------------------|
| `path` | Path to the script (relative to the calling Lua script) |
| `attribs` | Table with `key = value` attributes to add to the `<script>` tag |
| `afterBody` | Specify that the `<script>` tag should be inserted after the body |

For example, here update the previous example to add an `integrity` attribute to the script:

``` lua
quarto.doc.add_html_dependency({
  name = "glightbox",
  version = "3.2.0",
  scripts = {
    { path = "glightbox.min.js ", attribs = {integrity = "R9GqQ8K/uxy9rx"} }
  },
  stylesheets = {"glightbox.min.css"}
})
```

#### Stylesheet Object {#stylesheet-object}

The easiest way to specify `stylesheets` is with simple paths. However, in some cases you may need to add attributes to the `<link>` tag generated for the stylesheet. In those cases pass a stylesheet object:

| Field     | Description                                                    |
|---------------------|---------------------------------------------------|
| `path`    | Path to the stylesheet (relative to the calling Lua script)    |
| `attribs` | Table with `key = value` attributes to add to the `<link>` tag |

For example, here we update the previous example to add an `integrity` attribute to the stylesheet:

``` lua
quarto.doc.add_html_dependency({
  name = "glightbox",
  version = "3.2.0",
  scripts = {
    { 
      path = "glightbox.min.js ", 
      attribs = {integrity = "R9GqQ8K/uxy9rx"} 
    }
  },
  stylesheets = {
    { 
      path = "glightbox.min.css ", 
      attribs = {integrity = "GYl1kPzQho1wx"} 
    }
  }
})
```

### JSON Encoding

Quarto includes a copy of [json.lua](https://github.com/rxi/json.lua). a lightweight JSON library for Lua. You can access the JSON functions as follows:

| Function                    | Description                            |
|-----------------------------|----------------------------------------|
| `quarto.json.encode(input)` | Encode a Lua table into a JSON string. |
| `quarto.json.decode(str)`   | Parse a JSON string into a Lua table.  |

For example, here we encode and then decode a table:

``` lua
local json = quarto.json.encode({foo = "bar"})
local obj = quarto.json.decode(json)
```

### Base64 Encoding

Quarto includes a copy of [lbase64](https://github.com/iskolbin/lbase64), a pure Lua implementation of Base64 encoding. You can access the Base 64 encoding functions as follows:

| Function                       | Description                   |
|--------------------------------|-------------------------------|
| `quarto.base64.encode(str)`    | Encode a string into Base 64. |
| `quarto.base64.decode(b64str)` | Decode a Base 64 string.      |

### Paths

Quarto exposes paths to utilities that are likely to be useful to Lua extension and filter authors. Currently, only the ones below are supported:

| Function | Description |
|------------------------------------|------------------------------------|
| `quarto.paths.rscript()` | Returns the path to `Rscript` that Quarto uses in the `knitr` engine and R files for `quarto run` scripts |
| `quarto.paths.tinytex_bin_dir()` | Returns the path to `TinyTeX` binaries directory (where `tlmgr`, `pdlatex` and others are). If Quarto did not install `TinyTeX` and does not found it, it will return `nil`. This means that PDF rendering by Quarto probably used tools found in PATH. |

### Shortcodes

Quarto offers the following helper functions for shortcode developers, to be typically used in shortcode handlers. See the [shortcode development](/docs/extensions/shortcodes.qmd) documentation for more:

| Function | Description |
|----------|-------------|
| `quarto.shortcode.read_arg(args, [n])` | Returns the `n`-th argument of the shortcode invocation |
| `quarto.shortcode.error_output(name, message_or_args, context)` | Creates output to be used by shortcodes to depict an execution error, consistently with how Quarto shows such outputs |
```````

## File: docs/extensions/lua.qmd
```````
---
title: Lua Development
resources: 
  - luarefv51.pdf
---

{{< include _extension-version.qmd >}}

## Overview

The programming language used to create [filters](filters.qmd) and [shortcodes](shortcodes.qmd) is Lua, a lightweight, high-level scripting language. [Lua](https://www.lua.org/) is the extension language for Pandoc (which includes an embedded Lua interpreter). This means that Quarto extensions have no additional runtime dependencies or requirements.

This article will start by providing an orientation to learning Lua for those new to the language. Then, we'll provide some tips for productive Lua development.

See the [Lua API Reference](lua-api.qmd) for additional details on the APIs available for developing extensions.

## Learning Lua

Lua is a scripting language similar to Python, R, Julia, and JavaScript. If you are familiar with one or more of those languages you won't have trouble picking up Lua.

Here is a recommended approach for learning Lua for use with Quarto:

1.  Read [Learn Lua in 15 Minutes](https://learnxinyminutes.com/docs/lua/) for a quick overview of the language and its syntax.

2.  Check out the first two sections of the [Pandoc Lua Filters](https://pandoc.org/lua-filters.html) documentation then skip ahead to the [Filter Examples](https://pandoc.org/lua-filters.html#macro-substitution) section to make things a bit more concrete.

3.  Once you have the basic idea of Lua and filters, get a more complete picture by skimming the full [Pandoc Lua Filters](https://pandoc.org/lua-filters.html) documentation. You won't understand everything, but it's a good orientation to all of the moving parts.

4.  Finally, check out the source code of the extensions published in the [Quarto Extensions](https://github.com/quarto-ext) GitHub organization (these are extensions maintained by the Quarto core team). Once you are able to read and understand that code you are ready to start developing your own extensions!

Some additional learning resources you might find useful include:

1.  [Lua Quick Reference](luarefv51.pdf), a PDF with a compact summary of the language and base library.

2.  [Programming in Lua](https://www.amazon.com/exec/obidos/ASIN/8590379868/lua-pilindex-20), a book by Roberto Ierusalimschy, the chief architect of the language.

3.  [Lua Reference Manual](https://www.lua.org/manual/5.3/), a complete definition of the language and base library.

## Development Tools

### Quarto Preview

Quarto preview, `quarto preview`, is aware of Lua source files within extensions, and will automatically reload the preview whenever a Lua source file changes.

This makes it very easy to incrementally develop and debug Lua code (especially when combined with the [native](#native-format) format a described below). Live reloading for Lua files will work no matter what source code editor you are using (VS Code, RStudio, Neovim, etc.).

### VS Code

While you can use any text editor along with `quarto preview` for developing Lua extensions, we strongly recommend that you consider using VS Code, as it provides a number of additional tools including:

1.  Code completion and type checking.

2.  Diagnostics for various common problems with code.

3.  The ability to add types to your own functions.

Code completion covers the Lua base library as well as the Pandoc and Quarto Lua APIs, and also provides documentation on hover:

![](images/vscode-lua-completions.png){.border fig-alt="Screenshot of Lua file open in VS Code with code completion popup showing for Lua function." width="95%"}

Diagnostics check for many common errors including failing to check for `nil`, undefined global values, shadowing of local variables, unused functions, etc.

![](images/vscode-lua-diagnostics.png){.border fig-alt="Screenshot of Lua file open in VS Code with diagnostic errors shown in Problems pane below the code editor." width="95%"}

#### Installation

To get started with using VS Code for Lua extension development, install the following software:

1.  Install the latest version (v1.2 or greater) of [Quarto](/docs/download/index.qmd)

2.  Install the latest version (v1.40.0 or greater) of the [Quarto VS Code Extension](https://marketplace.visualstudio.com/items?itemName=quarto.quarto).

3.  For Lua code intelligence, install the [Lua LSP VS Code Extension](https://marketplace.visualstudio.com/items?itemName=sumneko.lua).

Once you've installed these components you should see the features described above appear automatically in your Quarto workspaces that include Lua code.

There are many options available for configuring Lua completion and diagnostics. It's also possible to provide type information for your own functions. See the section on [Lua in VS Code](#lua-in-vs-code) below for details.

## Diagnostic Logging

Use the functions in the `quarto.log` module to add diagnostic logging to your extension. You can use both temporary logging calls to debug a particular problem as well as add logging calls that are always present but only activated when the `--trace` flag is passed to `quarto render` or `quarto preview`.

The `quarto.log` module is based on the [pandoc-lua-logging](https://github.com/wlupton/pandoc-lua-logging) project from [\@wlupton](https://github.com/wlupton). You'll recognize the functions described below from that module (e.g. `logging.output()`, `logging.warning()`, etc). For documentation on using all of the logging functions see the project [README](https://github.com/wlupton/pandoc-lua-logging) file.

### quarto.log.output

To log any object (including Pandoc AST elements), you the `quarto.log.output()` function. For example, here we log the `Div` passed to us in our filter callback function as well as some diagnostic text:

``` {.lua filename="filter.lua"}
function Header(el)
  quarto.log.output("=== Handling Header ===")
  quarto.log.output(el)
end
```

This is log output you'd see in the terminal when the filter is executed:

``` default
=== Handling Header ===
Header {
  attr: Attr {
    attributes: AttributeList {}
    classes: List {}
    identifier: "section-one"
  }
  content: Inlines {
    [1] Str "Section"
    [2] Space
    [3] Str "One"
  }
  level: 2
}
```

### quarto.log.warning

Use the `quarto.log.warning()` function to output warnings that can be suppressed with the `--quiet` flag:

``` {.lua filename="filter.lua"}
function RawBlock(el)
  if el.format == "html" then
    quarto.log.warning("Raw HTML not supported")
    return pandoc.Null()
  end
end
```

For example, the warning above will not appear for this call to `quarto render`:

``` bash
quarto render document.qmd --quiet
```

### quarto.log.debug

Use the `quarto.log.debug()` function to write output whenever the `--trace` flag is present:

``` {.lua filename="filter.lua"}
function Header(el)
  quarto.log.debug("Header: " .. el.identifier)
end
```

For example, the debug message will appear for this call to `quarto preview`:

``` bash
quarto preview document.qmd --trace
```

You can keep these calls in your filter since they won't produce output unless `--trace` is specified.

## Native Format {#native-format}

A great tool for understanding the behavior of a Lua filter or shortcode in more depth is to target the `native` format (as opposed to `html`, `pdf`, etc.). The `native` format will show you the raw contents of the Pandoc AST. For example, here's a simple markdown document alongside it's `native` output:

::: {layout-ncol="2"}
<div>

``` {.markdown filename="document.qmd"}
---
format: native
---

## Heading

Some text below




```

</div>

<div>

``` border
Pandoc
  Meta
    { unMeta = fromList [] }
  [ Header
      2
      ( "heading" , [] , [] )
      [ Str "Heading" ]
  , Para
      [ Str "Some"
      , Space
      , Str "text"
      , Space
      , Str "below"
      ]
  ]
```

</div>
:::

Here we add a simple filter to the document that wraps all headers in `pandoc.Emph` (italics). You can see that the `Emph` AST element now wraps the heading text in the `native` output:

::: {layout-ncol="2"}
<div>

``` {.markdown filename="document.qmd"}
---
format: native
filters: [filter.lua]
---

## Heading

Some text below
```

``` {.lua filename="filter.lua"}
function Header(el)
  el.content = { 
    pandoc.Emph(el.content)
  }
  return el
end
```

</div>

::: {.font-monospace .border}
::: {style="font-size: 0.875em; padding: 4px;"}
| Pandoc
|   Meta
|     { unMeta = fromList \[\] }
|   \[ Header
|       2
|       ( "heading" , \[\] , \[\] )
|       **\[ Emph \[ Str "Heading" \]**
|       \]
|   , Para
|       \[ Str "Some"
|       , Space
|       , Str "text"
|       , Space
|       , Str "below"
|       \]
|   \]
| 
| 
| 
:::
:::
:::

## Lua in VS Code {#lua-in-vs-code}

### Type Hints

While Quarto provides type information for the Pandoc and Quarto Lua APIs, this doesn't cover functions that you write within your own extensions. You can however add type information using [Annotations](https://luals.github.io/wiki/annotations). For example, here we indicate that a function takes a `string` and a `pandoc.List()` and returns either a `pandoc.List()` or `nil`:

``` lua
---@param text string
---@param blocks pandoc.List
---@return pandoc.List|nil
function check_for_text(text, blocks)
  -- implementation
end
```

With these type declarations, any attempt to call the function without the correct types will result in a diagnostic message. Further, if a caller fails to check for `nil` before using the return value a diagnostic will also occur.

You can learn more about all of the available type annotations in the [Annotations Reference](https://luals.github.io/wiki/annotations) for the Lua Language Server.

### Settings

The [Lua Language Server](https://marketplace.visualstudio.com/items?itemName=sumneko.lua) extension includes a wide variety of options to customize its behavior (e.g. what diagnostics to show, which completions to offer, etc.).

All of the available options are documented in the [Settings Reference](https://luals.github.io/wiki/settings/) for the Lua Language Server.

Quarto provides a default configuration file (`.luarc.json`) within the root of any workspace that includes Quarto Lua extensions. This file is necessary because it provides a reference to the Lua type definitions for Pandoc and Quarto within your currently installed version of Quarto. Without it, the Lua extension wouldn't know anything about Quarto and would report errors for "unknown" Pandoc modules.

If, for example, Quarto is installed at `/opt/quarto/`, the default contents of the configuration file will be:

``` {.json filename=".luarc.json"}
{
  "Generator": ["Quarto"],
  "Lua.runtime.version": "Lua 5.3",
  "Lua.workspace.checkThirdParty": false,
  "Lua.workspace.library": ["/opt/quarto/share/lua-types"],
  "Lua.runtime.plugin": "/opt/quarto/share/lua-plugin/plugin.lua",
  "Lua.completion.showWord": "Disable",
  "Lua.completion.keywordSnippet": "Both",
  "Lua.diagnostics.disable": ["lowercase-global", "trailing-space"]
}
```

The `.luarc.json` file will also be automatically added to `.gitignore` since it points to the absolute path of Quarto on the local system.

You can change any of the settings within this file save for the `Lua.workspace.library` and `Lua.runtime.plugin` (these are automatically maintained by the Quarto extension based on where Quarto is installed). See the [Settings Reference](https://luals.github.io/wiki/settings/) for all available settings.

If you prefer to manage this file manually, simply remove the `Generator` key and Quarto will no longer update the `Lua.workspace.library` and `Lua.runtime.plugin` settings automatically.

You can also globally disable the automatic creation of `.luarc.json` using the **Quarto \> Lua: Provide Types** VS Code setting.
```````

## File: docs/extensions/managing.qmd
```````
---
title: "Managing Extensions"
---

{{< include _extension-version.qmd >}}

## Installation

If you want to use an extension within a document or project you need to add it to a project or directory. Rather than installing into a global library, Quarto extensions are stored locally, directly alongside the document or project they are used within. For example, if you have a project in a directory named `myblog`, you could add some extensions for use with that the project as follows:

``` {.bash filename="Terminal"}
cd myblog
quarto add quarto-ext/fontawesome
quarto add quarto-ext/video
```

This will result in an `_extensions` folder being created at the root of your project, and the `fontawesome` and `video` extensions being placed within it.

Note that a project isn't strictly required for using extensions---if you add extensions in a directory that isn't a project then any document located directly alongside the `_extensions` folder can use the extensions.

{{< include _extension-trust.qmd >}}

### Version Control

If you are using version control you should check the `_extensions` directory in to your repo along with your other code. Extensions used by a document or project are treated as source code to ensure very long term reproducibility---your project doesn't need to rely on the availability of an external package manager (or the maintenance of older extension versions) to successfully render now and far into the future.

## Repositories

The extensions in the example above were prefixed with `quarto-ext` because they were distributed from the [quarto-ext](https://github.com/quarto-ext/) GitHub organization. Extensions can be similarly distributed from **any** GitHub organization. So for example the following might also be valid command to add extensions to a project:

``` {.bash filename="Terminal"}
quarto add cooltools/lightbox
quarto add bigstateu/fancytweet
```

While it's convenient to distribute extensions using GitHub, you can also bundle them into a `.zip` or `.tar.gz` archive and distribute them using a URL or a local file. See the article on [Distributing Extensions](distributing.qmd) for additional details.

## Updating

You can list and update configured extensions for a given project with the following commands:

``` {.bash filename="Terminal"}
quarto list extensions
quarto update quarto-ext/fontawesome
```

Note that when updating an extension you'll be prompted to confirm the update based on the version you have and the version you are attempting to update to.

## Removing

Use this command to remove an extension from a project:

``` {.bash filename="Terminal"}
quarto remove quarto-ext/fontawesome
```

If you run the `quarto remove extension` command with no `extension-id`, you will be presented with a list of extensions that are present and you may select which extensions to remove.
```````

## File: docs/extensions/metadata.qmd
```````
---
title: "Metadata Extensions"
---

Metadata extensions are Quarto extensions that provide metadata (YAML objects) that can be merged to existing Quarto configurations in a reusable manner.

::: callout-important

Currently, metadata extensions only merge project-level metadata. This limitation will be lifted in the future.

:::

### Quick Start

Here we'll describe how to create a simple metadata extension. We'll use the `quarto create` command to do this. If you are using VS Code or RStudio you should execute `quarto create` within their respective integrated Terminal panes. 

To get started, execute `quarto create extension metadata` within the parent directory where you'd like the filter extension to be created:

```{.bash filename="Terminal"}
$ quarto create extension metadata
 ? Extension Name › my-prerender-scripts
```

As shown above, you'll be prompted for an extension name. Type `my-prerender-scripts` and press Enter---the filter extension is then created:

```bash
? Extension Name › my-prerender-scripts
Creating extension at /Users/cscheid/Desktop/my-prerender-scripts:
  - Created README.md
  - Created _extensions/my-prerender-scripts/_extension.yml
  - Created .gitignore
? Open With
❯ vscode
  rstudio
  (don't open)
```

If you are running within VS Code or RStudio a new window will open with the extension project. 

## Contents of Metadata Extensions

Here's what the contents of the files in `_extensions/my-prerender-scripts/` look like:

``` {.yaml filename="_extensions/my-prerender-scripts/_extension.yml"}
title: My-prerender-scripts
author: Carlos Scheidegger
version: 1.0.0
quarto-required: ">=99.9.0"
contributes:
  metadata:
    project:
      # your per-project metadata goes here
```

## How Metadata Extensions Work

Under the `project` key, any YAML you add will be automatically merged to _any_ project using this extension.
This behaves differently from custom project extensions.
Quarto projects using metadata extensions do not need to change their project types for the metadata to be merged.

::: callout-note

As noted above, metadata extensions only merge project-level metadata in the `project` key. This limitation will be lifted in the future.

:::
```````

## File: docs/extensions/nbfilter.qmd
```````
---
title: "Notebook Filters"
---

## Overview

If you are rendering existing Jupyter notebooks that were not created with Quarto in mind, you may wish to do some pre-processing on the notebook prior to its conversion to markdown. This can be accomplished by specifying one or more `ipynb-filters`. These filters are passed the [JSON representation](https://nbformat.readthedocs.io/en/latest/format_description.html) of the notebook on `stdin` and should write a transformed JSON representation to `stdout`.

::: callout-note
The purpose of notebook filters is to adapt existing `.ipynb` files for use with Quarto. Consequently, notebook filters are only run when the original input is an `.ipynb` file (they are not run for `.qmd` files).
:::

## Example

For example, this notebook filter uses the [nbformat](https://nbformat.readthedocs.io/en/latest/index.html) package to read a notebook, prepend a comment to the source of each code cell, and then write it back to `stdout`:

``` python
import sys
import nbformat

# read notebook from stdin
nb = nbformat.reads(sys.stdin.read(), as_version = 4)

# prepend a comment to the source of each cell
for index, cell in enumerate(nb.cells):
  if cell.cell_type == 'code':
     cell.source = "# comment\n" + cell.source
  
# write notebook to stdout 
nbformat.write(nb, sys.stdout)
```

You can arrange for this filter to be run using the `ipynb-filters` option (specified at either the document or project level):

``` yaml
---
ipynb-filters:
  - filter.py
---
```

Note that the current working directory for the filter will be set to the location of the input notebook.
```````

## File: docs/extensions/project-types.qmd
```````
---
title: "Project Types"
---

{{< include _extension-version.qmd >}}

## Overview

Custom project types provide the ability to tailor projects for a particular purpose. This could be used to create a project type that implements an organization-level standard for creating documentation or conducting analyses.

For example, if you created a project type extension called `lexdocs`, it could be used with:

``` {.yaml filename="_quarto.yml"}
project:
  type: lexdocs
```

This single line of configuration could provide:

-   Navigational elements
-   Headers and footers
-   Document filters
-   Graphical elements
-   HTML options and styles

If you additionally include some basic scaffolding as a [Starter Template](starter-templates.qmd) for using the project type, and host it within a GitHub repository, then users could get a new project up and running as simply as:

``` {.bash filename="Terminal"}
quarto use template lexcorp/lexdocs
```

Note that it is possible to bundle and distribute project type extensions as simple gzip archives (as opposed to using a GitHub repository as described above). See the article on [Distributing Extensions](distributing.qmd) for additional details.

## Development Tools

If you are using custom project types within VS Code or RStudio, only the very latest versions of these tools handle custom project types correctly:

-   For the Quarto VS Code Extension, use [version 1.45](https://marketplace.visualstudio.com/items?itemName=quarto.quarto) or greater.

-   For RStudio, use [version 2022.12](https://posit.co/download/rstudio-desktop/) or higher.

Please be sure to update your version(s) of these tools before proceeding.

## Complete Example

In this section we'll describe exactly what a project type extension should include by providing a complete example of the `lexdocs` project type alluded to above. Here are the files contained in our `lexdocs` project type:

``` bash
_quarto.yml
index.qmd
team.qmd
_extensions
  lexdocs/
    _extension.yml
    lexcorp.png
    theme.scss
    filter.lua
```

Note that this repository provides both:

1.  The project type extension (contained in the `_extensions` directory).

2.  A starter template for using the project type (the `_quarto.yml`, `index.qmd`, and `team.qmd` files in the root of the repository).

### Project Type Extension

Let's explore the code for the extension first. Here is the main `_extension.yml` file:

``` {.yaml filename="_extensions/lexdocs/_extension.yml"}
title: Lexdocs Project
author: Lexcorp, Inc.
version: 1.0.0
quarto-required: ">=1.2.0"
contributes:
  project:
    project:
      type: website
    website:
      sidebar: 
        contents: auto
        search: true
        style: docked
        background: light
        logo: lexcorp.png
      page-footer: |
        "Copyright 2022, Lexcorp, Inc." 
    format: lexdocs-html
  formats:
    html:
      theme: [default, theme.scss]
      code-overflow: wrap
      code-line-numbers: true
      filters:
        - filter.lua
```

The `contributes` key includes a `project` entry, which in turn defines the default values for the `_quarto.yml` configuration file when this project type is used.

Note that custom project types always need to inherit from one of the base project types built into Quarto (`default`, `website`, or `book`). Here we specify `project: type: website`.

You'll also note that we additionally define a `lexdocs-html` [Custom Format](formats.qmd) within the extension (and then make that the default format for the project). This enables us to reference that format explicitly within documents (e.g. if you want to include a document that renders both `pdf` and `lexdocs-html` variations).

There are three additional files referenced in the custom `project` definition in `_extension.yml`. We won't show their source code, but here's a rundown on the role they play:

-   `lexcorp.png` is a logo added to the `sidebar`.
-   `theme.scss` provides a [custom theme](/docs/output-formats/html-themes.qmd) for HTML output.
-   `filter.lua` provides some additional transformations required by the format.

### Starter Template

This repository also provides a starter template by including these files at the root of the repository:

-   `_quarto.yml` is the project configuration file
-   `index.qmd` is an empty default home page
-   `team.qmd` is a page where users of the project type are encouraged to list the team members who contributed.

Here's what `_quarto.yml` might look like:

``` {.yaml filename="_quarto.yml"}
project:
  title: "Docs Site"
  type: lexdocs
  
format:
  lexdocs-html:
    toc: true
```

Users of the template will naturally change the default `title`, and can add whatever other project-, website-, or format-level options they require (these options will be merged with the defaults provided by the extension).

## Markdown Publishing

If you are using Quarto to produce markdown for another publishing system, you can use a project type extension to tailor the markdown output created by Quarto, as well as integrate with the native preview capabilities of the other system.

Quarto includes a couple of built-in project-types for integrating with the [Hugo](/docs/output-formats/hugo.qmd) and [Docusaurus](/docs/output-formats/docusaurus.qmd) publishing systems. You can see the source code for these project types here:

-   [`hugo`](https://github.com/quarto-dev/quarto-cli/blob/main/src/resources/extensions/quarto/hugo/_extension.yml) project type

-   [`docusaurus`](https://github.com/quarto-dev/quarto-cli/blob/main/src/resources/extensions/quarto/docusaurus/_extension.yml) project type

### Hugo Example

Here is the `_extension.yml` file for the Hugo project type (this demonstrates a few of the additional options you'd typically specify when creating a project type for markdown publishing, we'll describe these options below):

``` {.yaml filename="_extension.yml"}
title: Hugo
author: RStudio, PBC
organization: quarto
contributes:
  project:
    project:
      type: default
      detect:
        - ["config.toml", "content"]
        - ["config/_default/config.toml", "content"]
      render:
        - "**/*.qmd"
        - "**/*.ipynb"
      preview:
        serve:
          cmd: "hugo serve --port {port} --bind {host} --navigateToChanged"
          env: 
            HUGO_RELATIVEURLS: "true"
          ready: "Web Server is available at"
    format: hugo-md
  formats:
    md:
      variant: gfm+yaml_metadata_block+definition_lists
      prefer-html: true
      fig-format: retina
      fig-width: 8
      fig-height: 5
      wrap: preserve
```

Let's look specifically at some project options provided for Hugo that you may not have seen before:

``` yaml
project:
  type: default
  detect:
    - ["config.toml", "content"]
    - ["config/_default/config.toml", "content"]
  render:
    - "**/*.qmd"
    - "**/*.ipynb"
  preview:
    serve:
      cmd: "hugo serve --port {port} --bind {host} --navigateToChanged"
      env: 
        HUGO_RELATIVEURLS: "true"
      ready: "Web Server is available at"
```

The `detect` option enables Quarto to automatically detect when to activate this project type based on the presence of one or more files.

The `render` option indicates which files Quarto should render (note that by default Quarto will render `.md` files, but this would interfere with Hugo's native rendering of `.md` files so we exclude them here).

The `preview` option enables `quarto preview` to launch the native preview server for Hugo. The `cmd` indicates the shell command to use (with spots to interpolate the `{port}` and `{host`}); the `env` option specifies values for environment variables; and the `ready` option is a sequence of characters to look for to indicate that the preview server has started and is ready to handle requests.

### Markdown Formats

When creating a project type for a markdown publishing system you'll always need to define a custom format along with it which defines what flavor of markdown to produce. In the case of Hugo we define the markdown flavor using the `variant` option:

``` yaml
formats:
  md:
    variant: gfm+yaml_metadata_block+definition_lists+smart
```

This results in GitHub Flavored Markdown w/ YAML metadata blocks (which Hugo requires for tags/categories/etc) in addition to support for definition lists and smart typography.

Note that for some systems you'll need to do more than just declare a variant. For example, in the case of Docusaurus we declare the variant as well as a Lua filter that deals with Docusaurus-specific constructs like MDX, Callouts, and Tabsets:

``` yaml
formats:
  md:
    variant: +yaml_metadata_block+pipe_tables+tex_math_dollars+header_attributes-all_symbols_escapable
    filters:
      - docusaurus.lua
```

A project type for any given markdown publishing system will have its own variant, and will often also require filters to deal with non-standard constructs and other vagaries of the target system.
```````

## File: docs/extensions/revealjs.qmd
```````
---
title: "Revealjs Plugins"
---

{{< include _extension-version.qmd >}}

## Overview

Revealjs plugins enable you to extend the capabilities of HTML presentations created with [Revealjs](/docs/presentations/revealjs/). The Reveal Plugin API is very rich, and many of the built-in capabilities of Quarto Revealjs presentations are implemented as plugins, including [Menu](https://github.com/quarto-dev/quarto-cli/tree/main/src/resources/formats/revealjs/plugins/menu), [Chalkboard](https://github.com/quarto-dev/quarto-cli/tree/main/src/resources/formats/revealjs/plugins/chalkboard), and [PDF Export](https://github.com/quarto-dev/quarto-cli/tree/main/src/resources/formats/revealjs/plugins/pdfexport).

Here are some examples of Revealjs plugins packaged as Quarto extensions:

| Extension                                                | Description                                                                          |
|----------------------------------------------------------|--------------------------------------------------------------------------------------|
| [Pointer](https://github.com/quarto-ext/pointer)         | Adds support for switching the cursor to a 'pointer' style element while presenting. |
| [Attribution](https://github.com/quarto-ext/attribution) | Display attribution text along the right edge of slides.                             |

: {tbl-colwidths="\[30,70\]"}

## Quick Start

Here we'll describe how to create a simple Revealjs plugin extension. We'll use the `quarto create` command to do this. If you are using VS Code or RStudio you should execute `quarto create` within their respective integrated Terminal panes. 

To get started, execute `quarto create extension revealjs-plugin` within the parent directory where you'd like the plugin extension to be created:

```{.bash filename="Terminal"}
$ quarto create extension revealjs-plugin
 ? Extension Name › shuffler
```

As shown above, you'll be prompted for an extension name. Type `shuffler` and press Enter---the Revealjs plugin extension is then created:

```bash
Creating extension at /Users/jjallaire/quarto/dev/shuffler:
  - Created README.md
  - Created _extensions/shuffler/_extension.yml
  - Created _extensions/shuffler/shuffler.css
  - Created _extensions/shuffler/shuffler.js
  - Created .gitignore
  - Created example.qmd
```

If you are running within VS Code or RStudio a new window will open with the extension project. 

Here's what the contents of the files in `_extensions/shuffler/` look like:

``` {.yaml filename="_extensions/shuffler/_extension.yml"}
title: Shuffler
author: J.J. Allaire
version: 1.0.0
quarto-required: ">=1.2.222"
contributes:
  revealjs-plugins:
    - name: RevealShuffler
      script:
        - shuffler.js
      stylesheet:
        - shuffler.css
```

``` {.lua filename="_extensions/shuffler/shuffler.js"}
window.RevealShuffler = function () {
  return {
    id: "RevealShuffler",
    init: function (deck) {
      // TODO: Implement your plugin functionality
      // Learn more at https://revealjs.com/creating-plugins/
      
      // This example shuffles the deck when the 'T' key is pressed
      deck.addKeyBinding({ keyCode: 84, key: "T" }, () => {
        deck.shuffle();
      });
    },
  };
};
```

There is also a `shuffler.css` file for providing any styles required by your plugin.

Finally, the `example.qmd` file includes code that exercises the extension. For example:

``` {.markdown filename="example.qmd"}
---
title: "Shuffler Example"
format:
  revealjs: default
revealjs-plugins:
  - shuffler
---

## Breakfast

- Eat eggs
- Drink coffee

## Dinner

- Eat spaghetti
- Drink wine
```

To develop your plugin, render/preview `example.qmd`, and then make changes to `shuffler.js` and `shuffler.css` (the preview will automatically refresh when you change these files).

## Installation and Use

If your extension source code it located within a GitHub repository, then it can be added by referencing the GitHub organization and repository name. For example, you can install the `attribution` extension with the following:

``` {.bash filename="Terminal"}
quarto add quarto-ext/attribution
```

Note that it is possible to bundle and distribute extensions as simple gzip archives (as opposed to using a GitHub repository as described above). See the article on [Distributing Extensions](distributing.qmd) for additional details.

Once an extension has been added, you can use the Reveal plugin by adding it to the `reveal-plugins` key. For example:

``` yaml
---
title: "My Presentation"
format: revealjs
revealjs-plugins:
  - attribution
---
```

## Plugin Packaging

Note that the plugins listed above were not initially developed for use with Quarto. Rather, they were developed intially as native Revealjs plugins and then packaged as Quarto extensions.

For example, you can find the original implementation of the attribution plugin here: <https://github.com/rschmehl/reveal-plugins/tree/main/attribution>. The plugin is implemented with a JavaScript file and a CSS file. To make the plugin available as a Quarto extension, we package these files along with an `_extension.yml` config file that registers the plugin. Here are the files in the Quarto extension:

``` bash
LICENSE
README.md
example.qmd
_extensions/
   attribution/
     _extension.yml
     attribution.js
     attribution.css
```

Note that the `LICENSE` and `README.md` are standard documentation files and the `example.qmd` is used for development and documentation of the extension. None of those files are actually installed by end users (rather only the contents of the `_extensions` directory is installed).

You can see the full source code of the Quarto version here: <https://github.com/quarto-ext/attribution> (we'll also walk through the code in detail below).

## Plugin Development

You can develop either entirely new Revealjs plugins from scratch or you can package existing Revealjs extensions as described above.

Here is a list of existing 3rd party plugins for Revealjs that you might consider packaging as Quarto extensions: <https://github.com/hakimel/reveal.js/wiki/Plugins,-Tools-and-Hardware>.

If you want to develop new plugins, check out the Quarto Reveal extensions listed above as well as the code of other 3rd party Reveal Plugins. The following documentation on the Revealjs website provides additional important technical details:

-   [API Methods](https://revealjs.com/api/)

-   [Reveal Events](https://revealjs.com/events/)

## Plugin Configuration

Some Revealjs plugins make available various user options. If you are developing a plugin from scratch, you should use a distinct key for your plugin's configuration. Users can use this key alongside other `revealjs` options. For example the `pointer` extension can be configured as follows:

``` yaml
---
title: "Example Presentation"
format:
  revealjs: 
    pointer:
      pointerSize: 18
      color: '#32cd32'
revealjs-plugins:
  - pointer
---
```

The extension accesses options using the `deck.getConfig()` function:

``` javascript
return {
  id: "pointer",
  init: (deck) => {
    const config = deck.getConfig();
    const options = config.pointer || {};
    // etc
  }
}
```

Note that when packaging an existing Revealjs plugin, you can override its default configuration using the `config` key within your `_extension.yml` file. For example, these are the overrides provided by the `pointer` extension:

``` yaml
title: Pointer
author: Charles Teague
contributes:
  revealjs-plugins:
    - name: RevealPointer
      script:
        - pointer.js
      stylesheet:
        - pointer.css
      config:
        pointer:
          key: "q"
          color: "red"
          pointerSize: 16
          alwaysVisible: false
```

## Example: Attribution

Here we'll walk through the complete source code for the [attribution](https://github.com/quarto-ext/attribution/) extension. This extension enables you to display attribution text sideways along the right edge of Revealjs slides.

Here are source files used to develop the extension:

``` bash
LICENSE
README.md
example.qmd
_extensions/
   attribution/
     _extension.yml
     attribution.js
     attribution.css
```

The `example.qmd` and documentation files are used for development of the extension only (it is not installed by end users). The other files provide extension registration (`_extension.yml`) and the actual implementation of the Revealjs plugin (`attribution.js` and `attribution.css`).

The `example.qmd` is a simple one-slide presentation that includes an image along with a div with class `.attribution`:

``` {.markdown filename="example.qmd"}
---
title: "Attribution Extension"
format: revealjs
revealjs-plugins:
  - attribution
---

## Forest Image

![](ingtotheforest.jpg)

::: {.attribution)
Photo courtesy of [@ingtotheforest](https://unsplash.com/@ingtotheforest)
:::
```

Note that the `revealjs-plugins` key references the `attribution` extension, which will implemented in the `_extensions/attribution` directory.

The `_extension.yml` file indicates that the extension is making available a Revealjs plugin along with the plugin name, script, and style-sheets (note that the plugin name is not arbitrary, it will be whatever name is used within the script that implements the plugin, in this case `RevealAttribution`):

``` {.yaml filename="_extensions/attribution/_extension.yml"}
title: Attribution
author:  Roland Schmehl
version: 0.1.0
quarto-required: ">=1.2.0"
contributes:
  revealjs-plugins:
    - name: RevealAttribution
      script:
        - attribution.js
      stylesheet:
        - attribution.css
```

The `attribution.js` file contains the implementation of the Plugin using the Revealjs Plugin API:

``` {.javascript filename="_extensions/attribution/attribution.js"}
window.RevealAttribution = window.RevealAttribution || {
  id: 'RevealAttribution',
  init: function(deck) {
      initAttribution(deck);
  }
};

const initAttribution = function(Reveal){

var ready = false;
var resize = false;
var scale = 1;

window.addEventListener( 'ready', function( event ) {

  var content;

  // Remove configured margin of the presentation
  var attribution = document.getElementsByClassName("attribution");
  var width = window.innerWidth;
  var configuredWidth = Reveal.getConfig().width;
  var configuredHeight = Reveal.getConfig().height;

  scale = 1/(1-Reveal.getConfig().margin);

  for (var i = 0; i < attribution.length; i++) {
    content = attribution[i].innerHTML;
    attribution[i].style.width = configuredWidth + "px";
    attribution[i].style.height = configuredHeight + "px";
    attribution[i].innerHTML = "<span class='content'>" + content + "</span>";
    attribution[i].style.transform = 'translate( -50%, -50% ) scale( ' + scale*100 + '% ) rotate(-180deg)';
  }

  // Scale with cover class to mimic backgroundSize cover
  resizeCover();

});

window.addEventListener( 'resize', resizeCover );

function resizeCover() {

  // Scale to mimic backgroundSize cover
  var attribution = document.getElementsByClassName("attribution");
  var xScale = window.innerWidth / Reveal.getConfig().width;
  var yScale = window.innerHeight / Reveal.getConfig().height;
  var s = 1;

  if (xScale > yScale) {
      // The div fits perfectly in x axis, stretched in y
      s = xScale/yScale;
  }
  for (var i = 0; i < attribution.length; i++) {
    attribution[i].style.transform = 'translate( -50%, -50% ) scale( ' + s*scale*100 + '% ) rotate(-180deg)';
  }
}

};
```

Finally, `attribution.css` includes the CSS that repositions and rotates the element with class `.attribution` on the far right side of the slide:

``` {.css filename="_extensions/attribution/attribution.css"}
/* Attribution plugin: text along the right edge of the viewport */
.attribution{
  position: absolute;
  top: 50%;
  bottom: auto;
  left: 50%;
  right: auto;
  font-size: 0.4em;
  pointer-events: none;
  text-align: center;
  writing-mode: vertical-lr;
  transform: translate( -50%, -50% ) scale( 100% ) rotate(-180deg);
}

/* Attribution plugin: activate pointer events for attribution text only */
.attribution .content{
  pointer-events: auto;
}
```
```````

## File: docs/extensions/shortcodes.qmd
```````
---
title: "Creating Shortcodes"
---

{{< include _extension-version.qmd >}}

This article describes how to create your own shortcodes.

{{< include /docs/authoring/_shortcodes.qmd >}}

## Quick Start

Here we'll describe how to create a simple shortcode extension. We'll use the `quarto create` command to do this. If you are using VS Code or RStudio, you should execute `quarto create` within their respective integrated terminal panes. 

To get started, execute `quarto create extension shortcode` within the parent directory where you'd like the shortcode extension to be created:

```{.bash filename="Terminal"}
$ quarto create extension shortcode
 ? Extension Name › shorty
```

As shown above, you'll be prompted for an extension name. Type `shorty` and press Enter---the shortcode extension is then created:

```bash
Creating extension at /Users/jjallaire/extensions/shorty/shorty:
  - Created README.md
  - Created _extensions/shorty/shorty.lua
  - Created _extensions/shorty/_extension.yml
  - Created .gitignore
  - Created example.qmd
```

If you are running within VS Code or RStudio, a new window will open with the extension project. 

Here's what the contents of the files in `_extensions/shorty/` look like:

``` {.yaml filename="_extensions/shorty/_extension.yml"}
title: Shorty
author: J.J. Allaire
version: 1.0.0
quarto-required: ">=1.2.222"
contributes:
  shortcodes:
    - shorty.lua
```

``` {.lua filename="_extensions/shorty/shorty.lua"}
return {
  ['shorty'] = function(args, kwargs, meta) 
    return pandoc.Str("Hello from Shorty!")
  end
}
```

Finally, the `example.qmd` file includes code that exercises the extension. For example:

``` {.markdown filename="example.qmd"}
---
title: "Shorty Example"
---

{{< shorty >}}
```

To develop your shortcode, render/preview `example.qmd`, and then make changes to `shorty.lua` (the preview will automatically refresh when you change `shorty.lua`).

## Development 

Shortcodes are created using Lua. If you aren't familar with Lua (or with Pandoc filters), here are some resources to help you along:

- [Lua Development](lua.qmd) (Lua is the language used to create shortcodes).

- [Lua API Reference](lua-api.qmd), which describes the Lua extension API for Quarto. Specifically, consider consulting the `quarto.shortcode.*` entry points.

Shortcodes are implemented as Lua functions that take one or more arguments and return a Pandoc AST node (or list of nodes).

Here's the implementation of the `env` shortcode that is built in to Quarto:

``` {.lua filename="env.lua"}
function env(args)
  local var = pandoc.utils.stringify(args[1])
  local value = os.getenv(var)
  if value ~= nil then
    return pandoc.Str(value)
  else
    return pandoc.Null()
  end
end
```

Note that arguments to shortcodes are provided in `args` (a 1-dimensional array), and that each argument is a list of Pandoc inlines (i.e. markdown AST parsed from the text).

We use the `pandoc.utils.stringify()` function to convert the inlines to an ordinary string, and then the `os.getenv()` function to get its value.

You would use this shortcode as follows:

``` markdown
{{{< env HOME >}}}
```

## Distribution

If your extension source code is located within a GitHub repository, then it can be installed by referencing the GitHub organization and repository name. For example:

``` {.bash filename="Terminal"}
# install the current HEAD of the extension
quarto add cooltools/shorty

# install a branch or tagged release of the extension
quarto add cooltools/shorty@v1.2
quarto add cooltools/shorty@bugfix-22
```

Note that it is possible to bundle and distribute extensions as simple gzip archives (as opposed to using a GitHub repository as described above). See the article on [Distributing Extensions](distributing.qmd) for additional details.

## Examples

You might find it instructive to examine the source code of these shortcode extensions authored by the Quarto team:

| **Extension**                                                                                     | **Description**                                                                                 |
|---------------------------|---------------------------------------------|
| [fancy-text](https://github.com/quarto-ext/fancy-text)                                            | Output nicely formatted versions of fancy strings such as LaTeX and BibTeX in multiple formats. |
| [fontawesome](https://github.com/quarto-ext/fontawesome)                                          | Use Font Awesome icons in HTML and PDF documents.                                               |
| [video](https://github.com/quarto-dev/quarto-cli/tree/main/src/resources/extensions/quarto/video) | Embed videos in HTML documents and Revealjs presentations.                                      |

: {tbl-colwidths="\[30,70\]"}

Some additional annotated examples are provided below.

### Raw Output

Shortcodes can tailor their output to the format being rendered to. This is often useful when you want to conditionally generate rich HTML output but still have the same document render properly to PDF or MS Word.

The `pagebreak` shortcode generates "native" pagebreaks in a variety of formats. Here's the implementation of `pagebreak`:

``` {.lua filename="pagebreak.lua"}
function pagebreak()
 
  local raw = {
    epub = '<p style="page-break-after: always;"> </p>',
    html = '<div style="page-break-after: always;"></div>',
    latex = '\\newpage{}',
    ooxml = '<w:p><w:r><w:br w:type="page"/></w:r></w:p>',
    odt = '<text:p text:style-name="Pagebreak"/>',
    context = '\\page'
  }

  if quarto.doc.isFormat('docx') then
    return pandoc.RawBlock('openxml', raw.ooxml)
  elseif quarto.doc.isFormat('pdf')  then
    return pandoc.RawBlock('tex', raw.latex)
  elseif quarto.doc.isFormat('odt')  then
    return pandoc.RawBlock('opendocument', raw.odt)
  elseif quarto.doc.isFormat('epub') then
    return pandoc.RawBlock('html', raw.epub)
  elseif quarto.doc.isFormat('html') then
    return pandoc.RawBlock('html', raw.html)
  elseif quarto.doc.isFormat('context') then
    return pandoc.RawBlock('context', raw.context)
  else
    -- fall back to insert a form feed character
    return pandoc.Para{pandoc.Str '\f'}
  end

end
```

We use the `pandoc.RawBlock()` function to output the appropriate raw content for the target format. Note that raw blocks are passed straight through to the output file and are not processed as markdown.

You'd use this shortcode as follows:

``` markdown
{{{< pagebreak >}}}
```

### Named Arguments

The examples above use either a single argument (`env`) or no arguments at all (`pagebreak`). Here we demonstrate named argument handling by implementing a `git-rev` shortcode that prints the current git revision, providing a `short` option to determine whether a short or long SHA1 value is displayed:

``` {.lua filename="git.lua"}
-- run git and read its output
function git(command)
  local p = io.popen("git " .. command)
  local output = p:read('*all')
  p:close()
  return output
end

-- return a table containing shortcode definitions
-- defining shortcodes this way allows us to create helper 
-- functions that are not themselves considered shortcodes 
return {
  ["git-rev"] = function(args, kwargs)
    -- command line args
    local cmdArgs = ""
    local short = pandoc.utils.stringify(kwargs["short"])
    if short == "true" then
      cmdArgs = cmdArgs .. "--short "
    end
    
    -- run the command
    local cmd = "rev-parse " .. cmdArgs .. "HEAD"
    local rev = git(cmd)
    
    -- return as string
    return pandoc.Str(rev)
  end
}
```

There are some new things demonstrated here:

1.  Rather than defining our shortcode functions globally, we return a table with the shortcode definitions. This allows us to define helper functions that are not themselves registered as shortcodes. It also enables us to define a shortcode with a dash (`-`) in its name.

2.  There is a new argument to our shortcode handler: `kwargs`. This holds any named arguments to the shortcode. As with `args`, values in `kwargs` will always be a list of Pandoc inlines (allowing you to accept markdown as an argument). Since `short` is a simple boolean value we need to call `pandoc.utils.stringify()` to treat it as a string and then compare it to `"true"`.

We'd use this shortcode as follows:

``` {.markdown shortcodes="false"}
---
title: "My Document"
---

{{< git-rev >}}
{{< git-rev short=true >}}
```

### Metadata Options

In some cases you may want to provide options that affect how your shortcode behaves. There is a third argument to shortcode handlers (`meta`) that provides access to document and/or project level metadata.

Let's implement a different version of the `git-rev` shortcode that emits the revision as a link to GitHub rather than plain text. To do this, we make use of `github.owner` and `github.repo` metadata values:

``` {.lua filename="git.lua"}
function git(command)
  local p = io.popen("git " .. command)
  local output = p:read('*all')
  p:close()
  return output
end

return {
  
  ["git-rev"] = function(args, kwargs, meta)
    -- run the command
    local rev = git("rev-parse HEAD")
    
    -- target repo
    local owner = pandoc.utils.stringify(meta["github.owner"])
    local repo = pandoc.utils.stringify(meta["github.repo"])
    local url = "https://github.com/" 
                .. owner .. "/" .. repo .. "/" .. rev 
    
    -- return as link
    return pandoc.Link(pandoc.Str(rev), url)
  end
}
```

As with `args` and `kwargs`, `meta` values are always provided as a list of Pandoc inlines, so often need to be converted to string using `pandoc.utils.stringify()`.

To use this shortcode in a document, we provide the GitHub info as document options, then include the shortcode where we want the link to be:

``` {.markdown shortcodes="false"}
---
title: "My Document"
github:
  owner: quarto-dev
  repo: quarto-cli
---

{{< git-rev >}}
```

The shortcode registration and GitHub metadata could just as well been provided in a project-level `_quarto.yml` file or a directory-level `_metadata.yml` file.

## Raw Arguments

In Quarto >= 1.3, you can also access the raw stream of inlines passed to a shortcode by adding a `raw_args` parameter. For example:

```lua
function shorty(args, kwargs, meta, raw_args)
  -- ...
end
```

## Context Awareness

In Quarto >= 1.5, you can access the context in which the shortcode was invoked as the fifth parameter of the function call. `context` is a string that will be one of `block`, `inline`, or `text`:

- if `context` is `block`, then the shortcode exists in a block by itself
- if `context` is `inline`, then the shortcode exists as one of many inline nodes
- if `context` is `text`, then the shortcode exists inside a text field of a Pandoc node. These can be:
  - the content of `CodeBlock` or `Code` elements
  - the content of `RawBlock` or `RawInline` elements
  - the content of attributes of Pandoc elements like `Div`, `Span`, etc.
  - the URL of a `Link` element
  - the source of an `Image` element

```lua
function shorty(args, kwargs, meta, raw_args, context)
  -- ...
end
```

{{< include _shortcode-escaping.qmd >}}
```````

## File: docs/extensions/starter-templates.qmd
```````
---
title: "Starter Templates"

---

{{< include _extension-version.qmd >}}

## Overview

Starter templates provide a straightforward way for users to get started with new Quarto projects by providing example content and options. You might use starter templates to:

1.  Create a working initial document for [Journal Articles](/docs/journals/index.qmd) or [Custom Formats](formats.qmd).

2.  Provide the initial content for a custom [Project Type](project-types.qmd). 

3.  Scaffold a standard form of data analysis project used by your organization.

Starter templates are essentially just GitHub repositories that are copied to a new directory on the user's system. As we'll describe below in [Extensions & Templates], often times the repository for a custom format is also used as a starter template.

## Creating a Template

To create a starter template, just create a GitHub repository that includes the files you want copied into projects created with the template. All of the files in the repository are copied except for:

1.  Hidden files (any file or directory name that starts with `.` (e.g. `.gitignore`).

2.  Common GitHub repository files like `README.md` and `LICENSE`.

If you'd like, you can also include a `.quartoignore` file in the root of your repository listing other files or directories you'd like to exclude. Each line of the file should be a glob describing file(s) to ignore (using syntax like a `.gitignore` file).

### template.qmd

There is one special file you'll typically want to include in templates that target creation of documents (as opposed to projects): `template.qmd`. There are two reasons to include a `template.qmd`:

1. It provides an easy way to test that your template is working as expected.

2. When the template is copied into the target directory, the `template.qmd` will automatically be renamed to match the name that the user provided for the directory.

If you are creating a template that targets creation of a website or book, a `template.qmd` is generally not necessary (as the `index.qmd` file already serves this purpose).

## Using a Template

Once you've created the template repository and pushed it to GitHub, it can be instantiated with the following command:

``` {.bash filename="Terminal"}
quarto use template cooltools/cool-project
```

This command copies the contents of the GitHub repository at `https://github.com/cooltools/cool-project` to the local system (excluding selected files as discussed above).

If the command is run in an empty directory, the user will be prompted whether they'd like to use the existing directory or create a new directory. If the command is run in a directory which contains other files or directories, they'll be prompted for the name of a directory to create.

## Extensions & Templates

When creating [Journal Articles](/docs/journals/index.qmd), [Custom Formats](formats.qmd), or [Project Type](project-types.qmd) extensions, we recommend that you additionally provide a starter template to make it easy for users to get started.

This is generally as easy as adding a `template.qmd` file to your extension that demonstrates its use. With this configuration, users can either begin using your extension via the template or by a conventional `quarto install` of the extension. 

For example, consider the [ACM](https://github.com/quarto-journals/acm) Journal Article extension. The extension repository supports _either_ getting started with a template:

```{.bash filename="Terminal"}
quarto use template quarto-journals/acm
```

Alternatively, you can add the format (without the template) into an existing project or directory:

```{.bash filename="Terminal"}
quarto add quarto-journals/acm
```
```````

## File: docs/faq/index.qmd
```````
---
title: "Frequently Asked Questions"
editor: source
---

If you are an R Markdown user wondering about the relationship between Quarto and R Markdown, see also our [FAQ for R Markdown Users](rmarkdown.qmd).

## General

### What can I use Quarto for?

Quarto® is an open-source scientific and technical publishing system built on Pandoc. You can weave together narrative text and code to produce elegantly formatted output as documents, web pages, blog posts, books and more.

### How do I install Quarto?

Visit the [Quarto.org - Get Started page](/docs/get-started/index.qmd), which provides installation instructions for Windows, Mac OS, and Linux.

### What output formats can Quarto create?

There are many output formats available in Quarto. This includes all of the built in Pandoc formats (e.g. HTML, PDF, MS Word, Revealjs, ePub, etc.) as well as various ways to publish multiple documents (websites, blogs, and books). Learn more at [Quarto Formats](/docs/output-formats/all-formats.qmd).

### What editing tools can I use with Quarto?

You can use a wide variety of tools with Quarto. We have provided documentation for writing and editing Quarto documents in VSCode, JupyterLab, RStudio IDE, or any text editor. Visit the [Get Started with Quarto page](/docs/get-started/index.qmd) to install, and then choose your tool for a brief introductory guide.

### Can I use Jupyter notebooks with Quarto?

Yes! Quarto can [render Jupyter notebooks](/docs/tools/jupyter-lab.qmd) and you can use Jupyter, JupyterLab or any other .ipynb notebook editor with Quarto. You can render existing .ipynb notebooks as-is with Quarto, but adding Quarto-specific output options or a YAML header can enhance the output. Visit the[JupyterLab page](/docs/tools/jupyter-lab.qmd) for more information.

### What programming languages are supported in Quarto?

The principal languages supported by Quarto are Python, R, Julia, and Observable JavaScript. Integration with Jupyter also enables the use of many other languages. 

Each Quarto document can be optionally processed by a computational engine (the engine can be manually specified or automatically detected based on the code chunks within). Current engines include Knitr (which is also used by R Markdown and supports [a variety of languages](https://bookdown.org/yihui/rmarkdown-cookbook/other-languages.html) including R, Python, and Julia, etc.) and Jupyter (which supports many languages including Python, Julia, and R). See the documentation on [Engine Binding](/docs/computations/execution-options.qmd#engine-binding) for additional details.

### What human languages are supported in Quarto?

You can write your Quarto documentation in your human language of choice. The [lang](https://pandoc.org/MANUAL.html#language-variables) [document option](/docs/authoring/language.qmd#lang-option) is used to identify the main language of the document using IETF language tags (following the [BCP 47 standard](https://tools.ietf.org/html/bcp47)), such as en or en-GB. 

### Where can I report bugs or request features?

Thanks for finding something and sharing with us! You can file an issue in the Quarto repository <https://github.com/quarto-dev/quarto-cli/issues>.

### Where can I ask questions and discuss using Quarto with others?

The best place to ask questions and see what questions other people have is in Quarto discussions (<https://github.com/quarto-dev/quarto-cli/discussions>). 

## Development and Maintenance

### How can I upgrade dependencies?

Generally, you cannot.
Quarto produces output tailored to its downstream dependencies (Pandoc, `typst`, etc), and uses features that depend on specific upstream dependencies (Deno).
Our installers bundle all required dependencies to eliminate version mismatch risks, and we *strongly recommend* that third-party packagers
follow the same policy.

### How often are dependencies updated?

Ideally, we update dependencies exactly once every stable release (1.2, 1.3, etc).
We reserve the right to change the cadence as necessary for our development.

### What are Quarto's dependencies?

Quarto's dependencies include:

- [Pandoc](https://pandoc.org)
- [Typst](https://typst.app)
- [Deno](https://deno.com)
- [Mermaid](https://mermaid.js.org)
- [esbuild](https://esbuild.github.io/)
- [Dart Sass](https://sass-lang.com/dart-sass/)

## Licensing

### Is Quarto free to use?

Yes! Quarto is [open source](/license.md). Quarto version 1.3 (and earlier) is licensed under the [GNU GPL v2](https://www.gnu.org/licenses/old-licenses/gpl-2.0.en.html). Quarto version 1.4 is licensed under the [MIT License](https://opensource.org/license/mit/).

### Can I use Quarto to develop proprietary content?

Yes! The copyright on Quarto does not cover the original content that you generate using Quarto. Using Quarto to create original content does not place any restrictions, legally, on the license that you choose for the original content that you create, nor does it “reach through” to affect software that you might be writing documentation for with Quarto.

### But doesn't the GPL cover exported HTML documents when they include styles or functionalities from Quarto?

It covers the styles or functionalities themselves.  It does not cover your original content because your original content is not a derivative work of the Quarto styles or functionalities.

### How can I share documents and have people comment on them?

You can publish Quarto content to various locations. See the user guides for [publishing](/docs/publishing/index.qmd) for details on using Quarto Pub, GitHub Pages, Netlify, Posit Connect, and other services with Quarto. Once documents are published you can use  [hypothes.is](https://web.hypothes.is/), [Utterances](https://utteranc.es/), or [Giscus](https://giscus.app/) for commenting. Learn more in the documentation on [commenting](/docs/output-formats/html-basics.qmd#commenting).

### Can I do collaborative editing with Quarto?

There is not yet anything specific for collaborative editing in Quarto. You can collaborate on .qmd files in the same way you currently do for any text or code files. 

Posit Workbench allows for [Project Sharing](https://support.rstudio.com/hc/en-us/articles/211659737-Sharing-Projects-in-RStudio-Workbench-RStudio-Server-Pro) for interactive editing and collaboration on the same document.

### Where can I publish Quarto websites?

There are a wide variety of ways to publish Quarto websites. Website content is by default written to the `\_site` sub-directory (you can customize this using the output-dir option). Publishing is simply a matter of copying the output directory to a web server or web hosting service.

The [publishing documentation](/docs/publishing/other.qmd) describes several convenient options for Quarto website deployment including Posit Connect, Netlify, GitHub Pages, Firebase, Site44, and Amazon S3. We'll mostly defer to the documentation provided by those various services, but will note any Quarto website specific configuration required.

## Quarto + Posit

### Does Posit Connect support Quarto?

Yes! You can publish Quarto content to Posit Connect v2021.08.0 or later. Quarto has to be enabled as documented in the Posit Connect [admin guide](https://docs.rstudio.com/connect/admin/appendix/configuration/#Quarto). Connect's user [documentation](https://docs.rstudio.com/connect/user/quarto/) refers to [Quarto.org docs](/docs/publishing/index.qmd#rstudio-connect) on how to publish from the RStudio IDE. To publish Python-based Quarto content, you can use the [rsconnect-python CLI](https://docs.rstudio.com/rsconnect-python/) from various locations, including VSCode, JupyterLab or the terminal.

## Meta

### Who are the developers of Quarto?

Development of Quarto is sponsored by [Posit, PBC](https://www.posit.co/). The same core team works on both Quarto and R Markdown:

-   Carlos Scheidegger ([\@cscheid](https://github.com/cscheid))

-   Gordon Woodhull ([\@gordonwoodhull](https://github.com/gordonwoodhull))

-   Christophe Dervieux ([\@cderv](https://github.com/cderv))

-   Charles Teague ([\@dragonstyle](https://github.com/dragonstyle))

-   J.J. Allaire ([\@jjallaire](https://github.com/jjallaire/))

-   Yihui Xie ([\@yihui](https://github.com/yihui))

Here is the [full contributors list](https://github.com/quarto-dev/quarto-cli/graphs/contributors). Quarto is open source and we welcome contributions in our github repository as well! <https://github.com/quarto-dev/quarto-cli>.

### Why the name Quarto?

We wanted to use a name that had meaning in the history of publishing and landed on Quarto, which is the format of a book or pamphlet produced from full sheets printed with eight pages of text, four to a side, then folded twice to produce four leaves. The earliest known European printed book is a Quarto, the [Sibyllenbuch](https://en.wikipedia.org/wiki/Sibyllenbuch_fragment), believed to have been printed by [Johannes Gutenberg](https://en.wikipedia.org/wiki/Johannes_Gutenberg) in 1452--53.
```````

## File: docs/faq/rmarkdown.qmd
```````
---
title: "FAQ for R Markdown Users"
description: Answers to R Markdown users' most frequently asked questions about Quarto.
---

### What can I use Quarto for?

Quarto® is an open-source scientific and technical publishing system built on Pandoc. You can weave together narrative text and code to produce elegantly formatted output as documents, web pages, blog posts, books and more. 

### Quarto sounds similar to R Markdown. What is the difference and why create a new project?

At its core, Quarto works the same way as R Markdown: 

![](/docs/get-started/hello/images/rstudio-qmd-how-it-works.png){.preview-image fig-alt="How Quarto works: qmd to knitr to md to pandoc to multiple formats including pdf, HTML and Microsoft Word"}

The goal of Quarto is to make the process of creating and collaborating on scientific and technical documents dramatically better. Quarto combines the functionality of R Markdown, bookdown, distill, xaringian, etc into a single consistent system with "batteries included" that reflects everything we've learned from R Markdown over the past 10 years.

The number of languages and runtimes used for scientific discourse is very broad (and the Jupyter ecosystem in particular is extraordinarily popular). Quarto is at its core multi-language and multi-engine (supporting Knitr, Jupyter, and Observable today and potentially other engines tomorrow).

On the other hand, R Markdown is fundamentally tied to R which severely limits the number of practitioners it can benefit. Quarto is Posit's attempt to bring R Markdown to everyone! Unlike R Markdown, Quarto doesn't have a dependency or requirement for R. Quarto was developed to be multilingual, beginning with R, Python, Javascript, and Julia, with the idea that it will work even for languages that don't yet exist.

While it is a "new" system, it should also be noted that it is highly compatible with existing content: you can render most R Markdown documents and Jupyter notebooks unmodified with Quarto. The concept is to make a major, long term investment in reproducible research, while keeping it compatible with existing formats and adaptable to the various environments users work in.

### Is R Markdown going away? Will my R Markdown documents continue to work?

R Markdown is not going away! R Markdown is used extensively and continues to work well. It will continue to be actively supported. We're not leaving R Markdown, we're expanding our scope. Over the years there have been many feature requests, and rather than implementing them all in R Markdown, for certain features we may refer you to Quarto. Everything that is currently in R Markdown will continue to work and be supported. There are no plans for deprecation.

Read more about this in Yihui Xie's blog post [With Quarto Coming, is R Markdown Going Away? No.](https://yihui.org/en/2022/04/quarto-r-markdown/)

### Should I switch from R Markdown to Quarto?

If you like using R Markdown, there's no need to switch! R Markdown will continue to be supported and work as it always has been. You're welcome to try Quarto if you like, but there's no need to switch. Some new features may only exist in Quarto, so if you want to use those, then that's where you would give those a try.  

We should emphasize that switching is not imperative. While we don't plan on major feature initiatives in R Markdown and related packages, we are going to continue to maintain them (smaller improvements and bug fixes) for a long time to come. Furthermore, since Rmd files can in most cases be rendered without modification by Quarto, you can continue using R Markdown and the switching cost will still be minimal whenever you decide to do it. 

### I use X (bookdown, blogdown, etc.). What is the Quarto equivalent?

Here are the Quarto equivalents for various packages and features of the R Markdown ecosystem (in some cases Quarto equivalents are not yet available but will be later this year):

::: comparison
+-----------------------+----------------------------------------------------------------------------------------------------------+-------------------------------------------------------------------+
| Feature               | R Markdown                                                                                               | Quarto                                                            |
+=======================+==========================================================================================================+===================================================================+
| Basic Formats         | -   [html_document](https://pkgs.rstudio.com/rmarkdown/reference/html_document.html)                     | -   [html](/docs/output-formats/html-basics.qmd)                  |
|                       | -   [pdf_document](https://pkgs.rstudio.com/rmarkdown/reference/pdf_document.html)                       | -   [pdf](/docs/output-formats/pdf-basics.qmd)                    |
|                       | -   [word_document](https://pkgs.rstudio.com/rmarkdown/reference/word_document.html)                     | -   [docx](/docs/output-formats/ms-word.qmd)                      |
+-----------------------+----------------------------------------------------------------------------------------------------------+-------------------------------------------------------------------+
| Beamer                | -   [beamer_presentation](https://pkgs.rstudio.com/rmarkdown/reference/beamer_presentation.html)         | -   [beamer](/docs/presentations/beamer.qmd)                      |
+-----------------------+----------------------------------------------------------------------------------------------------------+-------------------------------------------------------------------+
| PowerPoint            | -   [powerpoint_presentation](https://pkgs.rstudio.com/rmarkdown/reference/powerpoint_presentation.html) | -   [pptx](/docs/presentations/powerpoint.qmd)                    |
+-----------------------+----------------------------------------------------------------------------------------------------------+-------------------------------------------------------------------+
| HTML Slides           | -   [xaringan](https://bookdown.org/yihui/rmarkdown/xaringan.html)                                       | -   [revealjs](/docs/presentations/revealjs/index.qmd)            |
|                       | -   [ioslides](https://bookdown.org/yihui/rmarkdown/ioslides-presentation.html)                          |                                                                   |
|                       | -   [revealjs](https://bookdown.org/yihui/rmarkdown/revealjs.html)                                       |                                                                   |
+-----------------------+----------------------------------------------------------------------------------------------------------+-------------------------------------------------------------------+
| Advanced Layout       | -   [tufte](https://bookdown.org/yihui/rmarkdown/tufte-handouts.html)                                    | -   [Quarto Article Layout](/docs/authoring/article-layout.qmd)   |
|                       | -   [distill](https://rstudio.github.io/distill/figures.html)                                            |                                                                   |
+-----------------------+----------------------------------------------------------------------------------------------------------+-------------------------------------------------------------------+
| Cross References      | -   [html_document2](https://bookdown.org/yihui/bookdown/a-single-document.html)                         | -   [Quarto Crossrefs](/docs/authoring/cross-references.qmd)      |
|                       | -   [pdf_document2](https://bookdown.org/yihui/bookdown/a-single-document.html)                          |                                                                   |
|                       | -   [word_document2](https://bookdown.org/yihui/bookdown/a-single-document.html)                         |                                                                   |
+-----------------------+----------------------------------------------------------------------------------------------------------+-------------------------------------------------------------------+
| Websites & Blogs      | -   [blogdown](https://pkgs.rstudio.com/blogdown/)                                                       | -   [Quarto Websites](/docs/websites/website-basics.qmd)          |
|                       | -   [distill](https://pkgs.rstudio.com/distill/)                                                         | -   [Quarto Blogs](/docs/websites/website-blog.qmd)               |
+-----------------------+----------------------------------------------------------------------------------------------------------+-------------------------------------------------------------------+
| Books                 | -   [bookdown](https://pkgs.rstudio.com/bookdown/)                                                       | -   [Quarto Books](/docs/books/book-basics.qmd)                   |
+-----------------------+----------------------------------------------------------------------------------------------------------+-------------------------------------------------------------------+
| Interactivity         | [Shiny Documents](https://bookdown.org/yihui/rmarkdown/shiny-documents.html)                             | [Quarto Interactive Documents](/docs/interactive/shiny/index.qmd) |
+-----------------------+----------------------------------------------------------------------------------------------------------+-------------------------------------------------------------------+
| Journal Articles      | [rticles](https://pkgs.rstudio.com/rticles/)                                                             | [Quarto Journal Articles](/docs/journals/index.qmd)               |
+-----------------------+----------------------------------------------------------------------------------------------------------+-------------------------------------------------------------------+
| Paged HTML            | [pagedown](https://github.com/rstudio/pagedown)                                                          | Planned                                                           |
+-----------------------+----------------------------------------------------------------------------------------------------------+-------------------------------------------------------------------+
| Dashboards            | [flexdashboard](https://pkgs.rstudio.com/flexdashboard/)                                                 | [Quarto Dashboards](https://quarto.org/docs/dashboards/)          |
+-----------------------+----------------------------------------------------------------------------------------------------------+-------------------------------------------------------------------+
| Interactive Tutorials | [learnr](https://pkgs.rstudio.com/learnr/)                                                               | [Quarto Live](https://r-wasm.github.io/quarto-live/) Extension    |
+-----------------------+----------------------------------------------------------------------------------------------------------+-------------------------------------------------------------------+
:::

### Can you create custom formats for Quarto like you can for R Markdown?

Quarto offers an [Extension](/docs/extensions/index.qmd) mechanism to add features to a format using [Shortcodes](/docs/extensions/#using-shortcodes) or [Filters](/docs/extensions/#using-filters) but also create [custom formats](/docs/extensions/formats.qmd). A major difference with custom output format in R Markdown is that Quarto Extension does not use R but Lua, for example if you need to add some logic behind custom metadata fields. See [Developing with Lua](/docs/extensions/lua.qmd) to get started if you need use it your extension.
Some of the features from R Markdown custom formats like customizing knitting behavior can also now be done in YAML with [execution options](/docs/computations/execution-options.qmd#knitr-options).

As example of custom formats for Quarto, [Journal Articles](/docs/journals/index.qmd) for Quarto are port of some custom output format inside the **rticles** R package. Extensions lives in [Quarto Journals](https://github.com/quarto-journals/) Github organization, and you can find information on how to [customize templates](/docs/journals/templates.qmd) and [manage Authors](/docs/journals/authors.qmd) for you format. 

If you are an advanced developer of R Markdown custom format, the Extension mechanism may still have limitation (like pre and post processor). The Extension feature in Quarto will be improved over time - do not hesitate to share with us your use case or wished in our [Discussion Board](https://github.com/quarto-dev/quarto-cli/discussions).

### When would be a good time to start new projects in Quarto rather than R Markdown?

Quarto v1.0 was [announced at rstudio::conf(2022)](https://www.rstudio.com/blog/announcing-quarto-a-new-scientific-and-technical-publishing-system/). This is the first stable release which is already an excellent foundation for starting new projects with Quarto or migrating existing R Markdown projects ([if you are so inclined](/docs/faq/rmarkdown.qmd#is-r-markdown-going-away-will-my-r-markdown-documents-continue-to-work)). If you start using Quarto, please do stay updated with [latest release and changes](/docs/download/index.qmd) as development is very active. 

### Does the RStudio IDE support Quarto?

Yes! You need to use RStudio {{< var rstudio.min_version >}} or a later version, which includes support for [editing and preview of Quarto documents](/docs/tools/rstudio.qmd).

You can download the latest release of RStudio from <https://posit.co/download/rstudio-desktop/>.

### Does Posit Connect support Quarto?

Yes! You can publish Quarto content to Posit Connect v2021.08.0 or later. Quarto has to be enabled as documented in the Posit Connect [admin guide](https://docs.rstudio.com/connect/admin/appendix/configuration/#Quarto). Connect's user [documentation](https://docs.rstudio.com/connect/user/quarto/) refers to [Quarto.org docs](/docs/publishing/rstudio-connect.qmd#rstudio-ide) on how to publish from the RStudio IDE. To publish Python-based Quarto content, you can use the [rsconnect-python CLI](https://docs.rstudio.com/rsconnect-python/) from various locations, including VSCode, JupyterLab or the terminal.
```````

## File: docs/gallery/index.qmd
```````
---
pagetitle: "Gallery"
format:
  html:
    toc: false
image: articles/advanced-layout-pdf.png
search: false
execute:
  echo: false
listing:
  - id: gallery
    template: gallery.ejs
    contents: gallery.yml
description: |
  A gallery of example documents, websites, books, and presentations created with Quarto.
aliases:
  - /docs/dashboards/examples/index.html
  - /docs/dashboards/examples/
---

::: {#hero-banner .column-screen}
::: {.grid .column-page}
::: {.headline .g-col-lg-6 .g-col-12 .g-col-md-12}
::: h1
Gallery
:::

Quarto can produce a wide variety of output formats. Here are some examples:

-   [Articles & Reports](#articles-reports)
-   [Presentations](#presentations)
-   [Dashboards](#dashboards)
-   [Websites](#websites)
-   [Books](#books)
-   [Interactive Docs](#interactive-docs)
:::

```{r}
#| classes: '.g-col-lg-6 .g-col-12 .g-col-md-12'
#| warning: false
source("carousel.R")
carousel("gallery-carousel", 5000, 
         yaml.load_file("carousel.yml"))
```
:::
:::

::: {#gallery .column-page}
:::

```{=html}
<style>

/* we need to hide this element */
/* <header id="title-block-header" class="quarto-title-block"></header> */

header#title-block-header {
  display: none;
}

body.quarto-light #hero-banner {
  background-color: rgb(240,245,249);
}

body.quarto-dark #hero-banner {
  background-color: #17212B;
}

div.carousel {
  margin-top: 2rem; 
}

body.quarto-dark .carousel-dark .carousel-indicators [data-bs-target] {
  background-color: rgb(255,255,255);
}

body.quarto-dark .carousel-dark .carousel-control-next-icon,
body.quarto-dark .carousel-dark .carousel-control-prev-icon {
  filter: inherit;
}

#quarto-content main { 
  margin-top: 0;
  padding-top: 0;
}

html {
  scroll-behavior: smooth;
}

.headline {
  font-size: 1.25em;
  font-weight: 300;
  padding-bottom: 1em;
}

.headline p {
  margin: 0;
  padding-bottom: 0.2rem;
}

.headline a {
  text-decoration: none;
}

.headline ul li {
  margin-bottom: 0.3em;
}

.carousel.card {
  padding-top: 2em;
}

.carousel img {
  width: 70%;
  margin-bottom: 110px;
}

.carousel-control-prev-icon, .carousel-control-next-icon {
  margin-bottom: 110px;
}

.carousel-caption {
  padding-top: 1em;
}

.touch {
  
}
</style>
```
```````

## File: docs/get-started/authoring/_authoring-complete.qmd
```````
---
title: "Housing Prices"
author: "Mine Çetinkaya-Rundel"
toc: true
number-sections: true
highlight-style: pygments
format:
  html: 
    code-fold: true
    html-math-method: katex
  pdf:
    geometry: 
      - top=30mm
      - left=30mm
  docx: default
bibliography: references.bib
---

## Introduction

In this analysis, we build a model predicting sale prices of houses based on data on houses that were sold in the Duke Forest neighborhood of Durham, NC around November 2020. Let's start by loading the packages we'll use for the analysis.

```{r}
#| label: load-pkgs
#| code-summary: "Packages"
#| message: false

library(openintro)  # for data
library(tidyverse)  # for data wrangling and visualization
library(knitr)      # for tables
library(broom)      # for model summary
```

We present the results of exploratory data analysis in @sec-eda and the regression model in @sec-model.

We're going to do this analysis using literate programming [@knuth1984].

## Exploratory data analysis {#sec-eda}

The data contains `{r} nrow(duke_forest)` houses. As part of the exploratory analysis let's visualize and summarize the relationship between areas and prices of these houses.

### Data visualization

@fig-histogram shows two histograms displaying the distributions of `price` and `area` individually.

```{r}
#| label: fig-histogram
#| fig-cap: "Histograms of individual variables"
#| fig-subcap:
#|   - "Histogram of `price`s"
#|   - "Histogram of `area`s" 
#| layout-ncol: 2
#| column: page-right

ggplot(duke_forest, aes(x = price)) +
  geom_histogram(binwidth = 50000) +
  labs(title = "Histogram of prices")

ggplot(duke_forest, aes(x = area)) +
  geom_histogram(binwidth = 250) +
  labs(title = "Histogram of areas")
```

@fig-scatterplot displays the relationship between these two variables in a scatterplot.

```{r}
#| label: fig-scatterplot
#| fig-cap: "Scatterplot of price vs. area of houses in Duke Forest"

ggplot(duke_forest, aes(x = area, y = price)) +
  geom_point() +
  labs(title = "Price and area of houses in Duke Forest")
```

### Summary statistics

@tbl-stats displays basic summary statistics for these two variables.

```{r}
#| label: tbl-stats
#| tbl-cap: "Summary statistics for price and area of houses in Duke Forest"

duke_forest %>%
  summarise(
    `Median price` = median(price),
    `IQR price` = IQR(price),
    `Median area` = median(area),
    `IQR area` = IQR(area),
    `Correlation, r` = cor(price, area)
    ) %>%
  kable(digits = c(0, 0, 0, 0, 2))
```

## Modeling {#sec-model}

We can fit a simple linear regression model of the form shown in @eq-slr.

$$
price = \hat{\beta}_0 + \hat{\beta}_1 \times area + \epsilon
$$ {#eq-slr}

@tbl-lm shows the regression output for this model.

```{r}
#| label: tbl-lm
#| tbl-cap: "Linear regression model for predicting price from area"

price_fit <- lm(price ~ area, data = duke_forest)
  
price_fit %>%
  tidy() %>%
  kable(digits = c(0, 0, 2, 2, 2))
```

::: callout-note
This is a pretty incomplete analysis, but hopefully the document provides a good overview of some of the authoring features of Quarto!
:::

## References {.unnumbered}
```````

## File: docs/get-started/authoring/_authoring.qmd
```````
---
title: "Housing Prices"
author: "Mine Çetinkaya-Rundel"
format: pdf
---

## Introduction

In this analysis, we build a model predicting sale prices of houses based on data on houses that were sold in the Duke Forest neighborhood of Durham, NC around November 2020.
Let's start by loading the packages we'll use for the analysis.

```{r}
#| label: load-pkgs
#| code-summary: "Packages"
#| message: false

library(openintro)  # for data
library(tidyverse)  # for data wrangling and visualization
library(knitr)      # for tables
library(broom)      # for model summary
```

We present the results of exploratory data analysis in @sec-eda and the regression model in @sec-model.

<!--# ADD CITATION HERE -->

## Exploratory data analysis {#sec-eda}

The data contains `{r} nrow(duke_forest)` houses.
As part of the exploratory analysis let's visualize and summarize the relationship between areas and prices of these houses.

### Data visualization

@fig-histogram shows two histograms displaying the distributions of `price` and `area` individually.

```{r}
#| label: fig-histogram
#| fig-cap: "Histograms of individual variables"
#| fig-subcap:
#|   - "Histogram of `price`s"
#|   - "Histogram of `area`s" 
#| layout-ncol: 2

ggplot(duke_forest, aes(x = price)) +
  geom_histogram(binwidth = 50000) +
  labs(title = "Histogram of prices")

ggplot(duke_forest, aes(x = area)) +
  geom_histogram(binwidth = 250) +
  labs(title = "Histogram of areas")
```

@fig-scatterplot displays the relationship between these two variables in a scatterplot.

```{r}
#| label: fig-scatterplot
#| fig-cap: "Scatterplot of price vs. area of houses in Duke Forest"

ggplot(duke_forest, aes(x = area, y = price)) +
  geom_point() +
  labs(title = "Price and area of houses in Duke Forest")
```

### Summary statistics

@tbl-stats displays basic summary statistics for these two variables.

```{r}
#| label: tbl-stats
#| tbl-cap: "Summary statistics for price and area of houses in Duke Forest"

duke_forest %>%
  summarise(
    `Median price` = median(price),
    `IQR price` = IQR(price),
    `Median area` = median(area),
    `IQR area` = IQR(area),
    `Correlation, r` = cor(price, area)
    ) %>%
  kable(digits = c(0, 0, 0, 0, 2))
```

## Modeling {#sec-model}

We can fit a simple linear regression model of the form shown in @eq-slr.

\[ADD EQUATION HERE\]

@tbl-lm shows the regression output for this model.

```{r}
#| label: tbl-lm
#| tbl-cap: "Linear regression model for predicting price from area"

price_fit <- lm(price ~ area, data = duke_forest)
  
price_fit %>%
  tidy() %>%
  kable(digits = c(0, 0, 2, 2, 2))
```

<!--# ADD CALLOUT HERE -->

<!--# ADD SECTION HEADING FOR REFERENCES HERE -->
```````

## File: docs/get-started/authoring/index.qmd
```````
---
# These pages exist but are no longer needed; they're there in case someone links to them
# from the web
title: "Tutorial: Authoring"
include-in-header: ../_redirect.html
---
```````

## File: docs/get-started/authoring/jupyter.qmd
```````
---
title: "Tutorial: Authoring"
code-copy: hover
editor_options:
  markdown:
    wrap: sentence
    canonical: true
---

{{< include ../_tool-chooser.md >}}

## Overview

In this tutorial we'll show you how to author Quarto documents in Jupyter Lab.
In particular, we'll discuss the various document formats you can produce and show you how to add components like table of contents, equations, citations, cross-references, and more.

## Output Formats

Quarto supports rendering notebooks to dozens of different [output formats](/docs/output-formats/all-formats.qmd).
By default, the `html` format is used, but you can specify an alternate format (or formats) within document options.

### Format Options

Let's create a notebook and define various formats for it to be rendered to and add some options to each of the formats.
As a reminder, document options are specified in YAML within a "Raw" cell at the beginning of the notebook.
To create a Raw cell, add a cell at the top of the notebook and set its type to Raw using the notebook toolbar:

![](images/jupyter-raw-cell.png){.border fig-alt="Notebook formats.ipynb with a dropdown shown for a cell with three options: Code, Markdown, and Raw. Raw is highlighted."}

Now, let's add some basic document metadata and a default output format.

``` {.yaml .visually-hidden}
---
title: "Quarto Document"
author: "Norah Jones"
format: pdf
jupyter: python3
---
```

![](images/jupyter-format.png){.border fig-alt=""}

We specified `pdf` as the default output format (if we exclude the `format` option then it will default to `html`).

Let's add some options to control our PDF output.

``` {.yaml .visually-hidden}
---
title: "Quarto Document"
author: "Norah Jones"
format: 
  pdf: 
    toc: true
    number-sections: true
jupyter: python3
---
```

![](images/jupyter-format-options.png){.boder fig-alt=""}

### Multiple Formats

Some documents you create will have only a single output format, however in many cases it will be desirable to support multiple formats.
Let's add the `html` and `docx` formats to our document.

``` {.yaml .visually-hidden}
---
title: "Quarto Document"
author: "Norah Jones"
toc: true
number-sections: true
highlight-style: pygments
format: 
  html: 
    code-fold: true
    html-math-method: katex
  pdf: 
    geometry: 
      - top=30mm
      - left=20mm
  docx: default
jupyter: python3
---
```

![](images/jupyter-formats.png){.border fig-alt=""}

There's a lot to take in here!
Let's break it down a bit.
The first two lines are generic document metadata that aren't related to output formats at all.

``` yaml
title: "Quarto Document"
author: "Norah Jones"
```

The next three lines are document format options that *apply to all formats*.
which is why they are specified at the root level.

``` yaml
toc: true
number-sections: true
highlight-style: pygments
```

Next, we have the `format` option, where we provide format-specific options.

``` yaml
format:
  html: 
    code-fold: true
    html-math-method: katex
  pdf:
    geometry: 
      - top=30mm
      - left=30mm
  docx: default
```

The `html` and `pdf` formats each provide an option or two.
For example, for the HTML output we want the user to have control over whether to show or hide the code (`code-fold: true`) and use `katex` for math text.
For PDF we define some margins.
The `docx` format is a bit different---it specifies `docx: default`.
This means just use all of the default options for the format.

## Rendering

The formats specified within document options define what is rendered by default.
If we render the notebook with all the options given above using the following.

``` {.bash filename="Terminal"}
quarto render notebook.ipynb
```

Then, the following files would be created.

-   `notebook.html`
-   `notebook.pdf`
-   `notebook.docx`

We can select one or more formats using the `--to` option.

``` {.bash filename="Terminal"}
quarto render notebook.ipynb --to docx
quarto render notebook.ipynb --to docx,pdf
```

Note that the target file (in this case `notebook.ipynb`) should always be the very first command line argument.

If needed we can also render formats that aren't specified within document options.

``` {.bash filename="Terminal"}
quarto render notebook.ipynb --to odt
```

Since the `odt` format isn't included within document options, the default options for the format will be used.

::: {.callout-note appearance="simple"}
Note that when rendering an `.ipynb` Quarto **will not** execute the cells within the notebook by default (the presumption being that you already executed them while editing the notebook).
If you want to execute the cells you can pass the `--execute` flag to render.

``` {.bash filename="Terminal"}
quarto render notebook.ipynb --execute
```
:::

## Sections

You can use a table of contents and/or section numbering to make it easier for readers to navigate your document.
Do this by adding the `toc` and/or `number-sections` options to document options.
Note that these options are typically specified at the root level because they are shared across all formats.

``` {.yaml .visually-hidden}
---
title: Quarto Basics
author: Norah Jones
date: 'May 22, 2021'
toc: true
number-sections: true
jupyter: python3
---

## Colors

- Red
- Green 
- Blue

## Shapes

- Square
- Circle
- Triangle

## Textures

- Smooth
- Bumpy
- Fuzzy
```

![](images/jupyter-sections.png){.border fig-alt=""}

Here's what this document looks like when rendered to HTML.

![](images/sections-render.png){.border fig-alt="Document with title Quarto Basics, author, and date. Table of contents is on the left-hand side with numbered items for each of the three sections: 1. Colors, 2. Shapes, 3. Textures. Each section is shown in the document with the list contents from the source ipynb."}

There are lots of options available for controlling how the table of contents and section numbering behave.
See the output format documentation (e.g. [HTML](/docs/output-formats/html-basics.qmd), [PDF](/docs/output-formats/pdf-basics.qmd), [MS Word](/docs/output-formats/ms-word.qmd)) for additional details.

## Equations

You can add LaTeX equations to markdown cells within Jupyter Lab.

``` {.markdown .visually-hidden}
Einstein's theory of special relatively that expresses the equivalence of mass and energy:

$E = mc^{2}$
```

$E = mc^{2}$

![](/docs/get-started/authoring/images/jupyter-equation.png){.border fig-alt=""}

Equations are rendered when you run the cell.

![](/docs/get-started/authoring/images/jupyter-equation-render.png){.border fig-alt="Rendered notebook with LaTeX equation shown for E equals mc squared."}

Inline equations are delimited with `$…$`.
To create equations in a new line (display equation) use `$$…$$`.
See the documentation on [markdown equations](/docs/authoring/markdown-basics.qmd#equations) for additional details.

## Citations

To cite other works within a Quarto document.
First create a bibliography file in a supported format (BibTeX or CSL).
Then, link the bibliography to your document using the `bibliography` YAML metadata option.

Here's a notebook that includes a bibliography and single citation.
Note that markdown cells are un-executed so you can see all of the syntax.

```` {.markdown .visually-hidden}
---
title: Quarto Basics
format: html
bibliography: references.bib
jupyter: python3
---

## Overview

Knuth says always be literate [@knuth1984].

```{{python}}
1 + 1
```

## References
````

![](/docs/get-started/authoring/images/jupyter-citations.png){.border fig-alt=""}

Note that items within the bibliography are cited using the `@citeid` syntax.

``` markdown
 Knuth says always be literate [@knuth1984].
```

References will be included at the end of the document, so we include a `## References` heading at the bottom of the notebook.

Here is what this document looks like when rendered.

![](/docs/get-started/authoring/images/citations-render.png){.border width="600" fig-alt="Rendered notebook with references section at the bottom the content of which reads 'Knuth, Donald E. 1984. Literate Programming. The Computer Journal 27 (2): 97-111.'"}

\
The `@` citation syntax is very flexible and includes support for prefixes, suffixes, locators, and in-text citations.
See the documentation on [Citations](/docs/authoring/citations.qmd) to learn more.

## Cross References

Cross-references make it easier for readers to navigate your document by providing numbered references and hyperlinks to figures, tables, equations, and sections.
Cross-reference-able entities generally require a label (unique identifier) and a caption.

The notebook below illustrates cross-referencing various types of entities.
Once again, the markdown cells are again un-executed so that the syntax is visible.

```` {.markdown .visually-hidden}
---
title: Quarto Crossrefs
format: html
jupyter: python3
---

## Overview

See @fig-simple in @sec-plot for a demonstration of a simple plot. 

See @eq-stddev to better understand standard deviation.

## Plot {#sec-plot}

```{{python}}
#| label: fig-simple
#| fig-cap: "Simple Plot"
import matplotlib.pyplot as plt
plt.plot([1,23,2,4])
plt.show()
```

## Equation {#sec-equation}

$$
s = \sqrt{\frac{1}{N-1} \sum_{i=1}^N (x_i - \overline{x})^2}
$$ {#eq-stddev}
````

$$
x + 1
$$

![](/docs/get-started/authoring/images/jupyter-crossref.png){.border fig-alt=""}

This example includes cross-referenced sections, figures, and equations.
The table below shows how we expressed each of these.

+----------+---------------+----------------------------------+
| Entity   | Reference     | Label / Caption                  |
+==========+===============+==================================+
| Section  | `@sec-plot`   | ID added to heading:             |
|          |               |                                  |
|          |               | ``` {.default code-copy="false"} |
|          |               | # Plot {#sec-plot}               |
|          |               | ```                              |
+----------+---------------+----------------------------------+
| Figure   | `@fig-simple` | YAML options in code cell:       |
|          |               |                                  |
|          |               | ``` {.default code-copy="false"} |
|          |               | #| label: fig-simple             |
|          |               | #| fig-cap: "Simple Plot"        |
|          |               | ```                              |
+----------+---------------+----------------------------------+
| Equation | `@eq-stddev`  | At end of display equation:      |
|          |               |                                  |
|          |               | ``` default                      |
|          |               | $$ {#eq-stddev}                  |
|          |               | ```                              |
+----------+---------------+----------------------------------+

: {tbl-colwidths=\[20,30,50\]}

And finally, here is what this notebook looks like when rendered.

![](/docs/get-started/authoring/images/crossref-render.png){.border width="600" fig-alt="Rendered page with linked cross references to figures and equations."}

See the article on [Cross References](/docs/authoring/cross-references.qmd) to learn more, including how to customize caption and reference text (e.g. use "Fig." rather than "Figure").

## Callouts

Callouts are an excellent way to draw extra attention to certain concepts, or to more clearly indicate that certain content is supplemental or applicable to only some scenarios.

Callouts are markdown divs that have special callout attributes.
Here's an example of creating a callout within a markdown cell.

``` {.markdown .visually-hidden}
::: {.callout-note}
Note that there are five types of callouts, including:
`note`, `tip`, `warning`, `caution`, and `important`.
:::
```

![](/docs/get-started/authoring/images/jupyter-callout.png){.border fig-alt=""}

When we ultimately render the document with Quarto the callout appears as intended.

::: callout-note
Note that there are five types of callouts, including `note`, `tip`, `warning`, `caution`, and `important`.
:::

You can learn more about the different types of callouts and options for their appearance in the [Callouts](/docs/authoring/callouts.qmd) documentation.

## Article Layout

The body of Quarto articles have a default width of approximately 700 pixels.
This width is chosen to [optimize readability](https://medium.com/ben-shoemate/optimum-web-readability-max-and-min-width-for-page-text-dee9987a27a0).
This normally leaves some available space in the document margins and there are a few ways you can take advantage of this space.

In this notebook, we use the `reference-location` option to indicate that we would like footnotes to be placed in the right margin.

We also use the `column: screen-inset` cell option to indicate we would like our figure to occupy the full width of the screen, with a small inset.

```` {.markdown .visually-hidden}
---
title: Quarto Layout
format: html
reference-location: margin
jupyter: python3
---

## Placing Colorbars

Colorbars indicate the quantitative extent of image data.
Placing in a figure is non-trivial because room needs to
be made for them. The simplest case is just attaching a 
colorbar to each axes:^[See the [Matplotlib Gallery](https://matplotlib.org/stable/gallery/subplots_axes_and_figures/colorbar_placement.html) to explore colorbars further].

```{{python}}
#| code-fold: true
#| column: screen-inset
import matplotlib.pyplot as plt
import numpy as np

fig, axs = plt.subplots(2, 2)
fig.set_size_inches(20, 8)
cmaps = ['RdBu_r', 'viridis']
for col in range(2):
    for row in range(2):
        ax = axs[row, col]
        pcm = ax.pcolormesh(
          np.random.random((20, 20)) * (col + 1),
          cmap=cmaps[col]
        )
        fig.colorbar(pcm, ax=ax)
plt.show()
```
````

![](images/jupyter-layout.png){.border fig-alt=""}

Here is what this document looks like when rendered.

![](images/layout-render.png){.border fig-alt="Document with Quarto Layout title at the top followed by Placing Colorbars header with text below it. Next to the text is a footnote in the page margin. Below the text is a toggleable code widget to hide/reveal the code followed by four plots displayed in two rows and two columns."}

You can locate citations, footnotes, and [asides](/docs/authoring/article-layout.qmd#asides) in the margin.
You can also define custom column spans for figures, tables, or other content.
See the documentation on [Article Layout](/docs/authoring/article-layout.qmd) for additional details.

{{< include _footer.md >}}
```````

## File: docs/get-started/authoring/neovim.qmd
```````
---
title: "Tutorial: Authoring"
code-copy: hover
---

{{< include ../_tool-chooser.md >}}

{{< include _text-editor.md >}}


See the article on [Using Neovim with Quarto](/docs/tools/neovim.qmd) to learn more about installing, using, and customizing Neovim for Quarto.
```````

## File: docs/get-started/authoring/rstudio.qmd
```````
---
title: "Tutorial: Authoring"
editor_options:
  markdown:
    wrap: sentence
    canonical: true
---

{{< include ../_tool-chooser.md >}}

## Overview

In this tutorial we'll show you how to author Quarto documents in RStudio.
In particular, we'll discuss the various document formats you can produce with the same source code and show you how to add components like table of contents, equations, citations, etc.
The [visual markdown editor](/docs/visual-editor/index.qmd) in RStudio makes many of these tasks easier so we'll highlight its use in this tutorial, but note that it's possible to accomplish these tasks in the source editor as well.

If you would like to follow along step-by-step in your own environment, install the [latest release](https://posit.co/download/rstudio-desktop/) of RStudio.

## Output Formats

Quarto supports rendering notebooks to dozens of different output formats.
By default, the `html` format is used, but you can specify an alternate format (or formats) within document options.

### Format Options

You can choose the format you want to render your Quarto document to at the time of creating your new document.
To create a new document, go to **File** \> **New File** \> **Quarto Document...** Alternatively, use the command palette (accessible via Ctrl+Shift+P), search for **Create a new Quarto document** and hit return.

In the **Title** field, give a title for your document (e.g. the screenshot below suggests "Housing Prices") and add your name to the **Author** field.
Next, you will select the output format for your document.
By default, RStudio suggests using HTML as the output, let's leave that default for now.

![](images/rstudio-new-document.png){.border fig-alt="Pop up menu for creating a new document. The title field shows that we entered \"Housing Prices\" and the author field shows the name \"Mine Çetinkaya-Rundel\". HTML format is selected via the radio button. All else is left as default choices (e.g., Engine is Knitr and the Use visual markdown editor checkbox is checked)." fig-align="center" width="600"}

A new document will be created with the following YAML.

``` yaml
---
title: "Housing Prices"
author: "Mine Çetinkaya-Rundel"
---
```

Note that our format choice (HTML) is not even reflected in the YAML as it is the default output format for Quarto documents.
However you can directly edit the YAML to change the output format, e.g. to PDF (`pdf`) or MS Word (`docx`).
Add `format: pdf` to your document's YAML as shown below.

``` yaml
---
title: "Housing Prices"
author: "Mine Çetinkaya-Rundel"
format: pdf
---
```

Unfortunately, this document has no content, so rendering it would not result in very interesting output.
To make it a bit easier to demonstrate all the features we want to highlight in this tutorial, let's close this empty document and start with one that has a little bit of content in it.
If you would like to follow along step-by-step in your own environment, download the Quarto document (`.qmd`) below and open it in RStudio.

::: {.callout-note appearance="minimal" icon="false"}
<i class="bi bi-download"></i> [Download authoring.qmd](_authoring.qmd){download="authoring.qmd"}
:::

In order to create PDFs you will need to install a recent distribution of [LaTeX](https://www.latex-project.org/).
We recommend the use of TinyTeX (which is based on TexLive), which you can install with the following command:

``` {.bash filename="Terminal"}
quarto install tinytex
```

See the article on [PDF Engines](/docs/output-formats/pdf-engine.qmd) for details on using other LaTeX distributions and PDF compilation engines.

Once you have LaTeX setup, click on <kbd>![](images/rstudio-render-button.png){width="25" height="20"}</kbd> **Render** (or use the keyboard shortcut ⇧⌘K).
We recommend also checking the box for **Render on Save** for a live preview of your changes.
As shown below, you should see the rendered PDF in the Viewer in RStudio.

![](images/rstudio-pdf-preview.png){.border .column-page-right fig-alt="RStudio with authoring.qmd open. On the left: Source code in the visual editor. On the left: Rendered document as a PDF in the Viewer."}

Next, let's add an option to the YAML, e.g. to add line numbers to the code chunks (`code-line-numbers: true`).
Add this option to your document's YAML as shown below, paying attention to the indentation scheme.
Under `format:` our format choice `pdf` is indented (with two spaces) and it's followed by `:` to indicate that further options for that format will be specified.
In the next line, further indented by two spaces, we add `code-line-numbers: true`.

``` yaml
---
title: "Housing Prices"
author: "Mine Çetinkaya-Rundel"
format:
  pdf:
    code-line-numbers: true
---
```

If you checked **Render on Save** earlier, just save the document after making this change for a live preview.
Otherwise render the document to see your updates reflected, including a table of contents that looks like the following.

![](images/rstudio-code-line-numbers.png){.border fig-alt="Rendered version of authoring.qmd as PDF, with line numbers next to each of the lines of code chunks." fig-align="center"}

An incredibly exciting format option that we won't go into too much detail in this tutorial is `revealjs`.
Yes, you can make presentations with Quarto as well!
In fact, Quarto supports a variety of formats for creating presentations, including `revealjs` for HTML slides, `pptx` for PowerPoint, and `beamer` for LaTeX/PDF.
The [Presentations](/docs/presentations/index.qmd) article gives a thorough walk through of creating slide decks with Quarto.

### Multiple Formats

Some documents you create will have only a single output format, however in many cases it will be desirable to support multiple formats.
Let's add the `html` and `docx` formats to our document and modify some options specific to each format.

``` yaml
---
title: "Housing Prices"
author: "Mine Çetinkaya-Rundel"
highlight-style: pygments
format:
  html: 
    code-fold: true
    html-math-method: katex
  pdf:
    geometry: 
      - top=30mm
      - left=30mm
  docx: default
---
```

There's a lot to take in here!
Let's break it down a bit.
The first two lines are generic document metadata that aren't related to output formats at all.

``` yaml
---
title: "Housing Prices"
author: "Mine Çetinkaya-Rundel"
---
```

The next line is a document format option that *applies to all formats*, which is why it is specified at the root level.

``` yaml
---
highlight-style: pygments
---
```

Next, we have the `format` option, where we provide format-specific options.

``` yaml
---
format:
  html: 
    code-fold: true
    html-math-method: katex
  pdf:
    geometry: 
      - top=30mm
      - left=30mm
  docx: default
---
```

The `html` and `pdf` formats each provide an option or two.
For example, for the HTML output we want the user to have control over whether to show or hide the code (`code-fold: true`) and use `katex` for math text.
For PDF we define some margins.
The `docx` format is a bit different---it specifies `docx: default`.
This indicates that we just want to use all of the default options for the format.

## Rendering

Clicking the <kbd>![](images/rstudio-render-button.png){width="25" height="21"}</kbd> **Render** button (or using the keyboard shortcut <kbd>⇧⌘K</kbd>) in RStudio will render the document to the first format listed in the YAML.

![](images/rstudio-html-preview.png){.border fig-alt="Rendered version of authoring.qmd as HTML. There is no table of contents and the code chunks are folded, hiding the code."}

Note that the <kbd>![](images/rstudio-render-button.png){width="25" height="21"}</kbd> **Render** button also has a drop down menu that enables you to render to any of the formats listed in YAML front matter:

![](images/rstudio-render-formats.png){.border}

If you would like to render to all formats, you can do so with the [**quarto**](https://github.com/quarto-dev/quarto-r) package, which provides an R interface to the Quarto CLI. For example, to render the current document, use `quarto::quarto_render()`.
You can also specify the name of the document you want to render as well as the output format(s).

``` r
quarto::quarto_render(
  "authoring.qmd", 
  output_format = c("pdf", "html", "docx")
)
```

As a result, you will see three new files appear in your Files pane:

-   `authoring.docx`
-   `authoring.html`
-   `authoring.pdf`

![](images/rstudio-files-pane.png){.border fig-alt="RStudio Files pane, with four document, all titled authoring, but with different suffixes: docx, html, pdf, qmd." fig-align="center" width="600"}

## Sections

You can use a table of contents and/or section numbering to make it easier for readers to navigate your document.
Do this by adding the `toc` and/or `number-sections` options to document options.
Note that these options are typically specified at the root level because they are shared across all formats.

``` yaml
---
title: "Housing Prices"
author: "Mine Çetinkaya-Rundel"
toc: true
number-sections: true
highlight-style: pygments
format:
  html: 
    code-fold: true
    html-math-method: katex
  pdf:
    geometry: 
      - top=30mm
      - left=30mm
  docx: default
---
```

Here's what this document looks like when rendered to HTML.

![](images/rstudio-toc-secnum.png){.border fig-alt="Rendered version of authoring.qmd as HTML with numbered sections and a table of contens on the top right. The table of contents shows three sections: Introduction, Exploratory data analysis (with subsections Data visualization and Summary statistics), and Modeling."}

There are lots of options available for controlling how the table of contents and section numbering behave.
See the output format documentation (e.g. [HTML](/docs/output-formats/html-basics.qmd), [PDF](/docs/output-formats/pdf-basics.qmd), [MS Word](/docs/output-formats/ms-word.qmd)) for additional details.

## Equations

If you are using the visual editor mode, you can add LaTeX equations to Quarto documents in RStudio using the [Insert Anything](/docs/visual-editor/index.qmd#insert-anything) tool.
You can access it with <kbd>/</kbd> at the beginning of an empty block or <kbd>Cmd+/</kbd> anywhere else.

![](images/rstudio-insert-equation.png){.border fig-alt="Insert anything tool in the RStudio visual editor being used to insert a display math." fig-align="center" width="600"}

Display equations (in a new line) are delimited with `$$…$$` while inline equations are delimited with `$…$`.
Add the following as display math in the document.

``` markdown
price = \hat{\beta}_0 + \hat{\beta}_1 \times area + \epsilon
```

RStudio displays a rendered version of the tutorial as you type it in the editor.
See the documentation on [markdown equations](/docs/authoring/markdown-basics.qmd#equations) for additional details.

![](/docs/get-started/authoring/images/rstudio-equation-render.png){.border}

## Citations

The Insert Anything tool can also be used to insert citations to your document.

![](images/rstudio-insert-citation.png){fig-alt="Using the visual editor insert citation tool." width="700"}

In the next window you can insert a citation via from a variety of sources including your document bibliography, [Zotero](/docs/visual-editor/technical.qmd#citations-from-zotero) personal or group libraries, [DOI](/docs/visual-editor/technical.qmd#citations-from-dois) (Document Object Identifier) references, and searches of [Crossref](https://www.crossref.org/), [DataCite](https://datacite.org/), or [PubMed](https://pubmed.ncbi.nlm.nih.gov/).
You can find out more about citations with the visual editor [here](/docs/visual-editor/technical.qmd#citations).

Select **From DOI** on the left and copy-and-paste the DOI [`10.1093/comjnl/27.2.97`](https://doi.org/10.1093/comjnl/27.2.97) in the search bar and hit **Search**.
Then, select the found reference, and **Insert** it into your document.

![](images/rstudio-insert-citaton-menu.png){fig-alt="Insert citation to Knuth, D's Literate Programming article via DOI."}

If this is the first citation you are adding to your document, RStudio will automatically create a bibliography file for you.
This file is called `references.bib` by default and RStudio will also add `bibliography: references.bib` to your document's YAML metadata.

Note that items within the bibliography are cited using the `@citeid` syntax.
Add the following text to your document.

``` markdown
We're going to do this analysis using literate programming [@knuth1984].
```

References will be included at the end of the document, so we include a `## References` heading at the bottom of the notebook.
You might also add `.unnumbered` class to this section by clicking on the three dots (<kbd>...</kbd>) to edit its attributes.

![](images/rstudio-references-section.png){.border fig-alt="Edit Attributes window for the section title References. The image shows that this menu can be accessed by cliking on the three dots." width="700"}

Here is what this document looks like when rendered (with middle sections removed to highlight the relevant parts.

![](images/rstudio-references.png){.border fig-alt="Document with a single citation and a references section at the end."}

The `@` citation syntax is very flexible and includes support for prefixes, suffixes, locators, and in-text citations.
See the documentation on [Citations](/docs/authoring/citations.qmd) to learn more.

## Cross References

Cross-references make it easier for readers to navigate your document by providing numbered references and hyperlinks to figures, tables, equations, and sections.
Cross-reference-able entities generally require a label (unique identifier) and a caption.

For example, to add a label to the equation inserted earlier, click on the three dots to edit its attributes and use the suggested format (starting with `#eq-`) to label the equation.

![](images/rstudio-crossref-equation.png){.border fig-alt="Add label to an equation using the visual editor. The label added is #eq-slr."}

Then, add a cross reference using the Insert Anything tool in the visual editor.
You might add a sentence like `"We can fit a simple linear regression model of the form shown in"` to contextualize the cross reference and then add the reference to the end of that sentence.

![](images/rstudio-crossref-equation-insert.png){.border fig-alt="Use the insert anything tool in the visual editor to insert a cross reference."}

In the Insert Cross Reference menu, navigate to the desired cross reference entity on the left, and select the equation labeled earlier.

![](images/rstudio-crossref-insert-menu.png){.border fig-alt="Use the insert cross reference menu, select Equations on the left side, and select an equation to cross reference."}

Alternatively, start typing the label of the equation to be referenced in the visual editor, and the autofill tool will bring up the cross references to choose from.

![](images/rstudio-crossref-eq-autofill.png){.border fig-alt="Cross reference an equation by starting to type out its label."}

Below we illustrate cross-referencing various types of entities using fragments from the document you've been working with.

``` markdown
We present the results of exploratory data analysis in @sec-eda and the regression model in @sec-model.


@fig-scatterplot displays the relationship between these two variables in a scatterplot.


@tbl-stats displays basic summary statistics for these two variables.


We can fit a simple linear regression model of the form shown in @eq-slr.
```

This examples include cross-referenced sections, figures, and equations.
The table below summarizes how we express each of these.

+----------+--------------------+------------------------------------------------------------------------------+
| Entity   | Reference          | Label / Caption                                                              |
+==========+====================+==============================================================================+
| Section  | `@sec-eda`         | ID added to heading:                                                         |
|          |                    |                                                                              |
|          |                    | ``` {.default code-copy="false"}                                             |
|          |                    | # Exploratory data analysis {#sec-eda}                                       |
|          |                    | ```                                                                          |
+----------+--------------------+------------------------------------------------------------------------------+
| Figure   | `@fig-scatterplot` | YAML options in code cell:                                                   |
|          |                    |                                                                              |
|          |                    | ``` {.default code-copy="false"}                                             |
|          |                    | #| label: fig-scatterplot                                                    |
|          |                    | #| fig-cap: "Scatterplot of price vs. area of houses in Duke Forest"         |
|          |                    | ```                                                                          |
+----------+--------------------+------------------------------------------------------------------------------+
| Table    | `@tbl-stats`       | YAML options in code cell:                                                   |
|          |                    |                                                                              |
|          |                    | ``` {.default code-copy="false"}                                             |
|          |                    | #| label: tbl-stats                                                          |
|          |                    | #| tbl-cap: "Summary statistics for price and area of houses in Duke Forest" |
|          |                    | ```                                                                          |
+----------+--------------------+------------------------------------------------------------------------------+
| Equation | `@eq-slr`          | At end of display equation:                                                  |
|          |                    |                                                                              |
|          |                    | ``` default                                                                  |
|          |                    | $$ {#eq-slr}                                                                 |
|          |                    | ```                                                                          |
+----------+--------------------+------------------------------------------------------------------------------+

: {tbl-colwidths=\[20,30,50\]}

See the article on [Cross References](/docs/authoring/cross-references.qmd) to learn more, including how to customize caption and reference text (e.g. use "Fig." rather than "Figure").

## Callouts

Callouts are an excellent way to draw extra attention to certain concepts, or to more clearly indicate that certain content is supplemental or applicable to only some scenarios.

Callouts are markdown divs that have special callout attributes.
We can insert a callout using the Insert Anything tool.

![](images/rstudio-insert-callout.png){.border fig-alt="Insert Anything tool to insert a callout."}

In the subsequent dialogue you can select one of five types of callout (note, tip, important, caution, or warning), customize its appearance (default, simple, or minimal), and decide whether you want to show the icon.

![](images/rstudio-callout-dialogue.png){.border fig-alt="Callout dialogue. Type note is selected with default appearance and show icon box is checked." fig-align="center" width="500"}

Then, try inserting the following text in the callout box.

``` markdown
This is a pretty incomplete analysis, but hopefully the document provides a good overview of some of the authoring features of Quarto!
```

Here is what a callout looks like in the visual editor.

![](images/rstudio-callout-note-source.png){.border fig-alt="Callout box in the visual editor. Callout text reads \"This is a pretty incomplete analysis, but hopefully the document provides a good overview of some of the authoring features of Quarto!\""}

And here is the rendered callout in the output document.

![](images/rstudio-callout-note-rendered.png){.border fig-alt="Callout box in the rendered HTML document. Callout text reads \"This is a pretty incomplete analysis, but hopefully the document provides a good overview of some of the authoring features of Quarto!\""}

You can learn more about the different types of callouts and options for their appearance in the [Callouts](/docs/authoring/callouts.qmd) documentation.

## Article Layout

The body of Quarto articles have a default width of approximately 700 pixels.
This width is chosen to [optimize readability](https://medium.com/ben-shoemate/optimum-web-readability-max-and-min-width-for-page-text-dee9987a27a0).
This normally leaves some available space in the document margins and there are a few ways you can take advantage of this space.

We can use the `column: page-right` cell option to indicate we would like our figure to occupy the full width of the screen, with some inset.
Go ahead and add this chunk option to the chunk labeled `fig-histogram`.

``` r
#| label: fig-histogram
#| fig-cap: "Histograms of individual variables"
#| fig-subcap:
#|   - "Histogram of `price`s"
#|   - "Histogram of `area`s" 
#| layout-ncol: 2
#| column: page-right
```

Here is what the relevant section of the document looks like when rendered.

![](images/rstudio-column-page-right-render.png){.border fig-alt="Rendered version of authoring.qmd as HTML. Exploratory data analysis section is shown, the side-by-side histograms span a width wider than the rest of the document."}

You can locate citations, footnotes, and asides in the margin.
You can also define custom column spans for figures, tables, or other content.
See the documentation on [Article Layout](/docs/authoring/article-layout.qmd) for additional details.

## Publishing

Once your document is rendered to HTML, you can publish to [RPubs](https://rpubs.com/) (a free service from RStudio for sharing documents on the web) simply by clicking the <kbd>![](images/rstudio-publish-button.png){width="25" height="23"}</kbd> Publish button on the editor toolbar or preview window.
Alternatively, you can use the `quarto::quarto_publish_doc()` function.

``` r
quarto::quarto_publish_doc(
  "authoring.qmd", 
  server = "rpubs.com"
  )
```

Other possible publishing options include RStudio Connect and ShinyApps as well as GitHub Pages, Netlify, etc.
The [Publishing HTML](/docs/output-formats/html-publishing.qmd) article gives a much more detailed overview of your publishing options.

If you followed along step-by-step with this tutorial, you should now have a Quarto document that implements everything we covered.
Otherwise, you can download a completed version of `computations.qmd` below.

::: {.callout-note appearance="minimal"}
<i class="bi bi-download"></i> [Download authoring-complete.qmd](_authoring-complete.qmd){download="authoring-complete.qmd"}
:::

{{< include _footer.md >}}
```````

## File: docs/get-started/authoring/text-editor.qmd
```````
---
title: "Tutorial: Authoring"
code-copy: hover
editor_options:
  markdown:
    wrap: sentence
    canonical: true
---

{{< include ../_tool-chooser.md >}}

{{< include _text-editor.md >}}
```````

## File: docs/get-started/authoring/vscode.qmd
```````
---
title: "Tutorial: Authoring"
code-copy: hover
editor_options:
  markdown:
    wrap: sentence
    canonical: true
---

{{< include ../_tool-chooser.md >}}

{{< include _text-editor.md >}}


Additionally, if you are interested in seeing how to use Quarto from within `.ipynb` notebooks, check out the documentation on using the VS Code [Notebook Editor](/docs/tools/vscode/notebook.qmd) with Quarto.
```````

## File: docs/get-started/computations/_computations-complete.qmd
```````
---
title: "Quarto Computations"
format:
  html:
    code-fold: true
---

```{r}
#| label: load-packages
#| echo: false

library(ggplot2)
```

There are `{r} nrow(mpg)` observations in our data.

```{r}
#| echo: false

mean_cty <- round(mean(mpg$cty), 2)
mean_hwy <- round(mean(mpg$hwy), 2)
```

The average city mileage of the cars in our data is `{r} mean_cty` and the average highway mileage is `{r} mean_hwy`.

The plots in @fig-mpg show the relationship between city and highway mileage for 38 popular models of cars.
In @fig-mpg-1 the points are colored by the number of cylinders while in @fig-mpg-2 the points are colored by engine displacement.

```{r}
#| label: fig-mpg
#| fig-cap: "City and highway mileage for 38 popular models of cars."
#| fig-subcap:
#|   - "Color by number of cylinders"
#|   - "Color by engine displacement, in liters"
#| layout-ncol: 2
#| column: page
#| cache: true

ggplot(mpg, aes(x = hwy, y = cty, color = cyl)) +
  geom_point(alpha = 0.5, size = 2) +
  scale_color_viridis_c() +
  theme_minimal()

ggplot(mpg, aes(x = hwy, y = cty, color = displ)) +
  geom_point(alpha = 0.5, size = 2) +
  scale_color_viridis_c(option = "E") +
  theme_minimal()
```
```````

## File: docs/get-started/computations/_computations-text-editor.qmd
```````
---
title: Quarto Computations
jupyter: python3
---

## NumPy

```{python}
import numpy as np
a = np.arange(15).reshape(3, 5)
a
```

## Matplotlib

```{python}
import matplotlib.pyplot as plt

fig = plt.figure()
x = np.arange(10)
y = 2.5 * np.sin(x / 20 * np.pi)
yerr = np.linspace(0.05, 0.2, 10)

plt.errorbar(x, y + 3, yerr=yerr, label='both limits (default)')
plt.errorbar(x, y + 2, yerr=yerr, uplims=True, label='uplims=True')
plt.errorbar(x, y + 1, yerr=yerr, uplims=True, lolims=True,
             label='uplims=True, lolims=True')

upperlimits = [True, False] * 5
lowerlimits = [False, True] * 5
plt.errorbar(x, y, yerr=yerr, uplims=upperlimits, lolims=lowerlimits,
             label='subsets of uplims and lolims')

plt.legend(loc='lower right')
plt.show()
```

## Plotly

```{python}
import plotly.express as px
import plotly.io as pio
gapminder = px.data.gapminder()
gapminder2007 = gapminder.query("year == 2007")
fig = px.scatter(gapminder2007, 
                 x="gdpPercap", y="lifeExp", color="continent", 
                 size="pop", size_max=60,
                 hover_name="country")
fig.show()
```
```````

## File: docs/get-started/computations/_computations.qmd
```````
---
title: "Quarto Computations"
---

This dataset contains a subset of the fuel economy data from the EPA.
Specifically, we use the `mpg` dataset from the **ggplot2** package.

```{r}
#| label: load-packages
#| echo: false

library(ggplot2)
```

The visualization below shows a positive, strong, and linear relationship between the city and highway mileage of these cars.
Additionally, mileage is higher for cars with fewer cylinders.

```{r}
#| label: scatterplot

ggplot(mpg, aes(x = hwy, y = cty, color = cyl)) +
  geom_point(alpha = 0.5, size = 2) +
  scale_color_viridis_c() +
  theme_minimal()
```
```````

## File: docs/get-started/computations/index.qmd
```````
---
title: "Tutorial: Computations"
---
```````

## File: docs/get-started/computations/jupyter.qmd
```````
---
title: "Tutorial: Computations"
editor_options:
  markdown:
    wrap: sentence
tool:
  name: jupyter
---

{{< include ../_tool-chooser.md >}}

## Overview

Quarto has a wide variety of options available for controlling how code and computational output appear within rendered documents.
In this tutorial we'll take a simple notebook that has some numeric output and plots, and cover how to apply these options.

If you want to follow along step-by-step in your own environment, download the notebook below:

::: {.callout-note appearance="minimal"}
<i class="bi bi-journal-code"></i> [Download computations.ipynb](_computations.ipynb){download="computations.ipynb"}
:::

Then, create a new directory to work within and copy the notebook into this directory.

Once you've done that, switch to this directory in a Terminal, install notebook dependencies (if necessary), and open Jupyter Lab to get started working with the notebook.
The commands you can use for installation and opening Jupyter Lab are given in the table below.

+-----------+---------------------------------------------------------+
| Platform  | Commands                                                |
+===========+=========================================================+
|           | ```{.bash filename="Terminal"}                          |
| Mac/Linux | python3 -m pip install jupyter matplotlib plotly pandas |
|           | python3 -m jupyter lab computations.ipynb               |
|           | ```                                                     |
+-----------+---------------------------------------------------------+
|           | ```{.powershell filename="Terminal"}                    |
| Windows   | py -m pip install jupyter matplotlib plotly pandas      |
|           | py -m jupyter lab computations.ipynb                    |
|           | ```                                                     |
+-----------+---------------------------------------------------------+

The notebook as we start out is shown below.
Note that none of the cells are executed yet.

```` {.markdown .visually-hidden}
---
title: Quarto Computations
jupyter: python3
---

## NumPy

```{{python}}
import numpy as np
a = np.arange(15).reshape(3, 5)
a
```

## Matplotlib

```{{python}}
import matplotlib.pyplot as plt

fig = plt.figure()
x = np.arange(10)
y = 2.5 * np.sin(x / 20 * np.pi)
yerr = np.linspace(0.05, 0.2, 10)

plt.errorbar(x, y + 3, yerr=yerr, label='both limits (default)')
plt.errorbar(x, y + 2, yerr=yerr, uplims=True, label='uplims=True')
plt.errorbar(x, y + 1, yerr=yerr, uplims=True, lolims=True,
             label='uplims=True, lolims=True')

upperlimits = [True, False] * 5
lowerlimits = [False, True] * 5
plt.errorbar(x, y, yerr=yerr, uplims=upperlimits, lolims=lowerlimits,
             label='subsets of uplims and lolims')

plt.legend(loc='lower right')
plt.show(fig)
```

## Plotly

```{{python}}
import plotly.express as px
import plotly.io as pio
gapminder = px.data.gapminder()
gapminder2007 = gapminder.query("year == 2007")
fig = px.scatter(gapminder2007, 
                 x="gdpPercap", y="lifeExp", color="continent", 
                 size="pop", size_max=60,
                 hover_name="country")
fig.show()
```
````

![](images/jupyter-computations.png){.border fig-alt="Screen shot of computations.ipynb Jupyter notebook with NumPy, Matplotlib, and Plotly code cells shown."}

Next, create a new Terminal within Jupyter Lab to use for Quarto commands.

![](../hello/images/jupyter-terminal.png){.border fig-alt="Screenshot of menu items in Jupuyter Lab: File > New > Terminal."}

Finally, run `quarto preview` in the Terminal, and position Jupyter Lab side-by-side with the browser showing the preview.

``` {.bash filename="Terminal"}
quarto preview computations.ipynb
```

![](images/jupyter-computations-preview.png){.border fig-alt="Side-by-side preview of notebook on the left and live preview in the browser on the right."}

Go ahead and run all of the cells and then save the notebook.
You'll see that the preview updates immediately.

## Cell Output

All of the code in the notebook is displayed within the rendered document.
However, for some documents, you may want to hide all of the code and just show the output.
Let's go ahead and specify `echo: false` within the document `execute` options to prevent code from being printed.

``` {.yaml .visually-hidden}
---
title: Quarto Computations
execute:
  echo: false
jupyter: python3
---
```

![](images/jupyter-execute-echo-false.png){.border fig-alt="Screen shot of metadata section of Jupyter notebook with 'echo: false' included under the 'execute:' option."}

Save the notebook after making this change.
The preview will update to show the output with no code.

![](images/exec-echo-false-preview.png){.border fig-alt="Output of notebook with echo: false set, shows resulting array in NumPy section, line chart in Numpy section, and interactive bubble chart in Plotly section."}

You might want to selectively enable code `echo` for some cells.
To do this add the `echo: true` cell option.
Try this with the NumPy cell.

```` {.markdown .visually-hidden}
```{{python}}
#| echo: true

import numpy as np
a = np.arange(15).reshape(3, 5)
a
```
````

![](images/jupyter-exec-echo-true.png){.border fig-alt="Screen shot of NumPy section of Jupyter notebook with 'echo: true' set as a cell option for the code cell."}

Save the notebook and note that the code is now included for the NumPy cell.

![](images/exec-echo-true-preview.png){.border fig-alt="Screen shot of rendered NumPy section of Jupyter notebook which shows the code and the resulting array."}

There are a large number of other options available for cell output, for example `warning` to show/hide warnings (which can be especially helpful for package loading messages), `include` as a catch all for preventing any output (code or results) from being included in output, and `error` to prevent errors in code execution from halting the rendering of the document (and print the error in the rendered document).

See the [Jupyter Cell Options](/docs/reference/cells/cells-jupyter.qmd) documentation for additional details.

## Code Folding

Rather than hiding code entirely, you might want to fold it and allow readers to view it at their discretion.
You can do this via the `code-fold` option.
Remove the `echo` option we previously added and add the `code-fold` HTML format option.

``` {.yaml .visually-hidden}
---
title: Quarto Computations
execute:
   code-fold: true
jupyter: python3
---
```

![](images/jupyter-code-fold.png){.border fig-alt="Screen shot of metadata section of Jupyter notebook with 'code-fold: true' included under the 'html:' option, which is under the `format:` option."}

Save the notebook.
Now a "Code" widget is available above the output of each cell.

![](images/code-fold-preview.png){.border fig-alt="Screen shot of rendered NumPy section of Jupyter notebook which shows a toggleable section that is labelled 'Code' and the resulting array."}

You can also provide global control over code folding.
Try adding `code-tools: true` to the HTML format options.

``` {.yaml .visually-hidden}
---
title: Quarto Computations
execute:
   code-fold: true
   code-tools: true
jupyter: python3
---
```

![](images/jupyter-code-tools.png){.border fig-alt="Metadata section of Jupyter notebook with 'code-tools: true' added to the HTML format options."}

Save the notebook and you'll see that a code menu appears at the top right of the document that provides global control over showing and hiding code.

![](images/code-tools-preview.png){.border fig-alt="Output of notebook with 'code-tools: true' which includes a Code dropdown button next to the document header with two options: Show All Code, and Hide All Code."}

```` {.markdown .visually-hidden}
```{{python}}
#| label: fig-limits
#| fig-cap: "Errorbar limit selector"

import matplotlib.pyplot as plt

fig = plt.figure()
fig.set_size_inches(12, 7)
```
````

Let's improve the appearance of our Matplotlib output.
It could certainly stand to be wider, and it would be nice to provide a caption and a label for cross-referencing.

Go ahead and modify the Matplotlib cell to include `label` and `fig-cap` options as well as a call to `fig.set_size_inches()` to set a larger figure size with a wider aspect ratio.

```` {.markdown .visually-hidden}
```{{python}}
#| label: fig-limits
#| fig-cap: "Errorbar limit selector"

import matplotlib.pyplot as plt

fig = plt.figure()
fig.set_size_inches(12, 7)
```
````

![](images/jupyter-figure-options.png){.border fig-alt="Code cell with label and fig-cap options added, as well as a call to set the figure size explicitly."}

Execute the cell to see the updated plot.
Then, save the notebook so that the Quarto preview is updated.

![](images/figure-options-preview.png){.border fig-alt="Output of Matplotlib section of notebook which includes a caption under the figure that reads 'Figure 1: Errorbar limit selection.'"}

## Multiple Figures

The Plotly cell visualizes GDP and life expectancy data from a single year (2007).
Let's plot another year next to it for comparison and add a caption and subcaptions.
Since this will produce a wider visualization we'll also use the `column` option to lay it out across the entire page rather than being constrained to the body text column.

There are quite a few changes to this cell.
Copy and paste the code below into the notebook if you want to try them locally.

``` python
#| label: fig-gapminder
#| fig-cap: "Life Expectancy and GDP"
#| fig-subcap:
#|   - "Gapminder: 1957"
#|   - "Gapminder: 2007"
#| layout-ncol: 2
#| column: page

import plotly.express as px
import plotly.io as pio
gapminder = px.data.gapminder()
def gapminder_plot(year):
    gapminderYear = gapminder.query("year == " + 
                                    str(year))
    fig = px.scatter(gapminderYear, 
                     x="gdpPercap", y="lifeExp",
                     size="pop", size_max=60,
                     hover_name="country")
    fig.show()
    
gapminder_plot(1957)
gapminder_plot(2007)
```

Run the modified cell then save the notebook.
The preview will update as follows:

![](images/plotly-preview.png){.border fig-alt="Output of Plotly section which shows two charts side-by-side. The first has a caption below that reads '(a) Gapminder: 1957', the second's caption reads '(b) Gapminder 2007'. Below both figures, there's a caption that reads 'Figure 1: Life Expectancy and GDP (Data from World Bank via gapminder.org).'"}

Let's discuss some of the new options used here.
You've seen `fig-cap` before but we've now added a `fig-subcap` option.

``` python
#| fig-cap: "Life Expectancy and GDP"
#| fig-subcap:
#|   - "Gapminder: 1957"
#|   - "Gapminder: 2007"
```

For code cells with multiple outputs adding the `fig-subcap` option enables us to treat them as subfigures.

We also added an option to control how multiple figures are laid out---in this case we specified side-by-side in two columns.

``` python
#| layout-ncol: 2
```

If you have 3, 4, or more figures in a panel there are many options available for customizing their layout.
See the article on [Figures](/docs/authoring/figures.qmd) for details.

Finally, we added an option to control the span of the page that our figures occupy.

``` python
#| column: page
```

This allows our figure display to span out beyond the normal body text column.
See the documentation on [Article Layout](/docs/authoring/article-layout.qmd) to learn about all of the available layout options.

{{< include _footer.md >}}
```````

## File: docs/get-started/computations/neovim.qmd
```````
---
title: "Tutorial: Computations"
editor_options:
  markdown:
    wrap: sentence
    canonical: true
tool:
  name: neovim
---

{{< include _text-editor.md >}}
```````

## File: docs/get-started/computations/rstudio.qmd
```````
---
title: "Tutorial: Computations"
editor_options:
  markdown:
    wrap: sentence
    canonical: true
tool: 
  name: rstudio
---

{{< include ../_tool-chooser.md >}}


## Overview

Quarto supports executable code blocks within markdown.
This allows you to create fully reproducible documents and reports---the code required to produce your output is part of the document itself, and is automatically re-run whenever the document is rendered.

In this tutorial we'll show you how to author fully reproducible computational documents with Quarto in RStudio.

If you would like to follow along step-by-step in your own environment, download the Quarto document (`.qmd`) below, open it in RStudio, and click on <kbd>![](images/rstudio-render-button.png){width="25" height="20"}</kbd> **Render** (or use the keyboard shortcut ⇧⌘K).
We recommend also checking the box for **Render on Save** for a live preview of your changes.

::: {.callout-note appearance="minimal"}
<i class="bi bi-download"></i> [Download computations.qmd](_computations.qmd){download="computations.qmd"}
:::

Note that you will need to open this document in RStudio {{< var rstudio.min_version >}} or later, which you can download [here](https://posit.co/download/rstudio-desktop/).

## Cell Output

By default, the code and its output are displayed within the rendered document.

![](images/rstudio-computations-preview.png){.border .column-page-right fig-alt="RStudio window with computations.qmd open in the visual editor (on the right) and the rendered document (on the left). The document is titled Quarto Computations and contains some text and code. The rendered version also shows a visualization."}

However, for some documents, you may want to hide all of the code and just show the output.
To do so, specify `echo: false` within the `execute` option in the YAML.

``` yaml
---
title: "Quarto Computations"
execute:
  echo: false
---
```

If you checked **Render on Save** earlier, just save the document after making this change for a live preview.
Otherwise render the document to see your updates reflected.
The result will look like the following.

![](images/rstudio-exec-echo-false.png){.border fig-alt="Rendered computations.qmd document with title Quarto Computations, some descriptive text, and a plot. Code is not shown."}

You might want to selectively enable code `echo` for some cells.
To do this add the `echo: true` cell option.
Try this with the chunk labelled `scatterplot`.

``` r
#| label: scatterplot
#| echo: true

ggplot(mpg, aes(x = hwy, y = cty, color = cyl)) +
  geom_point(alpha = 0.5, size = 2) +
  scale_color_viridis_c() +
  theme_minimal()
```

Save the document again and note that the code is now included for the `scatterplot` chunk.

![](images/rstudio-exec-echo-true-preview.png){.border fig-alt="Rendered computations.qmd document with title Quarto Computations, some descriptive text, and a plot. Code is shown for the plot, but not for package loading."}

The `echo` option can be set to `true`, `false`, or `fenced`.
The last one might be of special interest for writing documentation and teaching materials as it allows you to include the fenced code delimiter in your code output to emphasize that executable code requires that delimiter.
You can read more about this option in the [Fenced Echo](/docs/computations/execution-options.qmd#fenced-echo) documentation.

There are a large number of other options available for cell output, for example `warning` for showing/hiding warnings (which can be especially helpful for package loading messages), `include` as a catch all for preventing any output (code or results) from being included in output, and `error` to prevent errors in code execution from halting the rendering of the document (and print the error in the rendered document).

See the [Knitr Cell Options](/docs/reference/cells/cells-knitr.qmd) documentation for additional details.

## Code Folding

Rather than hiding code entirely, you might want to fold it and allow readers to view it at their discretion.
You can do this via the `code-fold` option.
Remove the `echo` option we previously added and add the `code-fold` HTML format option.

``` yaml
---
title: "Quarto Computations"
format:
  html:
    code-fold: true
---
```

Save the document again and note that new Code widgets are now included for each code chunk.

![](images/rstudio-code-fold-preview.png){.border .column-page-right fig-alt="RStudio with computations.qmd open. On the right is the visual editor. The YAML has title and format defined. Title is Quarto Computations. Format is html, and code-fold option is set to true. On the right is the rendered version of the document. The title is followed by some text, which is followed by a Code widget that would expand if clicked on, which is followed by some more text, another code widget, and finally the plot. The Code widgets are folded, so the code is not visible in the rendered document."}

You can also provide global control over code folding.
Try adding `code-tools: true` to the HTML format options.

``` yaml
---
title: "Quarto Computations"
format:
  html:
    code-fold: true
    code-tools: true
---
```

Save the document and you'll see that a code menu appears at the top right of the rendered document that provides global control over showing and hiding all code.

![](images/rstudio-code-tools-preview.png){.border fig-alt="Rendered version of the computations.qmd document. A new code widget appears on top right of the document. The screenshot shows that the widget is clicked on, which reveals a drop down menu with three choices: Show All Code, Hide All Code, and View Source. In the background is the rendered document. The title is followed by some text, which is followed by a Code widget that would expand if clicked on, which is followed by some more text, another code widget, and finally the plot. The Code widgets are folded, so the code is not visible in the rendered document."}

## Code Linking

The `code-link` option enables hyper-linking of functions within code blocks to their online documentation.
Try adding `code-link: true` to the HTML format options.

``` yaml
---
title: "Quarto Computations"
format:
  html:
    code-link: true
---
```

Save the document and observe that the functions are now clickable hyperlinks.

![](images/rstudio-code-link-preview.png){.column-page-right fig-alt="Rendered version of the computations.qmd document. The document contains a title (Quarto Computations), text, code chunks, and a plot. The screenshot shows that function names in code chunks are clickable, and clicking on one brings you to documentation on the package website (which is shown on the foreground of the image). The function shown is theme_minimal() from ggplot2."}

Note that code linking is currently implemented only for the knitr engine via the [downlit](https://downlit.r-lib.org/) package.
A limitation of downlit currently prevents code linking if `code-line-numbers` and/or `code-annotations` are also `true`.

## Figures

We can improve the appearance and accessibility of our plot.
We can change its aspect ratio by setting `fig-width` and `fig-height`, provide a `fig-cap`, modify its `label` for cross referencing, and add [alternative text](https://medium.com/nightingale/writing-alt-text-for-data-visualization-2a218ef43f81) with `fig-alt`.

We'll add the following chunk options.

``` r
#| label: fig-scatterplot
#| fig-cap: "City and highway mileage for 38 popular models of cars."
#| fig-alt: "Scatterplot of city vs. highway mileage for cars, where points are colored by the number of cylinders. The plot displays a positive, linear, and strong relationship between city and highway mileage, and mileage increases as the number of cylinders decreases."
#| fig-width: 6
#| fig-height: 3.5
```

Save the document to see the updated plot.
Note that we have also updated the narrative with a [cross reference](/docs/authoring/cross-references.qmd#computations) to this figure using the following.

``` markdown
@fig-scatterplot shows a positive, strong, and linear relationship between the city and highway mileage of these cars.
```

![](images/rstudio-figure-options.png){.border .column-page-right fig-alt="RStudio with computations.qmd open. On the right is the visual editor. The YAML has title and format defined. Title is Quarto Computations. Format is html, and code-fold option is set to true. Compared to earlier images on the page, the code chunk shows the new chunk options added to the code chunk. On the right is the rendered version of the document. The title is followed by some text, which is followed by a Code widget that would expand if clicked on, which is followed by some more text, another code widget, and finally the plot. The Code widgets are folded, so the code is not visible in the rendered document."}

## Multiple Figures

Let's add another plot to our chunk---a scatterplot where the points are colored by engine displacement, using a different color scale.
Our goal is to display these plots side-by-side (i.e., in two columns), with a descriptive subcaption for each plot.
Since this will produce a wider visualization we'll also use the `column` option to lay it out across the entire page rather than being constrained to the body text column.

There are quite a few changes to this chunk.
To follow along, copy and paste the options outlined below into your Quarto document.

``` r
#| label: fig-mpg
#| fig-cap: "City and highway mileage for 38 popular models of cars."
#| fig-subcap:
#|   - "Color by number of cylinders"
#|   - "Color by engine displacement, in liters"
#| layout-ncol: 2
#| column: page

ggplot(mpg, aes(x = hwy, y = cty, color = cyl)) +
  geom_point(alpha = 0.5, size = 2) +
  scale_color_viridis_c() +
  theme_minimal()

ggplot(mpg, aes(x = hwy, y = cty, color = displ)) +
  geom_point(alpha = 0.5, size = 2) +
  scale_color_viridis_c(option = "E") +
  theme_minimal()
```

Additionally, replace the existing text that describes the visualization with the following.

``` markdown
The plots in @fig-mpg show the relationship between city and highway mileage for 38 popular models of cars.
In @fig-mpg-1 the points are colored by the number of cylinders while in @fig-mpg-2 the points are colored by engine displacement.
```

Then, save the document and inspect the rendered output, which should look like the following.

![](images/rstudio-multi-figure-preview.png){.border fig-alt="Rendered version of the computations.qmd document with a new plot. The document contains a title (Quarto Computations), text, code chunks, and figure include two side-by-side subfigures, each scatterplots. The text shows clickable cross reference links to Figure 1, Figure 1a, and Figure 1b."}

Let's discuss some of the new options used here.
You've seen `fig-cap` before but we've now added a `fig-subcap` option.

``` r
#| fig-cap: "City and highway mileage for 38 popular models of cars."
#| fig-subcap:
#|   - "Color by number of cylinders"
#|   - "Color by engine displacement, in liters"
```

For code cells with multiple outputs adding the `fig-subcap` option enables us to treat them as subfigures.

We also added an option to control how multiple figures are laid out---in this case we specified side-by-side in two columns.

``` r
#| layout-ncol: 2
```

If you have 3, 4, or more figures in a panel there are many options available for customizing their layout.
See the article [Figure Layout](/docs/authoring/figures.qmd#figure-panels) for details.

Finally, we added an option to control the span of the page that our figures occupy.

``` r
#| column: page
```

This allows our figure display to span out beyond the normal body text column.
See the documentation on [Article Layout](/docs/authoring/article-layout.qmd) to learn about all of the available layout options.

## Data Frames

{{< include ../../computations/_knitr-df-print.md >}}


## Inline Code

To include executable expressions within markdown, enclose the expression in `` `{r} ` ``^[Quarto also supports the Knitr syntax `` `r ` ``, read more in [Inline Code](/docs/computations/inline-code.qmd)].
For additional details on inline code expressions, please visit the [Inline Code](/docs/computations/inline-code.qmd) documentation.

For example, we can use inline code to state the number of observations in our data.
Try adding the following markdown text to your Quarto document.

````markdown
There are `{r} nrow(mpg)` observations in our data.
````

Save your document and inspect the rendered output.
The expression inside the backticks has been executed and the sentence includes the actual number of observations.

::: border
There are 234 observations in our data.
:::

If the expression you want to inline is more complex, involving many functions or a pipeline, we recommend including it in a code chunk (with `echo: false`) and assigning the result to an object.
Then, you can call that object in your inline code.

For example, say you want to state the average city and highway mileage in your data.
First, compute these values in a code chunk.

``` r
#| echo: false

mean_cty <- round(mean(mpg$cty), 2)
mean_hwy <- round(mean(mpg$hwy), 2)
```

Then, add the following markdown text to your Quarto document.

```markdown
The average city mileage of the cars in our data is `{r} mean_cty` and the average highway mileage is `{r} mean_hwy`. 
```

Save your document and inspect the rendered output.

::: border
The average city mileage of the cars in our data is 16.86 and the average highway mileage is 23.44.
:::

## Caching

If your document includes code chunks that take too long to compute, you might want to cache the results of those chunks.
You can use the `cache` option either at the document level using the YAML execute option.

``` yaml
execute:
  cache: true
```

However caching all code chunks in a document may not be preferable.
You can also indicate which chunks should be cached directly with using a chunk option.

``` r
#| cache: true
```

Try adding this chunk option to one of the code chunks in your document that produces a plot and save.
When the document is rendered, you'll see that a new folder has been created in your working directory with the same name as your document and the suffix `_cache`.
This folder contains the cached results.
You can find out more about caching in Quarto documents in the [Cache](/docs/projects/code-execution.qmd#cache) documentation.

If you followed along step-by-step with this tutorial, you should now have a Quarto document that implements everything we covered.
Otherwise, you can download a completed version of `computations.qmd` below.

::: {.callout-note appearance="minimal"}
`<i class="bi bi-download"></i>`{=html} [Download computations-complete.qmd](_computations-complete.qmd){download="computations-complete.qmd"}
:::

{{< include _footer.md >}}
```````

## File: docs/get-started/computations/text-editor.qmd
```````
---
title: "Tutorial: Computations"
editor_options:
  markdown:
    wrap: sentence
    canonical: true
tool:
  name: text-editor
---

{{< include _text-editor.md >}}
```````

## File: docs/get-started/computations/vscode.qmd
```````
---
title: "Tutorial: Computations"
editor_options:
  markdown:
    wrap: sentence
    canonical: true
tool:
  name: vscode
---

{{< include ../_tool-chooser.md >}}

## Overview

Quarto has a wide variety of options available for controlling how code and computational output appear within rendered documents.
In this tutorial we'll take a `.qmd` file that has some numeric output and plots, and cover how to apply these options.

This tutorial will make use of the `matplotlib` and `plotly` Python packages.
The commands you can use to install them are given in the table below.

+-----------+---------------------------------------------------------+
| Platform  | Commands                                                |
+===========+=========================================================+
| Mac/Linux | ```{.bash filename="Terminal"}                          |
|           | python3 -m pip install jupyter matplotlib plotly pandas |
|           | ```                                                     |
+-----------+---------------------------------------------------------+
| Windows   | ```{.powershell filename="Terminal"}                    |
|           | py -m pip install jupyter matplotlib plotly pandas      |
|           | ```                                                     |
+-----------+---------------------------------------------------------+

If you want to follow along step-by-step in your own environment, create a `computations.qmd` file and copy the following content into it.

```` markdown
---
title: Quarto Computations
jupyter: python3
---

## NumPy

```{{python}}
import numpy as np
a = np.arange(15).reshape(3, 5)
a
```

## Matplotlib

```{{python}}
import matplotlib.pyplot as plt

fig = plt.figure()
x = np.arange(10)
y = 2.5 * np.sin(x / 20 * np.pi)
yerr = np.linspace(0.05, 0.2, 10)

plt.errorbar(x, y + 3, yerr=yerr, label='both limits (default)')
plt.errorbar(x, y + 2, yerr=yerr, uplims=True, label='uplims=True')
plt.errorbar(x, y + 1, yerr=yerr, uplims=True, lolims=True,
             label='uplims=True, lolims=True')

upperlimits = [True, False] * 5
lowerlimits = [False, True] * 5
plt.errorbar(x, y, yerr=yerr, uplims=upperlimits, lolims=lowerlimits,
             label='subsets of uplims and lolims')

plt.legend(loc='lower right')
plt.show(fig)
```

## Plotly

```{{python}}
import plotly.express as px
import plotly.io as pio
gapminder = px.data.gapminder()
gapminder2007 = gapminder.query("year == 2007")
fig = px.scatter(gapminder2007, 
                 x="gdpPercap", y="lifeExp", color="continent", 
                 size="pop", size_max=60,
                 hover_name="country")
fig.show()
```
````

Then, execute the **Quarto: Preview** command.
You can alternatively use the <kbd>Ctrl+Shift+K</kbd> keyboard shortcut, or the **Preview** button (![](/docs/tools/images/vscode-preview-icon.svg){fig-alt="Preview icon"}) at the top right of the editor:

![](/docs/tools/images/vscode-preview-button.png){.border fig-alt="The top of the Visual Studio code editor. The right side of the editor tab area includes a Preview button."}

::: {.callout-note appearance="simple"}
Note that on the Mac you should use `Cmd` rather than `Ctrl` as the prefix for all Quarto keyboard shortcuts.
:::

Here is what you should see within VS Code:

![](images/vscode-computations-preview.png){.border .column-page-outset-right fig-alt="Side-by-side preview of text editor on the left and live preview in the browser on the right."}

## Cell Execution

As you author a document you may want to execute one or more cells without re-rendering the entire document.
You can do this using the **Run Cell** button above the code cell.
Click that button to execute the cell (output is shown side by side in the Jupyter interactive console):

![](/docs/tools/images/vscode-execute-cell.png){.border fig-alt="VS Code with two panes open, vscode.qmd source code on the right, and the interactive output of that code shown in a second pane on the left."}

There are a variety of commands and keyboard shortcuts available for executing cells:

| Quarto Command       | Keyboard Shortcut   |
|----------------------|---------------------|
| Run Current Cell     | <kbd>⇧⌘ Enter</kbd> |
| Run Selected Line(s) | <kbd>⌘ Enter</kbd>  |
| Run Next Cell        | <kbd>⌥⌘ N</kbd>     |
| Run Previous Cell    | <kbd>⌥⌘ P</kbd>     |
| Run All Cells        | <kbd>⌥⌘ R</kbd>     |
| Run Cells Above      | <kbd>⇧⌥⌘ P</kbd>    |
| Run Cells Below      | <kbd>⇧⌥⌘ N</kbd>    |

## Cell Output

All of the code in the source file is displayed within the rendered document.
However, in some cases, you may want to hide all of the code and just show the output.
Let's go ahead and specify `echo: false` within the document `execute` options to prevent code from being printed.

``` yaml
---
title: Quarto Computations
execute:
  echo: false
jupyter: python3
---
```

Re-render the document and the preview will update to show the output with no code (remember that you do not need to save the file before rendering, as this happens automatically when you render).

![](images/exec-echo-false-preview.png){.border fig-alt="Output of computations.qmd with 'echo: false' set, shows Title, resulting array in NumPy section, line chart in Matplotlib section, and interactive bubble chart in Plotly section."}

You might want to selectively enable code `echo` for some cells.
To do this add the `echo: true` cell option.
Try this with the NumPy cell.

```` markdown
```{{python}}
#| echo: true

import numpy as np
a = np.arange(15).reshape(3, 5)
a
```
````

Re-render note that the code is now included for the NumPy cell.

![](images/exec-echo-true-preview.png){.border fig-alt="Rendered NumPy section of computations.qmd which shows the code and the resulting array."}

There a large number of other options available for cell output, for example `warning` to show/hide warnings (which can be especially helpful for package loading messages), `include` as a catch all for preventing any output (code or results) from being included in output, and `error` to prevent errors in code execution from halting the rendering of the document (and print the error in the rendered document).

See the [Jupyter Cell Options](/docs/reference/cells/cells-jupyter.qmd) documentation for additional details.

## Code Folding

Rather than hiding code entirely, you might want to fold it and allow readers to view it at their discretion.
You can do this via the `code-fold` option.
Remove the `echo` option we previously added and add the `code-fold` HTML format option.

``` yaml
---
title: Quarto Computations
format:
  html:
    code-fold: true
jupyter: python3
---
```

Render the document.
Now a "Code" widget is available above the output of each cell.

![](images/code-fold-preview.png){.border fig-alt="Rendered NumPy section of computations.qmd which shows a toggleable section that is labelled 'Code' and the resulting array."}

You can also provide global control over code folding.
Try adding `code-tools: true` to the HTML format options.

``` yaml
---
title: Quarto Computations
format:
  html:
    code-fold: true
    code-tools: true
jupyter: python3
---
```

Render the document and you'll see that a code menu appears at the top right of the document that provides global control over showing and hiding code.

![](images/text-editor-code-tools-preview.png){.border fig-alt="Rendered version of the computations.qmd document. A new code widget appears on top right of the document. The screenshot shows that the widget is clicked on, which reveals a drop down menu with three choices: Show All Code, Hide All Code, and View Source. In the background is the rendered document. The title is followed by some text, which is followed by a Code widget that would expand if clicked on, which is followed by the output of the code. The Code widgets are folded, so the code is not visible in the rendered document."}

## Figures

Let's improve the appearance of our Matplotlib output.
It could certainly stand to be wider, and it would be nice to provide a caption and a label for cross-referencing.

Go ahead and modify the Matplotlib cell to include `label` and `fig-cap` options as well as a call to `fig.set_size_inches()` to set a larger figure size with a wider aspect ratio:

```` markdown
```{{python}}
#| label: fig-limits
#| fig-cap: "Errorbar limit selector"

import matplotlib.pyplot as plt

fig = plt.figure()
fig.set_size_inches(12, 7)
```
````

After re-rendering the document you'll see the updated plot:

![](images/figure-options-preview.png){.border fig-alt="Rendered Matplotlib section of computations.qmd which includes a toggleable code-folding widget, the figure, and a caption under the figure that reads 'Figure 1: Errorbar limit selection.'"}

## Multiple Figures

The Plotly cell visualizes GDP and life expectancy data from a single year (2007).
Let's plot another year next to it for comparison and add a caption and subcaptions.
Since this will produce a wider visualization we'll also use the `column` option to lay it out across the entire page rather than being constrained to the body text column.

There are quite a few changes to this cell.
Copy and paste this code into `computations.qmd` if you want to try them locally:

``` python
#| label: fig-gapminder
#| fig-cap: "Life Expectancy and GDP"
#| fig-subcap:
#|   - "Gapminder: 1957"
#|   - "Gapminder: 2007"
#| layout-ncol: 2
#| column: page

import plotly.express as px
import plotly.io as pio
gapminder = px.data.gapminder()
def gapminder_plot(year):
    gapminderYear = gapminder.query("year == " + 
                                    str(year))
    fig = px.scatter(gapminderYear, 
                     x="gdpPercap", y="lifeExp",
                     size="pop", size_max=60,
                     hover_name="country")
    fig.show()
    
gapminder_plot(1957)
gapminder_plot(2007)
```

Render the document and the preview will update as follows:

![](images/plotly-preview.png){.border fig-alt="Output of Plotly section which shows two charts side-by-side. The first has a caption below that reads '(a) Gapminder: 1957', the second's caption reads '(b) Gapminder 2007'. Below both figures, there's a caption that reads 'Figure 1: Life Expectancy and GDP (Data from World Bank via gapminder.org).'"}

Let's discuss some of the new options used here.
You've seen `fig-cap` before but we've now added a `fig-subcap` option:

``` python
#| fig-cap: "Life Expectancy and GDP"
#| fig-subcap:
#|   - "Gapminder: 1957"
#|   - "Gapminder: 2007"
```

For code cells with multiple outputs adding the `fig-subcap` option enables us to treat them as subfigures.

We also added an option to control how multiple figures are laid out---in this case we specified side-by-side in two columns:

``` python
#| layout-ncol: 2
```

If you have 3, 4, or more figures in a panel there are many options available for customizing their layout.
See the article [Figures](/docs/authoring/figures.qmd) for details.

Finally, we added an option to control the span of the page that our figures occupy:

``` python
#| column: page
```

This allows our figure display to span out beyond the normal body text column.
See the documentation on [Article Layout](/docs/authoring/article-layout.qmd) to learn about all of the available layout options.

{{< include _footer.md >}}
```````

## File: docs/get-started/hello/rstudio/_hello.qmd
```````
---
title: "Hello, Quarto"
format: html
editor: visual
---

```{r}
#| label: load-packages
#| include: false

library(tidyverse)
library(palmerpenguins)
```

## Meet Quarto

Quarto enables you to weave together content and executa