# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2.1
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class RecipientFormData(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, declined_time=None, delivered_time=None, email=None, form_data=None, name=None, recipient_id=None, sent_time=None, signed_time=None):
        """
        RecipientFormData - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'declined_time': 'str',
            'delivered_time': 'str',
            'email': 'str',
            'form_data': 'list[FormDataItem]',
            'name': 'str',
            'recipient_id': 'str',
            'sent_time': 'str',
            'signed_time': 'str'
        }

        self.attribute_map = {
            'declined_time': 'DeclinedTime',
            'delivered_time': 'DeliveredTime',
            'email': 'email',
            'form_data': 'formData',
            'name': 'name',
            'recipient_id': 'recipientId',
            'sent_time': 'SentTime',
            'signed_time': 'SignedTime'
        }

        self._declined_time = declined_time
        self._delivered_time = delivered_time
        self._email = email
        self._form_data = form_data
        self._name = name
        self._recipient_id = recipient_id
        self._sent_time = sent_time
        self._signed_time = signed_time

    @property
    def declined_time(self):
        """
        Gets the declined_time of this RecipientFormData.
        

        :return: The declined_time of this RecipientFormData.
        :rtype: str
        """
        return self._declined_time

    @declined_time.setter
    def declined_time(self, declined_time):
        """
        Sets the declined_time of this RecipientFormData.
        

        :param declined_time: The declined_time of this RecipientFormData.
        :type: str
        """

        self._declined_time = declined_time

    @property
    def delivered_time(self):
        """
        Gets the delivered_time of this RecipientFormData.
        

        :return: The delivered_time of this RecipientFormData.
        :rtype: str
        """
        return self._delivered_time

    @delivered_time.setter
    def delivered_time(self, delivered_time):
        """
        Sets the delivered_time of this RecipientFormData.
        

        :param delivered_time: The delivered_time of this RecipientFormData.
        :type: str
        """

        self._delivered_time = delivered_time

    @property
    def email(self):
        """
        Gets the email of this RecipientFormData.
        

        :return: The email of this RecipientFormData.
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """
        Sets the email of this RecipientFormData.
        

        :param email: The email of this RecipientFormData.
        :type: str
        """

        self._email = email

    @property
    def form_data(self):
        """
        Gets the form_data of this RecipientFormData.
        

        :return: The form_data of this RecipientFormData.
        :rtype: list[FormDataItem]
        """
        return self._form_data

    @form_data.setter
    def form_data(self, form_data):
        """
        Sets the form_data of this RecipientFormData.
        

        :param form_data: The form_data of this RecipientFormData.
        :type: list[FormDataItem]
        """

        self._form_data = form_data

    @property
    def name(self):
        """
        Gets the name of this RecipientFormData.
        

        :return: The name of this RecipientFormData.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this RecipientFormData.
        

        :param name: The name of this RecipientFormData.
        :type: str
        """

        self._name = name

    @property
    def recipient_id(self):
        """
        Gets the recipient_id of this RecipientFormData.
        Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.

        :return: The recipient_id of this RecipientFormData.
        :rtype: str
        """
        return self._recipient_id

    @recipient_id.setter
    def recipient_id(self, recipient_id):
        """
        Sets the recipient_id of this RecipientFormData.
        Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.

        :param recipient_id: The recipient_id of this RecipientFormData.
        :type: str
        """

        self._recipient_id = recipient_id

    @property
    def sent_time(self):
        """
        Gets the sent_time of this RecipientFormData.
        

        :return: The sent_time of this RecipientFormData.
        :rtype: str
        """
        return self._sent_time

    @sent_time.setter
    def sent_time(self, sent_time):
        """
        Sets the sent_time of this RecipientFormData.
        

        :param sent_time: The sent_time of this RecipientFormData.
        :type: str
        """

        self._sent_time = sent_time

    @property
    def signed_time(self):
        """
        Gets the signed_time of this RecipientFormData.
        

        :return: The signed_time of this RecipientFormData.
        :rtype: str
        """
        return self._signed_time

    @signed_time.setter
    def signed_time(self, signed_time):
        """
        Sets the signed_time of this RecipientFormData.
        

        :param signed_time: The signed_time of this RecipientFormData.
        :type: str
        """

        self._signed_time = signed_time

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
