# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2.1
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class UsageHistory(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, last_sent_date_time=None, last_signed_date_time=None, sent_count=None, signed_count=None):
        """
        UsageHistory - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'last_sent_date_time': 'str',
            'last_signed_date_time': 'str',
            'sent_count': 'str',
            'signed_count': 'str'
        }

        self.attribute_map = {
            'last_sent_date_time': 'lastSentDateTime',
            'last_signed_date_time': 'lastSignedDateTime',
            'sent_count': 'sentCount',
            'signed_count': 'signedCount'
        }

        self._last_sent_date_time = last_sent_date_time
        self._last_signed_date_time = last_signed_date_time
        self._sent_count = sent_count
        self._signed_count = signed_count

    @property
    def last_sent_date_time(self):
        """
        Gets the last_sent_date_time of this UsageHistory.
        The date and time the user last sent an envelope. 

        :return: The last_sent_date_time of this UsageHistory.
        :rtype: str
        """
        return self._last_sent_date_time

    @last_sent_date_time.setter
    def last_sent_date_time(self, last_sent_date_time):
        """
        Sets the last_sent_date_time of this UsageHistory.
        The date and time the user last sent an envelope. 

        :param last_sent_date_time: The last_sent_date_time of this UsageHistory.
        :type: str
        """

        self._last_sent_date_time = last_sent_date_time

    @property
    def last_signed_date_time(self):
        """
        Gets the last_signed_date_time of this UsageHistory.
        The date and time the user last signed an envelope.

        :return: The last_signed_date_time of this UsageHistory.
        :rtype: str
        """
        return self._last_signed_date_time

    @last_signed_date_time.setter
    def last_signed_date_time(self, last_signed_date_time):
        """
        Sets the last_signed_date_time of this UsageHistory.
        The date and time the user last signed an envelope.

        :param last_signed_date_time: The last_signed_date_time of this UsageHistory.
        :type: str
        """

        self._last_signed_date_time = last_signed_date_time

    @property
    def sent_count(self):
        """
        Gets the sent_count of this UsageHistory.
        The number of envelopes the user has sent. 

        :return: The sent_count of this UsageHistory.
        :rtype: str
        """
        return self._sent_count

    @sent_count.setter
    def sent_count(self, sent_count):
        """
        Sets the sent_count of this UsageHistory.
        The number of envelopes the user has sent. 

        :param sent_count: The sent_count of this UsageHistory.
        :type: str
        """

        self._sent_count = sent_count

    @property
    def signed_count(self):
        """
        Gets the signed_count of this UsageHistory.
        The number of envelopes the user has signed. 

        :return: The signed_count of this UsageHistory.
        :rtype: str
        """
        return self._signed_count

    @signed_count.setter
    def signed_count(self, signed_count):
        """
        Sets the signed_count of this UsageHistory.
        The number of envelopes the user has signed. 

        :param signed_count: The signed_count of this UsageHistory.
        :type: str
        """

        self._signed_count = signed_count

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
