# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2.1
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class WorkspaceFolderContents(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, end_position=None, folder=None, items=None, parent_folders=None, result_set_size=None, start_position=None, total_set_size=None, workspace_id=None):
        """
        WorkspaceFolderContents - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'end_position': 'str',
            'folder': 'WorkspaceItem',
            'items': 'list[WorkspaceItem]',
            'parent_folders': 'list[WorkspaceItem]',
            'result_set_size': 'str',
            'start_position': 'str',
            'total_set_size': 'str',
            'workspace_id': 'str'
        }

        self.attribute_map = {
            'end_position': 'endPosition',
            'folder': 'folder',
            'items': 'items',
            'parent_folders': 'parentFolders',
            'result_set_size': 'resultSetSize',
            'start_position': 'startPosition',
            'total_set_size': 'totalSetSize',
            'workspace_id': 'workspaceId'
        }

        self._end_position = end_position
        self._folder = folder
        self._items = items
        self._parent_folders = parent_folders
        self._result_set_size = result_set_size
        self._start_position = start_position
        self._total_set_size = total_set_size
        self._workspace_id = workspace_id

    @property
    def end_position(self):
        """
        Gets the end_position of this WorkspaceFolderContents.
        The last position in the result set. 

        :return: The end_position of this WorkspaceFolderContents.
        :rtype: str
        """
        return self._end_position

    @end_position.setter
    def end_position(self, end_position):
        """
        Sets the end_position of this WorkspaceFolderContents.
        The last position in the result set. 

        :param end_position: The end_position of this WorkspaceFolderContents.
        :type: str
        """

        self._end_position = end_position

    @property
    def folder(self):
        """
        Gets the folder of this WorkspaceFolderContents.

        :return: The folder of this WorkspaceFolderContents.
        :rtype: WorkspaceItem
        """
        return self._folder

    @folder.setter
    def folder(self, folder):
        """
        Sets the folder of this WorkspaceFolderContents.

        :param folder: The folder of this WorkspaceFolderContents.
        :type: WorkspaceItem
        """

        self._folder = folder

    @property
    def items(self):
        """
        Gets the items of this WorkspaceFolderContents.
        

        :return: The items of this WorkspaceFolderContents.
        :rtype: list[WorkspaceItem]
        """
        return self._items

    @items.setter
    def items(self, items):
        """
        Sets the items of this WorkspaceFolderContents.
        

        :param items: The items of this WorkspaceFolderContents.
        :type: list[WorkspaceItem]
        """

        self._items = items

    @property
    def parent_folders(self):
        """
        Gets the parent_folders of this WorkspaceFolderContents.
        

        :return: The parent_folders of this WorkspaceFolderContents.
        :rtype: list[WorkspaceItem]
        """
        return self._parent_folders

    @parent_folders.setter
    def parent_folders(self, parent_folders):
        """
        Sets the parent_folders of this WorkspaceFolderContents.
        

        :param parent_folders: The parent_folders of this WorkspaceFolderContents.
        :type: list[WorkspaceItem]
        """

        self._parent_folders = parent_folders

    @property
    def result_set_size(self):
        """
        Gets the result_set_size of this WorkspaceFolderContents.
        The number of results returned in this response. 

        :return: The result_set_size of this WorkspaceFolderContents.
        :rtype: str
        """
        return self._result_set_size

    @result_set_size.setter
    def result_set_size(self, result_set_size):
        """
        Sets the result_set_size of this WorkspaceFolderContents.
        The number of results returned in this response. 

        :param result_set_size: The result_set_size of this WorkspaceFolderContents.
        :type: str
        """

        self._result_set_size = result_set_size

    @property
    def start_position(self):
        """
        Gets the start_position of this WorkspaceFolderContents.
        Starting position of the current result set.

        :return: The start_position of this WorkspaceFolderContents.
        :rtype: str
        """
        return self._start_position

    @start_position.setter
    def start_position(self, start_position):
        """
        Sets the start_position of this WorkspaceFolderContents.
        Starting position of the current result set.

        :param start_position: The start_position of this WorkspaceFolderContents.
        :type: str
        """

        self._start_position = start_position

    @property
    def total_set_size(self):
        """
        Gets the total_set_size of this WorkspaceFolderContents.
        The total number of items available in the result set. This will always be greater than or equal to the value of the property returning the results in the in the response.

        :return: The total_set_size of this WorkspaceFolderContents.
        :rtype: str
        """
        return self._total_set_size

    @total_set_size.setter
    def total_set_size(self, total_set_size):
        """
        Sets the total_set_size of this WorkspaceFolderContents.
        The total number of items available in the result set. This will always be greater than or equal to the value of the property returning the results in the in the response.

        :param total_set_size: The total_set_size of this WorkspaceFolderContents.
        :type: str
        """

        self._total_set_size = total_set_size

    @property
    def workspace_id(self):
        """
        Gets the workspace_id of this WorkspaceFolderContents.
        The id of the workspace, always populated.

        :return: The workspace_id of this WorkspaceFolderContents.
        :rtype: str
        """
        return self._workspace_id

    @workspace_id.setter
    def workspace_id(self, workspace_id):
        """
        Sets the workspace_id of this WorkspaceFolderContents.
        The id of the workspace, always populated.

        :param workspace_id: The workspace_id of this WorkspaceFolderContents.
        :type: str
        """

        self._workspace_id = workspace_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
