---
layout: user-guide
---

Slang User's Guide
=============

Welcome to the Slang User's Guide, an introduction to the Slang language, compiler, and API. In this guide, you will learn:
- Slang's language features, including those inherited from HLSL and additional language features to make it easy to work with shaders.
- The compiler API that controls how to assemble shaders from different pieces of code, and how they are compiled for different targets.
- The reflection API that allows the host application to query the details of shader code in order to generate the right shader kernel and to set shader parameters correctly.

Note: this documentation is still under active development. While the coverage on language features is complete, we are still working on the remaining chapters on Slang's compilation and reflection API.

<!-- RTD-TOC-START
```{toctree}
:titlesonly:
:hidden:

Introduction <00-introduction>
Getting Started with Slang <01-get-started>
Conventional Language Features <02-conventional-features>
Basic Convenience Features <03-convenience-features>
Modules and Access Control <04-modules-and-access-control>
Capabilities <05-capabilities>
Interfaces and Generics <06-interfaces-generics>
Automatic Differentiation <07-autodiff>
Language Version <11-language-version>
Compiling Code with Slang <08-compiling>
Using the Reflection API <09-reflection>
Supported Compilation Targets <09-targets>
Link-time Specialization and Module Precompilation <10-link-time-specialization>
Special Topics <a1-special-topics>
Target-specific Features <a2-target-specific-features>
Reference <a3-reference>
```
RTD-TOC-END -->