# -*- coding: utf-8 -*-
"""
---------------------------------------------
Copyright (c) 2025 ZhangYundi
Licensed under the MIT License. 
Created on 2025/6/26 15:52
Email: yundi.xxii@outlook.com
Description: 应用层
---------------------------------------------
"""

def init_config():

    """初始化配置文件"""

    from pathlib import Path
    import shutil
    from importlib.resources import files
    import logair

    logger = logair.get_logger("quda.cli")
    source_conf_dir = files("quda.ml").joinpath("conf")
    # 当前工作目录下的 conf/
    target_conf_dir = Path.cwd() / "conf"
    if target_conf_dir.exists():
        logger.warning(f"{target_conf_dir} already exists.")
    try:
        shutil.copytree(source_conf_dir, target_conf_dir)
        logger.info(f"{target_conf_dir} created.")
    except Exception as e:
        logger.error(f"Failed to create {target_conf_dir}\n{e}")
