from typing import overload
from enum import IntEnum
import typing

import QuantConnect.Orders
import QuantConnect.Orders.Serialization
import QuantConnect.Util
import System


class SerializedOrderEvent(System.Object):
    """Data transfer object used for serializing an OrderEvent that was just generated by an algorithm"""

    @property
    def id(self) -> str:
        """The unique order event id"""
        ...

    @property
    def algorithm_id(self) -> str:
        """Algorithm Id, BacktestId or DeployId"""
        ...

    @algorithm_id.setter
    def algorithm_id(self, value: str) -> None:
        ...

    @property
    def order_id(self) -> int:
        """Id of the order this event comes from."""
        ...

    @order_id.setter
    def order_id(self, value: int) -> None:
        ...

    @property
    def order_event_id(self) -> int:
        """The unique order event id for each order"""
        ...

    @order_event_id.setter
    def order_event_id(self, value: int) -> None:
        ...

    @property
    def symbol(self) -> str:
        """Easy access to the order symbol associated with this event."""
        ...

    @symbol.setter
    def symbol(self, value: str) -> None:
        ...

    @property
    def symbol_value(self) -> str:
        """The mapped symbol value"""
        ...

    @symbol_value.setter
    def symbol_value(self, value: str) -> None:
        ...

    @property
    def symbol_permtick(self) -> str:
        """The symbols permanent ticker. For equities, by convention this is the first ticker symbol for which the security traded"""
        ...

    @symbol_permtick.setter
    def symbol_permtick(self, value: str) -> None:
        ...

    @property
    def time(self) -> float:
        """The time of this event in unix timestamp"""
        ...

    @time.setter
    def time(self, value: float) -> None:
        ...

    @property
    def status(self) -> QuantConnect.Orders.OrderStatus:
        """Status message of the order."""
        ...

    @status.setter
    def status(self, value: QuantConnect.Orders.OrderStatus) -> None:
        ...

    @property
    def order_fee_amount(self) -> typing.Optional[float]:
        """The fee amount associated with the order"""
        ...

    @order_fee_amount.setter
    def order_fee_amount(self, value: typing.Optional[float]) -> None:
        ...

    @property
    def order_fee_currency(self) -> str:
        """The fee currency associated with the order"""
        ...

    @order_fee_currency.setter
    def order_fee_currency(self, value: str) -> None:
        ...

    @property
    def fill_price(self) -> float:
        """Fill price information about the order"""
        ...

    @fill_price.setter
    def fill_price(self, value: float) -> None:
        ...

    @property
    def fill_price_currency(self) -> str:
        """Currency for the fill price"""
        ...

    @fill_price_currency.setter
    def fill_price_currency(self, value: str) -> None:
        ...

    @property
    def fill_quantity(self) -> float:
        """Number of shares of the order that was filled in this event."""
        ...

    @fill_quantity.setter
    def fill_quantity(self, value: float) -> None:
        ...

    @property
    def direction(self) -> QuantConnect.Orders.OrderDirection:
        """Order direction."""
        ...

    @direction.setter
    def direction(self, value: QuantConnect.Orders.OrderDirection) -> None:
        ...

    @property
    def message(self) -> str:
        """Any message from the exchange."""
        ...

    @message.setter
    def message(self, value: str) -> None:
        ...

    @property
    def is_assignment(self) -> bool:
        """True if the order event is an assignment"""
        ...

    @is_assignment.setter
    def is_assignment(self, value: bool) -> None:
        ...

    @property
    def quantity(self) -> float:
        """The current order quantity"""
        ...

    @quantity.setter
    def quantity(self, value: float) -> None:
        ...

    @property
    def stop_price(self) -> typing.Optional[float]:
        """The current stop price"""
        ...

    @stop_price.setter
    def stop_price(self, value: typing.Optional[float]) -> None:
        ...

    @property
    def limit_price(self) -> typing.Optional[float]:
        """The current limit price"""
        ...

    @limit_price.setter
    def limit_price(self, value: typing.Optional[float]) -> None:
        ...

    @property
    def is_in_the_money(self) -> bool:
        """True if the order event's option is In-The-Money (ITM)"""
        ...

    @is_in_the_money.setter
    def is_in_the_money(self, value: bool) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """Empty constructor required for JSON converter."""
        ...

    @overload
    def __init__(self, order_event: QuantConnect.Orders.OrderEvent, algorithm_id: str) -> None:
        """Creates a new instances based on the provided order event and algorithm Id"""
        ...


class OrderEventJsonConverter(QuantConnect.Util.TypeChangeJsonConverter[QuantConnect.Orders.OrderEvent, QuantConnect.Orders.Serialization.SerializedOrderEvent]):
    """Defines how OrderEvents should be serialized to json"""

    @property
    def populate_properties(self) -> bool:
        """
        True will populate TResult object returned by convert(SerializedOrderEvent) with json properties
        
        
        This codeEntityType is protected.
        """
        ...

    def __init__(self, algorithm_id: str = None) -> None:
        """
        Creates a new instance
        
        :param algorithm_id: The associated algorithm id, required when serializing
        """
        ...

    @overload
    def convert(self, value: QuantConnect.Orders.OrderEvent) -> QuantConnect.Orders.Serialization.SerializedOrderEvent:
        """
        Convert the input value to a value to be serialzied
        
        
        This codeEntityType is protected.
        
        :param value: The input value to be converted before serialziation
        :returns: A new instance of TResult that is to be serialzied.
        """
        ...

    @overload
    def convert(self, value: QuantConnect.Orders.Serialization.SerializedOrderEvent) -> QuantConnect.Orders.OrderEvent:
        """
        Converts the input value to be deserialized
        
        
        This codeEntityType is protected.
        
        :param value: The deserialized value that needs to be converted to OrderEvent
        :returns: The converted value.
        """
        ...


