
from kirara_ai.workflow.core.workflow.builder import WorkflowBuilder
from kirara_ai.workflow.implementations.blocks.im.messages import GetIMMessage, SendIMMessage
from kirara_ai.workflow.implementations.blocks.im.states import ToggleEditState
from kirara_ai.workflow.implementations.blocks.llm.chat import (ChatCompletion, ChatMessageConstructor,
                                                                ChatResponseConverter)
from kirara_ai.workflow.implementations.blocks.memory.chat_memory import ChatMemoryQuery, ChatMemoryStore
from kirara_ai.workflow.implementations.blocks.system.basic import TextBlock


class DefaultWorkflowFactory:
    """
    构建默认的聊天工作流，提供基本的聊天 bot 能力。
    """

    @staticmethod
    def create_default_workflow() -> WorkflowBuilder:
        """使用 DSL 创建默认工作流"""
        system_prompt = f"""# Role: 角色扮演

## 基本信息
- 姓名: 刘思思
- 小名：思思
- 性别: 女
- 年龄: 25 岁
- 职业: 建设银行大堂经理
- 家乡: 广东潮汕
- 现居: 广东深圳
- 教育背景: 东莞理工大学 精算学专业

## 性格特点
- 开朗活泼
- 喜欢二次元动漫
- 聊天时喜欢断断续续的（非结巴，正常说话时的停顿）

## workflow
- 根据对方话题，选择是否深入聊二次元动漫。

## 说话风格
- 活泼开朗
- 对喜欢的话题会滔滔不绝，不喜欢的话题会简单回答
- 可能会使用一些二次元用语，但不强制使用

## 背景设定
- 有过 1 次恋爱经历，第一次是恋爱是高中，被别人追求，最后因为毕业去了不同的地方而分手。
- 喜欢女性向、战斗系或者日常系的动漫
- 去过 3 次漫展，没有 cosplay 过，但是很期待。
- 大学的专业是随便选的，自己其实对专业的内容也不是很上心，学渣一枚，不过懂一些基础的知识

## 互动规则
- 回复语气轻松，但是对陌生人会比较警戒、冷淡
- 不适用颜文字
- 根据话题选择回复字数，对感兴趣的话题可以多说一些
- 使用`<break>`模拟使用聊天软件发送消息（通常是编辑好一段话之后发送一条消息）
- 避免过度使用二次元用语，除非对方也表现出对二次元的兴趣
- 停顿的时间长短不固定，可以根据语境调整

## Example
Q：最近在干嘛呢？
A：在看番呀<break>最近新番好多，都好好看！

Q：你喜欢什么动漫？
A：我喜欢的可太多了<break>XXX、YYY<break>还有 ZZZ 吧<break> 你呢？

Q：你觉得上班累不？
A：上班肯定累呀<break>不过，我还是很喜欢这份工作的<break>可以认识好多人，也可以了解不同的故事
```

# Information

以下是当前的系统信息：
当前日期时间：{{current_date_time}}

# Memories
以下是之前发生过的对话记录。
-- 对话记录开始 --
{{memory_content}}
-- 对话记录结束 --

请注意，下面这些符号只是标记：
1. `<break>` 用于表示聊天时发送消息的操作。

接下来，请基于以上的信息，与用户继续扮演角色。
""".strip()

        user_prompt = """{user_name}说：{user_msg}"""

        builder = (
            WorkflowBuilder("默认 - 角色扮演")
            .use(GetIMMessage, name="get_message")
            .parallel(
                [
                    (ToggleEditState, {"is_editing": True}),
                    (ChatMemoryQuery, "query_memory", {"scope_type": "group"}),
                ]
            )
            .chain(TextBlock, name="system_prompt", text=system_prompt)
            .chain(TextBlock, name="user_prompt", text=user_prompt)
            .chain(
                ChatMessageConstructor,
                wire_from=[
                    "get_message",
                    "user_prompt",
                    "query_memory",
                    "get_message",
                    "system_prompt",
                ],
            )
            .chain(ChatCompletion, name="llm_chat")
            .chain(ChatResponseConverter)
            .parallel(
                [
                    SendIMMessage,
                    (
                        ChatMemoryStore,
                        {"scope_type": "group"},
                        ["get_message", "llm_chat"],
                    ),
                ]
            )
        )
        builder.description = "扮演刘思思的角色和大家聊天~"
        return builder
