
[![YouTube](https://img.shields.io/youtube/views/zkcQn23DRaw?style=flat&logo=youtube&logoColor=red&label=YouTube)](https://www.youtube.com/watch?v=zkcQn23DRaw)
[![GitHub](https://img.shields.io/github/v/release/Stoupy51/stewbeet?logo=github&label=GitHub)](https://github.com/Stoupy51/stewbeet/releases/latest)
[![PMC](https://img.shields.io/badge/dynamic/json?url=https%3A%2F%2Fwww.planetminecraft.com%2Fdata-pack%2Fpython-datapack%2Fstatsv2&query=%24.downloads&logo=data%3Aimage%2Fvnd.microsoft.icon%3Bbase64%2CAAABAAEAEBAAAAEAIABoBAAAFgAAACgAAAAQAAAAIAAAAAEAIAAAAAAAAAAAABMLAAATCwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAJdNAUBLJgD%2FSyYA%2FxkoD%2F8vKAn%2Fl00BgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA%2FwAAAP8AAAD%2FmVgI%2F0tcHf8CXjP%2FL10l%2FwAAAP8AAAD%2FAAAA%2FwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA%2F5VOAf%2BVTQH%2FfVkP%2FyZ%2BOv8BgET%2FAYBE%2FwGARP9LZyP%2FlU0B%2F5ZNAf8AAAD%2FAAAAAAAAAAAAAAAAAAAAAJVOAf%2FYeRL%2F64wl%2F7eZOP8Bo1f%2FAaNW%2FwGjVv88nkv%2F2oEb%2F9N0Df%2FTdA3%2FlU0B%2F5dNAUAAAAAAAAAAAAAAAACkVQH%2F3pAq%2F6CcOv92pUf%2FLLli%2F12zW%2F%2FBqEv%2Fy59B%2F%2B2OJ%2F%2Figxz%2F03QN%2F5VNAf%2BEUARAAAAAAAAAAAAAAAD%2FjoMq%2Fzi2XP96r1T%2F3ahG%2F%2BCvUP%2F9qkr%2F%2F6hL%2F%2F2kRP%2F2mTT%2F7Y4n%2F%2BCBGv93aRf%2FAAAA%2FwAAAAAAAAAAp1gB%2FxHEb%2F%2BlslX%2F36xL%2F9StTP%2F%2Fp0f%2F%2F6VE%2F%2F%2BqTv%2F%2Fqk7%2F%2FaVH%2F%2FecOf%2Ftjif%2FMIQ3%2FwNhMP8AAAAAAAAAAI9bA%2F8SxXD%2FHr5o%2Fzm8ZP%2Fvo0D%2F%2F6I9%2F%2F%2BiPf%2F%2Fq1D%2F%2F6tQ%2F%2F%2BrUP%2F7pEb%2F7Y4n%2FwGCQf8BYDD%2FAAAAAAAAAAB8Wgz%2FFMdy%2FxDDbv8Qw27%2Fh7Zd%2F%2F%2BnSP%2F%2Foj3%2F%2F6xS%2F%2F%2BsUv%2F%2Fp0j%2F%2B504%2F%2B2OJ%2F%2BUfyH%2FAWIw%2FwAAAAAAAAAAelsL%2Fwa2Y%2F8TxnH%2FieK4%2F9fu2P%2F%2F2rH%2F%2F6pN%2F%2F%2BlQv%2F%2FpUL%2F%2F6NA%2F%2F2fOv%2F1li%2F%2FlH8h%2FwJhMP8AAAAAqVcBQIFaCkABczz%2FFMdy%2F7Hs0P%2F%2F%2F%2F%2F%2F6O7W%2F9SyV%2F%2F%2Foj3%2F%2F6RC%2F%2FidOv%2Fxkyz%2FxJEw%2F01fGf8hWR1wAVQqQAAAAAAAAAAAAV4y%2Fw2%2Fa%2F%2Bs16b%2F1OfK%2F7%2Fdr%2F%2F%2BrFH%2F%2F6RB%2F%2F%2BmRv%2F2mzn%2F2Y4p%2F2qOOP8BVCr%2FJDorQAAAAAAAAAAAAAAAAAFeMv8BsF7%2FLbpl%2F0DAaP%2Bmtlz%2Fo7Vc%2F%2F%2BoS%2F%2F%2FqEv%2F9ps6%2FyeOQf8BjUb%2FAlQq%2FwFUKkAAAAAAAAAAAAAAAAAAAAAAAl0z%2FxheKf8PdTL%2FeqxN%2FyvDaf%2F8rVL%2Fz6dF%2F7R6H%2F8BXS7%2FAlQq%2FwdRKwIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABGUCICeF4GQGNfDP9sXwj%2FqFgB%2F4hbB%2F9DWiKAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAKpXAUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA%2FB8AAOAHAADAAwAAwAMAAMADAACAAQAAgAEAAIABAACAAQAAgAEAAMADAADAAwAAwAMAAOAHAAD8H%2F%2F%2F%2F%2F%2F%2F%2Fw%3D%3D&label=PMC&color=6ec310)](https://www.planetminecraft.com/data-pack/python-datapack/)
[![Discord](https://img.shields.io/discord/1216400498488377467?label=Discord&logo=discord)](https://discord.gg/anxzu6rA9F)
[![PyPI - Downloads](https://img.shields.io/pypi/dm/stewbeet?logo=python&label=PyPI%20downloads)](https://pypi.org/project/stewbeet/)


## ❓ What is `StewBeet`
`StewBeet` is a [Beet](https://github.com/mcbeet/beet) framework and library 📦 aiming to provide huge automation for creating Minecraft datapacks.<br>
It is designed to be very simple to use and very convenient for developers.

`Example of the in-game manual generated by StewBeet:`<br>
![In-game Manual Example](https://i.imgur.com/dtuAG99.gif)


Here is a list of features that the package provides (the template is using all of them with clear comments):

- 🔄 Automatic resource pack files generation (models, textures, sounds, music discs) with the ability to override them with help of the `assets` folder.
- ⏳ Versioned load, and clock functions such as `tick`, `second`, `minute`.
- 🗃️ Loot tables for every item in the `definitions` along with a proper `_give_all` function that gives named chests.
- 📖 Automatic generation of a really [advanced and interactive items `manual`](./assets/in_game_manual_example.png).
- 📝 Automatic generation of a `en-us.json` lang file in the resource pack if configuration is set.
- 🖼️ Automatic headers for every function in `function` folders.
- 📦 Minecraft like vanilla recipes unlocking.
- 📚 Official libraries integrations:
  - 🧪 Automatic support for NBT Recipes with [`Smithed Crafter`](https://wiki.smithed.dev/libraries/crafter/) and [`Furnace NBT Recipes`](https://github.com/Stoupy51/FurnaceNbtRecipes/)
  - 🛠️ Placement and destruction for every custom block in the `definitions` with support for blockstates, ore drops (fortune, silk touch), with [`Smithed Custom Blocks`](https://wiki.smithed.dev/libraries/custom-block/).
  - 📚 Each module from [`Bookshelf`](https://github.com/mcbookshelf/bookshelf) is automatically added if you are using it, ex: `function #bs.math:...` will add the `bs.math` module to the datapack.
  - ⛏️ Custom ore generation with [`Smart Ore Generation`](https://github.com/Stoupy51/SmartOreGeneration).
  - 📦 Item transportation / container declaration with [`ItemIO`](https://github.com/edayot/ItemIO) when making custom containers.
  - 🔔 Events such as new items detection with [`Common Signals`](https://github.com/Stoupy51/CommonSignals).
- 🌐 External datapack libraries support, see configuration for more information.
- 🔗 Merging datapacks and resource packs with libraries using [Smithed Weld](https://weld.smithed.dev/).
- 🧩 Automatic recognition of custom blocks patterns depending on the texture names in the `assets/textures` folder. For instance, if you have a top, side, and bottom texture, the block will be automatically recognized as a cube with the top, side, and bottom textures.
- 📏 Follow the datapack conventions such as [LanternLoad](https://github.com/LanternMC/load), [CustomModelData prefix](https://mcdatapack.vercel.app/), [tag specification](https://wiki.smithed.dev/conventions/tag-specification/), and [namespacing](https://wiki.smithed.dev/conventions/namespacing/).
- 🧰 Ability to merge a model with the autogenerated one or override it.
- 🔀 `merge` folder providing a way to merge custom files with the autogenerated ones or add custom files to the datapack.
- ⚙️ Automatic special compatibilities with datapacks such as [`SimpleDrawer's compacted drawer`](https://edayot.github.io/SimpleDrawer/material.html), [`SimplEnergy's pulverizer`](./build/datapack/data/your_namespace/function/calls/simplenergy/pulverizer_recipes.mcfunction).
- 📂 Automatic copy of generated zip files to configured folders.


## 📦 How to use (beginner friendly)
In order to use `StewBeet`, you need to have at least [Python 3.12](https://www.python.org/downloads/) 🐍 or higher installed on your computer with pip!<br>
Then, you can open a terminal 💻 and run the following command to install the python package:

```bash
# This will install the latest version of the framework
# (including beet, bolt, mecha, and other dependencies)
pip install stewbeet
```

Next, there are a few templates available in the [`./templates`](./templates/) folder 📁,<br>
There are 3 templates available, feel free to choose the one you prefer (but I highly recommend the basic template):
- 🔹 [`minimal template`](./templates/minimal_template.zip): A very minimal template using only one `stewbeet` plugin.
- ⭐ [`basic template`](./templates/basic_template.zip): A template with complete configuration but no coded features.
- 🌟 [`extensive template`](./templates/extensive_template.zip): A template with all the features of the framework, including all the plugins.

The clickable links are zip files 📦, but you can check the content of the templates in the [`./templates`](./templates/) folder.<br>

Once you have a template, you can modify the `beet.yml` configuration file ⚙️ to suit your needs.<br>
Finally, you can run the following command to build the project 🔨:

```bash
# You can also run 'beet' instead of 'stewbeet' but with less functionality
# (Make sure you are in the project folder)
stewbeet
```
The command will generate a datapack and a resource pack in your `build` folder 🏗️.<br>
And that's it! 🎉 That is this easy use the package.<br>
Since this template is using all the features of the package, you can remove the parts you don't need! 🧹

## 🌱 How to use (Beet users)
If you are already familiar with the [Beet](https://github.com/mcbeet/beet) development kit, `StewBeet` is developped as a bunch of plugins for it.<br>
Install `StewBeet` with `pip install stewbeet` and check the [StewBeet plugins documentation](./docs/plugins/README.md) to learn about them.


## 📚 Documentation
There are a lot of features in the package, you could check the [extensive template](./templates/extensive/) to see how to use them.<br>
Alternatively, you could join the [Discord server](https://discord.gg/anxzu6rA9F) to ask questions and get help from the community!<br>
Or, you could check the **highly detailed** [documentation folder](docs/)<br>
Here a list of all the currently available guides:
- 📖 [Getting started](docs/0_getting_started/README.md)
- 🌱 [Beet Plugins](docs/plugins/README.md)
- 📁 [Project structure](docs/1_project_structure.md)
- 🗄️ [Database setup](docs/2_definitions_setup.md)
- ✍️ [Writing to files](docs/3_writing_to_files.md)
- 🔗 [External dependencies](docs/4_external_dependencies.md)
- 🔧 [Miscellaneous](docs/5_miscellaneous.md)
- 🔄 [Migration guide](docs/6_migration_guide.md)
- 🚀 [Continuous delivery](docs/7_continuous_delivery.md)
- ⚔️ [Adding a sword](docs/specific_guides/adding_a_sword.md)
- More soon!


## 🤝 Contribute
Want to help improve StewBeet? 🔍<br>
Here's how you can contribute:
- 🐛 **Report Bugs**: Found a bug? Open an issue on GitHub describing what happened and how to reproduce it.
- ✨ **Suggest Features**: Have an idea for a new feature? Share it in the issues section!
- 🔧 **Submit Pull Requests**: Feel free to fix bugs or add new features by submitting pull requests.
- 📚 **Improve Documentation**: Help make our docs better by fixing errors or adding examples.
- 💬 **Help Others**: Join our [Discord server](https://discord.gg/anxzu6rA9F) and help other users with their questions.

Every contribution matters, no matter how small! 🙌


## 📜 What projects use StewBeet?
To search for projects that use the framework, I search like [this.](https://github.com/search?q=%22%5C%22stewbeet.plugins.%22&type=code)<br>
Here is a list of projects that use it:<br>
- Actual projects:
  - Your next project here!
  - https://github.com/e-psi-lon/Armored-Elytra (Python Datapack: before Stewbeet was a thing)
  - https://github.com/Stoupy51/SimplEnergy
  - https://github.com/Stoupy51/ImagineYourCraftDatapack
  - https://github.com/Stoupy51/LifeSteal
  - https://github.com/Stoupy51/Survisland
  - https://github.com/Stoupy51/SmithedSummit
  - https://github.com/Stoupy51/SheepWars
  - https://github.com/Stoupy51/MoreApples
  - https://github.com/Stoupy51/CauldronConcretePowder

- Libraries or tools:
  - https://github.com/Stoupy51/SmartOreGeneration
  - https://github.com/Stoupy51/CommonSignals


## ⭐ Star History

<html>
  <a href="https://star-history.com/#Stoupy51/StewBeet&Date">
    <picture>
      <source media="(prefers-color-scheme: dark)" srcset="https://api.star-history.com/svg?repos=Stoupy51/StewBeet&type=Date&theme=dark" />
      <source media="(prefers-color-scheme: light)" srcset="https://api.star-history.com/svg?repos=Stoupy51/StewBeet&type=Date" />
      <img alt="Star History Chart" src="https://api.star-history.com/svg?repos=Stoupy51/StewBeet&type=Date" />
    </picture>
  </a>
</html>

