# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at https://mozilla.org/MPL/2.0/.
# SPDX-License-Identifier: MPL-2.0

import VeraGridEngine.IO.cim.cgmes.cgmes_assets.cgmes_2_4_15_assets as cgmes24
import VeraGridEngine.IO.cim.cgmes.cgmes_assets.cgmes_3_0_0_assets as cgmes30


CGMES_ASSETS = cgmes24.CGMES_2_4_15_ASSETS | cgmes30.CGMES3_ASSETS

CGMES_ACDC_CONVERTER = cgmes24.ACDCConverter | cgmes30.ACDCConverter
CGMES_ACDC_CONVERTER_DC_TERMINAL = cgmes24.ACDCConverterDCTerminal | cgmes30.ACDCConverterDCTerminal
CGMES_CS_CONVERTER = cgmes24.CsConverter | cgmes30.CsConverter
CGMES_DC_BASE_TERMINAL = cgmes24.DCBaseTerminal | cgmes30.DCBaseTerminal
CGMES_DC_BREAKER = cgmes24.DCBreaker | cgmes30.DCBreaker
CGMES_DC_BUSBAR = cgmes24.DCBusbar | cgmes30.DCBusbar
CGMES_DC_CHOPPER = cgmes24.DCChopper | cgmes30.DCChopper
CGMES_DC_CONDUCTING_EQUIPMENT = cgmes24.DCConductingEquipment | cgmes30.DCConductingEquipment
CGMES_DC_CONVERTER_UNIT = cgmes24.DCConverterUnit | cgmes30.DCConverterUnit
CGMES_DC_DISCONNECTOR = cgmes24.DCDisconnector | cgmes30.DCDisconnector
CGMES_DC_EQUIPMENT_CONTAINER = cgmes24.DCEquipmentContainer | cgmes30.DCEquipmentContainer
CGMES_DC_GROUND = cgmes24.DCGround | cgmes30.DCGround
CGMES_DC_LINE = cgmes24.DCLine | cgmes30.DCLine
CGMES_DC_LINE_SEGMENT = cgmes24.DCLineSegment | cgmes30.DCLineSegment
CGMES_DC_NODE = cgmes24.DCNode | cgmes30.DCNode
CGMES_DC_SERIES_DEVICE = cgmes24.DCSeriesDevice | cgmes30.DCSeriesDevice
CGMES_DC_SHUNT = cgmes24.DCShunt | cgmes30.DCShunt
CGMES_DC_SWITCH = cgmes24.DCSwitch | cgmes30.DCSwitch
CGMES_DC_TERMINAL = cgmes24.DCTerminal | cgmes30.DCTerminal
CGMES_FULL_MODEL = cgmes24.FullModel | cgmes30.FullModel
CGMES_PER_LENGTH_DC_LINE_PARAMETER = cgmes24.PerLengthDCLineParameter  # | cgmes30.PerLengthDCLineParameter
CGMES_VS_CAPABILITY_CURVE = cgmes24.VsCapabilityCurve | cgmes30.VsCapabilityCurve
CGMES_VS_CONVERTER = cgmes24.VsConverter | cgmes30.VsConverter
CGMES_BUS_NAME_MARKER = cgmes24.BusNameMarker | cgmes30.BusNameMarker
CGMES_ANALOG_CONTROL = cgmes24.AnalogControl  # | cgmes30.AnalogControl
CGMES_CONTROL = cgmes24.Control  # | cgmes30.Control
CGMES_LIMIT = cgmes24.Limit  # | cgmes30.Limit
CGMES_LIMIT_SET = cgmes24.LimitSet  # | cgmes30.LimitSet
CGMES_MEASUREMENT = cgmes24.Measurement  # | cgmes30.Measurement
CGMES_MEASUREMENT_VALUE = cgmes24.MeasurementValue  # | cgmes30.MeasurementValue
CGMES_QUALITY61850 = cgmes24.Quality61850  # | cgmes30.Quality61850
CGMES_ENERGY_SCHEDULING_TYPE = cgmes24.EnergySchedulingType | cgmes30.EnergySchedulingType
CGMES_ENERGY_SOURCE = cgmes24.EnergySource | cgmes30.EnergySource
CGMES_FOSSIL_FUEL = cgmes24.FossilFuel | cgmes30.FossilFuel
CGMES_GENERATING_UNIT = cgmes24.GeneratingUnit | cgmes30.GeneratingUnit
CGMES_HYDRO_GENERATING_UNIT = cgmes24.HydroGeneratingUnit | cgmes30.HydroGeneratingUnit
CGMES_HYDRO_POWER_PLANT = cgmes24.HydroPowerPlant | cgmes30.HydroPowerPlant
CGMES_HYDROPUMP = cgmes24.HydroPump | cgmes30.HydroPump
CGMES_NUCLEAR_GENERATING_UNIT = cgmes24.NuclearGeneratingUnit | cgmes30.NuclearGeneratingUnit
CGMES_SOLAR_GENERATING_UNIT = cgmes24.SolarGeneratingUnit | cgmes30.SolarGeneratingUnit
CGMES_THERMAL_GENERATING_UNIT = cgmes24.ThermalGeneratingUnit | cgmes30.ThermalGeneratingUnit
CGMES_WIND_GENERATING_UNIT = cgmes24.WindGeneratingUnit | cgmes30.WindGeneratingUnit
CGMES_ACDC_TERMINAL = cgmes24.ACDCTerminal | cgmes30.ACDCTerminal
CGMES_BASE_VOLTAGE = cgmes24.BaseVoltage | cgmes30.BaseVoltage
CGMES_BASIC_INTERVAL_SCHEDULE = cgmes24.BasicIntervalSchedule | cgmes30.BasicIntervalSchedule
CGMES_BAY = cgmes24.Bay | cgmes30.Bay
CGMES_CONDUCTING_EQUIPMENT = cgmes24.ConductingEquipment | cgmes30.ConductingEquipment
CGMES_CONNECTIVITY_NODE = cgmes24.ConnectivityNode | cgmes30.ConnectivityNode
CGMES_CONNECTIVITY_NODE_CONTAINER = cgmes24.ConnectivityNodeContainer | cgmes30.ConnectivityNodeContainer
CGMES_CURVE = cgmes24.Curve | cgmes30.Curve
CGMES_CURVE_DATA = cgmes24.CurveData | cgmes30.CurveData
CGMES_EQUIPMENT = cgmes24.Equipment | cgmes30.Equipment
CGMES_EQUIPMENT_CONTAINER = cgmes24.EquipmentContainer | cgmes30.EquipmentContainer
CGMES_GEOGRAPHICAL_REGION = cgmes24.GeographicalRegion | cgmes30.GeographicalRegion
CGMES_IDENTIFIED_OBJECT = cgmes24.IdentifiedObject | cgmes30.IdentifiedObject
CGMES_POWER_SYSTEM_RESOURCE = cgmes24.PowerSystemResource | cgmes30.PowerSystemResource
CGMES_REGULAR_INTERVAL_SCHEDULE = cgmes24.RegularIntervalSchedule | cgmes30.RegularIntervalSchedule
CGMES_REPORTING_GROUP = cgmes24.ReportingGroup | cgmes30.ReportingGroup
CGMES_SUB_GEOGRAPHICAL_REGION = cgmes24.SubGeographicalRegion | cgmes30.SubGeographicalRegion
CGMES_SUBSTATION = cgmes24.Substation | cgmes30.Substation
CGMES_TERMINAL = cgmes24.Terminal | cgmes30.Terminal
CGMES_VOLTAGE_LEVEL = cgmes24.VoltageLevel | cgmes30.VoltageLevel
CGMES_ACTIVE_POWER_LIMIT = cgmes24.ActivePowerLimit | cgmes30.ActivePowerLimit
CGMES_APPARENT_POWER_LIMIT = cgmes24.ApparentPowerLimit | cgmes30.ApparentPowerLimit
CGMES_CURRENT_LIMIT = cgmes24.CurrentLimit | cgmes30.CurrentLimit
CGMES_OPERATIONAL_LIMIT = cgmes24.OperationalLimit | cgmes30.OperationalLimit
CGMES_OPERATIONAL_LIMIT_SET = cgmes24.OperationalLimitSet | cgmes30.OperationalLimitSet
CGMES_OPERATIONAL_LIMIT_TYPE = cgmes24.OperationalLimitType | cgmes30.OperationalLimitType
CGMES_VOLTAGE_LIMIT = cgmes24.VoltageLimit | cgmes30.VoltageLimit
CGMES_AC_LINE_SEGMENT = cgmes24.ACLineSegment | cgmes30.ACLineSegment
CGMES_ASYNCHRONOUS_MACHINE = cgmes24.AsynchronousMachine | cgmes30.AsynchronousMachine
CGMES_BREAKER = cgmes24.Breaker | cgmes30.Breaker
CGMES_BUSBAR_SECTION = cgmes24.BusbarSection | cgmes30.BusbarSection
CGMES_CONDUCTOR = cgmes24.Conductor | cgmes30.Conductor
CGMES_CONNECTOR = cgmes24.Connector | cgmes30.Connector
CGMES_DISCONNECTOR = cgmes24.Disconnector | cgmes30.Disconnector
CGMES_EARTH_FAULT_COMPENSATOR = cgmes24.EarthFaultCompensator | cgmes30.EarthFaultCompensator
CGMES_ENERGY_CONSUMER = cgmes24.EnergyConsumer | cgmes30.EnergyConsumer
CGMES_EXTERNAL_NETWORK_INJECTION = cgmes24.ExternalNetworkInjection | cgmes30.ExternalNetworkInjection
CGMES_GROUND = cgmes24.Ground | cgmes30.Ground
CGMES_GROUND_DISCONNECTOR = cgmes24.GroundDisconnector | cgmes30.GroundDisconnector
CGMES_GROUNDING_IMPEDANCE = cgmes24.GroundingImpedance | cgmes30.GroundingImpedance
CGMES_JUNCTION = cgmes24.Junction | cgmes30.Junction
CGMES_LINE = cgmes24.Line | cgmes30.Line
CGMES_LINEAR_SHUNT_COMPENSATOR = cgmes24.LinearShuntCompensator | cgmes30.LinearShuntCompensator
CGMES_LOAD_BREAK_SWITCH = cgmes24.LoadBreakSwitch | cgmes30.LoadBreakSwitch
CGMES_MUTUAL_COUPLING = cgmes24.MutualCoupling  # | cgmes30.MutualCoupling
CGMES_NON_LINEAR_SHUNT_COMPENSATOR = cgmes24.NonlinearShuntCompensator | cgmes30.NonlinearShuntCompensator
CGMES_NON_LINEAR_SHUNT_COMPENSATOR_POINT = cgmes24.NonlinearShuntCompensatorPoint | cgmes30.NonlinearShuntCompensatorPoint
CGMES_PETERSEN_COIL = cgmes24.PetersenCoil | cgmes30.PetersenCoil
CGMES_PHASE_TAP_CHANGER = cgmes24.PhaseTapChanger | cgmes30.PhaseTapChanger
CGMES_PHASE_TAP_CHANGER_ASYMMETRICAL = cgmes24.PhaseTapChangerAsymmetrical | cgmes30.PhaseTapChangerAsymmetrical
CGMES_PHASE_TAP_CHANGER_LINEAR = cgmes24.PhaseTapChangerLinear | cgmes30.PhaseTapChangerLinear
CGMES_PHASE_TAP_CHANGER_NONLINEAR = cgmes24.PhaseTapChangerNonLinear | cgmes30.PhaseTapChangerNonLinear
CGMES_PHASE_TAP_CHANGER_SYMMETRICAL = cgmes24.PhaseTapChangerSymmetrical | cgmes30.PhaseTapChangerSymmetrical
CGMES_PHASE_TAP_CHANGER_TABLE = cgmes24.PhaseTapChangerTable | cgmes30.PhaseTapChangerTable
CGMES_PHASE_TAP_CHANGER_TABLE_POINT = cgmes24.PhaseTapChangerTablePoint | cgmes30.PhaseTapChangerTablePoint
CGMES_PHASE_TAP_CHANGER_TABULAR = cgmes24.PhaseTapChangerTabular | cgmes30.PhaseTapChangerTabular
CGMES_POWER_TRANSFORMER = cgmes24.PowerTransformer | cgmes30.PowerTransformer
CGMES_POWER_TRANSFORMER_END = cgmes24.PowerTransformerEnd | cgmes30.PowerTransformerEnd
CGMES_PROTECTED_SWITCH = cgmes24.ProtectedSwitch | cgmes30.ProtectedSwitch
CGMES_RATIO_TAP_CHANGER = cgmes24.RatioTapChanger | cgmes30.RatioTapChanger
CGMES_RATIO_TAP_CHANGER_TABLE = cgmes24.RatioTapChangerTable | cgmes30.RatioTapChangerTable
CGMES_RATIO_TAP_CHANGER_TABLE_POINT = cgmes24.RatioTapChangerTablePoint | cgmes30.RatioTapChangerTablePoint
CGMES_REACTIVE_CAPABILITY_CURVE = cgmes24.ReactiveCapabilityCurve | cgmes30.ReactiveCapabilityCurve
CGMES_REGULATING_COND_EQ = cgmes24.RegulatingCondEq | cgmes30.RegulatingCondEq
CGMES_REGULATING_CONTROL = cgmes24.RegulatingControl | cgmes30.RegulatingControl
CGMES_ROTATING_MACHINE = cgmes24.RotatingMachine | cgmes30.RotatingMachine
CGMES_SERIES_COMPENSATOR = cgmes24.SeriesCompensator | cgmes30.SeriesCompensator
CGMES_SHUNT_COMPENSATOR = cgmes24.ShuntCompensator | cgmes30.ShuntCompensator
CGMES_STATIC_VAR_COMPENSATOR = cgmes24.StaticVarCompensator | cgmes30.StaticVarCompensator
CGMES_SWITCH = cgmes24.Switch | cgmes30.Switch
CGMES_SYNCHRONOUS_MACHINE = cgmes24.SynchronousMachine | cgmes30.SynchronousMachine
CGMES_TAP_CHANGER = cgmes24.TapChanger | cgmes30.TapChanger
CGMES_TAP_CHANGER_CONTROL = cgmes24.TapChangerControl | cgmes30.TapChangerControl
CGMES_TAP_CHANGER_TABLE_POINT = cgmes24.TapChangerTablePoint | cgmes30.TapChangerTablePoint
CGMES_TRANSFORMER_END = cgmes24.TransformerEnd | cgmes30.TransformerEnd
CGMES_CONFORM_LOAD = cgmes24.ConformLoad | cgmes30.ConformLoad
CGMES_CONFORM_LOAD_GROUP = cgmes24.ConformLoadGroup | cgmes30.ConformLoadGroup
CGMES_ENERGY_AREA = cgmes24.EnergyArea | cgmes30.EnergyArea
CGMES_LOAD_AREA = cgmes24.LoadArea | cgmes30.LoadArea
CGMES_LOAD_GROUP = cgmes24.LoadGroup | cgmes30.LoadGroup
CGMES_LOAD_RESPONSE_CHARACTERISTIC = cgmes24.LoadResponseCharacteristic | cgmes30.LoadResponseCharacteristic
CGMES_NON_CONFORM_LOAD = cgmes24.NonConformLoad | cgmes30.NonConformLoad
CGMES_NON_CONFORM_LOAD_GROUP = cgmes24.NonConformLoadGroup | cgmes30.NonConformLoadGroup
CGMES_SEASON_DAY_TYPE_SCHEDULE = cgmes24.SeasonDayTypeSchedule | cgmes30.SeasonDayTypeSchedule
CGMES_SUB_LOAD_AREA = cgmes24.SubLoadArea | cgmes30.SubLoadArea
CGMES_EQUIVALENT_BRANCH = cgmes24.EquivalentBranch | cgmes30.EquivalentBranch
CGMES_EQUIVALENT_EQUIPMENT = cgmes24.EquivalentEquipment | cgmes30.EquivalentEquipment
CGMES_EQUIVALENT_INJECTION = cgmes24.EquivalentInjection | cgmes30.EquivalentInjection
CGMES_EQUIVALENT_NETWORK = cgmes24.EquivalentNetwork | cgmes30.EquivalentNetwork
CGMES_EQUIVALENT_SHUNT = cgmes24.EquivalentShunt | cgmes30.EquivalentShunt
CGMES_CONTROL_AREA = cgmes24.ControlArea | cgmes30.ControlArea
CGMES_CONTROL_AREA_GENERATING_UNIT = cgmes24.ControlAreaGeneratingUnit | cgmes30.ControlAreaGeneratingUnit
CGMES_TIE_FLOW = cgmes24.TieFlow | cgmes30.TieFlow
CGMES_DC_TOPOLOGICAL_ISLAND = cgmes24.DCTopologicalIsland | cgmes30.DCTopologicalIsland
CGMES_SV_STATUS = cgmes24.SvStatus | cgmes30.SvStatus
CGMES_SV_INJECTION = cgmes24.SvInjection | cgmes30.SvInjection
CGMES_SV_POWER_FLOW = cgmes24.SvPowerFlow | cgmes30.SvPowerFlow
CGMES_SV_SHUNT_COMPENSATOR_SECTIONS = cgmes24.SvShuntCompensatorSections | cgmes30.SvShuntCompensatorSections
CGMES_SV_TAP_STEP = cgmes24.SvTapStep | cgmes30.SvTapStep
CGMES_SV_VOLTAGE = cgmes24.SvVoltage | cgmes30.SvVoltage
CGMES_DC_TOPOLOGICAL_NODE = cgmes24.DCTopologicalNode | cgmes30.DCTopologicalNode
CGMES_TOPOLOGICAL_NODE = cgmes24.TopologicalNode | cgmes30.TopologicalNode
CGMES_TOPOLOGICAL_ISLAND = cgmes24.TopologicalIsland | cgmes30.TopologicalIsland
CGMES_COORDINATE_SYSTEM = cgmes24.CoordinateSystem | cgmes30.CoordinateSystem
CGMES_LOCATION = cgmes24.Location | cgmes30.Location
CGMES_POSITION_POINT = cgmes24.PositionPoint | cgmes30.PositionPoint

def is_term(term: CGMES_TERMINAL):
    return isinstance(term, (cgmes24.Terminal, cgmes30.Terminal))