#include "stim/diagram/crumble_data.h"

std::string stim_draw_internal::make_crumble_html() {
    std::string result;
    result.append(R"CRUMBLE_PART(<!DOCTYPE html>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(<html lang="en">
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(<head>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(    <meta charset="UTF-8">
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(    <title>Crumble</title>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(    <link rel="shortcut icon" href="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAABgWlDQ1BJQ0MgcHJvZmlsZQAAKJF9kTlIA0EUhj+j4kHEwhQiFluolQFREUuNgggRQlTwKtzdnJBdw27ExlKwDVh4NF6FjbW2FraCIHiAWFpZKdpIWN8kgQQxDgzz8c/8j/f+Ad9RxrTchgGw7JwTnQppC4tLWtMrrfiAAC266WbHI5EwNdfXPXXqvAuqWrXf/bnaYnHXhDpNeMzMOjnhVeGRjVxW8Z7qwkzpMeFz4X5HGhR+VLpR4jfFySKrpgk4c9EJ4YCwlqxio4rNlGMJDwv3xCxb6vsWShxTvKnYyqyb5T7VhP64PT+rdNndTDHNDBE0DNZJkyFHUE5bFJeo3Idq+LuK/oi4DHGlMcUxyRoWetGP+oPf2bqJocFSJX8IGl8876MXmnagkPe872PPK5xA/TNc2RX/2hGMfoqer2g9h9C+BRfXFc3Yhctt6HzK6o5elOpl+xIJeD+Tb1qEjltoXS7lVr7n9AHmJKvwDewfQF9Saq/UmLu5Ord/35Tz+wHVp3JoxsjWZAAAAAlwSFlzAAAuIwAALiMBeKU/dgAAAAd0SU1FB+YKAhYQLxXIct8AAAAZdEVYdENvbW1lbnQAQ3JlYXRlZCB3aXRoIEdJTVBXgQ4XAAAAx0lEQVRYw+2XwQ7EIAhEB+N/E76cnkgIa6OuWTFxvTWxdRgKDwmAYu+i+KDKPP62CJjHNYsQ7Psk8iGk7AxdmeGC1e0CvBBbKQK8ljQB5kK2AxcLsJLMdoBKZvQAULMOtk5IR7Dg294+yw4RymUBs3qQ5bHAO34vC8yFPwvSBFhJ3skC35Bq1sHHsKDGKfUX94J46HllGDjd5XnI5WjOXwXQSg5X95eXaaU3zXSjG3XJ79LW1ak1RsX9/qdsldqsPTppo66k6QGRuElWZ7d4CQAAAABJRU)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(5ErkJggg==">
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(</head>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(<body style="margin: 0">
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(    <div style="display: inline-block">
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(        <div>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(            <div style="display: inline-block">
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(                Crumble is a prototype stabilizer circuit editor.<br>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(                <a href="https://github.com/quantumlib/Stim/blob/main/glue/crumble/README.md">Read the manual</a><br>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(                <br>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(                <a href="#circuit=Q(0.5,2.5)0;Q(1,1)1;Q(1,2)2;Q(1,3)3;Q(1.5,0.5)4;Q(1.5,1.5)5;Q(1.5,2.5)6;Q(2,1)7;Q(2,2)8;Q(2,3)9;Q(2.5,1.5)10;Q(2.5,2.5)11;Q(2.5,3.5)12;Q(3,1)13;Q(3,2)14;Q(3,3)15;Q(3.5,1.5)16;POLYGON(0,0,1,0.5)2_8_9_3;POLYGON(0,0,1,0.5)7_13_14_8;POLYGON(0,0,1,0.5)15_9;POLYGON(0,0,1,0.5)7_1;POLYGON(1,0,0,0.5)1_7_8_2;POLYGON(1,0,0,0.5)8_14_15_9;POLYGON(1,0,0,0.5)13_14;POLYGON(1,0,0,0.5)2_3;TICK;R_10_6_12_4_1_2_3_7_8_9_13_14_15;RX_5_11_16_0;MARKX(0)5;MARKZ(1)15_9_12;TICK;CX_5_1_7_10_2_6_11_8_16_13_9_12;TICK;CX_5_7_8_10_11_14_1_4_3_6_0_2;TICK;CX_11_9_8_6_5_2_13_10_16_14_15_12;TICK;CX_5_8_14_10_0_3_9_6_7_4_11_15;TICK;M_10_6_12_4;MX_5_11_0_16;MARKX(0)5;MARKZ(1)12;TICK;R_10_6_12_4;RX_5_11_16_0;MARKX(0)5;TICK;CX_5_1_7_10_2_6_11_8_16_13_9_12;TICK;CX_5_7_8_10_11_14_1_4_3_6_0_2;TICK;CX_11_9_8_6_5_2_13_10_16_14_15_12;TICK;CX_5_8_14_10_0_3_9_6_7_4_11_15;TICK;M_10_6_12_4_1_2_3_7_8_9_13_14_15;MX_5_11_0_16;MARKX(0)5">Load example: surface code (d=3,r=2)</a><br>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(                <a href="#circuit=Q(1,1)0;Q(1,2)1;Q(1,3)2;Q(1,4)3;Q(1,5)4;Q(1,6)5;Q(1,7)6;Q(2,1)7;Q(2,2)8;Q(2,3)9;Q(2,4)10;Q(2,5)11;Q(2,6)12;Q(2,7)13;Q(3,1)14;Q(3,2)15;Q(3,3)16;Q(3,4)17;Q(3,5)18;Q(3,6)19;Q(3,7)20;Q(4,1)21;Q(4,2)22;Q(4,3)23;Q(4,4)24;Q(4,5)25;Q(4,6)26;Q(4,7)27;Q(5,1)28;Q(5,2)29;Q(5,3)30;Q(5,4)31;Q(5,5)32;Q(5,6)33;Q(5,7)34;Q(6,1)35;Q(6,2)36;Q(6,3)37;Q(6,4)38;Q(6,5)39;Q(6,6)40;Q(6,7)41;Q(7,1)42;Q(7,2)43;Q(7,3)44;Q(7,4)45;Q(7,5)46;Q(7,6)47;Q(7,7)48;POLYGON(0,0,1,0.5)0_7_14_21_28_35_42_43_36_29_22_15_8_1;POLYGON(1,0,0,0.5)0_7_13_6;TICK;R_0_1_2_3_4_5_6_7_8_9_10_11_12_13_14_15_16_17_18_19_20_21_22_23_24_25_26_27_28_29_30_31_32_33_34_35_36_37_38_39_40_41_42_43_44_45_46_47_48;MARKZ(0)6_13_20_27_34_41_48;TICK;MZZ_0_1_7_8_14_15_21_22_28_29_35_36_2_3_9_10_16_17_23_24_30_31_37_38_4_5_11_12_18_19_25_26_32_33_39_40_42_43_44_45_46_47;TICK;MXX_0_7_1_8_2_9_3_10_4_11_5_12_6_13_14_21_15_22_16_23_17_24_18_25_19_26_20_27_28_35_29_36_30_37_31_38_32_39_33_40_34_41;MARKX(1)14_15_16_17_18_19_20_21_22_23_24_25_26_27;TIC)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(K;MZZ_1_2_8_9_15_16_22_23_29_30_36_37_3_4_10_11_17_18_24_25_31_32_38_39_5_6_12_13_19_20_26_27_33_34_40_41_43_44_45_46_47_48;TICK;MXX_7_14_8_15_9_16_10_17_11_18_12_19_13_20_21_28_22_29_23_30_24_31_25_32_26_33_27_34_35_42_36_43_37_44_38_45_39_46_40_47_41_48;TICK;MZZ_0_1_7_8_14_15_21_22_28_29_35_36_2_3_9_10_16_17_23_24_30_31_37_38_4_5_11_12_18_19_25_26_32_33_39_40_42_43_44_45_46_47;TICK;MXX_0_7_1_8_2_9_3_10_4_11_5_12_6_13_14_21_15_22_16_23_17_24_18_25_19_26_20_27_28_35_29_36_30_37_31_38_32_39_33_40_34_41;MARKX(1)14_15_16_17_18_19_20_21_22_23_24_25_26_27;TICK;MZZ_1_2_8_9_15_16_22_23_29_30_36_37_3_4_10_11_17_18_24_25_31_32_38_39_5_6_12_13_19_20_26_27_33_34_40_41_43_44_45_46_47_48;TICK;MXX_7_14_8_15_9_16_10_17_11_18_12_19_13_20_21_28_22_29_23_30_24_31_25_32_26_33_27_34_35_42_36_43_37_44_38_45_39_46_40_47_41_48;TICK;M_0_1_2_3_4_5_6_7_8_9_10_11_12_13_14_15_16_17_18_19_20_21_22_23_24_25_26_27_28_29_30_31_32_33_34_35_36_37_38_39_40_41_42_43_44_45_46_47_48;MARKZ(0)6_13_20_27_34_41_48">Load example: bacon shor code (d=7,)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(r=2)</a><br>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(                <a href="#circuit=Q(0,0)0;Q(0,1)1;Q(0,2)2;Q(0,3)3;Q(0,4)4;Q(0,5)5;Q(0,6)6;Q(0.5,0.5)7;Q(0.5,1.5)8;Q(0.5,2.5)9;Q(0.5,3.5)10;Q(0.5,4.5)11;Q(0.5,5.5)12;Q(0.5,6.5)13;Q(1,0)14;Q(1,1)15;Q(1,2)16;Q(1,3)17;Q(1,4)18;Q(1,5)19;Q(1,6)20;Q(1.5,0.5)21;Q(1.5,1.5)22;Q(1.5,2.5)23;Q(1.5,3.5)24;Q(1.5,4.5)25;Q(1.5,5.5)26;Q(1.5,6.5)27;Q(2,0)28;Q(2,1)29;Q(2,2)30;Q(2,3)31;Q(2,4)32;Q(2,5)33;Q(2,6)34;Q(2.5,0.5)35;Q(2.5,1.5)36;Q(2.5,2.5)37;Q(2.5,3.5)38;Q(2.5,4.5)39;Q(2.5,5.5)40;Q(2.5,6.5)41;Q(3,0)42;Q(3,1)43;Q(3,2)44;Q(3,3)45;Q(3,4)46;Q(3,5)47;Q(3,6)48;Q(3.5,0.5)49;Q(3.5,1.5)50;Q(3.5,2.5)51;Q(3.5,3.5)52;Q(3.5,4.5)53;Q(3.5,5.5)54;Q(3.5,6.5)55;Q(4,0)56;Q(4,1)57;Q(4,2)58;Q(4,3)59;Q(4,4)60;Q(4,5)61;Q(4,6)62;Q(4.5,0.5)63;Q(4.5,1.5)64;Q(4.5,2.5)65;Q(4.5,3.5)66;Q(4.5,4.5)67;Q(4.5,5.5)68;Q(4.5,6.5)69;Q(5,0)70;Q(5,1)71;Q(5,2)72;Q(5,3)73;Q(5,4)74;Q(5,5)75;Q(5,6)76;Q(5.5,0.5)77;Q(5.5,1.5)78;Q(5.5,2.5)79;Q(5.5,3.5)80;Q(5.5,4.5)81;Q(5.5,5.5)82;Q(5.5,6.5)83;Q(6,0)84;Q(6,1)85;Q(6,2)86;Q(6,3)87;Q(6,4)88;Q(6,5)89;Q(6,6)90;Q(6.5,0.5)91;)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(Q(6.5,1.5)92;Q(6.5,2.5)93;Q(6.5,3.5)94;Q(6.5,4.5)95;Q(6.5,5.5)96;POLYGON(0,0,1,0.5)59_66_60_52;POLYGON(0,0,1,0.5)58_65_59_51;POLYGON(0,0,1,0.5)45_52_46_38;POLYGON(0,0,1,0.5)44_51_45_37;POLYGON(0,0,1,0.5)31_38_32_24;POLYGON(0,0,1,0.5)30_37_31_23;POLYGON(0,0,1,0.5)15_22_16_8;POLYGON(0,0,1,0.5)14_21_15_7;POLYGON(0,0,1,0.5)29_36_30_22;POLYGON(0,0,1,0.5)43_50_44_36;POLYGON(0,0,1,0.5)57_64_58_50;POLYGON(0,0,1,0.5)71_78_72_64;POLYGON(0,0,1,0.5)72_79_73_65;POLYGON(0,0,1,0.5)73_80_74_66;POLYGON(0,0,1,0.5)74_81_75_67;POLYGON(0,0,1,0.5)75_82_76_68;POLYGON(0,0,1,0.5)32_39_33_25;POLYGON(0,0,1,0.5)33_40_34_26;POLYGON(0,0,1,0.5)46_53_47_39;POLYGON(0,0,1,0.5)60_67_61_53;POLYGON(0,0,1,0.5)61_68_62_54;POLYGON(0,0,1,0.5)47_54_48_40;POLYGON(0,0,1,0.5)1_8_2;POLYGON(0,0,1,0.5)16_23_17_9;POLYGON(0,0,1,0.5)2_9_3;POLYGON(0,0,1,0.5)17_24_18_10;POLYGON(0,0,1,0.5)3_10_4;POLYGON(0,0,1,0.5)18_25_19_11;POLYGON(0,0,1,0.5)4_11_5;POLYGON(0,0,1,0.5)19_26_20_12;POLYGON(0,0,1,0.5)5_12_6;POLYGON(0,0,1,0.5)0_7_1;POLYGON(0,0,1,0.5)28_35_29_21;POLYG)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(ON(0,0,1,0.5)42_49_43_35;POLYGON(0,0,1,0.5)56_63_57_49;POLYGON(0,0,1,0.5)70_77_71_63;POLYGON(0,0,1,0.5)84_91_85_77;POLYGON(0,0,1,0.5)91;POLYGON(0,0,1,0.5)85_92_86_78;POLYGON(0,0,1,0.5)92;POLYGON(0,0,1,0.5)86_93_87_79;POLYGON(0,0,1,0.5)93;POLYGON(0,0,1,0.5)87_94_88_80;POLYGON(0,0,1,0.5)94;POLYGON(0,0,1,0.5)88_95_89_81;POLYGON(0,0,1,0.5)95;POLYGON(0,0,1,0.5)89_96_90_82;POLYGON(0,0,1,0.5)96;POLYGON(1,0,0,0.5)36_44_37_30;POLYGON(1,0,0,0.5)50_58_51_44;POLYGON(1,0,0,0.5)38_46_39_32;POLYGON(1,0,0,0.5)52_60_53_46;POLYGON(1,0,0,0.5)51_59_52_45;POLYGON(1,0,0,0.5)37_45_38_31;POLYGON(1,0,0,0.5)23_31_24_17;POLYGON(1,0,0,0.5)22_30_23_16;POLYGON(1,0,0,0.5)7_15_8_1;POLYGON(1,0,0,0.5)21_29_22_15;POLYGON(1,0,0,0.5)64_72_65_58;POLYGON(1,0,0,0.5)78_86_79_72;POLYGON(1,0,0,0.5)65_73_66_59;POLYGON(1,0,0,0.5)79_87_80_73;POLYGON(1,0,0,0.5)66_74_67_60;POLYGON(1,0,0,0.5)80_88_81_74;POLYGON(1,0,0,0.5)81_89_82_75;POLYGON(1,0,0,0.5)82_90_83_76;POLYGON(1,0,0,0.5)25_33_26_19;POLYGON(1,0,0,0.5)39_47_40_33;POLYGON(1,0,0,0.5)67_75_68_61;POLYGO)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(N(1,0,0,0.5)53_61_54_47;POLYGON(1,0,0,0.5)24_32_25_18;POLYGON(1,0,0,0.5)8_16_9_2;POLYGON(1,0,0,0.5)9_17_10_3;POLYGON(1,0,0,0.5)10_18_11_4;POLYGON(1,0,0,0.5)11_19_12_5;POLYGON(1,0,0,0.5)0_14_7;POLYGON(1,0,0,0.5)14_28_21;POLYGON(1,0,0,0.5)35_43_36_29;POLYGON(1,0,0,0.5)28_42_35;POLYGON(1,0,0,0.5)49_57_50_43;POLYGON(1,0,0,0.5)42_56_49;POLYGON(1,0,0,0.5)63_71_64_57;POLYGON(1,0,0,0.5)56_70_63;POLYGON(1,0,0,0.5)77_85_78_71;POLYGON(1,0,0,0.5)70_84_77;POLYGON(1,0,0,0.5)83;POLYGON(1,0,0,0.5)68_76_69_62;POLYGON(1,0,0,0.5)69;POLYGON(1,0,0,0.5)54_62_55_48;POLYGON(1,0,0,0.5)55;POLYGON(1,0,0,0.5)40_48_41_34;POLYGON(1,0,0,0.5)41;POLYGON(1,0,0,0.5)26_34_27_20;POLYGON(1,0,0,0.5)27;POLYGON(1,0,0,0.5)12_20_13_6;POLYGON(1,0,0,0.5)13;TICK;R_8_10_12_21_23_25_36_38_40_49_51_53_64_66_68_77_79_81_91_92_93_94_95_96_0_1_2_3_4_5_6_14_15_16_17_18_19_20_28_29_30_31_32_33_34_42_43_44_45_46_47_48_56_57_58_59_60_61_62_70_71_72_73_74_75_76_84_85_86_87_88_89_90;RX_7_9_11_13_22_24_26_27_35_37_39_41_50_52_54_55_63_65_67_69_78_80_82_83;MARKX(0)37;)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(MARKZ(1)40;MARKZ(2)59_60_66_73_74;MARKZ(3)0_14_28_42_56_70_84;TICK;CX_1_8_3_10_5_12_7_0_9_2_11_4_13_6_14_21_16_23_18_25_22_15_24_17_26_19_29_36_31_38_33_40_35_28_37_30_39_32_41_34_42_49_44_51_46_53_50_43_52_45_54_47_57_64_59_66_61_68_63_56_65_58_67_60_69_62_70_77_72_79_74_81_78_71_80_73_82_75_85_92_87_94_89_96;TICK;CX_2_8_4_10_6_12_7_14_9_16_11_18_13_20_15_21_17_23_19_25_22_29_24_31_26_33_30_36_32_38_34_40_35_42_37_44_39_46_41_48_43_49_45_51_47_53_50_57_52_59_54_61_58_64_60_66_62_68_63_70_65_72_67_74_69_76_71_77_73_79_75_81_78_85_80_87_82_89_86_92_88_94_90_96;TICK;CX_1_7_3_9_5_11_8_15_10_17_12_19_16_22_18_24_20_26_21_28_23_30_25_32_27_34_29_35_31_37_33_39_36_43_38_45_40_47_44_50_46_52_48_54_49_56_51_58_53_60_55_62_57_63_59_65_61_67_64_71_66_73_68_75_72_78_74_80_76_82_77_84_79_86_81_88_83_90_85_91_87_93_89_95;TICK;CX_0_7_2_9_4_11_8_1_10_3_12_5_15_22_17_24_19_26_21_14_23_16_25_18_27_20_28_35_30_37_32_39_36_29_38_31_40_33_43_50_45_52_47_54_49_42_51_44_53_46_55_48_56_63_58_65_60_67_64_57_66_59_68_61_71_78_73_80_7)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(5_82_77_70_79_72_81_74_83_76_84_91_86_93_88_95;TICK;M_7_9_11_22_24_26_35_37_39_50_52_54_63_65_67_78_80_82_91_92_93_94_95_96;MX_8_10_12_13_21_23_25_27_36_38_40_41_49_51_53_55_64_66_68_69_77_79_81_83;MARKX(0)36;MARKZ(1)26;MARKZ(2)80;TICK;R_7_9_11_22_24_26_35_37_39_50_52_54_63_65_67_78_80_82_91_92_93_94_95_96;RX_8_10_12_13_21_23_25_27_36_38_40_41_49_51_53_55_64_66_68_69_77_79_81_83;MARKX(0)36;MARKZ(1)26;TICK;CX_0_7_2_9_4_11_8_1_10_3_12_5_15_22_17_24_19_26_21_14_23_16_25_18_27_20_28_35_30_37_32_39_36_29_38_31_40_33_43_50_45_52_47_54_49_42_51_44_53_46_55_48_56_63_58_65_60_67_64_57_66_59_68_61_71_78_73_80_75_82_77_70_79_72_81_74_83_76_84_91_86_93_88_95;TICK;CX_1_7_3_9_5_11_8_15_10_17_12_19_16_22_18_24_20_26_21_28_23_30_25_32_27_34_29_35_31_37_33_39_36_43_38_45_40_47_44_50_46_52_48_54_49_56_51_58_53_60_55_62_57_63_59_65_61_67_64_71_66_73_68_75_72_78_74_80_76_82_77_84_79_86_81_88_83_90_85_91_87_93_89_95;TICK;CX_2_8_4_10_6_12_7_14_9_16_11_18_13_20_15_21_17_23_19_25_22_29_24_31_26_33_30_36_32_38_34_40_35_42_37_44_39_46)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(_41_48_43_49_45_51_47_53_50_57_52_59_54_61_58_64_60_66_62_68_63_70_65_72_67_74_69_76_71_77_73_79_75_81_78_85_80_87_82_89_86_92_88_94_90_96;TICK;CX_1_8_3_10_5_12_7_0_9_2_11_4_13_6_14_21_16_23_18_25_22_15_24_17_26_19_29_36_31_38_33_40_35_28_37_30_39_32_41_34_42_49_44_51_46_53_50_43_52_45_54_47_57_64_59_66_61_68_63_56_65_58_67_60_69_62_70_77_72_79_74_81_78_71_80_73_82_75_85_92_87_94_89_96;TICK;M_8_10_12_21_23_25_36_38_40_49_51_53_64_66_68_77_79_81_91_92_93_94_95_96;MX_7_9_11_13_22_24_26_27_35_37_39_41_50_52_54_55_63_65_67_69_78_80_82_83;MARKX(0)37;MARKZ(1)40;TICK;R_8_10_12_21_23_25_36_38_40_49_51_53_64_66_68_77_79_81_91_92_93_94_95_96;RX_7_9_11_13_22_24_26_27_35_37_39_41_50_52_54_55_63_65_67_69_78_80_82_83;TICK;CX_1_8_3_10_5_12_7_0_9_2_11_4_13_6_14_21_16_23_18_25_22_15_24_17_26_19_29_36_31_38_33_40_35_28_37_30_39_32_41_34_42_49_44_51_46_53_50_43_52_45_54_47_57_64_59_66_61_68_63_56_65_58_67_60_69_62_70_77_72_79_74_81_78_71_80_73_82_75_85_92_87_94_89_96;TICK;CX_2_8_4_10_6_12_7_14_9_16_11_18_13_20_15_21_17_23_19_25)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(_22_29_24_31_26_33_30_36_32_38_34_40_35_42_37_44_39_46_41_48_43_49_45_51_47_53_50_57_52_59_54_61_58_64_60_66_62_68_63_70_65_72_67_74_69_76_71_77_73_79_75_81_78_85_80_87_82_89_86_92_88_94_90_96;TICK;CX_1_7_3_9_5_11_8_15_10_17_12_19_16_22_18_24_20_26_21_28_23_30_25_32_27_34_29_35_31_37_33_39_36_43_38_45_40_47_44_50_46_52_48_54_49_56_51_58_53_60_55_62_57_63_59_65_61_67_64_71_66_73_68_75_72_78_74_80_76_82_77_84_79_86_81_88_83_90_85_91_87_93_89_95;TICK;CX_0_7_2_9_4_11_8_1_10_3_12_5_15_22_17_24_19_26_21_14_23_16_25_18_27_20_28_35_30_37_32_39_36_29_38_31_40_33_43_50_45_52_47_54_49_42_51_44_53_46_55_48_56_63_58_65_60_67_64_57_66_59_68_61_71_78_73_80_75_82_77_70_79_72_81_74_83_76_84_91_86_93_88_95;TICK;M_7_9_11_22_24_26_35_37_39_50_52_54_63_65_67_78_80_82_91_92_93_94_95_96;MX_8_10_12_13_21_23_25_27_36_38_40_41_49_51_53_55_64_66_68_69_77_79_81_83;TICK;R_7_9_11_22_24_26_35_37_39_50_52_54_63_65_67_78_80_82_91_92_93_94_95_96;RX_8_10_12_13_21_23_25_27_36_38_40_41_49_51_53_55_64_66_68_69_77_79_81_83;TICK;CX_0_7_2_9_4_11_8_1)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(_10_3_12_5_15_22_17_24_19_26_21_14_23_16_25_18_27_20_28_35_30_37_32_39_36_29_38_31_40_33_43_50_45_52_47_54_49_42_51_44_53_46_55_48_56_63_58_65_60_67_64_57_66_59_68_61_71_78_73_80_75_82_77_70_79_72_81_74_83_76_84_91_86_93_88_95;TICK;CX_1_7_3_9_5_11_8_15_10_17_12_19_16_22_18_24_20_26_21_28_23_30_25_32_27_34_29_35_31_37_33_39_36_43_38_45_40_47_44_50_46_52_48_54_49_56_51_58_53_60_55_62_57_63_59_65_61_67_64_71_66_73_68_75_72_78_74_80_76_82_77_84_79_86_81_88_83_90_85_91_87_93_89_95;TICK;CX_2_8_4_10_6_12_7_14_9_16_11_18_13_20_15_21_17_23_19_25_22_29_24_31_26_33_30_36_32_38_34_40_35_42_37_44_39_46_41_48_43_49_45_51_47_53_50_57_52_59_54_61_58_64_60_66_62_68_63_70_65_72_67_74_69_76_71_77_73_79_75_81_78_85_80_87_82_89_86_92_88_94_90_96;TICK;CX_1_8_3_10_5_12_7_0_9_2_11_4_13_6_14_21_16_23_18_25_22_15_24_17_26_19_29_36_31_38_33_40_35_28_37_30_39_32_41_34_42_49_44_51_46_53_50_43_52_45_54_47_57_64_59_66_61_68_63_56_65_58_67_60_69_62_70_77_72_79_74_81_78_71_80_73_82_75_85_92_87_94_89_96;TICK;M_8_10_12_21_23_25_36_38_40_49_51_)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(53_64_66_68_77_79_81_91_92_93_94_95_96_0_1_2_3_4_5_6_14_15_16_17_18_19_20_28_29_30_31_32_33_34_42_43_44_45_46_47_48_56_57_58_59_60_61_62_70_71_72_73_74_75_76_84_85_86_87_88_89_90;MX_7_9_11_13_22_24_26_27_35_37_39_41_50_52_54_55_63_65_67_69_78_80_82_83;MARKZ(3)0_14_28_42_56_70_84">Load example: three coupler surface code (d=7,r=4)</a><br>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(                <a href="#circuit=Q(0,2)0;Q(0,4)1;Q(0,6)2;Q(0.5,0.5)3;Q(0.5,1.5)4;Q(0.5,2.5)5;Q(0.5,3.5)6;Q(0.5,4.5)7;Q(0.5,5.5)8;Q(0.5,6.5)9;Q(1,0)10;Q(1,1)11;Q(1,2)12;Q(1,3)13;Q(1,4)14;Q(1,5)15;Q(1,6)16;Q(1.5,0.5)17;Q(1.5,1.5)18;Q(1.5,2.5)19;Q(1.5,3.5)20;Q(1.5,4.5)21;Q(1.5,5.5)22;Q(1.5,6.5)23;Q(2,0)24;Q(2,1)25;Q(2,2)26;Q(2,3)27;Q(2,4)28;Q(2,5)29;Q(2,6)30;Q(2,7)31;Q(2.5,0.5)32;Q(2.5,1.5)33;Q(2.5,2.5)34;Q(2.5,3.5)35;Q(2.5,4.5)36;Q(2.5,5.5)37;Q(2.5,6.5)38;Q(3,0)39;Q(3,1)40;Q(3,2)41;Q(3,3)42;Q(3,4)43;Q(3,5)44;Q(3,6)45;Q(3.5,0.5)46;Q(3.5,1.5)47;Q(3.5,2.5)48;Q(3.5,3.5)49;Q(3.5,4.5)50;Q(3.5,5.5)51;Q(3.5,6.5)52;Q(4,0)53;Q(4,1)54;Q(4,2)55;Q(4,3)56;Q(4,4)57;Q(4,5)58;Q(4,6)59;Q(4,7)60;Q(4.5,0.5)61;Q(4.5,1.5)62;Q(4.5,2.5)63;Q(4.5,3.5)64;Q(4.5,4.5)65;Q(4.5,5.5)66;Q(4.5,6.5)67;Q(5,0)68;Q(5,1)69;Q(5,2)70;Q(5,3)71;Q(5,4)72;Q(5,5)73;Q(5,6)74;Q(5.5,0.5)75;Q(5.5,1.5)76;Q(5.5,2.5)77;Q(5.5,3.5)78;Q(5.5,4.5)79;Q(5.5,5.5)80;Q(5.5,6.5)81;Q(6,0)82;Q(6,1)83;Q(6,2)84;Q(6,3)85;Q(6,4)86;Q(6,5)87;Q(6,6)88;Q(6,7)89;Q(6.5,0.5)90;Q(6.5,1.5)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART()91;Q(6.5,2.5)92;Q(6.5,3.5)93;Q(6.5,4.5)94;Q(6.5,5.5)95;Q(6.5,6.5)96;Q(7,1)97;Q(7,2)98;Q(7,3)99;Q(7,4)100;Q(7,5)101;Q(7,6)102;POLYGON(0,0,1,0.5)3_17_18_4;POLYGON(0,0,1,0.5)5_19_20_6;POLYGON(0,0,1,0.5)7_21_22_8;POLYGON(0,0,1,0.5)18_33_34_19;POLYGON(0,0,1,0.5)20_35_36_21;POLYGON(0,0,1,0.5)22_37_38_23;POLYGON(0,0,1,0.5)32_46_47_33;POLYGON(0,0,1,0.5)34_48_49_35;POLYGON(0,0,1,0.5)36_50_51_37;POLYGON(0,0,1,0.5)47_62_63_48;POLYGON(0,0,1,0.5)49_64_65_50;POLYGON(0,0,1,0.5)51_66_67_52;POLYGON(0,0,1,0.5)61_75_76_62;POLYGON(0,0,1,0.5)63_77_78_64;POLYGON(0,0,1,0.5)65_79_80_66;POLYGON(0,0,1,0.5)76_91_92_77;POLYGON(0,0,1,0.5)78_93_94_79;POLYGON(0,0,1,0.5)80_95_96_81;POLYGON(0,0,1,0.75)4_5;POLYGON(0,0,1,0.75)6_7;POLYGON(0,0,1,0.75)8_9;POLYGON(0,0,1,0.75)90_91;POLYGON(0,0,1,0.75)92_93;POLYGON(0,0,1,0.75)94_95;POLYGON(1,0,0,0.5)4_18_19_5;POLYGON(1,0,0,0.5)6_20_21_7;POLYGON(1,0,0,0.5)8_22_23_9;POLYGON(1,0,0,0.5)17_32_33_18;POLYGON(1,0,0,0.5)19_34_35_20;POLYGON(1,0,0,0.5)21_36_37_22;POLYGON(1,0,0,0.5)33_47_48_34;POLYGON(1,0,0,0.)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(5)35_49_50_36;POLYGON(1,0,0,0.5)37_51_52_38;POLYGON(1,0,0,0.5)46_61_62_47;POLYGON(1,0,0,0.5)48_63_64_49;POLYGON(1,0,0,0.5)50_65_66_51;POLYGON(1,0,0,0.5)62_76_77_63;POLYGON(1,0,0,0.5)64_78_79_65;POLYGON(1,0,0,0.5)66_80_81_67;POLYGON(1,0,0,0.5)75_90_91_76;POLYGON(1,0,0,0.5)77_92_93_78;POLYGON(1,0,0,0.5)79_94_95_80;POLYGON(1,0,0,0.75)17_3;POLYGON(1,0,0,0.75)38_23;POLYGON(1,0,0,0.75)46_32;POLYGON(1,0,0,0.75)67_52;POLYGON(1,0,0,0.75)75_61;POLYGON(1,0,0,0.75)96_81;TICK;R_0_1_2_11_13_15_26_28_30_40_42_44_55_57_59_69_71_73_84_86_88_97_98_99_100_101_102;RX_10_12_14_16_24_25_27_29_31_39_41_43_45_53_54_56_58_60_68_70_72_74_82_83_85_87_89;MARKX(0)41;MARKX(1)70;MARKX(3)64_65_72_78_79;MARKZ(0)42;MARKZ(2)65_66_79_80_73;TICK;CX_10_3_12_5_14_7_16_9_25_18_27_20_29_22_39_32_41_34_43_36_45_38_54_47_56_49_58_51_68_61_70_63_72_65_74_67_83_76_85_78_87_80_4_11_6_13_8_15_19_26_21_28_23_30_33_40_35_42_37_44_48_55_50_57_52_59_62_69_64_71_66_73_77_84_79_86_81_88_91_97_93_99_95_101;TICK;CX_10_17_12_19_14_21_16_23_25_33_27_35_29_37_39_46_)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(41_48_43_50_45_52_54_62_56_64_58_66_68_75_70_77_72_79_74_81_83_91_85_93_87_95_3_11_5_13_7_15_18_26_20_28_22_30_32_40_34_42_36_44_47_55_49_57_51_59_61_69_63_71_65_73_76_84_78_86_80_88_90_97_92_99_94_101;TICK;CX_17_25_33_41_46_54_48_56_62_70_64_72_75_83_77_85_79_87_91_98_93_100_95_102_24_32_40_47_53_61_55_63_69_76_71_78_82_90_84_92_86_94_12_4_14_6_16_8_27_19_29_21_31_23_43_35_45_37_58_50_60_52_74_66_89_81_5_0_7_1_9_2_20_13_22_15_36_28_38_30_51_44_67_59;XCY_11_18_26_34_42_49_57_65_73_80_88_96;TICK;CX_32_39_47_54_61_68_63_70_76_83_78_85_92_98_94_100_24_17_40_33_53_46_55_48_69_62_71_64_82_75_84_77_86_79_97_91_99_93_101_95_12_18_14_20_16_22_27_34_29_36_31_38_43_49_45_51_58_65_60_67_74_80_89_96_4_0_6_1_8_2_19_13_21_15_35_28_37_30_50_44_66_59;TICK;XCY_18_25_34_41_49_56_65_72_80_87_96_102;TICK;H_17_32_33_46_47_48_61_62_63_64_75_76_77_78_79_90_91_92_93_94_95_10_24_25_39_40_41_53_54_55_56_68_69_70_71_72_82_83_84_85_86_87_97_98_99_100_101_102;SQRT_X_11_26_42_57_73_88;TICK;M_0_1_2_10_11_13_15_24_26_28_30_39_40_42_44_53_55)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(_57_59_68_69_71_73_82_84_86_88;MX_12_14_16_25_27_29_31_41_43_45_54_56_58_60_70_72_74_83_85_87_89_97_98_99_100_101_102;MY_3;MARKX(0)41_56;MARKX(2)87;MARKZ(0)42;MARKZ(1)71;MARKZ(2)73;MARKZ(3)71;TICK;POLYGON(0,0,1,0.5)17_18_4;POLYGON(0,0,1,0.5)5_19_20_6;POLYGON(0,0,1,0.5)7_21_22_8;POLYGON(0,0,1,0.5)18_33_34_19;POLYGON(0,0,1,0.5)20_35_36_21;POLYGON(0,0,1,0.5)22_37_38_23;POLYGON(0,0,1,0.5)32_46_47_33;POLYGON(0,0,1,0.5)34_48_49_35;POLYGON(0,0,1,0.5)36_50_51_37;POLYGON(0,0,1,0.5)47_62_63_48;POLYGON(0,0,1,0.5)49_64_65_50;POLYGON(0,0,1,0.5)51_66_67_52;POLYGON(0,0,1,0.5)61_75_76_62;POLYGON(0,0,1,0.5)63_77_78_64;POLYGON(0,0,1,0.5)65_79_80_66;POLYGON(0,0,1,0.5)76_91_92_77;POLYGON(0,0,1,0.5)78_93_94_79;POLYGON(0,0,1,0.5)80_95_96_81;POLYGON(0,0,1,0.75)4_5;POLYGON(0,0,1,0.75)6_7;POLYGON(0,0,1,0.75)8_9;POLYGON(0,0,1,0.75)32_17;POLYGON(0,0,1,0.75)61_46;POLYGON(0,0,1,0.75)90_75;POLYGON(1,0,0,0.5)4_18_19_5;POLYGON(1,0,0,0.5)6_20_21_7;POLYGON(1,0,0,0.5)8_22_23_9;POLYGON(1,0,0,0.5)17_32_33_18;POLYGON(1,0,0,0.5)19_34_35_20;POLYGON)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART((1,0,0,0.5)21_36_37_22;POLYGON(1,0,0,0.5)33_47_48_34;POLYGON(1,0,0,0.5)35_49_50_36;POLYGON(1,0,0,0.5)37_51_52_38;POLYGON(1,0,0,0.5)46_61_62_47;POLYGON(1,0,0,0.5)48_63_64_49;POLYGON(1,0,0,0.5)50_65_66_51;POLYGON(1,0,0,0.5)62_76_77_63;POLYGON(1,0,0,0.5)64_78_79_65;POLYGON(1,0,0,0.5)66_80_81_67;POLYGON(1,0,0,0.5)75_90_91_76;POLYGON(1,0,0,0.5)77_92_93_78;POLYGON(1,0,0,0.5)79_94_95_80;POLYGON(1,0,0,0.75)38_23;POLYGON(1,0,0,0.75)67_52;POLYGON(1,0,0,0.75)96_81;POLYGON(1,0,0,0.75)91_92;POLYGON(1,0,0,0.75)93_94;POLYGON(1,0,0,0.75)95_96">Load example: surface code Y basis transition round (d=7)</a><br>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(            </div>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(            <div style="display: inline-block">
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(                <canvas id="toolbox" style="width: 500px; height: 120px; border: 1px solid black; margin: 0; padding: 0;">
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(                </canvas>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(            </div>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(        </div>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(        <div style="display: inline-block">
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(            <div>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(                <button id="btnShowHideImportExport">Show Import/Export</button><br>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(                <button id="clear">Clear All</button><br>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(            </div>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(        </div>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(        <div style="display: inline-block">
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(            <div>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(                <button id="btnClearMarkers">Clear All Pauli Marks</button><br>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(                <button id="btnClearSelectedMarkers">Clear Selected Marks (space)</button>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(            </div>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(        </div>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(        <div style="display: inline-block">
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(            <div>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(                <button id="btnRedo">Redo (ctrl+Y)</button><br>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(                <button id="btnUndo">Undo (ctrl+Z)</button>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(            </div>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(        </div>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(        <div style="display: inline-block">
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(            <div>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(                <button id="btnNextLayer">Next Layer (e)</button><br>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(                <button id="btnPrevLayer">Prev Layer (q)</button>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(            </div>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(        </div>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(        <div style="display: inline-block">
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(            <div>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(                <button id="btnRotate45">Rotate 45 Clockwise ↻ (t)</button><br>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(                <button id="btnRotate45Counter">Rotate 45 Mathwise ↺ (shift+t)</button>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(            </div>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(        </div>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(        <div style="display: inline-block">
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(            <div>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(                <button id="btnTimelineFocus">Set Timeline Focus (L)</button><br>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(                <button id="btnClearTimelineFocus">Clear Timeline Focus</button>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(            </div>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(        </div>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(        <textarea id="txtDefaultCircuit" style="display: none">[[[DEFAULT_CIRCUIT_CONTENT_LITERAL]]]</textarea>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(    </div>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(    <div id="divImportExport" style="display: none">
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(        <div>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(            <textarea id="txtStimCircuit" style="width: 95vw; height: 300px; background-color: #FFFFB0">
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(            </textarea>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(        </div>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(        <button id="btnExport" style="background-color: red">↑ Export to Stim Circuit ↑</button>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(        <button id="btnImport" style="background-color: red">↓ Import from Stim Circuit ↓</button>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(    </div>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(    <canvas id="cvn" style="width: calc(100vw - 32px); height: calc(100vh - 150px); border: 1px solid black; margin: 0; padding: 0;" tabindex="0">
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(    </canvas>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(</body>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(</html>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(<script>
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(class l{constructor(t,r,e,i,o,a,n,s=void 0){this.name=t,this.t=r,this.i=i,this.o=e,this.l=o,this.h=a,this.v=n,this.u=s}X(t){return new l(this.name,this.t,this.o,this.i,this.l,this.h,this.v,t)}}function _(r){var e=[];for(let t=0;t<r.length;t++){var i="I".repeat(t),o="I".repeat(r.length-t-1);"X"!==r[t]&&"Y"!==r[t]||e.push(i+"X"+o),"Z"!==r[t]&&"Y"!==r[t]||e.push(i+"Z"+o)}return e}class p{constructor(t,r,e){if(!(t instanceof l))throw new Error("!(gate instanceof Gate)");if(!(r instanceof Float32Array))throw new Error("!(args instanceof Float32Array)");if(!(e instanceof Uint32Array))throw new Error("!(targets instanceof Uint32Array)");this.Z=t,this.Y=r,this.R=e}M(i){let r=this.Z.l;if(void 0===r){if(this.Z.name.startsWith("M")){let r,e=(r=this.Z.name.startsWith("MPP:")?this.Z.name.substring(4):this.Z.name.substring(1),0);for(let t=0;t<i.length;t++){var o="XYZ".indexOf(i[t]),a="XYZ".indexOf(r[t]);0<=o&&0<=a&&o!==a&&e++}return e%2!=0?"ERR:"+i:i}if(this.Z.name.startsWith("SPP:")||this.Z.name.startsWith("SPP_DAG:")){va)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(r t=this.Z.name.startsWith("SPP_DAG:"),n=this.Z.name.substring(t?8:4);let r=0,e="";for(let t=0;t<i.length;t++){var s="IXYZ".indexOf(i[t]),l="IXYZ".indexOf(n[t]);0<s&&0<l&&s!==l&&r++,e+="IXYZ"[s^l]}return r%2!=0?e:i}if("POLYGON"===this.Z.name)return i;throw new Error(this.Z.name)}if(i.length!==this.Z.t)throw new Error("before.length !== this.gate.num_qubits");if(r.has(i))return r.get(i);let e=_(i);var h,f=[0,0];for(h of e=e.map(t=>r.get(t)))for(let t=0;t<i.length;t++)"X"===h[t]&&(f[t]^=1),"Y"===h[t]&&(f[t]^=3),"Z"===h[t]&&(f[t]^=2);let c="";for(let t=0;t<i.length;t++)c+="IXZY"[f[t]];return c}I(t,r){r.save();try{this.Z.v(this,t,r)}finally{r.restore()}}}const d=50,nt=10;function a(t,r,e){void 0!==r&&void 0!==e&&(t.strokeStyle="black",t.fillStyle="white",t.beginPath(),t.arc(r,e,nt,0,2*Math.PI),t.fill(),t.stroke(),t.beginPath(),t.moveTo(r,e-nt),t.lineTo(r,e+nt),t.stroke(),t.beginPath(),t.moveTo(r-nt,e),t.lineTo(r+nt,e),t.stroke())}function n(t,r,e){void 0!==r&&void 0!==e&&(t.strokeStyle="black",t.fillStyle="#AAA",)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(t.beginPath(),t.moveTo(r,e+nt),t.lineTo(r+nt,e-nt),t.lineTo(r-nt,e-nt),t.lineTo(r,e+nt),t.stroke(),t.fill())}function s(t,r,e){void 0!==r&&void 0!==e&&(t.fillStyle="black",t.beginPath(),t.arc(r,e,nt,0,2*Math.PI),t.fill())}function h(t,r,e){var i;void 0!==r&&void 0!==e&&(t.fillStyle="black",t.strokeStyle="black",t.beginPath(),t.arc(r,e,nt,0,2*Math.PI),t.fill(),t.stroke(),i=.4*nt,t.strokeStyle="white",t.lineWidth=3,t.beginPath(),t.moveTo(r-i,e-i),t.lineTo(r+i,e+i),t.stroke(),t.moveTo(r-i,e+i),t.lineTo(r+i,e-i),t.stroke(),t.lineWidth=1)}function f(t,r,e){var i;void 0!==r&&void 0!==e&&(t.fillStyle="#888",t.strokeStyle="#222",t.beginPath(),t.arc(r,e,nt,0,2*Math.PI),t.fill(),t.stroke(),i=.4*nt,t.lineWidth=3,t.strokeStyle="black",t.beginPath(),t.moveTo(r-i,e-i),t.lineTo(r+i,e+i),t.stroke(),t.moveTo(r-i,e+i),t.lineTo(r+i,e-i),t.stroke(),t.lineWidth=1)}function S(t,r,e){var i;void 0!==r&&void 0!==e&&(i=nt/3,t.strokeStyle="black",t.beginPath(),t.moveTo(r-i,e-i),t.lineTo(r+i,e+i),t.stroke(),t.moveTo(r-i,e+i),t.lineTo(r+)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(i,e-i),t.stroke())}function g(t,r,e){var i;void 0!==r&&void 0!==e&&(i=1.1*nt,t.strokeRect(r-i,e-i,2*i,2*i))}function st(t,r,e,i,o){var a,n,s,l,h;void 0===r||void 0===e||void 0===i||void 0===o?(g(t,r,e),g(t,i,o)):i<r||i===r&&o<e?st(t,i,o,r,e):(n=i-r,l=s=(a=o-e)/(a=Math.sqrt(n*n+a*a))*14,h=-(n=n/a*14),t.beginPath(),t.moveTo(r,e),a<1.1*d?t.lineTo(i,o):t.bezierCurveTo(r+n+l,e+s+h,i-n+l,o-s+h,i,o),t.stroke())}function v(t,r,e,i,o){t.lineWidth=2,t.strokeStyle="black",st(t,r,e,i,o),t.lineWidth=1}function W(e,i){if(e.beginPath(),0!==i.length){var r=i.length;if(1===r){var[[o,a]]=i;e.arc(o,a,1.7*nt,0,2*Math.PI)}else if(2===r){var[[o,a],[n,s]]=i,l=n-o,h=s-a,f=(n+o)/2,c=(s+a)/2;let t=-h,r=l;var v=t*t+r*r,v=(2500<v&&(v=50/Math.sqrt(v),t*=v,r*=v),f+.2*t-.2*l),d=c+.2*r-.2*h,w=f+.2*t+.2*l,u=c+.2*r+.2*h,X=f-.2*t-.2*l,Z=c-.2*r-.2*h,f=f-.2*t+.2*l,l=c-.2*r+.2*h;e.moveTo(o,a),e.bezierCurveTo(v,d,w,u,n,s),e.bezierCurveTo(f,l,X,Z,o,a)}else{var[c,h]=i[r-1];e.moveTo(c,h);for(let t=0;t<r;t++){var[Y,R]=i[t];e.lineTo(Y,R)}}}}function U()CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(t){let r,e,i,o;return o=0===t?(r=nt,e=nt+5,i=2*nt,5):1===t?(r=-nt,e=nt,i=5,2*nt):2===t?(r=nt,e=-nt,i=2*nt,5):3===t?(r=nt+5,e=nt,i=5,2*nt):(r=Math.cos(t/5)*nt,e=Math.sin(t/5)*nt,i=5),{dx:r,dy:e,m:i,p:o}}function*C(){yield new l("ISWAP",2,!0,!1,new Map([["IX","YZ"],["IZ","ZI"],["XI","ZY"],["ZI","IZ"]]),(t,r)=>t.do_iswap(r),(t,r,e)=>{var[i,o]=r(t.R[0]),[r,t]=r(t.R[1]);v(e,i,o,r,t),f(e,i,o),f(e,r,t)}),yield new l("ISWAP_DAG",2,!0,!1,new Map([["IX","YZ"],["IZ","ZI"],["XI","ZY"],["ZI","IZ"]]),(t,r)=>t.do_iswap(r),(t,r,e)=>{var[i,o]=r(t.R[0]),[r,t]=r(t.R[1]);v(e,i,o,r,t),f(e,i,o),f(e,r,t)}),yield new l("SWAP",2,!0,!1,new Map([["IX","XI"],["IZ","ZI"],["XI","IX"],["ZI","IZ"]]),(t,r)=>t.do_swap(r),(t,r,e)=>{var[i,o]=r(t.R[0]),[r,t]=r(t.R[1]);v(e,i,o,r,t),S(e,i,o),S(e,r,t)}),yield new l("CXSWAP",2,!0,!1,new Map([["IX","XI"],["IZ","ZZ"],["XI","XX"],["ZI","IZ"]]),(t,r)=>t.do_cx_swap(r),(t,r,e)=>{var[i,o]=r(t.R[0]),[r,t]=r(t.R[1]);v(e,i,o,r,t),h(e,i,o),i=e,o=t,void 0!==(e=r)&&void 0!==o&&(i.fillStyle="white",i.strokeStyle=)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART("black",i.beginPath(),i.arc(e,o,nt,0,2*Math.PI),i.fill(),i.stroke(),t=.4*nt,i.strokeStyle="black",i.lineWidth=3,i.beginPath(),i.moveTo(e-t,o-t),i.lineTo(e+t,o+t),i.stroke(),i.moveTo(e-t,o+t),i.lineTo(e+t,o-t),i.stroke(),i.lineWidth=1)}),yield new l("CZSWAP",2,!0,!1,new Map([["IX","XZ"],["IZ","ZI"],["XI","ZX"],["ZI","IZ"]]),(t,r)=>t.do_cz_swap(r),(t,r,e)=>{var[i,o]=r(t.R[0]),[r,t]=r(t.R[1]);v(e,i,o,r,t),h(e,i,o),h(e,r,t)})}function*P(){yield new l("CX",2,!0,!1,new Map([["IX","IX"],["IZ","ZZ"],["XI","XX"],["ZI","ZI"]]),(t,r)=>t.do_cx(r),(t,r,e)=>{var[i,o]=r(t.R[0]),[r,t]=r(t.R[1]);v(e,i,o,r,t),s(e,i,o),a(e,r,t)}),yield new l("CY",2,!0,!1,new Map([["IX","ZX"],["IZ","ZZ"],["XI","XY"],["ZI","ZI"]]),(t,r)=>t.do_cy(r),(t,r,e)=>{var[i,o]=r(t.R[0]),[r,t]=r(t.R[1]);v(e,i,o,r,t),s(e,i,o),n(e,r,t)}),yield new l("XCX",2,!0,!1,new Map([["IX","IX"],["IZ","XZ"],["XI","XI"],["ZI","ZX"]]),(t,r)=>t.do_xcx(r),(t,r,e)=>{var[i,o]=r(t.R[0]),[r,t]=r(t.R[1]);v(e,i,o,r,t),a(e,i,o),a(e,r,t)}),yield new l("XCY",2,!0,!1,new Map([["IX","X)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(X"],["IZ","XZ"],["XI","XI"],["ZI","ZY"]]),(t,r)=>t.do_xcy(r),(t,r,e)=>{var[i,o]=r(t.R[0]),[r,t]=r(t.R[1]);v(e,i,o,r,t),a(e,i,o),n(e,r,t)}),yield new l("YCY",2,!0,!1,new Map([["IX","YX"],["IZ","YZ"],["XI","XY"],["ZI","ZY"]]),(t,r)=>t.do_ycy(r),(t,r,e)=>{var[i,o]=r(t.R[0]),[r,t]=r(t.R[1]);v(e,i,o,r,t),n(e,i,o),n(e,r,t)}),yield new l("CZ",2,!0,!1,new Map([["IX","ZX"],["IZ","IZ"],["XI","XZ"],["ZI","ZI"]]),(t,r)=>t.do_cz(r),(t,r,e)=>{var[i,o]=r(t.R[0]),[r,t]=r(t.R[1]);v(e,i,o,r,t),s(e,i,o),s(e,r,t)}),yield new l("MR",1,!0,!1,new Map([["X","ERR:I"],["Y","ERR:I"],["Z","I"]]),(t,r)=>t.do_demolition_measure("Z",r),(t,r,e)=>{var[r,t]=r(t.R[0]);e.fillStyle="gray",e.fillRect(r-nt,t-nt,2*nt,2*nt),e.strokeStyle="black",e.strokeRect(r-nt,t-nt,2*nt,2*nt),e.fillStyle="black",e.textAlign="center",e.textBaseline="middle",e.fillText("MR",r,t)}),yield new l("MRY",1,!0,!1,new Map([["X","ERR:I"],["Y","I"],["Z","ERR:I"]]),(t,r)=>t.do_demolition_measure("Y",r),(t,r,e)=>{var[r,t]=r(t.R[0]);e.fillStyle="gray",e.fillRect(r-nt,t-nt,2*nt,)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(2*nt),e.strokeStyle="black",e.strokeRect(r-nt,t-nt,2*nt,2*nt),e.fillStyle="black",e.textAlign="center",e.textBaseline="middle",e.fillText("MRY",r,t)}),yield new l("MRX",1,!0,!1,new Map([["X","I"],["Y","ERR:I"],["Z","ERR:I"]]),(t,r)=>t.do_demolition_measure("X",r),(t,r,e)=>{var[r,t]=r(t.R[0]);e.fillStyle="gray",e.fillRect(r-nt,t-nt,2*nt,2*nt),e.strokeStyle="black",e.strokeRect(r-nt,t-nt,2*nt,2*nt),e.fillStyle="black",e.textAlign="center",e.textBaseline="middle",e.fillText("MRX",r,t)}),yield new l("H",1,!0,!1,new Map([["X","Z"],["Z","X"]]),(t,r)=>t.do_exchange_xz(r),(t,r,e)=>{var[r,t]=r(t.R[0]);e.fillStyle="yellow",e.fillRect(r-nt,t-nt,2*nt,2*nt),e.strokeStyle="black",e.strokeRect(r-nt,t-nt,2*nt,2*nt),e.fillStyle="black",e.textAlign="center",e.textBaseline="middle",e.fillText("H",r,t)}),yield new l("H_XY",1,!0,!1,new Map([["X","Y"],["Z","Z"]]),(t,r)=>t.do_exchange_xy(r),(t,r,e)=>{var[r,t]=r(t.R[0]);e.fillStyle="yellow",e.fillRect(r-nt,t-nt,2*nt,2*nt),e.strokeStyle="black",e.strokeRect(r-nt,t-nt,2*nt,2*nt),e.fil)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(lStyle="black",e.textAlign="center",e.textBaseline="middle",e.fillText("H",r,t-nt/3),e.fillText("XY",r,t+nt/3)}),yield new l("H_YZ",1,!0,!1,new Map([["X","X"],["Z","Y"]]),(t,r)=>t.do_exchange_yz(r),(t,r,e)=>{var[r,t]=r(t.R[0]);e.fillStyle="yellow",e.fillRect(r-nt,t-nt,2*nt,2*nt),e.strokeStyle="black",e.strokeRect(r-nt,t-nt,2*nt,2*nt),e.fillStyle="black",e.textAlign="center",e.textBaseline="middle",e.fillText("H",r,t-nt/3),e.fillText("YZ",r,t+nt/3)}),yield new l("POLYGON",void 0,!1,!0,void 0,()=>{},(t,r,e)=>{var i,o=[];for(i of t.R)o.push(r(i));W(e,o),e.globalAlpha*=t.Y[3],e.fillStyle=`rgb(${255*t.Y[0]},${255*t.Y[1]},${255*t.Y[2]})`,e.strokeStyle=`rgb(${32*t.Y[0]},${32*t.Y[1]},${32*t.Y[2]})`,e.fill(),e.stroke()}),yield new l("MARKX",1,!0,!0,void 0,()=>{},(o,a,n)=>{var[a,s]=a(o.R[0]);if(void 0!==a&&void 0!==s){var{dx:o,dy:l,m:h,p:f}=U(o.Y[0]);let t,r,e,i;i=h===f?(t=a+o,r=s+l,e=t+o+h,r+l+f):(t=a+(o<0?1:-1)*nt,r=s+(l<0?1:-1)*nt,e=t+(h>nt?1:0)*nt*2,r+(f>nt?1:0)*nt*2),n.fillStyle="red",n.beginPath(),n.moveTo(a,s),n)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(.lineTo(t,r),n.lineTo(e,i),n.lineTo(a,s),n.fill()}}),yield new l("MARKY",1,!0,!0,void 0,()=>{},(o,a,n)=>{var[a,s]=a(o.R[0]);if(void 0!==a&&void 0!==s){var{dx:o,dy:l,m:h,p:f}=U(o.Y[0]);let t,r,e,i;i=h===f?(t=a+o,r=s+l,e=t+o+h,r+l+f):(t=a+(o<0?1:-1)*nt,r=s+(l<0?1:-1)*nt,e=t+(h>nt?1:0)*nt*2,r+(f>nt?1:0)*nt*2),n.fillStyle="green",n.beginPath(),n.moveTo(a,s),n.lineTo(t,r),n.lineTo(e,i),n.lineTo(a,s),n.fill()}}),yield new l("MARKZ",1,!0,!0,void 0,()=>{},(o,a,n)=>{var[a,s]=a(o.R[0]);if(void 0!==a&&void 0!==s){var{dx:o,dy:l,m:h,p:f}=U(o.Y[0]);let t,r,e,i;i=h===f?(t=a+o,r=s+l,e=t+o+h,r+l+f):(t=a+(o<0?1:-1)*nt,r=s+(l<0?1:-1)*nt,e=t+(h>nt?1:0)*nt*2,r+(f>nt?1:0)*nt*2),n.fillStyle="blue",n.beginPath(),n.moveTo(a,s),n.lineTo(t,r),n.lineTo(e,i),n.lineTo(a,s),n.fill()}}),yield new l("MARK",1,!1,!0,void 0,()=>{},(t,r,e)=>{var[r,t]=r(t.R[0]);void 0!==r&&void 0!==t&&(e.fillStyle="magenta",e.fillRect(r-nt,t-nt,nt,nt))}),yield new l("MXX",2,!0,!1,new Map([["II","II"],["IX","IX"],["IY","ERR:IY"],["IZ","ERR:IZ"],["XI","XI"],["XX",")CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(XX"],["XY","ERR:XY"],["XZ","ERR:XZ"],["YI","ERR:YI"],["YX","ERR:YX"],["YY","YY"],["YZ","YZ"],["ZI","ERR:ZI"],["ZX","ERR:ZX"],["ZY","ZY"],["ZZ","ZZ"]]),(t,r)=>t.do_measure("XX",r),(t,r,e)=>{var[i,o]=r(t.R[0]),[r,t]=r(t.R[1]);v(e,i,o,r,t),e.fillStyle="gray",e.fillRect(i-nt,o-nt,2*nt,2*nt),e.fillRect(r-nt,t-nt,2*nt,2*nt),e.strokeStyle="black",e.strokeRect(i-nt,o-nt,2*nt,2*nt),e.strokeRect(r-nt,t-nt,2*nt,2*nt),e.fillStyle="black",e.textAlign="center",e.textBaseline="middle",e.fillText("MXX",i,o),e.fillText("MXX",r,t)}),yield new l("MYY",2,!0,!1,new Map([["II","II"],["IX","ERR:IX"],["IY","IY"],["IZ","ERR:IZ"],["XI","ERR:XI"],["XX","XX"],["XY","ERR:XY"],["XZ","XZ"],["YI","YI"],["YX","ERR:YX"],["YY","YY"],["YZ","ERR:YZ"],["ZI","ERR:ZI"],["ZX","ZX"],["ZY","ERR:ZY"],["ZZ","ZZ"]]),(t,r)=>t.do_measure("YY",r),(t,r,e)=>{var[i,o]=r(t.R[0]),[r,t]=r(t.R[1]);v(e,i,o,r,t),e.fillStyle="gray",e.fillRect(i-nt,o-nt,2*nt,2*nt),e.fillRect(r-nt,t-nt,2*nt,2*nt),e.strokeStyle="black",e.strokeRect(i-nt,o-nt,2*nt,2*nt),e.strokeRect(r-nt)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(,t-nt,2*nt,2*nt),e.fillStyle="black",e.textAlign="center",e.textBaseline="middle",e.fillText("MYY",i,o),e.fillText("MYY",r,t)}),yield new l("MZZ",2,!0,!1,new Map([["II","II"],["IX","ERR:IX"],["IY","ERR:IY"],["IZ","IZ"],["XI","ERR:XI"],["XX","XX"],["XY","XY"],["XZ","ERR:XZ"],["YI","ERR:YI"],["YX","YX"],["YY","YY"],["YZ","ERR:YZ"],["ZI","ZI"],["ZX","ERR:ZX"],["ZY","ERR:ZY"],["ZZ","ZZ"]]),(t,r)=>t.do_measure("ZZ",r),(t,r,e)=>{var[i,o]=r(t.R[0]),[r,t]=r(t.R[1]);v(e,i,o,r,t),e.fillStyle="gray",e.fillRect(i-nt,o-nt,2*nt,2*nt),e.fillRect(r-nt,t-nt,2*nt,2*nt),e.strokeStyle="black",e.strokeRect(i-nt,o-nt,2*nt,2*nt),e.strokeRect(r-nt,t-nt,2*nt,2*nt),e.fillStyle="black",e.textAlign="center",e.textBaseline="middle",e.fillText("MZZ",i,o),e.fillText("MZZ",r,t)}),yield new l("I",1,!0,!1,new Map([["X","X"],["Z","Z"]]),()=>{},(t,r,e)=>{var[r,t]=r(t.R[0]);e.fillStyle="white",e.fillRect(r-nt,t-nt,2*nt,2*nt),e.strokeStyle="black",e.strokeRect(r-nt,t-nt,2*nt,2*nt),e.fillStyle="black",e.textAlign="center",e.textBaseline="middle",e)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(.fillText("I",r,t)}),yield new l("X",1,!0,!1,new Map([["X","X"],["Z","Z"]]),()=>{},(t,r,e)=>{var[r,t]=r(t.R[0]);e.fillStyle="white",e.fillRect(r-nt,t-nt,2*nt,2*nt),e.strokeStyle="black",e.strokeRect(r-nt,t-nt,2*nt,2*nt),e.fillStyle="black",e.textAlign="center",e.textBaseline="middle",e.fillText("X",r,t)}),yield new l("Y",1,!0,!1,new Map([["X","X"],["Z","Z"]]),()=>{},(t,r,e)=>{var[r,t]=r(t.R[0]);e.fillStyle="white",e.fillRect(r-nt,t-nt,2*nt,2*nt),e.strokeStyle="black",e.strokeRect(r-nt,t-nt,2*nt,2*nt),e.fillStyle="black",e.textAlign="center",e.textBaseline="middle",e.fillText("Y",r,t)}),yield new l("Z",1,!0,!1,new Map([["X","X"],["Z","Z"]]),()=>{},(t,r,e)=>{var[r,t]=r(t.R[0]);e.fillStyle="white",e.fillRect(r-nt,t-nt,2*nt,2*nt),e.strokeStyle="black",e.strokeRect(r-nt,t-nt,2*nt,2*nt),e.fillStyle="black",e.textAlign="center",e.textBaseline="middle",e.fillText("Z",r,t)}),yield new l("S",1,!0,!1,new Map([["X","Y"],["Z","Z"]]),(t,r)=>t.do_exchange_xy(r),(t,r,e)=>{var[r,t]=r(t.R[0]);e.fillStyle="yellow",e.fillRect(r-)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(nt,t-nt,2*nt,2*nt),e.strokeStyle="black",e.strokeRect(r-nt,t-nt,2*nt,2*nt),e.fillStyle="black",e.textAlign="center",e.textBaseline="middle",e.fillText("S",r,t)}),yield new l("S_DAG",1,!0,!1,new Map([["X","Y"],["Z","Z"]]),(t,r)=>t.do_exchange_xy(r),(t,r,e)=>{var[r,t]=r(t.R[0]);e.fillStyle="yellow",e.fillRect(r-nt,t-nt,2*nt,2*nt),e.strokeStyle="black",e.strokeRect(r-nt,t-nt,2*nt,2*nt),e.fillStyle="black",e.textAlign="center",e.textBaseline="middle",e.fillText("S†",r,t)}),yield new l("SQRT_X",1,!0,!1,new Map([["X","X"],["Z","Y"]]),(t,r)=>t.do_exchange_yz(r),(t,r,e)=>{var[r,t]=r(t.R[0]);e.fillStyle="yellow",e.fillRect(r-nt,t-nt,2*nt,2*nt),e.strokeStyle="black",e.strokeRect(r-nt,t-nt,2*nt,2*nt),e.fillStyle="black",e.textAlign="center",e.textBaseline="middle",e.fillText("√X",r,t)}),yield new l("SQRT_X_DAG",1,!0,!1,new Map([["X","X"],["Z","Y"]]),(t,r)=>t.do_exchange_yz(r),(t,r,e)=>{var[r,t]=r(t.R[0]);e.fillStyle="yellow",e.fillRect(r-nt,t-nt,2*nt,2*nt),e.strokeStyle="black",e.strokeRect(r-nt,t-nt,2*nt,2*nt),e.fillSt)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(yle="black",e.textAlign="center",e.textBaseline="middle",e.fillText("√X†",r,t)}),yield new l("SQRT_Y",1,!0,!1,new Map([["X","Z"],["Z","X"]]),(t,r)=>t.do_exchange_xz(r),(t,r,e)=>{var[r,t]=r(t.R[0]);e.fillStyle="yellow",e.fillRect(r-nt,t-nt,2*nt,2*nt),e.strokeStyle="black",e.strokeRect(r-nt,t-nt,2*nt,2*nt),e.fillStyle="black",e.textAlign="center",e.textBaseline="middle",e.fillText("√Y",r,t)}),yield new l("SQRT_Y_DAG",1,!0,!1,new Map([["X","Z"],["Z","X"]]),(t,r)=>t.do_exchange_xz(r),(t,r,e)=>{var[r,t]=r(t.R[0]);e.fillStyle="yellow",e.fillRect(r-nt,t-nt,2*nt,2*nt),e.strokeStyle="black",e.strokeRect(r-nt,t-nt,2*nt,2*nt),e.fillStyle="black",e.textAlign="center",e.textBaseline="middle",e.fillText("√Y†",r,t)}),yield new l("R",1,!0,!1,new Map([["X","ERR:I"],["Y","ERR:I"],["Z","ERR:I"]]),(t,r)=>t.do_discard(r),(t,r,e)=>{var[r,t]=r(t.R[0]);e.fillStyle="gray",e.fillRect(r-nt,t-nt,2*nt,2*nt),e.strokeStyle="black",e.strokeRect(r-nt,t-nt,2*nt,2*nt),e.fillStyle="black",e.textAlign="center",e.textBaseline="middle",e.fillText()CRUMBLE_PART");
    result.append(R"CRUMBLE_PART("R",r,t)}),yield new l("RX",1,!0,!1,new Map([["X","ERR:I"],["Y","ERR:I"],["Z","ERR:I"]]),(t,r)=>t.do_discard(r),(t,r,e)=>{var[r,t]=r(t.R[0]);e.fillStyle="gray",e.fillRect(r-nt,t-nt,2*nt,2*nt),e.strokeStyle="black",e.strokeRect(r-nt,t-nt,2*nt,2*nt),e.fillStyle="black",e.textAlign="center",e.textBaseline="middle",e.fillText("RX",r,t)}),yield new l("RY",1,!0,!1,new Map([["X","ERR:I"],["Y","ERR:I"],["Z","ERR:I"]]),(t,r)=>t.do_discard(r),(t,r,e)=>{var[r,t]=r(t.R[0]);e.fillStyle="gray",e.fillRect(r-nt,t-nt,2*nt,2*nt),e.strokeStyle="black",e.strokeRect(r-nt,t-nt,2*nt,2*nt),e.fillStyle="black",e.textAlign="center",e.textBaseline="middle",e.fillText("RY",r,t)}),yield new l("M",1,!0,!1,new Map([["X","ERR:X"],["Y","ERR:Y"],["Z","Z"]]),(t,r)=>t.do_measure("Z",r),(t,r,e)=>{var[r,t]=r(t.R[0]);e.fillStyle="gray",e.fillRect(r-nt,t-nt,2*nt,2*nt),e.strokeStyle="black",e.strokeRect(r-nt,t-nt,2*nt,2*nt),e.fillStyle="black",e.textAlign="center",e.textBaseline="middle",e.fillText("M",r,t),e.textAlign="left"}),yield new l("MX",1,!0)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(,!1,new Map([["X","X"],["Y","ERR:Y"],["Z","ERR:Z"]]),(t,r)=>t.do_measure("X",r),(t,r,e)=>{var[r,t]=r(t.R[0]);e.fillStyle="gray",e.fillRect(r-nt,t-nt,2*nt,2*nt),e.strokeStyle="black",e.strokeRect(r-nt,t-nt,2*nt,2*nt),e.fillStyle="black",e.textAlign="center",e.textBaseline="middle",e.fillText("MX",r,t),e.textAlign="left"}),yield new l("MY",1,!0,!1,new Map([["X","ERR:X"],["Y","Y"],["Z","ERR:Z"]]),(t,r)=>t.do_measure("Y",r),(t,r,e)=>{var[r,t]=r(t.R[0]);e.fillStyle="gray",e.fillRect(r-nt,t-nt,2*nt,2*nt),e.strokeStyle="black",e.strokeRect(r-nt,t-nt,2*nt,2*nt),e.fillStyle="black",e.textAlign="center",e.textBaseline="middle",e.fillText("MY",r,t),e.textAlign="left"}),yield new l("SQRT_XX",2,!0,!1,new Map([["IX","IX"],["IZ","XY"],["XI","XI"],["ZI","YX"]]),(t,r)=>t.do_sqrt_xx(r),(t,r,e)=>{var i,o,[a,n]=r(t.R[0]),[r,t]=r(t.R[1]);v(e,a,n,r,t);for([i,o]of[[a,n],[r,t]])e.fillStyle="yellow",e.fillRect(i-nt,o-nt,2*nt,2*nt),e.strokeStyle="black",e.strokeRect(i-nt,o-nt,2*nt,2*nt),e.fillStyle="black",e.textAlign="center",e.textB)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(aseline="middle",e.fillText("√XX",i,o)}),yield new l("SQRT_XX_DAG",2,!0,!1,new Map([["IX","IX"],["IZ","XY"],["XI","XI"],["ZI","YX"]]),(t,r)=>t.do_sqrt_xx(r),(t,r,e)=>{var i,o,[a,n]=r(t.R[0]),[r,t]=r(t.R[1]);v(e,a,n,r,t);for([i,o]of[[a,n],[r,t]])e.fillStyle="yellow",e.fillRect(i-nt,o-nt,2*nt,2*nt),e.strokeStyle="black",e.strokeRect(i-nt,o-nt,2*nt,2*nt),e.fillStyle="black",e.textAlign="center",e.textBaseline="middle",e.fillText("√XX†",i,o)}),yield new l("SQRT_YY",2,!0,!1,new Map([["IX","YZ"],["IZ","YX"],["XI","ZY"],["ZI","XY"]]),(t,r)=>t.do_sqrt_yy(r),(t,r,e)=>{var i,o,[a,n]=r(t.R[0]),[r,t]=r(t.R[1]);v(e,a,n,r,t);for([i,o]of[[a,n],[r,t]])e.fillStyle="yellow",e.fillRect(i-nt,o-nt,2*nt,2*nt),e.strokeStyle="black",e.strokeRect(i-nt,o-nt,2*nt,2*nt),e.fillStyle="black",e.textAlign="center",e.textBaseline="middle",e.fillText("√YY",i,o)}),yield new l("SQRT_YY_DAG",2,!0,!1,new Map([["IX","YZ"],["IZ","YX"],["XI","ZY"],["ZI","XY"]]),(t,r)=>t.do_sqrt_yy(r),(t,r,e)=>{var i,o,[a,n]=r(t.R[0]),[r,t]=r(t.R[1]);v(e,a,n,r,t);for)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(([i,o]of[[a,n],[r,t]])e.fillStyle="yellow",e.fillRect(i-nt,o-nt,2*nt,2*nt),e.strokeStyle="black",e.strokeRect(i-nt,o-nt,2*nt,2*nt),e.fillStyle="black",e.textAlign="center",e.textBaseline="middle",e.fillText("√YY†",i,o)}),yield new l("SQRT_ZZ",2,!0,!1,new Map([["IX","ZY"],["IZ","IZ"],["XI","YZ"],["ZI","ZI"]]),(t,r)=>t.do_sqrt_zz(r),(t,r,e)=>{var i,o,[a,n]=r(t.R[0]),[r,t]=r(t.R[1]);v(e,a,n,r,t);for([i,o]of[[a,n],[r,t]])e.fillStyle="yellow",e.fillRect(i-nt,o-nt,2*nt,2*nt),e.strokeStyle="black",e.strokeRect(i-nt,o-nt,2*nt,2*nt),e.fillStyle="black",e.textAlign="center",e.textBaseline="middle",e.fillText("√ZZ",i,o)}),yield new l("SQRT_ZZ_DAG",2,!0,!1,new Map([["IX","ZY"],["IZ","IZ"],["XI","YZ"],["ZI","ZI"]]),(t,r)=>t.do_sqrt_zz(r),(t,r,e)=>{var i,o,[a,n]=r(t.R[0]),[r,t]=r(t.R[1]);v(e,a,n,r,t);for([i,o]of[[a,n],[r,t]])e.fillStyle="yellow",e.fillRect(i-nt,o-nt,2*nt,2*nt),e.strokeStyle="black",e.strokeRect(i-nt,o-nt,2*nt,2*nt),e.fillStyle="black",e.textAlign="center",e.textBaseline="middle",e.fillText("√ZZ†",i,o)}),yi)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(eld*C(),yield new l("C_XYZ",1,!0,!1,new Map([["X","Y"],["Z","X"]]),(t,r)=>t.do_cycle_xyz(r),(t,r,e)=>{var[r,t]=r(t.R[0]);e.fillStyle="teal",e.fillRect(r-nt,t-nt,2*nt,2*nt),e.fillStyle="black",e.strokeStyle="black",e.strokeRect(r-nt,t-nt,2*nt,2*nt),e.textAlign="center",e.textBaseline="middle",e.fillText("C",r,t-nt/3),e.fillText("XYZ",r,t+nt/3)}),yield new l("C_ZYX",1,!0,!1,new Map([["X","Z"],["Z","Y"]]),(t,r)=>t.do_cycle_zyx(r),(t,r,e)=>{var[r,t]=r(t.R[0]);e.fillStyle="teal",e.fillRect(r-nt,t-nt,2*nt,2*nt),e.fillStyle="black",e.strokeStyle="black",e.strokeRect(r-nt,t-nt,2*nt,2*nt),e.textAlign="center",e.textBaseline="middle",e.fillText("C",r,t-nt/3),e.fillText("ZYX",r,t+nt/3)})}const E=function(){var t,r=new Map;for(t of P())r.set(t.name,t);return r}(),O=((t=new Map).set("CNOT",{name:"CX"}),t.set("MZ",{name:"M"}),t.set("MRZ",{name:"MR"}),t.set("RZ",{name:"R"}),t.set("H_XZ",{name:"H"}),t.set("SQRT_Z",{name:"S"}),t.set("SQRT_Z_DAG",{name:"S_DAG"}),t.set("ZCX",{name:"CX"}),t.set("ZCY",{name:"CY"}),t.set("ZCZ",{na)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(me:"CZ"}),t.set("SWAPCZ",{name:"CZSWAP"}),t.set("XCZ",{name:"CX",A:!0}),t.set("YCX",{name:"XCY",A:!0}),t.set("YCZ",{name:"CY",A:!0}),t.set("SWAPCX",{name:"CXSWAP",A:!0}),t.set("CORRELATED_ERROR",{k:!0}),t.set("DEPOLARIZE1",{k:!0}),t.set("DEPOLARIZE2",{k:!0}),t.set("E",{k:!0}),t.set("ELSE_CORRELATED_ERROR",{k:!0}),t.set("PAULI_CHANNEL_1",{k:!0}),t.set("PAULI_CHANNEL_2",{k:!0}),t.set("X_ERROR",{k:!0}),t.set("Y_ERROR",{k:!0}),t.set("Z_ERROR",{k:!0}),t.set("HERALDED_ERASE",{k:!0}),t.set("HERALDED_PAULI_CHANNEL_1",{k:!0}),t.set("MPAD",{k:!0}),t.set("DETECTOR",{k:!0}),t.set("OBSERVABLE_INCLUDE",{k:!0}),t.set("SHIFT_COORDS",{k:!0}),t);class b{constructor(){this._=new Map,this.S=[]}g(){var t=new b;return t._=new Map(this._),t.S=[...this.S],t}empty(){return 0===this._.size&&0===this.S.length}C(t){var r,e,i=new b;for(r of this._.values())t(r)&&i.put(r);for(e of this.S)t(e)&&i.S.push(e);return i}P(r){return this.C(t=>!t.R.every(t=>!r(t)))}O(e,t){var r,i,o=new Map,a=new Set;for(r of e.keys()){var n=e.get(r),s=this._.get()CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(r);if(void 0!==s){let r="";for(var l of s.R){a.has(l),a.add(l);let t=e.get(l);void 0===t&&(t="I"),r+=t}var h=s.M(r),f=h.startsWith("ERR:");for(let t=0;t<s.R.length;t++){var c=s.R[t];f?o.set(c,"ERR:"+h[4+t]):o.set(c,h[t])}}else o.set(r,n)}for(i of this.S)if("MARKX"===i.Z.name&&i.Y[0]===t){var v=i.R[0];let t=o.get(v);void 0===t||"I"===t?t="X":"X"===t?t="I":"Y"===t?t="Z":"Z"===t&&(t="Y"),o.set(v,t)}else if("MARKY"===i.Z.name&&i.Y[0]===t){v=i.R[0];let t=o.get(v);void 0===t||"I"===t?t="Y":"X"===t?t="Z":"Y"===t?t="I":"Z"===t&&(t="X"),o.set(v,t)}else if("MARKZ"===i.Z.name&&i.Y[0]===t){var d=i.R[0];let t=o.get(d);void 0===t||"I"===t?t="Z":"X"===t?t="Y":"Y"===t?t="X":"Z"===t&&(t="I"),o.set(d,t)}return o}T(){return 0===this._.size&&0===this.S.length}D(r){if(this.S=this.S.filter(t=>-1===t.R.indexOf(r)),this._.has(r)){var t,e=this._.get(r);for(t of e.R)this._.delete(t);return e}}G(r,e=void 0){this.S=this.S.filter(t=>void 0!==e&&t.Y[0]!==e||"MARKX"!==t.Z.name&&"MARKY"!==t.Z.name&&"MARKZ"!==t.Z.name||t.R[0]!==r)}put(t,r=!0)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(){if(t.Z.i)"MARKX"!==t.Z.name&&"MARKY"!==t.Z.name&&"MARKZ"!==t.Z.name||this.G(t.R[0],t.Y[0]),this.S.push(t);else{for(var e of t.R)if(this._.has(e)){if(!r)throw new Error("Collision");this.D(e)}for(var i of t.R)this._.set(i,t)}}*L(){for(var t of this._.keys()){var r=this._.get(t);r.R[0]===t&&(yield r)}yield*this.S}}function y(t){let r=void 0,e=void 0;for(var[i,o]of t)(void 0===r||i<r||i===r&&o<e)&&(r=i,e=o);return[r,e]}const w=1e3,T=(new function(){}).toString(),D="!recursion-limit!",x=10;function G(t,r){if(0===r)return D;if(t instanceof Map){var e,i,o=r,a=[];for([e,i]of t.entries()){if(a.length>w){a.push("[...]");break}e=A(e,o-1),i=A(i,o-1);a.push(e+": "+i)}return`Map{${a.join(", ")}}`}if(t instanceof Set){var n,s=r,l=[];for(n of t){if(l.length>w){l.push("[...]");break}l.push(A(n,s-1))}return`Set{${l.join(", ")}}`}if(void 0!==t[Symbol.iterator]){var h,f=r,c=[];for(h of t){if(c.length>w){c.push("[...]");break}c.push(A(h,f-1))}return`${t=Array.isArray(t)?"":t.constructor.name}[${c.join(", ")}]`}}function L(t,r))CRUMBLE_PART");
    result.append(R"CRUMBLE_PART({try{var e=String(t);if(e!==T)return e}catch{}var i=t,o=r,a=[];for(s in i)if(i.hasOwnProperty(s)){if(a.length>w){a.push("[...]");break}var n=i[s],s=A(s,o-1),n=A(n,o-1);a.push(s+": "+n)}return void 0===i.constructor?"[an unknown non-primitive value with no constructor]":(e=(e=i.constructor.name)==={}.constructor.name?"":`(Type: ${e})`)+`{${a.join(", ")}}`}function A(t,r=x){return(null===(e=t)?"null":void 0===e?"undefined":"string"==typeof e?`"${e}"`:"number"==typeof e?""+e:void 0)||G(t,r)||L(t,r);var e}function Q(t,r){var e,i=new Map;for(e of t){var o=r(e),a=i.get(o);void 0===a?i.set(o,[e]):a.push(e)}return i}function F(t){let r=[];var e,i=()=>{""!==o&&(r.push(o),o="")};let o="";for(e of t)" "===e?i():"*"===e?(i(),r.push("*")):o+=e;return i(),r}function N(e){var t=[];let i=0;for(;i<e.length;){let r=i+1;for(;r<e.length&&"*"===e[r];)r+=2;if(r>e.length)throw Error(`Dangling combiner in ${e}.`);var o=[];for(let t=i;t<r;t+=2){if("*"===e[t]){if(0===t)throw Error(`Leading combiner in ${e}.`);throw Error(`Adjacent com)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(biners in ${e}.`)}o.push(e[t])}t.push(o),i=r}return t}function K(t,r){let e="";var i,f,o=[];for(i of r){if("X"!==(i="!"===i[0]?i.substring(1):i)[0]&&"Y"!==i[0]&&"Z"!==i[0])throw Error("Non-Pauli target given to MPP: "+r);e+=i[0];var a=parseInt(i.substring(1));if(a!=a)throw Error("Non-Pauli target given to MPP: "+r);o.push(a)}let n=E.get("M"+e);return void 0===(n=void 0===n?E.get("MPP:"+e):n)&&(n=(f=e,new l("MPP:"+f,f.length,!0,!1,void 0,(t,r)=>t.do_mpp(f,r),(r,e,i)=>{let o=void 0,a=void 0;for(let t=0;t<r.R.length;t++){var[n,s]=e(r.R[t]);void 0!==o&&v(i,n,s,o,a),o=n,a=s}for(let t=0;t<r.R.length;t++){var[l,h]=e(r.R[t]);i.fillStyle="gray",i.fillRect(l-nt,h-nt,2*nt,2*nt),i.strokeStyle="black",i.strokeRect(l-nt,h-nt,2*nt,2*nt),i.fillStyle="black",i.textAlign="center",i.textBaseline="middle",i.font="bold 12pt monospace",i.fillText(f[t],l,h-1),i.font="5pt monospace",i.fillText("MPP",l,h+8)}}))),new p(n,t,new Uint32Array(o))}function q(t,r,e){let i="";var o,f,c,a=[];for(o of e){if("X"!==(o="!"===o[0]?o.substring(1):o)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART()[0]&&"Y"!==o[0]&&"Z"!==o[0])throw Error("Non-Pauli target given to SPP: "+e);i+=o[0];var n=parseInt(o.substring(1));if(n!=n)throw Error("Non-Pauli target given to SPP: "+e);a.push(n)}let s=E.get((r?"SPP_DAG:":"SPP:")+i);return void 0===s&&(s=(f=i,c=r,new l((c?"SPP_DAG:":"SPP:")+f,f.length,!0,!1,void 0,(t,r)=>t.do_spp(f,r),(r,e,i)=>{let o=void 0,a=void 0;for(let t=0;t<r.R.length;t++){var[n,s]=e(r.R[t]);void 0!==o&&v(i,n,s,o,a),o=n,a=s}for(let t=0;t<r.R.length;t++){var[l,h]=e(r.R[t]);i.fillStyle="gray",i.fillRect(l-nt,h-nt,2*nt,2*nt),i.strokeStyle="black",i.strokeRect(l-nt,h-nt,2*nt,2*nt),i.fillStyle="black",i.textAlign="center",i.textBaseline="middle",i.font="bold 12pt monospace",i.fillText(f[t],l,h-1),i.font="5pt monospace",i.fillText(c?"SPP†":"SPP",l,h+8)}}))),new p(s,t,new Uint32Array(a))}class u{constructor(t,r=[]){if(!(t instanceof Float64Array))throw new Error("!(qubitCoords instanceof Float64Array)");if(!Array.isArray(r))throw new Error("!Array.isArray(layers)");if(!r.every(t=>t instanceof b))throw new)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART( Error("!layers.every(e => e instanceof Layer)");this.F=t,this.N=r}static K(t){t=t.replaceAll(";","\n").replaceAll("_"," ").replaceAll("Q(","QUBIT_COORDS(").replaceAll("DT","DETECTOR").replaceAll(" COORDS","_COORDS").replaceAll(" ERROR","_ERROR").replaceAll("C XYZ","C_XYZ").replaceAll("H XY","H_XY").replaceAll("H YZ","H_YZ").replaceAll(" INCLUDE","_INCLUDE").replaceAll("SQRT ","SQRT_").replaceAll(" DAG ","_DAG ").replaceAll("C ZYX","C_ZYX").split("\n");let M=[new b],I=new Map,m=new Set,s=(e,i,o,r)=>{M[M.length-1].empty()||M.push(new b);for(let t=0;t<r;t++){for(let r=i;r<o;r++){let t=e[r];var a,n;(t=t.split("#")[0].trim()).toLowerCase().startsWith("repeat ")?(a=parseInt(t.split(" ")[1]),n=((e,t,i)=>{let o=0;for(let r=t;r<i;r++){let t=e[r];if((t=t.split("#")[0].trim()).toLowerCase().startsWith("repeat "))o++;else if("}"===t&&0===--o)return r}throw Error("Repeat block didn't end")})(e,r,o),s(e,r+1,n,a),r=n):(o=>{let a=[],n=[],s="";if(o.indexOf(")")!==-1){let[t,r]=o.split(")");let[e,i]=t.split("(");s=e.trim();a=i)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(.split(",").map(t=>t.trim()).map(parseFloat);n=F(r)}else{let t=o.split(" ").map(t=>t.trim()).filter(t=>t!=="");if(t.length===0)return;let[r,...e]=t;s=r.trim();a=[];n=e.flatMap(F)}let e=false;if(""!==s){var r=O.get(s),i;if(void 0!==r){if(r.k)return;if(void 0===r.name)throw new Error(`Unimplemented alias ${s}: ${A(r)}.`);e=void 0!==r.A&&r.A,s=r.name}else{if("TICK"===s)return M.push(new b);if("MPP"===s){var l=N(n),h;let r=M[M.length-1];for(h of l)try{r.put(K(new Float32Array(a),h),!1)}catch(t){M.push(new b),(r=M[M.length-1]).put(K(new Float32Array(a),h),!1)}return}if("SPP"===s||"SPP_DAG"===s){var f="SPP_DAG"===s,c=N(n),v;let r=M[M.length-1];for(v of c)try{r.put(q(new Float32Array(a),f,v),!1)}catch(t){M.push(new b),(r=M[M.length-1]).put(q(new Float32Array(a),f,v),!1)}return}if(s.startsWith("QUBIT_COORDS")){var d=a.length<1?0:a[0],w=a.length<2?0:a[1],u;for(u of n){var X=parseInt(u);I.has(X)?console.warn(`Ignoring "${o}" because there's already coordinate data for qubit ${X}.`):m.has(d+","+w)?console.warn(`Ignoring)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART( "${o}" because there's already a qubit placed at ${d},${w}.`):(I.set(X,[d,w]),m.add(d+","+w))}return}}let t=!1;for(i of n){if(i.startsWith("rec[")&&("CX"===s||"CY"===s||"CZ"===s||"ZCX"===s||"ZCY"===s)){t=!0;break}if("number"!=typeof parseInt(i))throw new Error(o)}if(t)console.warn("IGNORED",s);else{var Z=E.get(s);if(void 0===Z)console.warn("Unrecognized gate name in "+o);else{var Y=new Float32Array(a);let r=M[M.length-1];if(void 0===Z.t)r.put(new p(Z,Y,new Uint32Array(n)));else{if(n.length%Z.t!=0)throw new Error("Incorrect number of targets in line "+o);for(let t=0;t<n.length;t+=Z.t){var R=n.slice(t,t+Z.t),y=(e&&R.reverse(),new Uint32Array(R));try{r.put(new p(Z,Y,y),!1)}catch(t){M.push(new b),(r=M[M.length-1]).put(new p(Z,Y,y),!1)}}}}}}})(t)}M[M.length-1].empty()||M.push(new b)}},o=(s(t,0,t.length,1),0<M.length&&M[M.length-1].T()&&M.pop(),0);var r,e=t=>{let r=!0;for(;!I.has(t);){var e=r?t:o,i=e+",0";m.has(i)||(m.add(i),I.set(t,[e,0])),o+=!r,r=!1}};for(r of M)for(var i of r.L())for(var a of i.R)e(a);var n=Mat)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(h.max(...I.keys(),0)+1,l=new Float64Array(2*n);for(let t=0;t<n;t++){e(t);var[h,f]=I.get(t);l[2*t]=h,l[2*t+1]=f}return new u(l,M)}U(){var t,r=new Set;for(t of this.N)for(var e of t.L())for(var i of e.R)r.add(i);return r}H(){return this.$((t,r)=>[t-r,t+r])}W(){var t,r,e=new Map;for(let t=0;t<this.F.length;t+=2){var i=this.F[t],o=this.F[t+1];e.set(i+","+o,[i,o])}let a=1/0,n=1/0,s=256;for([t,r]of e.values())for(a=Math.min(t,a),n=Math.min(r,n);(t%s!=0||r%s!=0)&&s>1/256;)s/=2;let l;if(s<=1/256)l=1;else{l=1/s;let t=0;for(var[h,f]of e.values()){var c=(h-a+f-n)%(2*s),h=(h-a-f+n)%(2*s);t=t|(0==c?1:2)|(0==h?4:8)}5===t?l/=2:10===t&&(a-=s,l/=2)}let v=-a,d=-n;return(t,r)=>[(t+v)*l,(r+d)*l]}q(){return this.$(this.W())}B(e,i){return this.$((t,r)=>[t+e,r+i])}g(){return this.B(0,0)}$(r){var e=new Float64Array(this.F.length);for(let t=0;t<this.F.length;t+=2){var[i,o]=r(this.F[t],this.F[t+1]);e[t]=i,e[t+1]=o}var t=this.N.map(t=>t.g());return new u(e,t)}j(){var t,r=new Set;for(t of this.N)for(var e of t.L())for(var i of e.R)r.add)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART((i);var o,a=[];for(o of r){var n=this.F[2*o],s=this.F[2*o+1];a.push({V:o,x:n,y:s})}a.sort((t,r)=>t.x!==r.x?t.x-r.x:t.y!==r.y?t.y-r.y:t.V-r.V);var l,h=new Map,f=[];for(let t=0;t<a.length;t++){var{V:c,x:v,y:d}=a[t];h.set(c,t),f.push(`QUBIT_COORDS(${v}, ${d}) `+t)}for(l of this.N){var w,u=Q(l.L(),t=>{let r=t.Z.name;return(r=(r=r.startsWith("MPP:")&&!E.has(r)?"MPP":r).startsWith("SPP:")&&!E.has(r)?"SPP":r).startsWith("SPP_DAG:")&&!E.has(r)&&(r="SPP_DAG"),0<t.Y.length&&(r+="("+[...t.Y].join(",")+")"),r}),X=[...u.keys()];X.sort((t,r)=>{var e=t.startsWith("MARK")||t.startsWith("POLY"),i=r.startsWith("MARK")||r.startsWith("POLY");return e!==i?e<i?-1:1:t<r?-1:r<t?1:0});for(w of X){var Z=u.get(w),Y=[],R=w.split("(")[0],y=E.get(R);if(void 0!==y||"MPP"!==R&&"SPP"!==R&&"SPP_DAG"!==R){if(void 0!==y&&y.o){var M,I=[];for(M of Z)I.push(...M.R);Y.push(I)}else for(var m of Z)Y.push([...m.R]);for(var p of Y){var b,A=[w];for(b of p)A.push(h.get(b));f.push(A.join(" "))}}else{var k,_=[R+" "];for(k of Z){var S=k.Z.name.substring(4);)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(for(let t=0;t<k.R.length;t++)_.push(S[t]+h.get(k.R[t])),_.push("*");_.pop(),_.push(" ")}f.push(_.join("").trim())}}f.push("TICK")}for(;0<f.length&&"TICK"===f[f.length-1];)f.pop();return f.join("\n")}J(t){var r,e,i=this.tt(),o=[];for([r,e]of t){var a=r+","+e;i.has(a)||(i.set(a,i.size),o.push(r,e))}return new u(new Float64Array([...this.F,...o]),this.N.map(t=>t.g()))}tt(){var r=new Map;for(let t=0;t<this.F.length;t+=2){var e=this.F[t],i=this.F[t+1];r.set(e+","+i,t/2)}return r}toString(){return this.j()}rt(t){return t instanceof u&&this.j()===t.j()}}function X(t,r){if(t===r||j(t)&&j(r))return!0;var e,i=function(t,r){if(!Z(t)&&void 0!==t.constructor&&t.constructor.prototype.hasOwnProperty("rt"))return t.rt(r);if(!Z(r)&&void 0!==r.constructor&&r.constructor.prototype.hasOwnProperty("rt"))return r.rt(t)}(t,r);if(void 0!==i)return i;if(Z(t)||Z(r)||t.constructor.name!==r.constructor.name)return!1;if(t instanceof Map){var o,a,i=t,n=r;if(i.size!==n.size)return!1;for([o,a]of i){if(!n.has(o))return!1;o=n.get(o);if(!X(a,o)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART())return!1}return!0}if(t instanceof Set)return V(t,r);if(e=t,Array.isArray(e)||!B.every(t=>!(e instanceof t))){var s=t,l=r;if(s.length!==l.length)return!1;for(let t=0;t<s.length;t++)if(!X(s[t],l[t]))return!1;return!0}var h,f=t,c=r;if(!V(i=J(f),J(c)))return!1;for(h of i)if(h!==Symbol.iterator&&!X(f[h],c[h]))return!1;i=void 0!==f[Symbol.iterator],t=void 0!==c[Symbol.iterator];return i==t&&!(i&&t&&!function(t,r){var e=r[Symbol.iterator]();for(var i of t){var o=e.next();if(o.done||!X(i,o.value))return}return e.next().done}(f,c))}const B=[Float32Array,Float64Array,Int8Array,Int16Array,Int32Array,Uint8Array,Uint16Array,Uint32Array,Uint8ClampedArray];function j(t){return"number"==typeof t&&isNaN(t)}function Z(t){return null==t||"string"==typeof t||"number"==typeof t||"boolean"==typeof t}function V(t,r){if(t.size!==r.size)return!1;for(var e of t)if(!r.has(e))return!1;return!0}function J(t){var r,e=new Set;for(r in t)t.hasOwnProperty(r)&&e.add(r);return e}class tt{constructor(t,r,e,i,o,a){this.et=t,this.it=r,this.altK)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(ey=e,this.shiftKey=a,this.ctrlKey=i,this.metaKey=o}rt(t){return t instanceof tt&&this.et===t.et&&X(this.it,t.it)&&this.altKey===t.altKey&&this.shiftKey===t.shiftKey&&this.ctrlKey===t.ctrlKey&&this.metaKey===t.metaKey}toString(){return`ChordEvent(
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(    inProgress=${this.et},
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(    chord=${A(this.it)},
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(    altKey=${this.altKey},
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(    shiftKey=${this.shiftKey},
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(    ctrlKey=${this.ctrlKey},
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(    metaKey=${this.metaKey},
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART()`}}const rt=new Set(["alt","shift","control","meta"]);class et{constructor(){this.ot=new Set,this.nt=new Set,this.st=new Set,this.lt=[]}ht(t){return new tt(t,new Set(this.st),this.ot.has("alt"),this.ot.has("control"),this.ot.has("meta"),this.ot.has("shift"))}ft(t){this.lt.push(this.ht(t))}ct(){this.nt.clear(),this.st.clear(),this.ot.clear()}vt(t){var r,e,i=t.key.toLowerCase();if("escape"===i&&this.ct(),"keydown"===t.type){for([r,e]of[[t.altKey,"alt"],[t.shiftKey,"shift"],[t.ctrlKey,"control"],[t.metaKey,"meta"]])r?this.ot.add(e):this.ot.delete(e);rt.has(i)||(this.nt.add(i),this.st.add(i)),this.ft(!0)}else{if("keyup"!==t.type)throw new Error("Not a recognized key event type: "+t.type);rt.has(i)||(this.nt.delete(i),this.ft(0<this.nt.size),0===this.nt.size&&(this.ot.clear(),this.st.clear()))}}}class it{constructor(t,r,e=0,i=!1){this.action=t,this.dt=r,this.wt=e,this.ut=i,this.Xt="idle",this.Zt=-1/0}Yt(){var t=this.dt-(performance.now()-this.Zt);if(0<t)this.Rt(t);else{this.Xt="running";t=performance.now();try{th)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(is.action()}finally{t=performance.now()-t;this.Zt=performance.now()+t*this.wt,"running-and-triggered"===this.Xt?this.Rt(this.dt):this.Xt="idle"}}}yt(){switch(this.Xt){case"idle":this.Yt();break;case"waiting":break;case"running":this.Xt="running-and-triggered";break;case"running-and-triggered":break;default:throw new Error("Unrecognized throttle state: "+this.Xt)}}Rt(e){if(this.Xt="waiting",this.ut){let t,r=performance.now();(t=()=>{performance.now()<r+e?requestAnimationFrame(t):(this.Xt="idle",this.Zt=-1/0,this.yt())})()}else setTimeout(()=>{this.Xt="idle",this.Zt=-1/0,this.yt()},e)}}class i{constructor(t){this.Mt=t}subscribe(t){return this.Mt(t)}static of(...e){return new i(t=>{for(var r of e)t(r);return()=>{}})}It(){let r=[];return this.subscribe(t=>r.push(t))(),r}map(e){return new i(r=>this.subscribe(t=>r(e(t))))}filter(e){return new i(r=>this.subscribe(t=>{e(t)&&r(t)}))}bt(s,l){return new i(r=>{let e=!1,i=!1,o,a,t=this.subscribe(t=>{o=t,e=!0,i&&r(l(o,a))}),n=s.subscribe(t=>{a=t,i=!0,e&&r(l(o,a))});return()CRUMBLE_PART");
    result.append(R"CRUMBLE_PART()=>{t(),n()}})}static At(){return new i(t=>{let r,e=!1;return(r=()=>{e||(t(void 0),window.requestAnimationFrame(r))})(),()=>{e=!0}})}kt(){return new i(e=>{let i=()=>{},o=!1,t=this.subscribe(t=>{var r;o||(r=i,i=t.subscribe(e),r())});return()=>{o=!0,i(),t()}})}_t(r){return this.map(t=>(r(t),t))}St(){return new i(r=>{let e=[];return e.push(this.subscribe(t=>e.push(t.subscribe(r)))),()=>{for(var t of e)t()}})}Et(a){return new i(t=>{let r=void 0,e=!1,i=new it(()=>{e||t(r)},a),o=this.subscribe(t=>{r=t,i.yt()});return()=>{e=!0,o()}})}static gt(r,e){return new i(t=>(r.addEventListener(e,t),()=>r.removeEventListener(e,t)))}Ct(t){return new i(r=>{let e=t;return this.subscribe(t=>{0<e?--e:r(t)})})}Pt(t=void 0){let o=t||((t,r)=>t===r);return new i(r=>{let e=!1,i=void 0;return this.subscribe(t=>{e&&o(i,t)||(i=t,e=!0,r(t))})})}}class ot{constructor(){this.Ot=[],this.Tt=new i(t=>{this.Ot.push(t);let r=!1;return()=>{r||(r=!0,this.Ot.splice(this.Ot.indexOf(t),1))}})}Dt(){return this.Tt}send(t){for(var r of this.Ot)r(t)}}class)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART( at{constructor(t=void 0){this.xt=t,this.Gt=new ot,this.Tt=new i(t=>(t(this.xt),this.Gt.Dt().subscribe(t)))}Dt(){return this.Tt}set(t){this.xt=t,this.Gt.send(t)}get(){return this.xt}}class r{constructor(t,r,e){if(r<0||r>=t.length)throw new Error("Bad index: "+{history:t,index:r,Lt:e});if(!Array.isArray(t))throw new Error("Bad history: "+{history:t,index:r,Lt:e});this.history=t,this.index=r,this.Lt=e,this.Qt=new ot,this.Ft=new at(this.history[this.index])}Nt(){return this.Qt.Dt()}Kt(){return this.Ft.Dt()}Ut(){return this.Ft.get()}static Ht(t){return new r([t],0,!1)}zt(){return 0===this.index&&!this.Lt}$t(){return this.index===this.history.length-1}clear(t){this.history=[t],this.index=0,this.Lt=!1,this.Ft.set(t),this.Qt.send(t)}Wt(){this.Lt=!0,this.Qt.send(void 0)}qt(){this.Lt=!1;var t=this.history[this.index];return this.Ft.set(t),this.Qt.send(t),t}commit(t){t===this.history[this.index]?this.qt():(this.Lt=!1,this.index+=1,this.history.splice(this.index,this.history.length-this.index),this.history.push(t),this.)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(Ft.set(t),this.Qt.send(t))}Bt(){if(!this.Lt){if(0===this.index)return;--this.index}this.Lt=!1;var t=this.history[this.index];return this.Ft.set(t),this.Qt.send(t),t}jt(){var t;if(this.index+1!==this.history.length)return this.index+=1,this.Lt=!1,t=this.history[this.index],this.Ft.set(t),this.Qt.send(t),t}toString(){return"Revision("+A({index:this.index,count:this.history.length,Vt:this.Lt,head:this.history[this.index]})+")"}rt(t){return t instanceof r&&this.index===t.index&&this.Lt===t.Lt&&X(this.history,t.history)}}let lt=32;function ht(i,o,a,n){var t,r=i.canvas.width/2,e=o.Jt();e.sort((t,r)=>{var[t,e]=n(t),[r,i]=n(r);return e!==i?e-i:t-r});let s=new Map,l=void 0,h=0,f=0,c=0,v=0;for(t of e){var[D,d]=n(t);f+=lt,l!==d?(l=d,h=1.5*r,c=Math.max(c,v),v=0,f+=.25*lt):(h+=.25*nt,v++),s.set(D+","+d,[h,f])}let w=lt+nt*c*.25,u=(t,r)=>{var[t,e]=n(t);return[t,e,r]=[[t,e,r]][0],t=t+","+e,s.has(t)?([e,t]=s.get(t),[e+(r-o.tr)*w,t]):[void 0,void 0]};var X=Math.floor(i.canvas.width/4/w),Z=Math.max(0,o.tr-X+1),Y=o.tr+X+2;i.save)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(();try{i.clearRect(r,0,r,i.canvas.height);for(let t=0;t<a.length;t++)if(t<4){R=void 0;y=void 0;M=void 0;I=void 0;m=void 0;x=void 0;G=void 0;E=void 0;g=void 0;C=void 0;p=void 0;b=void 0;P=void 0;O=void 0;A=void 0;L=void 0;Q=void 0;F=void 0;N=void 0;k=void 0;_=void 0;S=void 0;var R=i;var y=u;var M=a[t];var I=t;var m=Z;var x=Y;var G=w;let r,e;e=G,0===I?r=10:1===I?r=5:2===I?r=0:3===I&&(r=-5);for(let t=m;t<=x;t++){var p,b,A,k,_,S,E=M.rr(t);for([p,b]of E.er.entries()){var[g,C]=y(p,t);if(void 0!==g&&void 0!==C){if("X"===b)R.fillStyle="red";else if("Y"===b)R.fillStyle="green";else{if("Z"!==b)throw new Error("Not a pauli: "+b);R.fillStyle="blue"}R.fillRect(+g,C-r,e,5)}}for(A of E.ir){var[P,O]=y(A,t-.5);void 0!==P&&void 0!==O&&(R.fillStyle="magenta",R.fillRect(+P-8,O-r-8,e+16,21),R.fillStyle="black",R.fillRect(+P,O-r,e,5))}for({ar:k,nr:_,color:S}of E.sr){var[L,Q]=y(k,t),[F,N]=y(_,t);"X"===S?R.strokeStyle="red":"Y"===S?R.strokeStyle="green":"Z"===S?R.strokeStyle="blue":R.strokeStyle="magenta",R.lineWidth=8,st(R,L,Q,F,N))CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(,R.lineWidth=1}}}i.globalAlpha*=.5,i.fillStyle="black",i.fillRect(1.5*r-1.3*nt,0,w,i.canvas.height),i.globalAlpha*=2,i.strokeStyle="black",i.fillStyle="black";for(var K of e){var[U,H]=u(K,Z-1),[z,$]=u(K,Y+1);i.beginPath(),i.moveTo(U,H),i.lineTo(z,$),i.stroke()}i.textAlign="right",i.textBaseline="middle";for(var T of e){var[W,q]=u(T,Z-1),B=o.lr.F[2*T],j=o.lr.F[2*T+1];i.fillText(B+`,${j}:`,W,q)}for(let r=Z;r<=Y;r++){var V=t=>u(t,r),J=o.lr.N[r];if(void 0!==J)for(var tt of J.L())tt.I(V,i)}i.globalAlpha=.25,i.setLineDash([1,1]);let t=0;for(var rt of e)t=Math.max(t,n(rt)[0]);for(var et of e){var[it,ot]=u(et,Z-1),[,at]=n(et);i.beginPath(),i.moveTo(it,ot),i.lineTo(t+.25,at),i.stroke()}}finally{i.restore()}}class ft{constructor(t,r,e){this.er=t,this.ir=r,this.sr=e}}class ct{constructor(t){this.hr=t}rr(t){let r=this.hr.get(t);return r=void 0===r?new ft(new Map,new Set,[]):r}static cr(r,e){var i=new ct(new Map);let o=new Map;for(let t=0;t<r.N.length;t++){var a,n=r.N[t],s=o,l=(o=n.O(o,e),new Set);for(a of[...o.keys()]){v)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(ar h=o.get(a);h.startsWith("ERR:")&&(l.add(a),o.set(a,h.substring(4))),"I"===o.get(a)&&o.delete(a)}var f,c=[];for(f of n.L())if(2===f.Z.t&&!f.Z.i){var v,[d,w]=f.R,u=new Set;for(v of f.R){var X=o.get(v),Z=s.get(v);X!==Z&&(void 0!==X&&u.add(X),void 0!==Z)&&u.add(Z)}if(0<u.size){let t="I";1===u.size&&(t=[...u][0]),c.push({ar:d,nr:w,color:t})}}(0<o.size||0<l.size||0<c.size)&&i.hr.set(t,new ft(o,l,c))}return i}}const H=-d+Math.floor(d/4)+.5,z=-d+Math.floor(d/4)+.5;function vt(t,r){var e,i,o,a;return void 0!==t&&void 0!==r&&(e=t/d,i=r/d,e=Math.floor(2*e+.5)/2,i=Math.floor(2*i+.5)/2,o=e*d,a=i*d,Math.abs(o-t)<=nt)&&Math.abs(a-r)<=nt&&e%1==i%1?[e,i]:[void 0,void 0]}let dt=!0;function $(t,r){t.save();try{dt&&r()}finally{t.restore()}}function wt(x,G){let L=G.lr,r=0;for(var t of L.N)for(var e of t.S){var i=e.Z;"MARKX"!==i.name&&"MARKY"!==i.name&&"MARKZ"!==i.name||(r=Math.max(r,e.Y[0]+1))}let Q=(t,r)=>[t*d-H,r*d-z],F=t=>{var r=L.F[2*t],t=L.F[2*t+1];return Q(r,t)},N=[];for(let t=0;t<r;t++)N.push(ct.cr(L,t));let K=new Set;f)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(or(var o of L.U()){var a=L.F[2*o],o=L.F[2*o+1];K.add(a+","+o)}$(x,()=>{x.fillStyle="white",x.clearRect(0,0,x.canvas.width,x.canvas.height);var[t,r]=vt(G.vr,G.dr);let e=G.tr;for(let t=0;t<=G.tr;t++)for(var D of L.N[t].S)if("POLYGON"===D.Z.name){e=t;break}var i,o,a=[...L.N[e].S];a.sort((t,r)=>r.R.length-t.R.length);for(i of a)"POLYGON"===i.Z.name&&i.I(F,x);$(x,()=>{L.U();x.strokeStyle="black";for(let r=0;r<100;r+=.5)for(let t=r%1;t<100;t+=1){var[e,i]=Q(r,t),o=(r%1==.5?x.fillStyle="pink":x.fillStyle="white",!K.has(r+","+t));o&&(x.globalAlpha*=.25),x.fillRect(e-nt,i-nt,2*nt,2*nt),x.strokeRect(e-nt,i-nt,2*nt,2*nt),o&&(x.globalAlpha*=4)}});for(let t=0;t<N.length;t++){v=c=f=w=d=h=l=s=n=void 0;var n=x,s=G,l=F,h=N[t];if(t,void 0!==(h=h.rr(s.tr).sr))for(var{ar:f,nr:c,color:v}of h){var[f,d]=l(f),[c,w]=l(c);"X"===v?n.strokeStyle="red":"Y"===v?n.strokeStyle="green":"Z"===v?n.strokeStyle="blue":n.strokeStyle="magenta",n.lineWidth=8,st(n,f,d,c,w),n.lineWidth=1}}for(o of L.N[G.tr].L())"POLYGON"!==o.Z.name&&o.I(F,x);$(x,()=>{)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(x.globalAlpha*=.25;for(var[t,r]of G.wr.values()){var[t,r]=Q(t,r);x.fillStyle="yellow",x.fillRect(t-1.25*nt,r-1.25*nt,2.5*nt,2.5*nt)}}),$(x,()=>{x.globalAlpha*=.5;for(var[t,r]of G.ur.values()){var[t,r]=Q(t,r);x.fillStyle="blue",x.fillRect(t-1.25*nt,r-1.25*nt,2.5*nt,2.5*nt)}});for(let t=0;t<N.length;t++){Z=T=O=P=C=g=S=_=E=X=u=k=A=b=p=m=I=M=y=R=Y=void 0;var u,X,Z,Y=x,R=G,y=F,M=N[t],I=t,{dx:m,dy:p,m:b,p:A}=U(I),k=[];for([u,X]of M.rr(R.tr).er.entries())k.push([X,y(u)]);if(0<k.length){k.every(t=>"X"===t[0])?Y.fillStyle="red":k.every(t=>"Y"===t[0])?Y.fillStyle="green":k.every(t=>"Z"===t[0])?Y.fillStyle="blue":Y.fillStyle="black",Y.strokeStyle=Y.fillStyle;var _,S,E=k.map(t=>t[1]);let n=0,s=0;for([_,S]of E)n+=_,s+=S;n/=E.length,s/=E.length,E.sort((t,r)=>{var[t,e]=t,[r,i]=r;let o=Math.atan2(e-s,t-n),a=Math.atan2(i-s,r-n);return t===n&&e===s&&(o=-100),r===n&&i===s&&(a=-100),o-a}),W(Y,E),Y.globalAlpha*=.25,Y.fill(),Y.globalAlpha*=4,Y.lineWidth=3,Y.stroke(),Y.lineWidth=1}if(I<4)for(var[g,[C,P]]of k){if("X"===g)Y.fillStyle)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(="red";else if("Y"===g)Y.fillStyle="green";else{if("Z"!==g)throw new Error("Not a pauli: "+g);Y.fillStyle="blue"}Y.fillRect(C-m,P-p,b,A)}for(Z of M.rr(R.tr).ir){var[O,T]=y(Z);Y.fillStyle="magenta",Y.fillRect(O-m-8,T-p-8,b+16,A+16),Y.fillStyle="black",Y.fillRect(O-m,T-p,b,A)}}void 0!==t&&(x.save(),x.globalAlpha*=.5,[a,t]=Q(t,r),x.fillStyle="red",x.fillRect(a-nt,t-nt,2*nt,2*nt),x.restore()),$(x,()=>{var t,r,e,i,o,a;x.globalAlpha*=.25,x.fillStyle="blue",void 0!==G.Xr&&void 0!==G.vr&&(t=Math.min(G.vr,G.Xr),r=Math.max(G.vr,G.Xr),e=Math.min(G.dr,G.Zr),i=Math.max(G.dr,G.Zr),--t,r+=1,--e,i+=1,t-=H,r-=H,e-=z,i-=z,x.fillRect(t,e,r-t,i-e));for([o,a]of G.Yr){var[n,s]=Q(o,a);x.fillRect(n-nt,s-nt,2*nt,2*nt)}})}),x.save();try{x.strokeStyle="black";for(let r=0;r<L.N.length;r++){var n=!N.every(t=>0===t.rr(r).ir.size);r===G.tr?x.fillStyle="red":(n&&(x.fillStyle="magenta",x.fillRect(-2,5*r-2,14,8)),x.fillStyle="black"),x.fillRect(0,5*r,10,4)}}finally{x.restore()}ht(x,G,N,F)}class ut{constructor(t,r,e,i,o,a,n,s,l){for(this.lr=t.)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(g(),this.tr=r,this.ur=new Map(e.entries()),this.wr=new Map(i.entries()),this.vr=o,this.dr=a,this.Xr=n,this.Zr=s,this.Yr=[...l];this.lr.N.length<=this.tr;)this.lr.N.push(new b)}Rr(){return this.lr.U()}Jt(){let r=this.Rr();var t=[];if(0<this.wr.size){var e,i=this.lr.tt();for(e of this.wr.keys()){var o=i.get(e);void 0!==o&&t.push(o)}}else t.push(...r.values());return t.filter(t=>r.has(t))}}function Xt(r){let e=[1,0],i=[0,1];var o=(t,r)=>[t-r,t+r];r=(r%8+8)%8;for(let t=0;t<r;t++)e=o(e[0],e[1]),i=o(i[0],i[1]);return(t,r)=>[e[0]*t+i[0]*r,e[1]*t+i[1]*r]}function Zt(){try{return window.self===window.top}catch(t){}}class Yt{constructor(){this.yr=!1,this.Mr=void 0}Ir(){this.Mr={mr:!0}}pr(t){this.Mr=t}br(){this.Mr=void 0}Ar(t,r){if(!r.startsWith("#"))throw new Error('"Expected a hash URL: '+{kr:t,_r:r});if(Zt()&&this.Mr!==t)if(this.yr)document.location.hash=r;else try{void 0===this.Mr?history.replaceState(t,"",r):(history.pushState(t,"",r),this.Mr=void 0)}catch(t){console.warn("Calling 'history.replaceState/pushState' f)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(ailed. Falling back to setting location.hash.",t),this.yr=!0,document.location.hash=r}}}function Rt(t){return"#circuit="+(t=-1===(t=t.replaceAll("QUBIT_COORDS","Q").replaceAll(", ",",").replaceAll(") ",")").replaceAll(" ","_").replaceAll("\n",";")).indexOf("%")&&-1===t.indexOf("&")?t:encodeURIComponent(t))}let c=document.getElementById("toolbox"),Y=10.5,R=["H","S","R","M","C","W","SC","MC","P","1","2","3","4"],yt=[1,2,2,2,1,2,2,2,-1,-1,-1,-1,-1];let Mt=function(){var r=new Map([["0,0",E.get("H_YZ")],["0,1",E.get("H")],["0,2",E.get("H_XY")],["1,0",E.get("SQRT_X")],["1,1",E.get("SQRT_Y")],["1,2",E.get("S")],["2,0",E.get("RX")],["2,1",E.get("RY")],["2,2",E.get("R")],["3,0",E.get("MX")],["3,1",E.get("MY")],["3,2",E.get("M")],["4,0",E.get("CX")],["4,1",E.get("CY")],["4,2",E.get("CZ")],["5,0",E.get("CXSWAP")],["5,1",E.get("SWAP")],["5,2",E.get("CZSWAP")],["6,0",E.get("SQRT_XX")],["6,1",E.get("SQRT_YY")],["6,2",E.get("SQRT_ZZ")],["7,0",E.get("MXX")],["7,1",E.get("MYY")],["7,2",E.get("MZZ")]]);let e=9;for(let t=0;t<4)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(;t++)r.set(e+",0",E.get("MARKX").X(t)),r.set(e+",1",E.get("MARKY").X(t)),r.set(e+",2",E.get("MARKZ").X(t)),r.set(e+",-1",E.get("MARK").X(t)),e+=1;return r}();function It(t){var r,e=function(t){var r,e;if(!t.ctrlKey)return r=+t.it.has("x"),e=+t.it.has("y"),t=+t.it.has("z"),r&&!e&&!t||!r&&e&&t?{Sr:0,strength:Math.max(r,Math.min(e,t))}:!r&&e&&!t||r&&!e&&t?{Sr:1,strength:Math.max(e,Math.min(r,t))}:!r&&!e&&t||r&&e&&!t?{Sr:2,strength:Math.max(t,Math.min(r,e))}:void 0}(t),t=function(i){if(!i.ctrlKey){let e=void 0;for(let r=0;r<R.length;r++){let t=0;for(var o of R[r].toLowerCase())t+=i.it.has(o.toLowerCase());t===R[r].length&&(void 0===e||t>=e.strength)&&(e={Er:r,strength:t/R[r].length})}return e}}(t);let i=e,o=(void 0!==t&&void 0===e&&(r=yt[t.Er],i=void 0===r?void 0:{strength:0,Sr:r}),void 0);return void 0!==i&&void 0!==t&&(r=t.Er+","+i.Sr,Mt.has(r))&&(o=Mt.get(r)),{gr:e,Cr:i,Pr:t,Or:o}}const e=-d+Math.floor(d/4)+.5,o=-d+Math.floor(d/4)+.5;var t=document.getElementById("btnUndo"),mt=document.getElementById("btnRedo")CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(),pt=document.getElementById("btnClearMarkers");const bt=document.getElementById("btnShowHideImportExport");var At=document.getElementById("btnNextLayer"),kt=document.getElementById("btnPrevLayer"),_t=document.getElementById("btnRotate45"),St=document.getElementById("btnRotate45Counter"),M=document.getElementById("btnExport"),Et=document.getElementById("btnImport"),gt=document.getElementById("clear");const I=document.getElementById("txtStimCircuit");var Ct=document.getElementById("btnTimelineFocus"),Pt=document.getElementById("btnClearTimelineFocus"),Ot=document.getElementById("btnClearSelectedMarkers");I.addEventListener("keyup",t=>t.stopPropagation()),I.addEventListener("keydown",t=>t.stopPropagation());let m=new class{constructor(t){this.rev=r.Ht(""),this.canvas=t,this.dr=void 0,this.vr=void 0,this.Tr=new et,this.tr=0,this.ur=new Map,this.wr=new Map,this.Xr=void 0,this.Zr=void 0,this.Dr=new at(this.Gr(void 0))}Lr(){for(var t=u.K(this.rev.Ut());t.N.length<=this.tr;)t.N.push(new b);return t}Qr(){this.ur.clea)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(r(),this.Fr()}Nr(t){var r,e=this.Lr(),i=e.tt();for(r of this.ur.keys()){var o=i.get(r);void 0!==o&&e.N[this.tr].D(o)}this.Kr(e,t)}Ur(t){var r=this.Lr();r.N.splice(this.tr,1),this.Kr(r,t)}Hr(t){var r=this.Lr();r.N.splice(this.tr,0,new b),this.Kr(r,t)}Bt(){this.rev.Bt()}jt(){this.rev.jt()}Kr(t,r){r?this.zr(t):this.commit(t)}commit(t){for(;0<t.N.length&&t.N[t.N.length-1].T();)t.N.pop();this.rev.commit(t.j())}zr(t){this.rev.Wt(),this.Dr.set(this.Gr(t))}Gr(t){return void 0===t&&(t=this.Lr()),new ut(t,this.tr,this.ur,this.wr,this.vr,this.dr,this.Xr,this.Zr,this.$r(this.Tr.ot.has("alt")))}Fr(){var t=this.Dr.get().lr;this.Dr.set(this.Gr(t))}Wr(){this.commit(new u(new Float64Array([]),[]))}qr(){var t,r=this.Lr();for(t of r.N)t.S=t.S.filter(t=>"MARKX"!==t.Z.name&&"MARKY"!==t.Z.name&&"MARKZ"!==t.Z.name);this.commit(r)}$r(i){var t=this.vr,r=this.dr,o=this.Xr,a=this.Zr,n=[];if(void 0!==t&&void 0!==o){var[s,l]=vt(o,a),h=Math.min(t,o),f=Math.max(t,o),c=Math.min(r,a),v=Math.max(r,a),t=d/4-nt;h+=t,f-=t,c+=t,v-=t,h=Math.floor()CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(2*h/d+.5)/2,f=Math.floor(2*f/d+.5)/2,c=Math.floor(2*c/d+.5)/2,v=Math.floor(2*v/d+.5)/2;let e=1;h!=f&&c!=v||(e=2);for(let r=h;r<=f;r+=.5)for(let t=c;t<=v;t+=.5)r%1!=t%1||i&&(s%e!=r%e||l%e!=t%e)||n.push([r,t])}return n}Br(o,t){let r=this.Lr();var e;r=r.$(o),t||(this.wr=(e=t=>{var r,e,i=new Map;for([r,e]of t.values())[r,e]=o(r,e),i.set(r+","+e,[r,e]);return i})(this.wr),this.ur=e(this.ur)),this.Kr(r,t)}jr(t,r){let e=Xt(t),i=this.Lr().$(e).W();this.Br((t,r)=>([t,r]=e(t,r),i(t,r)),r)}Vr(t){this.tr=Math.max(t,0),this.Fr()}Jr(t,r,e){r||e||this.ur.clear();for(var[i,o]of t){var a=i+","+o;e&&this.ur.has(a)?this.ur.delete(a):this.ur.set(a,[i,o])}this.Fr()}te(t){var r,e=new Map,i=this.Lr().N[this.tr];for(r of[...t]){var o=i._.get(r);if(void 0!==o)if("RX"===o.Z.name||"MX"===o.Z.name||"MRX"===o.Z.name)e.set(r,"X");else if("RY"===o.Z.name||"MY"===o.Z.name||"MRY"===o.Z.name)e.set(r,"Y");else if("R"===o.Z.name||"M"===o.Z.name||"MR"===o.Z.name)e.set(r,"Z");else if("MXX"===o.Z.name||"MYY"===o.Z.name||"MZZ"===o.Z.name){var a,n=o)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(.Z.name[1];for(a of o.R)e.set(a,n)}else if(o.Z.name.startsWith("MPP:")&&void 0===o.Z.l&&o.R.length===o.Z.name.length-1){var s=o.Z.name.substring(4);for(let t=0;t<o.R.length;t++){var l=o.R[t];e.set(l,s[t])}}}return e}re(t,r){var e,i=this.Lr().J(this.ur.values()),o=i.tt(),a=new Set;for(e of this.ur.keys())a.add(o.get(e));var n,s=this.te(a);for(n of s.keys())a.add(n);var l=new Set(s.values());l.delete(void 0);let h;h=1===l.size?[...l][0]:"Z";var f,c=i.N[this.tr];for(f of a){let t=s.get(f);void 0===t&&(t=h);var v=E.get("MARK"+t).X(r);c.put(new p(v,new Float32Array([r]),new Uint32Array([f])))}this.Kr(i,t)}ee(t){var r,e,i,o=this.Lr().J(this.ur.values()),a=o.tt(),n=new Set;for(r of this.ur.keys())n.add(a.get(r));for(e of this.te(n).keys())n.add(e);for(i of n)void 0!==i&&o.N[this.tr].G(i);this.Kr(o,t)}ie(t,r,e){var i,o=this.Lr().J(this.ur.values()),a=o.tt();for(i of this.ur.keys())o.N[this.tr].put(new p(r,new Float32Array(e),new Uint32Array([a.get(i)])));this.Kr(o,t)}oe(t,r,e){let i=this.Lr();var[o,a]=vt(this.vr,this)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(.dr),[n,s]=y(this.ur.values()),l=[];if(void 0===o||void 0===n||this.ur.has(o+","+a)){if(2===this.ur.size)for(var[h,f]of this.ur.values())l.push([h,f])}else{var c,v,d=o-n,w=a-s;for([c,v]of this.ur.values())l.push([c,v]),l.push([c+d,v+w])}if(0<l.length){var u=(i=i.J(l)).tt();for(let t=0;t<l.length;t+=2){var[X,Z]=l[t],[Y,R]=l[t+1],X=u.get(X+","+Z),Z=u.get(Y+","+R);i.N[this.tr].put(new p(r,new Float32Array(e),new Uint32Array([X,Z])))}}this.Kr(i,t)}ae(t,r,e){if(0!==this.ur.size){var i,n=[];let o=0,a=0;for(i of this.ur.values())n.push(i),o+=i[0],a+=i[1];o/=n.length,a/=n.length,n.sort((t,r)=>{var[t,e]=t,[r,i]=r;return Math.atan2(e-a,t-o)-Math.atan2(i-a,r-o)});var s=this.Lr().J(this.ur.values()),l=s.tt(),h=new Uint32Array(this.ur.size);for(let t=0;t<n.length;t++){var[f,c]=n[t];h[t]=l.get(f+","+c)}s.N[this.tr].put(new p(r,new Float32Array(e),h)),this.Kr(s,t)}}ne(t,r,e=void 0){void 0===e&&(e=void 0===r.u?[]:[r.u]),1===r.t?this.ie(t,r,e):2===r.t?this.oe(t,r,e):this.ae(t,r,e)}}(document.getElementById("cvn"));function Tt)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART((){var t=m.Lr().j().replaceAll("\nPOLYGON","\n#!pragma POLYGON").replaceAll("\nMARK","\n#!pragma MARK"),r=I;r.value=t+"\n",r.focus(),r.select()}M.addEventListener("click",t=>{Tt()}),Et.addEventListener("click",t=>{var r=I.value,r=u.K(r.replaceAll("\n#!pragma ","\n"));m.commit(r)}),bt.addEventListener("click",t=>{var r=document.getElementById("divImportExport");"none"===r.style.display?(r.style.display="block",bt.textContent="Hide Import/Export",Tt()):(r.style.display="none",bt.textContent="Show Import/Export",I.value=""),setTimeout(()=>{window.scrollTo(0,0)},0)}),gt.addEventListener("click",t=>{m.Wr()}),t.addEventListener("click",t=>{m.Bt()}),Ct.addEventListener("click",t=>{m.wr=new Map(m.ur.entries()),m.Fr()}),Ot.addEventListener("click",t=>{m.ee(!1),m.Fr()}),Pt.addEventListener("click",t=>{m.wr=new Map,m.Fr()}),mt.addEventListener("click",t=>{m.jt()}),pt.addEventListener("click",t=>{m.qr()}),_t.addEventListener("click",t=>{m.jr(1,!1)}),St.addEventListener("click",t=>{m.jr(-1,!1)}),At.addEventListener("click)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(",t=>{m.Vr(m.tr+1)}),kt.addEventListener("click",t=>{m.Vr(m.tr-1)}),window.addEventListener("resize",t=>{m.canvas.width=m.canvas.scrollWidth,m.canvas.height=m.canvas.scrollHeight,m.Fr()}),m.canvas.addEventListener("mousemove",t=>{m.vr=t.offsetX+e,m.dr=t.offsetY+o,m.Xr-e<10&&m.vr-e<10&&1===t.buttons?(m.Vr(Math.floor(t.offsetY/5)),t.preventDefault()):m.Fr()}),m.canvas.addEventListener("mousedown",t=>{m.vr=t.offsetX+e,m.dr=t.offsetY+o,m.Xr=t.offsetX+e,m.Zr=t.offsetY+o,m.Xr-e<10&&1===t.buttons?m.Vr(Math.floor(t.offsetY/5)):m.Fr()}),m.canvas.addEventListener("mouseup",t=>{var r=m.$r(t.altKey);m.Xr=void 0,m.Zr=void 0,m.vr=t.offsetX+e,m.dr=t.offsetY+o,m.Jr(r,t.shiftKey,t.ctrlKey)});let Dt=void 0;async function xt(){let e=m.Lr();e.N=[e.N[m.tr]],0<m.ur.size&&(e.N[0]=e.N[0].P(t=>{var r=e.F[2*t],t=e.F[2*t+1];return m.ur.has(r+","+t)}),[r,t]=y(m.ur.values()),e=e.B(-r,-t));var t,r=e.j();Dt=r;try{await navigator.clipboard.writeText(r)}catch(t){console.warn("Failed to write to clipboard. Using fallback emulated clipboard.",)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(t)}}async function Gt(e){let i;try{i=await navigator.clipboard.readText()}catch(t){console.warn("Failed to read from clipboard. Using fallback emulated clipboard.",t),i=Dt}if(void 0!==i){let r=u.K(i);if(1!==r.N.length)throw new Error(i);let t=m.Lr();0<m.ur.size&&([o,a]=y(m.ur.values()),r=r.B(o,a));var o,a,n=[];for(let t=0;t<r.F.length;t+=2)n.push([r.F[t],r.F[t+1]]);var s,l,h=(t=t.J(n)).tt();for(s of m.ur.keys()){var f=h.get(s);void 0!==f&&t.N[m.tr].D(f)}for(l of r.N[0].L()){var c,v=[];for(c of l.R){var d=r.F[2*c],w=r.F[2*c+1];v.push(h.get(d+","+w))}t.N[m.tr].put(new p(l.Z,l.Y,new Uint32Array(v)))}m.Kr(t,e)}}const Lt=function(){let o=new Map;o.set("shift+t",t=>m.jr(-1,t)),o.set("t",t=>m.jr(1,t)),o.set("escape",()=>m.Qr),o.set("delete",t=>m.Nr(t)),o.set("backspace",t=>m.Nr(t)),o.set("ctrl+delete",t=>m.Ur(t)),o.set("ctrl+insert",t=>m.Hr(t)),o.set("ctrl+backspace",()=>m.Ur),o.set("ctrl+z",t=>{t||m.Bt()}),o.set("ctrl+y",t=>{t||m.jt()}),o.set("ctrl+shift+z",t=>{t||m.jt()}),o.set("ctrl+c",async t=>{await xt()}),o.se)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(t("ctrl+v",Gt),o.set("ctrl+x",async t=>{await xt(),m.Nr(t)}),o.set("l",t=>{t||(m.wr=new Map(m.ur.entries()),m.Fr())}),o.set(" ",t=>m.ee(t));for(let[t,r]of[["1",0],["2",1],["3",2],["4",3],["5",4],["6",5],["7",6],["8",7],["9",8],["0",9],["-",10],["=",11],["\\",12],["`",13]])o.set(""+t,t=>m.re(t,r)),o.set(t+"+x",t=>m.ne(t,E.get("MARKX").X(r))),o.set(t+"+y",t=>m.ne(t,E.get("MARKY").X(r))),o.set(t+"+z",t=>m.ne(t,E.get("MARKZ").X(r)));function a(t,r,e=void 0){for(var i of t){if(o.has(i))throw new Error("Chord collision: "+i);o.set(i,t=>m.ne(t,E.get(r)))}void 0!==e&&a(t.map(t=>"shift+"+t),e)}return o.set("p",t=>m.ne(t,E.get("POLYGON"),[1,0,0,.5])),o.set("alt+p",t=>m.ne(t,E.get("POLYGON"),[0,1,0,.5])),o.set("shift+p",t=>m.ne(t,E.get("POLYGON"),[0,0,1,.5])),o.set("p+x",t=>m.ne(t,E.get("POLYGON"),[1,0,0,.5])),o.set("p+y",t=>m.ne(t,E.get("POLYGON"),[0,1,0,.5])),o.set("p+z",t=>m.ne(t,E.get("POLYGON"),[0,0,1,.5])),o.set("p+x+y",t=>m.ne(t,E.get("POLYGON"),[1,1,0,.5])),o.set("p+x+z",t=>m.ne(t,E.get("POLYGON"),[1,0,1,.5])),o)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(.set("p+y+z",t=>m.ne(t,E.get("POLYGON"),[0,1,1,.5])),o.set("p+x+y+z",t=>m.ne(t,E.get("POLYGON"),[1,1,1,.5])),a(["h","h+y","h+x+z"],"H","H"),a(["h+z","h+x+y"],"H_XY","H_XY"),a(["h+x","h+y+z"],"H_YZ","H_YZ"),a(["s+x","s+y+z"],"SQRT_X","SQRT_X_DAG"),a(["s+y","s+x+z"],"SQRT_Y","SQRT_Y_DAG"),a(["s","s+z","s+x+y"],"S","S_DAG"),a(["r+x","r+y+z"],"RX"),a(["r+y","r+x+z"],"RY"),a(["r","r+z","r+x+y"],"R"),a(["m+x","m+y+z"],"MX"),a(["m+y","m+x+z"],"MY"),a(["m","m+z","m+x+y"],"M"),a(["m+r+x","m+r+y+z"],"MRX"),a(["m+r+y","m+r+x+z"],"MRY"),a(["m+r","m+r+z","m+r+x+y"],"MR"),a(["c"],"CX","CX"),a(["c+x"],"CX","CX"),a(["c+y"],"CY","CY"),a(["c+z"],"CZ","CZ"),a(["c+x+y"],"XCY","XCY"),a(["alt+c+x"],"XCX","XCX"),a(["alt+c+y"],"YCY","YCY"),a(["w"],"SWAP","SWAP"),a(["w+x"],"CXSWAP",void 0),a(["c+w+x"],"CXSWAP",void 0),a(["i+w"],"ISWAP","ISWAP_DAG"),a(["w+z"],"CZSWAP",void 0),a(["c+w+z"],"CZSWAP",void 0),a(["c+w"],"CZSWAP",void 0),a(["f"],"C_XYZ","C_ZYX"),a(["c+s+x"],"SQRT_XX","SQRT_XX_DAG"),a(["c+s+y"],"SQRT_YY","SQRT_YY_DAG"),a(["c+)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(s+z"],"SQRT_ZZ","SQRT_ZZ_DAG"),a(["c+s"],"SQRT_ZZ","SQRT_ZZ_DAG"),a(["c+m+x"],"MXX","MXX"),a(["c+m+y"],"MYY","MYY"),a(["c+m+z"],"MZZ","MZZ"),a(["c+m"],"MZZ","MZZ"),o}();function Qt(r){if(m.Tr.vt(r),"keydown"===r.type){if("q"===r.key)return void m.Vr(m.tr-1);if("e"===r.key)return void m.Vr(m.tr+1)}var t=m.Tr.lt;if(0!==t.length){for(var e=t[t.length-1];0<t.length;)t.pop();var i=[...e.it];if(0!==i.length){i.sort();let t="";e.altKey&&(t+="alt+"),e.ctrlKey&&(t+="ctrl+"),e.metaKey&&(t+="meta+"),e.shiftKey&&(t+="shift+");for(var o of i)t+=o+"+";t=t.substring(0,t.length-1);i=Lt.get(t);void 0!==i?(i(e.et),r.preventDefault()):m.zr(m.Lr())}}}document.addEventListener("keydown",Qt),document.addEventListener("keyup",Qt),m.canvas.width=m.canvas.scrollWidth,m.canvas.height=m.canvas.scrollHeight,m.rev.Nt().subscribe(()=>{m.Dr.set(m.Gr(void 0));var t=m.Tr.ht(!1),e=(c.width=c.scrollWidth,c.height=c.scrollHeight,c.getContext("2d"));e.clearRect(0,0,c.width,c.height),e.textAlign="right",e.textBaseline="middle",e.fillText("X",7.5,)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(24.5),e.fillText("Y",7.5,56.5),e.fillText("Z",7.5,88.5),e.textAlign="center",e.textBaseline="bottom";for(let t=0;t<R.length;t++)e.fillText(R[t],24.5+32*t,Y);e.fillStyle="white",e.strokeStyle="black";var i=[["H_YZ","S_X","R_X","M_X","C_X","CXSWAP","√XX","M_XX","red","X1","X1","X2","X3","X4"],["H","S_Y","R_Y","M_Y","C_Y","SWAP","√YY","M_YY","green","Y1","Y1","Y2","Y3","Y4"],["H_XY","S","R","M","C_Z","CZSWAP","√ZZ","M_ZZ","blue","Z1","Z1","Z2","Z3","Z4"]];for(let r=0;r<R.length;r++)for(let t=0;t<3;t++)e.fillRect(Y+32*r,Y+32*t,28,28),e.strokeRect(Y+32*r,Y+32*t,28,28);e.fillStyle="black";for(let r=0;r<R.length;r++)for(let t=0;t<3;t++){var o=i[t][r],a=Y+32*r+14,n=Y+32*t+14;if(-1!==o.indexOf("_")){var[s,l]=o.split("_");e.font="16pt monospace",e.textAlign="right",e.textBaseline="middle",e.fillText(s,a,n),e.font=1===l.length?"12pt monospace":"8pt monospace",e.textAlign="left",e.textBaseline="top",e.fillText(l,a,n)}else{let t=16;for(;4<t&&(e.font=t+"pt monospace",!(e.measureText(o).width<=28));)--t;e.textAlign="center")CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(,e.textBaseline="middle",e.fillText(o,a,n)}}void 0!==(t=It(t)).gr&&(e.fillStyle="rgba(255, 255, 0, "+.5*t.gr.strength+")",e.fillRect(0,Y+32*t.gr.Sr-2,Y+32*R.length,32)),void 0!==t.Pr&&(e.fillStyle="rgba(255, 255, 0, "+.5*t.Pr.strength+")",e.fillRect(Y+32*t.Pr.Er-2,0,32,106.5)),void 0!==t.Cr&&void 0!==t.Pr&&(e.fillStyle="rgba(255, 0, 0, 0.5)",e.fillRect(Y+32*t.Pr.Er-2,Y+32*t.Cr.Sr-2,32,32)),e.textAlign="left",e.textBaseline="middle",e.fillStyle="black"});{var Ft=m.rev;const k=new Yt;M=()=>{k.Ir();try{var t,r=(()=>{var t=document.location.hash.substring(1),r=new Map;if(""!==t)for(var e of t.split("&")){var i,o=e.indexOf("=");-1!==o&&(i=e.substring(0,o),e=decodeURIComponent(e.substring(o+1)),r.set(i,e))}return r})(),e=(r.has("circuit")||("[[[DEFAULT-CIRCUIT-CONTENT-LITERAL]]]"===(t=document.getElementById("txtDefaultCircuit")).value.replaceAll("_","-")?r.set("circuit",""):r.set("circuit",t.value)),k.pr(r.get("circuit")),u.K(r.get("circuit"))),i=e.j();Ft.clear(i),e.N.every(t=>t.T())&&1===r.size&&i===r.get("circui)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(t")?k.br():k.Ar(i,Rt(i))}catch(t){throw new Error(t)}},window.addEventListener("popstate",M),M(),Ft.Kt().Pt().Ct(1).subscribe(t=>{k.Ar(t,Rt(t))})}m.Dr.Dt().subscribe(t=>requestAnimationFrame(()=>wt(m.canvas.getContext("2d"),t))),window.addEventListener("focus",()=>{m.Tr.ct()}),window.addEventListener("blur",()=>{m.Tr.ct()});
)CRUMBLE_PART");
    result.append(R"CRUMBLE_PART(</script>
)CRUMBLE_PART");
    return result;
}
