"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateTags = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const crypto = require("crypto");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
class CreateTags extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { resourceIds, tags } = props;
        const removalPolicy = props.removalPolicy ?? aws_cdk_lib_1.RemovalPolicy.RETAIN;
        new custom_resources_1.AwsCustomResource(this, "CreateTags", {
            onCreate: {
                service: "EC2",
                action: "createTags",
                region: aws_cdk_lib_1.Stack.of(this).region,
                parameters: {
                    Resources: resourceIds,
                    Tags: tags.map((tag) => {
                        return { Key: tag.key, Value: tag.value };
                    }),
                },
                physicalResourceId: custom_resources_1.PhysicalResourceId.of(this.makeUniqueId(resourceIds)),
            },
            onDelete: removalPolicy != aws_cdk_lib_1.RemovalPolicy.DESTROY
                ? undefined
                : {
                    service: "EC2",
                    action: "createTags",
                    region: aws_cdk_lib_1.Stack.of(this).region,
                    parameters: {
                        Resources: resourceIds,
                        Tags: tags.map((tag) => {
                            return { Key: tag.key, Value: tag.value };
                        }),
                    },
                    physicalResourceId: custom_resources_1.PhysicalResourceId.of(this.makeUniqueId(resourceIds)),
                },
            installLatestAwsSdk: false,
            policy: custom_resources_1.AwsCustomResourcePolicy.fromSdkCalls({
                resources: custom_resources_1.AwsCustomResourcePolicy.ANY_RESOURCE,
            }),
        });
    }
    makeUniqueId(resourceIds) {
        const human = resourceIds
            .map((s) => {
            return s.replace(/[^A-Za-z0-9]/g, "");
        })
            .join("")
            .slice(0, 240);
        const md5 = crypto.createHash("md5").update(resourceIds.join("")).digest("hex");
        const hash = md5.slice(0, 8).toUpperCase();
        return human + hash;
    }
}
exports.CreateTags = CreateTags;
_a = JSII_RTTI_SYMBOL_1;
CreateTags[_a] = { fqn: "@pepperize/cdk-vpc.CreateTags", version: "0.0.264" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY3JlYXRlLXRhZ3MuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvY3JlYXRlLXRhZ3MudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSxpQ0FBaUM7QUFDakMsNkNBQW1EO0FBQ25ELG1FQUE4RztBQUM5RywyQ0FBdUM7QUF5Q3ZDLE1BQWEsVUFBVyxTQUFRLHNCQUFTO0lBQ3ZDLFlBQW1CLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQXNCO1FBQ3JFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsTUFBTSxFQUFFLFdBQVcsRUFBRSxJQUFJLEVBQUUsR0FBRyxLQUFLLENBQUM7UUFDcEMsTUFBTSxhQUFhLEdBQUcsS0FBSyxDQUFDLGFBQWEsSUFBSSwyQkFBYSxDQUFDLE1BQU0sQ0FBQztRQUVsRSxJQUFJLG9DQUFpQixDQUFDLElBQUksRUFBRSxZQUFZLEVBQUU7WUFDeEMsUUFBUSxFQUFFO2dCQUNSLE9BQU8sRUFBRSxLQUFLO2dCQUNkLE1BQU0sRUFBRSxZQUFZO2dCQUNwQixNQUFNLEVBQUUsbUJBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsTUFBTTtnQkFDN0IsVUFBVSxFQUFFO29CQUNWLFNBQVMsRUFBRSxXQUFXO29CQUN0QixJQUFJLEVBQUUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDLEdBQUcsRUFBRSxFQUFFO3dCQUNyQixPQUFPLEVBQUUsR0FBRyxFQUFFLEdBQUcsQ0FBQyxHQUFHLEVBQUUsS0FBSyxFQUFFLEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQztvQkFDNUMsQ0FBQyxDQUFDO2lCQUNIO2dCQUNELGtCQUFrQixFQUFFLHFDQUFrQixDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLFdBQVcsQ0FBQyxDQUFDO2FBQzFFO1lBQ0QsUUFBUSxFQUNOLGFBQWEsSUFBSSwyQkFBYSxDQUFDLE9BQU87Z0JBQ3BDLENBQUMsQ0FBQyxTQUFTO2dCQUNYLENBQUMsQ0FBQztvQkFDRSxPQUFPLEVBQUUsS0FBSztvQkFDZCxNQUFNLEVBQUUsWUFBWTtvQkFDcEIsTUFBTSxFQUFFLG1CQUFLLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLE1BQU07b0JBQzdCLFVBQVUsRUFBRTt3QkFDVixTQUFTLEVBQUUsV0FBVzt3QkFDdEIsSUFBSSxFQUFFLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQyxHQUFHLEVBQUUsRUFBRTs0QkFDckIsT0FBTyxFQUFFLEdBQUcsRUFBRSxHQUFHLENBQUMsR0FBRyxFQUFFLEtBQUssRUFBRSxHQUFHLENBQUMsS0FBSyxFQUFFLENBQUM7d0JBQzVDLENBQUMsQ0FBQztxQkFDSDtvQkFDRCxrQkFBa0IsRUFBRSxxQ0FBa0IsQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxXQUFXLENBQUMsQ0FBQztpQkFDMUU7WUFDUCxtQkFBbUIsRUFBRSxLQUFLO1lBQzFCLE1BQU0sRUFBRSwwQ0FBdUIsQ0FBQyxZQUFZLENBQUM7Z0JBQzNDLFNBQVMsRUFBRSwwQ0FBdUIsQ0FBQyxZQUFZO2FBQ2hELENBQUM7U0FDSCxDQUFDLENBQUM7SUFDTCxDQUFDO0lBRU8sWUFBWSxDQUFDLFdBQXFCO1FBQ3hDLE1BQU0sS0FBSyxHQUFHLFdBQVc7YUFDdEIsR0FBRyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUU7WUFDVCxPQUFPLENBQUMsQ0FBQyxPQUFPLENBQUMsZUFBZSxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQ3hDLENBQUMsQ0FBQzthQUNELElBQUksQ0FBQyxFQUFFLENBQUM7YUFDUixLQUFLLENBQUMsQ0FBQyxFQUFFLEdBQUcsQ0FBQyxDQUFDO1FBRWpCLE1BQU0sR0FBRyxHQUFHLE1BQU0sQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLENBQUMsTUFBTSxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxNQUFNLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDaEYsTUFBTSxJQUFJLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsV0FBVyxFQUFFLENBQUM7UUFFM0MsT0FBTyxLQUFLLEdBQUcsSUFBSSxDQUFDO0lBQ3RCLENBQUM7O0FBdERILGdDQXVEQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNyeXB0byBmcm9tIFwiY3J5cHRvXCI7XG5pbXBvcnQgeyBSZW1vdmFsUG9saWN5LCBTdGFjayB9IGZyb20gXCJhd3MtY2RrLWxpYlwiO1xuaW1wb3J0IHsgQXdzQ3VzdG9tUmVzb3VyY2UsIEF3c0N1c3RvbVJlc291cmNlUG9saWN5LCBQaHlzaWNhbFJlc291cmNlSWQgfSBmcm9tIFwiYXdzLWNkay1saWIvY3VzdG9tLXJlc291cmNlc1wiO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSBcImNvbnN0cnVjdHNcIjtcblxuZXhwb3J0IGludGVyZmFjZSBUYWcge1xuICAvKipcbiAgICogVGhlIGtleSBvZiB0aGUgdGFnLlxuICAgKlxuICAgKiBDb25zdHJhaW50czogVGFnIGtleXMgYXJlIGNhc2Utc2Vuc2l0aXZlIGFuZCBhY2NlcHQgYSBtYXhpbXVtIG9mIDEyNyBVbmljb2RlIGNoYXJhY3RlcnMuIE1heSBub3QgYmVnaW4gd2l0aCBhd3M6LlxuICAgKi9cbiAgcmVhZG9ubHkga2V5OiBzdHJpbmc7XG4gIC8qKlxuICAgKiBUaGUgdmFsdWUgb2YgdGhlIHRhZy5cbiAgICpcbiAgICogQ29uc3RyYWludHM6IFRhZyB2YWx1ZXMgYXJlIGNhc2Utc2Vuc2l0aXZlIGFuZCBhY2NlcHQgYSBtYXhpbXVtIG9mIDI1NiBVbmljb2RlIGNoYXJhY3RlcnMuXG4gICAqL1xuICByZWFkb25seSB2YWx1ZTogc3RyaW5nO1xufVxuXG4vKipcbiAqIEFkZHMgb3Igb3ZlcndyaXRlcyBvbmx5IHRoZSBzcGVjaWZpZWQgdGFncyBmb3IgdGhlIHNwZWNpZmllZCBBbWF6b24gRUMyIHJlc291cmNlIG9yIHJlc291cmNlcy4gV2hlbiB5b3Ugc3BlY2lmeSBhbiBleGlzdGluZyB0YWcga2V5LCB0aGUgdmFsdWUgaXMgb3ZlcndyaXR0ZW4gd2l0aCB0aGUgbmV3IHZhbHVlLiBFYWNoIHJlc291cmNlIGNhbiBoYXZlIGEgbWF4aW11bSBvZiA1MCB0YWdzLiBFYWNoIHRhZyBjb25zaXN0cyBvZiBhIGtleSBhbmQgb3B0aW9uYWwgdmFsdWUuIFRhZyBrZXlzIG11c3QgYmUgdW5pcXVlIHBlciByZXNvdXJjZS5cbiAqXG4gKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NFQzIvbGF0ZXN0L1VzZXJHdWlkZS9Vc2luZ19UYWdzLmh0bWxcbiAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0VDMi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9DcmVhdGVUYWdzLmh0bWxcbiAqXG4gKiBAZXhwZXJpbWVudGFsXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQ3JlYXRlVGFnc1Byb3BzIHtcbiAgLyoqXG4gICAqIFRoZSBJRHMgb2YgdGhlIGVjMiByZXNvdXJjZXMsIHNlcGFyYXRlZCBieSBzcGFjZXMuIENvbnN0cmFpbnRzOiBVcCB0byAxMDAwIHJlc291cmNlIElEcy4gV2UgcmVjb21tZW5kIGJyZWFraW5nIHVwIHRoaXMgcmVxdWVzdCBpbnRvIHNtYWxsZXIgYmF0Y2hlcy5cbiAgICpcbiAgICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTRUMyL2xhdGVzdC9Vc2VyR3VpZGUvVXNpbmdfVGFncy5odG1sI3RhZy1yZXNvdXJjZXNcbiAgICovXG4gIHJlYWRvbmx5IHJlc291cmNlSWRzOiBzdHJpbmdbXTtcblxuICAvKipcbiAgICogVGhlIHRhZ3MuIFRoZSB2YWx1ZSBwYXJhbWV0ZXIgaXMgcmVxdWlyZWQsIGJ1dCBpZiB5b3UgZG9uJ3Qgd2FudCB0aGUgdGFnIHRvIGhhdmUgYSB2YWx1ZSwgc3BlY2lmeSB0aGUgcGFyYW1ldGVyIHdpdGggbm8gdmFsdWUsIGFuZCB3ZSBzZXQgdGhlIHZhbHVlIHRvIGFuIGVtcHR5IHN0cmluZy5cbiAgICovXG4gIHJlYWRvbmx5IHRhZ3M6IFRhZ1tdO1xuXG4gIHJlYWRvbmx5IHJlbW92YWxQb2xpY3k/OiBSZW1vdmFsUG9saWN5O1xufVxuXG5leHBvcnQgY2xhc3MgQ3JlYXRlVGFncyBleHRlbmRzIENvbnN0cnVjdCB7XG4gIHB1YmxpYyBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQ3JlYXRlVGFnc1Byb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIGNvbnN0IHsgcmVzb3VyY2VJZHMsIHRhZ3MgfSA9IHByb3BzO1xuICAgIGNvbnN0IHJlbW92YWxQb2xpY3kgPSBwcm9wcy5yZW1vdmFsUG9saWN5ID8/IFJlbW92YWxQb2xpY3kuUkVUQUlOO1xuXG4gICAgbmV3IEF3c0N1c3RvbVJlc291cmNlKHRoaXMsIFwiQ3JlYXRlVGFnc1wiLCB7XG4gICAgICBvbkNyZWF0ZToge1xuICAgICAgICBzZXJ2aWNlOiBcIkVDMlwiLFxuICAgICAgICBhY3Rpb246IFwiY3JlYXRlVGFnc1wiLCAvLyBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTSmF2YVNjcmlwdFNESy9sYXRlc3QvQVdTL0VDMi5odG1sI2NyZWF0ZVRhZ3MtcHJvcGVydHlcbiAgICAgICAgcmVnaW9uOiBTdGFjay5vZih0aGlzKS5yZWdpb24sXG4gICAgICAgIHBhcmFtZXRlcnM6IHtcbiAgICAgICAgICBSZXNvdXJjZXM6IHJlc291cmNlSWRzLFxuICAgICAgICAgIFRhZ3M6IHRhZ3MubWFwKCh0YWcpID0+IHtcbiAgICAgICAgICAgIHJldHVybiB7IEtleTogdGFnLmtleSwgVmFsdWU6IHRhZy52YWx1ZSB9O1xuICAgICAgICAgIH0pLFxuICAgICAgICB9LFxuICAgICAgICBwaHlzaWNhbFJlc291cmNlSWQ6IFBoeXNpY2FsUmVzb3VyY2VJZC5vZih0aGlzLm1ha2VVbmlxdWVJZChyZXNvdXJjZUlkcykpLFxuICAgICAgfSxcbiAgICAgIG9uRGVsZXRlOlxuICAgICAgICByZW1vdmFsUG9saWN5ICE9IFJlbW92YWxQb2xpY3kuREVTVFJPWVxuICAgICAgICAgID8gdW5kZWZpbmVkXG4gICAgICAgICAgOiB7XG4gICAgICAgICAgICAgIHNlcnZpY2U6IFwiRUMyXCIsXG4gICAgICAgICAgICAgIGFjdGlvbjogXCJjcmVhdGVUYWdzXCIsIC8vIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NKYXZhU2NyaXB0U0RLL2xhdGVzdC9BV1MvRUMyLmh0bWwjZGVsZXRlVGFncy1wcm9wZXJ0eVxuICAgICAgICAgICAgICByZWdpb246IFN0YWNrLm9mKHRoaXMpLnJlZ2lvbixcbiAgICAgICAgICAgICAgcGFyYW1ldGVyczoge1xuICAgICAgICAgICAgICAgIFJlc291cmNlczogcmVzb3VyY2VJZHMsXG4gICAgICAgICAgICAgICAgVGFnczogdGFncy5tYXAoKHRhZykgPT4ge1xuICAgICAgICAgICAgICAgICAgcmV0dXJuIHsgS2V5OiB0YWcua2V5LCBWYWx1ZTogdGFnLnZhbHVlIH07XG4gICAgICAgICAgICAgICAgfSksXG4gICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgIHBoeXNpY2FsUmVzb3VyY2VJZDogUGh5c2ljYWxSZXNvdXJjZUlkLm9mKHRoaXMubWFrZVVuaXF1ZUlkKHJlc291cmNlSWRzKSksXG4gICAgICAgICAgICB9LFxuICAgICAgaW5zdGFsbExhdGVzdEF3c1NkazogZmFsc2UsXG4gICAgICBwb2xpY3k6IEF3c0N1c3RvbVJlc291cmNlUG9saWN5LmZyb21TZGtDYWxscyh7XG4gICAgICAgIHJlc291cmNlczogQXdzQ3VzdG9tUmVzb3VyY2VQb2xpY3kuQU5ZX1JFU09VUkNFLFxuICAgICAgfSksXG4gICAgfSk7XG4gIH1cblxuICBwcml2YXRlIG1ha2VVbmlxdWVJZChyZXNvdXJjZUlkczogc3RyaW5nW10pIHtcbiAgICBjb25zdCBodW1hbiA9IHJlc291cmNlSWRzXG4gICAgICAubWFwKChzKSA9PiB7XG4gICAgICAgIHJldHVybiBzLnJlcGxhY2UoL1teQS1aYS16MC05XS9nLCBcIlwiKTtcbiAgICAgIH0pXG4gICAgICAuam9pbihcIlwiKVxuICAgICAgLnNsaWNlKDAsIDI0MCk7XG5cbiAgICBjb25zdCBtZDUgPSBjcnlwdG8uY3JlYXRlSGFzaChcIm1kNVwiKS51cGRhdGUocmVzb3VyY2VJZHMuam9pbihcIlwiKSkuZGlnZXN0KFwiaGV4XCIpO1xuICAgIGNvbnN0IGhhc2ggPSBtZDUuc2xpY2UoMCwgOCkudG9VcHBlckNhc2UoKTtcblxuICAgIHJldHVybiBodW1hbiArIGhhc2g7XG4gIH1cbn1cbiJdfQ==