# mypy-boto3-dynamodbstreams

[![PyPI - mypy-boto3-dynamodbstreams](https://img.shields.io/pypi/v/mypy-boto3-dynamodbstreams.svg?color=blue)](https://pypi.org/project/mypy-boto3-dynamodbstreams)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-dynamodbstreams.svg?color=blue)](https://pypi.org/project/mypy-boto3-dynamodbstreams)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.DynamoDBStreams 1.13.24](https://boto3.amazonaws.com/v1/documentation/api/1.13.24/reference/services/dynamodbstreams.html#DynamoDBStreams) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 1.1.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-dynamodbstreams](#mypy-boto3-dynamodbstreams)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `DynamoDBStreams` service.

```bash
python -m pip install boto3-stubs[dynamodbstreams]

# update installed packages index
mypy_boto3
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3 import dynamodbstreams
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_dynamodbstreams as dynamodbstreams

# Use this client as usual, now mypy can check if your code is valid.
# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("dynamodbstreams")
client: dynamodbstreams.DynamoDBStreamsClient = boto3.client("dynamodbstreams")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: dynamodbstreams.DynamoDBStreamsClient = session.client("dynamodbstreams")

```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3_builder) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from the documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) for readability.