"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InsufficientDataHealthStatus = exports.AlarmHealthCheck = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const route53 = require("aws-cdk-lib/aws-route53");
const health_check_1 = require("./health-check");
const health_check_type_1 = require("./health-check-type");
/**
 * Create a Route53 HealthCheck that monitors a CloudWatch Alarm.
 *
 * <b>Example</b>
 * ```typescript
 * const alarm new Alarm(stack, "Alarm", {
 *   // ...
 * });
 * new AlarmHealthCheck(stack, "HealthCheck", {
 *   alarm: alarm,
 * });
 * ```
 * @link https://docs.aws.amazon.com/de_de/AWSCloudFormation/latest/UserGuide/aws-resource-route53-healthcheck.html#aws-resource-route53-healthcheck-properties
 *
 * @resource AWS::Route53::HealthCheck
 */
class AlarmHealthCheck extends health_check_1.HealthCheckBase {
    constructor(scope, id, props) {
        super(scope, id);
        const { alarmName, alarmArn } = props.alarm;
        // https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatch.html
        const alarmRegion = aws_cdk_lib_1.Stack.of(props.alarm).splitArn(alarmArn, aws_cdk_lib_1.ArnFormat.COLON_RESOURCE_NAME).region;
        const insufficientDataHealthStatus = props.insufficientDataHealthStatus ?? InsufficientDataHealthStatus.LAST_KNOWN_STATUS;
        const resource = new route53.CfnHealthCheck(this, "Resource", {
            healthCheckConfig: {
                alarmIdentifier: {
                    name: alarmName,
                    region: alarmRegion,
                },
                insufficientDataHealthStatus: insufficientDataHealthStatus,
                type: health_check_type_1.HealthCheckType.CLOUDWATCH_METRIC,
            },
            healthCheckTags: this.tags.renderedTags,
        });
        this.healthCheckId = resource.attrHealthCheckId;
        if (props.healthCheckName) {
            aws_cdk_lib_1.Tags.of(this).add("Name", props.healthCheckName);
        }
    }
}
exports.AlarmHealthCheck = AlarmHealthCheck;
_a = JSII_RTTI_SYMBOL_1;
AlarmHealthCheck[_a] = { fqn: "@pepperize/cdk-route53-health-check.AlarmHealthCheck", version: "0.0.425" };
var InsufficientDataHealthStatus;
(function (InsufficientDataHealthStatus) {
    /**
     * Route53 considers the health check to be healthy.
     */
    InsufficientDataHealthStatus["HEALTHY"] = "Healthy";
    /**
     * Route53 considers the health check to be unhealthy.
     */
    InsufficientDataHealthStatus["UNHEALTHY"] = "Unhealthy";
    /**
     * Route53 uses the status of the health check from the last time that CloudWatch had sufficient data to determine the alarm state, otherwise healthy
     */
    InsufficientDataHealthStatus["LAST_KNOWN_STATUS"] = "LastKnownStatus";
})(InsufficientDataHealthStatus = exports.InsufficientDataHealthStatus || (exports.InsufficientDataHealthStatus = {}));
//# sourceMappingURL=data:application/json;base64,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