# Generated by Django 4.1.8 on 2023-09-28 13:22
import django.core.validators
import django.db.models.deletion
import taggit.managers
import utilities.json
from django.conf import settings
from django.db import migrations
from django.db import models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("core", "0005_job_created_auto_now"),
        ("extras", "0092_delete_jobresult"),
        ("contenttypes", "0002_remove_content_type_name"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="IPFabricSnapshot",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("last_updated", models.DateTimeField(editable=False)),
                ("name", models.CharField(max_length=200)),
                ("snapshot_id", models.CharField(max_length=100, unique=True)),
                ("data", models.JSONField(blank=True, null=True)),
                ("date", models.DateTimeField(blank=True, editable=False, null=True)),
            ],
            options={
                "verbose_name": "IP Fabric Snapshot",
                "verbose_name_plural": "IP Fabric Snapshots",
                "ordering": ("source", "-date"),
            },
        ),
        migrations.CreateModel(
            name="IPFabricTransformMap",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "custom_field_data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=utilities.json.CustomFieldJSONEncoder,
                    ),
                ),
                ("name", models.CharField(max_length=100, unique=True)),
                ("source_model", models.CharField(max_length=50)),
                ("status", models.CharField(max_length=50, null=True)),
                (
                    "tags",
                    taggit.managers.TaggableManager(
                        through="extras.TaggedItem", to="extras.Tag"
                    ),
                ),
                (
                    "target_model",
                    models.ForeignKey(
                        limit_choices_to=models.Q(
                            models.Q(
                                models.Q(("app_label", "dcim"), ("model", "site")),
                                models.Q(
                                    ("app_label", "dcim"), ("model", "manufacturer")
                                ),
                                models.Q(("app_label", "dcim"), ("model", "platform")),
                                models.Q(
                                    ("app_label", "dcim"), ("model", "devicerole")
                                ),
                                models.Q(
                                    ("app_label", "dcim"), ("model", "devicetype")
                                ),
                                models.Q(("app_label", "dcim"), ("model", "device")),
                                models.Q(
                                    ("app_label", "dcim"), ("model", "virtualchassis")
                                ),
                                models.Q(("app_label", "dcim"), ("model", "interface")),
                                models.Q(("app_label", "ipam"), ("model", "vlan")),
                                models.Q(("app_label", "ipam"), ("model", "vrf")),
                                models.Q(("app_label", "ipam"), ("model", "prefix")),
                                models.Q(("app_label", "ipam"), ("model", "ipaddress")),
                                models.Q(
                                    ("app_label", "contenttypes"),
                                    ("model", "contenttype"),
                                ),
                                _connector="OR",
                            )
                        ),
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="contenttypes.contenttype",
                    ),
                ),
            ],
            options={
                "verbose_name": "IP Fabric Transform Map",
                "verbose_name_plural": "IP Fabric Transform Maps",
            },
        ),
        migrations.CreateModel(
            name="IPFabricTransformField",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False
                    ),
                ),
                ("source_field", models.CharField(max_length=100)),
                ("target_field", models.CharField(max_length=100)),
                ("coalesce", models.BooleanField(default=False)),
                ("template", models.TextField(blank=True, null=True)),
                (
                    "transform_map",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="field_maps",
                        to="ipfabric_netbox.ipfabrictransformmap",
                    ),
                ),
            ],
            options={
                "verbose_name": "IP Fabric Transform Field",
                "verbose_name_plural": "IP Fabric Transform Fields",
                "ordering": ("transform_map",),
            },
        ),
        migrations.CreateModel(
            name="IPFabricSync",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                ("name", models.CharField(max_length=100, unique=True)),
                ("type", models.CharField(default="dcim", max_length=50)),
                (
                    "status",
                    models.CharField(default="new", editable=False, max_length=50),
                ),
                ("parameters", models.JSONField(blank=True, null=True)),
                (
                    "last_synced",
                    models.DateTimeField(blank=True, editable=False, null=True),
                ),
                ("scheduled", models.DateTimeField(blank=True, null=True)),
                (
                    "interval",
                    models.PositiveIntegerField(
                        blank=True,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(1)],
                    ),
                ),
                (
                    "snapshot_data",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="snapshots",
                        to="ipfabric_netbox.ipfabricsnapshot",
                    ),
                ),
                (
                    "tags",
                    taggit.managers.TaggableManager(
                        through="extras.TaggedItem", to="extras.Tag"
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "IP Fabric Sync",
                "ordering": ["pk"],
            },
        ),
        migrations.CreateModel(
            name="IPFabricSource",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "custom_field_data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=utilities.json.CustomFieldJSONEncoder,
                    ),
                ),
                ("description", models.CharField(blank=True, max_length=200)),
                ("comments", models.TextField(blank=True)),
                ("name", models.CharField(max_length=100, unique=True)),
                ("url", models.CharField(max_length=200)),
                (
                    "status",
                    models.CharField(default="new", editable=False, max_length=50),
                ),
                ("parameters", models.JSONField(blank=True, null=True)),
                (
                    "last_synced",
                    models.DateTimeField(blank=True, editable=False, null=True),
                ),
                (
                    "tags",
                    taggit.managers.TaggableManager(
                        through="extras.TaggedItem", to="extras.Tag"
                    ),
                ),
            ],
            options={
                "verbose_name": "IP Fabric Source",
                "verbose_name_plural": "IP Fabric Sources",
                "ordering": ("name",),
            },
        ),
        migrations.AddField(
            model_name="ipfabricsnapshot",
            name="source",
            field=models.ForeignKey(
                editable=False,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="snapshots",
                to="ipfabric_netbox.ipfabricsource",
            ),
        ),
        migrations.CreateModel(
            name="IPFabricRelationshipField",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False
                    ),
                ),
                ("target_field", models.CharField(max_length=100)),
                ("coalesce", models.BooleanField(default=False)),
                ("template", models.TextField(blank=True, null=True)),
                (
                    "source_model",
                    models.ForeignKey(
                        limit_choices_to=models.Q(
                            models.Q(
                                ("app_label", "dcim"),
                                ("app_label", "ipam"),
                                models.Q(
                                    ("app_label", "contenttypes"),
                                    ("model", "contenttype"),
                                ),
                                _connector="OR",
                            )
                        ),
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="ipfabric_transform_fields",
                        to="contenttypes.contenttype",
                    ),
                ),
                (
                    "transform_map",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="relationship_maps",
                        to="ipfabric_netbox.ipfabrictransformmap",
                    ),
                ),
            ],
            options={
                "verbose_name": "IP Fabric Relationship Field",
                "verbose_name_plural": "IP Fabric Relationship Fields",
                "ordering": ("transform_map",),
            },
        ),
        migrations.CreateModel(
            name="IPFabricBranch",
            fields=[
                (
                    "branch_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="extras.branch",
                    ),
                ),
                (
                    "job",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="core.job",
                    ),
                ),
                (
                    "sync",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="ipfabric_netbox.ipfabricsync",
                    ),
                ),
            ],
            options={
                "verbose_name": "IP Fabric Branch",
                "verbose_name_plural": "IP Fabric Branches",
                "ordering": ("name",),
            },
            bases=("extras.branch",),
        ),
    ]
