# coding: utf-8

"""
    Rapidata.Dataset

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from rapidata.api_client.models.json_web_key_set import JsonWebKeySet
from typing import Optional, Set
from typing_extensions import Self

class ClientModel(BaseModel):
    """
    The response containing the id and secret of a dynamically registered client. Additionally, it contains all registered metadata for the client.
    """ # noqa: E501
    client_id: StrictStr = Field(description="The unique identifier for the client.")
    client_secret: Optional[StrictStr] = Field(description="The client secret for the client, which is used to authenticate the client")
    client_id_issued_at: Optional[StrictInt] = Field(description="The date and time when the client identifier was issued.")
    client_secret_expires_at: Optional[StrictInt] = Field(description="If the client has a secret, this is the date and time when the client secret expires. If the client secret does not expire, this will be 0.")
    redirect_uris: Optional[List[StrictStr]] = Field(description="Array of redirection URI strings for use in redirect-based flows such as the authorization code and implicit flows.")
    grant_types: Optional[List[StrictStr]] = Field(description="Array of OAuth 2.0 grant type strings that the client can use at the token endpoint.")
    response_types: Optional[List[StrictStr]] = Field(description="Array of the OAuth 2.0 response type strings that the client can use at the authorization endpoint.")
    client_name: Optional[StrictStr] = Field(description="Human-readable string name of the client to be presented to the end-user during authorization.")
    client_uri: Optional[StrictStr] = Field(description="URL string of a web page providing information about the client.")
    logo_uri: Optional[StrictStr] = Field(description="URL string that references a logo for the client.")
    scope: Optional[StrictStr] = Field(default=None, description="String containing a space-separated list of scope values that the client can use when requesting access tokens.")
    contacts: Optional[List[StrictStr]] = Field(default=None, description="Array of strings representing ways to contact people responsible for this client, typically email addresses.")
    tos_uri: Optional[StrictStr] = Field(description="URL string that points to a human-readable terms of service document for the client that describes a contractual relationship between the end-user and the client that the end-user accepts when authorizing the client.")
    policy_uri: Optional[StrictStr] = Field(description="URL string that points to a human-readable privacy policy document that describes how the deployment organization collects, uses, retains, and discloses personal data.")
    jwks_uri: Optional[StrictStr] = Field(description="URL string referencing the client's JSON Web Key document, which contains the client's public keys.")
    jwks: JsonWebKeySet
    __properties: ClassVar[List[str]] = ["client_id", "client_secret", "client_id_issued_at", "client_secret_expires_at", "redirect_uris", "grant_types", "response_types", "client_name", "client_uri", "logo_uri", "scope", "contacts", "tos_uri", "policy_uri", "jwks_uri", "jwks"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ClientModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of jwks
        if self.jwks:
            _dict['jwks'] = self.jwks.to_dict()
        # set to None if client_secret (nullable) is None
        # and model_fields_set contains the field
        if self.client_secret is None and "client_secret" in self.model_fields_set:
            _dict['client_secret'] = None

        # set to None if client_id_issued_at (nullable) is None
        # and model_fields_set contains the field
        if self.client_id_issued_at is None and "client_id_issued_at" in self.model_fields_set:
            _dict['client_id_issued_at'] = None

        # set to None if client_secret_expires_at (nullable) is None
        # and model_fields_set contains the field
        if self.client_secret_expires_at is None and "client_secret_expires_at" in self.model_fields_set:
            _dict['client_secret_expires_at'] = None

        # set to None if redirect_uris (nullable) is None
        # and model_fields_set contains the field
        if self.redirect_uris is None and "redirect_uris" in self.model_fields_set:
            _dict['redirect_uris'] = None

        # set to None if grant_types (nullable) is None
        # and model_fields_set contains the field
        if self.grant_types is None and "grant_types" in self.model_fields_set:
            _dict['grant_types'] = None

        # set to None if response_types (nullable) is None
        # and model_fields_set contains the field
        if self.response_types is None and "response_types" in self.model_fields_set:
            _dict['response_types'] = None

        # set to None if client_name (nullable) is None
        # and model_fields_set contains the field
        if self.client_name is None and "client_name" in self.model_fields_set:
            _dict['client_name'] = None

        # set to None if client_uri (nullable) is None
        # and model_fields_set contains the field
        if self.client_uri is None and "client_uri" in self.model_fields_set:
            _dict['client_uri'] = None

        # set to None if logo_uri (nullable) is None
        # and model_fields_set contains the field
        if self.logo_uri is None and "logo_uri" in self.model_fields_set:
            _dict['logo_uri'] = None

        # set to None if scope (nullable) is None
        # and model_fields_set contains the field
        if self.scope is None and "scope" in self.model_fields_set:
            _dict['scope'] = None

        # set to None if contacts (nullable) is None
        # and model_fields_set contains the field
        if self.contacts is None and "contacts" in self.model_fields_set:
            _dict['contacts'] = None

        # set to None if tos_uri (nullable) is None
        # and model_fields_set contains the field
        if self.tos_uri is None and "tos_uri" in self.model_fields_set:
            _dict['tos_uri'] = None

        # set to None if policy_uri (nullable) is None
        # and model_fields_set contains the field
        if self.policy_uri is None and "policy_uri" in self.model_fields_set:
            _dict['policy_uri'] = None

        # set to None if jwks_uri (nullable) is None
        # and model_fields_set contains the field
        if self.jwks_uri is None and "jwks_uri" in self.model_fields_set:
            _dict['jwks_uri'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ClientModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "client_id": obj.get("client_id"),
            "client_secret": obj.get("client_secret"),
            "client_id_issued_at": obj.get("client_id_issued_at"),
            "client_secret_expires_at": obj.get("client_secret_expires_at"),
            "redirect_uris": obj.get("redirect_uris"),
            "grant_types": obj.get("grant_types"),
            "response_types": obj.get("response_types"),
            "client_name": obj.get("client_name"),
            "client_uri": obj.get("client_uri"),
            "logo_uri": obj.get("logo_uri"),
            "scope": obj.get("scope"),
            "contacts": obj.get("contacts"),
            "tos_uri": obj.get("tos_uri"),
            "policy_uri": obj.get("policy_uri"),
            "jwks_uri": obj.get("jwks_uri"),
            "jwks": JsonWebKeySet.from_dict(obj["jwks"]) if obj.get("jwks") is not None else None
        })
        return _obj


