# coding: utf-8

"""
    Rapidata.Dataset

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from rapidata.api_client.models.compare_workflow_config_metadata_value import CompareWorkflowConfigMetadataValue
from rapidata.api_client.models.compare_workflow_config_model_pair_maker_config import CompareWorkflowConfigModelPairMakerConfig
from rapidata.api_client.models.compare_workflow_model1_referee import CompareWorkflowModel1Referee
from rapidata.api_client.models.elo_config import EloConfig
from rapidata.api_client.models.feature_flag import FeatureFlag
from typing import Optional, Set
from typing_extensions import Self

class CompareWorkflowConfigModel(BaseModel):
    """
    The configuration for creating a compare workflow. A compare workflow is a workflow that continuously matches datapoints against each other and updates their respective ELO scores. The ELO scores are used to determine the relative strength of the datapoints, and datapoints are matched against other datapoints with similar ELO scores. The end goal is a ranking of the datapoints based on their relative strength.
    """ # noqa: E501
    t: StrictStr = Field(description="Discriminator value for CompareWorkflowConfig", alias="_t")
    criteria: StrictStr = Field(description="The criteria to add to each compare rapid.")
    pair_maker_config: CompareWorkflowConfigModelPairMakerConfig = Field(alias="pairMakerConfig")
    referee: CompareWorkflowModel1Referee
    target_country_codes: List[StrictStr] = Field(description="A list of country codes that this workflow is targeting.", alias="targetCountryCodes")
    elo_config: Optional[EloConfig] = Field(default=None, alias="eloConfig")
    metadata: Dict[str, CompareWorkflowConfigMetadataValue] = Field(description="The metadata is attached to every single rapid and can be used for something like the prompt.")
    feature_flags: List[FeatureFlag] = Field(description="The list of feature flags that will be applied to the rapids created by this workflow.", alias="featureFlags")
    __properties: ClassVar[List[str]] = ["_t", "criteria", "pairMakerConfig", "referee", "targetCountryCodes", "eloConfig", "metadata", "featureFlags"]

    @field_validator('t')
    def t_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['CompareWorkflowConfig']):
            raise ValueError("must be one of enum values ('CompareWorkflowConfig')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CompareWorkflowConfigModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of pair_maker_config
        if self.pair_maker_config:
            _dict['pairMakerConfig'] = self.pair_maker_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of referee
        if self.referee:
            _dict['referee'] = self.referee.to_dict()
        # override the default output from pydantic by calling `to_dict()` of elo_config
        if self.elo_config:
            _dict['eloConfig'] = self.elo_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in metadata (dict)
        _field_dict = {}
        if self.metadata:
            for _key_metadata in self.metadata:
                if self.metadata[_key_metadata]:
                    _field_dict[_key_metadata] = self.metadata[_key_metadata].to_dict()
            _dict['metadata'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each item in feature_flags (list)
        _items = []
        if self.feature_flags:
            for _item_feature_flags in self.feature_flags:
                if _item_feature_flags:
                    _items.append(_item_feature_flags.to_dict())
            _dict['featureFlags'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CompareWorkflowConfigModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "_t": obj.get("_t") if obj.get("_t") is not None else 'CompareWorkflowConfig',
            "criteria": obj.get("criteria"),
            "pairMakerConfig": CompareWorkflowConfigModelPairMakerConfig.from_dict(obj["pairMakerConfig"]) if obj.get("pairMakerConfig") is not None else None,
            "referee": CompareWorkflowModel1Referee.from_dict(obj["referee"]) if obj.get("referee") is not None else None,
            "targetCountryCodes": obj.get("targetCountryCodes"),
            "eloConfig": EloConfig.from_dict(obj["eloConfig"]) if obj.get("eloConfig") is not None else None,
            "metadata": dict(
                (_k, CompareWorkflowConfigMetadataValue.from_dict(_v))
                for _k, _v in obj["metadata"].items()
            )
            if obj.get("metadata") is not None
            else None,
            "featureFlags": [FeatureFlag.from_dict(_item) for _item in obj["featureFlags"]] if obj.get("featureFlags") is not None else None
        })
        return _obj


