# coding: utf-8

"""
    Rapidata.Dataset

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from rapidata.api_client.models.and_filter_filters_inner import AndFilterFiltersInner
from rapidata.api_client.models.feature_flag import FeatureFlag
from typing import Optional, Set
from typing_extensions import Self

class LeaderboardQueryResult(BaseModel):
    """
    LeaderboardQueryResult
    """ # noqa: E501
    id: StrictStr
    order_id: Optional[StrictStr] = Field(default=None, alias="orderId")
    name: StrictStr
    instruction: StrictStr
    show_prompt: StrictBool = Field(alias="showPrompt")
    show_prompt_asset: StrictBool = Field(alias="showPromptAsset")
    is_inversed: StrictBool = Field(alias="isInversed")
    response_budget: StrictInt = Field(alias="responseBudget")
    min_responses: StrictInt = Field(alias="minResponses")
    validation_set_id: Optional[StrictStr] = Field(default=None, alias="validationSetId")
    filters: List[AndFilterFiltersInner]
    feature_flags: List[FeatureFlag] = Field(alias="featureFlags")
    __properties: ClassVar[List[str]] = ["id", "orderId", "name", "instruction", "showPrompt", "showPromptAsset", "isInversed", "responseBudget", "minResponses", "validationSetId", "filters", "featureFlags"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LeaderboardQueryResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in filters (list)
        _items = []
        if self.filters:
            for _item_filters in self.filters:
                if _item_filters:
                    _items.append(_item_filters.to_dict())
            _dict['filters'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in feature_flags (list)
        _items = []
        if self.feature_flags:
            for _item_feature_flags in self.feature_flags:
                if _item_feature_flags:
                    _items.append(_item_feature_flags.to_dict())
            _dict['featureFlags'] = _items
        # set to None if order_id (nullable) is None
        # and model_fields_set contains the field
        if self.order_id is None and "order_id" in self.model_fields_set:
            _dict['orderId'] = None

        # set to None if validation_set_id (nullable) is None
        # and model_fields_set contains the field
        if self.validation_set_id is None and "validation_set_id" in self.model_fields_set:
            _dict['validationSetId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LeaderboardQueryResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "orderId": obj.get("orderId"),
            "name": obj.get("name"),
            "instruction": obj.get("instruction"),
            "showPrompt": obj.get("showPrompt"),
            "showPromptAsset": obj.get("showPromptAsset"),
            "isInversed": obj.get("isInversed"),
            "responseBudget": obj.get("responseBudget"),
            "minResponses": obj.get("minResponses"),
            "validationSetId": obj.get("validationSetId"),
            "filters": [AndFilterFiltersInner.from_dict(_item) for _item in obj["filters"]] if obj.get("filters") is not None else None,
            "featureFlags": [FeatureFlag.from_dict(_item) for _item in obj["featureFlags"]] if obj.get("featureFlags") is not None else None
        })
        return _obj


