# coding: utf-8

"""
    Rapidata.Dataset

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from rapidata.api_client.models.update_validation_rapid_model_truth import UpdateValidationRapidModelTruth
from typing import Optional, Set
from typing_extensions import Self

class UpdateValidationRapidModel(BaseModel):
    """
    The model for updating a validation rapid.
    """ # noqa: E501
    truth: UpdateValidationRapidModelTruth
    explanation: Optional[StrictStr] = Field(default=None, description="The optional explanation that will be shown to the user when answering wrong.")
    prompt: Optional[StrictStr] = Field(default=None, description="The optional prompt that will be shown to the user.")
    random_correct_probability: Union[StrictFloat, StrictInt] = Field(description="The probability that if the user answers at random that he'll be correct.", alias="randomCorrectProbability")
    __properties: ClassVar[List[str]] = ["truth", "explanation", "prompt", "randomCorrectProbability"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateValidationRapidModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of truth
        if self.truth:
            _dict['truth'] = self.truth.to_dict()
        # set to None if explanation (nullable) is None
        # and model_fields_set contains the field
        if self.explanation is None and "explanation" in self.model_fields_set:
            _dict['explanation'] = None

        # set to None if prompt (nullable) is None
        # and model_fields_set contains the field
        if self.prompt is None and "prompt" in self.model_fields_set:
            _dict['prompt'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateValidationRapidModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "truth": UpdateValidationRapidModelTruth.from_dict(obj["truth"]) if obj.get("truth") is not None else None,
            "explanation": obj.get("explanation"),
            "prompt": obj.get("prompt"),
            "randomCorrectProbability": obj.get("randomCorrectProbability")
        })
        return _obj


