# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

import os
from typing import Any, Dict, Mapping, cast
from typing_extensions import Self, Literal, override

import httpx

from . import _exceptions
from ._qs import Querystring
from ._types import (
    Omit,
    Timeout,
    NotGiven,
    Transport,
    ProxiesTypes,
    RequestOptions,
    not_given,
)
from ._utils import is_given, get_async_library
from ._version import __version__
from .resources import spans, tasks, agents, events, states, tracker, deployment_history
from ._streaming import Stream as Stream, AsyncStream as AsyncStream
from ._exceptions import APIStatusError
from ._base_client import (
    DEFAULT_MAX_RETRIES,
    SyncAPIClient,
    AsyncAPIClient,
)
from .resources.messages import messages

__all__ = [
    "ENVIRONMENTS",
    "Timeout",
    "Transport",
    "ProxiesTypes",
    "RequestOptions",
    "Agentex",
    "AsyncAgentex",
    "Client",
    "AsyncClient",
]

ENVIRONMENTS: Dict[str, str] = {
    "production": "http://localhost:5003",
    "development": "http://localhost:5003",
}


class Agentex(SyncAPIClient):
    agents: agents.AgentsResource
    tasks: tasks.TasksResource
    messages: messages.MessagesResource
    spans: spans.SpansResource
    states: states.StatesResource
    events: events.EventsResource
    tracker: tracker.TrackerResource
    deployment_history: deployment_history.DeploymentHistoryResource
    with_raw_response: AgentexWithRawResponse
    with_streaming_response: AgentexWithStreamedResponse

    # client options
    api_key: str | None

    _environment: Literal["production", "development"] | NotGiven

    def __init__(
        self,
        *,
        api_key: str | None = None,
        environment: Literal["production", "development"] | NotGiven = not_given,
        base_url: str | httpx.URL | None | NotGiven = not_given,
        timeout: float | Timeout | None | NotGiven = not_given,
        max_retries: int = DEFAULT_MAX_RETRIES,
        default_headers: Mapping[str, str] | None = None,
        default_query: Mapping[str, object] | None = None,
        # Configure a custom httpx client.
        # We provide a `DefaultHttpxClient` class that you can pass to retain the default values we use for `limits`, `timeout` & `follow_redirects`.
        # See the [httpx documentation](https://www.python-httpx.org/api/#client) for more details.
        http_client: httpx.Client | None = None,
        # Enable or disable schema validation for data returned by the API.
        # When enabled an error APIResponseValidationError is raised
        # if the API responds with invalid data for the expected schema.
        #
        # This parameter may be removed or changed in the future.
        # If you rely on this feature, please open a GitHub issue
        # outlining your use-case to help us decide if it should be
        # part of our public interface in the future.
        _strict_response_validation: bool = False,
    ) -> None:
        """Construct a new synchronous Agentex client instance.

        This automatically infers the `api_key` argument from the `AGENTEX_SDK_API_KEY` environment variable if it is not provided.
        """
        if api_key is None:
            api_key = os.environ.get("AGENTEX_SDK_API_KEY")
        self.api_key = api_key

        self._environment = environment

        base_url_env = os.environ.get("AGENTEX_BASE_URL")
        if is_given(base_url) and base_url is not None:
            # cast required because mypy doesn't understand the type narrowing
            base_url = cast("str | httpx.URL", base_url)  # pyright: ignore[reportUnnecessaryCast]
        elif is_given(environment):
            if base_url_env and base_url is not None:
                raise ValueError(
                    "Ambiguous URL; The `AGENTEX_BASE_URL` env var and the `environment` argument are given. If you want to use the environment, you must pass base_url=None",
                )

            try:
                base_url = ENVIRONMENTS[environment]
            except KeyError as exc:
                raise ValueError(f"Unknown environment: {environment}") from exc
        elif base_url_env is not None:
            base_url = base_url_env
        else:
            self._environment = environment = "production"

            try:
                base_url = ENVIRONMENTS[environment]
            except KeyError as exc:
                raise ValueError(f"Unknown environment: {environment}") from exc

        super().__init__(
            version=__version__,
            base_url=base_url,
            max_retries=max_retries,
            timeout=timeout,
            http_client=http_client,
            custom_headers=default_headers,
            custom_query=default_query,
            _strict_response_validation=_strict_response_validation,
        )

        self.agents = agents.AgentsResource(self)
        self.tasks = tasks.TasksResource(self)
        self.messages = messages.MessagesResource(self)
        self.spans = spans.SpansResource(self)
        self.states = states.StatesResource(self)
        self.events = events.EventsResource(self)
        self.tracker = tracker.TrackerResource(self)
        self.deployment_history = deployment_history.DeploymentHistoryResource(self)
        self.with_raw_response = AgentexWithRawResponse(self)
        self.with_streaming_response = AgentexWithStreamedResponse(self)

    @property
    @override
    def qs(self) -> Querystring:
        return Querystring(array_format="comma")

    @property
    @override
    def auth_headers(self) -> dict[str, str]:
        api_key = self.api_key
        if api_key is None:
            return {}
        return {"Authorization": f"Bearer {api_key}"}

    @property
    @override
    def default_headers(self) -> dict[str, str | Omit]:
        return {
            **super().default_headers,
            "X-Stainless-Async": "false",
            **self._custom_headers,
        }

    def copy(
        self,
        *,
        api_key: str | None = None,
        environment: Literal["production", "development"] | None = None,
        base_url: str | httpx.URL | None = None,
        timeout: float | Timeout | None | NotGiven = not_given,
        http_client: httpx.Client | None = None,
        max_retries: int | NotGiven = not_given,
        default_headers: Mapping[str, str] | None = None,
        set_default_headers: Mapping[str, str] | None = None,
        default_query: Mapping[str, object] | None = None,
        set_default_query: Mapping[str, object] | None = None,
        _extra_kwargs: Mapping[str, Any] = {},
    ) -> Self:
        """
        Create a new client instance re-using the same options given to the current client with optional overriding.
        """
        if default_headers is not None and set_default_headers is not None:
            raise ValueError("The `default_headers` and `set_default_headers` arguments are mutually exclusive")

        if default_query is not None and set_default_query is not None:
            raise ValueError("The `default_query` and `set_default_query` arguments are mutually exclusive")

        headers = self._custom_headers
        if default_headers is not None:
            headers = {**headers, **default_headers}
        elif set_default_headers is not None:
            headers = set_default_headers

        params = self._custom_query
        if default_query is not None:
            params = {**params, **default_query}
        elif set_default_query is not None:
            params = set_default_query

        http_client = http_client or self._client
        return self.__class__(
            api_key=api_key or self.api_key,
            base_url=base_url or self.base_url,
            environment=environment or self._environment,
            timeout=self.timeout if isinstance(timeout, NotGiven) else timeout,
            http_client=http_client,
            max_retries=max_retries if is_given(max_retries) else self.max_retries,
            default_headers=headers,
            default_query=params,
            **_extra_kwargs,
        )

    # Alias for `copy` for nicer inline usage, e.g.
    # client.with_options(timeout=10).foo.create(...)
    with_options = copy

    @override
    def _make_status_error(
        self,
        err_msg: str,
        *,
        body: object,
        response: httpx.Response,
    ) -> APIStatusError:
        if response.status_code == 400:
            return _exceptions.BadRequestError(err_msg, response=response, body=body)

        if response.status_code == 401:
            return _exceptions.AuthenticationError(err_msg, response=response, body=body)

        if response.status_code == 403:
            return _exceptions.PermissionDeniedError(err_msg, response=response, body=body)

        if response.status_code == 404:
            return _exceptions.NotFoundError(err_msg, response=response, body=body)

        if response.status_code == 409:
            return _exceptions.ConflictError(err_msg, response=response, body=body)

        if response.status_code == 422:
            return _exceptions.UnprocessableEntityError(err_msg, response=response, body=body)

        if response.status_code == 429:
            return _exceptions.RateLimitError(err_msg, response=response, body=body)

        if response.status_code >= 500:
            return _exceptions.InternalServerError(err_msg, response=response, body=body)
        return APIStatusError(err_msg, response=response, body=body)


class AsyncAgentex(AsyncAPIClient):
    agents: agents.AsyncAgentsResource
    tasks: tasks.AsyncTasksResource
    messages: messages.AsyncMessagesResource
    spans: spans.AsyncSpansResource
    states: states.AsyncStatesResource
    events: events.AsyncEventsResource
    tracker: tracker.AsyncTrackerResource
    deployment_history: deployment_history.AsyncDeploymentHistoryResource
    with_raw_response: AsyncAgentexWithRawResponse
    with_streaming_response: AsyncAgentexWithStreamedResponse

    # client options
    api_key: str | None

    _environment: Literal["production", "development"] | NotGiven

    def __init__(
        self,
        *,
        api_key: str | None = None,
        environment: Literal["production", "development"] | NotGiven = not_given,
        base_url: str | httpx.URL | None | NotGiven = not_given,
        timeout: float | Timeout | None | NotGiven = not_given,
        max_retries: int = DEFAULT_MAX_RETRIES,
        default_headers: Mapping[str, str] | None = None,
        default_query: Mapping[str, object] | None = None,
        # Configure a custom httpx client.
        # We provide a `DefaultAsyncHttpxClient` class that you can pass to retain the default values we use for `limits`, `timeout` & `follow_redirects`.
        # See the [httpx documentation](https://www.python-httpx.org/api/#asyncclient) for more details.
        http_client: httpx.AsyncClient | None = None,
        # Enable or disable schema validation for data returned by the API.
        # When enabled an error APIResponseValidationError is raised
        # if the API responds with invalid data for the expected schema.
        #
        # This parameter may be removed or changed in the future.
        # If you rely on this feature, please open a GitHub issue
        # outlining your use-case to help us decide if it should be
        # part of our public interface in the future.
        _strict_response_validation: bool = False,
    ) -> None:
        """Construct a new async AsyncAgentex client instance.

        This automatically infers the `api_key` argument from the `AGENTEX_SDK_API_KEY` environment variable if it is not provided.
        """
        if api_key is None:
            api_key = os.environ.get("AGENTEX_SDK_API_KEY")
        self.api_key = api_key

        self._environment = environment

        base_url_env = os.environ.get("AGENTEX_BASE_URL")
        if is_given(base_url) and base_url is not None:
            # cast required because mypy doesn't understand the type narrowing
            base_url = cast("str | httpx.URL", base_url)  # pyright: ignore[reportUnnecessaryCast]
        elif is_given(environment):
            if base_url_env and base_url is not None:
                raise ValueError(
                    "Ambiguous URL; The `AGENTEX_BASE_URL` env var and the `environment` argument are given. If you want to use the environment, you must pass base_url=None",
                )

            try:
                base_url = ENVIRONMENTS[environment]
            except KeyError as exc:
                raise ValueError(f"Unknown environment: {environment}") from exc
        elif base_url_env is not None:
            base_url = base_url_env
        else:
            self._environment = environment = "production"

            try:
                base_url = ENVIRONMENTS[environment]
            except KeyError as exc:
                raise ValueError(f"Unknown environment: {environment}") from exc

        super().__init__(
            version=__version__,
            base_url=base_url,
            max_retries=max_retries,
            timeout=timeout,
            http_client=http_client,
            custom_headers=default_headers,
            custom_query=default_query,
            _strict_response_validation=_strict_response_validation,
        )

        self.agents = agents.AsyncAgentsResource(self)
        self.tasks = tasks.AsyncTasksResource(self)
        self.messages = messages.AsyncMessagesResource(self)
        self.spans = spans.AsyncSpansResource(self)
        self.states = states.AsyncStatesResource(self)
        self.events = events.AsyncEventsResource(self)
        self.tracker = tracker.AsyncTrackerResource(self)
        self.deployment_history = deployment_history.AsyncDeploymentHistoryResource(self)
        self.with_raw_response = AsyncAgentexWithRawResponse(self)
        self.with_streaming_response = AsyncAgentexWithStreamedResponse(self)

    @property
    @override
    def qs(self) -> Querystring:
        return Querystring(array_format="comma")

    @property
    @override
    def auth_headers(self) -> dict[str, str]:
        api_key = self.api_key
        if api_key is None:
            return {}
        return {"Authorization": f"Bearer {api_key}"}

    @property
    @override
    def default_headers(self) -> dict[str, str | Omit]:
        return {
            **super().default_headers,
            "X-Stainless-Async": f"async:{get_async_library()}",
            **self._custom_headers,
        }

    def copy(
        self,
        *,
        api_key: str | None = None,
        environment: Literal["production", "development"] | None = None,
        base_url: str | httpx.URL | None = None,
        timeout: float | Timeout | None | NotGiven = not_given,
        http_client: httpx.AsyncClient | None = None,
        max_retries: int | NotGiven = not_given,
        default_headers: Mapping[str, str] | None = None,
        set_default_headers: Mapping[str, str] | None = None,
        default_query: Mapping[str, object] | None = None,
        set_default_query: Mapping[str, object] | None = None,
        _extra_kwargs: Mapping[str, Any] = {},
    ) -> Self:
        """
        Create a new client instance re-using the same options given to the current client with optional overriding.
        """
        if default_headers is not None and set_default_headers is not None:
            raise ValueError("The `default_headers` and `set_default_headers` arguments are mutually exclusive")

        if default_query is not None and set_default_query is not None:
            raise ValueError("The `default_query` and `set_default_query` arguments are mutually exclusive")

        headers = self._custom_headers
        if default_headers is not None:
            headers = {**headers, **default_headers}
        elif set_default_headers is not None:
            headers = set_default_headers

        params = self._custom_query
        if default_query is not None:
            params = {**params, **default_query}
        elif set_default_query is not None:
            params = set_default_query

        http_client = http_client or self._client
        return self.__class__(
            api_key=api_key or self.api_key,
            base_url=base_url or self.base_url,
            environment=environment or self._environment,
            timeout=self.timeout if isinstance(timeout, NotGiven) else timeout,
            http_client=http_client,
            max_retries=max_retries if is_given(max_retries) else self.max_retries,
            default_headers=headers,
            default_query=params,
            **_extra_kwargs,
        )

    # Alias for `copy` for nicer inline usage, e.g.
    # client.with_options(timeout=10).foo.create(...)
    with_options = copy

    @override
    def _make_status_error(
        self,
        err_msg: str,
        *,
        body: object,
        response: httpx.Response,
    ) -> APIStatusError:
        if response.status_code == 400:
            return _exceptions.BadRequestError(err_msg, response=response, body=body)

        if response.status_code == 401:
            return _exceptions.AuthenticationError(err_msg, response=response, body=body)

        if response.status_code == 403:
            return _exceptions.PermissionDeniedError(err_msg, response=response, body=body)

        if response.status_code == 404:
            return _exceptions.NotFoundError(err_msg, response=response, body=body)

        if response.status_code == 409:
            return _exceptions.ConflictError(err_msg, response=response, body=body)

        if response.status_code == 422:
            return _exceptions.UnprocessableEntityError(err_msg, response=response, body=body)

        if response.status_code == 429:
            return _exceptions.RateLimitError(err_msg, response=response, body=body)

        if response.status_code >= 500:
            return _exceptions.InternalServerError(err_msg, response=response, body=body)
        return APIStatusError(err_msg, response=response, body=body)


class AgentexWithRawResponse:
    def __init__(self, client: Agentex) -> None:
        self.agents = agents.AgentsResourceWithRawResponse(client.agents)
        self.tasks = tasks.TasksResourceWithRawResponse(client.tasks)
        self.messages = messages.MessagesResourceWithRawResponse(client.messages)
        self.spans = spans.SpansResourceWithRawResponse(client.spans)
        self.states = states.StatesResourceWithRawResponse(client.states)
        self.events = events.EventsResourceWithRawResponse(client.events)
        self.tracker = tracker.TrackerResourceWithRawResponse(client.tracker)
        self.deployment_history = deployment_history.DeploymentHistoryResourceWithRawResponse(client.deployment_history)


class AsyncAgentexWithRawResponse:
    def __init__(self, client: AsyncAgentex) -> None:
        self.agents = agents.AsyncAgentsResourceWithRawResponse(client.agents)
        self.tasks = tasks.AsyncTasksResourceWithRawResponse(client.tasks)
        self.messages = messages.AsyncMessagesResourceWithRawResponse(client.messages)
        self.spans = spans.AsyncSpansResourceWithRawResponse(client.spans)
        self.states = states.AsyncStatesResourceWithRawResponse(client.states)
        self.events = events.AsyncEventsResourceWithRawResponse(client.events)
        self.tracker = tracker.AsyncTrackerResourceWithRawResponse(client.tracker)
        self.deployment_history = deployment_history.AsyncDeploymentHistoryResourceWithRawResponse(
            client.deployment_history
        )


class AgentexWithStreamedResponse:
    def __init__(self, client: Agentex) -> None:
        self.agents = agents.AgentsResourceWithStreamingResponse(client.agents)
        self.tasks = tasks.TasksResourceWithStreamingResponse(client.tasks)
        self.messages = messages.MessagesResourceWithStreamingResponse(client.messages)
        self.spans = spans.SpansResourceWithStreamingResponse(client.spans)
        self.states = states.StatesResourceWithStreamingResponse(client.states)
        self.events = events.EventsResourceWithStreamingResponse(client.events)
        self.tracker = tracker.TrackerResourceWithStreamingResponse(client.tracker)
        self.deployment_history = deployment_history.DeploymentHistoryResourceWithStreamingResponse(
            client.deployment_history
        )


class AsyncAgentexWithStreamedResponse:
    def __init__(self, client: AsyncAgentex) -> None:
        self.agents = agents.AsyncAgentsResourceWithStreamingResponse(client.agents)
        self.tasks = tasks.AsyncTasksResourceWithStreamingResponse(client.tasks)
        self.messages = messages.AsyncMessagesResourceWithStreamingResponse(client.messages)
        self.spans = spans.AsyncSpansResourceWithStreamingResponse(client.spans)
        self.states = states.AsyncStatesResourceWithStreamingResponse(client.states)
        self.events = events.AsyncEventsResourceWithStreamingResponse(client.events)
        self.tracker = tracker.AsyncTrackerResourceWithStreamingResponse(client.tracker)
        self.deployment_history = deployment_history.AsyncDeploymentHistoryResourceWithStreamingResponse(
            client.deployment_history
        )


Client = Agentex

AsyncClient = AsyncAgentex
