/*
 * Decompiled with CFR 0.152.
 */
package Lmeasure.gui;

import Lmeasure.gui.HTMLDocumentLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.swing.text.html.StyleSheet;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class EditorPaneExample13
extends JFrame {
    private static final String spaces = "                    ";
    private static final String LOAD_TIME = "Load time: ";
    private HTMLDocumentLoader loader;
    private JEditorPane pane = new JEditorPane();
    private JLabel loadingState;
    private JLabel loadedType;
    private JLabel timeLabel;
    private JComboBox urlCombo;
    private JCheckBox onlineLoad;
    private JTree tree;
    private TreeModel emptyModel;
    private long startTime;
    private boolean populatingCombo;
    private boolean loadingPage;
    private static final Cursor waitCursor = Cursor.getPredefinedCursor(3);
    private static final Cursor defaultCursor = Cursor.getPredefinedCursor(0);
    private static final Cursor handCursor = Cursor.getPredefinedCursor(12);
    private static final HTMLEditorKit editorKit = new HTMLEditorKit();

    public EditorPaneExample13() {
        super("JEditorPane Example 13");
        this.pane.setEditable(false);
        this.getContentPane().add((Component)new JScrollPane(this.pane), "Center");
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 13;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        JLabel urlLabel = new JLabel("URL: ", 4);
        panel.add((Component)urlLabel, c);
        JLabel loadingLabel = new JLabel("State: ", 4);
        c.gridy = 1;
        panel.add((Component)loadingLabel, c);
        JLabel typeLabel = new JLabel("Type: ", 4);
        c.gridy = 2;
        panel.add((Component)typeLabel, c);
        c.gridy = 3;
        panel.add((Component)new JLabel(LOAD_TIME), c);
        c.gridy = 4;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.anchor = 17;
        this.onlineLoad = new JCheckBox("Online Load");
        panel.add((Component)this.onlineLoad, c);
        this.onlineLoad.setSelected(true);
        this.onlineLoad.setForeground(typeLabel.getForeground());
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 13;
        c.fill = 2;
        this.urlCombo = new JComboBox();
        panel.add((Component)this.urlCombo, c);
        this.urlCombo.setEditable(true);
        this.loadingState = new JLabel(spaces, 2);
        this.loadingState.setForeground(Color.black);
        c.gridy = 1;
        panel.add((Component)this.loadingState, c);
        this.loadedType = new JLabel(spaces, 2);
        this.loadedType.setForeground(Color.black);
        c.gridy = 2;
        panel.add((Component)this.loadedType, c);
        this.timeLabel = new JLabel("");
        c.gridy = 3;
        panel.add((Component)this.timeLabel, c);
        panel.setBorder(new LineBorder(Color.BLUE));
        this.getContentPane().add((Component)panel, "South");
        InputStream is = EditorPaneExample13.class.getResourceAsStream("C:\\Soumya\\Workspace\\LMTest\\WebContent\\help\\helpPageStyle.css");
        if (is != null) {
            try {
                StyleSheet ss = this.loadStyleSheet(is);
                editorKit.setStyleSheet(ss);
            }
            catch (IOException e) {
                System.out.println("Failed to load new default style sheet");
            }
        }
        DefaultMutableTreeNode emptyRootNode = new DefaultMutableTreeNode("Empty");
        this.emptyModel = new DefaultTreeModel(emptyRootNode);
        this.tree = new JTree(this.emptyModel);
        this.tree.setPreferredSize(new Dimension(200, 200));
        this.getContentPane().add((Component)new JScrollPane(this.tree), "East");
        this.urlCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (EditorPaneExample13.this.populatingCombo) {
                    return;
                }
                Object selection = EditorPaneExample13.this.urlCombo.getSelectedItem();
                EditorPaneExample13.this.loadNewPage(selection);
            }
        });
        this.pane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("page")) {
                    EditorPaneExample13.this.loadComplete();
                    EditorPaneExample13.this.displayLoadTime();
                    EditorPaneExample13.this.populateCombo(EditorPaneExample13.this.findLinks(EditorPaneExample13.this.pane.getDocument(), null));
                    TreeNode node = EditorPaneExample13.this.buildHeadingTree(EditorPaneExample13.this.pane.getDocument());
                    EditorPaneExample13.this.tree.setModel(new DefaultTreeModel(node));
                    EditorPaneExample13.this.enableInput();
                    EditorPaneExample13.this.loadingPage = false;
                }
            }
        });
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                DefaultMutableTreeNode node;
                Object userObject;
                TreePath path = evt.getNewLeadSelectionPath();
                if (path != null && (userObject = (node = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()) instanceof Heading) {
                    Heading heading = (Heading)userObject;
                    try {
                        Rectangle textRect = EditorPaneExample13.this.pane.modelToView(heading.getOffset());
                        textRect.y += 3 * textRect.height;
                        EditorPaneExample13.this.pane.scrollRectToVisible(textRect);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        });
        this.pane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                if (EditorPaneExample13.this.loadingPage) {
                    return;
                }
                if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    JEditorPane sp = (JEditorPane)evt.getSource();
                    if (evt instanceof HTMLFrameHyperlinkEvent) {
                        HTMLDocument doc = (HTMLDocument)sp.getDocument();
                        doc.processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)evt);
                    } else {
                        EditorPaneExample13.this.loadNewPage(evt.getURL());
                    }
                } else if (evt.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                    EditorPaneExample13.this.pane.setCursor(handCursor);
                } else if (evt.getEventType() == HyperlinkEvent.EventType.EXITED) {
                    EditorPaneExample13.this.pane.setCursor(defaultCursor);
                }
            }
        });
    }

    public void loadNewPage(Object page) {
        try {
            this.loadingPage = true;
            URL url = page instanceof URL ? (URL)page : new URL((String)page);
            this.urlCombo.setSelectedItem(page);
            URL loadedURL = this.pane.getPage();
            if (loadedURL != null && loadedURL.sameFile(url)) {
                return;
            }
            this.urlCombo.setEnabled(false);
            this.urlCombo.paintImmediately(0, 0, this.urlCombo.getSize().width, this.urlCombo.getSize().height);
            this.setCursor(waitCursor);
            this.loadingState.setText("Loading...");
            this.loadingState.paintImmediately(0, 0, this.loadingState.getSize().width, this.loadingState.getSize().height);
            this.loadedType.setText("");
            this.loadedType.paintImmediately(0, 0, this.loadedType.getSize().width, this.loadedType.getSize().height);
            this.timeLabel.setText("");
            this.timeLabel.paintImmediately(0, 0, this.timeLabel.getSize().width, this.timeLabel.getSize().height);
            this.tree.setModel(this.emptyModel);
            this.tree.paintImmediately(0, 0, this.tree.getSize().width, this.tree.getSize().height);
            this.startTime = System.currentTimeMillis();
            if (this.onlineLoad.isSelected()) {
                this.pane.setPage(url);
                this.loadedType.setText(this.pane.getContentType());
            } else {
                this.pane.setContentType("text/html");
                this.loadedType.setText(this.pane.getContentType());
                if (this.loader == null) {
                    this.loader = new HTMLDocumentLoader();
                }
                HTMLDocument doc = this.loader.loadDocument(url);
                this.loadComplete();
                this.pane.setDocument(doc);
                this.displayLoadTime();
                this.populateCombo(this.findLinks(doc, null));
                TreeNode node = this.buildHeadingTree(doc);
                this.tree.setModel(new DefaultTreeModel(node));
                this.enableInput();
                this.loadingPage = false;
            }
        }
        catch (Exception e) {
            System.out.println(e);
            JOptionPane.showMessageDialog(this.pane, new String[]{"Unable to open file", page.toString()}, "File Open Error", 0);
            this.loadingState.setText("Failed");
            this.enableInput();
            this.loadingPage = false;
        }
    }

    public void loadComplete() {
        this.loadingState.setText("Page loaded.");
    }

    public void enableInput() {
        this.urlCombo.setEnabled(true);
        this.setCursor(defaultCursor);
        this.pane.setCursor(defaultCursor);
    }

    public void displayLoadTime() {
        double loadingTime = (double)(System.currentTimeMillis() - this.startTime) / 1000.0;
        this.timeLabel.setText(String.valueOf(loadingTime) + " seconds");
    }

    public void populateCombo(URL[] urls) {
        Object o = this.urlCombo.getSelectedItem();
        this.populatingCombo = true;
        this.urlCombo.setModel(new DefaultComboBoxModel<URL>(urls));
        this.urlCombo.setSelectedItem(o);
        this.populatingCombo = false;
    }

    public StyleSheet loadStyleSheet(InputStream is) throws IOException {
        StyleSheet s = new StyleSheet();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        s.loadRules(reader, null);
        reader.close();
        return s;
    }

    public URL[] findLinks(Document doc, String protocol) {
        Vector<URL> links = new Vector<URL>();
        Vector<String> urlNames = new Vector<String>();
        URL baseURL = (URL)doc.getProperty("stream");
        if (doc instanceof HTMLDocument) {
            Element elem = doc.getDefaultRootElement();
            ElementIterator iterator = new ElementIterator(elem);
            while ((elem = iterator.next()) != null) {
                Object linkAttr;
                AttributeSet attrs = elem.getAttributes();
                Object link = attrs.getAttribute(HTML.Tag.A);
                if (!(link instanceof AttributeSet) || !((linkAttr = ((AttributeSet)link).getAttribute(HTML.Attribute.HREF)) instanceof String)) continue;
                try {
                    String linkURLName;
                    URL linkURL = new URL(baseURL, (String)linkAttr);
                    if (protocol != null && !protocol.equalsIgnoreCase(linkURL.getProtocol()) || urlNames.contains(linkURLName = linkURL.toString())) continue;
                    urlNames.addElement(linkURLName);
                    links.addElement(linkURL);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        Object[] urls = new URL[links.size()];
        links.copyInto(urls);
        links.removeAllElements();
        urlNames.removeAllElements();
        return urls;
    }

    public TreeNode buildHeadingTree(Document doc) {
        String title = (String)doc.getProperty("title");
        if (title == null) {
            title = "[No title]";
        }
        Heading rootHeading = new Heading(title, 0, 0);
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(rootHeading);
        DefaultMutableTreeNode[] lastNode = new DefaultMutableTreeNode[7];
        int lastLevel = 0;
        lastNode[lastLevel] = rootNode;
        if (doc instanceof HTMLDocument) {
            Heading heading;
            Element elem = doc.getDefaultRootElement();
            ElementIterator iterator = new ElementIterator(elem);
            while ((heading = this.getNextHeading(doc, iterator)) != null) {
                DefaultMutableTreeNode hNode = new DefaultMutableTreeNode(heading);
                int level = heading.getLevel();
                if (level > lastLevel) {
                    int i = lastLevel + 1;
                    while (i < level) {
                        lastNode[i] = null;
                        ++i;
                    }
                    lastNode[lastLevel].add(hNode);
                } else {
                    int prevLevel = level - 1;
                    while (prevLevel >= 0) {
                        if (lastNode[prevLevel] != null) break;
                        lastNode[prevLevel] = null;
                        --prevLevel;
                    }
                    lastNode[prevLevel].add(hNode);
                }
                lastNode[level] = hNode;
                lastLevel = level;
            }
        }
        return rootNode;
    }

    public Heading getNextHeading(Document doc, ElementIterator iter) {
        Element elem;
        while ((elem = iter.next()) != null) {
            AttributeSet attrs = elem.getAttributes();
            Object type = attrs.getAttribute(StyleConstants.NameAttribute);
            int level = this.getHeadingLevel(type);
            if (level <= 0) continue;
            String headingText = "";
            int count = elem.getElementCount();
            int i = 0;
            while (i < count) {
                Element child = elem.getElement(i);
                AttributeSet cattrs = child.getAttributes();
                if (cattrs.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.CONTENT) {
                    try {
                        int offset = child.getStartOffset();
                        headingText = String.valueOf(headingText) + doc.getText(offset, child.getEndOffset() - offset);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                ++i;
            }
            headingText = headingText.trim();
            return new Heading(headingText, level, elem.getStartOffset());
        }
        return null;
    }

    public int getHeadingLevel(Object type) {
        if (type instanceof HTML.Tag) {
            if (type == HTML.Tag.H1) {
                return 1;
            }
            if (type == HTML.Tag.H2) {
                return 2;
            }
            if (type == HTML.Tag.H3) {
                return 3;
            }
            if (type == HTML.Tag.H4) {
                return 4;
            }
            if (type == HTML.Tag.H5) {
                return 5;
            }
            if (type == HTML.Tag.H6) {
                return 6;
            }
        }
        return -1;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        EditorPaneExample13 f = new EditorPaneExample13();
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                System.exit(0);
            }
        });
        f.setSize(500, 400);
        f.setVisible(true);
    }

    static class Heading {
        protected String text;
        protected int level;
        protected int offset;

        public Heading(String text, int level, int offset) {
            this.text = text;
            this.level = level;
            this.offset = offset;
        }

        public String getText() {
            return this.text;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLevel() {
            return this.level;
        }

        public String toString() {
            return this.text;
        }
    }
}

