/*
 * Decompiled with CFR 0.152.
 */
package Lmeasure.stat;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;

public class Alignment {
    static final String[][] blastParams = new String[][]{{" 1.10 0.333 0.549 1 -1 ", " 0.264 0.0532 0.0722 2 -1 ", " ", " ", " ", " ", " ", " ", " ", " "}, {" 1.33 0.621 1.12 1 -2 ", " 0.549 0.333 0.549 2 -2 ", " 0.271 0.130 0.222 3 -2 ", " 0.132 0.0532 0.0722 4 -2 ", " 0.0514 0.0250 0.0135 5 -2 ", " ", " ", " ", " ", " "}, {" 1.37 0.711 1.31 1 -3 ", " 0.634 0.408 0.912 2 -3 ", " 0.366 0.333 0.549 3 -3 ", " 0.227 0.161 0.306 4 -3 ", " 0.144 0.0952 0.158 5 -3 ", " 0.0882 0.0532 0.0722 6 -3 ", " 0.0494 0.0291 0.0264 7 -3 ", " 0.0212 0.0268 0.00550 8 -3 ", " ", " "}, {" 1.38 0.738 1.36 1 -4 ", " 0.666 0.621 1.12 2 -4 ", " 0.410 0.340 0.811 3 -4 ", " 0.275 0.333 0.549 4 -4 ", " 0.192 0.176 0.357 5 -4 ", " 0.136 1.63 0.222 6 -4 ", " 0.0957 0.0809 0.132 7 -4 ", " 0.0661 0.0532 0.0722 8 -4 ", " 0.0435 0.0327 0.0350 9 -4 ", " 0.0257 7.93 0.0135 10 -4 "}, {" 1.39 0.747 1.38 1 -5 ", " 0.681 0.515 1.24 2 -5 ", " 0.432 0.396 0.997 3 -5 ", " 0.301 0.306 0.753 4 -5 ", " 0.220 0.333 0.549 5 -5 ", " 0.164 0.184 0.390 6 -5 ", " 0.124 0.140 0.270 7 -5 ", " 0.0945 0.103 0.182 8 -5 ", " 0.0713 0.0733 0.118 9 -5 ", " 0.0529 0.0532 0.0722 10 -5 "}, {" 1.39 0.749 1.38 1 -6 ", " 0.687 0.711 1.31 2 -6 ", " 0.444 0.621 1.12 3 -6 ", " 0.317 1.17 0.912 4 -6 ", " 0.237 0.286 0.716 5 -6 ", " 0.183 0.333 0.549 6 -6 ", " 0.144 0.189 0.414 7 -6 ", " 0.114 1.41 0.306 8 -6 ", " 0.0904 1.63 0.222 9 -6 ", " 0.0718 1.79 0.158 10 -6 "}, {" 1.39 0.750 1.39 1 -7 ", " 0.690 0.548 1.34 2 -7 ", " 0.451 0.455 1.21 3 -7 ", " 0.327 0.386 1.03 4 -7 ", " 0.249 0.327 0.854 5 -7 ", " 0.196 0.273 0.690 6 -7 ", " 0.157 0.333 0.549 7 -7 ", " 0.127 0.192 0.431 8 -7 ", " 0.104 0.161 0.334 9 -7 ", " 0.0855 0.132 0.256 10 -7 "}, {" 1.39 0.750 1.39 1 -8 ", " 0.692 0.738 1.36 2 -8 ", " 0.455 0.472 1.27 3 -8 ", " 0.333 0.621 1.12 4 -8 ", " 0.257 0.357 0.965 5 -8 ", " 0.205 1.10 0.811 6 -8 ", " 0.167 0.263 0.671 7 -8 ", " 0.137 0.333 0.549 8 -8 ", " 0.114 0.194 0.445 9 -8 ", " 0.0958 1.31 0.357 10 -8 "}, {" 1.39 0.750 1.39 1 -9 ", " 0.692 0.558 1.37 2 -9 ", " 0.458 0.711 1.31 3 -9 ", " 0.337 0.427 1.19 4 -9 ", " 0.263 0.378 1.05 5 -9 ", " 0.211 1.17 0.912 6 -9 ", " 0.174 0.295 0.779 7 -9 ", " 0.145 0.255 0.657 8 -9 ", " 0.122 0.333 0.549 9 -9 ", " 0.104 0.196 0.456 10 -9 "}, {" 1.39 0.750 1.39 1 -10 ", " 0.693 0.747 1.38 2 -10 ", " 0.460 0.491 1.33 3 -10 ", " 0.340 1.06 1.24 4 -10 ", " 0.267 0.621 1.12 5 -10 ", " 0.216 1.03 0.997 6 -10 ", " 0.179 0.321 0.871 7 -10 ", " 0.151 1.07 0.753 8 -10 ", " 0.128 0.250 0.646 9 -10 ", " 0.110 0.333 0.549 10 -10 "}};
    public static final Float[] zScoreVs10Log10 = new Float[]{new Float(1.65), new Float(13.05645352), new Float(1.66), new Float(13.14641628), new Float(1.67), new Float(13.23675387), new Float(1.68), new Float(13.3274666), new Float(1.69), new Float(13.41855481), new Float(1.7), new Float(13.51001881), new Float(1.71), new Float(13.60185892), new Float(1.72), new Float(13.69407545), new Float(1.73), new Float(13.7866687), new Float(1.74), new Float(13.879639), new Float(1.75), new Float(13.97298665), new Float(1.76), new Float(14.06671195), new Float(1.77), new Float(14.16081521), new Float(1.78), new Float(14.25529673), new Float(1.79), new Float(14.3501568), new Float(1.8), new Float(14.44539573), new Float(1.81), new Float(14.54101382), new Float(1.82), new Float(14.63701134), new Float(1.83), new Float(14.7333886), new Float(1.84), new Float(14.83014588), new Float(1.85), new Float(14.92728347), new Float(1.86), new Float(15.02480166), new Float(1.87), new Float(15.12270073), new Float(1.88), new Float(15.22098096), new Float(1.89), new Float(15.31964263), new Float(1.9), new Float(15.41868601), new Float(1.91), new Float(15.5181114), new Float(1.92), new Float(15.61791905), new Float(1.93), new Float(15.71810923), new Float(1.94), new Float(15.81868223), new Float(1.95), new Float(15.91963831), new Float(1.96), new Float(16.02097773), new Float(1.97), new Float(16.12270077), new Float(1.98), new Float(16.22480767), new Float(1.99), new Float(16.32729871), new Float(2.0f), new Float(16.43017415), new Float(2.01), new Float(16.53343423), new Float(2.02), new Float(16.63707923), new Float(2.03), new Float(16.74110938), new Float(2.04), new Float(16.84552495), new Float(2.05), new Float(16.95032619), new Float(2.06), new Float(17.05551334), new Float(2.07), new Float(17.16108665), new Float(2.08), new Float(17.26704637), new Float(2.09), new Float(17.37339274), new Float(2.1), new Float(17.48012601), new Float(2.11), new Float(17.58724641), new Float(2.12), new Float(17.69475419), new Float(2.13), new Float(17.80264958), new Float(2.14), new Float(17.91093283), new Float(2.15), new Float(18.01960416), new Float(2.16), new Float(18.1286638), new Float(2.17), new Float(18.23811199), new Float(2.18), new Float(18.34794897), new Float(2.19), new Float(18.45817495), new Float(2.2), new Float(18.56879017), new Float(2.21), new Float(18.67979484), new Float(2.22), new Float(18.7911892), new Float(2.23), new Float(18.90297347), new Float(2.24), new Float(19.01514786), new Float(2.25), new Float(19.12771261), new Float(2.26), new Float(19.24066792), new Float(2.27), new Float(19.35401401), new Float(2.28), new Float(19.4677511), new Float(2.29), new Float(19.5818794), new Float(2.3), new Float(19.69639912), new Float(2.31), new Float(19.81131048), new Float(2.32), new Float(19.92661368), new Float(2.33), new Float(20.04230894), new Float(2.34), new Float(20.15839646), new Float(2.35), new Float(20.27487644), new Float(2.36), new Float(20.3917491), new Float(2.37), new Float(20.50901462), new Float(2.38), new Float(20.62667322), new Float(2.39), new Float(20.7447251), new Float(2.4), new Float(20.86317045), new Float(2.41), new Float(20.98200947), new Float(2.42), new Float(21.10124236), new Float(2.43), new Float(21.22086932), new Float(2.44), new Float(21.34089053), new Float(2.45), new Float(21.46130619), new Float(2.46), new Float(21.58211649), new Float(2.47), new Float(21.70332162), new Float(2.48), new Float(21.82492178), new Float(2.49), new Float(21.94691714), new Float(2.5), new Float(22.06930789), new Float(2.51), new Float(22.19209423), new Float(2.52), new Float(22.31527633), new Float(2.53), new Float(22.43885437), new Float(2.54), new Float(22.56282855), new Float(2.55), new Float(22.68719903), new Float(2.56), new Float(22.811966), new Float(2.57), new Float(22.93712964), new Float(2.58), new Float(23.06269013), new Float(2.59), new Float(23.18864763), new Float(2.6), new Float(23.31500233), new Float(2.61), new Float(23.44175439), new Float(2.62), new Float(23.568904), new Float(2.63), new Float(23.69645132), new Float(2.64), new Float(23.82439652), new Float(2.65), new Float(23.95273978), new Float(2.66), new Float(24.08148126), new Float(2.67), new Float(24.21062112), new Float(2.68), new Float(24.34015954), new Float(2.69), new Float(24.47009668), new Float(2.7), new Float(24.60043271), new Float(2.71), new Float(24.73116778), new Float(2.72), new Float(24.86230206), new Float(2.73), new Float(24.9938357), new Float(2.74), new Float(25.12576888), new Float(2.75), new Float(25.25810175), new Float(2.76), new Float(25.39083446), new Float(2.77), new Float(25.52396718), new Float(2.78), new Float(25.65750006), new Float(2.79), new Float(25.79143326), new Float(2.8), new Float(25.92576692), new Float(2.81), new Float(26.0605012), new Float(2.82), new Float(26.19563626), new Float(2.83), new Float(26.33117225), new Float(2.84), new Float(26.46710931), new Float(2.85), new Float(26.6034476), new Float(2.86), new Float(26.74018726), new Float(2.87), new Float(26.87732844), new Float(2.88), new Float(27.01487129), new Float(2.89), new Float(27.15281595), new Float(2.9), new Float(27.29116258), new Float(2.91), new Float(27.4299113), new Float(2.92), new Float(27.56906227), new Float(2.93), new Float(27.70861563), new Float(2.94), new Float(27.84857152), new Float(2.95), new Float(27.98893008), new Float(2.96), new Float(28.12969144), new Float(2.97), new Float(28.27085576), new Float(2.98), new Float(28.41242316), new Float(2.99), new Float(28.55439378), new Float(3.0f), new Float(28.69676776), new Float(3.01), new Float(28.83954523), new Float(3.02), new Float(28.98272634), new Float(3.03), new Float(29.1263112), new Float(3.04), new Float(29.27029997), new Float(3.05), new Float(29.41469276), new Float(3.06), new Float(29.5594897), new Float(3.07), new Float(29.70469094), new Float(3.08), new Float(29.8502966), new Float(3.09), new Float(29.9963068), new Float(3.1), new Float(30.14272168), new Float(3.11), new Float(30.28954137), new Float(3.12), new Float(30.43676598), new Float(3.13), new Float(30.58439565), new Float(3.14), new Float(30.73243051), new Float(3.15), new Float(30.88087066), new Float(3.16), new Float(31.02971625), new Float(3.17), new Float(31.17896739), new Float(3.18), new Float(31.32862421), new Float(3.19), new Float(31.47868682), new Float(3.2), new Float(31.62915534), new Float(3.21), new Float(31.7800299), new Float(3.22), new Float(31.93131062), new Float(3.23), new Float(32.08299762), new Float(3.24), new Float(32.235091), new Float(3.25), new Float(32.3875909), new Float(3.26), new Float(32.54049742), new Float(3.27), new Float(32.69381069), new Float(3.28), new Float(32.84753081), new Float(3.29), new Float(33.0016579), new Float(3.3), new Float(33.15619208), new Float(3.31), new Float(33.31113346), new Float(3.32), new Float(33.46648215), new Float(3.33), new Float(33.62223826), new Float(3.34), new Float(33.7784019), new Float(3.35), new Float(33.93497319), new Float(3.36), new Float(34.09195224), new Float(3.37), new Float(34.24933914), new Float(3.38), new Float(34.40713402), new Float(3.39), new Float(34.56533699), new Float(3.4), new Float(34.72394813), new Float(3.41), new Float(34.88296758), new Float(3.42), new Float(35.04239542), new Float(3.43), new Float(35.20223177), new Float(3.44), new Float(35.36247673), new Float(3.45), new Float(35.52313041), new Float(3.46), new Float(35.6841929), new Float(3.47), new Float(35.84566432), new Float(3.48), new Float(36.00754476), new Float(3.49), new Float(36.16983433), new Float(3.5), new Float(36.33253313), new Float(3.51), new Float(36.49564126), new Float(3.52), new Float(36.65915881), new Float(3.53), new Float(36.82308589), new Float(3.54), new Float(36.98742261), new Float(3.55), new Float(37.15216904), new Float(3.56), new Float(37.31732531), new Float(3.57), new Float(37.48289149), new Float(3.58), new Float(37.64886769), new Float(3.59), new Float(37.81525401), new Float(3.6), new Float(37.98205054), new Float(3.61), new Float(38.14925737), new Float(3.62), new Float(38.3168746), new Float(3.63), new Float(38.48490233), new Float(3.64), new Float(38.65334065), new Float(3.65), new Float(38.82218965), new Float(3.66), new Float(38.99144942), new Float(3.67), new Float(39.16112006), new Float(3.68), new Float(39.33120166), new Float(3.69), new Float(39.50169431), new Float(3.7), new Float(39.67259809), new Float(3.71), new Float(39.84391311), new Float(3.72), new Float(40.01563944), new Float(3.73), new Float(40.18777718), new Float(3.74), new Float(40.36032642), new Float(3.75), new Float(40.53328725), new Float(3.76), new Float(40.70665975), new Float(3.77), new Float(40.880444), new Float(3.78), new Float(41.05464011), new Float(3.79), new Float(41.22924814), new Float(3.8), new Float(41.40426819), new Float(3.81), new Float(41.57970035), new Float(3.82), new Float(41.7555447), new Float(3.83), new Float(41.93180132), new Float(3.84), new Float(42.10847029), new Float(3.85), new Float(42.28555171), new Float(3.86), new Float(42.46304564), new Float(3.87), new Float(42.64095219), new Float(3.88), new Float(42.81927142), new Float(3.89), new Float(42.99800342), new Float(3.9), new Float(43.17714827), new Float(3.91), new Float(43.35670605), new Float(3.92), new Float(43.53667684), new Float(3.93), new Float(43.71706072), new Float(3.94), new Float(43.89785777), new Float(3.95), new Float(44.07906808), new Float(3.96), new Float(44.26069171), new Float(3.97), new Float(44.44272875), new Float(3.98), new Float(44.62517927), new Float(3.99), new Float(44.80804335), new Float(4.0f), new Float(44.99132108), new Float(4.01), new Float(45.17501252), new Float(4.02), new Float(45.35911774), new Float(4.03), new Float(45.54363684), new Float(4.04), new Float(45.72856988), new Float(4.05), new Float(45.91391694), new Float(4.06), new Float(46.09967808), new Float(4.07), new Float(46.2858534), new Float(4.08), new Float(46.47244295), new Float(4.09), new Float(46.65944682), new Float(4.1), new Float(46.84686507), new Float(4.11), new Float(47.03469778), new Float(4.12), new Float(47.22294502), new Float(4.13), new Float(47.41160687), new Float(4.14), new Float(47.60068339), new Float(4.15), new Float(47.79017465), new Float(4.16), new Float(47.98008074), new Float(4.17), new Float(48.1704017), new Float(4.18), new Float(48.36113763), new Float(4.19), new Float(48.55228858), new Float(4.2), new Float(48.74385463), new Float(4.21), new Float(48.93583584), new Float(4.22), new Float(49.12823228), new Float(4.23), new Float(49.32104403), new Float(4.24), new Float(49.51427114), new Float(4.25), new Float(49.70791369), new Float(4.26), new Float(49.90197175), new Float(4.27), new Float(50.09644538), new Float(4.28), new Float(50.29133464), new Float(4.29), new Float(50.48663961), new Float(4.3), new Float(50.68236035), new Float(4.31), new Float(50.87849692), new Float(4.32), new Float(51.07504939), new Float(4.33), new Float(51.27201783), new Float(4.34), new Float(51.46940229), new Float(4.35), new Float(51.66720285), new Float(4.36), new Float(51.86541957), new Float(4.37), new Float(52.06405251), new Float(4.38), new Float(52.26310173), new Float(4.39), new Float(52.4625673), new Float(4.4), new Float(52.66244928), new Float(4.41), new Float(52.86274773), new Float(4.42), new Float(53.06346272), new Float(4.43), new Float(53.2645943), new Float(4.44), new Float(53.46614254), new Float(4.45), new Float(53.6681075), new Float(4.46), new Float(53.87048923), new Float(4.47), new Float(54.07328781), new Float(4.48), new Float(54.27650328), new Float(4.49), new Float(54.48013572), new Float(4.5), new Float(54.68418517), new Float(4.51), new Float(54.8886517), new Float(4.52), new Float(55.09353537), new Float(4.53), new Float(55.29883623), new Float(4.54), new Float(55.50455435), new Float(4.55), new Float(55.71068978), new Float(4.56), new Float(55.91724258), new Float(4.57), new Float(56.12421281), new Float(4.58), new Float(56.33160053), new Float(4.59), new Float(56.53940578), new Float(4.6), new Float(56.74762864), new Float(4.61), new Float(56.95626915), new Float(4.62), new Float(57.16532737), new Float(4.63), new Float(57.37480335), new Float(4.64), new Float(57.58469717), new Float(4.65), new Float(57.79500885), new Float(4.66), new Float(58.00573848), new Float(4.67), new Float(58.21688609), new Float(4.68), new Float(58.42845174), new Float(4.69), new Float(58.64043549), new Float(4.7), new Float(58.85283739), new Float(4.71), new Float(59.0656575), new Float(4.72), new Float(59.27889586), new Float(4.73), new Float(59.49255254), new Float(4.74), new Float(59.70662758), new Float(4.75), new Float(59.92112103), new Float(4.76), new Float(60.13603296), new Float(4.77), new Float(60.35136341), new Float(4.78), new Float(60.56711243), new Float(4.79), new Float(60.78328008), new Float(4.8), new Float(60.99986641), new Float(4.81), new Float(61.21687146), new Float(4.82), new Float(61.4342953), new Float(4.83), new Float(61.65213797), new Float(4.84), new Float(61.87039951), new Float(4.85), new Float(62.08907999), new Float(4.86), new Float(62.30817945), new Float(4.87), new Float(62.52769794), new Float(4.88), new Float(62.74763551), new Float(4.89), new Float(62.96799222), new Float(4.9), new Float(63.1887681), new Float(4.91), new Float(63.40996321), new Float(4.92), new Float(63.6315776), new Float(4.93), new Float(63.85361131), new Float(4.94), new Float(64.0760644), new Float(4.95), new Float(64.29893691), new Float(4.96), new Float(64.52222888), new Float(4.97), new Float(64.74594038), new Float(4.98), new Float(64.97007144), new Float(4.99), new Float(65.19462212), new Float(5.0f), new Float(65.41959245), new Float(5.01), new Float(65.64498248), new Float(5.02), new Float(65.87079227), new Float(5.03), new Float(66.09702186), new Float(5.04), new Float(66.32367129), new Float(5.05), new Float(66.55074062), new Float(5.06), new Float(66.77822987), new Float(5.07), new Float(67.00613911), new Float(5.08), new Float(67.23446838), new Float(5.09), new Float(67.46321772), new Float(5.1), new Float(67.69238718), new Float(5.11), new Float(67.92197679), new Float(5.12), new Float(68.15198662), new Float(5.13), new Float(68.38241669), new Float(5.14), new Float(68.61326705), new Float(5.15), new Float(68.84453776), new Float(5.16), new Float(69.07622885), new Float(5.17), new Float(69.30834036), new Float(5.18), new Float(69.54087234), new Float(5.19), new Float(69.77382483), new Float(5.2), new Float(70.00719787), new Float(5.21), new Float(70.24099151), new Float(5.22), new Float(70.4752058), new Float(5.23), new Float(70.70984076), new Float(5.24), new Float(70.94489644), new Float(5.25), new Float(71.1803729), new Float(5.26), new Float(71.41627016), new Float(5.27), new Float(71.65258827), new Float(5.28), new Float(71.88932726), new Float(5.29), new Float(72.12648719), new Float(5.3), new Float(72.3640681), new Float(5.31), new Float(72.60207002), new Float(5.32), new Float(72.84049299), new Float(5.33), new Float(73.07933706), new Float(5.34), new Float(73.31860225), new Float(5.35), new Float(73.55828863), new Float(5.36), new Float(73.79839622), new Float(5.37), new Float(74.03892508), new Float(5.38), new Float(74.27987521), new Float(5.39), new Float(74.52124669), new Float(5.4), new Float(74.76303953), new Float(5.41), new Float(75.0052538), new Float(5.42), new Float(75.2478895), new Float(5.43), new Float(75.4909467), new Float(5.44), new Float(75.73442544), new Float(5.45), new Float(75.97832573), new Float(5.46), new Float(76.22264763), new Float(5.47), new Float(76.46739118), new Float(5.48), new Float(76.7125564), new Float(5.49), new Float(76.95814335), new Float(5.5), new Float(77.20415206), new Float(5.51), new Float(77.45058255), new Float(5.52), new Float(77.69743488), new Float(5.53), new Float(77.94470907), new Float(5.54), new Float(78.19240519), new Float(5.55), new Float(78.44052323), new Float(5.56), new Float(78.68906324), new Float(5.57), new Float(78.93802527), new Float(5.58), new Float(79.18740938), new Float(5.59), new Float(79.43721557), new Float(5.6), new Float(79.68744384), new Float(5.61), new Float(79.93809432), new Float(5.62), new Float(80.18916698), new Float(5.63), new Float(80.44066188), new Float(5.64), new Float(80.692579), new Float(5.65), new Float(80.94491848), new Float(5.66), new Float(81.19768028), new Float(5.67), new Float(81.45086443), new Float(5.68), new Float(81.70447102), new Float(5.69), new Float(81.95850003), new Float(5.7), new Float(82.21295149), new Float(5.71), new Float(82.46782551), new Float(5.72), new Float(82.72312205), new Float(5.73), new Float(82.97884115), new Float(5.74), new Float(83.23498298), new Float(5.75), new Float(83.49154735), new Float(5.76), new Float(83.74853434), new Float(5.77), new Float(84.00594412), new Float(5.78), new Float(84.26377674), new Float(5.79), new Float(84.522032), new Float(5.8), new Float(84.7807101), new Float(5.81), new Float(85.03981116), new Float(5.82), new Float(85.29933503), new Float(5.83), new Float(85.55928164), new Float(5.84), new Float(85.81965141), new Float(5.85), new Float(86.08044419), new Float(5.86), new Float(86.34165978), new Float(5.87), new Float(86.6032985), new Float(5.88), new Float(86.86536029), new Float(5.89), new Float(87.12784533), new Float(5.9), new Float(87.39075349), new Float(5.91), new Float(87.65408457), new Float(5.92), new Float(87.9178391), new Float(5.93), new Float(88.18201676), new Float(5.94), new Float(88.44661769), new Float(5.95), new Float(88.71164198), new Float(5.96), new Float(88.97708958), new Float(5.97), new Float(89.24296024), new Float(5.98), new Float(89.50925452), new Float(5.99), new Float(89.77597217), new Float(6.0f), new Float(90.04311345)};

    public static double estimatePValue(double z) {
        if (z > 6.0) {
            return 0.0;
        }
        if (z < -6.0) {
            return 1.0;
        }
        double b1 = 0.31938153;
        double b2 = -0.356563782;
        double b3 = 1.781477937;
        double b4 = -1.821255978;
        double b5 = 1.330274429;
        double p = 0.2316419;
        double c2 = 0.3989423;
        if (z < 0.0) {
            z *= -1.0;
        }
        double t = 1.0 / (1.0 + z * p);
        double b = c2 * Math.exp(-z * (z / 2.0));
        double n = ((((b5 * t + b4) * t + b3) * t + b2) * t + b1) * t;
        n = 1.0 - b * n;
        return 1.0 - n;
    }

    public static double transform10Log10(double num) {
        return -10.0 * (Math.log(num) / Math.log(10.0));
    }

    public static double convertRawScoreToBit(double lambdaNats, double K, double rawS) {
        NumberFormat f = NumberFormat.getNumberInstance();
        f.setMaximumFractionDigits(1);
        double bs = (lambdaNats * rawS - Math.log(K)) / Math.log(2.0);
        String bsS = f.format(bs);
        bsS = bsS.replaceAll(",", "");
        return Double.parseDouble(bsS);
    }

    public static double convertBitScoreToRaw(double lambdaNats, double K, double bitS) {
        NumberFormat f = NumberFormat.getNumberInstance();
        f.setMaximumFractionDigits(1);
        double bs = Math.round((bitS * Math.log(2.0) + Math.log(K)) / lambdaNats);
        String bsS = f.format(bs);
        bsS = bsS.replaceAll(",", "");
        return Double.parseDouble(bsS);
    }

    public static String calculateEValue(double lambdaNats, double K, int rawS, double effectiveN, double effectiveM) {
        DecimalFormat f = new DecimalFormat("0E0");
        double num = K * effectiveN * effectiveM * Math.exp(-1.0 * lambdaNats * (double)rawS);
        String numS = f.format(num);
        if (numS.equals("0E0")) {
            return "<1E-99";
        }
        return numS;
    }

    public static int[] calculateEffectiveMandN(double m, double n, double K, double H) {
        double l = Math.log(K * m * n) / H;
        return new int[]{(int)Math.round(m - l), (int)Math.round(n - l)};
    }

    public static double[] fetchBLASTParams(int match, int misMatch) {
        String x = blastParams[misMatch * -1 - 1][match - 1].trim();
        if (x.equals("")) {
            return null;
        }
        String[] nums = x.split("\\s");
        return new double[]{Double.parseDouble(nums[0]), Double.parseDouble(nums[1]), Double.parseDouble(nums[2])};
    }

    public static int ScoreDNAAlignment(String seq1, String seq2, int match, int misMatch, int gapCreate, int gapExtend) {
        Character dash = new Character('-');
        int score = 0;
        boolean newGap = true;
        int matches = 0;
        int len = seq1.length();
        seq1 = seq1.toUpperCase();
        seq2 = seq2.toUpperCase();
        int i = 0;
        while (i < len) {
            Character s2;
            Character s1 = new Character(seq1.charAt(i));
            int comp = s1.compareTo(s2 = new Character(seq2.charAt(i)));
            if (comp == 0) {
                score += match;
                newGap = true;
                ++matches;
            } else {
                int comp1 = s1.compareTo(dash);
                int comp2 = s2.compareTo(dash);
                if (comp1 == 0 || comp2 == 0) {
                    if (newGap) {
                        score += gapCreate;
                        newGap = false;
                    } else {
                        score += gapExtend;
                    }
                } else {
                    score += misMatch;
                    newGap = true;
                }
            }
            ++i;
        }
        return score;
    }

    public static String fetchTransformedPValueString(float zScore, HashMap zScoreVs10Log10) {
        if ((double)zScore < 1.65) {
            return "not significant";
        }
        if ((double)zScore > 6.0) {
            return ">90";
        }
        Float num = Alignment.roundFloat(zScore);
        num = (Float)zScoreVs10Log10.get(num);
        return Alignment.roundFloat(num.floatValue()).toString();
    }

    public static float fetchTransformedPValueFloat(float zScore, HashMap zScoreVs10Log10) {
        if ((double)zScore < 1.65) {
            return 0.0f;
        }
        if ((double)zScore > 6.0) {
            return 90.0f;
        }
        Float num = Alignment.roundFloat(zScore);
        num = (Float)zScoreVs10Log10.get(num);
        return num.floatValue();
    }

    public static HashMap fetchZScorePValueHashMap() {
        int num = zScoreVs10Log10.length;
        HashMap<Float, Float> map = new HashMap<Float, Float>(num);
        int i = 0;
        while (i < num) {
            map.put(zScoreVs10Log10[i], zScoreVs10Log10[++i]);
            ++i;
        }
        return map;
    }

    public static Float roundFloat(float num) {
        NumberFormat f = NumberFormat.getNumberInstance();
        f.setMaximumFractionDigits(2);
        return new Float(f.format(num));
    }
}

