/*
 * Decompiled with CFR 0.152.
 */
package Lmeasure.gui;

import Lmeasure.gui.FuncStatTableModel;
import Lmeasure.gui.LMManagerImpl;
import Lmeasure.gui.MakeLMInput;
import Lmeasure.gui.ParseTextToStructure;
import Lmeasure.gui.PvalarrModel;
import Lmeasure.gui.StatTableRow;
import Lmeasure.gui.pValueModel;
import Lmeasure.stat.Ttest;
import Lmeasure.stat.WilcoxonRankSumTest;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.DefaultListModel;

public class StatTest {
    Ttest tt;
    WilcoxonRankSumTest wrst;
    boolean[] sum_arr;
    boolean[] min_arr;
    boolean[] avg_arr;
    boolean[] max_arr;
    boolean[] sd_arr;
    double[] data_arr_1;
    double[] data_arr_2;
    int G1_size;
    int G2_size;
    File statFile;
    Iterator tmIterator;
    LMManagerImpl execLm;
    FuncStatTableModel fstm;
    int noof_func;
    MakeLMInput stmkobj;
    DefaultListModel lstmdl;
    ParseTextToStructure pts;
    Object[][] pvalarr;
    boolean appisLocal;
    int firstplace = -1;
    int pvalarrind = -1;
    int no_of_clicks = 0;
    static final double VOID = 9.99999999E8;

    public StatTest(MakeLMInput mkobj, DefaultListModel lstmdl) {
        this.stmkobj = mkobj;
        this.lstmdl = lstmdl;
        this.tt = new Ttest();
        this.wrst = new WilcoxonRankSumTest();
        System.out.println("g1size:" + mkobj.getG1_Size());
        this.fstm = mkobj.getFuncTable();
        this.tmIterator = this.fstm.rows.iterator();
        this.noof_func = this.fstm.getRowCount();
        this.appisLocal = mkobj.isAppLocal();
        this.sum_arr = new boolean[this.noof_func];
        this.min_arr = new boolean[this.noof_func];
        this.avg_arr = new boolean[this.noof_func];
        this.max_arr = new boolean[this.noof_func];
        this.data_arr_1 = new double[mkobj.getG1_Size()];
        this.data_arr_2 = new double[mkobj.getG2_Size()];
    }

    public void fillStatPrefs() {
        int sumIndex = 0;
        int minIndex = 0;
        int maxIndex = 0;
        int avgIndex = 0;
        while (this.tmIterator.hasNext()) {
            StatTableRow tm = (StatTableRow)this.tmIterator.next();
            this.sum_arr[sumIndex++] = tm.m_Sum;
            this.min_arr[minIndex++] = tm.m_Min;
            this.avg_arr[avgIndex++] = tm.m_Avg;
            this.max_arr[maxIndex++] = tm.m_Max;
        }
    }

    public int getSelectedArray(boolean[] bool) {
        int boolCount = 0;
        int i = 0;
        while (i < bool.length) {
            if (bool[i]) {
                ++boolCount;
            }
            ++i;
        }
        return boolCount;
    }

    public void doStatTest() {
        this.pts = new ParseTextToStructure(this.stmkobj.getOutFile(), this.noof_func, this.stmkobj.getG1_Size(), this.stmkobj.getG2_Size());
        this.pts.parseFile();
        this.statFile = this.stmkobj.getOutFile();
        if (!this.appisLocal) {
            this.firstplace = 0;
        }
        this.fillStatPrefs();
        int sum_clicks = this.getSelectedArray(this.sum_arr);
        int min_clicks = this.getSelectedArray(this.min_arr);
        int avg_clicks = this.getSelectedArray(this.avg_arr);
        int max_clicks = this.getSelectedArray(this.max_arr);
        this.no_of_clicks = sum_clicks + min_clicks + avg_clicks + max_clicks;
        this.pvalarr = new Object[this.no_of_clicks][11];
        this.computeStatMetric(this.sum_arr, 0);
        this.computeStatMetric(this.min_arr, 1);
        this.computeStatMetric(this.avg_arr, 2);
        this.computeStatMetric(this.max_arr, 3);
        this.printSave();
    }

    public void computeStatMetric(boolean[] metric_arr, int col) {
        int find_metric = 0;
        double tbcorr = 0.0;
        double wbcorr = 0.0;
        String funcname = "";
        while (find_metric < metric_arr.length) {
            if (metric_arr[find_metric]) {
                Integer N2;
                int fid_1 = 0;
                while (fid_1 < this.stmkobj.getG1_Size()) {
                    this.data_arr_1[fid_1] = this.pts.Group1_Array[fid_1][find_metric][col];
                    ++fid_1;
                }
                int fid_2 = 0;
                while (fid_2 < this.stmkobj.getG2_Size()) {
                    this.data_arr_2[fid_2] = this.pts.Group2_Array[fid_2][find_metric][col];
                    ++fid_2;
                }
                if (this.stmkobj.getTtestFlag()) {
                    double[] avevar2;
                    double[] avevar1;
                    pValueModel pvalobj;
                    funcname = this.fstm.getValueAt(find_metric, 0).toString();
                    Integer N1 = new Integer(this.data_arr_1.length);
                    N2 = new Integer(this.data_arr_2.length);
                    double[] result = this.tt.ttest(this.data_arr_1, N1.longValue(), this.data_arr_2, N2.longValue());
                    if (this.stmkobj.getBcorrFlag()) {
                        tbcorr = result[1] * (double)this.no_of_clicks;
                    }
                    ++this.pvalarrind;
                    if (this.stmkobj.getBcorrFlag()) {
                        this.pvalarr[this.pvalarrind][0] = funcname.trim();
                        this.pvalarr[this.pvalarrind][1] = "Ttest";
                        this.pvalarr[this.pvalarrind][2] = this.fstm.getColumnName(col + 1);
                        pvalobj = new pValueModel(this.pvalarrind, result[1]);
                        this.pvalarr[this.pvalarrind][3] = pvalobj;
                        this.pvalarr[this.pvalarrind][4] = new Double(tbcorr);
                        avevar1 = new double[2];
                        avevar1 = this.tt.avevar(this.data_arr_1, N1.longValue());
                        avevar2 = new double[2];
                        avevar2 = this.tt.avevar(this.data_arr_2, N2.longValue());
                        this.pvalarr[this.pvalarrind][5] = new Double(avevar1[0]);
                        this.pvalarr[this.pvalarrind][6] = new Double(Math.sqrt(avevar1[1]));
                        this.pvalarr[this.pvalarrind][7] = new Double(avevar2[0]);
                        this.pvalarr[this.pvalarrind][8] = new Double(Math.sqrt(avevar2[1]));
                        this.pvalarr[this.pvalarrind][9] = N1;
                        this.pvalarr[this.pvalarrind][10] = N2;
                    } else {
                        this.pvalarr[this.pvalarrind][0] = funcname.trim();
                        this.pvalarr[this.pvalarrind][1] = "Ttest";
                        this.pvalarr[this.pvalarrind][2] = this.fstm.getColumnName(col + 1);
                        pvalobj = new pValueModel(this.pvalarrind, result[1]);
                        this.pvalarr[this.pvalarrind][3] = pvalobj;
                        this.pvalarr[this.pvalarrind][4] = new Double(9.99999999E8);
                        avevar1 = new double[2];
                        avevar1 = this.tt.avevar(this.data_arr_1, N1.longValue());
                        avevar2 = new double[2];
                        avevar2 = this.tt.avevar(this.data_arr_2, N2.longValue());
                        this.pvalarr[this.pvalarrind][5] = new Double(avevar1[0]);
                        this.pvalarr[this.pvalarrind][6] = new Double(Math.sqrt(avevar1[1]));
                        this.pvalarr[this.pvalarrind][7] = new Double(avevar2[0]);
                        this.pvalarr[this.pvalarrind][8] = new Double(Math.sqrt(avevar2[1]));
                        this.pvalarr[this.pvalarrind][9] = N1;
                        this.pvalarr[this.pvalarrind][10] = N2;
                    }
                } else if (this.stmkobj.getWtestFlag()) {
                    double[] avevar2;
                    double[] avevar1;
                    pValueModel pvalobj;
                    Integer N1 = new Integer(this.data_arr_1.length);
                    N2 = new Integer(this.data_arr_2.length);
                    funcname = this.fstm.getValueAt(find_metric, 0).toString();
                    double result = this.wrst.test(this.data_arr_1, this.data_arr_2);
                    if (this.stmkobj.getBcorrFlag()) {
                        wbcorr = result * (double)this.no_of_clicks;
                    }
                    ++this.pvalarrind;
                    if (this.stmkobj.getBcorrFlag()) {
                        this.pvalarr[this.pvalarrind][0] = funcname.trim();
                        this.pvalarr[this.pvalarrind][1] = "Wilcoxon";
                        this.pvalarr[this.pvalarrind][2] = this.fstm.getColumnName(col + 1);
                        pvalobj = new pValueModel(this.pvalarrind, result);
                        this.pvalarr[this.pvalarrind][3] = pvalobj;
                        this.pvalarr[this.pvalarrind][4] = new Double(wbcorr);
                        avevar1 = new double[2];
                        avevar1 = this.tt.avevar(this.data_arr_1, N1.longValue());
                        avevar2 = new double[2];
                        avevar2 = this.tt.avevar(this.data_arr_2, N2.longValue());
                        this.pvalarr[this.pvalarrind][5] = new Double(avevar1[0]);
                        this.pvalarr[this.pvalarrind][6] = new Double(Math.sqrt(avevar1[1]));
                        this.pvalarr[this.pvalarrind][7] = new Double(avevar2[0]);
                        this.pvalarr[this.pvalarrind][8] = new Double(Math.sqrt(avevar2[1]));
                        this.pvalarr[this.pvalarrind][9] = N1;
                        this.pvalarr[this.pvalarrind][10] = N2;
                    } else {
                        this.pvalarr[this.pvalarrind][0] = funcname.trim();
                        this.pvalarr[this.pvalarrind][1] = "Wilcoxon";
                        this.pvalarr[this.pvalarrind][2] = this.fstm.getColumnName(col + 1);
                        pvalobj = new pValueModel(this.pvalarrind, result);
                        this.pvalarr[this.pvalarrind][3] = pvalobj;
                        this.pvalarr[this.pvalarrind][4] = new Double(9.99999999E8);
                        avevar1 = new double[2];
                        avevar1 = this.tt.avevar(this.data_arr_1, N1.longValue());
                        avevar2 = new double[2];
                        avevar2 = this.tt.avevar(this.data_arr_2, N2.longValue());
                        this.pvalarr[this.pvalarrind][5] = new Double(avevar1[0]);
                        this.pvalarr[this.pvalarrind][6] = new Double(Math.sqrt(avevar1[1]));
                        this.pvalarr[this.pvalarrind][7] = new Double(avevar2[0]);
                        this.pvalarr[this.pvalarrind][8] = new Double(Math.sqrt(avevar2[1]));
                        this.pvalarr[this.pvalarrind][9] = N1;
                        this.pvalarr[this.pvalarrind][10] = N2;
                    }
                }
            }
            ++find_metric;
        }
    }

    public PvalarrModel[] sortPvalarr() {
        Object[] pvm = new PvalarrModel[this.pvalarr.length];
        pValueModel pvalobj = null;
        try {
            int pind = 0;
            while (pind < this.pvalarr.length) {
                ((PvalarrModel)pvm[pind]).Fname = this.pvalarr[pind][0].toString();
                ((PvalarrModel)pvm[pind]).Tname = this.pvalarr[pind][1].toString();
                ((PvalarrModel)pvm[pind]).Cname = this.pvalarr[pind][2].toString();
                ((PvalarrModel)pvm[pind]).pvalm = pvalobj = (pValueModel)this.pvalarr[pind][3];
                ((PvalarrModel)pvm[pind]).corr = (Double)this.pvalarr[pind][4];
                ++pind;
            }
            Arrays.sort(pvm);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return pvm;
    }

    public void printSave() {
        try {
            NumberFormat nf = NumberFormat.getInstance();
            DecimalFormat df = (DecimalFormat)nf;
            df.applyPattern("0.####");
            BufferedWriter StatBufferedFile = new BufferedWriter(new FileWriter(this.statFile, true));
            Object[] pval = new pValueModel[this.pvalarr.length];
            double pvalue = 0.0;
            pValueModel pvalueobj = null;
            double bcorrvalue = 0.0;
            boolean statTitleFlag = false;
            if (this.stmkobj.getFcorrFlag()) {
                try {
                    int pind = 0;
                    while (pind < this.pvalarr.length) {
                        pvalueobj = (pValueModel)this.pvalarr[pind][3];
                        pval[pind] = pvalueobj;
                        ++pind;
                    }
                    Arrays.sort(pval);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            StatBufferedFile.newLine();
            if (this.stmkobj.getFcorrFlag()) {
                int comp = 0;
                while (comp < this.pvalarr.length) {
                    pvalue = ((pValueModel)this.pvalarr[comp][3]).pvalue;
                    int ID = ((pValueModel)this.pvalarr[comp][3]).ID;
                    bcorrvalue = (Double)this.pvalarr[comp][4];
                    int pcomp = 0;
                    while (pcomp < pval.length) {
                        double pval_Sorted = ((pValueModel)pval[pcomp]).pvalue;
                        int pval_ID = ((pValueModel)pval[pcomp]).ID;
                        if (Double.compare(pvalue, pval_Sorted) == 0 && ID == pval_ID) {
                            int dup_pcomp = 0;
                            int k = 0;
                            double FDR = 0.0;
                            String npval = "";
                            dup_pcomp = pcomp;
                            this.lstmdl.insertElementAt("****" + this.pvalarr[comp][1].toString().trim() + " Result on " + this.pvalarr[comp][2].toString().trim() + " metric of " + this.pvalarr[comp][0].toString().trim() + " function" + "****", ++this.firstplace);
                            this.lstmdl.insertElementAt("                 N              Mean              SD          ", ++this.firstplace);
                            this.lstmdl.insertElementAt("Group1   " + (Integer)this.pvalarr[comp][9] + "          " + df.format((Double)this.pvalarr[comp][5]) + "          " + df.format((Double)this.pvalarr[comp][6]), ++this.firstplace);
                            this.lstmdl.insertElementAt("Group2   " + (Integer)this.pvalarr[comp][10] + "          " + df.format((Double)this.pvalarr[comp][7]) + "          " + df.format((Double)this.pvalarr[comp][8]), ++this.firstplace);
                            npval = df.format(((pValueModel)this.pvalarr[comp][3]).pvalue).equals("0") ? "0.00001" : df.format(((pValueModel)this.pvalarr[comp][3]).pvalue);
                            this.lstmdl.insertElementAt("P Value <=" + ((pValueModel)this.pvalarr[comp][3]).pvalue, ++this.firstplace);
                            k = dup_pcomp + 1;
                            System.out.println("k " + k);
                            FDR = pval_Sorted * (double)this.no_of_clicks / (double)k;
                            if (!statTitleFlag) {
                                if (this.stmkobj.getTtestFlag()) {
                                    StatBufferedFile.write("Function_Name\tStatistic\tN1\tMean1\tSD1\tN2\tMean2\tSD2\tTtest_P_Values\tFDR_correction\n");
                                } else {
                                    StatBufferedFile.write("Function_name\tStatisitc\tN1\tMean1\tSD1\tN2\tMean2\tSD2\tWilcoxon_P_Values\tFDR_correction\n");
                                }
                                statTitleFlag = true;
                            }
                            StatBufferedFile.write(String.valueOf(this.pvalarr[comp][0].toString()) + "\t" + this.pvalarr[comp][2].toString().trim() + "\t" + (Integer)this.pvalarr[comp][9] + "\t" + df.format((Double)this.pvalarr[comp][5]) + "\t" + df.format((Double)this.pvalarr[comp][6]) + "\t" + (Integer)this.pvalarr[comp][10] + "\t" + df.format((Double)this.pvalarr[comp][7]) + "\t" + df.format((Double)this.pvalarr[comp][8]) + "\t" + ((pValueModel)this.pvalarr[comp][3]).pvalue + "\t" + FDR);
                            StatBufferedFile.newLine();
                            this.lstmdl.insertElementAt("FDR Correction " + FDR, ++this.firstplace);
                        }
                        ++pcomp;
                    }
                    ++comp;
                }
            } else {
                String npval = "";
                int comp = 0;
                while (comp < this.pvalarr.length) {
                    bcorrvalue = (Double)this.pvalarr[comp][4];
                    this.lstmdl.insertElementAt("****" + this.pvalarr[comp][1].toString().trim() + " Result on " + this.pvalarr[comp][2].toString().trim() + " metric of " + this.pvalarr[comp][0].toString().trim() + " function" + "****", ++this.firstplace);
                    this.lstmdl.insertElementAt("                 N              Mean              SD          ", ++this.firstplace);
                    this.lstmdl.insertElementAt("Group1   " + (Integer)this.pvalarr[comp][9] + "          " + df.format((Double)this.pvalarr[comp][5]) + "          " + df.format((Double)this.pvalarr[comp][6]), ++this.firstplace);
                    this.lstmdl.insertElementAt("Group2   " + (Integer)this.pvalarr[comp][10] + "          " + df.format((Double)this.pvalarr[comp][7]) + "          " + df.format((Double)this.pvalarr[comp][8]), ++this.firstplace);
                    npval = df.format(((pValueModel)this.pvalarr[comp][3]).pvalue).equals("0") ? "0.00001" : df.format(((pValueModel)this.pvalarr[comp][3]).pvalue);
                    this.lstmdl.insertElementAt("P Value <=" + ((pValueModel)this.pvalarr[comp][3]).pvalue, ++this.firstplace);
                    if (Double.compare(bcorrvalue, 9.99999999E8) > 0 || Double.compare(bcorrvalue, 9.99999999E8) < 0) {
                        if (!statTitleFlag) {
                            if (this.stmkobj.getTtestFlag()) {
                                StatBufferedFile.write("Function_Name\tStatistic\tN1\tMean1\tSD1\tN2\tMean2\tSD2\tTtest_P_Values\tBonferroni_correction\n");
                            } else {
                                StatBufferedFile.write("Function_name\tStatistic\tN1\tMean1\tSD1\tN2\tMean2\tSD2\tWilcoxon_P_Values\tBonferroni_correction\n");
                            }
                            statTitleFlag = true;
                        }
                        if ((Double)this.pvalarr[comp][4] < 1.0) {
                            this.lstmdl.insertElementAt("Bonferroni Correction:" + (Double)this.pvalarr[comp][4], ++this.firstplace);
                            StatBufferedFile.write(String.valueOf(this.pvalarr[comp][0].toString()) + "\t" + this.pvalarr[comp][2].toString().trim() + "\t" + (Integer)this.pvalarr[comp][9] + "\t" + df.format((Double)this.pvalarr[comp][5]) + "\t" + df.format((Double)this.pvalarr[comp][6]) + "\t" + (Integer)this.pvalarr[comp][10] + "\t" + df.format((Double)this.pvalarr[comp][7]) + "\t" + df.format((Double)this.pvalarr[comp][8]) + "\t" + ((pValueModel)this.pvalarr[comp][3]).pvalue + "\t" + (Double)this.pvalarr[comp][4]);
                            StatBufferedFile.newLine();
                        } else {
                            this.pvalarr[comp][4] = new Double(1.0);
                            this.lstmdl.insertElementAt("Bonferroni Correction: >=" + df.format((Double)this.pvalarr[comp][4]), ++this.firstplace);
                            StatBufferedFile.write(String.valueOf(this.pvalarr[comp][0].toString()) + "\t" + this.pvalarr[comp][2].toString().trim() + "\t" + (Integer)this.pvalarr[comp][9] + "\t" + df.format((Double)this.pvalarr[comp][5]) + "\t" + df.format((Double)this.pvalarr[comp][6]) + "\t" + (Integer)this.pvalarr[comp][10] + "\t" + df.format((Double)this.pvalarr[comp][7]) + "\t" + df.format((Double)this.pvalarr[comp][8]) + "\t" + ((pValueModel)this.pvalarr[comp][3]).pvalue + "\t" + ">=" + df.format((Double)this.pvalarr[comp][4]));
                            StatBufferedFile.newLine();
                        }
                    } else {
                        if (!statTitleFlag) {
                            if (this.stmkobj.getTtestFlag()) {
                                StatBufferedFile.write("Function_name\tStatistic\tN1\tMean1\tSD1\tN2\tMean2\tSD2\tTtest_P_Values\n");
                            } else {
                                StatBufferedFile.write("Function_name\tStatistic\tN1\tMean1\tSD1\tN2\tMean2\tSD2\tWilcoxon_P_Values\n");
                            }
                            statTitleFlag = true;
                        }
                        StatBufferedFile.write(String.valueOf(this.pvalarr[comp][0].toString()) + "\t" + this.pvalarr[comp][2].toString().trim() + "\t" + (Integer)this.pvalarr[comp][9] + "\t" + df.format((Double)this.pvalarr[comp][5]) + "\t" + df.format((Double)this.pvalarr[comp][6]) + "\t" + (Integer)this.pvalarr[comp][10] + "\t" + df.format((Double)this.pvalarr[comp][7]) + "\t" + df.format((Double)this.pvalarr[comp][8]) + "\t" + ((pValueModel)this.pvalarr[comp][3]).pvalue);
                        StatBufferedFile.newLine();
                    }
                    ++comp;
                }
            }
            StatBufferedFile.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

