/*
 * Decompiled with CFR 0.152.
 */
package Lmeasure.stat;

import Lmeasure.stat.Alignment;
import Lmeasure.stat.WilcoxonSample;
import Lmeasure.stat.WilcoxonSignedRankTest;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;

public class WilcoxonRankSumTest {
    private WilcoxonSample[] samples;
    private double treatmentSum;
    private double controlSum;
    private int numTreatments;
    private int numControls;
    private double z;
    private double pValue;
    private double logTPvalue;
    private double averageIntensityDifference;

    public double test(double[] treatment, double[] control) {
        double[] result = new double[3];
        this.treatmentSum = 0.0;
        this.controlSum = 0.0;
        this.z = -10.0;
        this.pValue = 1.0;
        this.logTPvalue = 0.0;
        this.makeSamples(treatment, control);
        this.averageIntensityDifference = WilcoxonRankSumTest.calcAveIntDiff(treatment, control);
        Arrays.sort(this.samples);
        this.rankSamples();
        this.sumRanks();
        if (this.numTreatments > 9 && this.numControls > 9) {
            result[0] = this.z = this.calculateZ();
            result[1] = this.pValue = Alignment.estimatePValue(this.z);
            System.out.println("z: " + this.z + " p-val " + this.pValue);
            this.logTPvalue = this.pValue == 0.0 ? 90.0 : Alignment.transform10Log10(this.pValue);
            result[2] = this.logTPvalue;
        } else {
            boolean nShort;
            int N = this.numTreatments + this.numControls;
            int nShortest = 0;
            double w = 0.0;
            double MaxSum = new Integer(N * (N + 1) / 2).doubleValue();
            double H0 = MaxSum / 2.0;
            double[] total_rank = new double[this.samples.length];
            int s = 0;
            while (s < this.samples.length) {
                total_rank[s] = this.samples[s].rank;
                ++s;
            }
            System.out.println("total_rank size " + total_rank.length);
            boolean bl = nShort = this.numTreatments < this.numControls;
            if (!nShort) {
                nShortest = this.numControls;
                w = this.controlSum;
            } else {
                nShortest = this.numTreatments;
                w = this.treatmentSum;
            }
            w = w > H0 ? MaxSum - w : w;
            double permutations = this.koutn(this.numTreatments, N);
            double less = this.countSmallerRanks(w, 0.0, nShortest - 1, 0, total_rank);
            if (2.0 * less > permutations) {
                less = this.countSmallerRanks(w - 1.0, 0.0, nShortest - 1, 0, total_rank);
                less = permutations - less;
            }
            this.pValue = 2.0 * less / permutations;
            if (nShortest < 10 && (this.pValue >= 0.25 || permutations >= 60000.0)) {
                System.out.println("*" + this.pValue);
                System.out.println("w " + w);
            }
        }
        return this.pValue;
    }

    public static double calcAveIntDiff(double[] treatment, double[] control) {
        double aveT = WilcoxonRankSumTest.averageDoubleArray(treatment);
        double aveC = WilcoxonRankSumTest.averageDoubleArray(control);
        return aveT - aveC;
    }

    public double koutn(int k, int n) {
        double kn = 1.0;
        while (k > 0) {
            kn = kn * (double)n / (double)k;
            --k;
            --n;
        }
        return kn;
    }

    public double countSmallerRanks(double w, double sum, int mminus1, int start, double[] rankList) {
        int end = 0;
        int i = 0;
        int smaller = 0;
        int msub1 = 0;
        double temp = 0.0;
        if (sum > w) {
            return 0.0;
        }
        end = rankList.length - 1;
        if (mminus1 > 0) {
            msub1 = mminus1 - 1;
            i = start;
            while (i <= end - mminus1 - 1) {
                temp = sum + rankList[i];
                if (temp > w) {
                    return smaller;
                }
                smaller = (int)((double)smaller + this.countSmallerRanks(w, temp, msub1, i + 1, rankList));
                ++i;
            }
        } else {
            if (sum + (double)end + 1.0 <= w) {
                return end - start + 1;
            }
            i = start;
            while (i <= end) {
                temp = sum + rankList[i];
                if (temp <= w) {
                    ++smaller;
                } else {
                    return smaller;
                }
                ++i;
            }
        }
        return smaller;
    }

    public static double averageDoubleArray(double[] f) {
        double tTot = 0.0;
        int lenTreat = f.length;
        int i = 0;
        while (i < lenTreat) {
            tTot += f[i];
            ++i;
        }
        return tTot / (double)lenTreat;
    }

    public double calculateZ() {
        double stndiv = Math.sqrt(this.numTreatments * this.numControls * (this.numTreatments + this.numControls + 1) / 12);
        double top = this.treatmentSum - (double)(this.numTreatments * (this.numTreatments + this.numControls + 1) / 2);
        double res = top / stndiv;
        return res;
    }

    public void sumRanks() {
        int numSamples = this.samples.length;
        int i = 0;
        while (i < numSamples) {
            if (this.samples[i].treatment) {
                this.treatmentSum += this.samples[i].rank;
            } else {
                this.controlSum += this.samples[i].rank;
            }
            ++i;
        }
    }

    public void rankSamples() {
        int num = this.samples.length;
        int i = 0;
        while (i < num) {
            this.samples[i].rank = i + 1;
            ++i;
        }
        int i2 = 0;
        while (i2 < num) {
            int start = i2;
            int end = i2;
            while (++end < num && this.samples[start].value == this.samples[end].value) {
            }
            if (end - start != 1) {
                float ave = WilcoxonSignedRankTest.getAverageInts((int)this.samples[start].rank, (int)this.samples[end - 1].rank);
                int x = start;
                while (x < end) {
                    this.samples[x].rank = ave;
                    ++x;
                }
                i2 = end - 1;
            }
            ++i2;
        }
    }

    public void makeSamples(double[] treatment, double[] control) {
        this.numTreatments = treatment.length;
        System.out.println("numTreatments " + this.numTreatments);
        this.numControls = control.length;
        System.out.println("numControls " + this.numControls);
        int counter = this.numTreatments;
        this.samples = new WilcoxonSample[this.numTreatments + this.numControls];
        int i = 0;
        while (i < this.numTreatments) {
            this.samples[i] = new WilcoxonSample(treatment[i], true);
            ++i;
        }
        i = 0;
        while (i < this.numControls) {
            this.samples[counter++] = new WilcoxonSample(control[i], false);
            ++i;
        }
    }

    public static void main(String[] args) {
        WilcoxonRankSumTest w = new WilcoxonRankSumTest();
        double[] t = new double[]{36.7026, 20.6192, 23.602, 24.2285, 22.4488, 24.9252, 22.4913, 34.1419, 18.0648, 24.6049, 28.1036, 16.0293, 23.7704, 14.6354, 28.6911, 15.4244, 23.0271, 23.0248, 31.5966, 16.1242};
        double[] c = new double[]{36.1141, 16.7068, 12.218, 17.2185, 13.3827, 28.6911, 11.831, 115.428, 11.1518, 13.1706, 11.2866, 16.3826, 24.2428, 15.7121, 10.048, 10.4991, 11.1006, 15.1188, 24.7057, 24.9346, 11.349, 10.3886, 15.8532, 12.5934};
        double p = w.test(t, c);
        NumberFormat df = DecimalFormat.getInstance();
        System.out.println("p: " + p);
        System.out.println("p: " + df.format(p));
        System.out.println("p: " + Math.round(p));
    }

    public double getAverageIntensityDifference() {
        return this.averageIntensityDifference;
    }

    public double getLogTPvalue() {
        return this.logTPvalue;
    }

    public int getNumberTreatmentsControls() {
        return this.numTreatments + this.numControls;
    }
}

