/*
 * Decompiled with CFR 0.152.
 */
package Lmeasure.stat;

import Lmeasure.stat.Alignment;
import Lmeasure.stat.WilcoxonSamplePair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class WilcoxonSignedRankTest {
    private WilcoxonSamplePair[] wsps;
    private HashMap ZPMap;
    private float WPlus;
    private float WMinus;
    private float W;
    private int numberWPlusRanks;
    private int numberWMinusRanks;
    private int N;
    private float Zw;
    private float Zs;
    private float averageIntensityDifference;
    private String transformedPValueString;
    private float transformedPValueFloat = 0.0f;

    public WilcoxonSignedRankTest(float[] treatment, float[] control, HashMap ZPMap) {
        this.ZPMap = ZPMap;
        this.test(treatment, control);
    }

    public float test(float[] treatment, float[] control) {
        this.createSamplePairs(treatment, control, true);
        this.calcAveIntDiff();
        Arrays.sort(this.wsps);
        this.rankSamplePairs();
        this.calculateSignedRankStatistics();
        this.calculateTestStatisticZw();
        this.transformedPValueFloat = this.N >= 10 ? Alignment.fetchTransformedPValueFloat(this.Zw, this.ZPMap) : (float)WilcoxonSignedRankTest.calcSmallSample10Log10PValue(this.Zw, this.N);
        return this.transformedPValueFloat;
    }

    public WilcoxonSignedRankTest() {
    }

    public void calcAveIntDiff() {
        float total = 0.0f;
        int num = this.wsps.length;
        int i = num - 1;
        while (i >= 0) {
            total += this.wsps[i].difference;
            --i;
        }
        this.averageIntensityDifference = total / (float)num;
    }

    public void calculateTestStatisticZw() {
        float N = this.numberWPlusRanks + this.numberWMinusRanks;
        float sd = (float)Math.sqrt(N * (N + 1.0f) * (2.0f * N + 1.0f) / 6.0f);
        this.Zw = (this.W - 0.5f) / sd;
    }

    public void calculateSignedRankStatistics() {
        this.numberWPlusRanks = 0;
        this.numberWMinusRanks = 0;
        this.WPlus = 0.0f;
        this.WMinus = 0.0f;
        int i = this.wsps.length - 1;
        while (i >= 0) {
            if (this.wsps[i].difference > 0.0f) {
                this.WPlus += this.wsps[i].rank;
                ++this.numberWPlusRanks;
            } else if (this.wsps[i].difference < 0.0f) {
                ++this.numberWMinusRanks;
                this.WMinus -= this.wsps[i].rank;
            }
            --i;
        }
        this.W = this.WPlus + this.WMinus;
        this.N = this.numberWPlusRanks + this.numberWMinusRanks;
    }

    public void rankSamplePairs() {
        int num = this.wsps.length;
        int i = 0;
        while (i < num) {
            this.wsps[i].rank = i + 1;
            ++i;
        }
        int i2 = 0;
        while (i2 < num) {
            int start = i2;
            int end = i2;
            while (++end < num && this.wsps[start].absoluteDifference == this.wsps[end].absoluteDifference) {
            }
            if (end - start != 1) {
                float ave = WilcoxonSignedRankTest.getAverageInts((int)this.wsps[start].rank, (int)this.wsps[end - 1].rank);
                int x = start;
                while (x < end) {
                    this.wsps[x].rank = ave;
                    ++x;
                }
                i2 = end - 1;
            }
            ++i2;
        }
    }

    public static float getAverageInts(int start, int end) {
        int endOne = end + 1;
        int len = endOne - start;
        int sum = 0;
        int i = start;
        while (i < endOne) {
            sum += i;
            ++i;
        }
        return (float)sum / (float)len;
    }

    public void createSamplePairs(float[] treatment, float[] control, boolean noZeros) {
        int len = treatment.length;
        if (noZeros) {
            ArrayList<WilcoxonSamplePair> al = new ArrayList<WilcoxonSamplePair>(len);
            int i = len - 1;
            while (i >= 0) {
                WilcoxonSamplePair sp = new WilcoxonSamplePair(treatment[i], control[i]);
                if (sp.difference != 0.0f) {
                    al.add(sp);
                }
                --i;
            }
            this.wsps = new WilcoxonSamplePair[al.size()];
            al.toArray(this.wsps);
        } else {
            this.wsps = new WilcoxonSamplePair[len];
            int i = len - 1;
            while (i >= 0) {
                this.wsps[i] = new WilcoxonSamplePair(treatment[i], control[i]);
                --i;
            }
        }
    }

    public static float[] signedDifference(float[] scores, float median) {
        int len = scores.length;
        float[] sd = new float[len];
        int i = len - 1;
        while (i >= 0) {
            sd[i] = scores[i] - median;
            --i;
        }
        return sd;
    }

    public static double calcSmallSample10Log10PValue(float W, int N) {
        if (N == 5) {
            if (W >= 15.0f) {
                return Alignment.transform10Log10(0.05);
            }
            return 0.0;
        }
        if (N == 6) {
            if (W < 17.0f) {
                return 0.0;
            }
            if (W >= 17.0f && W < 21.0f) {
                return Alignment.transform10Log10(0.05);
            }
            return Alignment.transform10Log10(0.025);
        }
        if (N == 7) {
            if (W < 22.0f) {
                return 0.0;
            }
            if (W >= 22.0f && W < 24.0f) {
                return Alignment.transform10Log10(0.05);
            }
            if (W >= 24.0f && W < 28.0f) {
                return Alignment.transform10Log10(0.025);
            }
            return Alignment.transform10Log10(0.01);
        }
        if (N == 8) {
            if (W < 26.0f) {
                return 0.0;
            }
            if (W >= 26.0f && W < 30.0f) {
                return Alignment.transform10Log10(0.05);
            }
            if (W >= 30.0f && W < 34.0f) {
                return Alignment.transform10Log10(0.025);
            }
            if (W >= 34.0f && W < 36.0f) {
                return Alignment.transform10Log10(0.01);
            }
            return Alignment.transform10Log10(0.005);
        }
        if (N == 9) {
            if (W < 29.0f) {
                return 0.0;
            }
            if (W >= 29.0f && W < 35.0f) {
                return Alignment.transform10Log10(0.05);
            }
            if (W >= 35.0f && W < 39.0f) {
                return Alignment.transform10Log10(0.025);
            }
            if (W >= 39.0f && W < 43.0f) {
                return Alignment.transform10Log10(0.01);
            }
            if (W >= 43.0f && W < 50.0f) {
                return Alignment.transform10Log10(0.005);
            }
            return Alignment.transform10Log10(0.0025);
        }
        return 0.0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int num = this.wsps.length;
        int i = 0;
        while (i < num) {
            sb.append(this.wsps[i].toString());
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    public WilcoxonSamplePair[] getWsps() {
        return this.wsps;
    }

    public void setWsps(WilcoxonSamplePair[] pairs) {
        this.wsps = pairs;
    }

    public float getZw() {
        return this.Zw;
    }

    public int getNumberWMinusRanks() {
        return this.numberWMinusRanks;
    }

    public int getNumberWPlusRanks() {
        return this.numberWPlusRanks;
    }

    public float getW() {
        return this.W;
    }

    public float getWMinus() {
        return this.WMinus;
    }

    public float getWPlus() {
        return this.WPlus;
    }

    public float getTransformedPValueFloat() {
        return this.transformedPValueFloat;
    }

    public String getTransformedPValueString() {
        return this.transformedPValueString;
    }

    public void calculateTestStatisticZs() {
        ArrayList<WilcoxonSamplePair> n = new ArrayList<WilcoxonSamplePair>();
        int i = this.wsps.length - 1;
        while (i >= 0) {
            if (this.wsps[i].difference != 0.0f) {
                n.add(this.wsps[i]);
            }
            --i;
        }
        float num = n.size();
        float meanS = num * (num + 1.0f) / 4.0f;
        float sd = 0.0f;
        float holder = 0.0f;
        float sum = 0.0f;
        int i2 = this.wsps.length - 1;
        while (i2 >= 0) {
            holder = ((WilcoxonSamplePair)n.get((int)i2)).rank;
            holder *= holder;
            sum += holder;
            --i2;
        }
        sd = (float)Math.sqrt((double)sum / 4.0);
        this.Zs = (this.WPlus - meanS) / sd;
    }

    public static void main(String[] args) {
        System.out.println("\n\nUncomment the main method to get this to run.\n");
        WilcoxonSignedRankTest test = new WilcoxonSignedRankTest();
        float[] t = new float[]{97.0f, 88.0f, 75.0f, 90.0f, 85.0f, 94.0f, 77.0f, 89.0f, 82.0f, 90.0f};
        float[] c = new float[]{96.0f, 86.0f, 79.0f, 89.0f, 91.0f, 89.0f, 86.0f, 99.0f, 94.0f, 96.0f};
        test.createSamplePairs(t, c, true);
        System.out.println(test + "\n\n");
        Arrays.sort(test.wsps);
        System.out.println(test + "\n\n");
        test.rankSamplePairs();
        System.out.println(test + "\n\n");
        test.calculateSignedRankStatistics();
        test.calculateTestStatisticZs();
        System.out.println("Zs: " + Alignment.roundFloat(test.getZs()));
        test.calculateTestStatisticZw();
        System.out.println("Zw: " + Alignment.roundFloat(test.getZw()));
        System.out.println("WPluse " + test.WPlus);
        System.out.println("WMinus " + test.WMinus);
        System.out.println("WCombine " + (test.WPlus + test.WMinus));
        System.out.println("N: " + test.getN());
        HashMap ZPMap = Alignment.fetchZScorePValueHashMap();
        test.setZPMap(ZPMap);
        System.out.println("TransPValue(Zw) " + Alignment.fetchTransformedPValueString(test.Zw, ZPMap));
        System.out.println("TransPValue(Zs) " + Alignment.fetchTransformedPValueString(test.Zs, ZPMap));
    }

    public void setZPMap(HashMap map) {
        this.ZPMap = map;
    }

    public int getN() {
        return this.N;
    }

    public float getZs() {
        return this.Zs;
    }

    public float getAverageIntensityDifference() {
        return this.averageIntensityDifference;
    }
}

